setwd("~/Research/APA/FiguresRelated/GeneExpressionVsPDUI")
x <- read.table("ProteinCodingHitsPPP2R2DLongVersion.txt",header=TRUE, sep = "\t")
x$Colour="#D3D3D390"
# Set new column values to appropriate colours
x$Colour[x$Expression>=0.6]="#FF000090"
x$Colour[x$Expression<=-0.6]="#0000FF90"
#x$Colour[x$Expression==1.357934348]="green"
#x$Colour[x$Expression==-2.255987053]="green"
F <-plot (x$Expression~x$PDUI,ann=FALSE,xlim=c(-0.7,0.7), bg=x$Colour, col=x$Colour, pch =21, ylim=c(-4,4),cex.axis=1.5 )
title(xlab="Change in PDUI (Tumor-Normal)",ylab="Expression:log2(Tumor/Normal)",line=2.3,cex=1.5,cex.lab=1.3)
legend("topright", c("Overexpressed", "Underexpressed"), pt.bg=c("#FF000090","#0000FF90"), pch=c(21,21), cex=1)
abline(v=0)
