## 8/2/2018 KHE
## notes for Swati V's project.

setwd("/mnt/lustre/users/svenkat/Research/Final_Figures/Figure1A-B")
#PDUI all 2573 genes
PDUIPVal<-read.csv("2573PDUI-Pval.csv",row.names=1)


## Figure 1 notes
pdf("2018-1205-fig1-pduipaad.pdf",width=13,height=5.7)
  par(mfrow=c(1,2))
  par(cex.lab=1.3,cex.axis=1.5)
  par(mar=c(5,5,3,3))

  col0<-rep("#00000022",nrow(PDUIPVal))
  col0[(abs(PDUIPVal[,4])>=0.1)&(PDUIPVal[,3]>PDUIPVal[,2])]<-"#FF000090"
  col0[(abs(PDUIPVal[,4])>=0.1)&(PDUIPVal[,3]<PDUIPVal[,2])]<-"#0000FF90"
  pch0<-rep(21,nrow(PDUIPVal))
  
    
  par(pty="s")
    plot(PDUIPVal[,3:2],bg=col0,pch=pch0,col=NA,cex=1.5,axes=FALSE,xlab="",ylab="")
    title(xlab="PDUI Normal",ylab="PDUI Tumor",line= 2.3,cex.lab= 1.3)
    title(main="",line= 0.5)
    box();axis(1,at=c(0,.5,1));axis(2,at=c(0,.5,1))
    legend("topleft", c("Lengthened", "Shortened"), pt.bg=c("#0000FF90","#FF000090"), pch=c(21,21), cex=1)
    abline(c(.1,1),lty=2,lwd=2)
    abline(c(-.1,1),lty=2,lwd=2)
 
  par(pty="m")
    plot((PDUIPVal[,4]),-log10(PDUIPVal[,5]),xlim=c(-.6,.6),ylim=c(0,100), xlab="",ylab="",col=NA,pch=pch0,bg=col0,cex=1.5)
    title(xlab="Change in PDUI (Tumor-Normal)",ylab="p-value (BH, -log10)",line= 2.3,cex.lab= 1.3)
    abline(v=0.1*c(-1,1),lty=2,lwd=2)
    #########################
    
    
    #cutoff at 0.1 
    #abline(v=0.1*c(-1,1),lty=2,lwd=2)
    
    axis(3,at=c(.55),line=-0.5,label=c("Lengthened"),hadj=1,tick=FALSE)
    axis(3,at=c(-.55),line=-0.5, label=c("Shortened"),hadj=0,tick=FALSE)
dev.off()


##############
##############
##############



