% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization_SHARP.R
\name{visualization_SHARP}
\alias{visualization_SHARP}
\title{SHARP visualization}
\usage{
visualization_SHARP(y, label, w, filename, filetype, n.cores,
  legendtitle = "Cell Type", width = 9.5, height = 8.5, res = 400,
  ...)
}
\arguments{
\item{y}{the results after running the SHARP function}

\item{label}{the reference (or pre-defined) clustering label for the data; if not given, the resulting plot will be drawn in black/white color.}

\item{w}{the relative weight of clustering-result based matrix over ensemble random-projection based matrix; by default, w = 2.}

\item{filename}{the name of the file to which the output figure will be saved; if not given, the output figure will be saved in "vi_SHARP.pdf"}

\item{filetype}{the type of the output file. Suggested file types are PDF or PNG, while other common types (e.g., JPEG or TIFF) are also acceptable. If not given, the type will be determined as follows: when the number of single cells is less than 5000, the type will be PDF; otherwise, it will be PNG.}

\item{width/height}{the width/height of the outpuf figure.}
}
\description{
This function is to visualize the data in 2D scatter plots. For visualization, SHARP uses a weighted combination of the dimension-reduced feature matrix and the output location matrix produced by the clustering results of SHARP. The output scatter plot will be saved in a figure file (by default, the file is named as "vi_SHARP.pdf" or "vi_SHARP.png")
}
\examples{
y = SHARP(scExp)
visualization_SHARP(y)

}
