% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_Mtimes_SHARP.R
\name{run_Mtimes_SHARP}
\alias{run_Mtimes_SHARP}
\title{Run multiple-times SHARP for single-cell RNA data clustering}
\usage{
run_Mtimes_SHARP(scExp, Mtimes = 10, Kset = 15, ...)
}
\arguments{
\item{scExp}{input single-cell expression matrix}

\item{Mtimes}{number of times to run SHARP. By default, 10 times will be tried}

\item{Kset}{a set of ensemble sizes (ensize.K) to be tried. By default, only one element (i.e., ensize.K = 15) will be tried}

\item{...}{other parameters of SHARP that have not been listed here}
}
\description{
This function is to run multiple times of SHARP for evaluating SHARP in clustering of single-cell RNA-Seq data
}
\examples{
enresults = run_Mtimes_SHARP(scExp, Mtimes = 10, Kset = 5, partition.ncells = 2000, n.cores = 1)

}
