% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_markers.R
\name{plot_markers}
\alias{plot_markers}
\title{Plot marker genes}
\usage{
plot_markers(sginfo, label, N.marker, sN.cluster, filename, filetype,
  nratio, n.cores, width = 900, height = 900, ...)
}
\arguments{
\item{sginfo}{the info matrix of selected marker genes, including their correspnding cluster, p-value and AUROC (areas under the curve of the Receiver Operating Characteristic) value.}

\item{label}{the clustering labels, either using ground-truth labels or predicted clustering results.}

\item{N.marker}{the maximum number of marker genes selected for each cluster. The default value is 10.}

\item{filename}{the output file name to save the heatmap figure. By default ,the filename is "markers_heatmap.pdf".}

\item{filetype}{the type of the output file. Suggested file types are PDF or PNG, while other common types (e.g., JPEG or TIFF) are also acceptable. If not given, the type will be determined as follows: when the number of single cells is less than 5000, the type will be PDF; otherwise, it will be PNG.}

\item{scExp}{the original expression matrix}
}
\value{
The heatmap of cell-type-specific marker gene expression will be saved into a file (by default the file will be named as "markers_heatmap.pdf" or "markers_heatmap.png", depending on the number of cells). Besides, all of the cluser-specific marker genes and their associated information will be returned.
}
\description{
This function is to plot a heatmap showing the cluster-specific marker genes. Only the top 10 marker genes for each cluster are shown.
}
\examples{

y = SHARP(scExp)
sginfo = get_marker_genes(scExp, y)
sortmarker = plot_markers(sginfo)

}
