% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_marker_genes_unlimited2.R
\name{get_marker_genes_unlimited2}
\alias{get_marker_genes_unlimited2}
\title{Get marker genes of each cluster for huge-size single-cell datasets}
\usage{
get_marker_genes_unlimited2(gdinfo, y, theta, auc, pvalue, n.cores)
}
\arguments{
\item{y}{the clustering results after running SHARP.R}

\item{n.cores}{number of cores to be used. The default is (n-1) cores, where n is the number of cores in your local computer or server.}

\item{scExp}{the list of original block-wise expression matrices}
}
\value{
a matrix where each row represents each selected marker gene and each column represnts one property of the gene, including its cluster, p-value and AUROC.
}
\description{
This is an version of finding marker genes for huge-size single-cell datasets (e.g., the size of the scRNA-seq data is so huge that the expression matrix can not be read into R; instead, a list of block-wise expression matrices is read into R.) This also corresponds to SHARP_unlimited(). Detailed specifications can be found in get_marker_genes().
}
\examples{

y = SHARP_unlimited(scExp)
sginfo = get_marker_genes_unlimited2(scExp, y)

}
