% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_marker_genes.R
\name{get_marker_genes}
\alias{get_marker_genes}
\title{Get marker genes for each cluster}
\usage{
get_marker_genes(scExp, y, theta, auc, pvalue, FC, ng, n.cores)
}
\arguments{
\item{scExp}{the original expression matrix}

\item{y}{the clustering results after running SHARP.R}

\item{n.cores}{number of cores to be used. The default is (n-1) cores, where n is the number of cores in your local computer or server.}
}
\value{
a matrix where each row represents each selected marker gene and each column represnts one property of the gene, including its cluster, p-value and AUROC.
}
\description{
This is to identify marker genes for each cluster after SHARP clustering. It uses a method similar to that proposed in the SC3 package except two improvements: (1) it uses an adjusted threshold to select marker genes instead of using a hardthreshod (i.e., p-value < 0.01 and AUROC > 0.85), so that marker genes can be found for all clusters; (2) it uses a parallelization way to calculate the p-value and AUROC (areas under the curve of the Receiver Operating Characteristic) for each gene, thus much faster than SC3.
}
\examples{

y = SHARP(scExp)
sginfo = get_marker_genes(scExp, y)

}
