% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHARP.R
\name{SHARP_large}
\alias{SHARP_large}
\title{Run SHARP for large-size (by default, >= 5000) single-cell RNA datasets}
\usage{
SHARP_large(scExp, ncells, ensize.K, reduced.dim, partition.ncells,
  hmethod, N.cluster, enpN.cluster, indN.cluster, minN.cluster,
  maxN.cluster, sil.thre, height.Ntimes, flashmark, flag, n.cores, forview,
  rM, rN.seed)
}
\arguments{
\item{scExp}{input single-cell expression matrix}

\item{ncells}{number of single cells}

\item{ensize.K}{number of applications of random projection for ensemble}

\item{reduced.dim}{the dimension to be reduced to}

\item{partition.ncells}{number of cells for each partition when using SHARP_large}
}
\description{
For large-size (>= 5000) datasets, we suggest first partitioning the datasets into several groups, then we run SHARP for each group, and finally and we ensemble the results of each group by a similarity-based meta-clustering algorithm.
}
\details{
For each partition (or group), the default number of cells is set to 2000 for each group. The users can also set a different number according to the computational capability of their own local computers. The suggested criteria to set this number is that as long as SHARP_small can run in a fast enough (depending on users' requirements) way for the selected number of single cells.
}
\examples{
enresults = SHARP_large(scExp, ncells, ensize.K, reduced.dim, partition.ncells)

}
