% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHARP.R
\name{SHARP}
\alias{SHARP}
\title{Run SHARP for single-cell RNA data clustering}
\usage{
SHARP(scExp, exp.type, ensize.K, reduced.ndim, base.ncells,
  partition.ncells, hmethod, N.cluster = NULL, enpN.cluster = NULL,
  indN.cluster = NULL, minN.cluster, maxN.cluster, sil.thre,
  height.Ntimes, flashmark = FALSE, logflag, sncells, n.cores,
  forview = TRUE, prep, rM, rN.seed)
}
\arguments{
\item{scExp}{input single-cell expression matrix, where each column represents a cell and each row represents a gene.}

\item{exp.type}{the data type of single-cell expression matrix. Common types include 'count', 'UMI', 'CPM', 'TPM', 'FPRKM' and 'RPKM'. If missing, SHARP regards scExp as already normalized expression matrix.}

\item{ensize.K}{number of applications of random projection for ensemble. The default value is 15.}

\item{reduced.ndim}{the dimension to be reduced to. If missing, the value will be estimated by an equation associated with number of cells (see our paper and supplementary materials for details).}

\item{base.ncells}{a base threshold of number of cells. The default value is 5000. When the number of cells of a dataset is smaller than this threshold, we use SHARP_small function; otherwise, we use SHARP_large.}

\item{partition.ncells}{number of cells for each partition when using SHARP_large. The default value is 2000.}

\item{N.cluster}{number of clusters for the final clustering results. The default is NULL, i.e., without giving the number of clusters, and SHARP will automatically determine the optimal number of clusters. If given, SHARP will calculate according to the given number of clusters.}

\item{enpN.cluster}{number of clusters for the weighted ensemble meta-clustering only for SHARP_large. The default is NULL, i.e., without giving the number of clusters, and SHARP will automatically determine the optimal number of clusters. If given, SHARP will calculate according to the given number of clusters.}

\item{indN.cluster}{number of clusters for the individual RP-based hierarchical clustering. The default is NULL, i.e., without giving the number of clusters, and SHARP will automatically determine the optimal number of clusters. If given, SHARP will calculate according to the given number of clusters.}

\item{minN.cluster}{the minimum number of clusters that SHARP will try when determining the optimal number of clusters}

\item{maxN.cluster}{the maximum number of clusters that SHARP will try when determining the optimal number of clusters}

\item{sil.thre}{the threshold of Silhouette index that SHARP will use the Silhouette index to determine the optimal number of clusters. In other words, if the maximum Silhouette index is larger than sil.thre, then SHARP uses the Silhouette index to determine the number of clusters; otherwise, SHARP uses the other indices (i.e., CH index and/or hierarchical heights) to determine}

\item{height.Ntimes}{the number of times of the height versus the immediate next height in the hierarchical clustering. SHARP uses this parameter as a threshold to determine the location where to cut the hierarchical tree. In other words, if the current height is (height.Ntimes) times larger than the immediate next height in the descending order of heights, then SHARP cuts the tree at the median of these two heights.}

\item{flashmark}{a logical to determine whether flashClust is used. By default, flashmark = FALSE, i.e., traditional hclust is used.}

\item{logflag}{a logical to determine whether to check a log-transform of the input expression matrix. By default, logflag = TRUE, i.e., SHARP will check the log-transform operation.}

\item{sncells}{number of cells randomly selected for checking log-transform is necessary or not. By default, sncells = 100.}

\item{n.cores}{number of cores to be used. The default is (n-1) cores, where n is the number of cores in your local computer or server.}

\item{forview}{a logical to indicate whether those feature-vectors for data visualization should be saved or not. By default, it is TRUE.}

\item{prep}{a logical to determine whether preprocessing (e.g., removing all-zero rows and replace negative value with 0) is employed or not. By default, prep = TRUE only when the number of single cells is smaller than 10,000.}

\item{rM}{if provided, it should be a list of random matrices for random projection; otherwise, it will be calculated by SHARP_large.}

\item{rN.seed}{a number using which we can set seeds for SHARP to obtain reproducible results.}
}
\value{
a list containing the SHARP clustering results, distribution of the clustering results, the predicted optimal number of clusters, time SHARP consumes for clustering, some intermediate results including clustering results by each random-projection based hierarchical clustering and other related statstical information including number of cells, genes, reduced dimensions and number of applications of random projection.
}
\description{
SHARP: Single-cell RNA-Seq Hyper-fast and Accurate clustering via ensemble Random Projection.
}
\details{
This is the main interface for SHARP to process and analyze different kinds of single-cell RNA-Seq data. Only one parameter is manadatory, i.e., scExp, the single-cell expression matrix. In most cases, most of the parameters can be determined automatically or have been optimized, so users don't have to take efforts to try different parameters. While for some other cases where users need to change parameters, SHARP also provides various parameters, including algorithm-related parameters, hierarchical-clustering-related parameters, parallel-computing parameters and parameters to obtain reproducible results, for better optimizing the performance.
}
\examples{
enresults = SHARP(scExp)

}
\author{
Shibiao Wan <shibiao@pennmedicine.upenn.edu>
}
