#!/usr/bin/env python3
# Name: Bryan Thornlow
# Date: 7/31/2017
# messerBootstrap.py

import sys
import os
import time
import random
import numpy
import gzip
import math

#########################
##### MAIN FUNCTION #####
#########################

def reformatOrthologTable():
    myOutString = ''

    converter = {}
    converter['Ananc2'] = 'Aotus_nancymaae'
    converter['Btaur8'] = 'Bos_taurus'
    converter['Casia1'] = 'Chrysochloris_asiatica'
    converter['Cfami3'] = 'Canis_lupus_familiaris'
    converter['Chirc1'] = 'Capra_hircus'
    converter['Clani1'] = 'Chinchilla_lanigera'
    converter['Cporc3'] = 'Cavia_porcellus'
    converter['Dnove3'] = 'Dasypus_novemcinctus'
    converter['Ecaba2'] = 'Equus_caballus'
    converter['Eeuro2'] = 'Erinaceus_europaeus'
    converter['Efusc1'] = 'Eptesicus_fuscus'
    converter['Ggori5'] = 'Gorilla_gorilla'
    converter['Hglab2'] = 'Heterocephalus_glaber'
    converter['Hsapi38'] = 'Homo_sapiens'
    converter['Jjacu1'] = 'Jaculus_jaculus'
    converter['Mmarm2'] = 'Marmota_marmota'
    converter['Mmula8'] = 'Macaca_mulatta'
    converter['Mmuri3'] = 'Microcebus_murinus'
    converter['Mmusc10'] = 'Mus_musculus'
    converter['Mochr1'] = 'Microtus_ochrogaster'
    converter['Mputo1'] = 'Mustela_putorius'
    converter['Ocuni2'] = 'Oryctolagus_cuniculus'
    converter['Odegu1'] = 'Octodon_degus'
    converter['Oorca1'] = 'Orcinus_orca'
    converter['Palec1'] = 'Pteropus_alecto'
    converter['Ppygm3'] = 'Pongo_abelii'
    converter['Ptrog5'] = 'Pan_troglodytes'
    converter['Rnorv6'] = 'Rattus_norvegicus'
    converter['Sscro11'] = 'Sus_scrofa'

    for line in open('FINAL_ORTHOLOG_SET.txt'):
        splitLine = (line.strip()).split('\t')
        if splitLine[0] == 'Ananc2':
            tRNAToCoords = {}
            myHeader = splitLine
            for k in splitLine:
                for line in open(k.upper()+'/tRNAHiConf.bed'):
                    splitLine = (line.strip()).split('\t')
                    tRNAToCoords[k+'-'+splitLine[3]] = splitLine[0]+':'+str(splitLine[1])+'-'+str(splitLine[2])

            newFirst = []
            for k in myHeader:
                newFirst.append(converter[k])
            myOutString += joiner(newFirst)+'\n'
        else:
            for i in range(0,len(splitLine)):
                if not splitLine[i] == 'N/A':
                    if splitLine[i] in tRNAToCoords:
                        splitLine[i] = tRNAToCoords[splitLine[i]]
                    else:
                        print(splitLine[i])
            myOutString += joiner(splitLine)+'\n'
    open('reformattedOrthologTable.txt','w').write(myOutString)





def joiner(entry):
    """
    Helper function to print lists in 
    tab separated format.
    """
    newList = []
    for k in entry:
        newList.append(str(k))
    return '\t'.join(newList)


def main():
    reformatOrthologTable()

if __name__ == "__main__":
    """
    Calls main when program is run by user.
    """
    main();
    raise SystemExit

