#!/usr/bin/env python3
# Name: Bryan Thornlow
# Date: 4/10/2018
# separateCMFiles.py

import sys
import os
import time
import random
import numpy
import gzip
import math

##########################
##### MAIN FUNCTIONS #####
##########################

def getHumanMouseAgreement():
    tRNAToActivity = {}
    for line in open('/public/groups/corbettlab/tRNA/classifier/JOEL/FINAL_TEST_RUN/MMUSC10/mouseActivityInput.txt'):
        splitLine = (line.strip()).split('\t')
        tRNAToActivity['Mmusc10-'+splitLine[0]] = splitLine[1]

    for line in open('/public/groups/corbettlab/tRNA/classifier/JOEL/Hsapi38/finalActivityHg19Hg38.txt'):
        splitLine = (line.strip()).split('\t')
        tRNAToActivity['Hsapi38-'+splitLine[0]] = splitLine[3]

    tRNAToPrediction = {}
    for line in open('/public/groups/corbettlab/tRNA/classifier/JOEL/FINAL_TEST_RUN/MMUSC10/Mmusc10tRNAClassificationsNewFixedNoSegDups.txt'):
        splitLine = (line.strip()).split('\t')
        tRNAToPrediction['Mmusc10-'+splitLine[0]] = splitLine[2]

    for line in open('/public/groups/corbettlab/tRNA/classifier/JOEL/FINAL_TEST_RUN/HSAPI38/Hsapi38tRNAClassificationsNewFixedNoSegDups.txt'):
        splitLine = (line.strip()).split('\t')
        tRNAToPrediction['Hsapi38-'+splitLine[0]] = splitLine[2]

    humanActivityMouseActivity = 0
    humanActivityHumanPrediction = 0
    mouseActivityMousePrediction = 0


    count = 0
    humanMismatch = 0
    mouseMismatch = 0
    for line in open('FINAL_ORTHOLOG_SET.txt'):
        splitLine = (line.strip()).split('\t')
        if (splitLine[13] in tRNAToActivity and splitLine[13] in tRNAToPrediction) and (splitLine[18] in tRNAToActivity and splitLine[18] in tRNAToPrediction):
            count += 1
            if tRNAToActivity[splitLine[13]] == tRNAToActivity[splitLine[18]]:
                humanActivityMouseActivity += 1
            if tRNAToActivity[splitLine[13]] == tRNAToPrediction[splitLine[13]]:
                humanActivityHumanPrediction += 1
            if tRNAToActivity[splitLine[18]] == tRNAToPrediction[splitLine[18]]:
                mouseActivityMousePrediction += 1
            if tRNAToActivity[splitLine[13]] == tRNAToPrediction[splitLine[13]] and tRNAToActivity[splitLine[13]] != tRNAToActivity[splitLine[18]]:
                humanMismatch += 1
            if tRNAToActivity[splitLine[18]] == tRNAToPrediction[splitLine[18]] and tRNAToActivity[splitLine[13]] != tRNAToActivity[splitLine[18]]:
                mouseMismatch += 1

    print(count)
    print(humanActivityMouseActivity)
    print(humanActivityHumanPrediction)
    print(mouseActivityMousePrediction)
    print(humanMismatch, mouseMismatch)



def joiner(entry):
    newList = []
    for k in entry:
        newList.append(str(k))
    return '\t'.join(newList)

def main():
    getHumanMouseAgreement()
    
if __name__ == "__main__":
    """
    Calls main when program is run by user.
    """
    main();
    raise SystemExit

