#!/usr/bin/env python3
# Name: Bryan Thornlow
# Date: 11/29/2018
# getPrimateSet.py

import sys
import os
import time
import random
import numpy
import gzip
import math

##########################
##### MAIN FUNCTIONS #####
##########################

def getCoreSets():
    mySpecies = ['Ananc2','Btaur8','Casia1','Cfami3','Chirc1','Clani1','Cporc3','Dnove3','Ecaba2','Eeuro2']
    mySpecies += ['Efusc1','Ggori5','Hglab2','Hsapi38','Jjacu1','Mmarm2','Mmula8','Mmuri3','Mmusc10','Mochr1']
    mySpecies += ['Mputo1','Ocuni2','Odegu1','Oorca1','Palec1','Ppygm3','Ptrog5','Rnorv6','Sscro11']

    # 1) core, unique to primates: those found in all primates (and only primates)
    # allow for a 1 or 2 non-primates to account for errors in alignments

    # 2) unique to some primates+human: those found in human and at least two other primates, but no other mammals

    # 3) core primate set: those found in all primates (but they can occur in other non-primates)

    primates5 = ['Hsapi38','Ptrog5','Ggori5','Ppygm3','Mmula8']
    myPrimate5Indices = []
    for k in primates5:
        myPrimate5Indices.append(mySpecies.index(k))

    primates7 = ['Hsapi38','Ptrog5','Ggori5','Ppygm3','Mmula8','Ananc2','Mmuri3']
    myPrimate7Indices = []
    for k in primates7:
        myPrimate7Indices.append(mySpecies.index(k))

    myOutString15 = joiner(primates5)+'\n'
    myOutString17 = joiner(primates7)+'\n'
    myOutString2 = ''
    myOutString35 = joiner(primates5)+'\n'
    myOutString37 = joiner(primates7)+'\n'
    denom2 = 0
    for line in open('FINAL_ORTHOLOG_SET.txt'):
        splitLine = (line.strip()).split('\t')
        if not splitLine[0] == 'Ananc2':

            myIndices = getIndices(splitLine)
            if len(myIndices) <= 7:
                if checkIndices1(splitLine,myPrimate5Indices):
                    myOutString15 += joiner(reorder(splitLine,[13,26,11,25,16]))+'\n'
            if len(myIndices) <= 9:
                if checkIndices1(splitLine,myPrimate7Indices):
                    myOutString17 += joiner(reorder(splitLine,[13,26,11,25,16,0,17]))+'\n'

            if len(myIndices) >= 3 and splitLine[13] != 'N/A':
                if checkIndices2Alt(splitLine,myPrimate7Indices):
                    denom2 += 1
                if checkIndices2(splitLine,myPrimate7Indices):
                    myOutString2 += joiner(reorder(splitLine,[13,26,11,25,16,0,17]))+'\n'

            if len(myIndices) >= 5:
                if checkIndices3(splitLine,myPrimate5Indices):
                    myOutString35 += joiner(reorder(splitLine,[13,26,11,25,16]))+'\n'

            if len(myIndices) >= 7:
                if checkIndices3(splitLine,myPrimate7Indices):
                    myOutString37 += joiner(reorder(splitLine,[13,26,11,25,16,0,17]))+'\n'

    open('out15.txt', 'w').write(myOutString15)
    open('out17.txt', 'w').write(myOutString17)
    open('out2.txt', 'w').write(myOutString2)
    open('out35.txt', 'w').write(myOutString35)
    open('out37.txt', 'w').write(myOutString37)
    print(denom2)


def getIndices(myList):
    myReturn = []
    for i in range(0,len(myList)):
        if not myList[i] == 'N/A':
            myReturn.append(i)
    return(myReturn)

def reorder(myList, myOrder):
    myReturn = []
    for k in myOrder:
        if myList[k] != 'N/A':
            myReturn.append(myList[k])
    for k in myList:
        if k != 'N/A' and not k in myReturn:
            myReturn.append(k)
    return(myReturn)

def joiner(entry):
    newList = []
    for k in entry:
        newList.append(str(k))
    return '\t'.join(newList)

def checkIndices1(myList,myCheck):
    myMisses = 0
    for i in range(0,len(myList)):
        if myList[i] != 'N/A' and i not in myCheck:
            myMisses += 1
    for k in myCheck:
        if myList[k] == 'N/A':
            return(False)
    if myMisses > 2:
        return(False)
    else:
        return(True)

def checkIndices2(myList,myCheck):
    for i in range(0,len(myList)):
        if myList[i] != 'N/A' and i not in myCheck:
            return(False)
    return(True)

def checkIndices2Alt(myList,myCheck):
    myPrimates = 0
    for i in myCheck:
        if myList[i] != 'N/A':
            myPrimates += 1
    if myPrimates >= 2:
        return(True)
    else:
        return(False)

def checkIndices3(myList,myCheck):
    for i in myCheck:
        if myList[i] == 'N/A':
            return(False)
    return(True)


def main():
    getCoreSets()

if __name__ == "__main__":
    """
    Calls main when program is run by user.
    """
    main();
    raise SystemExit





