#!/usr/bin/env python3
# Name: Bryan Thornlow
# Date: 4/10/2018
# separateCMFiles.py

import sys
import os
import time
import random
import numpy
import gzip
import math

##########################
##### MAIN FUNCTIONS #####
##########################

def getActivityChanges():
    tRNAToActivity = {}
    for abb in ['Ananc2','Btaur8','Casia1','Cfami3','Chirc1','Clani1','Cporc3','Dnove3','Ecaba2','Eeuro2','Efusc1','Ggori5','Hglab2','Jjacu1','Mmarm2','Mmula8','Mmuri3','Mmusc10','Mochr1','Mputo1','Ocuni2','Odegu1','Oorca1','Palec1','Ppygm3','Ptrog5','Rnorv6','Sscro11']:
        for line in open(abb.upper()+'/'+abb+'tRNAClassificationsNewFixedNoSegDups.txt'):
            splitLine = (line.strip()).split('\t')
            tRNAToActivity[abb+'-'+splitLine[0]] = splitLine[2]

    for line in open('humanCVPredictionsChanged.txt'):
        splitLine = (line.strip()).split('\t')
        tRNAToActivity['Hsapi38-'+splitLine[0]] = splitLine[1]

    changesCount = 0
    inactiveCount = 0
    activeCount = 0
    ACChangesCount = 0
    AAChangesCount = 0
    ACAndActivityCount = 0
    AAAndActivityCount = 0
    ssCount = 0
    allActive = 0
    allInactive = 0
    blockCount = 0
    blockChanges = []
    for line in open('FINAL_ORTHOLOG_SET.txt'):
        splitLine = (line.strip()).split('\t')
        blockCount += 1
        if not splitLine[0] == 'Ananc2':
            myTempList = []
            myTempACList = []
            myTempAAList = []
            if splitLine.count('N/A') == 28:
                ssCount += 1
            else:
                for tRNA in splitLine:
                    if not tRNA == 'N/A' and tRNA in tRNAToActivity:
                        myTempList.append(tRNAToActivity[tRNA])

                    if not tRNA.startswith('Hsapi38') and not tRNA == 'N/A':
                        myTempACList.append(tRNA[-3:])
                    elif tRNA.startswith('Hsapi38'):
                        myTempACList.append(tRNA.split('-')[3])

                    if not tRNA.startswith('Hsapi38') and not tRNA == 'N/A':
                        myTempAAList.append(tRNA.split('-')[-1][:-3])
                    elif tRNA.startswith('Hsapi38'):
                        myTempAAList.append(tRNA.split('-')[2])


                if len(set(myTempACList)) > 1:
                    print(blockCount)
                    ACChangesCount += 1
                    #print(set(myTempACList))
                    if myTempList.count('active') >= 1 and myTempList.count('inactive') >= 1:
                        ACAndActivityCount += 1
                
                if len(set(myTempAAList)) > 1:
                    AAChangesCount += 1
                    if myTempList.count('active') >= 1 and myTempList.count('inactive') >= 1:
                        AAAndActivityCount += 1


                if myTempList.count('active') >= 1 and myTempList.count('inactive') >= 1:
                    if myTempList.count('inactive') > myTempList.count('active'):
                        inactiveCount += 1
                    elif myTempList.count('inactive') < myTempList.count('active'):
                        activeCount += 1
                    #print(myTempList)
                    changesCount += 1
                    blockChanges.append(blockCount)
                    #print(set(myTempAAList))

                elif myTempList.count('inactive') == 0:
                    allActive += 1
                elif myTempList.count('active') == 0:
                    allInactive += 1

    print(ACChangesCount)
    print(AAChangesCount)
    print(changesCount)
    print(activeCount)
    print(inactiveCount)
    print(ACAndActivityCount)
    print(AAAndActivityCount)
    print(ssCount)
    print(allActive)
    print(allInactive)
    print(blockChanges)



def joiner(entry):
    newList = []
    for k in entry:
        newList.append(str(k))
    return '\t'.join(newList)

def main():
    getActivityChanges()
    #getHumanMistakes()
    
if __name__ == "__main__":
    """
    Calls main when program is run by user.
    """
    main();
    raise SystemExit


