#!/usr/bin/perl

use strict;
use warnings;

# code adapted from Nature protocols paper by Ding, Tayor, Reijns 2015
my $shift = 5;	# want position 20-21 from 26 nucleotide read, equivalent to -6/-5 position

#equivalent to 19-21 in 0-based start bed coordinates
while ( my $line = <STDIN> )
{
	my @field = split /\t/, $line;
	if ( $field[0] =~ /chr[0-9a-zA-Z_]+/ )
	{	
		if ( $field[5] =~ /\+/ )
		{
			$field[1] = $field[2] - 2; # set to last two nts of xr-seq read
                	# shift position to -6/-5 position
			$field[1] -= $shift;
			$field[2] -= $shift;
		}
		elsif ( $field[5] =~ /-/ )
		{
			$field[2] = $field[1] + 2; # set to first two nts, since - strand
                        # shift position to -6/-5 position
                        $field[1] += $shift;
                        $field[2] += $shift;
		}
		else
		{
			die "No strand info for field[5]: $field[5] line: $line\n";
		}

		if ( $field[1] >= 0 )
		{
			print join "\t", @field;
		}
	}
	else
	{
		die "Misformatted line: $line\n";
	}
}	
