#!/usr/bin/perl

use strict;
use warnings;

my %lengths = ();
my $min = 23;
my $max = 31;
my $filtered = 0;
while ( my $line = <STDIN> )
{
	chomp $line;
	my @fields = split /\t/, $line;
	my $len = $fields[2] - $fields[1];
	$lengths{$len}++;
	if ( $fields[0] =~ /chr[0-9a-z-A-Z_]+/ )
	{
		if ( $len >= $min && $len <= $max )
		{
			print "$line\n";
		}
		else
		{
			$filtered++;
		}

	}
	else
	{
		die "Misformatted line: $line\n";
	}
}
print STDERR "Filtered lines = $filtered\n";
