#!/usr/bin/perl

use strict;
use warnings;

my %dinuc_count;
while ( my $line = <STDIN> )
{
	chomp $line;
	if ($line =~ /^>/ )
	{
		next;
	}
	my $len = length($line);
	#count from 3' end
	# i is location of 5' end of dinuc - distance from 3' end (i.e., first i is 2 nt from end)
	for ( my $i = 2; $i <= $len; $i++ )
	{
		my $j = $len - $i;
		my $dinuc = substr ( $line, $j, 2 );

		if ( $dinuc =~ /[CT][CT]/ )
		{
			$dinuc_count{$len}{$i}{$dinuc}++;
		}
		else
		{
			$dinuc_count{$len}{$i}{"Other"}++;
		}
	}

}

print "Length of XR-seq fragment\tPosition relative to 3' end\tDinuc Sequence\tFrequency\n";
foreach my $long (sort {$a <=> $b} keys %dinuc_count)
{
	foreach my $pos ( sort {$a <=> $b} keys %{$dinuc_count{$long}} )
	{
		foreach my $di (sort keys %{$dinuc_count{$long}{$pos}} )
		{
			print "$long\t$pos\t$di\t$dinuc_count{$long}{$pos}{$di}\n";
		}
	}
}
