#!/bin/bash

# some code adapted from https://stackoverflow.com/questions/20796200/how-to-iterate-over-files-in-a-directory-with-bash

# process all bed files in the directory
for filename in ${PWD}/*.bam; do
	fname="$(basename "$filename" .bam)"
	bamToBed -i ${filename} >${fname}.bed

	rm ../hg19_puc19.fa.fai
        fastaFromBed -s -name -fi ../hg19_puc19.fa -bed ${fname}.bed -fo ${fname}.fa
        perl count_dinucleotide_pattern.pl <${fname}.fa >${fname}_nupattern.txt

	# keep only reads between 23 and 31 nucleotides
	perl filter_bed_length.pl <${fname}.bed >${fname}_len.bed

	# identify likely lesion containing site
	perl findXRseqcoord.pl <${fname}_len.bed >${fname}_len_cpd.bed

	# sort file
	cat ${fname}_len_cpd.bed | sort -k1,1 -k2,2n >${fname}_len_cpd_sorted.bed

	# split strands
	printf "${fname}_len_cpd_sorted.bed\n" | perl ../split_strands.pl 
done

# rest of processing should be done mannually --> count function of IGV tools, withi window size 1, zoom 10, to generate .wig files
# then run perl set_background.pl >[bkgd set wig file]
