#include <queue>
#include <iostream>
#include <sstream>
#include <fstream>
#include <string>
#include <cstdlib>
#include "NucScore.h"
#include <tr1/unordered_set>
#include <tr1/unordered_map>
#define ASIZE	15

using namespace std;

// code from http://www.technical-recipes.com/2011/priority-queues-and-min-priority-queues-in-c/
struct CompareScore : public std::binary_function<NucScore*, NucScore*, bool>
{
	bool operator()(const NucScore* lhs, const NucScore* rhs ) const
	{
		return lhs->getScore() < rhs->getScore();
	}
};

int main( int argc, char const *argv[])
{
	// code adapted from: https://codeconnect.wordpress.com/2013/09/05/max-min-heap-using-c-stl/
	// and http://www.technical-recipes.com/2011/priority-queues-and-min-priority-queues-in-c/

	long offsets[ASIZE] = {0,1,-1,10,-10,11,-11,9,-9,20,-20,21,-21,19,-19};
	std::tr1::unordered_map<long, long> offcounts;
	
	// ifstream infile("hg18.chrY.nucleosome.score.csv");
	ifstream dnasefile;
	ifstream mnasefile;
	string chr;
	if ( argc > 3 )
	{
		dnasefile.open( argv[1] );
		mnasefile.open( argv[2] );
		chr = argv[3];
	}
	else
	{
		cerr << "Didn't include filename of dnase nucleosome scores, mnase mids, and chromosome number (i.e., chr1) as arguments!" << endl;
		return 0;
	}

	// nucscore priority queue
	priority_queue<NucScore*, vector<NucScore*>, CompareScore > ns;

	// create unordered_set (i.e., hash) to contain all nucleosome positions already taken +- window
	long window = 147;
	std::tr1::unordered_set<long> taken;

	// creade unordered_map of mnase mid counts
        std::tr1::unordered_map<long, double> mnase;
	string str;
	while ( getline(dnasefile, str) )
	{
		stringstream strs(str);
		string data;
                getline( strs, data, ',');
		long a;
		a = atoi( data.c_str() );
		double b;
		strs >> b;
                //cout << "String: " << str << "\tposition: " << a << "\tScore: " << b << endl;
		if ( a > 0 )
			ns.push( new NucScore(a, b) );
	}

        while ( getline(mnasefile, str) )
        {
                stringstream strs(str);
                string data;
                getline( strs, data, ',');
                long a;
                a = atoi( data.c_str() );
                double b;
                strs >> b;
                //cout << "String: " << str << "\tposition: " << a << "\tScore: " << b << endl;
                if ( a > 0 )
                        mnase[a] = b;
        }

	int counter = 0;

	// threshold is minimum NucScore to be reported --> previous paper set at 0
	double threshold = 10.0;

	long skipped = 0;

	while( !ns.empty() )
	{
		NucScore *n = ns.top();
		// check if score is greather than or equal to threshold
		if ( n->getScore() < threshold )
		{
			delete n;
			break;
		}

		long p = n->getPosition();

		// check if position is already taken, if not report position
		if ( taken.find( p ) == taken.end() )
		{ 
			// p is 1-based, so calculate start q as 0-based for bed file format
			if ( p < window )
			{
				cerr << "Error with position: " << p << endl;
				return 0;
			}		

			// find highest MNase read count in offset positions, assign as dyads
			double max = 0;
			long maxpos = -1;
			for ( int i = 0; i < ASIZE; i++ )
			{
				long pos = p + offsets[i]; 

				// code adapted from: https://www.geeksforgeeks.org/unordered_map-in-cpp-stl/
				std::tr1::unordered_map<long, double>:: iterator itr;
				itr = mnase.find(pos);
				if ( itr != mnase.end() )
				{
					double val = itr->second;
					if ( val > max )
					{
						max = val;
						if ( pos != itr->first )
						{
                                			cerr << "Error with position itr " << pos << endl;
                                			return 0;
						}
						maxpos = pos;
					}
				}
			}

			if ( maxpos == -1 )
			{
				taken.insert(p);
				skipped++;
			}
			else
			{			
				long q = maxpos - 1;
				cout << chr << "\t" << q << "\t" << maxpos << "\n";
				long offset = maxpos - p;
				offcounts[offset]++;		

				// insert window of positions around dyad into taken
				for ( long i = ( maxpos - window ); i <= (maxpos + window); i++ )
				{
					taken.insert(i);
				}

				counter++;
			}

		}

		ns.pop();
                delete n;
	}

	cerr << "Number of called nucleosomes: " << counter << endl;
	cerr << "Nucleosome offsets:" << endl;
	std::tr1::unordered_map<long,long>:: iterator mitr;
	for ( mitr = offcounts.begin(); mitr != offcounts.end(); mitr++ )
	{
		cerr << mitr->first << "\t" << mitr->second << endl;
	}
	return 0;
}
