#!/usr/bin/perl

use strict;
use warnings;

package IntergenicHumanNucCoord;

sub new
{
	my ($class) = @_;
	
	my $self = bless {}, $class;

	my $nuc_file_name = "../hybridnuct10_allchr_hg19_1based_147bp_notBLIST_annotated.txt";
	#my $nuc_file_name = "../hybridnuct10_allchr_hg18_1based_147bp_notBLIST_annotatedfix.txt";
	#my $nuc_file_name = "../intergenic_test_nucs.txt";	

	# open file with gene positions
	open( GENE, $nuc_file_name) || die "Couldn't open file\n";
	#my $header = <GENE>;
	#print STDERR "Header: $header";

	my %chromdyad;
	while( my $line = <GENE> )
	{
		chomp($line);

		if ( $line =~ /(chr[a-zA-Z_0-9]+)\t([0-9]+)\t/ )
		{	
			# don't shift coord, because coords are 1-based 
			my $chr = $1;
			my $pos = $2;
			my @fields = split /\t/, $line;
			if ( $fields[0] ne $chr || $fields[1] != $pos )
			{
				die "mismatch in fields from line: $line\n";
			}
			my $acc = $fields[3];
			if ( $acc eq "NA" )
                        {
				push @{$chromdyad{$chr}}, $pos;
			}
			elsif ( $acc =~ /^ENSG/ )  
			{
				next;
			}
			else
			{
				die "Error with accession: $line\n";
			}
		}

	}

	close ( GENE );
	$self->{'chromdyad'} = \%chromdyad;
	$self->{'nuc_file_name'} = $nuc_file_name;
	return $self;	
}

sub get_chr_dyad
{
	my ($self) = @_;

	return %{$self->{'chromdyad'}};

}

sub get_nuc_filename
{
        my ($self) = @_;

        return $self->{'nuc_file_name'};
}
1;	
