#!/usr/bin/perl

use strict;
use warnings;

use lib '../';

use OrientedHumanNucCoord;
use CPDHumanReads;

print STDERR "Enter filename for output .txt file\n";
my $outfile = <STDIN>;
chomp $outfile;

my $bed_file = $outfile;
$bed_file =~ s/\.txt/\.bed/ || die "output file must be a .txt file\n";
open (BED, ">$bed_file") || die "couldn't open bed file\n";

open ( OUT, ">$outfile" ) || die "couldn't open output file\n";

my $nucwindow = 73;
# ask for probe filename to analyze
print STDERR "Enter filename of plus strand reads\n";
my $plusfile = <STDIN>;
chomp($plusfile);

print STDERR "Enter filename of minus strand reads\n";
my $minusfile = <STDIN>;
chomp($minusfile);

# add filename here for probe values 
#my $filename = "h2bwtdata.txt";

print STDERR "Loading nucleosome coordinates\n";
my $nucs = OrientedHumanNucCoord->new();
print STDERR "Loading Probe Values\n";
my $reads = CPDHumanReads->new($plusfile, $minusfile);

my %chrdyad = $nucs->get_chr_dyad();
my %dyadstrand = $nucs->get_dyad_strand();
my %dyadacc = $nucs->get_dyad_acc();
my $nuc_filename = $nucs->get_nuc_filename();

#print header
print OUT "Randomly oriented nucleosome positioning data for just coding nucleosomes from: $nuc_filename\nSequencing data from file: $plusfile\t$minusfile\n";
print OUT "Position Relative to Dyad (bp)";
for ( my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
{
	print OUT "\t$i";
}
print OUT "\n";

my @pluscpdval;
my @minuscpdval;
my @totalcount;

my $plusnucount = 0;
my $minusnucount = 0;
foreach my $chr (sort keys %chrdyad)
{
	print STDERR "Starting $chr\n";
	my %plusreads = $reads->get_plus_reads_for_chromosome($chr);
	my $num_plusreads = scalar keys %plusreads;
	my %minusreads = $reads->get_minus_reads_for_chromosome($chr);
	my $num_minusreads = scalar keys %minusreads;
	print STDERR "$chr reads: $num_plusreads plus reads and $num_minusreads minus reads\n";
	foreach my $dyad ( @{$chrdyad{$chr}} )
	{
		my $start = $dyad - $nucwindow;
		my $end = $dyad + $nucwindow;
		my $strand = $dyadstrand{$chr}{$dyad};
		
		# bed start should be 0-based
		my $bedstart = $start - 1;
		my $nucname = $chr . ":" . $start . "-" . $end;

		if ( $strand eq "+" )
		{
			$plusnucount++;
                	print BED "$chr\t$bedstart\t$end\t$nucname\t$plusnucount\t$strand\n";

			for ( my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
			{	
				my $pos = $dyad + $i;
				my $j;
                                if ( $plusnucount % 2 == 0 )
                                {
                                        $j = $i + $nucwindow;
                                }
                                else
                                {
                                        $j = $nucwindow - $i;
                                }

				$totalcount[$j]++;
				if ( exists $plusreads{$pos} )
				{
					$pluscpdval[$j] += $plusreads{$pos};
				}
				
	                        if ( exists $minusreads{$pos} )
	                        {
	                                $minuscpdval[$j] += $minusreads{$pos};
	                        }
			}
		}
		elsif ( $strand eq "-" )
		{
                        $minusnucount++;
                        print BED "$chr\t$bedstart\t$end\t$nucname\t$minusnucount\t$strand\n";
                        for ( my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
                        {
                                my $pos = $dyad + $i;
                                my $j;

                                if ( $minusnucount % 2 == 0 )
                                {
                                        $j = $i + $nucwindow;
                                }
                                else
                                {
                                        $j = $nucwindow - $i;
                                }

                                $totalcount[$j]++;
                                if ( exists $plusreads{$pos} )
                                {
                                        $minuscpdval[$j] += $plusreads{$pos};
                                }

                                if ( exists $minusreads{$pos} )
                                {
                                        $pluscpdval[$j] += $minusreads{$pos};
                                }
                        }
		}
		else
		{
			die "No strand info for nuc: $chr\t$dyad\n";
		}
	}

}

print OUT "Plus strand";
for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
{
	my $j = $i + $nucwindow;
	my $mean = 1.0 * $pluscpdval[$j] / $totalcount[$j];
	print OUT "\t$mean";
}
print OUT "\nMinus strand";
for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
{
	my $j = $i + $nucwindow;
        my $mean = 1.0 * $minuscpdval[$j] / $totalcount[$j];
        print OUT "\t$mean";
}
print OUT "\n";
print OUT "\n5\'->3\'Minus strand";
for (my $i = $nucwindow; $i >= (-1 * $nucwindow); $i-- )
{
        my $j = $i + $nucwindow;
        my $mean = 1.0 * $minuscpdval[$j] / $totalcount[$j];
        print OUT "\t$mean";
}

print OUT "\n\n";
print OUT "Plus strand\n";
print OUT "Mutations Plus Strand";
for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
{
        my $j = $i + $nucwindow;
        print OUT "\t$pluscpdval[$j]";
}
print OUT "\nNucleotides:";
for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
{
        my $j = $i + $nucwindow;
        print OUT "\t$totalcount[$j]";
}
print OUT "\nMinus strand\n";
print OUT "Mutations Minus Strand";
for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
{
        my $j = $i + $nucwindow;
        print OUT "\t$minuscpdval[$j]";
}
print OUT "\nNucleotides:";
for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
{
        my $j = $i + $nucwindow;
        print OUT "\t$totalcount[$j]";
} 

print OUT "\n\n";
print OUT "Sum of both strands:";
print OUT "\nMutations both strands";
for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
{
        my $j = $i + $nucwindow;
	my $total_val = $pluscpdval[$j] + $minuscpdval[$j];
        print OUT "\t$total_val";
}

print OUT "\n";
print OUT "\n5\'->3\'Minus strand\n";
print OUT "Mutations Minus Strand (5\'->3\')";
for (my $i = $nucwindow; $i >= (-1 * $nucwindow); $i-- )
{
        my $j = $i + $nucwindow;
        print OUT "\t$minuscpdval[$j]";
}
print OUT "\nTotal Nucleotides:";
for (my $i = $nucwindow; $i >= (-1 * $nucwindow); $i-- )
{
        my $j = $i + $nucwindow;
        print OUT "\t$totalcount[$j]";
}

