#!/usr/bin/perl

use strict;
use warnings;

my $header1 = <STDIN>;
print STDERR "Header 1: $header1";
my $header2 = <STDIN>;
print STDERR "Header 2: $header2";

my %trimuts = ();
my %trinucs = ();

while ( my $line = <STDIN> )
{
	chomp $line;
	my @fields = split /\t/, $line;

	my $trinuc = $fields[0];
	if ( $trinuc =~ /^[ATGC]([ATGC])[ATGC]$/ )
	{
		my $mutbase = $1;
		if ( $mutbase =~ /[AG]/ )
		{
			$trinuc = reverse $trinuc;
			$trinuc =~ tr/ATGC/TACG/;
		}

                $trimuts{$trinuc} += $fields[1];
                $trinucs{$trinuc} += $fields[2];
	}
	else
	{
		die "Error with trinuc sequence: $trinuc\n";
	}

}

print $header1;
print $header2;

foreach my $tri ( sort keys %trimuts )
{
	my $fraction = 1.0 * $trimuts{$tri} / $trinucs{$tri};
	print "$tri\t$trimuts{$tri}\t$trinucs{$tri}\t$fraction\n";
}
