#!/usr/bin/perl

use strict;
use warnings;

package OrientedHumanNucCoord;

sub new
{
	my ($class) = @_;
	
	my $self = bless {}, $class;

	#my $nuc_file_name = "../hybridnuct10_allchr_hg19_1based_147bp_notBLIST_annotate_driver_codingexon.txt";
	my $nuc_file_name = "../hybridnuct10_allchr_hg19_1based_147bp_notBLIST_annotated.txt";
	#my $nuc_file_name = "../hybridnuct10_allchr_hg18_1based_147bp_notBLIST_annotatedfix.txt";
	#my $nuc_file_name = "../test_annotate_nucs.txt";
	#my $nuc_file_name = "../test_mutation_nucs.txt";

	# open file with gene positions
	open( GENE, $nuc_file_name) || die "Couldn't open file\n";
	#my $header = <GENE>;
	#print STDERR "Header: $header";

	my %chromdyad;
	my %dyadacc = ();
	my %dyadstrand = ();
	while( my $line = <GENE> )
	{
		chomp($line);

		if ( $line =~ /(chr[a-zA-Z_0-9]+)\t([0-9]+)\t/ )
		{	
			# don't shift coord, because coords are 1-based 
			my $chr = $1;
			my $pos = $2;
			my @fields = split /\t/, $line;
			if ( $fields[0] ne $chr || $fields[1] != $pos )
			{
				die "mismatch in fields from line: $line\n";
			}
			my $acc = $fields[3];
			if ( $acc =~ /^ENSG/ )
			{
				if ( $fields[5] eq "+" || $fields[5] eq "-" )
				{
                                	$dyadacc{$chr}{$pos} = $acc;
					$dyadstrand{$chr}{$pos} = $fields[5];
                        		push @{$chromdyad{$chr}}, $pos;
				}
				elsif ( $fields[5] eq "AMBIG" )
				{
					next;
				}	
				else
				{
					die "Strand error for line: $line\n";
				}
			}
			elsif ( $acc eq "NA" )
			{
				next;
			}
			else
			{
				die "Error with accession: $line\n";
			}
		}

	}

	close ( GENE );
	$self->{'chromdyad'} = \%chromdyad;
	$self->{'dyadacc'} = \%dyadacc;
	$self->{'dyadstrand'} = \%dyadstrand;
	$self->{'nuc_file_name'} = $nuc_file_name;
	return $self;	
}

sub get_chr_dyad
{
	my ($self) = @_;

	return %{$self->{'chromdyad'}};

}

sub get_nuc_filename
{
        my ($self) = @_;

        return $self->{'nuc_file_name'};
}
sub get_dyad_strand
{
        my ($self) = @_;

        return %{$self->{'dyadstrand'}};

}
sub get_dyad_acc
{
        my ($self) = @_;

        return %{$self->{'dyadacc'}};
}
1;	
