#!/usr/bin/perl

use strict;
use warnings;

use lib '../';

use OrientedHumanNucCoord;
use FastCPDHumanReads;

my $nucwindow = 73;

print STDERR "Enter filename for output .txt file\n";
my $outfile = <STDIN>;
chomp $outfile;

my $bed_file = $outfile;
$bed_file =~ s/\.txt/\.bed/ || die "output file must be a .txt file\n";
open (BED, ">$bed_file") || die "couldn't open bed file\n";

open ( OUT, ">$outfile" ) || die "couldn't open output file\n";

my @plusfiles = ();
my @minusfiles = ();

# ask for multiple wig filenames to analyze

my $counter = 1;
while ( 1 )
{
	print STDERR "Enter filename of plus strand reads for replicate $counter\n";
	my $plusfile = <STDIN>;
	chomp($plusfile);

	if ( $plusfile =~ /wig/ )
	{
		push @plusfiles, $plusfile;	
	}
	else
	{
		last;
	}

	print STDERR "Enter filename of minus strand reads for replicate $counter\n";
	my $minusfile = <STDIN>;
	chomp($minusfile);

	if ( $minusfile =~ /wig/ )
	{	
		push @minusfiles, $minusfile;
	}
	else
	{
		last;
	}
	$counter++;
}

if ( scalar @plusfiles != scalar @minusfiles )
{
	die "Number of plus and minus files given don't match!\n";
}

print STDERR "Loading nucleosome coordinates\n";
my $nucs = OrientedHumanNucCoord->new();

my %chrdyad = $nucs->get_chr_dyad();
my $nuc_filename = $nucs->get_nuc_filename();

my %dyadstrand = $nucs->get_dyad_strand();
my %dyadacc = $nucs->get_dyad_acc();

my @pluscpdval;
my @totalcount;
my @minuscpdval;

for ( my $a = 0; $a < scalar @plusfiles; $a++ )
{ 
	# load and process plus reads
	print STDERR "Loading Plus Reads from file $plusfiles[$a]\n";
	my $plusobj = FastCPDHumanReads->new($plusfiles[$a]);
	
	foreach my $chr (sort keys %chrdyad)
	{
		print STDERR "Starting $chr\n";
		my %plusreads = $plusobj->get_reads_for_chromosome($chr);
		my $num_plusreads = scalar keys %plusreads;
		print STDERR "$chr reads: $num_plusreads plus reads\n";
		foreach my $dyad ( @{$chrdyad{$chr}} )
		{
			my $start = $dyad - $nucwindow;
			my $end = $dyad + $nucwindow;
			my $strand = $dyadstrand{$chr}{$dyad};

			# just do this once --> don't repeat for minus strand
			if ( $a == 0 )
			{
	                	my $bedstart = $start - 1;
				my $nucname = $chr . ":" . $start . "-" . $end;
	                	# set all strands as + /default
	                	print BED "$chr\t$bedstart\t$end\t$nucname\t.\t+\n";
			}

			if ( $strand eq "+" )	
			{
				for ( my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
				{	
					my $pos = $dyad + $i;
					my $j = $i + $nucwindow;

					if ( $a == 0 )
					{
						$totalcount[$j]++;
					}
					if ( exists $plusreads{$pos} )
					{
						$pluscpdval[$j] += $plusreads{$pos};
					}
				}	
			}
			elsif ( $strand eq "-" )
			{
                                for ( my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
                                {
        	                        my $pos = $dyad + $i;
	                                my $j = $nucwindow - $i; # opposite direction because - strand
 					if ( $a == 0 )
					{
                                		$totalcount[$j]++;
					}
        	                        if ( exists $plusreads{$pos} )
                	                {
                        	                $minuscpdval[$j] += $plusreads{$pos};
                                	}
				}
			}
                	else
                	{
                        	die "No strand info for nuc: $chr\t$dyad\n";
                	}
		}
		undef %plusreads;
	}
	
	undef $plusobj;
	
	#load and process minus reads
	print STDERR "Loading Minus Reads from file $minusfiles[$a]\n";
	my $minusobj = FastCPDHumanReads->new($minusfiles[$a]);
	
	foreach my $chr (sort keys %chrdyad)
	{
	        print STDERR "Starting $chr\n";
	        my %minusreads = $minusobj->get_reads_for_chromosome($chr);
	        my $num_minusreads = scalar keys %minusreads;
	        print STDERR "$chr reads: $num_minusreads minus reads\n";
	        foreach my $dyad ( @{$chrdyad{$chr}} )
	        {
	                my $start = $dyad - $nucwindow;
	                my $end = $dyad + $nucwindow;
			my $strand = $dyadstrand{$chr}{$dyad};

			if ( $strand eq "+" )
			{
	                	for ( my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
	                	{
	                        	my $pos = $dyad + $i;
		                        my $j = $i + $nucwindow;
		                        if ( exists $minusreads{$pos} )
		                        {
	        	                        $minuscpdval[$j] += $minusreads{$pos};
	                	        }
				}
	                }
	                elsif ( $strand eq "-" )
        	        {
                	        for ( my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
                        	{
                                	my $pos = $dyad + $i;
        	                        my $j = $nucwindow - $i; # opposite direction because - strand

	                                if ( exists $minusreads{$pos} )
        	                        {
                	                        $pluscpdval[$j] += $minusreads{$pos};
                        	        }
				}
                        }
                        else
                        {
                                die "No strand info for nuc: $chr\t$dyad\n";
                        }
	        }
		undef %minusreads;
	}
	
	undef $minusobj;
}
	
#print header
print OUT "Oriented nucleosome positioning data from: $nuc_filename\nSequencing data from file:\t@plusfiles\t@minusfiles\n";
print OUT "Postion Relative to Dyad (bp)";
for ( my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
{
        print OUT "\t$i";
}
print OUT "\n";

print OUT "Plus strand";
for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
{
	my $j = $i + $nucwindow;
	my $mean = 1.0 * $pluscpdval[$j] / $totalcount[$j];
	print OUT "\t$mean";
}
print OUT "\nMinus strand";
for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
{
	my $j = $i + $nucwindow;
        my $mean = 1.0 * $minuscpdval[$j] / $totalcount[$j];
        print OUT "\t$mean";
}
print OUT "\n";
print OUT "\n5\'->3\'Minus strand";
for (my $i = $nucwindow; $i >= (-1 * $nucwindow); $i-- )
{
        my $j = $i + $nucwindow;
        my $mean = 1.0 * $minuscpdval[$j] / $totalcount[$j];
        print OUT "\t$mean";
}

print OUT "\n\n";
print OUT "Plus strand\n";
print OUT "CPDs Plus Strand";
for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
{
        my $j = $i + $nucwindow;
        print OUT "\t$pluscpdval[$j]";
}
print OUT "\nNucleotides:";
for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
{
        my $j = $i + $nucwindow;
        print OUT "\t$totalcount[$j]";
}
print OUT "\nMinus strand\n";
print OUT "CPDs Minus Strand";
for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
{
        my $j = $i + $nucwindow;
        print OUT "\t$minuscpdval[$j]";
}
print OUT "\nNucleotides:";
for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
{
        my $j = $i + $nucwindow;
        print OUT "\t$totalcount[$j]";
} 

print OUT "\n\n";
print OUT "Sum of both strands:";
print OUT "\nCPDs both strands";
for (my $i = (-1 * $nucwindow); $i <= $nucwindow; $i++ )
{
        my $j = $i + $nucwindow;
	my $total_val = $pluscpdval[$j] + $minuscpdval[$j];
        print OUT "\t$total_val";
}

print OUT "\n";
print OUT "\n5\'->3\'Minus strand\n";
print OUT "CPDs Minus Strand (5\'->3\')";
for (my $i = $nucwindow; $i >= (-1 * $nucwindow); $i-- )
{
        my $j = $i + $nucwindow;
        print OUT "\t$minuscpdval[$j]";
}
print OUT "\nTotal Nucleotides:";
for (my $i = $nucwindow; $i >= (-1 * $nucwindow); $i-- )
{
        my $j = $i + $nucwindow;
        print OUT "\t$totalcount[$j]";
}

