#!/usr/bin/perl

use strict;
use warnings;

#use lib '../';

package FastCPDHumanReads;

sub new
{
	my ($class, $readfile) = @_;

	my $self = bless {}, $class;

	my $inChr_flag = 0;
	my $sequence_num = 0;
	my $chr_num;
	my %seqreads;

	open( READS, $readfile) || die "couldn't open file: $readfile\n";

	while( my $line = <READS> )
	{
	        chomp $line;
	        $line =~ s/^M//g;
		if ( $line eq "" )
		{
			next;
		}
	        elsif( $line =~ /chrom=(chr[0-9A-Za-z_]+) / )
	        {
	                $chr_num = $1;
	        }
	        else
	        {
			my @fields = split /\t/, $line;

			# hash of hashes
	                $seqreads{$chr_num}{$fields[0]} = $fields[1];
		
			#print "field0: $fields[0]\t field1: $fields[1]\n";
	        }
	
	}
	close( READS );

	$self->{'seqreads'} = \%seqreads;

	return $self;
}

sub get_reads_for_chromosome
{
        my( $self, $chr_num ) = @_;

        return %{$self->{'seqreads'}{$chr_num}};
}
1;
