#!/bin/bash
# repair_genecluster_pipeline.sh
#Code adapted from code on Taylor lab github site

a="repair_"
export VAL=$1
export TWO=$2
export ZERO=$3
export REPAIR=$a${TWO}
mkdir ${REPAIR}
cd ${REPAIR}

#copy wig files to directory
cp ../${TWO}/${TWO}_dipy_inbetween_bk_plus.wig ${TWO}_dipy_inbetween_bk_plus.wig
cp ../${TWO}/${TWO}_dipy_inbetween_bk_minus.wig ${TWO}_dipy_inbetween_bk_minus.wig
cp ../${ZERO}/${ZERO}_dipy_inbetween_bk_plus.wig ${ZERO}_dipy_inbetween_bk_plus.wig
cp ../${ZERO}/${ZERO}_dipy_inbetween_bk_minus.wig ${ZERO}_dipy_inbetween_bk_minus.wig

# process data to get fraction remaining
printf "${TWO}_dipy_inbetween_bk_plus.wig\n${TWO}_dipy_inbetween_bk_minus.wig\n${ZERO}_dipy_inbetween_bk_plus.wig\n${ZERO}_dipy_inbetween_bk_minus.wig\n" | perl ../cpdrepair_plotorf_inbetween_highres.pl >${REPAIR}_dipy_inbetween_bk_tcr_15bpx2bins.txt

printf "${REPAIR}_dipy_inbetween_bk_tcr_15bpx2bins.txt\n${VAL}\n" | perl ../arbcenter_logtransform_clusters.pl

printf "${REPAIR}_dipy_inbetween_bk_tcr_15bpx2bins_center${VAL}.txt" | perl ../orfplot_trxall.pl

printf "${REPAIR}_dipy_inbetween_bk_tcr_15bpx2bins_center${VAL}_trxsorted.txt" | perl ../split_nts_ts.pl

perl ../format_CDT.pl <${REPAIR}_dipy_inbetween_bk_tcr_15bpx2bins_center${VAL}_trxsorted_ts.txt >${REPAIR}_dipy_inbetween_bk_tcr_15bpx2bins_center${VAL}_trxsorted_ts_cluster.cdt

perl ../format_CDT.pl <${REPAIR}_dipy_inbetween_bk_tcr_15bpx2bins_center${VAL}_trxsorted_nts.txt >${REPAIR}_dipy_inbetween_bk_tcr_15bpx2bins_center${VAL}_trxsorted_nts_cluster.cdt
