#!/bin/bash

# code adapted from Lopez-Bigas: https://nbviewer.jupyter.org/urls/bitbucket.org/bbglab/nucleosome-periodicity/raw/master/accessibility/accessibility.ipynb

for individual in NA18507 NA18508 NA18516 NA18522 NA19193 NA19238 NA19239
do
    for filename in ${PWD}/${individual}*; do
    	zcat < ${filename} | \
        perl convert_dnase_to_bed.pl 
    done >dnaseq_${individual}.bed 

    cat dnaseq_${individual}.bed | sort -k1,1 -k2,2n > dnaseq_${individual}_sorted.bed

    #rm hg18.fa.fai
    #fastaFromBed -s -name -fi hg18.fa -bed dnaseq_${individual}_sorted.bed -fo dnaseq_${individual}_sorted.fa
    #perl check_dnase_fasta.pl < dnaseq_${individual}_sorted.fa >dnaseq_${individual}_sorted_checkmatch.txt

    printf "dnaseq_${individual}_sorted.bed\n" | perl ../split_strands.pl
done

