#!/usr/bin/perl 

use strict;
use warnings;

while ( my $line = <STDIN> )
{
	chomp $line;
	my @fields = split /\t/, $line;

	my $start;
	my $end;

	my $fivebase = substr ( $fields[3], 0, 1);
	if ( $fields[2] eq "+" )
	{
		$end = $fields[1];
		$start = $end - 1; # make 0-based
	}
	elsif ( $fields[2] eq "-" )
	{
		$end = $fields[1] + 19; # get 5' end of minus strand dnase-seq read
		$start = $end - 1;
	}
	else
	{
		die "No strand information for line: $line\n";
	}

	print "$fields[0]\t$start\t$end\t$fivebase\t\t$fields[2]\n";


}
