(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[   1246087,      24603]
NotebookOptionsPosition[   1244564,      24571]
NotebookOutlinePosition[   1244931,      24587]
CellTagsIndexPosition[   1244888,      24584]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Plotting \[OpenCurlyQuote]Population Structure Hierarchies\[CloseCurlyQuote] \
onto geographic maps\
\>", "Title",
 CellChangeTimes->{{3.7316915647554417`*^9, 3.731691603357554*^9}, {
  3.7316920898571978`*^9, 3.7316920900990577`*^9}, {3.7348033462826414`*^9, 
  3.7348033541638002`*^9}},ExpressionUUID->"12f822a6-5e9b-4d25-8d16-\
5653252b083c"],

Cell["\<\
INSTRUCTIONS

This tools is intended to plot outputs of NetStruct_Hierarchy onto geographic \
maps.

Follow the following steps:
1. In the Mathematica toolbar, choose Evaluation -> Evaluate Initialization \
Cells.
2. In \[OpenCurlyDoubleQuote]DataFolder= \[OpenCurlyDoubleQuote] (purple cell \
below this orange cell), input the folder that contains the output files of \
NetStruct_Hierarchy 
3. In \[OpenCurlyDoubleQuote]CoordinatesFileFolder=\[CloseCurlyDoubleQuote], \
input the folder that contains the coordinates file
4. In \[OpenCurlyDoubleQuote]CoordinatesFileName=\[CloseCurlyDoubleQuote], \
input the name of the coordinates file (must be a CSV file)
5. Click anywhere in the purple cell and hit Shift+Enter to run the cell. 
6. In the blue cell, set the coordinate range of the requested map under \
\[OpenCurlyDoubleQuote]range=\[CloseCurlyDoubleQuote]
7. Set the root node below which clusters will be colored under \
\[OpenCurlyDoubleQuote]rootnode=\[CloseCurlyDoubleQuote]. By default, this is \
set to \[OpenCurlyDoubleQuote]1\[CloseCurlyDoubleQuote] so that all clusters \
will be colored. See paper for details.
8. Click anywhere in the blue cell and hit Shift+Enter to generate the map \
and Population Structure Hierarchy plots.
9. Steps 5-7 can be repeated to fine-tune and generate several maps. There is \
no need to re-run the purple cell.

OUTPUTS
There are three outputs:
1. A map with the requested coordinate range. Individual samples are colored \
according to the cluster assignment, shown in the next two outputs
2. The Population Structure Hierarchy, with colored assigned to each cluster \
(see paper)
3. The same Population Structure Hierarchy with the number ID of each \
cluster. These number IDs can be used to select a different root node.

NOTE
The CSV coordinate file should be structured in the following way:
    Each row contains data on a single individual.
    Column 1 - Associated region of the individual (string). This column does \
not affect map plotting, and could be identical to all individuals.
    Column 2 - ID of individual (string). Should be the same as was used to \
generate the NetStruct_Hierarchy outputs.
    Column 3 - Latitude (number).
    Column 4 - Longitude (number).\
\>", "Text",
 CellChangeTimes->{{3.731691544191473*^9, 3.7316915451412363`*^9}, {
   3.7316916085631638`*^9, 3.7316917787538695`*^9}, {3.7316918809099045`*^9, 
   3.7316919978239665`*^9}, {3.731692037980384*^9, 3.73169204188665*^9}, {
   3.7316920769656334`*^9, 3.7316921952271566`*^9}, {3.7316922359524145`*^9, 
   3.7316926198385115`*^9}, {3.731692709674506*^9, 3.73169291661065*^9}, {
   3.7316929764165792`*^9, 3.731693004287326*^9}, {3.731693034387164*^9, 
   3.7316930408203588`*^9}, {3.7316931050089226`*^9, 
   3.7316931073811135`*^9}, {3.73169326079103*^9, 3.7316935048941402`*^9}, {
   3.734803225112409*^9, 3.734803297074994*^9}, {3.7348034179336295`*^9, 
   3.7348034203578053`*^9}, 3.735998768539749*^9, {3.73599896452979*^9, 
   3.735999020938653*^9}},
 Background->RGBColor[
  1, 0.9, 0.8],ExpressionUUID->"48a83395-b95c-4e99-9378-a7077de3e07e"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "DataFolder", "=", 
   "\"\<C:\\\\Users\\\\gilig\\\\Documents\\\\MEGA\\\\NetStruct_WG_project\\\\\
temp\\\\arabidopsis1\\\\5\\\\data\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "CoordinatesFileFolder", "=", 
   "\"\<C:\\\\Users\\\\gilig\\\\Documents\\\\Mega\\\\NetStruct_WG_project\\\\\
Arabidopsis\>\""}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
   "CoordinatesFileName", "=", "\"\<indlist_new2_with_coords.csv\>\""}], 
   ";"}], "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "CoordinatesFileFolder", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"file1", "=", 
   RowBox[{"Import", "[", "CoordinatesFileName", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "DataFolder", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"file2name", "=", 
   RowBox[{
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{"FileNames", "[", "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"StringTake", "[", 
         RowBox[{"#", ",", "6"}], "]"}], "\[Equal]", "\"\<1_Comm\>\""}], 
       "&"}]}], "]"}], "\[LeftDoubleBracket]", "1", 
    "\[RightDoubleBracket]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"file2", "=", 
   RowBox[{"Import", "[", 
    RowBox[{"file2name", ",", "\"\<Table\>\""}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"tree1", "=", 
   RowBox[{"MakeTreeFull", "[", 
    RowBox[{"file2", ",", "file1"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"PrepareData", "[", "DataFolder", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.731688995129768*^9, 3.731688995664101*^9}, {
   3.7316894003351316`*^9, 3.7316894147467527`*^9}, {3.7316894452290945`*^9, 
   3.73168945721056*^9}, {3.731689512250872*^9, 3.731689537195335*^9}, 
   3.731689572292677*^9, {3.7316896747325063`*^9, 3.73168968026315*^9}, {
   3.731689858409252*^9, 3.731689860845975*^9}, {3.7316899662466745`*^9, 
   3.73168998812953*^9}, 3.73169034199298*^9, {3.731691784580863*^9, 
   3.7316918636332045`*^9}, 3.7316920204737167`*^9, 3.731693186240388*^9},
 Background->RGBColor[
  0.94, 0.88, 0.94],ExpressionUUID->"74f4bc81-bc96-426b-aef1-d09e5ecc1946"],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"backgroundmap", "=", "\"\<Coastlines\>\""}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"range", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "90"}], ",", "90"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "180"}], ",", "180"}], "}"}]}], "}"}]}], ";"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"lat", "/", "long"}], " ", "-", " ", 
    RowBox[{"World", " ", "Map"}]}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rootnode", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"pointsize", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"q1", "=", 
  RowBox[{"plotmapsAllind", "[", 
   RowBox[{
   "range", ",", "rootnode", ",", "pointsize", ",", "\"\<Rainbow\>\""}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"q2", "=", "coloredtree2"}], "\[IndentingNewLine]", 
 RowBox[{"q3", "=", "coloredtree"}]}], "Input",
 CellChangeTimes->{{3.7316905194871225`*^9, 3.731690536597642*^9}, 
   3.7316912335940857`*^9, 3.7316915058170757`*^9, 3.7316922984198465`*^9, {
   3.7316923512522526`*^9, 3.731692352063639*^9}},
 Background->RGBColor[
  0.87, 0.94, 1],ExpressionUUID->"bc620b30-c8ac-46f0-9ac5-44de81f66c44"],

Cell[BoxData[
 GraphicsBox[{{
    TagBox[
     {Opacity[1], 
      {FaceForm[RGBColor[0.87, 0.94, 1]], PolygonBox[CompressedData["
1:eJxl2nl8zlf2B/CgqCpVW6LRlDRiC4JIguDEEiKprBKxZCGoLZa2xpBqLGMN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        "]]}, 
      {EdgeForm[GrayLevel[0.6]], FaceForm[RGBColor[1, 0.93, 0.82]], 
       StyleBox[{FilledCurveBox[{{Line[CompressedData["
1:eJws23k8Vc/7AHA7kTVL9n3ft+te233srn1fkxCislQoJCqRskZ8UkhUJImK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             "]]}, {Line[CompressedData["
1:eJwBMQLO/SFib1JlAgAAACIAAAACAAAA0Kckgfg1L8B7Y2yNqOknQEnElEii
Jy/AJET5ghYKKEAO0lPkEBEvwNhJfVna8SdAn1inyvf8LsDVB5J3DvUnQIZV
vJF53C7AsirCTUYlKEAfSx+6oLYuwPOPvknTCChAMo/8wcCjLsAj9Z7KaR8o
QCU8odefrC7AF0flJmoxKED9/zhhwrAuwEzdlV0wIChAox8Np8zFLsBSflLt
0xkoQGtEMA4u9S7AWkkrvqE4KEDAB69d2uguwNUI/Uy9FihAlI/dBUryLsAp
toKmJQ4oQHHIBtLF/i7A+S6lLhkXKEDt+3CQEP0uwH1+GCE8KihAPG2NCMYB
L8B4swbvqzIoQIVWJ2coBi/A8YPzqWM1KEAkXp7OFQ0vwNs0tteCBihAGjVf
JR8jL8AofSHkvB8oQCCHd2/7OC/Av/OLEvT7J0BmW3KBcFYvwFCU3/1MEChA
L6fEIeGSL8CEmcnz3wAoQK+NZ4ZDbS/ASdCpdSzIJ0AuUs1R7GUvwJt/qsB/
7SdAb5QGyOFhL8BUYo1pXOInQD+A+/DiUy/A7//jhAnbJ0D8Tjhg/FUvwAFv
3L030SdADbBFwUJQL8AlNsQdFM0nQAJjIkogTi/AZ0Y/Gk7dJ0C4q/zXXmAv
wAzZikfz7SdAeOxnsRRlL8BHeqx00u4nQIjPQqeMbC/ATybJzjbqJ0CllveC
YFcvwAzbYPJQDShA0Kckgfg1L8B7Y2yNqOknQBQH+SM=
             "]]}, {Line[CompressedData["
1:eJxTTMoPSmViYGAQB2IQzW9Ub23/WtihPWRNqa2+l8OdXbOXW60RcZhXztHx
Ts3L4aTFU2lpZ1GHFzmMC78C+WrHLqY9myzikH3jfWepppfDpiIJdckaEQdF
YaufdoZeDn3VfldnzBZz+M10JO+ln5eDYfx+sVWJYg6iSU+kDyR6OUhH3PsV
ulTM4SCndbVslpcD96+D692vizlUutfcvQHkJyWnqFy7K+bQq5fPdz3by2FH
9+0MhnxRB3fmCm6VAi+HXf2TeKOWiTq83reWlb3Ky+ECULaxRdShjO3Phd3d
Xg4On+/t9dAVcWC9GrBlT7mXA8/bOWmNdSIO1nU7E3YleDnMcg7iVrUWdWDl
uLpnZpSXQ9jyCFOOxSIOW6t9sw77ezlc45tQqScq4vD95nbP3wFeDgx/fny4
GC7i0Ou/fVGzg5fDtKj35rcMRRyWHGuZ4W3h5fD2eVxhU4KIQzCLxd5uOy+H
PQejr23uE3GQt/tVcMvKywE9fAHe2pjM
             "]]}, {Line[CompressedData["
1:eJxd1X88lWcfB3DkkbX1g4YeopFf7VFq0xDyec59n/vc931ONUJIrck4pB5Z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             "]]}}], FilledCurveBox[{}], FilledCurveBox[{{Line[CompressedData["
1:eJwsXHc81d8bFykpadAXSfbKlplxbBf3upuse3G1VERFygxNRaKIEiKrkKyM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             "]]}}], FilledCurveBox[{}], FilledCurveBox[{{Line[CompressedData["
1:eJxdenk8lN8XPyGREkqKVoqQsu85djOYmWdmlCxFZa0s7clWloSUFtmVQouP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             "]]}}], FilledCurveBox[{}], PolygonBox[{CompressedData["
1:eJxNnHc8lf/7x7XTHoSmhlGRESkZb2Svex1bOOfQTn1aKkUb7V1aaNAQSWmp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           "], CompressedData["
1:eJxdWGlATV0XrhBCSKKUigbSYEhKqlVESp29z723CEUKkSgNXpUipRLeMpQh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           "], CompressedData["
1:eJxdV3k41lvX7pUUiXI0S4UmkgaVMu2QdkRt0yFSkgwZU8mQoUEkY4NMmUJ5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           "], CompressedData["
1:eJxdVwtYTekariaVZEtCkb3/vVvNuBw6Jrcy+CM5EZLLOGYyay3DXI5LbimX
ikYeMxJjnNQwJjUqk8aYcRk69kdlDE6aRNMocgzxYERqK5fO9/1rOXnOep7a
z7u////Xd3m/9/u3WV0UOdfBzs6uEf/os6WzrbV1t8JDh4U/unXJEezo+Vrh
h+w8BB7v5tDP+ajCP62IvuIy1hm+8HKcYShTuJx7objvj+2hRnJa2/W2woes
HlAQ7usGbwx0yfexU7lbREraws8N8M8xn82vc1e5q5/T2u1JBvAIS49720/l
B6IbVhdGdobUSTnJPweqvLp0TmDBnC6Q5lc/InKYym8mNSf3utMVztZFu0RM
V3nd7f3ngjp3h2d5D8snLlH5nYmq+8xAL9hZzA4sWaXyi4TTe0BeWh9b+Hsq
//X8Y/uhD3tAEpzNHDtb5ZvTFnok1faEfJ9Z7w+fo/Kdpxp7v5vaS/MvRuUz
hm4MlktMMNK1Mit6rcpPLdvm5TiEwfBrk1PSElW+yANPCmbwt+srPQsQu63d
PuazcAa/xJzY3QPXV5Xapt6YziA7eoRrZWIbNq2/O+Uo4nTKWxQD4SfiTHrv
Oww+3Hp/9ahX7PT6EYgX0vdzGRj6H9z1IEHl15vjPy58X/cH8fx59DB4/Lwi
9k687s9qBrOPhbk5oL2nP1WGAUZ7bTLiBbQ8uW19HvmZxABPzzmNWPixnmn1
x/WlFFcqA/zvX4P2hqeY+BQGlIZMxMKPzQzCKW+Ijeh+/88ZfIXHTUD8pcgv
g9HyzTIL4nOZYw834H6RxzUqt1CCtjG4N+WocT3i5tWjBs/O0P3H9UW0fQ8D
sQ/t57GMh7MY0GsOIk4NxoPRbj6w5MOtiKMLsWDZDETYiP99Hp98Blm4/flq
ldvoPd8ycBJ50v09yGAjnYP4CuUX9y/GtGQhPou0+jCTgWfBuOsrEZvpYMSp
FBfyzUh5OMQAvT4WhvhS7J3XB57R64XYZ2bgj2cuM6DyG1/B2E4buiEWea5l
UI/pGoq4AD82Xtfrv1LlZRR3DQOCrohfYNleR/sqcihO5R3xmKqrDOijFLHg
GWIRB+JeVPhrDAQPcH8Uhn8X9wv+I16O9J5xVa8f4ptYzoX/YSDeg3gGQo8b
DOIwLBfEQ7GtZ/3BoAWPX4bnUxuMe8jgZ3Q7GHEIJdLO/D9/RJ5aGawgAiEO
ojy5mTW+I75PfOpoBjr2fcSUZk+DGag88+P0/LibgejQ7xW8h+oZq/IAerqY
tfyifSo51N0MJDseWK+nSJ9Tlxj4UkIwv4IXWC8qQwzah5M7yB/Stw2Il9Sh
Q8gHWrYd+dOIYefn6/lHPoq4kX+0rPwV/r7kt0SOYD+UEG8QB5J/aA/BNn+K
uJzytIUBpd2A/X3jmy+LWTQDYuEu7Ldm6st5ev+81I+5bfilPgSh+ycQjyGi
ROn8Qf0Rfk/V+Y94GDU26pfQS1xfgcd901Pv/yQ9Ph8GS6kgG1T+Nba51MRg
EsnqBt0fxP8iHUS8lnjXwoDocjNZ5YtJAGw6HxD3wXQ3PmFA7RON2IsCaND7
A/F5ir9e5x++X+QJ+YPVrIhdp/JWOqdB3494ChnwPCFz69r2i3wg7kSJu6/r
FcY7ivLyQNc7jFfMhSf6+xCPozo9ZRBDBUCcj+k/4GAGoqsN8y/oiTiS+iRB
1xfE4mtcn4XjA1zNml6gPY/8cDZr+pWg97+LGZqId1jvgXRw9zZMNMgzm6GU
dAmxrRwHgZdZ6y88n8bjmA46vxG/RwTBeNdRP2C8hZSnZgZiXXKb/WX+52F4
V9D+iM7Fegm/MN5dlAfEV8g/zIc36d42lYu897FoepaH8Yl4LBr/c/T5Ye+r
xXtS5YmUt9m+EEobD+t6vstXm3fH9PjsJW1+nlP5IOL/cEnrn2pdX5dJsHtf
XdiLsyqfVjDh9sZ9Ekz2H30q+LLKf38RVP2DyU/jw2mVizp/4KfNy+MqF3Xo
6afpPfqz7yEF6qfpV7HK3amxb0mwl+papNvLJK2+uSrPSKdH0vQX4xVz7QsJ
hO7k6fqyRQKhm7he6EKyBDRWHNEu+uITScsH2vcTrxIkELxHfIH6a5Wk1S9X
16elEhAtdyMWOhglaf2aq/N/igQ24gdiCut+eNt5Ig9hklaffS/jlYDMvdE+
jeofIQGFU4VYxIXxCT5tUbnQzQ/0963Q5/tgScyzlo9UHkNfvOcLJIcn3lV5
EjXqRgsIXZdxntKc7mzR8hepz5sXZu1+N0Hl7RKwnKi/Qv/HqPw5udebCftO
f5X3oDl4xKTt74l6SO8xmTT/TXo8EUaNnwaVMyrEoF5AbXrFXuW1dP+YbNTm
iSPqHSX+ryYQ+/B++QfRPd6o6bcD9gfVqZv+vmeKVu8qI3QnHXqi8AkiQUZt
vjUp/Euyexvh8Th1W/JzhdcklJR9/cCk3efqFW3e2jMQacP1twR/9fl/TeHi
HpGv69tlRdNLvF8J/bigcOF3jq6n5xS+g/RjvD4PTypa/DLT9MGq8EoKB+1U
vny0d6XG6cugb/nMGY2g8O+iaid6vDDB3ysWh351QuH3P+NObz0yafczxDnE
uxBd74oUzo0BEd4J+v3qosI3NiYYGg7p94UbCi8nHbqn6+ddRZ/HFm0eVCh8
ANV5nwUMwaaYLccUPvridu/E5RbI897/Igt/H8xY7rvhBrfA2PllYbsRbzrr
ZwkJtsCYAevcMxB3PrHnne8Qp6TKj5NTFd77z9SdD4PMUFk/8rel8QofaVxT
EzCIwdHv/9HRNlfh0dvlxcMWMchYsmP0yokKz3QLaTdiH953AkpWPB+k8ItJ
b6QH38T5OquyaMlYhYdZAxdUDjZBp3V3Ot2ervA/Y6Tcfpk+0PdMX7vgcIUP
ik3J8Y/yhlDD/Pr00QpfGde0N8C7G6yxb90U2Fvhn0SlvN5U7Ak/Pt7ap6qj
wjcHS3uPRneBe3XS6dgGme/wO+63yscD7w9HVK8qme9pH/nNiDPuMKt0fOuR
EzKfeeXXMLvbBmhY/3ti1Q8yl4/HGFwvdIDs3skZ3Qtl7vDDpAnqIhdIK9q2
rssxmQ/otfSr70c5wzFjbXb2tzK3Hxvz4FFTB6iO+8vPg3fJ/OPDb7Eeb7uD
w6/D4oZkyLzo2ZtevqorXD2Znjdrk8wTnxVOSh3tAj8dbKmKj5f5yGeh659a
nEBmLluu75T5Wwuf1CwragfOm7uGhhyXeWBt3pA/57SD2EPV6b+gP8V3W9od
72wPf5zsdnxNlswTCqM+dcq3h8mlEdUDP5V5UAoYIkMd4E215afqRJnXzS05
NyDgudWzKSttwwqZz/q+/cqfqhqtuZunj78QJXO7rJG/9LrcZPU813//3uUy
z4nw+uKjafesa52d3ONTMH+H5/Xzb75kvba0XeLkvTJ3+y29rv9r161BtY71
zCrz89MSA4vb11kLZqdeVE7h+S2OjeXpT6zmGu8je0pk/sbN7FtKpQPsKXFJ
y66QuX/hjpNLHzmBpcAWs/eGzIdu27RzfccO8Kx8q8fiZplP3Z4xomyIM1y2
9SsY3knhC9Nyr/aQX4PvfE6HOfkp3DNgQetZj1ar0O8ghYu5MddmFbIwDfuR
5o3tqXUL9fcChb9GAhtiB13onp+s8DdJoFMcII1+t+HvZZk2XnaE///9/F9M
MS37
           "], CompressedData["
1:eJxdl3k4ldsXx5GpQpeKc4znnPeknFLSKNM25DrvK8qQIVQSGRJFXeRcoYyH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           "], CompressedData["
1:eJxd13k4VVvYAPBwcGQ6x3GOWZJCpUSlEufNUPZwrgwRKipDZCh1o7nkVio3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           "], CompressedData["
1:eJxdmHlczN0Xx1NC2rNTRNQsNU1pmTadaSJZKkWLppnvd0ZPepIQpajseoiQ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           "], CompressedData["
1:eJxdVglwjVcUzoQmkagmqETI/hKRyHqvrURPKarh2spoGksRtaSEUXvSmFYt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           "], CompressedData["
1:eJxdlnk81dkbx4tCirI21+5Gk3yPJUlDv+nBIKVvZY8kpGuQnWTnSjSytNhm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           "], CompressedData["
1:eJxdVnk01esaJg0ylW0oZQgRUo6bI5VIKN/v7E+UEycJnSSVRGmXDDvjjSYZ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           "], CompressedData["
1:eJxdVXs0lWkXp0PCkVujUCO5dFASlXCQIp73631wXIY0NIxRo1I40WS6qNOc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           "], CompressedData["
1:eJxdlXs41tkWx1WoGd0kUcKrUES8ezOuzVmGkTJy9g8ZNLkcl+G4lIkcjcvk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           "], CompressedData["
1:eJxdWHk81d3zF2ULiR4ksqSUClmzVIOoKO6953wuCSFtshS6pUIlS48kKVRU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           "], CompressedData["
1:eJxdlHs8VHkUwMeaEUtj+12tNDQpixQqSSm5fTaVrsgjJYr1qLCmPKbdfFal
bUnJo1BIlsGMSTNey9oJZ1JbVg8hIWmza2fbpk9eZW2r2dO/+8f93M/38z3n
d88999xjHnrIJ+IjFovlj9eHe8HDzBTfNoZ+cvuuNEFN4OjLXbl9yBMlgX7L
XxNY0mOn5XuDoUGj1St9QyDp6vwlLGTjjZHa+toUXPK7M+qA8WZ+7rKqTyl4
HpNzlYt8I6bHL2QRBW2pxPboTYae3SXyHFlCwSx9q8j3yCb2VrULV1PwhaHT
GB/jFx7cExqxigKNX7LGB8/fB8tEW5wpmLSuMH2qZGhf3sYH+ui9qjXOTsDQ
Rp3F2WF2FJjW7+IbIrcszWgyt6DAoFRj/2cLQztydwgX8ymI2fH9pE0rQ9Pu
qcMv5lGwu1ft1N7M0MGJoarGORREetiyVmK8HlTMWzGbAoeO6WYJ+oyEmKZN
syiodZyjll1n6CFnzZF+5CNzp24+UzB0rDufbYf54Q2t3KmfGLoyLb/vMYeC
cX25xVH0YWvcJ26zKbB0E54yQ643Nn++8D0BHaPM5TXI97qF4w5TBLY5ziw2
w+dXu7rxXZBHW3PVfcjHjQYDOBMEorQG/OuQvfNn7TR8RSDaJDjKGeu7XyRN
z/qNQM16kS4b2ch2oCtgkMAtvltRE7I0XzHmPoD5c96ej0YO+7Ewj9tDIKzj
4vUKfJ/5Vg90pJ0EMi62d7zBevK2d3bcQ7/NQ2d1URNDx13xP7K/kYDds+Kp
6AaGFkzcteTVErCwHT2cV8/Qr+Cdl6icgHpxxT+nkEPKbWVjJQT0LrgUpdQx
9MEKSyWvgEB/bl52IvqisaTYylICh3vXOd1B/5VTmXeyiIAgIKFEgtwiedy1
VYL5miRz11qGFkcoVBF43unTbw3Wo8/R1Sw6eJlA7sMYOxH6a8GBrjMXCawY
9tj7eQ3WY6Xb9lkOAeb4mQ2JyGncwcEJ9Dp/DfV4VzO0V4dh0Eg+gfjlhaw2
GUP//avC+lE2gYEXoXZsOUMXnOGYBGUQYDeWBWRi/PSBA6my8wTm9l2TtyKn
rJVwtTMJVO702tiP8fVZqk13Uwh48LiMNtazXdh8rCuRgDBDq/8l9mtSaq8l
iyMwVngg+3wjQz/w1jYWuhLIN/jSWYz9TVcuEAwj2+yt/vgM9t9iRjCX70OA
+2jtVSmynL3PlPEnkK27UnwY5+uY/OT9PSEETvhLd3LQv+zc4D8aTSCy4fl+
Mfoyi3VPtgoIcKYk4eXIipSEbqWQQLggbHcUcm+QzYn4rwlkbasRxSK/TlCl
qb4hEBxf93veB7956TUh+kjL+zQPz28e0qvqQm/z8NWJzejL9wSalR8nkHw2
+EYtevaOS38YfEtAke59bjtywYBu4r7TBDxLjcK8cL62CMZZilQC3dbtz0KR
q951/6vC/qmnC0Y+5IdUCV2WIQu1OUPt6H+YnD1Wj99HqRr+ZRXOu0FSXNP+
YgKa73pEwejXBDqaFF8gsNQlrSUWeXPMSi/fLAI+4vFlU/h/22ueeuSVEZge
OfkiCnlB0OjuRRUEqGjx5RFk72Mzn/CqsP+ljd0rcJ94qkuSqnDeCk1K5bdw
/8wYNjiIGwhcOdtpEor7ybMnRy+8jsChOJnxNPpB06LKn5UEePry9lbkeOUT
613NBCSqNaQN91Xjas65yXsE/r9P/wOi14u8
           "], CompressedData["
1:eJxdlH0w1GkcwFXKS16qUTc1J4TW3fO7NoVdOnxzXqJ6QlxO55JOrpRdV9l1
Ki8p6+Yu1XJLTcjRkoRwbbnliVYvY8lE0nm9aU7dFTXeo7qvv27m/tjZ+czn
+31+z3xfHqsIUWDkXB0dne34m/2XnI+tf/4DZS6NK22CjxBI1Sjcs45TtrdL
zv6SEjCxLUyUJ1JmsvHO78eSCBxd1ldamUqZuNc32CaVgOaru8rfZJRp72nU
uZkEzK695On/SNm8Cy0l9RcJ9ESuKB5Mo6yvJCkhV0mg/MktfgPGV+416NxU
SiDkykJpDvoFZ84IyqsJ1GRtFTliPjQJRBM3CUQYJiTaIfN6v97BayAQ9zgs
Q4rxbzP1p7x6Cdy3lCy+fJKy7WJzWVs/AeXktYm2E5Qpbqs7a4YI9B6an9Sa
QlmRNuV8NPIULyyvF31C3d6bB14TCHC/eeMA8r785+I9UwRG3V7kbUimrHTz
0ULJJAHdDzqLPsZ8u1fXdeumCXQd1hVXoX+52sNBdz4H8uq24UqsV45WJrFd
wEFm8AFeURJlw5dOPxEacTDQvbTiEfpn8l3+rw05GJHvzzt9lDLjta6ly5Zw
4HzLT9KJnNamzpas4mBU0RzFx34UCM9eEdhxcK5DP2TBLJcNfyez5uBdvrTP
I54yldmlVdk2HMykPzjliD5N/vcb+zUcPNhpIOxLoOzCHc34B+Rc56c8J/TG
5r/sFvDxPl66Mh7yVJ0qqMieA21zivt1PK/Op+DzbGSr6nhJPbJTbaHlmvUc
tOc3dq5DFp7ddnyjIwcTOSaTO5BHUtx8zjtxcCgmRqmPPMT8thUIOHCYs0Jn
PnK89cg9CyEHtqGK+kEpZbJVQ9PJyBDmq/j1CGVr9Dp29zugfzySGILMLxs4
VoH369g0J+RRHGVPggXaNxwHkZ9WTWQfpkz3cfjDSaxH9Efp9d3IaXe7WtUr
OTD1rC0XHaLsZ2+3cinWL+qyqcoglrLlmXdekRUceDfhgCJjFTp8zTgIf1/e
p/qeMsOazSwI2WdCrTASU6bJ3lapwf5rTZeEDIsoO5H8k23AMwIufmaLfNHn
LrRWF/cQiFwZ5DqK553OqC3L6SKwtLRUOY1+MD9LY9JOQG+2cXh+e6R95dRD
AoGhMRbF6LuNfWb4zQT2fJuYUYGsuFbbvqeJQK058ZjG+JngpGGnegJWNguz
GXoHh6nbQXUEvJ825RXj9967yQxMawl4+Cfq+c9y4NiAKe6Hi+Op4SqMTyme
1im8RUAdFdPqiuzV7JS8Hvmzd1l9VRjf0FgtGrrx3/ndloWq0RoC0ZEN/DHk
nWWqHvFVAhYbvhHsxPusFv8Tk3uFgDBurFWK+Vb3x6NncH8d/pz70A7rLU7N
f29STOC1ZduuL9C7+L+5315AwL8qYPAC5nvGZTpvQX41tNnHD+MHOzXWyiwC
yQerok6iD6UXC46fI5ATEWJagl7peTDuQwaBxS1zN91D3tFyIvxtGoHZ9jZj
vx+5S4TikwQqjt3gf4nzYa3dFz6Wjvu7bLnUV0LZC3PciFMErkb0i/ajz/Kv
qCnD92kdr3GLE85j5dbW8MlYfD9UUcq1OI9kXNEjjybwxydGSUrcB9fJ9HnP
kdN8wzrbMT5Uf7fNfjGB/7+P/wJyOHV7
           "], CompressedData["
1:eJxdVGtYjGkYHoeuctjCJjlkqyXUNGqa7/sydY2ntqKieRxWstWgMkIlISor
FEYHLYnLqQNGhVJEbPJIaVpSsrqWZZJ1SDIdnTqw3/7dH+/1/niu93mf+76f
+7ZYGbEwZLBAIFDw57/bpT3FQiBjSTncdfLryQiNVj666GCW9pyvKdgvQYi5
H1lzz5SjZNYyKt4e4YfNh05b1HKURjFcpAjBViAe7zDSkaZHu1kXOSLcvvnB
p8uLo8DojP5zTgjLtl9LKFKxlBHdcl8tQ+iUbbu+XsPQ3WhpdrYLwl1/6/io
coYCD/1sOWE+gqZJ377ZiKWTVceLvngg+M1bJysIYcnpp2nSQd4IAd09vyRu
ZOlhjUFgkCfCnEz3M9X7WVosSFbWe/HzlhwY2d7KUFHz20PFSxGGj+syCOfx
6PSd7QQKhCstBewoMUu3/sh2v7ICwUUmVlaPYykipdzx7CqEYKeEjAm9LH1c
rdccshxht2NjVdhTjuLc5qmmLOPxS0xyzfc6UsFskYkNXz+b2pvmX8ORUL23
wmwlQm7y9szI8Y7UwByMuBKFEFb1tTh2H//+RXvtGb5/WP38BS9dOKpyP+2P
axEsKoZlSLQcRXbHld3ZguB8Y2GGhYijayM9o7M3IeSzul0v6jhyrXBJzo5H
iG3NERsFczTX+NukpO0I24bHd47M58gBx3+T7UH41jZnn2YLR1fPftBcTEZ4
3jGtbkUXS6+9fLgJCQi3evSN+9ayZKJTn9kVi+B/PveWJJ0lqitdb74BYZPP
QO2jJSx1+fQUToxBMNvcZO/M8yEYKN/enYKgnp31V6E/S+mzOu3m/oYgD7LP
qhVzVBJZuSwuA+HPo6/NznbwfN9/EjbuJMLL1APFWeYsaUuamCH7Ebp3yuYc
RYZqj78c0PHz48659XnHGPokLPcN2oYwoLgZGeTF0OpgD1E4P98K3em6pb4M
9Szw8BdEIDzemHcFDjF0klOw3usQdiZdj516gaHS42przXoEmxyr3rhShriU
9yVZkQhOc2Uh76oZmhq/wLGTr6vaK8+Pi2XocbpN2d0gBCgUBUR7M6Qf96up
Ba9PYG6xNjCGoSHVhaER/ghXpV4RNWMZSnW7feM7fr8ya/PrHukkFNpx4ass
BOGet19zp5eEjBelhuetQZDktuV/DJWQNKZfq05EMLXPOTWiy4HEUw+0hPB8
9l3zPW4e40Az6qd1TeHxNEY19N2JcCDtK8vy73chDBq6UpNVI6ZWZVbLel4/
z4xnz4wNxVR8/VFUA98/VTR1R5lcTG6twtA+FcLMpJe7paH2dPPc1rc7eD6f
VT6ZoSy1o3pVt9WHNISkr/X3Durb0QtlWPDqHF5/41cNnx+L6LzzjouL9vF4
fadVND+1JU17WO+lwwhj3xUWjzayJdXEQVbSIwjr/pFN1ypE9H7IE2XTbgS3
C6HaSKktaVc9Z1X8f+leZirnYlvqsa9csikc4fLz1jP3NwqpvqrD8oSS34fN
pRXLORu64GfWXsn75fEXzadGPSEZdl7O1l/A+0tv4Y00xoaicgIS0+UIDw7P
Kq0bJqStG38UWs/j/a+afEIxYE1qowBsckN4q4nPWb1FSCL8pDZ05f2zWV2/
NcCGUi4v1qZK+XwxCNhirGdLfmObrU6JEaouKRqidgpJRp6qgzMQtm7Ilc5u
s6VXpYukS40Q9r9xyNKWicgtz9Q1zwRhTY9RtSJIRMNM9jjcNET43ashbd4Y
O/L0H+0RMAjB9dgk2dsuOxrlzhV9fCMHzbtV7xIf2lPaA+9Gca0cfJyLjlhe
FpNR4PK+8GI56LLXNGeqHOj9SoPwMdVySNWfYm2mkNBd5cXnJX/LQRT2bMNR
CUO565Yu8uuQw9DytpaazwzF+XY37GqTwxPD/sAvZSzJXVMXFrTIod+JDci/
xFLb55mjEvQQ5pf2C51G8Pk4/E70kcE8fl1YZu8yhubrJkUcNuXz7X/5/i8n
hNF/
           "], CompressedData["
1:eJxd1GtQlFUYB/CVZQHZdYHlDnLVwSAUOViNBusL6BpyWcFQGc0RAgUVkICA
lrsbLO2OUlxWJQZxQkIMtmAQIZy3INpAYGBAjCa5VNwhuSQXYem/fezDzju/
+T/nvM+c87xrFxYbFKHBYDCO46d+jh01rs+QCumVjQEJi02ozWfaTQL4VmV3
/Bz8Xf3qY7VPe3IS1J7tjRDxZXDVtAtrB6HGPQe8byIv0JOGMeF7zCyxKVwy
IUmV6xNq1PJ9ZyUcO2P4V5IeodICpOxArJfPhztoI2/Q6xe/h9zQIungb/Cs
UbVW6GdCuljV8fevhoQyY7HjXsEV/Ix8SxNCWfOPqJYlQpp10SnqsgWh6j1s
dNlwtPAtm1RzQsVWHXTRzBXSr4sLTfKQ79SJ8anLEdK521U8P2tCrYrM9PU/
FdKu6YmKECtC+Y161s2IhXSw8qVbng2hbMbfWfgkW0gvfu3lz4dzN73LDsA0
3ZK6YUmo3eV7J4KuC+mndku8b7D/8A2HrgHk/BONkTzYoP6DDSVs57t/fBX9
Xv09NCYoC/v39W94GROq03avWIr8REm2YJ2H882YLHCAGy9PKjgGhJruYtaV
wsn5k7XlcLn7mCATFmswDJyNCPVC7Pq8Fe/vKl02r8b6NzcS5DboX9c/WtMD
9XzOhz/UITfZ6ttcgRcmOk75q/vZecZtEOd7aMIvowT9PIjLfGCJnNgHRobA
7QM89x7cn6I/qiAF9Wfb5XcCuIR68mSwJw1OXItqUrv41fe9ase/nfyffa9K
3n0Dlv05upSC9ecXD681Y7+70wLuz/C6ytR8H3JO6t1rvRxC/eLlJNoGNwjt
rVIwT/MJrqYa6Hd4xajCcTuhLiovRS4iv+Stuu2pQ6i6UP+IQLisTVbkAY+H
L2XfRn3Oo5YClhb6Y5y6dwyuqqJ3v9TE/NlJbj2CFYGihjpY3jxi5YTzifvR
0ewQk1DSHNmxKri9VcR1hpsEnVnWmIf0nyz2fbSNUG4t3HEavrHW0ZUF3/eX
KuSwy1et3maot4rjFc7CwVEDq8XwyfwpiyT44/zB6z4sQo053mmxx7yt1YZV
ctHfELv5xSwcu0u3zxXuub8rswTzuaA7VXQa9WfHeJ9Xw93cymwK+6Uuu8fU
wG2KyOEs9G+5VFTCxHyH1D43noLzRM5pk3D30z05h+Gj/UfKbuYJaafKsSsJ
2G++/1zMfnwvWXPNad8iL9XifMGHL+Q9HBpCvnVt459aOKJZ9lCAfgLaZb4K
fH96nezgZ8jXar40m4PJueTHfyBvO5mucwHfq+GZ4yO22oQybalpioIbDyhj
FHD068jsRdQvxJM91rifMmanAUFeqTGfooIZW4VOgcirl85fqYDLndt1lXj/
jF1icT3Wr4fbOk3CiztGJD64////H/0L1ngRew==
           "], CompressedData["
1:eJxd1HtMk1cUAHAemwO6KAawFHooHQxIgzwmTBhhfFVEqNZq0UGAwerEFLRB
IqxgAaHyEsojyjaUBcHxcsh4bWPAhAOOlxkLLDDZeCgyno6HOGQ1BHf8d398
+fLLOffec+89ufzTMdJIPR0dHRF9r/87mg6W51hJGdWSYdXGJcDyoS1VGzlo
+jG3MxEw9K7Y4AC5aPK3Ht0YQNktEfsuSJkhs9DNQ3LAEc/jzwIoblXIDP4p
AVz9O7PflydlmP0FVhaegBhqLYwlq1F1288R0JojYyJp/C9mN927TQFn1qMi
jMif2zWGSFiADVPisGaulPFpEO2z13Kx8csw1aillMlkOSu5G1ysTbB53k9+
c6H6et8KF+VKf1ekfGFjr5vTJhdZfNdcC5pv0NjhxKwRYMtT0YUC8uGWVs0L
E8BIbUSghupZKg7ROSMAnI85wFeTFctFzVxvQIYVWKmk/WwPT9RXSwEf2Meb
+JFFySguPA2YKhdeqSHPX6xYvK0EPKHrUiqk8QPuDafUyYDuWx/n55G3t+oC
SzIBObZjJh60vuDlQuJEBeBnipgWW6qXSW1h1N2Ah/UTWBW0n6xw94z0XsDB
e8NjDuT5srWUtB5AwZTiyisLqvcYq7UOAUc3h/7pJ4e3t3VElwGe/7VrXznl
h4kXfL4/B+iwknA9gmzNq1QEBQIa3xCPW5jT+SSdrfB8FzDYI+B53x4pY3Ph
MU/HAnB9++p4E/mv4D9mBHQ+7fH+KjHl64hHlDYGgCkTNsw6W8q8Etg/TTMH
7Hf1b7CnOLtwoDiWDyguCFtmc6RMd4H1kVG6XzeJ4Ywe2d0uJvWGPc0/JuB+
RRbaSvz5zoBKebDmA6q/MnNd0uYE+HbVDp89ZPkju+UgL0DvSk/5LNlvZHGW
S/1zPzrL4hPaj6Lna62BELB5b3hWD7mvey8vgCwr1suOJfPaqkp4IsAg53i/
B+Q31I0crzOAWcAPbyK3SypZH1E/r74nz5uj+Q8mp+0yLQWcC2/fZUlxq4dD
bM19QJfvHl0+Ts7JvSMZpPPW313s3UkuN7M970T3Yc/u4BjT/VkxE6O1FG+W
iSOHKW6iZ+h89kfAUymfchwpXjLbkVv3A+DJwlt5YXT/U2qZkfUXgHnmjrn/
kjWmmlWXa4CJOy0t18jph5aejBcDVt9T5rCov5Zbq3dsFAJ63OyPPUre/e30
WBTlN00Wa6PI8ed8XXbmA77MPpbhRJ5IKa2VFgDmX2RafiLX3OnV/Yb6r83z
yOVZstz4/Wn9bMDojEVVHhlC7OQeOYDJS8GVceSBid6GEQ1gzDUXSCdfmh0t
6qT5U+qTnpWR2fm/v+VP+ZZd/Pon5JL1JFkexV9cXW/nUb+vKUJFR2k91pwW
TpLjemt6q2g9dcZkF4fsJSzhfpgGGCfe7+NGBltfrZryVxS+wtfvTcnDd5p/
Tgf8/3v0H7vE+1E=
           "], CompressedData["
1:eJxdlG1Q1FUUxleEWliVRRR5kYSdIsUXzP73z0sqJ0UjWGSBUXJQEzpUu6iM
o7hIDjosqOA4Igi2khKwgquuiRBtinkQJJFxNclUUN6lRTQsXTUF6/a1D3fu
/OZ57ofnzLmPb1JqbLKdRCKJ4Oe/u+Pqoj/1OxC2u2+zKd0Fur4+fa4750ZJ
W43GVaARn9asj3cjrM548NHWCIESxTE7j+YiPFFu/el0iECKnq+2j81H0I4v
9VArBbLXx5knHUaYtG3OKaVJINeA6N+vVCHMPZp7I7hZoOepY/scjiH0WDdr
0jsF+qJSs3G+CYEUeGnyXwI9mhefOIHzSL/u753OjLwy5lqyaxAe9HasjZrD
KEc+ZC2sRpAXV5eVBDA6PS1Jt6QWYTDkSPfJMEb6mdOrVWYEaXGmd6GSUdjy
qjUTzyHAKp00K4WRMUidFlWPUHv+XZ/ABEZkrNXMv4CwNUMy8H0Oo9AXNus8
zs2ivWKamlH0DKfoxgaEfYXeW0J2MfIp35WvbkXQvV2+LKCK0RXtjDTHWwjd
+SPa922MJsRGWgw3Efylv8Y0vWQ05Ob3QtaJEJLorWiZLFJXwQ2FSw+Cq+fU
HV+GimQNvh0j60b4Z0H6oxsrRJqYH1Bmdw/hjuHhQpdkkdZEX3NL4RysFMIb
PhUpNtldu7gDYWZt0gbTSpHOVI7v7WxHGC23H81RieSrdamczvWMhLBUJWev
U9NO5nOOSo/rOBglktr6Ul/Eud/1zBNRKZJiv8uJdv4+U25GGdebZ/msvH8H
4djjagdLgkjrR5+W2rj+OtbW4/yZSK/y2surbyP8nP3E3ht5Htk98d41hNPf
bKq8ECzS9UV2S+MtCHlVjd+NRvM8SW3DVVcRxrxZEW7yF8nsF6R6dQVh9oi/
k0OISB4RgW2WFoREt/bgq1xPLTHK9/H5znZUxbVyXl3p11DC+fBgalzUdJFC
czf3mxoRIsPifqlxE6koaL5l4SWEBfLa1SPjRDJo1qpauf602eAZ4yiStE9p
ruecXOd5Wf0Gz9vZtSSb+4Nyipz8pSKdX+r3gctFBM/7T1XiAKMG7bPHEkLY
fdYZNM8ZGXaPOxF0FkGmn6nTdDE6P3VL13s/8Hk3rTJtqGOkC9J0J9UhhC++
de3kRUZ9vcfu2hv5fjvUDT/bz0jiJfc9ZUDwEFM/TEhjpPAKn1LCWbpuk7SB
719xpD5vcRnC9cG3MiuQ0cWWh73rShGyvg7JXBPJaH14wW/LjiBs/MTzRQz3
1/6R0aQ7hLCi7K6LcRYjrdVhsKYEYa854VG9J6Nv3XS7jHqevy9vYJUXo+Pn
zsiauX/pO2l2hyYwamlpMtkdRBD7Sz2a+P+qn9xWbF+EsDNQHqi8L1BEhVm/
4wDvA9WUGQeGBVpRpDiyvwBBMvHg7IqHAvWqHPW2PQi2wHjdQCPvA+lwYvJe
hBKL8cKPZoGGfJwaHLIRDhhS/Lo+F2i5ek/KSA5CrgwqNscL1HdTV/h6O0KA
1X1oS6hAxy3OlyOyEPQ8btUCgf7fR/8C4UEtmA==
           "], CompressedData["
1:eJxdVGlQlWUURtAISQmDglhiEeFAhSgNTCq8krzMsHOdQOOKhLLvy5hQCKJe
FoEuV7gYXiAQRw1CuJYxiHbKQGRxWGJxIbYGBBwEEmTxWse//fjmm2ee855n
zjnPOcZBsYJgZSUlJRf6Xv+VE1r2aZ3hzCHdYTwrHlBWLukrEXE2ptpUlxgC
qOlVWeOZzVmoXuQCBAFGrG/JScviTG3Eqa1FCPgwLkcQn8OZVpvOSiXhil1S
fHiWM+Gko2uaN+CzgnDD6DzOqi4duvemB+C5220eFwgXj1sI6wWANoV+yf4U
33XXT/2SH+C2OLHVb2LOatr3TMpI38fI323oW85cHZwXWDjgjJeG98YCzu6l
pFuOJQFm/Oyt+8c5zlaePJfYHwc8G2R3YF8RZ21XLzkeiAWMcRrWtJJyJjd+
MP85xUfw7dKMC5zN6ctquo4B+s6ELe0hLCifEFWlAH48+L6DRxln69IiQk6c
BNxbKQ67RbhTKdW2WQRY/PuX23RKOXt+X+yQmAt4rGjyVgrxniVRXS8KALlc
pN5J+XzF3oe0iwEdtgpiCs9zZqA2VKNaC/iB7qrLR8SvNTlKA24DrlfdaRgt
4yzX4g2vQMKxtk8PTxA/O2QuaWwGbJWb2Ad+x5lueuzUunZA97xP3KMJX/d/
YS/5E3CTyON+QwlnPcFlPU0DgPMKx9NzxZz5HA3QOtUHmLmQaCWl+lP6mzUs
hwCzOwSiRcJGnitxOuOAqrXvfHOR+hUyGvHFwt+Uf4s4s4v4X8d3b06fBRwJ
KI0xofx7zKyvKv8DqCgcHe2hehrcfO0urwBGzdx59RnpJXSMPnZepn64SltF
r/XygvLyFOSn1YDS+ULODnrLj2TS+83pKa9mJZwZu19+z0DJEktCc+wP0zwn
PF03CNcA06+EO5rR/IVf/SIZpPdLdT+GeNH8Q26eNn1rCbBxbvHkLPnn++4P
IxUvAZNkcw2LhBOOm3eYPAWM15CMaZIfx6NqKtoJN2jf2Kuby5ls45TA+glg
pLWt4X6KL3Cb0qinfix8GjYtIb6we0dS9wPAXv1FC1Py400P9WXjx4ADBo0z
euT/cmFQhbCD/Kx5YrqV4s3+XTXYSVhSpaKbTfnC2470lQ8CLhpuD9aneubk
tbvNh2kf4v07v6Z6E9Zm43X/AjReun7DhvxqFWx2J6MfcP+1FM8iiq82L3Nb
uAs4GL8lo5f08z1XipN/on6q7QqdzucssMAo1/oa4LsZ9o4jpD/cPbZVpRrw
h+nUK/mk72xjt0n5IiA8MslvIf6owk4eWQIozqnT6ye+YVDfR1EEeKDz/Esl
4luqTUPKya+WFtIyLeLrNSQKeRZg8pq7ihP1r0/WK3DNARx9ds1sA+371KMB
dW3aBx0j/4PFdB9cehKXd5wCLDgTuxpB9+Ny8srb0anEDwZphmVyprJYP9BH
+/b/+/IfZisb4g==
           "], CompressedData["
1:eJxdlHtQU0cUxhO1Ug3GDvKqAUqrUstDqBQGrISF3rsB5BkRBCxS5q4PBk1B
jWgUsFJLRLFiKUYoNIJEGUCoYKSgHkEEZZCXCgJC5dVRUBKt4Avt9t/+sXPn
N989Z79z5pv9NFYmJbN4PJ6Unv++dVb69n6OoNM5IfZaOYbQrHZ96QaCPD8e
bphIwGCfBU4lVFcY9eQdTMKgLIjs2R5J0KmXESJVFYax0n9SnIMJqhnoU5Xr
MGgVNUGB4QQJ1uREDA5haNlvFvWE8vRwrlH1JAYuy/X1ZS+CVlwLDKu0lsDb
4nWqTDuCNuXzT5WFSODaeKb1RyKCDrt/uKo3WAKHnJo1x+cTdP6OsHcu5W/w
1HQz5Qqz81Z5LhIw6GwsztZxKCBeXL7AWALMnUx727scSnr2qNJhsQQ6taa7
W7s4xBfi45FGEti6z6St7R6HpvZONymEErh07MBD/n0Ohd9zbRz+QALPNSu/
rO/hkE6+Q2PLk0CLUL8wqo9DS1pOVOfMYLjwpMol9gGHXgeYmW+ZxjBaLkuI
pqx4c/vw7CkM3Z7i7m2dHOovFSgbBRIoUu5O1dD73oybmPY/wdAaMrGgsJVD
k7eUHbefYzhywtAvdpDq2V949fZh8NgnlgV1c0g191iq6AEGizP8xKS/OCQQ
Oqb7XMHgu1QUcZDOF6MyKiq7ieHiiObzWOp/2NeioewchviGxGy3UTpPhirT
rw6DOiHnggPtv7B9v/uF4xhm7YFDCU85tH72pOfRnRhiUx9FVM9wSO0agzeH
Y6i0Neyzfs2hdc06Z6UnBn3p09M1AoKGVt0wMeNjyMh4Z4dtCIqOXnad38aC
TZywuhMR1HsgLXEijwXwsRJvjCIo7MywdXccC+xWfrw0niBNi2ppqyELN5Uj
KnY/zYM+aHlDOQOBJU1NbpkE+ZjPta8JZmArMu/6O5ugFBtD43pPBprN3lnm
/kYQV9rHengzQA7qk64WEDSe6If8GQYe59vxVqtpHse/6pRKGKgPCSgKyiHI
KDwt5L0XA/OO1uaV/ULQUZn7WWEoAwt8DP1f0vqCR8turOQYwD/J59gUE4TO
r/h2dwkDaa6TT7V/EuS/45CHj5yBbTOqMe9agtJ/jOyqS2bg7I7fh9ZeJcg5
+pxlVQIDSk/HAwAEWTq/2HhkJwMd0obmPPq/m+/zpqofaH2/QWPtJbqvoWS5
nLJFq2t//BWCbFPK+Lx0BkYnvM1HqK697OZ/7AQDvhHtjRW0/tX95l1rTzKg
Ni7rF1B9cuycsEbNwJiLqF1LeUNDZVdVEQOhXm8kJrcIMl5++ZZLCgMr1pcI
XtYRFPfWcrS2kIGBoJUDihsEOWbZm+6irPv6Yaq+kaBAmYv6fQEDIQNNHRbN
1P/Iixgp7R8k9ri4jHK2s8zJkeqSDVFd3ZSDzwjCvCjzjZesKaYcOqXJN82n
+3J3kl2/SdB3ZuzCfbl0/2HzTA2on0SXP+wcKM+v/36eiPIe3Xbwpvx4dRsz
Q/dVWe/wie8lBhSOV7a00X5bckVdiwYZaHPN2riYzveqU3v22ScsfCbeFEY0
BGXMD03uiGFBzq4KqPiV+vXWra1QszCR+nOHDc1L3OaTvdK7LCSv8ctIo3ng
LZo1W9rFwt3lKVKfQoJ6LPNUJY9ZMLAVq/amE7S5GqwWzcHgbjczWLqNoCn/
0UKFJYb/v4f/Ailze3g=
           "], CompressedData["
1:eJxdVGs0lVkYRhfd5ZJhmAiTidLFZammPPs736hxC11cUufbhjlTKqVTudXR
xIpORcVSCkkXlxwnVEiJEVaDJAppokNFiomRGpf5+js/3rXXs95nv8+73v3s
d55voLu/ipKSkhsfX8+EiLOR0hQKSWuGi2ovA6+j6dniVIpty+sFOyUMHpXo
7395iqJQvqtkpQmDM5M1Am0vUKD7y+DJFwRtTa5qQ8cp9pVuODicQWByJTY3
/yBFVoJskq+YIN2b1dIMpkia9vfaknACD3WTK2qRFKFPFDmZ1QSDjtsuWUko
pB+1vcKfESyYGlPgLKZw7koPO15CsL4gaLF8H4VB9MKGilME8rdPA4r9KMLW
9/7RlEJw/52laNSbQmeKit9bJ4LzyhbV2l4UstSx/NexBIuEiR12aygcVN+N
6/N5uLXIX1tS1GnP9lZzJHAX6EWcMKRwn29doOxAIFkcpepsTqFZ1D5jzIcg
+feRHX4GFBF+K8ShoQSm/QORDjwmjzsqG7wIJi/xb4/Qo8j5t4oRbyXY69eV
SL6lKIruq7geRhCv+d7ssj6Fq078NqsoAnZpyIQanq/hMn3roJSg0tWlIHs2
RYJ9Te+AJ8G6AynBdTw/StjzxtmYwGzl6EWLORTtzwdFdgsJXnTXaa6bRvHN
WtcRHV0Cl2kDc0XDHHpyPTx33wYyNevZ5g4OUWxrZWo/j4e6g2t6OLT4WD9S
30JwEBctu+s4fBQaTokTETjp1D68dYPDK2X/9TIQ6Pd/ppHxHJ6kZ6bU8PU/
GZyblRzHYY18z+gdC4JaWZi5hpRDQuHJPQ8WEZywX50bHMkhr3C8WtwDyDvN
tEsPcGi19V20eiqBtGKi9YgPB4GsMd/wCxA6VuD2nZCD1NqnM8WWIKtfFGy5
k8MjpyUXAmwIMtne+dMlHMz3tpdf+40g4+zuple8fvS5uG5FEsG13sEjxZc4
dJZitmEtgeUd5ZCYIg5Gz2c4ZDcSlMbM2uVZz0E41HzEpo3A0VPvF9M3HJLV
r9wtU/D+mKsVb8TPI+Wnvg33iwj0TLrtXFUoypock0/x97OSDHvujXEYNzw9
r2qMYKLbJ+Vqft71jIp94hIGQtU63cfaFGl+QdtFvgx8h/LeW+lQdBYv6Lop
Y/DXeNVUTd4/N16swqcyBgeetcRJ+PeOCdnUcOwEg0laPd3GphROx/2/fM8x
sOlM1WV/pMjTGLh++SgDUcHGn/3ceD+fixAa5zIw77l6zUhIoVbe9qGrn0G/
wfCkjh0UE97ZHspYJsBXemooxWfNhJkBYgEsHmz0f3mY4rb9REV7mwC62bXj
5vsp/lRfFicaF8AkvC+wPoJiTtZ5aakei6rGLS1RYRRbnVPyklxYlMiEcr1o
itP702M//8piKLw2qOUYRV/OWifXNBY2N+57iBMp/hHZubPbWTQeCjB9eJX/
bzPnKEZCWEg36GyewuPszatM76azUFLoWonP8v01b7l4+TQLs6DowuXJvN8X
mqYNPmDhYTI/o0NGMfRE8nTkFovA5ls/5Ofweq9GC0c9WVRIig+rFFLYKcoP
x6mx0DG91+pWThGrOOpgXClAmdj7NuHzbck3n1ucFGB7+dCZpXw9M0/FjhWb
BHD4II+pkVPkzrO1UBgJUK7V1TCcRrE5LDWLWSzA//fff2NXTkY=
           "], CompressedData["
1:eJxdlH8w22ccx9MMG23pujunyhJHWqOZfR8dUZs9W/wKrT70qoTuyiY19WPl
rA3qbCRaXRZarqxsBFPBmqW4hh5Pq7UR3Eg37TY1O6oyNTFVrWIf/+6P5557
3fvz43k+934ep/i0iAQ2i8USwtrYoyrGOfWJhDY98+UxIQjf9Ct7M0pCaMQN
XukOL4RLBfKYHccJDe+qlpkBx1ZO+6UBq0Xz8r37EFboj85bQ7792Puz+30Q
9pG3R3SBruTIAjf7IjwTJknngl444Rwf8g7CH+SWuBPgv/88lhYP7LNq7Eze
4KqEk2JP6K8o5W9PIrQjOl2/KkC4lZXSFJ1MaLZamCrnQz11UUd1KqGPb93B
Cg+E+9fuGlTphN56dCU6kouwrXrJH2UQOk4nA0tsEHb2/6avNpPQi/eTuA1b
EfYMbbCPB75eOJRj9xLCbsrUgjtZhN7MS5vUP2NwVcvgtnt5hLrcDt11dIXB
M0cKmgVFhPanShZrHzNYXZMolSoIjWwTGRvnGBxbPXfA8Tyhc0/q2GMmBnP9
DrsdAH2017OnZonBr3I8m0a+IrRbZKhOhHiDg02yvpjQJwN/KA4uMNj/IU88
qCS0fmQxNxj0LF3FzqpSQqdUbavy5ww2vcHqvVZOKHfB9PGFeQbPytjt+VWE
prSOiAtXGbw9K2jUtp5QB97VIQb6ZYteWbncQOiJTsuuT4CFbQ7CmO8JLdbo
Wt1ZCBvqdB1nNYRKD3mFz8N9pdKybS8D888bxH+tMTjOxtvE0RL62omGyik2
wpMPreoTgAPcvuSbQbw5v++7z9sIHdisUYb9y+D6mdXi4E5CS6xt4l4sM9jy
9X3lrsCbtE4iMczrqmRZPU8J9X7rw3IT5McEaQbaewlddpE0z8K8rvj/5JGu
JzRXa+fOfcpgi3Gl1wzwqcOR5zbmVTlcrW0aJHTX0FTcC7hv7VLy8cZ+QtOn
HdmqTQiLb0TZqYAzWNeYBDPw455Fh2SIf3f06QTXEuGOn0OzdX3gP2Geo+ht
hK2CVzjHhgltCbcZfhSLcMvEGc005H8a9nsmT4JwSDOj0AO7rj2I1WYhbJ61
8HzsR0KNW6YzOfkI3w2wSohrIfTBPxaFg6cRbpy57WFRR+ivQSbfS2fA3yuq
MCsVoeyAPfH3MhFe12YvaGoI3S3t3umQg3BN0kGXjArwT2hZ/t5cOO/uLwRK
8IOum+McAPF2l3/oyQA/RQhs07qlCK9Y8QOvg/8+G/za+lAGwrxL4hDTWUKd
mlgFraCvn/KXGeWE/lakai5IQXhr8Jb9AhmhI8b3er1Pgv+bc2SdoJuEIVEU
6itCNRd/kRI63GN/eh3qmd8/0mOE91ZjKG/TwTwcL4hdK+D9frvM7Yj8COH/
/w//AemtAe8=
           "]}], PolygonBox[CompressedData["
1:eJxTTMoPSmVmYGBgBGJpIGYC4u6c579XBqY79B/6qhFTH3bgwKmFrtuMEfxv
GjH9h0QRfO12sZvnvqfB+YlPLyjdvongT3UGmrgbwT8NNO7zXASfAQQaMPkh
HBfd2VwQfEm/NWkbOBD8+5PbW6POhsL5i24mLWGZhOCny9sdXheG4OukSj6K
kA6F268YLLYiQC4U7j5RR+E8D8VQuPu59AVMHFRC4f77J8P7y1w9FO7/z1xc
B/S1QuHh8/wHW5u6bugBWPjdecbsI2+A4KuY6Rz7l47g57aGONybj+Bvu1Kz
a+91BP+/8lKTufxhcL578dl1Ne4IPiy8AAhKxoc=
          "]], FilledCurveBox[{{Line[CompressedData["
1:eJxd1Hs01HkUAPAZHTRlxPxEShGRSY5q9lHWNHfkUdFMO63Q7/crSrNmaVG0
bY7KY1lsixLrlZDSxGRQ0mt+HlF57IzHRnao1DFJEYbpEPvjz/3jnns+5957
7jnf8z137eEQwVEtCoUiIGM+s961UngiFD5HHpw2uk6B5SGdC2bXRc7Me1lj
BnXe7qWrxubt5OvZpcpEocLr3Xc8+TRHNEy9EduIwnNBzsXjgkmOQ5HPz0wF
Cqf5SdNfHaHApO8t1t+9KPyudivblKcNHSWrYpn6GFx3cFymPK4L0qmE9ljA
oFFkH5a4kwaLg08srvXHwDG0+iwxqw9+Lw9un43BYP99i6bIAwyoy1Zu6Y/D
IKb5J7GLLwP29FFY86bO7Fvw2JMGwdMUDN7YT5bQAhjgXLW/qiYHg5XsYzsi
ixiw+6OXvKcSg0X54Za1nQhUvCjQ0TzGQN5W1vjE1gjCvqlzFzVgcOSt89tD
4wh4SlYERNdhkLPGKL3wCwIsxR9DWbUYbNlTG2GRgcBWt7QF+w3Uhsxb3znJ
I5904MirCwN/IvBGUjN7l/RcGMXnlCMCA52KBduccF3wu6FugYL0I8JV+ZC0
XGWXpySdtTNw2eBWBLoU60tMyP1U7rOsbzchkO3hx4yux+DX5ymLjjIR6P6l
fDSNdGjwaU0ZadvDd2i5pGnx0pc9pPsTq1Qa0sesDjjpeCHQyvcbzW/CwNtM
T24YjMALeyTFqxGDdUs/73+RikAEdn5491MMWtZb3/iUj0Bbe2noFOluPaVL
QRECsy2P4x4+w2Dickj5v9cR6Fh0mbVWjUFNgMNH03BjKHE8+TrOHIczG0bs
vMEUosJ4aapdOOwYlYjS9cxgcKzL5ZIPWefWRn5pNgV+OK7h/ojDvQsd54XJ
JuCdvL3LJBcHZll8A1toDHihecUHOQ5/NW2bNuIuh57uXrPVjTi0Tkz7JvCM
YN1vdHHgJRzQdo/NpSZGYHlQhZYn4KBTXH9ZkYjA1dJ+T88iHLKVVyuVQkOI
eOTi7yTEQSQVFRuUGwAn/XOoMen4XCJ6c5kBPBD7FHw4ioPbxuqqlWIDGHwQ
FNEXjoP01LY07QI6zA1/mSnbhwMd8bDOFNOAN9jZb3YMhyQqY88VjTbkvLpZ
lxyPg+5od/gNNy1YYvx6WBqKwyurK6ubbSgwml2g9SkTB1Z9K+8mXcN5bu6/
YpMMB9eoOw3nckY411yjLtwn6zGKqBHrgfeck0FZeu7kvMzadWXzBhUHa9eN
bg7CAbY/+j5eO0bG3XZSzSffT2rS4Tl1TyXzfyu3RB1xSLfawZoImJCdTbPb
K6TjwL9vRgQHz8iCVMKzFjbkvr2prJI0KtGbVFgaZ4jDbfcaVzGNRhi2bMwb
6sNA61ah+tpWOrGLXn1+bykGtksb2xWVBkTPXLH0cAEGdkLmbHr+UkKdmKll
f5z8/3UVA/IqGmFglLhvyhmD9DVOT/We6RLjc2KrptUY7Mw91GfPWEL8875l
PEODwrRp7DjvgB7BlzBTfT+Q90bp4GXepkM0ReR568hQELDzMQlXl+CwDc0r
U1EIzNMPYN/WJSarD2UJklDwMalPDmdTCckWCTIWi0KK5YjQO1ktG1jfwHjM
R2FGbRP/5uqQbPETp8w2ZxTO2WbonPkhVrYx8Paq7q9RuOsydgmWDHHKS7j6
F8l+G3qvRTFzivP/e/gfLTlb1A==
             "]]}}], FilledCurveBox[{}], PolygonBox[{CompressedData["
1:eJxt1H9Qk3UcB/BtzalwMKl9Q0CwnWyCWXnmbd0J53NPwkgcw0UCnoBjAwfC
hhAOEc7GAmG6BLPkpENbWEQHLQ2Ijm5fEQIqqQQUjHYYZHaHdWMmrujWe/3Z
9cdzz73u/Xm+Pz/3iHON6jweh8Nh8fjfjRbjVxl6QhdDZczUEyyT6+VY7BpC
zYXvJfg9VtUYsLyPUI/3g4mm/3HRpodpt+DRxBuqRli/ZnKX31nLxf966sN2
x6r9hHbLbPe7H2eZrqjZtsFMQm117OdvwBuTO5cisgiVxh/MvxrCMhKjsfgc
6tem1BtD4VLdc5IZ5Mf49wdb1rDM9eN8YSTybdn8W1L4YmIAPZ9N6McGwehu
IcvUJAcqR1C/NHZNtwLed2c3z5pDaKMpY3EgmGXG9SEt0wcI/Uh4W8OD1/pq
3tygJdTkC/7LE8QyS6vPb7+QT+glnUu1FfmksizOkUeosrlyowMW1aqHWg8S
6nS8y+zE+KOfyZ2aQkL7fq11N8BJTQHawAJCC45OpFjgqVfk190436NZ4eEd
cJDApupF/WOKrC/bYdermy9FlhO6Sa0pEmO/E0/nxMUUE3r58JVno7G/mZtP
tp5DfdtcoS4d3jPdYykqIrS+7qlcF/zncVlMKnIBr6vcAwtMqfNthwgNTpDW
RmG8LjKiuIv6wSv8MC488/fs1iwDofE9eTQT1uTG+05gPnvqijP58KdW1vwM
nKyyG9fB2789+0sgxhv0WqO3wKu4vt/nYEmXdv9huPd29B9pqBeZ+keNcMTw
o5PbMJ/8x3RrA2zvUKpVyJ93Z1Q7YZ+o+kEc5qeOZW8PPNwuPqBFfijeNvQa
/II7bMeLyM+UrdxbCYf8NLhsNhKa2mu3zMOhN20mBXJ531j5d3CSuePIIhx5
qtoQhH460SCIrSgltEq0mpsGs46XRvbANerMvn54L5P489clhLbI6o99D5ss
+k59GfqJH+J5CC/8oBJfhvvtuyxNcMm8VOiAXf6+gRmx+07SEfSPQGNYgi8E
pex0whXv1y2UwqkcaY7fVeMPprno/09iee+4cL+M/HRUOCwaHlq5GfuZvdvq
9Fua7ekYw/35FhTWEXyfHlldU4n+6Rye0t2DScXcb1/AEc1m4w7UB6+/ek+J
9X+j6Dwpg1+epBffhustr8fkwOsdAzfycB7dj/oSS2CtpPbaOrhJ6uK2wt4B
p3Yc5x3LJmwpgCVhlua30M/CidjTBvi//4N/AD9rvW0=
           "], CompressedData["
1:eJxdk39Q02Ucx59nINNgKZxKnqAHBhMq5UdcIuP2nTr40g4tzsKgwyMIQ+Ig
wggUx9YvBL08FFyA25TYBQsOpkIgzI+sxRgQ5Bg5BjcJ+4EkFKQOW9THf/vj
e8+97vX5fJ7v93ne34C38pLe5hBCRPg8WXN3Pc9zPUMh0ujn7v8Fy5yMjPV1
CSjE8L/e+yyyrsTYyiZT8AkeX5IqWIZMWT3kqRTGpp5rGqhhmZaxGxPcAxQ8
DHnLK9UsYyo/p87E+v1HDT2ByFujy0//k0Nh1an78xTrHU32F71lFIQCTcLH
6Cusgvi7xym4JI8cC+j1xs6btecpDP50teabCywTN5w80K/E9zE2ixTIm9q9
X9jSQKEvPttuxfq6w9uv/2WmcPqxNEyCXBgTrQy9RyFh01D3BLIiIp+RPKLw
TquFlWB/UavYc3ScgkMm8Q7F78mx3E7zxP5jvFnNR7UsE+G/O3YB/cs8U9dX
9SzzmnWNwT5PISW8c7xAyTIDlX96xBIO+OyT729BzipaDhet5kDbcIC7UM0y
P97cnqRdpnAwdDFqwyWWUa7UEJeFwtFMl9qC/koFm/brKIVhuVCXhz5sbYQ0
RoX72UoDm1Us8+HC2kaulEL6d12LK8i66oYOwzHst5Q2KpDne5qvpORTiDIk
f+KL89I2cqc3Z1JQOLIjZtDz52Tq+0kUDitDRnxxvudm1rcujoJE5bVvFXKl
LpdrYylUWTO8i5E/8Lt9J3IXhRPaG3lnkNeEW/nr/SkEtWa8+R7OPxv9uz7D
SeDzfzmiMmS/peo6twUCzry0eifu98DS29SgJ1CcWzZzAv1MYoW4r4WAtG1P
WR/6z7Z2Rc1qCARxrMJyPC+JiRtbV00gM7DRJkD208kK27MJeC89DA/D+qFi
9yrPNwjIa9eF9KCXK09qR1MJMDsnu8KQXR0b/dZHEtActAhvXWSZv0Wv3pvc
QaDXGiKexvvK4Nl+JsEEQque0n+LLHls7Hh9A4EjqQWy/Cd+IOvQOJ9A4vvT
D7uRafzT/U0CAouvmFOW61jG3cco7A8kkDN0dmQU89/uTExv3EOgVD1YcQHz
ol2Zm7waTcCUFFWZjvllNOu2ORgCCd1Zi8PnWeaS01xgepfAYKlvagv6T5cC
3MZUBPjqU23T6LfdKvxhzkzgN329rRXz2Sye6q2aIKAvPWKUIe8cVSSM2Qm8
pHLUd2B/3LWAa8Jf0GuLZ2XIO7YUkZI/CMj2unkFY7052kuUPUPAi1cSJEW+
vPt70/E7BFb3srpDmPcDOXfdO/G+zNdt1lr0qnNi7ZfItSNd9gfo/////wdp
EOap
           "], CompressedData["
1:eJxd03lME1kcB/DSKgutooIaoahbwZViUWZXSUhBprIqssGJrV3dQCECpS2g
eETURleRQ4MnVJFLJcC6ARa6HGZRFAfvANJ4FEQ01hblKFWoZxGa/fZf/5hM
Pvm+N+/3fu8NLz5NLGcyGIwwPI736V+sC6alUPS92f/sDBogSDd9cE11MkVb
R23XQ+HmVvvzf2GB/a9v72FPZUDLXHiLjb33ySBBKlXN7h0qirZkCjg/wV2P
ipK94R7L5GYFrArtEZcoKdr3UODoiyGCrPK64VUGd1fLPB4PE2QeO4Ejgi9k
F15OMBPkCsrVxITTGz/dkiC3/1Yr1isoen2FzBAFJ9UpEg7DXcc94izwuf72
YQXcv42R1wvPNJiYOXBES7obG+slXdFaryVRdMHZFt0Y/OrOSlMvrHBJ3e0C
ewpE5hx4XY8wPwP1us7oH54FR16qz81H/t+rleFT4dgoW8p05FmK1Zo7core
L7ylakM//OTicC789G6Mix/Ga6Wd4olEip7zo3zhTYz/PSnSnIZ8nplb+KKf
IFv5G0tewpHRTv5tbwhyMJPduAf1+kYw8n9FrtWMNzTBbiG1eR5GgmRtlXV4
oR8XswIeNb0mSIM6VhgPa253mvTI722S3u6Fl/wwWRBpIkjxUKcxGf0/c/7Q
qj7kM86Z3dUwjyPoM2K+iudU4Tivnx/IsvjIP283Fo/B34xf+sKR7ypcwFLi
fHWn9yw5hbysaG7Ndbg4oKlLAk95y5Oswn3hNA/YnhgIciQibKk6laIzV2+o
ikH90mALP3gbRU/E2owi7I+xNoezHC4djeHPeUuQopcba3UYr75axJ2PPEhf
ubgMnvjjqD0RzlW3/e2YH+jdKhzE+OJup5RAuFi59tMJ9Htk3kR5FfyOW+Xi
OK83W/xM/O0U3fq1PDQWvsyK8JGmUXQUVzUlHffhIWvSXw4PHTzWEIP7tUMU
vXsE1uTc7KiHtRm17gI4SL8+NWCEIAN9nDsWwaz3YSe74eXJpdaTcPO+fboM
C0EecL0Wb8Z6zhtmCevggS5mRQYcrfHI34nvxX31blwH/yldtskOu3vWV19F
vSHjcXVr4KzxMatj/ymXTt2fhu9XHoyXXIBLQ+h3OtSbxikYZsLR/u2MGlgi
VHJ9YbLsmdaA+9X+cZQ9hP5nS7c+c4bZA4kfjsChvrygSew/wUm25gzcYM9+
WoF+ff9//w9mQep6
           "], CompressedData["
1:eJxd1Gs0lAkYB3AiWo11aUTpIJQZM+/MMBMziOeQ932nGtW02k2iGwqlq6aS
cqmW2i2ji3Qj2uxRiXJbXZ4uVlKk6EJkmaLkNkK7NHb26354zv/8zv/L/9Mz
c02MPGyCjo7OEu39l9h5yOx+PQX5ZU/mRacTaHtnIOjaGAX7hspiir0JPFPH
PLG+j4LI6/pXre8TODSbw1FrnZPdHbHsHYFUz5ta+SAFTdy88tkfCHRceKVz
XE1BVHDuUHA3gezhg4We2r7D4bbeqV4Ci75PU+lpvSk1+ohvH4EpHUYSHa2b
N7WwjPsJtFkr7grWusxKfadtgMCSKbNmpmk9LFydZaom0JDLnCc2pEGcc1i9
JYTAwdqxyirt3nCuasWGES72H/7te9lrCi6b/XqzoIOLqx52UNkDFKhj/kpt
FHBRWYuPajQU+G0IeUg0crEmwyluxSQaYuSHato2cbHygOzaNu3+3nrrXgc+
B70DnWV99jTwqPgbSXkcjGv1U0R60TC5yzkx95YzimRC8aVIGgKOsw9HVDrj
vgg7T2YCDYYj5ce+PWZjXP2DHS7BNCRH+KY/bGfhNnlApI2ChlCPkfUVoyyc
s29h1IuLNCgtO4x3dzlhHPXLdy4FNJAtt5WZ0SwUudVFF2XR4GNZFDpDysL4
bY5eZC4NEuZp5u5kFqb3vPp6OZOGH65MTy5PYOHPVaIUQQYNqU+rirNPstB9
KtMgTGsHi6iVJjksnHXyeEXdPRq2v/9WzS5lYevE+UbcERo8NIFp1pbOON9w
efIzYykEHN2vul7EwdJJ6zXbHaWwzi7fnQwg0MFop2KapxR2FTamNn/kYe3e
JFAwpXDB2ufvVRo+Vn/xyNAbpCHn09j+K208/NAnmfyylgbRg2xzV2s+Vjkt
rbBooaFT9mnzNFcBXgqNjgrs1vZ/JL0+/VKA45rW0qibNGTVMzJiaRdUF/Ad
DEppYAjjOQ5sVzT2ZiWFKGnYf6KrfpeuEFlP7DpKNtIwNCJXPHsjxHlB0/xM
pDRsCLpt41QkwtVdZjkRjjS8u+VUuTd1DsbFGunhOAVyW2VUwxo3zNDXW2vV
TMGfCWNmHE93vKEcvb+5hAIPVXhZwhQx1tl9sa9Oo6CArA953S1Gr7f+devm
UmA4JVoqmi3BvFOn9uh8JCH0nYHo2CoJWiz96HT2OAml+dk2nzMl6N0Y11+8
gIS8BjeTLQskGP6jaXndBBIyv9WMD42KMaVwYOLzRn84zeoU6AeK8eLQAluL
dn+4K+UFNe9wR5vYE7nZd/3hOXd6XL7KDc8Mt7J55/xBZWJwfs9SNww3H0pc
hP6giF+SqFkzByXtTZl3dElI1bm8c+CqCBlFWET4kXA+cSxa9VWInSVjPgbO
JNQeYiy+ay/EexXip62mJGiOzBBmLnTFc7g9qHTEHwRK7tQdsS5o3yTsf2RF
gsKTMdL8QoB5g+oDTRISUNX9ytdFgNXi7q8NYSTkNx99rLdagPGWK66WXSDB
yLy5Ra+Nj+59vaVcrQ/uHRjtmaXtC+VnNQ0ktDOWi3OtBLjR1/RlcSMJ3K3e
HNsjfGToYmEEmwJZx1bLW2f46GXOX9SpoGClPGrxpzAeyuom+lTspGDPpfqU
3wd4aPRP+HBDFgXnDBhKb10+nn+6aOragxT4kO9rrgfxsG1YP6WnnIKb3u8z
uEEEzk3/XPW2mAKC/fynZTIe/v///QvNhGon
           "], CompressedData["
1:eJxd03tQ1FUUB3BYlkADpFktZAERRl0XHLi/4mEPuCKLLII8AiyV2Xh4B1Ae
UUzsRvEIVobHgiwKMqbDuhTvBipAm4YDAdJjDKwEWiOWQl4W4EjKyo4dZvqr
P37zm8/cc8+95zu/3+6EjKjTPBMTE398Nt9ZV/uP/uLO6KwxPXNikICP+Xz7
ygFG43K2fyzsI2CZl/3s67j+fsv69JkOAqev2Q0dRwsuG+gDDQGTmLu9xZ6M
po7qz+wsJMDvcGNFLzFaNl8h9cohsDAlr3P3YtS7Tl9/sYBAvp93eizaIUXm
YYb1cycVlSq0TjLj8V4egR/6XbI70VlqiwkjOjdl9voltEWPrf+JSgJPeAr9
LbTreojznioCsi3awb/RvDstcQL0Rkz+cjd64CzP6nvcv2JMVk/hfZQ1But0
vM/21Nr8FB9G66Y9+vlyAn5jo/UGX0YXWyOkAYkEkkSF6hE/RksOPrLmZRAw
VJku1koYTXjQOqUMJ9D68FsaHcyo2ymJly6ewKe6EbegI4w679UHOKUREJRU
JK+idxwWNcbmE9iyp3DfH1JGl+Kyqi9nYj75OwP4oZivqmvyfhkBuzDH+qYo
RuNXFIpuLQGz3B65aySjzbX7H4UOExAlPPeNTTSjpkOuoW2TBKxHz1oLsb5b
ffuDkFkCTYvy6h/RnV9a3incILAmmWvQYf0NTY1t21YOLiXKjxtjGFUkD75d
bMJBo3bmRHAso1sPvTHehU79eV5xDvdr0mNf3O3CQcvt58d9N+35UbluGwdJ
0oz0gQhGj+h3nXzFQEB9TtzwFtpcJftpap1A+XXbiKBwRqvNhLnPGNGygS7X
Y4wWXIkf4uN9RpZHPv8kDM93tuYp0YlWkWIl2iN8rjQK+7VZ/lV2A+22+p1/
4GMCqlGx6go6yGHDpvIfAjFhttky7HfwfIvPF+hm/05+Cfppy0jFzTUCpqNZ
izXoJbWPUPmQQFE0reLQd1f39kmWCexQOV/QYL/9v60W5Nwn8GezsbwAzZNO
9KjRj6+FKYqwPt7h1Mv3cL/Fwq3eC7h+LLCv+0M8z+6d3Dfz0Jr25eQSnHfs
XaG8GO2072Lj3BMCB9wFk5v9XSQds7/jfCqd3P0m5pH52meOBPNwnFbXdWJe
21LtM5Q4r0A4Y1Ma+d/3Yc/BTNKYeGEzn8ivZOZiDlJE2qWcEPxe0zzlTU4c
9Jpe3TUcyKi2Py1Nf5iD4PYyb82rmC8bPv91EAe+jS/YZotxvtKGe2uOHByy
51uZihgdj6K/Pp0h8P//+1+1cdI8
           "], CompressedData["
1:eJxdlXs0l1kXx00pTSKmMhi3H+mOGEL0s6WawsJ5phrPTX5uRaW85DIaxZC0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           "], CompressedData["
1:eJxdk3lM1EcUx8ESWVxEZn7cWkARhMBSwtVyKJNAit0BCjRZryJHQQoNolhX
iuAiCRbkyCIgWBYhEl3lFKxSDMrbNlkrouwiiIIQSgDRUpRFynaLbsd/+8dk
8sl73zdvvm9ma1JmbMo6AwODXWx92NMevsreMYTAYyitINKSktCEwLbxeQSl
hVuzdBwluS6NnquTCLa9+/v4FKYkK1h3O5XFX2vrVh4xTt8jVkyNIXDYpTsy
xthjbTD63AwC9zB1ZCui5KsQFZyyx2Dw50DtxCZK4icHQg0Zj3w6op80oyT8
wWn7dB8MzXUlfX+ZUvJD2Ro/KgpDt3zld6+NlPz78G5NajqGqjAyeJ1PiW3M
lNYvD0PT9ZJLxhsoUQfM8PViDNEXf1OuN6HkTnL5bFwGBpOSs5/VM5b3pF90
YvpqI41/PuPe+UxtpQRDVscOy/n1lLQGn3x8oQhDju9I5T+MgwarXvBPYpAP
58tKeJSkBtipf8xn9X2+UGcyvV3NfuGSDINsWZtUxdglvs+quZPd70iFoyHL
F064Zaf0Y4g54Nt+n/WX7JC8z+slBq+rzqY9jMOmrvkvLmOQTp/wfMH0FtmC
3KeLGL61KeoApq9WtLbEvWf1ftktNWDxFlXgl39YcrBbFj8pMKYkqYynVAg4
KBUYBbiyfOUF8RNuAwdGVinjZswfR4Hb0F57DsQFl+zDmZ93pDxvuTkHC6LC
3mHmZ3viGSVnyEGGxfvOm4xzGhY132gw3KgXJgaYU7K8T1/ftIDhmZ/56Wds
/sXx0W8OrmKwUuhFXex99A3GdbdNYzgUIlM3WlMSFWwaWz2O4fnx/KO3bSm5
5XjZqX8KQ51Kkm69mRKz0uw11wEMM8ZaicPHlIQ8NtQLL2MgJnk6W3tKmqdz
Gx9kYSjr19glbKPEfaFnqfITDK5LPdyCgPUXLUo1n0ZQOyfitXhTgiZWD3p/
j6C7fefe7/zYeTGaV1uOIahRcYURH+JNpXHhxQjk5Trp1x5sXkMV3d1nELw5
nFL8yI2StOJAG5EYwVuPNnc+49Ec1bs5CdMXSA4oXCk597wzLyMHgQhqizDj
uZsZx+6GIri3v8z/qQslvNHlMRSEoGv2irXSmRKvTbqiqEgE58snLQ8xDkq+
capciOCo1HyWv52Sw0+2e946gWBnrYVDgwOb54qv1UesflKHwnSU+eG4Ljam
5TyCQd/en4O3UOKsUK68/glBwq8b60PtKEn83KlhTymCjnsvpYT5e1XjYqev
QLD5/jAXYcP89Bnoi+hCUPeWJ1Gx+fz/P/8HliK6wQ==
           "], CompressedData["
1:eJxdVGs0lWkYdZmsqFymUEMtNbnkcM53Pt00xS5SDImH0hS5JJVJiU7RhBIj
XTiMIjJH4zqJNBXFFDm5RbE0ipJGiEq5MxgzX3/mx/x41rP2ei5rv+/az17o
ecDRW05GRmYbF59z1osqXkU+gxDtOrH6OKF54/41qTuECF4zWKc2RJhxW81e
pMhC5DZPSfkjIWj55oiOGCGSNDbLe7whTKT418+RCgH9x8lP2wlFT0frh7KF
6HLMbI99RvhpzZi5yI7FqthLWmNvCWpmnxaubmVxcOpg2uqXhIigGBO7RBbV
BhGCk08IKaptfMlrFmZBLtm3Kgn/xIorjpWawO1b8XqvMoK7mqXbVslShM6v
aVctJjwQjwyzYcvw8ye5sHs3CQu25T9XT1uKKzpOEe3XCMd09hSPlZkg0yEj
WiGL8OytTuqLdhY5J0diDCWEjBlb1hZomMAINWYh5wlnKpYl2dazSPaedljm
LKFNV796yUwTlCw8p5QSSRhP/VD2D49FYeH2OPlgbn5e1049fxaTO6pC+g8R
HqeYF/5pwWKfZqPtqDshZvl5lzMJQlR9XSRmvQl3bAeqpI5CzDjk8THdkttv
UC6XIyfE4sjGlUoWhJGA/JVrrYRQtQ2FcDXhC133J6yUgUXgdO3TJgQXt+wb
r/SESAwqadEyJgxvj3hlZM2gmlU2r15MqL8lkGjuYTAhWMjocPWrX4qST4zy
cSC90iZrBaHigHfHj2oMWuVIc5zbv6JJZWJTFgMbj1dvbNcRzj1RtKp5JsDY
S8WRtrWE3IHBhBF3PrJclk0P4HCdg9ipT90YLfa+5maOhN7r/NnvaniYtSFN
pOhFuG999O1wqTGmIs2DNnE4pr2sWLZQgL6K1mPxHF51fLAhMYGPjwqitFQf
wltN3W5BoDHeWylX5vgSwq/fF3duF2Dm7Enduf4E8eJrl+vSGBi19ZyKFBE6
JKeSbocLUOKsvGsogJA1ljfaUG4Mu1rWwpPr37u52blX3git67Yuqvcj+Esa
fBzm8+DoJ953PpwginYOZ5qNECj1zb4SRQgObE5V4fhc+Mqq6/Y5AvL5rkcM
GNw5qLP4URxhXXrfu90KQryoGPdou8jpPTq0Z8qZgaudxV/6lwml2u3SyX4G
eUILs/IcgvT1VR9HAYNI8/Lkw78QYq3fz9nczP+vX13jpcpRJz5SZuvk52YQ
MjVkks428GFzLcUzOJuwP/9X+YfX+bDrLUjak0cY7fBIa6o1gr9OtYNuGmGD
jTQjMNUYhQFXhWwi4btHiqG8Ch4WRft57uf4+tnau7T3LsFZiTA+m9OvobUF
e9reAJgy3lGQzv33+hUzmQI9DG031L1bwvGt9O+XLdSHyP3TTV/uniTWuU2N
JQYY3XXTcv5dQk6dtWmOqz6mxjIt90sJh6KKTBMm9fFm/MjxrnpCZ+d4VI6f
Ht7U1fMTKgjefPVS04262Fv6UPDZH1QaupU9n+tBdc5putjN6T+gxDV6jwGK
fGyP1PUSvDRic2+MLcHOYpVk+UHCrDteEy1RPCioNN4zHeP0uSJT36iXhxkZ
nSMnuLq26g8+KhaGaH4Y4p74gSDb45A1kGiArC7NmrxOQq38Ff+Be0uw1F+h
ZSWHLywY+GagwxClE0M9Dzq49/1WPFLsaYjd2iFxF1oJv3tuTW+caYTuS34h
3Q2Evtauc/GpPNQ4hBnM5fwM/Y6Sab7GyNf2jY0fIGxyCjOVagkwqbUt9fs/
CPkvtuxdu5vBRq0NueuLCHGHW2WeyzKo4qmu6Wki9CyoYlpXCbBhdXPd2WHC
pKHStNtmDKLv1Zb9Le+E//vvv4eLhRk=
           "], CompressedData["
1:eJxd02tQjFEYB/BdbFPMlok2NlG7tandXLJqtVuOGZpKeAthNmlTo6ZWZZSZ
jFBJN9FUuriMYTdNd1NoK7xIZWVRJIUyKUbZCRORLf+++vDOmd+c5zznec57
jm1oTED4LAaDIcM3M5b2KQ91raZoriFCEm5PyIjHWHbuGorudlul8YctOCcD
T8E3VtfwTQWE+DberyBwzk2ushbzuyU+P9rgMlZm3THMc2m5zQa4MbA7Nwm2
T3YY1MF5LyekWlhT/zz17Yy1MaKUmfgsptJITNFPlllHbIObDr9TL4WfGhKd
/OCpbfWK2fCnAi+HUjhEHRccAOf0n5COw+/9zqv+Il97fv3pUAdCOivbesLQ
zwfdqdxg+MCTss9JKylaI/dOkDsS8jjEZv9jZ4oOWVFUzYGFlXMf3oKjPavZ
Fk6E9Pa4dpvBQfHW5Y5CQm4bZLvU8OuWvYs2igjJeF+0g498D5qjB+oQr9YO
h0TDcbM912cjn1/jkaUCeEqsIjth24/N02dhs6gBw3XY+tmD3yvh5H1vmsaR
f2odx95lBUXvZ4XtuIv8Wecsdo1hP7eoAlaDMyG30lP6FbC7F5tpBftKj9u5
wse8q/0fYT1vjWWDTETRxcWeAwJ4mDuvxgdu3/KwNBX1mUtN5DwhRZ9xT5Uq
MF/ofO3qUexvdNG3ohXn13tJVdON81qcHynW8AgZLKwdlayl6OnLptzaZYRc
e9tm5eRG0bFMdl8T/DNsT1Y5PMIRTGy2IeT7VEafi4Si07hOUcSWEJPscXYH
zL+XlM62IyR+8uc9JezHbGlIgGV6tXs1XK+ukxjDQpOSgXBYKw/75s8nJC84
U+EBr424bN4Kt4+rlS7YT2R9R9iB+jQcZyJ3peiWXl1VK/zqRYdeBa87pKd9
4T08o9hIxL+YnB8+00/ektoKHzhRGHRFj3prHCw+H0Q84w/P6zDcyU3Zaox+
XXXMd99h1mautwx2/NLhYYd+DDcVGi3uW9LQhsRMuLKqZ18C3BnaP6cA3lRm
LFDCy+MOxKrhyZy0CRHWf927nJUM63gxC8Xwgvl5sbao5/n2ro9FuK96Xa/S
Ev01dGVPPnKh6ONDv0ZjcB5Glml8PszYoiuJhMWqoQve+D/l5R+iU/He/n+v
/wDeGZvg
           "], CompressedData["
1:eJxdk2tME1YUxytkVhAnxiEqGyBYmOPeDBAYmA7OFRSsCkRGNlhkDIto1g2Z
HZONhlECRVAqqY+qhTaFDQQBHe2Y0IzqlD2aNIhgHcQojgla0QoCndSyw9d9
uLn55X9e99xzNuTk78l14XA4fDyLd0ZX9TcDHQQ2tQlFx2cZVBflOR8gX79x
fnvjHAM/deRYQjOBk03c7Cw7AwI8u62dQFnh+7KJlwx6DgSGcy8S0LqXVLzn
YNB74HF/QgMBSWB33l7k2E/HjEtbCQBNVU2+YrB3hmdMbyIweWefJMvJYFaj
eaMN44cNGmLNyDbV123mTgLKtaYXO5EPBboPhBkILNwZvvzbAoPf5Xavz4wE
TszGGTNRt6znZIegfeWTtw8rMV9labtkiZ7A7bmKvPZ5Bqde/qhLMxEYKvrA
cQ853dp5xf8GgX2nH6T8i+85nZP4d+oIAaPwbIQD3/OlLkXUYiEg5fcUW1Fv
SBz/0HyXwFpJdkAM6vsLpVpfK4E/w5wBK1Cvmaj/6vgsgVvLEoct2K/8pKQd
ulcEYmoOdjVhP7fM/SrucxAYvKI96TnDQNHo+blogUD5D1HSeuTXIn4q/oNL
oXRqoNnnBQNneq2PHPVC3s+JPOSgzWV1XA4Fj0c2z74pBmJPsa4F46++qigY
R5ZddXiFzxPwNsT/0438SV59lwdySJ3OS7Nobx0u0zsJbDhiiRAgX3r6kUjh
TkG88czCiWnkeOuZWNTPPXL9QmrD/l+Y6+AupWD2CS4ves6gxHuVf/0yChdu
mWKuLeqKjMNRWO9onFT2+mK+rO8kYown7I12cUF73sVwuwbt+UrX6e2o80d5
0TMrKPjcVX3fi/po/8d8w3IKfcYtNX6Yv9mt9lrragr3eVKpCu31Bdczi4Mo
SDsFao9nDOTfJg8p/ShoFYK3jj5lIPK9mewdTMEQYL8nQDYPaYoE/hT2vGuP
CJ7E+jyEsq08Cuubj5WorQzedFe3laF/RdWabTrkh6bll+S+FJ5fzpbdnmCQ
4L+71eJNIbJDPt2A+i+KlqT7a7Ae1/LqoMcM/ormik0rKYTmqDlVyKGZUZt6
kPu0NZun0H9dY/mhgnUUtsUJRzqRH5p3hapQD3I7Uhk5zqD4WX5/1hDOb/qT
wSXof85mixfgvqSOhCjrsJ9pyStzXXH+RSnDuW74376lY1urcL8O6gtr7dif
d7qP6tNaCGTk7pyvxnn5/77+BymFv4c=
           "], CompressedData["
1:eJxd03tQTGEUAPC1SyFCspTWVKOsc5tNa/JWp2Vll6w1PUyNHlerkiFJaDF5
ZFFGtHlEaooZla08EhLRStYwsSU1lUmlks0rCtU4/vXHnTu/Oeee75w533Vg
t61TcTkcziJ6/r07o1QR86xZFHwpqo1qA6y7O+TDm8KinaevrRu5b6LYvZfi
dQ4H1gpbAcevuprUTy5T2tpr3gG+jOF5eFL+GAf1tJL3gG+7lVwXclDoyWPa
RkC1g0geSN5nqeEsfgN4OW65TRI5IH7TLCE57la+Uya5X1i60p3qnQ2dVbCe
7FKQZdJQPWPQN9ELckVCU2kg9VNjTPR6TW7IGB0f0A3o4STZryRfCO2V8T8C
ui/LF7aQNTOjTFvIBgmoR/BZzDmTnJluAizVnhv3rz+FT/MXfg/gkjCjdivN
0/aww19H8YacskYOOeHgTXlWF+DX9I7UX5NZvPJ47iCXzjuufXQtmuLyKvtN
HZSvEj+a8oPq5bruiMn6DBi79vHq6XSeZf3mCWqKR/eb3VNOZXGUS/CrdT8B
We31nshpLH7z577s7wNcmJI2zkA2y/rQLv0NGGl5+UMVuXlhi0jKY3A410ma
YcNiyLCv84qRDHIzdGEF5EJfM32jFYP5vM3qJ7Yshh2Ki2gSMXhq6P3oanJt
5ZENBk8Gd17XBx+azqJuwRxrCwWDDyXJk0R2LJ4wBXYeljHoErJEOF7A4t3T
u2u/u5NT2uIvzWCx+6h47AIxg15B5XuyKd60R5PYNZbB3rMK/xT6/nm9akBB
/SXxq3NCyMPmQ195g4Cy6IjvRuoPwgfO62n/fXkb063IyuISnd1bwI29gRIP
sp+UG1BpBLz11KK7mOa11bOu254BCn6nZbaRFaXehu1VgJ3tUuds8kBmTMVA
GWB1eVHiHXJF8P2EmELAm7KGfSzZmhmWS3QUr85VFZKXvQmvNy8AtN91+1MJ
ucbG3GfEBdpHXmzqCtoHd6e127z9gB/3Cpp1tL/k8vtXvA4COg4mZ7uRQxv4
RZXHARN6bqyxIGOto/e7dMA/AleZnFzZok+9eA7wU/Hu7JHkrmMS57gMwAet
55kWuh+Npqil4quAaVWRAj+y5Zk/otvUr5+/qGg+5c9mWsPjXwDyreo4Brpf
r/JqOmLbad7//se/UsqKzw==
           "], CompressedData["
1:eJxdU3tQlHUUBYJaZBLZlVegtbEQjkIOwhgI6/2+bxchVx5ukzKowcZvewDJ
lIK6EQGBgxAiAoUoICIbhgyP2IWJx0WeC0uxxCtpRUFNRJYSMAWUvv7tjzt3
7tx7z5xzZg5fdnQ/MTEyMhKy9V9/htlrJj0EdmScalfupFEWXNDg+gsBCx0/
TiClMcjcLcesl8Cj8It/CrfTOKDVarMGCLR6q6NqrNh5qaerrI2AaVz9iVpL
Gjdeg6GsdgKHqn5o9/Sgse/BhL5YRWBdqse3LqsUJr2VMFPzI4HGsOaDdt0U
Pn1fE9NQRyDng4xQvorCz5aoXdp6AqOeeUlDSgq/tvKUc9n7NyvTcjXtFDYk
3y7wLCegTIFNYgWFsRnG6vN5BIRVf9Rw/ShckV19pyWfQDyJLOz1olCXz3kv
6TKBHm3wz5WeFO6LT9x+qojVq+yXycQUmlqXSGKVBIpbZiQ5KRS+XjG+ra6K
QO5LDl++HEXhFcORwIFqAs6cume8VAqdGi60nb9BYCp9y4Qum+UnnPjJqYNA
V83m/R9VUzib/Wmiqo8Aj7E9+SKfwrrArzrnhwgkmls7HpmjMFlRvPt6P4Fv
AtIdw/UUkse2nToNgV7vlY1WsxQ6vK0XdE8QSN4geHfUncau7ubsxt8IBEj9
CpNiaYwOFiw43ScwOLvoapxAI3ll79ZjBgJPWpWu+4po1ByX9kU/JOCnHy6q
EtKoUhv9PjhPoKn3e5sQisbuk4aFoGUC02efnw4+RCN/78g2/yUCMa4bdMxR
GiNtxZa+xnIwvmS4s3OMxqktF1pMeHKwxGZVrIHGD33nozUCOWyaPpN5xYxB
98vaEPluOUiMwqZ7Oml0Q7f1l0LlwPvcu8lnnMZJm3hZRKAcND6Oh68yDN42
aVs1FcphV+pgpiCcwcPlITYv2H/3hrypwmwGbe8HLUv4crC/FcrJKGSQAXth
ooMchl/zbp9rYTAtXJjLdZIDEXfY7RlisE+R6feQ5fdX0rk7N4Qi5PTFrmxe
I8DJCBuWpIvQ3y6kScr6wc/l94wOiNC9WiItYf384qIzt6BchMfHd/gU3CWw
uGambzoowucPznC87hHAx4on6ldFeIC3HHydzYNBW2m+5yaDtX6ffOfcSMBB
OeY4WsFgVlxg5zoWb2sHb0T1MYMJ+Ws3+0cIeClKre3WM/i3S1TWMT0BZmF+
ptSCQQvTihPUOIGISEf1whyNKf4lYudJAqtvuPiu3qORG6Nu5OsIiCs8FGdP
0xjw9NZkxBgBrn3ttaYSGpWl51rXWLycR+H/lLL7nMX6sgO/ElCXpd6VptH4
/zz/Cz5w5DA=
           "], CompressedData["
1:eJxd03tMk1cUAPCWOVzEDMHN4YNYxyOnakXktYItp4CCmAUvxFLSCQxBQ1TK
0FaESQaIhucGAUUoiKJIpIQOpFHm9IqCiuIQcMZgSYpTi8bHGqoGcXr8d398
+fLLOee7556Tb1mKJjbNQSAQSOn59HbrzVVJkfFyfZHseSZgsnGxSSJn/OJw
Y1DPVkD17VPnzgQy/kqkaxlKADTMPWrRBjDubzkyvS8O0OzpmF/jx/ipprGN
i8IBD+rbs+75M97q9kQTpgA8ludYUkGepfxS0ikDTFQXlzhQvWLF6lRtCODO
efrJaqrXzxd1GKSAqcELLz8jB59ulryVA+pupp8pIIcMLPHW0vcKucYau4bx
v4cuDFtXA95Vf6b28mHc4VZ/dcICQOvDgDknfRkfPKt61EDuOVE9z0D5nt62
DJ0LYEu2sL6W+rlcdNA5kOIjGTHPKul+qvemWxXLAA9PTIWWkLtEUvkHb8D2
jE3KJ9RvzSZjd7snYNxGceMkWTgcVZO1EtApSnk/lvJDC9f+9JIcKE4+zMgH
VlmG1AD4jaEgRRvEuNWvabxsOWBnfLr+CMX1wU/Ds7wAp3yvKu3kKvMCXYoI
0Hjv88Fsyj9RlLTuONVXOYnrJsjn4xXbJXS+PeOQJU9G+8hZ+v4Rzcv21WCi
C+0rcnTaRUvzfeoMr9so/tj5x/gXEYAPtswtcaL44pmuu/WRtA/lnaWLyKaR
3L+e03w7Ok3ixlDGs2UytWEd4B9yN/duBeMzMc0BbbT/quU4cDGMcW1lWMLb
bYDbX70pvR/OeO5867lLSXS/1Js2ewTjY3t6Jmopv0yV4yFez/jUqL+0fy+g
x4t3+WujGLftfdnqWwyYsKu5pSCScac3v/iEVNA+lphj3Sg+2xRt/O43QHne
QJkreffYQmFmKeCVPiz/nezhb16fSPV3qq6N2DYw/n3p5vHJGsDaVuloNPnX
irbKLQ2Art15EWayo8Qzec+fgAql8Iv0aMbPGk+7/9cL6L7ZpnQgZ3473W2/
BrjjXbyyjvrfkdbrY+8CnCnXPcik++1fcb3ofDOgs/Zqv4VcXB93Q9AEGKOa
EKaRBZr8WX3HAL/e5dcD5J+ThP8mlQP+oAoabyBf0F8vyKb+vTpu+4rIs4+m
/rOyDFDjWsgHaL51G3z6jDmA////PgIPS5bq
           "], CompressedData["
1:eJxdk39Q03UYx7dU5FgwDSej/fp+vxsBofMHKtacvBU4T08Zx/cz4sIsm7iz
EGpCIgWzLMVEcWeIGYEHFKeRGgkICjY74pchBA7PgJSgowkyCUGQZh//7Y/n
Pve69/v5cZ97HvbtlNjE5wQCwas0nr3Kq7KLMW4eHj2tjU8takS1mQcPzPDo
vXpDJNquxm8DdQ3KaR6nvnau7P9cDUeBRecUE3QbHasaytRQG0bMz68g+EP4
gdUjj4Oz5q65Wk9gly7ws02zGJ+dbl/4CkE4YovCpRxeVNzXuygvaDErEwdZ
dL45pX9C/dLBK6N7JllwcXf0JJrg49qwtC4DC+s9V6/dQJCWm3T+tB+L9pGA
ox2bCR5+UeD7YRCLS0LOp2QL7W/wOmubzUJja1QINhGcX7xmiYT6S7X13o4N
BHM3TosjhSyOi1WZq2m9f0pPTn4yxCAujyu0xRHsqXNWJ7oZLJsypkRsI3hh
Mn66XcJAypVdMJsIDu0+slw2rsLBypwlK7cTvBGTVZBRpcLaiBOqG+8R9MdX
Md98pcQcifFa7F6C0hr35XiigDlyV4orleCHUM3qcLEMowXy8YQkAo+MYYVm
zB9fjlz4uY4QqH3Szx1tlWJxdhj7ZwDBj6asZvZ7P7RFclm59L/7OFvSjjlS
2Gt1H5k8CIofRa1POCiFMPlKWsk4D+mxkAFBkwzP8NIkD+u85G7X3zKYJC0K
G9WDu7RCvkaOodAzfTmUA2c8K8gtOarTFQvFEzw29fhvDbbIMV+rLZqg+ct8
T2tOpspxOzMp7KUxHilPiyXB3ypR9Ou5m8ZhHo5Hxll97zKYcCUWe47yuF1U
75WXzsAnoNR6gvJP3jl+O3MY3JPIazY+5PFL4Ja+hHIGb4luBVkpVy1yCypr
GdTkOy+3Uy7cX9J51s4gNyHwsID2M2frgizXGfSxDYLDD3icGThSfn8tA/5J
ffN+On+F+7OukjIVkqPKxZXUH/+6srIzlcHYg6b43f/yiDA2V123sBja+93j
GLq/LZIDiy7eZXFH3zVfNosgv2JAt17MoVVkdPw+l2BUJPOKPMVha3bGzmSq
rwtZuiOtkcOn0SbHXyKCJtGxsMLHHKZcHYd4qpvsq/qbl6sxRjp2lfkSmPdh
RXQ/h2FrwMykP90PJx86z5Pex2DvBg3ND3lN6/W+QY13Ko63bPMmyMxfGt7z
sho393U71wgJ2mxO3bXNavz/Hv8DgfSTBg==
           "], CompressedData["
1:eJxdU2tQDFAUjmpKiZVHUxkxQhPulVZJU52iLaWbGkVYm1UeW+QxLVlmYsJM
eTRLYjyi3dJjbFJWauluD6Y0jEexYhHZlMeMpLzK6a8fd+58833n3HO+c+40
aUp04kgzMzNvPMP33KpWaWE548IyQ/qdXAL64krZvuuM2wVR5Rwtga6YgeOp
Wsb949N6VjYROFEb9/XlTcZ9y/225L4isEKTk6q+xfhQ8vJL3zsIyJO+N/og
lvTHus7sIjD/RWRSgI7xftEGlXSQQHSYdWxrDePqMW/ZcwsKaWOcnbffZtx9
9YRHNuMppEeHHkuoZtxhQfF1H1cKg4qcaZ6ot+vW5pncKWSWL6tdgvrmU40V
1bMphHcqI4XIX1Yo9pnmUfj7oFN3A7HWxso04EehI/T3XkfE7/3djDeXUNha
aDqYh/k/3hDa/xFRyA5SHZqI/e2R5NjmhFAI1qUOfkY/7vSVhiVjvrNTDfZF
GsajWrLEnzwpCGv7dPKrjLsWdG/eSClUpG08aVfKeHh+RMO4+RSChpg6uIRx
qbId7s+h8Dg9S1JXyPjOhEwjw3p/hp6y8rzCuNNIr7bKGRQMSz1bagsY7wuL
O7zQiYKsz+XduXzGux87Ga3Qj/gJvVIHFePmbSXi8TYUojaY7CsuMe4mzjN6
jEI/9uqv+FxGfyzW9nwYQUFTfKR+LvJ7Qu7KeocIMPHi6o8XcV6GnU9svxKo
q+KZA8iLStWS5NcEgk2i/Ld5jFtbrmlvxnm2NGb4KRFr/moc3Z8S8FdnWJ5H
fVv/bI3vQwLPBPpXg5iv0/u0XvqAwLjArDU1iCeJXM6ENhMYuNWjjUG9hJpn
NN4j0HHN4OWB+S7WiGmEnkDSsaujI5EPaH1WXKTDfSlIVBsxPkThEHagiECA
+9jJw/Vk/qjTeJ8j0H70iSAGcfjveUctTxLYJK0WlGJ8nIvMqzubwN3lvb8W
Yv8HzRwXydMJpKwVtM9CP89OT102S0GgYZ1bvC/6LSwKSdiyn8Aul+b1gTif
KVRdvzgZ9zOwPmp4vqpYP8vEJAI2Ht/s3pQxLtj1xdliGwHzkqYL75CXjchu
OrMV65V3lVDEEZuVq6LlBHZ0frrwCPW2M1Upu/G9X8+r4hyuMV7ZkFK2Q0ng
///1DyhLpBU=
           "], CompressedData["
1:eJxd03lQDFAcB/DundpkFNqQWiNFY/qJdYaHlRxrk+zqoFHTS1NqLFvkyLCt
JEJoGcsgCdnkKrXDT45CqVGuyhHjKhsjoUh+/euPN28+896895vf+z5xZGJQ
tIWZmdkEGr1zcOa3np5UziprVsaz4YA/Szy8vpOxQdB3hzfg+OcdN/NTOBsa
Oshw2x/wmqu65kAyZwNFfdYGqAHnz/lit0bF2YWStiNDMgGrA0ekmidyVr7O
mPrmMqDF4+npw8lt4aJPs+8A+ug3XNav5izjvlZygJzVXHQsbRNngTg4+Usy
4EtDTl4A3Rex1BRoWQAY1did1rmBs2djbFXnzgMWX//bcIH2x6WnXcm8BWi9
R7LZmMRZtoP7ruBiwI/OW44Po3ouvc76HFYDiB3OUBzL2YmNM4S2jwAH/zb5
p8RxlmMoq48yApYdlCgqojl7q9Xsl14CzNA+qZ+1gjP9FGGmDe13aRFudI/k
TDmgtmveR8C8D1uP6ZdTvQp7paAFsO6OuVy9jDPrXwntd5sBpX6OPnKyiyp+
6qxngKv8xg5pCecsTCM6KnsKuDJmu6GLrDDTZ3s9BlytkMq+k5VOXXJTPaCy
f7RHEzlIpVtvJEcIUxKryP06qpp21QG2jxI7VJKFCyx8dpMtwhtK35GXNMq+
9p4farJJEtP9127vFQx7DmhYONKut57pwl+tVm8AlxWpIzRhnNn1ie0c0QTo
OtF+53glZxOcUxudrMbgxVcJuYJgztZqYvQLqgGLHHXtRXLOZnpqHEprARfZ
HlLvCeIsviB2W8kZQJGr5MG8RZyNXK/ebX4S8MbDb83TFJx5vA+Z620AND91
3F8cwpkv6y7XHgac/N4vyi2Us8bW7H31JwB/LB499getv5Cma91zAXtqq7Jb
yQUn5YE+p6g/EqWqlGwnKsnJIqcJqg1lZM9CTa51HmBnbkK5juw10NC9mHzQ
Pswhi5zkeFVaR25v2/xgH7n8zwBfZT7g3sgt0jqy7KLbmsJzgOlOuoXe9J6e
8hDZU8pzfqzRJZTy0qEzFd6Ko/5GbbJ0oryeFp/9GuNH/8GqIjqc8rXi9z2R
WwBgm6VEHKTmrHDbJEj0BSy1qUiqpPzevDpu1ZWpgP//r3/L+5j0
           "], CompressedData["
1:eJxd03tQzFEUB/BklmLWY8auGTSmPGacZEOekxxDyaNb1G470hqWJSYMWqHV
bEvrkUolISqR3V5M0yZ63aKR2hixxLAim0fySHmWHH+Z8cdv7nzmO7/zu79z
z3Vet23lBns7O7uZ9PxdnURLBGtOML7YtSAibQHgaE/7rWay6pAy9KkXYOGq
Vo3qJOMHrqxv3oGAOZ5GW0Ua42uiw+WFlE9qMAl9yZs6dcYx9H7du1+iR6cZ
d0/fkpblDWg2HPOecobxp3Wx0S6+gMbIq8Lf6YwbzbpcvQ+gJ/hqssnfHWVH
vfwAD4x+3uh4jvGtPiNtrQGAR6P8aqMyGD8orjuf4Q9Y+jjMdI9syQuXDAkE
3GfqqF1LTroe+Kk+CHC6JabxI7k8tb3ufTBgi7rIlpPJeNDtEMfZ5Fcei0S/
yer41UmKENr/5eehkecZD3zQ5VEWCvhlS/ulvizGx4fYn0hdB5gorqm1UT5L
xHYvVAKOrX7jl0ledFI7IlYFmCQJ7jZkUz1ppli3kf5XcN9SQ3YObxrXEwY4
4+rrc6PILwYnG2MiAF/Iy3sVf53bE3VRA6je12c5RfXaS10FH/YDtmalmDrJ
yf4exTkxgLtqH2qG034+Plzo3aYHLNYPtD4hS72u3zp0BFARp40YQ+6THBO1
xwMKq9CkImuUymt2yYCzBG8KtlM/DFX9DSwFMGFgycUwsq3Svas1FVA2LUT4
ivpdHKSz9FLeJCkxAbl7gHHCRsrdBBd6h5Kjz6JmewZgc40+vI3Oa3JzVvey
bMDg9M1u5lPUb3nFJo9KQHmb0q2L5kEYV55/uAJQe+eCn4XmZ07pLvOeGkD+
rMPiQvN1pkEYO/cmIDjLpZJkxreVKCLrqwDjGi5pJiUx/k7v8uFXNfVfNkwh
Jr9NGNvSR/W++Wuf/UxkXHxLG9xAbu4erL5B7lc2X9dZBli502qae5zxqKlL
Y5uuAV5xrZ4HCYx3rv1a1GEAvL2i3lQUT/12aFF93gvY6DBCdpdynTQgv1D9
r56P/Meg3XSebXKrdCh935onm9ijAHxsDXUqIb8UhgW1LAd06n3g5J7CeOX9
wNO6peT/7tMfZcGoWA==
           "], CompressedData["
1:eJxdVHlM1GcQ3SIgUKSArsoRziqVCL3XtssxiO737e/oqltYUZel2oVQFJTS
AiKCoMihBHSpq7SIgAZZPKBcbTFMIcgpikorQlUiBqiiVitni/2Z/tdJJpNJ
Jm9eZl6e69aYDVojkUgkE/JVdTWyOsW0spi3uvSAOJHAPGnphvw5Fpv8mXzX
3QSozbb7r59n0XNn9YIt5QQOjbjFZahZLCi2z/72VwKGfkfm8z4WH7YUVvkP
EujsWuziw3MYMOLYPzpEYPSS9cTiVg6PWxSJjowQML1o0f2nD4+PvZzfko4T
WF5iXNJdw+Oa9cWK4WcEPis9lee9ncde+encNfYUUsv8UvLceQxdXXGlLICC
Ub/s2JEtPE6uI9sdCQXlStvowwd4zAqfFl9eTSHakuW7C3lMUNzMVPhQ2CtZ
8qZbMY8k3lqqlFKoN8i0iSU8djTog3KFvi1lnwtE8chv7O2zDKfQr2wcMP1A
2D9pHpyTR+GCJjy30JtHi1tWskcZFPZEhRmMxTyq4xbkjh+kEHHW1DBrzqOd
OC3cNZnCjF94VegUh1caw+fNJFAQvYqnHMrVexwqEymkp4jMrJx4LF1rc25n
NYV1EG0vuc3hSp/Ekg9/omCj920KbePw9Im5fCsLOdx4YvnFwRoOnabT942E
yKEh6+W9USWHtVptsapADkXuz9TMcxa567KmtmtyULW/FjZUy6IdiiJ6OuWw
clh08ekMi/5rQs6PH5P/xwc41LZXvbDUyuF9XYfG2orDS871Gr9gOfgoi96u
9OMwqCZ9s5mVHGS2X70kMRw+putU11spfFQQfDhmEYfVzyUS6SI5dAf5Vhga
WYw+92B/0ywF3Y1R51xbDqvuuc/P76dQU9G5LdaGQ31H1wubOuEff/wQGqFj
cW/Di2GDgKeYnfQMrGZx4rabc4WOwqenZ1aMnWHx94H70pFMCosHykqqfFis
u6jOu99OIdLu7OTNOQbPK57odwp4japz3BQyWP449dQ/pRROnOy11NuzuGzh
mTvmERS8IpMqpnsY1GVtNnlXRSE7PtXDa4bBkKDsBBlD4dYvjvpVgwyu7bsQ
50cpRC3JahpcymJOd/1x7XsUAvX57zSLWez5sqsTVlDYP2Qrib3G4MT3Gl2x
oMdWT53ULYdBp97natEmCp8sS7qrTGVwVXfGw/kyCsk1Rx1zGhm0CNj4W7Ud
BQysDGmeYnCwdkWLWtB/xy7uZ982BgNb5jsENhMoP9rmXfk1g6Ohu9JSxRQy
HlytNyljMHLMos7mMgFeY6clCgbvHhvjZ4X5ikdhkSaxDBr6qq0TsgiY7S7f
0aJjMH7hnht/KQhIDnl4pFxl0DjTI+zeegKPfFnZ/ssMsjkno4y/I5AmudOs
sWOxrL32b4dIApve0CzPHhbw66OUGQ0ETnSSyaXCvVUFySpjge/6b8bEJu4s
tra4BP04QeDjxqQBjzjBH+Zt3TFST+D/fvIvwgYFsg==
           "], CompressedData["
1:eJxdk3tQzFEUx3dqV9r02LYJv3ujTTUhKtOW57rYmqHHFUapJW0PlellEvIq
ea3HkFSy+QPTNOSVVVFqz9jWGkqrzCKTKAxGWUmFwvWvP+7c+cw59873nO85
EmXGqkQLHo8XwM6/O/hD9baTXhj6OhZ4lmNKVNKfQl8+htWjh8fXTaZEL1Ne
ptsxrOPXPL7mSYlMecO7pwtBXvyMKNlMSnyO1/udOYuAvN/QYO9FiXG2esVK
Fm8UX5hzy52SFi+pftZzBCUKfU+ghJKiCGEs/x4Cs6GvlE6hxDfPfF6uQ5DS
lpjqyPITMndrvGIR7DU2HwjzoKQgOKZYnoNALlxTU8Tel6s+Lr1ih2DewyTN
CVdKhuduf5QrQ5DfXqWwdKEkZVPPprT9HMyKSzt2biIlnTnSpwVjHGRFaWXd
zpQ8EEkS7GM4eNJkGVbsQInyIAQcMnIgzk51sXGk5L5/6+vTezhIFqlfjNhS
Emi+FRwOHMTFfM8IY2y/IxO7NHNQ3MtXBFtR4iFw6O3s46BjW5rHDDtKrMcl
cmH9HFTlXneYwP7TZbVd4kIQrB4KfXdxEiU/NCm1C5MRqFPbHY2M3da7tdpZ
IXAeBx1aESXJBaOGc7YIZMM+0YU2lMwtmhr6bgSBKt86MJvl+3c51/ZbYLjC
BXgWMX+eD79xlXAYUq7Ntmhi9XKDK3637EZw0LRDmMHq42308//AuBdvzVbY
U1KB95VVqBHcrhMJPjK9p9KHrB7WIMj85SPxZfUtvlquzDUgWO4UbRqbQMlL
N49DZf9YH/1Mx3iJzPuI7S4Era+/TNSw/Fb9tMrEOcxP+Z961XhKvkWEzquv
QLBYnfTIkvFamwG7EOaXJm6g6pWA6eXFOHljBHXd0mUCHiUhedXxD1i/Sv5I
9YfHwslIpLmwwMz8sDJ++TUSTtBAek5NPwLD/KRPWj4lQaN73zfOxBAZn+Bu
Yvp3KjafPnsEA5m+/LiWsZaKvrpexzDmZMiPZP2s1K2Rl5ZhuF14M6hdTElJ
0/23OqELiJM6fxezeSh9xgR9xvDS1PDWfSrTN21So/VdDEE+F6PSGS/qHKxu
GcRwpzRoyzI2b8LHR8WxXRiGasuEX9k+NN/FOd1ZGASmBtVmNq//79NfCPx6
gQ==
           "], CompressedData["
1:eJxd030slHEAB/CLtkrnZNOuxZ17nLcjDPPkZfQ7WiovmTJvl+yijBWNXeV9
opSk5rzOS3krjrxkSjjU1YSxvCxlxDQMsTaROep7//bHs2effb+/5/e2hxJH
+4arMRgMOzyqdwSrav5uuIiEdLTONhnQpNtUmPIMTnL9XOAAb4jvzAzCIhvb
idtwQGWE1QrsZxsl4FE0KR026u2Bi0bKK3J4NKkp/Z2eCltUtbB74KSQX2N8
+HjMviWpPk26GNuLY2EiEu6+nshGvr9dWFkHX3iffK4e+dnE1b0JsMi2rMGU
S5N3BaONcrjzlLHTEw5NYratqCbY85JcNqZHE/M9CwnKyyKyxS7RK4LfyJRf
puHJXEmgGvqFwy8aS+F717JsdJHvBhaaOav6sT1hqr6gnTtjCJv3mTEo9IMT
yutc4R17n/xDmL+spfilCSzln1+XwA3Wi+k+cC/VKPbEeqflAQJv+ITgTHY3
zsNr07HWCt6t+vZ8Dk75YR2iyvuUP5UrcHeglG8JN5sxJ0NxnnUDsY884GWB
6XYpfOyTx2k7OIN12KXNmCblV3dusmDLozbcapgryauiYL0hZSQLLlmsVcjE
IjK0Mz4nN6HJlJWffjIc2ZslTzPD9/Q2S+pggbsoeFRAE8WhtbUKjNeoWFV/
jJzBmR/IwnkKebMfmHBM7oasGvb2W2bFmtPEIii1bRwuc9yO7oc/erXE18Na
49IwDvqRs5oKTdwv6zsnLgyeykyLY8KDM9PLQZivxF6nSAoLDx44chF5Mm/s
qdsVEVn/0+WVgv3mURNqTLiVJ928Af+VfG3sQP9BsVuDwgjrHenJWcJ8+pRO
9RD219Ip46ruPyN4bkIfnjGactJC31Fxf0sd1uXzm6/D/XGL650Y38muFYrh
1pMcpjmc7Skx2MT4hbeO2izYub2GzMP5ldpJmXyamGq4sP3RN3zo51BpSJNb
PP8cHkxZroXGI/eN95g2gl+PRL1qxnr//3/+AWgpYEo=
           "], CompressedData["
1:eJxdk3tQDHoUx3e2jSviZuOK6brNlaVSrj2yytW5w6h0yCupsZkiNVRabGyr
65Hx2pGkuCivoscWmdoeYzQnKmaT51DXrdjIM82URZ7dn3/98ZvffOZ7fuf8
fud8fy5R6xZFSyUSCYj1fR/InrreJ4Rn+9FRsQD4vrznjzLBcwemzylaCnzC
6mSc0E7Y0HmvxnEF8Ab/wLDb/xJaLLszSyOAC6flPjO2EKqG3Uhyiwb2z17R
PqmNcHRlh4d3PDCk9nFaK6HigHrZm0TgvFivrmRxPi/+y16zYNXaLNuqhyKf
yqfv3npg5VZfP30zYfvW0SVhOuBrR47N/2Im3KjbULU0FdjcbOfXdpVwZ3Vb
Y8ouYJsw69ugasLX+qvK0G3AMeedH0SbCA8uXNL1q4hnWUJb0wXCnKrad03J
wG9gT31ECWFv762Y41uAR25aPyPESFgz3hQZoQVO/iVzqD6fcGale7B+E7BD
5+DwgEJCcPCecTkB+NaLr1OHFRPahWfMsxH3zTsnPcSlhIPeyzxhFXC6QmW0
ivz2f3ukOUYCn/b8kPCP0Ofn+Nf3q4EPe6/+3eU8oTpUccUSDqw9Mla+U+jB
6SlTixcBL0wcslwn9IAcc1lrIPDPUc4pOy4SDv0YM6BnOvASpanCp5LQ7/jg
4Qc9BK+zj8tiwgWqSyaaAFyXWps+uYbQENL+cqIr8MNRjxVlQu+33SFxGgcs
W6lM2lxLWJ+oldTJgV9V+7q4XSNsqWj6eFMm+uewr+RUA2Fpd5nrAAnwh8Yb
GrnofweknRkl9MUFcq1B8GS3Qvntb0qu19ed8LhJmLInNDf2s5J7wbZ5u5if
s29BnVYKPP7c6jXxwh+e3e/ypKLe4VmGuOdi3oY0v+IMJ+DySY6fih4RhnQH
vz05BjjfKj0z0iL8IotUN/4GHGiy2vcI/xUVlP5U/v19XZzZ2kG43y47zsYd
uCXsaFbGc8LrB3KW9/kAD8/vdn3xlDB2yt2/5v0JPG2I4b3zM8LO/zS6qNnA
KysGZTt0Cn9pvO5rgoAra3JdZop45ac7iea5wJZVSZok4f/HV0YYIwOE/0xz
CicKDlLv95cJ/vG//A/ehYeH
           "], CompressedData["
1:eJxdk38s1GEcxy9MIr+ayLW2LhJHJ0+K8/O53BWtPJyiMhT3rawUW0ju68dR
u/JjcmQtXapLVGR+rJIfT80tlI3Z0lRKtyVriJOKUh//9sezZ6+9vp/n+T7P
5/3w4k9LGQMOh7MVxtJcyJsyU2cSKjZc6XRwJ8KG6ZJyYzmhNa+cp20kCDMm
0bsawLOfHxChGOGyV1UlEVmEmu8vDJ0ORJh7IvtYJktosN56R3gAwot8psMZ
/Gx+r+y9H8JhJwI7XICDVi3nsj4IzxzXKVuyCR2eyTle6Y3w8+H47oUcQvMm
32klQoTtgvJie3IJbQrjmcd4Qb0iuL8WeELXuPbFNoQVz4bbc/MJXUipcuN5
IjzCD5hVAfMN45PGEML1fVZvPp8n1K98nVsdsEjI9KRfIPTO778qrgfCD9Wq
ES8loY/2jFae3IKwjVxQvwe40/7rgCnw2ahP1feBLTZqslXuCEvkKfoh4J/T
o7ctgRtdNzt8Bx5irbP0AoSTQg4w34B/aaOvS6G+Jepc99RFQmdSEwom3RAe
Neh3jikg1Czxy/xVV4Sr9LLguCJCD9cOOun5CNd+4M8eBR6oYay64HvnFYOi
mmJCyf2iyEObEfa6pU0IKyF03vglawf1rCb9o/Qyoa5nbF7LgZnt3Y4OpYQ2
R6zhEBeE9RIP9zRg7mSSWATrKzMk1UhF6C5Fa6kA/JDnlLekjNANbIj9JvDy
quQBxyuEKrrSfnDA94y1lveCx9Ibgd2w/qc+bttD2E9UXOnbAOflsZNxzfA/
oWLZHzO4TzvVYqxpIaGakQjhBHD0/msaNZx32elcI+1WhEsYM6kP+KajnSEC
6BfjOZOhBW87LOwzgH7abN87fm+pH7IGfwvIQ8V4hfIR8JHIvIJkyIujpdg2
Ee6TW7eYIPdFGHH2peignzsz20osIH/KvZ03UvMItXbwaeXsQNhfs2b9gIJQ
Oht+c7UIYd3bp8Ys5OvDE9GiDryAOyRDwHPtfhFq8OOXTFrKIb+notRzu4OA
H6eWmkD+Eza1Gd2F9/D/+/gHOxdqsg==
           "], CompressedData["
1:eJxd0n0s1HEcB3CzzmP+QFq2bsjTVd+wCDG1Hk6XVnF35CE3D/eTsaErI+IS
szxE8nSn2Zy4unJ3olCpPip5utYK/YGdkpLCXZOb7ip9/Nsfv/322uezzz7f
7/ftlJDOpoyNjIy88Fv/pw6WQDOXguyIrVtKCwgoYmQbWWjV5rVd3fkEGp+H
0OzQK7ltO5hFBLKYtSY3ORQInJgcgv1VfsqmaTYFii8hJ/yKCVQKyrid6KOP
3w5cvETgkF9TiAAdbK63DMJ57L76bF0YBTKpsOVTHgGbgsoka6wzui5LXUsJ
xNfXdxzE+Z7FgubYKgImVs3RMvTwvnzX4BICFQutRbm4T5O6vEF5ncBIozjO
P5yC/U51jPc1BFYUZQtcdPWQrDEe551pqXnFi6CA1ZmslaP/9MpY/Vgfubtd
KL9K4AVDzm9DC+3nhg31BCSqUDch9se87NNoWwgEmmlVOWjJ2pjH6SYC/Zlz
sx/QTyLPTdpLCAyzTPe8Rld3d3cdkxJIndKJEtHb6BdyU28RaD+pEbWfomDV
qocz/YiAXmdusI6kYLBHFF7RTcBs5uPMcXRpSow66Rmef2AigINe8/XiiR4S
MKRtWHaKomAuvHHcGPuFhbpvzuh3K/N0WwWBhkWLvAz0oi8vo1dGIKlqKnQO
zW/zXVPiPsoDG/quRFNgGJV4yLE+HvQ7mBZDQQejaj4Tz2fhYOReiv2GZWcf
f7y/sbPfXazRT3e6BwdWE5jnfhX8wn0cEhgqR7wfO5r+MA+t0+hVUVj/uWo6
aY9OMbUZvof1v2BpnYTnHRJPqV2uETiisfB2Rkv5e81bsT/Mc9XHHW2fVZgs
LydA85bGrd8fc9OSdjfmx+xGLSsP38P5jnQiNgffy1XkKEabvwkQp2GeuGnN
dW7o6KkJuhzzc36x3cMWLeO3LqVjHnm3O9RqzMdn+o/MRCGB0fwH92fRwhG2
JAPz+3/e/wGq44cD
           "], CompressedData["
1:eJxd0mtIU2EYB/B10WbTpk4/tMRLhuXUlDetpbjOTAykOKBmOlAoKytSo9lK
yWs5LadrOUXDu5V+0ApLsCn05mpFkCcyjZmjEO0yG4G6UgzpPz/24XD48Tz8
3+c57wk4kZd0aj2PxwvB43h/G6zTu+tYuvJHJHntRpixp51rDrRwwQ5LdWyx
HI6SSePL4FbKiSS3WLojgQvLh0V2C/+rlqVHCoPVdlfCfAhaiHRC/Wa2OFMB
b1J1ZNajHvPQ1ekVzAmLYw2wJIsIugSEqdC3pazUsnTGI2hiAZ6uL6k6g7rY
W2p2Rr9Tnu2HFs7JUdO9OC+1Wjb+EW4U/03zgcWlx7xD4HAqi74E+3/W97xF
Xvib7RvC4chk9/kI+GyfMVSI/CJ798EMDUsnJZePpsK9JaYYFWw29gwUbibM
7DpViTM8c/94cpwLYR64nK2Rw7mJvosecLpJnfsbnpLr6najv0CZ0cJHfvOc
NV4KazQvDN1w59yIcBT99/yMW/vh1oDnywV8wpSpbZZxeGeRSZIIP5I2Lzts
8mtPDUW/vMDvkBL71Fo5c4bjvHRdZT7MC7BN7ke+durA0HfY2tUykwbf2XZF
EYjv/U6hCjNhn67zpVVG3JftdMeSBvsPnvRKegnrr+oeax33xa9Y8+iN2CcO
9x6O29NUx1L/L4p9v4SEUTknZE7cxv0Me481eBLGd0ig90L+3ZQRUaEHYZYs
3PUyzCuzr9qpiDBRP5OK++DytnK3JnfCRLQPR1qrWUp8uGwGeYaBBtFqDUuf
TRuUF7dgv8bSjecw/7XZrPfRyOvn+J8WkT9Kczx3oX8+pXLKFfMpL7QJzJjv
///zH8lIMRA=
           "], CompressedData["
1:eJxdkmtIE1AcxafEsNksCe1Dqyal+cpdl+lkqTefc9pVlOmaosu2MEFU8IFO
EVquwjQHamaYSipl80WLFN28+Vi5StfURs4X6pC0KMHy0YhuX/twufw4/O/9
n8NxychJkNpSKBRPcv7dPIkquWMd4crZpM6pCACP5dNTDWsI87NUHkYBgOyX
tMXAJYQPzUczn6YC2BmcnNJnQljXURfKTATQ3lQ+7PYBYU3/s6+mywB+z+X6
eRsQFp9kW8J4ADKL1+MVkwi/vQrKK8IBdNLaSbAO4a42p6V4orezk+orCY+t
DcRIIwG0luR/fkxY5JkTxYkGsJrDEGSOIcxTFofsxAF41xonsR1F2Ndl7mO3
EEAlNS3TpEU4/dONWpkIwNaazZ7IcYR/Ra2GROYCON7zwLlwEOGKdLmjWg5g
dkJh8x01whZJ0BF1EYDm+uzY7RcIT1PzWCUZAOaV8hIbehHee/Rzkk7eRwtV
9k4dCG/70MXLxK/UeVPq2oyw+faQZYPkdcGgS9mtQ1jfpvCnhABYQ7UJa2lB
WHja+V77JQC1+9OtPiqEZWdy9G7BAPZ/y257SPbRuGfOitgAPl+5n7uMEfYy
WHmNfgDqNoX7Ca8RZjRPrAgCAHwVkxZtHkF4ZyNiUOoP4NbZ7qIJ4n/Gy8rw
JXrTUYWUS/Ix7roymjgAFtIci98TfXWY1T1P9H3BuVPDZH7mCb9SQ1jlbUga
Ivmc7/rxxUz2aWL+zhISlhcY+wK5AHr94YeW6REeXVDniy8CSCsTTDe+Q/jE
1MgeyxdA92ulDZo3CCuvZNBkLgDKyyl2DoS5Yjq1ig5g6nG9KHyK9GNZeLB6
iwVlMQcS6+YQ7i2Q3rxlYcHYWq1QuUL+D+Io+IcBHJAYbTxI364HOFQtEn//
9/Evz7I8Ag==
           "], CompressedData["
1:eJxdkn0s1AEcxjFKWYdzS5lp3n6/30mmUqxrPGLV+t5GSkUjNcSxo9sqcpuI
GLqhEvOeG12KUlZSpiTlahXhIhrdjGqY5C2m69/+ePbs+e/zPHtsT8UFRBjo
6elxOv1z22fTks7jDFqMw1urVARfZXWImBjsyFexhWrCi+CYIXbQEd5rNA9y
egjF68ZEdc4MlDKptOYT4bTy2isbNwZoHvug6CUEGKYeqH7qiOGB2/0OXwmL
6Q1Un8mgo6o+6fIggXeWd1jOYyGxdFklmSJU6c2emzJmUcGXJ4jmCPYxUaHR
hQw0fsEWkUuE6IEef1MFA60k/GiwvhjbIx+JzBQstvTlfTZdJizYaGu73VkM
xQU5CbQE0Wonz6IsFgUFeRf8dHxet7IFnd9ZjC5mqjx/Enq8MsNfv2Oxy7lN
qvhNmNRsnPJ5z2L4zeNfvHnCy5EU/j0TDiYmE6t3zxCE1qPxAbYcVqKD7hoM
EcJMerjkRRYt8qXJLl2+6JBn19fPQjrTG1HaTXiuMnWY5Dic1/hGuuhyu7q7
6aaAw1z5j/vfZgkjVr5mOQ9Z1Gi9N33U9fNw1x8uy+fQRVvvZJiJMTSB+Vov
Iez4ToMGRmJM8yh03lgIaafaX63jjS2znw7xFCKx8GBG/ADBjV9pHpvGobHV
xkLYQeDvPbaw9gSH9VV1jXNNhOYbf7TcGIewcXlCgZKgLEm8lGjEIaXsZLvh
VcKTQ9fNZSEcbEuMcnMVhP2CFevsIxyMLDdLXJMJDYEeHh26PeRe/cp9SYRt
ga5OKhGL4kqDM1FZBJnMarlNxaKub6aiIp3wZXxD5Xgqi3LBXDRTSmjsexuz
M42Bz5U9+UFFhP//9heZJRuS
           "], CompressedData["
1:eJxdkn0slAEcx7nESSZElOg6LXfP4zx3ihrqW1FKSqrN1fl5mWqNRLVe5CKj
Rp0xUi2RK6U1sixaXIkTSxYNCWUVS0kuyUupdf3bH999//xsn30EkQeD9/AM
DAwk+v379o2WRywYgibkcI99Not0qw9DRd6EyTkF809sccXnTAvtOmfC49Ta
5Ll3XbGhufeVYinhpXJT3/0fLCy0jkmZjgRFw3vPtDYWdUFnbWJnErb7XE4a
y3aFXyZfUP0zFG8L8+/1P5bgaXM6y9eFYj/v2kD7sBs0eUNNMZOhEHpUfKuO
4pBefoYTmhLyKq2Tu0059LorJOwCQovNiOVJMYcLk8UbHPS8UbWkrUvHYbNm
JHy2gGDHxWZ5VEnBS1mZMC0k+GhKt+YqZUitMhEs2kj4/cfF78w1GWaq40e/
nCQ0/UpZuspXhro38uoDmQSn8bWGPWkyvC23unQ4g8AJ71iW50tR2lHv3VpE
cD5kdsvWXooYo7M1s1QEL8PAVHMfDp9dTCpM9xACp+bsUHW7ofBJgI00hBCk
7Bx6flGCett4ndd+Am+fSL5F7/NTdF7z+gRCRVDi0xdGLLQjN3eP6/k/Q/ZW
tj5joM44GmeWRTAPKEnzTGSxzEkwt7iUkCu3U4aXsfjz66N2qpHQXdZq0nyE
Qe5E/LLGDkJl9FXrzuUsnOVt3PppQsNavnDbRQa7/GsHR98Rcqw9HzxawsD3
eMPVfB3hq3b8RqijGBnnQzoUs8Pw7HzVBXISY9C4oNPfOAw73aNFixaKUPLk
dTD7g+AxUeRgWyKCKrWxScgLQ9d4m9HAsAgRcq2Zsp0wpfYh/xlixK54nxRR
Tdgrut6jmBTj1DyDMT+1vpe7fHn8MIPvgf05YTcJqx2cfaeCxVhpYm+15hyh
U1mpTRYwSKwNzFocRzjQ5+/H1zGoiTrWGxBMMDrd11osZSAZO1Z8RUZ4qKqJ
nO5mcDtXpWkRESaS3bwSMhj83/NfNO9ByA==
           "], CompressedData["
1:eJxd0l9I01EUB/Cfm5OJIgsjKrmIaZsmycywekhXmYIg2dxMDWSznLTZpEKX
9G9FSWlNhWRljqYVPYwypaWxlQdHRol/Uralm2Fm25rTQdPcWGpnrz1cLh++
59zzcG5CRQ2/kkZRFBtP6J79IivZL5Tw+JZaushKYOP8hLYA7U1OTKPMBETb
gKpC6/3bZzrQfYpengidHnb6XjzWq6JHxovQdOn1uWo0rcioDPVrnEK/Cuvl
1yZF2eioSJNyJ+YZ3VPKLDSnck1SMU2Ac8DAykWz1z6NttoIPNWNcQvRZrp6
h8BOoLb8feFJ9AOtk6HC+s/2oVcC9IfIFwe7vhKIuDv//QK6Z7H0creFgCPX
I69H/3AbrWVTBEziM7Mf0UcVhvL2OQK2huMsI7rx9ZL5ioOAODaLGkVvLpUl
650Enufnc4fRA6bw6UEXgaT7p04MoH+2dcj3LhBwVYd16tEt7+andW4C0mxm
nw7tZ/JT6jwE3sg0sRb0ubHAzbw/BPbdCIy70VVr38ICKwQGfaur62jXpifO
Lb8JJBQnDS+hffI9jKFFAg2Zz8Qz6N1a8SUFmvGWq5hAt925uPAX5xekCOyh
PKYsnHX7F4HmEgdzGd3laO+PwnzS9rgpoljCU9h7XYcxV+2qTz2Ejk9XC856
CTzKyAvmoF9utFwN4nxhnTB4DL0SncpWLhPooD3UMNBNBo9Vs05AfQtsI/h+
eYzBuxWdmHOE1YOuSYvT+HzY398ozUTH0VqbObi////TPxIhKUA=
           "], CompressedData["
1:eJxTTMoPSmViYGBQBWIwrZye6D/V2CFVvai8R8bPYVHSnP2c040dZNy+J92T
8HPI18/suTbb2GFZe7jHenE/B5+QfN4coPw0fbkpz0T8HLY8jelaPcfYobR+
tXaosJ/DUdtpdiXdxg75/0RfnBTyc9gm8GRBS7Oxw4vnNpKXxPwc3C7fPPmg
y9jh4+TIYjM5P4fuzrPHtwLlj/E4z0oH8i/ZHzza1WLsMGFdR0C0gp9Dtcg6
94dNxg7va+xN44Dye0omS7DUAc0Xaj5wStbPoThj4tuaemOHGXlAAaB8Vf3Z
ZtZaY4erR2M4NID6u3Oe/15ZaeygbsixRgYoD1ZXZexwUen2zzolP4cFUvp3
VYDm3fPvnZ4H5JelqWu8qjZ22H6m76cqUP/DKqADOo0dbpz7HvxY0c9BGagt
C+i++iygS4DyK455m3cC5Z9eABooh+CDaaB67Xaxm+f6jR0u+yYJRAD5QNJy
ywRjh9DHS2cfUfFz6HRMeHphkrHD6YWu2z4D5TfNfb/8GDC8P18CatDwcwBZ
twcYvkW2XNcXA9WnWN/3711u7BAC0g+0H+StqCXGDgqtrwN3AO0HhtIuzzXG
DiDlBcDweQMUbV1t7FAACi9RPwdgaHy8tNTYARRs9kD+Lk8eJm2geTogdwLj
Nw4ksBjqfqA8WN1cYwc1tsapzkB5eZA984wd/l2peKkm6eeAnn4AaeP6rA==

           "], CompressedData["
1:eJxd0v8v1HEAx3Elq3xp2s3Xc33uqGSzURzm68ulKF8WMd/f75AbCq3MyLd8
m+/cab7lyyWhCEtWMrG++BIZGWVxW7W5Qm2ZTk5F9Ws/PPf4B5688HifyJ1K
Skomf/un8/GggQIRgU2qgQ5TbQALSXgRK4VANlN4zfc7G7tepe4ezCHge5au
6ixy8GajMjumlCB3SBw+P8vAs2OP21AfAROVVTXpwUXAtmDZe47A9LFGj0cC
D1HzV6vq5AQq36SyknkuFlv61fkrBEpHO0MzJhk8VU/9eVeXonNH2kiFGQ/T
E4Gb7WYUROhnu2+Li6W1e9teFhQfN1Zo0xYPU/4ioWkYxaqvln6+iiHmnuXF
yoIpZsbWefHNRnD/IFMklVDwLE+ZmtQaoqjZbaC8guLrfUezw108CMXWqkG5
FOx44uxkw4M4syohvobimHXOZMovLiqZ3jHWTYp6zUcKvohB/ZM5bm8Lxdvu
SN8EYw7WTQf8IyopBscW5dp8NvhiR5+lAgrj7kHXAAkb+qtn1YKLKdrkScMR
LD0Ed44qLmZSpLWy9KcFbNRecPicnkjhHdgZi8scFAlVBQ3RFMPZxjXOCgMM
J1+3XfCnGG0PUX4o08esU/750ViK03JxMzdaF2nOanurAylqysukKgJtCGLi
3i+doWifql3UCNZF1jkX8UE7iq3yBosHl3QQldqnFcpQ3LYfd4hL1oVXtfmN
CmUKd9kPV5MsPdSufbKy/00QVpQ4/qKJDXGdx0KbJsXmCWWOTyYHLo2RUqcv
BHZlZidfgkGI4rXW/nmC4TiJn1DAwMr8ziH1dwSi6mVWYRwHZbeuGHmPENRJ
8jLSVg/Ageny5vYQPJ8oTrfs56CxpbJD3koQKT2iIWIz+P+/P70oHyQ=
           "], CompressedData["
1:eJxTTMoPSmViYGBQAWIQHTjD8VhuVfCBqrgHK07fsnAQKNmySrUo+IC5zMf9
H3ZaODzgmLNNoC74QE8/q/WWDRYOS2YUlXgXBh+47PJSxne7hYNYVE/Bydzg
A/vOpB3ZXWPhcET1+NxL5cEHtq88XdyXaeFgd/rzg3dlwQfE+VpSGLstHNgm
hh0LqAk+UC4aVBfUauEQxsiRGQ5U/+t/07s7yRYOi6+IbHdoCj7wwX32Fw5X
C4etnv0f2ruDDxir8b3KybBwONZ+8/S29uADN6+L9lUD7dvZd6ZuB5BvceBM
+Yd2C4eW5W7zonqDDwjICSXb5Vs4ZGyVvtE6N/iA/MqStMKZFg4FHKFZ3/qC
D8S3eglZLbJwEF17h/vMpOAD8zIrMitPWThcUl8x3a8j+MDMHaECzKyWDgtU
66p5gfb36sZ/msVm6XDw5ETNX53BB9ZwRiS+5LJ02HVjS1AH0D6pncIT2VQs
He63a5zeCjT/MB+HZK6BpUPdJftyCyDfJmmm8gVjSwfDVWEFnY3BB/5PfHnh
pa6lQ7HzXOap1cEHnh5edOPAMwsH719Ht10D8mVDfQVKn1s4mJxyiY4HhpfD
zAkKy55YOLysfZx9HsjfM+dEU8VToH9Urc2Y6oMPdJR+4Xx128KhbZJK8oSG
4AMue1ultO4C9VesVFoGjL/AVbVWcq8tHAIk/9s9BvJfWwJNAvJX6ntbb20J
PtD1sN9d9IGFg4dy6KmFQPOKrV0j5l23cPj7Lv3QAaB7Ip5LTNgLdB96egEA
J4YTPg==
           "], CompressedData["
1:eJxTTMoPSmViYGBQAWIQzc2n33GiPvAA5wblzEnKmg4XC2/9sADyPRVv3TCT
03TYn/Hqgktt4IFpfqZHDolpOryv+brcGcgPuRPL0yWs6eCcfOfwlJrAA2+S
npRVimg6HFc1bpYF8o9N3DulgF/TweassGR6deCB087eh6fyaDrM+Gx4JAzI
56qu17Dl0HToP6g/a1dV4IHHZ6X2rGfSdEi4MHe3BZDve/H2SwlGTYdta2UE
wisDDzyZvuGNxQ8Nh/sd7yKvVwQeYD7MLGLyXcPhOy/Tw8rywAPycTVlqVc0
HPad2JXXAJTXWHZQ+cElDYeEE6/CzgP5/1cbJ5dd13BoP8qs+gBonuj0mR25
NzUcLNSudqwC8q3O2MS9BfI3/vi03Ahov8BflQ6WuxoOlZYTWT8C+bU2X+6u
vaPhYBZ+tvgI0P0hFxbPKHqg4aC1hX2rFZD/8fuzSaz3NRxUu265WwD5Pirt
dnwPNRwil3SWNwDDo6Mq7d2xxxoOrIvOrL5fF3hgjsSkyZ2fNRwkLDccfA4M
b/8Fdjs+ftVw4GQ3bNNoDDwwL92ddeV/DYe9Jq4Nl4F8m4DlNruA4WESfThM
qinwQEHU1Jc27JoOPhZfxPhbAg94GDos4gSGf/ZjO417QPnVGyQfNGloOuw5
8vdNTnPgAVnWx9Y9FpoO1yvXb70E5KuW2HA/t9Z0ENMotp0N5DtxGuf+t9N0
mPid1b8GaJ9xqk9aoommw9bU1AXXG4DhE6Skt1Rb0wE9vQAAMocHBQ==
           "], CompressedData["
1:eJxTTMoPSmViYGBQAWIQzVjy+cXCT34HDp61rTcVMnTQ93jZYQTk37Kzf34S
yL9xsDxw1Ue/A9e+a6+zFjR00D0n8YwFyBevmNzyUsDQ4c0eIxEZIF/v6m69
TcKGDocezLL+9dnvQFTi/KUXRAwd2N9W8V1873dAK+ZVdYaUocN7WVO1I0D5
aEatg+2Shg5J7rr3bgLtW9OUVPpVztCBd17wLZ03fgd2n7eO/ytr6LB2r3/o
wnd+B5IeuYpuUTR06Ft36W4pUD7ibn9DmZahQ3nW5dqlz/wO1M0LmLlG29Ch
7vWVZb8f+R3YVz1RSkXF0MF9Y6Pkjyd+B4J5w74rKxg6CB/9atnx2O9A972V
DdUyhg4yX5Zut3/od+DXM4+KHiC/U333zIv3/Q5kfeE/Hq9s6FBasVbT9IHf
gRQR0d3Hge5JlZA59fWO34HZMzprY6UNHe5sPcf5+q7fgQ67zE/3xAwditWV
eHdc8zvQuuXYAmGgf/Pbylbm3PY7sEVY5KsFMDx9Ur/JXQbKr7Dg2xMF5K9x
1+bQB/JPffnA9ZLb0GEjZ9XOmTf8Dvxec33mc3ZDh09JbOc1ge4JTjx+ywoo
L/bi5OtyoH1MVncP57MYOuz8tdGzDijPt1UoftJ/A4doJ7sXN4H+2RAi/sGI
GRg/hVYqAkD//mlSt+tgMHT4FrhQtBjI/97E+uw6q6FDlTLL13Jg+JhnT2Xd
wWjooOA6d2f7K78Dy/5/a+MB8ks9u1/+AMbvshlndfexGTqgpxcAP2kV1w==

           "], CompressedData["
1:eJxTTMoPSmViYGBQAWIQvbbtiO20EE8Ho6qTUfPsrBykF5hc0Qj1dMhOPaT/
1dLK4dWKyLCAKE+HVvUvvyZbWTmsit0hsSLa0+Hrzltdf3WtHLZpHo5NivR0
iDoh1GNpYeUw3zdCpz/c00F5vcR+KyD/9K56HZcIT4e3ul2H7QysHJbfig0T
D/N0+Pfr+gpbUyuHCZ6vRQKAfPPd/28uAMq/8M6v1wPavyml72msvpUDU/vq
uJvBng6qFvb8/4HmVX408U8J8HRI2TPnRBOQb9imIeoMlH9qW1z9ztrKgbvl
h7QHUP56Fn/1QqB/ON3ymWQDPR3Ycs9uFHe2cnhw5HXofn9PB8evWbe7gfx5
O9tb3gP5aoc/1rA5WTmYCcsKFwP5f+4ts/9tb+XwccmDlrlA/vQr+2+xA/l3
y167ZQL5s1lOMYoBzT+8flFAgp+nA7fg6YPHba0cXB20sq56ejpYhEkIVntb
ORTttnEqAtofZVvo1eVp5fCz4GThcqD6uVHHmQr8rRxSLF7EzAa6f5Mh192G
ECuHTKYFT68A1Wu8cFB4CFQv0hvF5giMn5mTE9Vme1g5rF2+UeICUP2R2RMM
L3lZOZzTCb6bC5R/PCEj9p+PlUNykNF7dWB4/s9N2GMA1C/Mt/foYaC8bk3t
Wm9XK4c1KYJXrIDxE7h6XtMmIP/a+W/Ox4HyiTNzYxWA/IQz09Z0Aflpvxpm
KzgC42P55ON6QPOExQq01gLDBz29AABWwO3z
           "], CompressedData["
1:eJxTTMoPSmViYGBQBmIQfe2ez8dYRZ8DaYuL67qy3B1Ek55IH9DxOXBzVZ69
Voq7Q9t8zzXXgPxfha7F61LdHYqcrpd81vc5MEn7qw5HmruDB8Mkly4gv/Vp
yb9Jme4O0WyObz4a+hxYyqvzhg9oXsi5IpNFxj4HbG5ZJOkC5e/ELNxyB8gP
v82cbJzt7nBk9gTDSwY+Byozr/QezHV3uLjrj2060L7VKdGJofnuDllr/s59
q+lz4Icd94/XJe4OfUwuB3u0fA5ELuksb6h0d9Bq3iKgp+tzoKUpaEtRvbuD
pK1QFwfQfq4dPQ6JTe4OYtYXft4H8sW3X2S41+bu4NWzvt0ByP9uau6d1+Xu
EB5a6fMOyL+neoZ/e4+7w9SQGO5MoPsmOFpsSOt1d7hX2NX3BOg+Vvas568m
uDu8Cr4R9lfb54DMNt1TOZPcHeJrbb7cBfLfybk6MUx0d3CRcZuzEqj++5Tv
Z972uTtsFpdmSQfyo1brHNAFmufYqRV+Wc/nwNsdD8svd7s7iOvvPhMK9O+y
npM6PUD75Z7ufl+sAHRP1GnO+nZ3B+/YXncWIL/g/r/tb1uA+s1fXe9R8jkg
V9Q39TPQv+8e81611PA5kCPgaLCo2t1hodB1w3XA8Hpyp3HqvDJ3h/bUG2cN
gfK1hkvtXYvdHWTUtQ7IqPockHA69/t/ITC8JZPYSuR9DnQl2i45B+Rvk5jO
micHdI9JoJU7MD7Q0wcAWMX9Vg==
           "], CompressedData["
1:eJxTTMoPSmViYGBQBmIQvX//HJMXyVEOj7QLMhqeqhwIivisa5sa5cCv8IJ3
zhuVAwFyhcoH0qIcpt3fvP/vO5UDR3/v7mhIj3JY2LP8yu23KgdCNgV9354Z
5fBP0b1lAlC//k3Z70FZUQ4Jb5vbjzxQOSDvXpySCuTXO7Vzyd9WOfDzdfzi
b0C+rxKPrzKQb5v74qBFdpSDwbIvy19cVjlgL9nB9SsnyqHr8n+NBUB+b4dE
ak5ulIPLjrz3+x+pHPh39+MdQyD/p9yT1Zdfqxzw9W0yXwLk7/MRUSx9r3Jg
KT/T9Byg/kWrfpRO+6xywCqz9Kw90Hy2xqnO3QyqBzZJWtvEA/lZQokZUpyq
B34XcTNdALqnxeLoTFER1QMvJqu9XwvkcwkWcIQqqR74Lj+Tby7Qf4bqGZMP
K6seuHzowDkNIP/v+dXe1xVVD6wt+rN6UUaUQ/LmE9KsvKoHrNhS1n8Hhs8h
Qc+ZleyqB2Q5+yceB4an45PHJ1VYVQ883HeETxLIF/jufq6CUfVAhvn8+3OA
4d/demxHO5C/59jl6aeSohxOyppNnAnUv703oNYQyC/JcE9IYlM9cCvD689s
IJ9pvrwbx3+VA7I6QeLxQP2CCe6XVH6rHDDv2+xyCMg/6fBTzBDo//IdhxIW
A/kM2mWvGoDxZxUrJiwN5Jcqtz8OeQUM7xApQ2Mg/1rBxOpdwPD9ITBPqhLI
D/aZUiwB5KOnDwBQsgJS
           "], CompressedData["
1:eJxdkmtI02EUxuc22hRZLuNsa5DTGgtjvQO/mFl2UWEt8grCapJakMF0xkCt
xMIivCVSEWpeKq3WGLqcZZT1VNZoXjIz09Qk6QJa5lQilmR/v/bhcDg855zn
8OOEZuYmH+HzeLwwLlZyaJTwgtBHiHi1IdjwiSGlpsu9OEkY73EvbxllaFlr
PakfI9y8c/hAxjuGAkGQ9ugI4daY+XjKMEPfqYPK8H6Co74vgV4zlKnM2onH
hLS2yoK7bxkaJarKVCfBXppg6Bpi6D0t2d/YRPjj50p2DDIEN4m0H2oJcdke
229uX2Lkw459DYTtJZvjrowwxLQk5uXXENbxq6s0YwwDnRbVxjpCxfNF+c5J
BsfZi6MvqgnHjPIRBXe/9by/61wpgfLmtkV/ZehW5OBbFWFN95B3YZrB82Wr
W11OiFd+n0+eZ7Cbh1IPcf5udURJ/QJDVljsniDOr9iwtzz2F0OxxddtuEaY
1lydMPoY5naFvLG1EcK9npjYJYaaQtklSTuhqfBnejNPB0Whq7eog1CkGG64
sczxu//ZVPuEAIFAHMLp9qSUM3oQZputjYN+Onwct3nEowRLUn7rynxCe531
Hse7f7VZmsnX4bY68IF4ivDDuzsqmqt1qh7NwBLhkXG2VyjSwXfCNFAhkiFX
Kp9RCnVYtZ7pA/xleN8a7gzl+k1lgRkzm2R4mWW3WP4yZKcpxTlSGazXO3eI
vAxTkZed8QEyPHWlP0vjeP3/D/8AiZsGrQ==
           "], CompressedData["
1:eJxTTMoPSmViYGBQAmIQ/eF8WL6cmYmDVvFKhnMsfg7HjDNezDcxcdh5fTJX
CbOfQwlv31sBGxMHryPvGUUZ/RzUvZ5n/NI1cWD5Z9X467evw4Rre3edNzBx
cJcU8/j619fB83CLThpQvsbjx737QPUH3fmUkjVNHD4pPOqe/d/XYdp+w11F
ciYO8y1NH64A8vX1fq2XkDFxCJRdPWUeg59DTKXKznBFEwe1y5v+ewP1/wjx
q/YSM3GwDJgmkMTm52C8Kn3OQ0ETB9tjas7zWf0c/vxN2pYiauJwrmLbIg2g
+8O3Llksw2PiEHr/pysnUL7jiVSoDYuJwz3nQ9//cfg5RD4+/rnkp7FDX7n7
sSxOP4cDPzZnbgPKLymTOpLE4+fQfYTFtAZofrbR49ylQPUCDlnC6vwmDgHT
FeoigfK+82ULYoVNHDhKJzpFcvs5GGrO/D4Z6L7a5XmXXfj8HF5deFlprmTi
wPVQp6EFKL9M5CNrr6mJw/n9tnNKgHwOwV1T841NHHZsTl2vCzTvxa+ZV6cB
5Tvz2E2UhPwcJuk2ennbmjgUfzbS1xH0c1g8eem135YmDm+M/iyXFvVz4DES
DitxNHFo6mngcuf3czBiPRZ6wMHEoVqx4roJUN43dEIog4+JA/MG73l/gOZ5
OFhP0/UwcRBNvPK/GejfkpvOYUJWJg4qP6xYXgL5HkftkrTNTRyupWv9fMbl
54CeHgDm79Nm
           "], CompressedData["
1:eJxTTMoPSmViYGBQBGIQ/Zx/yu1vJ5UdJhQZzGaY7+3APiGDyfWMssNLl6aV
aau9HZg2cxro5Cs7JEw2faW4x9shvW7H1ydAvo1Vys5oIP/yUUb/rYXKDpX3
rk+aD+QbnJx69XyRssPrZ7aa74D8dQuOOHEUKzv0rTZb8g3I33Pny6EfHcoO
4TcOPVLb6e2g/TPap3aZskNbvOvCA9uB6vnzasyjlR3OKbLYsx7ydmit+sXx
Z6aKwwPOJNdN570dLD4HNJy9puJw5Kmsj/5pbwfmnoo/GiKqDouuqlz+c9jb
wYYp78xCeVWHvda9/HxA/f8WxW/78VvFoYr5TA37MW+Hv1/mm9ozqTqcv8nk
9Hq/twPjt4srtR+rOEz++9kkYa+3Q2aZhSjLIRUH1m+2/d+2ejssUF5xQf+A
isOnL16RbVu8HW4BtT08rOJw9NDWei4gf+5cnr5J9qoOdbE2RVH7vB0ubNi7
28pG1SErTv65O9C9PieSvvHWqzrkCN/NVASaL7R+YddFTVWHNO0r9rq7vR2i
Z0UrrhFTdegRNZ3RtsPbYVbiv9SgbaoO2skvajuWejsseqP7tGaqqsNtfZfP
S5d7OxTd+rHjdp2qw0vdyunPgPKqke2LV9eoOlxqPnP/XIe3Q23epvBMDlWH
L1Ji/9KbgeoXMZ1RVFNx2L/PMH5np7cD64eEq1mRKg75upMfVkzwdkCPfwBv
0vDA
           "], CompressedData["
1:eJxdk39MzHEYx8+VXT8o1epUVI6c/Lq57/1wV523xTSh3X0+ZxGOSDsU2TGV
bDU/SkTZOmV+1PkxP09b1xmy2kRsClFSzY+QMjm65HQuX//649mz955ne/Y8
79czJWW7JpXL4XAYNv5lUWC9ommPDNUfDrRUB1DUGMZ2FjySAYuzf+ZFUORe
XrSvSi2HI+lm3NZQCvugzSwKluO+sVBwfiKFj7aXtylRju3xJu6lQIr6/P6X
taMyaNpfj1Bvithtry44Z8hxymsZV8SjiHuT73fuuRyHVeGp7r4USzVzcuP2
zkfWzh8PO4IoOjWqaH6aAifnuJIzJlCkk0RHv1oJ62dPG9eLwkXWW+/FRKPN
FLjf6EZxuaFDcy1LieLy36IHQwQaERkor1Ug/tibTnsvQaQ+fvr3BgWuJD4B
uggSJvzMMIxToOtgT1FBO0Gm1WQdXjkfvvccbU+fExjXqTk5lXIsHPIVBDcT
dPMiLJ51MiRUVOg+PyOYWj2gP/lKCu2CyNPWlwT61XVhQrsEug/m1wc7CMxu
R1otvhLoC5UTV3YTNC/HrUsXGUTxDUd2fSIoqYoqq9VLUDMrJEnSR0CG/Q2N
s6VQoX7q4BeCoGVO9YtvUjyim79VDxCk/NHKUgRSxPSMvN/J6hs3zCE2KsH1
zJI2htUjOs/R3EMMIjjCx/avBEv8NvZ43xajpPhunYXVD8YkWjIDxMjM6c7t
cxBYvjZuyP4hhrPV2RvO3i92yBSzgorRtlR81zSWotGZxxfUzsPNhrTjQg+K
Df6tM88eF6NyMOSOO+vfH+E01aStDEojmz++Y/sXtnhP2mVksPtZ5eQxnhS8
jAHH1VExVqUmjHizfq7Vqvn7oxlsc8jDqlg+umLCzeoyBpVPnTlKH4qi2T22
E48ZtISF7fkynuK8fxw/q5+B/9zCpD4+Rd3ioHBtOoP0pgWMB8vfomwc411l
4PFCfT+J5bN0tS55t06C5cFrjCq2/la5T/gxQIrSdZu3TGPnzw09PUiapGg3
7Yj18qMoa/QxuIqkSDtaVHOG3SdvxbAtNFaGgmS7+y8XwQFBd0tUvgw+792i
XVyK///jLyjLYgs=
           "], CompressedData["
1:eJxdkmtIk3EUxucos5Qsy0QZaA6nKdLFSqaFmaT1/r28/zkvqS2niRHOdKY5
KhOtvJVgQ0zaUhgaSbg2w1tpjwopRhHlJTXKa0MzSSnJmdRrH/twOPw+PIfn
nPPsTrooSeHzeDxvrtZ70HNNQKuI4sjLJP+RSAaazVU1M24UhbrpQXE0g8LA
YqdndhSuocuXnFQMpEurJ8dsKJJLOix97jLwCmMCW4QUhshNA8s1DEwq0dzq
HxYy0/e4928Y6Or56mMfWVhfGZ3QrzEoUFcMP2xgkSo4uPGqE4E830Vgq2LR
03HH46QvwTGFPjEnhIXzWRPZKSVIuOc/63OdxYSsuqUhniC3pzdzsZmFTkaE
gckElQuR5sYFFimytfLhCwQGx/GCNG4fd5nerFASFP2s2JTJcX7e4gklx765
9lbrHKdKD17n2pAhrxwphZjPNw1lEFg5VEVcKaBwKKss8r9IoPwSk5X/hGJ5
xx6PWgXB/A8Pi6H7FN2WZvM2CYFfaYc8rYtipTa1aY7zk11uMfJ1kGKvb5ZO
GEgQI/otCfhMIUyVR/jHEtjN+RhKORb1at91MQTeosPOw78o1jTuQWZKMPPW
dWyFJ4H6xqyLlNOLTl1Vv/pA4fnmMa/9EMH5rkGi5fzAIWPc2ZOgM+z6stBA
Ic1q62JZgkxNf6zuFsWD7rrOohACLcmMGmmhsGxqzGlzIShLM60+ekZxXOQo
trYlONBgM9VYTOHxzbihk5s/atrf3xRFsfVp6NuMBO5+86/b6o5SXLaX5EnE
3D8EfpPZ5ygmrNWPCrYT7Aut3xJcRkH4AwPGWQZ+iuHKRE5fktfXnGpksPWa
QBmromCFxeGeBgZTt+XhrJZiV1/Il3k9g2vGpNb2mxQvCs2LSzkMrIPdsvka
iujnFarpZAb2o4VxZ+QUj0vtRz/FM3BJn/yXV/7par/1vP6f378Tn2bE
           "], CompressedData["
1:eJxTTMoPSmViYGBQAGIQvVvRKFDzmN+B7RKf9j2IVHXYzGSkFX/W78ABhZeX
tZJUHbI6p148ccHvwGuRAN93IaoOHRaG9Q+u+h0oi11ncj9b1eF7R/uzD3v8
DmhyyN2/16vq0Kzht+TVNr8D+cy6wiYtqg6ePEza7ev8DgQ/LDH/Ml/VweSL
f8HGWX4HBCax+jyYpupQf84ig6vV70DJDH39A+tUHd47/FgdXeJ3YN+U0xNK
Vqs6HP6/Mftai9+BN37l8yriVB1CI+KFOxr9Dlg+ujVrH4+qw2TGBV3SQP0n
+R48Znqn4jD3XLzR/Aa/A/6Wpy92bFNxcH+pWzm92u9A6ernS76vVXGIC7hv
tLze78B0/99BT2aqOEyc/ZCtps7vwO5PkfPY3VUcOH8uSN/cBFT/dLMNv5+K
g6yS8NRNU4DuXbtrs7SaisOVArND7sDwUP3wKKJIRsXB8Y5BqvVzvwPRU24q
TNZRcXhbr/rn+ze/AytaChtFJVUcVkk3rzz40u+AeVzBno8uKg4aR2tned4E
qr9++JNTqIpD0PuVc74BzTt5JOjk0joVh+3X707vO+J3QCPwaZZUmYrD6rCC
zlxg+M6rfepY1aXisO9VzBrm3X4HjJd+3c6yQcVBb6rQXb4Dfgced3+rULyq
4qCsNe+IIVA+lOG5grOYqgNblmHFjP1+ByKmvdDZ7KHqgB7fACcM9O4=
           "], CompressedData["
1:eJxTTMoPSmViYGBQAGIQvWyxzBk1S0+Hh05yB3tNrByU0xP9ra08HeJjRVcc
tbBySBNbeIPLwtPB9efd8y3mVg59SSLxHkB+53mn5T1WVg4bFd8tOOHk6aDM
bvaDx8bKQVYpz0/VxdMhc57QMVYHK4etuvmbZT08HQQdu6N3W1s5BGevXvzF
29NBsu+58QKg/E3m776rfTwdojLXHtaxtHJwtWxX1AjwdFDY/Ld0B9C+pd+U
bvX5ezrwVTVYRBpZOYScKzJZBDSvozPx0StjK4cAxU2Lz7h7OtyK/OLHCpQ3
Pv5pXRVQP/tNXrMLslYOWyK6nmgD9c9a3lLYyG/lMP/o96w3QPn6M3vL5Lms
HOSzzF7V+Ho6/JkcPK3mpaUDP4tQ3Bkg//cKbRcdIF+0Wm6SgB/QvI93rhUC
+WdOzc74A+R3THZdvQTI366rqsYMNL/o/EqpYiCfY/XGlq1A+XUV/Tcm37V0
uO1SHnUC6N7HFwTXLzwFVC+4Sn8ZMLwOCVf99Xxm6dDyVNJVARjePo/3LLn2
zdIhXtzksbKdp8OnBt7HJ7mtHNQuvSnQsvV00DQ9qmsgaeUQ/XLrzQhgfMlO
PvrXXcnK4c4joMFAPvPvnwzvtK0cDt3a25hn7ukQIqQ8tRjIX6V50koGaH6c
mv51dz0rB/T4BgBgINMS
           "], CompressedData["
1:eJxd0mlQzHEYB/Cd/jrQTCexWBaR0SGmcm5PJJWU/Wn4/Zau7VhqmxxTCckx
7ExhyEwG2zDGKrrEtKoJj2aamrRbiWrY2tI4JtOF1Org760XzzzzefE8L57n
K5ankHgzgUDgyte/rlf7PusNo9j2rrb1RL8UGqSNFWsvU+yTuHT7TEohriw9
qyaH4rEO++9+H6TQa2t+xVhMUXfO98lQpxQij+aqzfQUV7orj+a3S0EftOFh
hgXDer1zQv2AFCTinophCUNFipGNzCBQMn6xVpHO0NL25q4FCwksanFr7i5j
WPCY+G1fR8D8TvihjCyG+3urL27xJDCYfJJzDGNobb+sycuDQMfme/mlIoYv
t+bYubvx+5y2bWgVMDyVNouL3kxgLH6xMETM8JKsSGUKJdCQ3fKicC7DrrQA
gYEQUBoHcuZwDE2Rl6d+7SSgzpV7+3ynWDGQWKgKIZCGQmvhEEWNKVZ2m583
jjlqDq1mKG7zGnTZRyDQw0ZSpWCYX2x5ThtFwPv3R7Xcj6EuOKhu9ACB5XXa
idkLGE59zbbykhG4laRKnR/IMMLf+aVNCoEjAecbS70Z7hxqbe1JJdBpcK1y
nqS4TNUXviKNgO+x9gL1K4oTotGOJN6amWfyHFT8f7QW+8t5W99ddSE7hGJR
6LzuX7y/fSmcXriF4q7prhHDQQK7H2VuFEVQdPDvslwSQ+BppPUnfwXF2zJt
u1MsAbPYTM5BSVG19PpWG96ma3YWb5Mohusso37I+XvpDnOSZIoJnuWmSt6v
FRkiA+8/jp0lHrxjqmXrZcEUe/5knhrfS+DBm5+nrVIptp+VC2v4e/b3X6nT
3qHYxO2ozAIC9/sS425EU2zw1yiV6wlEGAK442KK9Rc4MVtD4D1XglftKB5J
LHdOFRLY8+Cj7SYfisP3ypbozAjUaD7XXBVRbM57rg008fn6L69/Ae+vT+Y=

           "], CompressedData["
1:eJxdVH001XccVkioaQcz45rmbKpZ6ka5bPMxU51uDtf3+/t9b95KtJCyvNWp
vLSaDM3tjRax6856GdeJJi9LH73gzAk5KW915URSJA5Xd8p++3d/fM7nPH98
zvOc83meZ+n22IAd8/X09L4V5r+d8kfiwMRRHmW3kz0VvxHoVBtHHQ/msUGu
wac/ERg9VFZz4gyPmguX2yGLgIFUZpLbyuPb6cT+gmwCttZTgeeMGNqu9xqf
OU7A/jhdfuxrhvuuu/ikFRLwPDn6cL8Nw2v7RR/kKAmE5qWnR8/wqF2z4Nl5
gS8o3+Xge04MN+/a/3FMGQGuaCC2YitDZfEIc68iIFMpIvhTDKe7gxULbxBI
GIos6iIMC75KT159i0Ducq+eQAuG3sry6MAmAtUx1paP7vM4YtDNjrQQ6C1/
7bdV0K+InO9T2kag0qlDVdbBo2uc4yeL2wlkXarQ/mPGsOfg5rndAg7/7JR0
ky/DlB/39rUK2EMVX3Q2k6FDTm6N8z0C5vZ0cqiJYfPZulyFgO89btPUjjF0
MtkWe2yAQJVBW3xtM8NtZT2uYYME8le0GtUWMzztz826DxNo0oVpLikYrjU1
m8odJ+AlWWlUeIfhO3CcOKklULNPt/KkjmFTkuern98REFc18unOcswpZS8z
DSl050iJxyzDjWZ8EtWncDiq3W9c4NOLo3p28ygs8+Y2l5xhWHM/IPOZcF9x
vnowppGhXXOnQ+QCCl/O2KS6aBkeqZNfH15MoSkg9cNZRzkOq3v5KEsK9use
dLm9YHi10SfQz5rCAZsvfklUM0x9XB7iKqJwf+7Iloq9DKXT1mE2SykYPgrt
OHuRYf2oWn5xBYW1tRJpqoaheNDb39WFQnxMW73BZYaKThuHDe4Uyu12iDMT
GI7dmZySA4WX7boSM0/h/1UtzdHrKYwRnXr3Loarsw3bWqUUXj94c60lj6HV
ds9OsYzCoS5Tw5h4hhPfaH6QUQoLekQBi/wY3nVIXfU9oyBTip5WWjL8VF32
PGsDhYJIUVJQH48H3fqKL6yj8MxZtFBfxWPHTZPgW44U1mhtz12O4nG5r8RS
Y0Uhud7WKWAVj2kPd7bqjCiMHua3ZZjyGJLXbm74PoUQH8Xp+iEO3Zlki9lH
FErGfez1l/C4NWZJwXNjCrTxRtvMIIfZ+oXR4fMp6BdIUsfqOKw+97nkkY7A
wM7dEcO9HGZVdvUZCX4ZstCKI0o4DHecbEzrI/CiIW1e/x4OPfIXX3nzgMCr
PSbtQW4cmpsty48T/KaStdhnxHH4Xah8o8ltAswle+/VUg5ryjKmlEJeTKx8
b/YL+ha9rS6WXCLw5ICFeoMxj8merqG1Qn50KdF/JWg5bPhb6VOlIiA68Spg
RMzjXN8TnPqdQNKm6foLLjyOF/rKS4X863R/+t8V+uDXK4NSuzwC/++LfwGf
WRUT
           "], CompressedData["
1:eJxdklswlHEYxllUmlKkGkUiacop7ff9dxDe0FhZNX3/b0MH6SDGNFSMQzoQ
laLTRWwUyqiJrPO0s6nedmomxyRtlEETkfOhk7ZIt10881z8Zp6L3zwW+yO5
EIGWlpbtTP71nNaAN+dWUrT5bdLxYEIIB4erNKPeFBOrwt+l9AgBdRdZ7Yqk
qI541LT7nRByb9csuDvD3WSRrYY7GZiXZCSVSyg6OsSUmd9hIDSoQvtPKsXH
OpmWvIqBRObHwJebFFOGRacVG1iQzXVRq0sp+ra1fjDNZ8Gu/NZIbzNFiTJ2
hfU9FlSBWvqTXyn6ZS/Z51DEgtJnnsDGnEe598fjxvYEau24hu0+PCbEdRW7
2hF4byiTxUXxKL7f2XXIlgC3J8Ro2UUen3jN0jEJIfA7ynZL92EeY8Xqcw7R
BFanbTYLPcSjU8U9+3VnCXjOv87mxfLYZzMUn19MQJQk9LhQymOYx/BJvUoC
P32m2/e18dgCskTdrQQURnWxzgIpgrtHsk4fC1Xj7endG6VoKhgUZ3Ww4B5g
AR8NpVg1ra0u1CaQundHg8xUit8lPfkJ6wmYNKwuNTaQYu9rz1WXrxHo9sxS
GQ/zSJPN01a9JCBXGrw1buQRGc24YopAsnKo1ymDx6VyC99JfREEKut/BQXx
eGSNON9psQjslUXzU6x5fJkXoYlfKYJZl7Y9tByhWOJc7dioItC5dyL42UOK
GS36YZYzPhQbMucGJ1I8EeGfEzObwFU9l8opMcUDcwpaau+zUBbWmWTtRLE4
3stlj4SF24IlJX1GFNf217tasSxcuylpLxzksGCnFAbMWKj8dWXM7xOHzbR7
4dE6Br5pAs+fGuPwVc2mpwVqBsof9GeHj3LYcEP8fKSCgTp/RXZGNYcjCQ4m
lqUMNMnT/cNTOdTUB+YeIwy4vgiu/POcw2iX/hybz0K409juqRqf2Vt+xm1w
UAj///UvOc1Pgg==
           "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQPc3P9AjTpQQHlSgzzd35sg6Hftm3/7yQ4GD2Ya6t
TYasQ7a0qeiMiwkOzUeu9+oGyTqILIjhFAbyD0hcvSHiJ+swl6EylRfIn71/
xbvbSbIOaVMqutSA+oNdVPf3l8g65D1zc9cA8tlDVrncXC3r8ORjpPO5cwkO
92cHfg49JeuwYfkhl4zzCQ5VOTriD37KOtgE3VjgBVS/Z+6lg7/+yzp8iWW4
EA7kHxBzvif+RNaBzbuUUR9oX8/Bvde3Msk5rIrdIfECqD/Kb3G9BZ+cw9qW
d5N+APl+x/m0ClXlHGRaRKbbAdXzF1uslLOXc9jdKcDrCPJPF6tkTJqcw5/F
IpJNQP8veS/3e0utnIOgytL+/MsJDjJfd7kmlMg5MOl8eu1+JcHhssLug2yT
5By2fNlk7gTk7yw/6Vm0S84h+3b34RKg+vojK6s5b8k5lL+6PfkikJ/t6W45
462cw8TNoe9WAdXHv7tYtvycnAODkaRxHpAfLfZnYq2xnMOSN4/DFwHVuzmf
aeCTk3P4bZS0IQcob/nu3uwPf2QdJk6ZWd4IdB/7JalmvxmyDhIeq7dyA9Vb
ncs9tLcIGH6LAhK6gfJro5qeW6bKOlTf2R6VDuTrzmo5+LpS1gE9fgGf+d+d

           "], CompressedData["
1:eJxTTMoPSmViYGCQA2IQvTj4T0tEEOsBHb2XzQe2ezh8Sznwb4Ix64FPx/8d
Xr7Dw4HzzKSl1U6sB7ZW8LzatsvD4Vhfx7nrD1kOmF9KXjp5t4fDrEuTX0g/
ZzlwPMlh9sE9Hg6n3E6Jee5mOeA6S9aPda+Hw761ggctdrAcuPW4taRin4fD
RP89IhkTWQ7MMa2In7rfw+G/e8y2niiWA27sKon3gfIs3x5dbQ5mOVBdnHcy
4YCHg2D5y4J9SSwHWmd4r9oG5Hd/lWR75M1yoK2iXlzwoIfDr0aXk7PYWQ7U
bjAMyQLKZ8ipT1sK5AvOXb94N8g8Rem3sRosB+KrfhdfBLpHW3aBK4Mgy4HP
3wwNbID86Z9F7nV5As2fyqW1CuifuTzGN5+YAt3HOX1+KtC/hvPm/Cl0A5r3
VrJiCZAvK/3itbMHy4GFkzSvftnp4VDQ8nt7oyHLgR+Vz1fbA+Wt70gd/weU
r5xUcvYJUL7lYuDmNQ4sB6xUBLiWbvVwiF8fqs4Tz3KgPCOiZ9c2D4ftUamM
eY0sB54XexoYAOX3vahyN5rAcmDxGbaZKUB55SgbtlJgeFqsM/XyBcqXv2B9
WezPeuCJyj1vbaD8v+tr1+9PYz1gPDmuKxEYf+jxCQCABuEb
           "], CompressedData["
1:eJxdUV1IUwEYnTbsobQRCxGbZjeatlgZLRnS7kkprelwc1pJ5bfqjkpjt0CX
YYktV9RyQYXZRMsotVY9ZLXUZNiC1kOJ/RAYw6aLiiwb/YzYtNtrDx+Hw+Gc
A+fL2GkxcPEikWiRcP/wnu/ZnoldBL2B4orqWMSbB23pZYQVY5z9zLQG8vlF
qrtbCW+cxWGmnIXvCzf6yUC40Ld7IdPCItwb9ZZVELJzTwd6ullEUpKTxOWE
ScW8kdIBFnaxQ2kpIYjVmabrR1ikdvin64yEl/mr+2wrWegeDvW/20DoOrxq
5iPL4vnMzea29YTBQOz7jkRAwzok7aWExkpmo8QMuNfpdOMFBO4JXyO6BByS
d6SN5hPiqnHcwwNOFWPbpiUscxtL9JsBvn6y9VoOwd4sMwYLgf3qluANFcHZ
FZp92wGcCy05r1ETen4evSqzAGke6ZXFuQRltOmxdR8Q4f0H5CAYTNUZT6uA
5PtmxZ1sgi/v1t6AC+hM9Cb4hP5QQ9j6zQ8s51KCb4X9Eh7l2EURQFqr/+El
Qvvns673f4Bg1sSmtcLeJ9aIUiUvgKQF49HiGsIDk1TsfA38Zi7LtLyQ5zVt
6e0EKjzuoQ/1hKbMyuE8gQ/PDc7qPybo4fQRixUo5BluTi3hpLLb0loAtMUa
D7oE/6uluq/WXyymTo01KKoIF6e0sYHtLP7/919sNeBX
           "], CompressedData["
1:eJxdUm8s1HEcPmQab+xYK7TrOv+23705KWZpD37fn4ryJzJ2TZ8fV2jLUalW
S2NuM7uuImYoc64X/kydEkat8zeSGm0mS9NSW3Gl4VLSeduzPXtePG+ePc8j
F3MTNY4SiURh56YuSzOq/5YRxrO3ZV1sYnDI3nBSmgiJ6ZUFObcZtOrBI/pW
QiCna3ay+8OLjn4lTQR1akP7yxkGj+6YuZZHBEVQy5zexhBXO2ON7yKIvQlc
bJyAXRmLaZFmgo+/V+OHOgHlz1dCbb2EoLdFY1aLAPfJWYfJVwRzbtHIsRIB
N+aHR9pmCSrXoqEn0QLiE5a5E8uEPy+2y07JBUh75HpXNxGDpW0Fnr8ZVIET
Wfk7RBQG1waFrDJkdGQmb+FE7Pvkas3nBIzJJqaDd4sY0F6Q9M8yeP/IDGlX
ingQ3u4LE4Pa505NYJiIcdvTzqSHDMmxpnvfvUVINnGL4ejVx8bOdXsel4jo
Zi1DieKgaWqJMKoxnru2h6FnZPq+7TNB0+9cn7DCY42/67tznLC/b7IyzI8h
9Bk1RHQQpBajXpHEcDhKHymtJxhTnCp0/va+Lp9XKA2ErNEuz5QYhg5lehWV
ErgzNXN5MgbnAYNq1b7HNw+ozPM81OEBvbkVhKjW7Pd5X3hYhxaq4nSEXzrL
6a9mHqnvPA1lhYQG61lN6SAPldtC7Xwx4aSsrntpg0c1V5xTfInwxmV06nUA
w6GVrXv7rhBsa2lVXskMY63uxz/eJBwoX/8ZfJ3h/3/8A+0p+74=
           "], CompressedData["
1:eJxTTMoPSmViYGCQB2IQ3bPS/+wBpniHsLKXoqxrlA5o2u0QOAjkT+K6NxXE
n7g0S+wwkC/nMyGHE8hfxaD5u0Iu3uH+73mLTCKVDkzdoqFRA+T7Rj/LNgLy
4xMP/m0A8k2PGvPqA/nvDBf9O2IT77A29f/0Y68UDzz0LPM7A+QvtLf/PxHI
P6vdC+ZbLJ31D8RfGfIkW8st3kFjP2P5q+mKB6Qf/st94B7v8G5JyfxL7ooH
rm+u9s3yjXcw++Vs7G+meGAWN2NqRVm8g1CpWeezTwoHTrhm/+btj3cIP/Ir
YDOj4oG6F02/ps2Kd5j5RKSi6YrCAQveb6d9lsQ7pEybN3/Gd4UDHdxdBvwH
4h2i0gS71i5ROFApK8Yvcjne4Y19UzvfKYUD3JsvnHsJlJ/sGf5LKl7xwIyv
a7YeXBrvsFiDs3PLTMUDEr/vSC2aF+9Q6s12+/ETxQNn5totP9od71BUdTZx
7RfFAwZHuW+41MQ7aO1lnq7konRgwz3fGOO0eAedHHvJx/FKB5awRNhPdI13
iP+2fJ7YW6UDDw0b3k4A8i3Z564QB/InGH+S6wHy1ZfluKsD+RcE+iLLBOMd
tt+5lOVxSfmAwDvNKQl34xzchS37MrerHDh3es8GgQ9xDudcBIO2b1Q+gB6/
AO5/5xk=
           "], CompressedData["
1:eJxdU3tM1EcQPtHgQZBDqwULwYMKCOVRXl5RwAHURpCS7v4ep1XEB/LwUahg
QKHQCKGIYEF8QHsUSvAOOCtasEIlGTxBwbM2SqVwoBIkICpKLYqF2u5F/+ok
m83s7HzffDO7Dts+J7EmEokE2DLuqjrvnj9SBGyLeXIXZwgcNsl0jAoXsF1r
HRYwQSBhxcrFdnsEPObk+j03RMD6RaPu3koBc0KCC+E+gSvnPPdWmwuYupke
dB8gsG+Pxiaul8ed6fEJNn0E5K6OOjcNj+LxTHFOD4H5nrFbrZJ5XFs2z6fT
QGCWr+bfyQAe/VQqiyKG96fikcpgwuP7VR4jZJjAUKBnYNt1DhfUtLZZjxG4
HZLcd7qUQ0lt5Hf944x/bWPakc0cPtUO7K96TiA4b7RjTM5hgfabyMJRAj9f
tVu07gFFF23Y0nRW3834+pJr3RQfh7a6DV4ksCPtcdw5KYd1I9mSybMEpvI8
gsoDOUw4svqOVE2g8OTeBYeSOHTxlmrtKghMNFkMFGs49PEbPT5TT4DvrlNX
3ucwUHEtq7+ZgG5y2aajVjzO1E7ciqwkUDmcnqSI4LGjvykno4pAxu9dOfdy
eSyWHVhe/wMBZbttWR7y+Flo8GhvNQH/pt1nvKZ5dE41KZfWEDDq7vEX8Jm6
I0JxmsB4qeWdrCQBW/oO/xPL6uvK2TLmUi9g7ryos6UaAuqUhtc3hwWMgne2
6moJpD109pbOFhH8Pqm48QuB8GjVdpCL6LMs39Bzg4DJB3nv9pqKqP72irzh
BYHESynHbJxFZKe/vjSlcDtym5VyjYjxxU8yVllTWBS3JFi3X8QH0fscEhZS
2JDdv8tTI+IW91ftJfMplJcx6xXR8OrLxEuWFHyN9pOIEqOx+89iKjRZgyJu
7/Q6MWNH4UyRmb1epsSOEobgRN/wByvRddPRy5OeFGzmCJYeFkocz1jlHx1A
4WqEIj+kT8TzqqfqjjAKyUHmPdV1Ir7uZkqDKNh6DSw1PShiuAVTtpxCu7zh
i/gIEU+EFewe8aKw8MePBw8kim/wGL8DCxfHisi8lnXvUTDSnVeI2OqxK3W9
nMLDaTZIMxFXOKd9GOVMQV+15sJzg4AX7XMffepO4e9m35q5WgFPXb67pMuR
gtsth1LbDAHTd37EhS5m/RmTHfJaL+AG85KvW2Rv49kCTuXrneyt3uY3snyz
ubqvmH/diD8iIFMZM8x8mQdT2iwge30bd5hTIEbiAgHZdOjQbAqrmazpTgFD
Y4Z/c5xFIcvYQL2Axue68S8CReYvnS5Usnoa9ZmFUwT+/9//AzC94U4=
           "], CompressedData["
1:eJwBkQNu/CFib1JlAgAAADgAAAACAAAAEEte+JzlXUBAbho2JSwSwLZlZaAX
411AwqT4+IQsEMBcgGxIkuBdQIe2rXfJWQzAb6UyINa7XUAFWAG+24wMwGID
2DZ7sF1AGw+22O1DBsCfSGIPjsNdQJ+kPMrzRgDA343s56DWXUBGdIZ385P0
vxvTdsCz6V1AnD4ntf4z4b9YGAGZxvxdQFCt+RKm/8o/mF2LcdkPXkBFFaS+
0bPuPwOIzKbtJV5ATDq3v2nw5z+6O8Zw0DleQNQvbCgQsfU/G8qaoq1qXkDg
ozfcR57zP35Yb9SKm15A7BcDkH+L8T/f5kMGaMxeQO4XnYdu8e4/QnUYOEX9
XkAGADTv3cvqP6gC7nk+JF9AVuvnqP4s9D8OkMO7N0tfQKnWNVoO9Po/EPLV
6Rs0X0AqV+/L9AbxPxNU6BcAHV9AqF6j9mxn3D+ln5GE1OdeQCm16K42ENw/
OOs68aiyXkCrCy5nALnbP8w25F19fV5ALGJzH8ph2z9fgo3KUUheQK64uNeT
Cts/8802NyYTXkAvD/6PXbPaP5kxFpd0C15AFAx5TsRsur9ElfX2wgNeQJxK
ndvf9OO/l/WstYEXXkAX9Mh6xU7wv+pVZHRAK15A4ELDBxuj9r8kHwWZ7kle
QBSpTZzcv/G/XOilvZxoXkCRHrBhPLnpv3fA0H6/ol5AIUzg1t086r+TmPs/
4txeQLB5EEx/wOq/dH6K48CuXkDcshB4u7nyv1VkGYefgF5A4CgZSjcT+L84
SqgqflJeQOKeIRyzbP2/F0MopdZ4XkB8v43euhQEwPQ7qB8vn15Ahq8KLxxz
CcBBRXr2gYxeQJ28OzJW2wzA7hbcarG2XkDeeglfqUgQwMpcz8YAul5AT7h0
zHnuEMC9vEqIg7heQGaZj7XQpxHA29GkuXqcXkBkIUDhR6ASwPzm/upxgF5A
YanwDL+YE8BP08LAzmJeQAuh3udTEhPAWNBGQBdSXkAzlDVF2zQQwGHNyr9f
QV5Atg4ZRcWuCsBoyk4/qDBeQAb1xv/T8wTAqpA8IQUMXkA3Yb32cckHwChj
s1oXEl5AXyvVqgLaDsCmNSqUKRheQMR6dq9J9RLAJAihzTseXkDYX4IJkn0W
wHEcwkI3/V1AHEqplVNwFsC8MOO3MtxdQGE00CEVYxbA5r0g2OfgXUBQUfUr
nUcUwBBLXvic5V1AQG4aNiUsEsCM/LMj
           "], CompressedData["
1:eJxTTMoPSmViYGCQAWIQrXNP+VtKbpzDQqmn/ly6lg6bV5taKlbHOezeM0VU
TtHS4ZPEldz9QL7apTcFWhyWDu/L79VENsQ5/DL1KD/GbOng35D483NJnEPI
+3j+O9ctHJTWfS9TK49zcLqc+0S02sIh91tgeEd6nEOt+sGyblELh/C5Bnty
M+Mc/hRMEHjKaOFw9kabQ0pUnANjcs51K3lzB/sWJoaJdnEO6766OkX3mTnY
T45Yq24Z53CCr1VrQoiZww111ZWF5nEOpQtmsPU/M3W48e7wMw7DOAeNSqmr
fV9NHc6t/64zUy/OYV7k9mfGr00d1B5c9xDSjHNw1Dsz94uvmYPD3n3Vb4Tj
HF5Zp+Sf6zZzeCdlZxzEHedwZfuZl5t+mTkcVWqTdWOKc3jNYiJoxmfukK87
+WEFV5xD903zOfNSzB1OKE33nMce57Bvg1v7xWZzh/NG3QFvgPIxq23ftJ4z
d+g364voFoxziD6ouq3wirnD+yLB+53ycQ7Ze0omS/hYOFQfvjH3JNA/2sf3
axXtt3D4u4jlL6szUD6W/zQ3p6UDezmPyZGIOAeDD42HXFUtHXasmyEYlxTn
8PbLveLdPpYO6PEFAO6Vv34=
           "], CompressedData["
1:eJxTTMoPSmViYGCQBmIQXdKw230iv4dDQ56crckpW4dsXfU/a4H8d8/8Qt2A
/MU3DvDUAPkvla1EdwH52t2yL/7weTjwT5Ar1Tpt67D6jKVsLq+HQ25TXN4z
oHzMqZ9J74Hy324dTzU/Y+vwQifCPwiov76pW9T0HNB8HivFEh4Ph5PTHJYu
Bepnb4q+tIbbwyHaX3JJ6yVbB6WZ8ie/CXo4VHHfmpV82dbh5s4jbw4AzY/j
lt82E8hvcOCRNAHyV6Z3b+W8CdS/fWvrczEPB3Neh8jnF2wdLgRl8GdJeziU
+2VuXvDK1sGXm9l6MVA+xcZL1eYj0D0G8XENQh4OT5clBju9BNp3lKFTTRjo
vxbt35yfbB3+1mafmQA0P1+19bDMD1uHjwtM9B8B5Y+5THGY8tvWIXZTa/UB
ZQ+H2oIOpuNPbR3W7/y3I8LAw8GJnYlT/4Ctw739h//90fRwUDzxzP/ASluH
03Ptlh8Fuqdry4sfh6fYOkxcEvWrDeieNQ66bPyzbR1E7I/d2Qq0z3OquP/n
Q7YOd8/09gVweDhcW52rz3fc1gE9fgDXirY+
           "], CompressedData["
1:eJxTTMoPSmViYGCQAmIQLfRTb6leWYyDKW/XM0YjM4fOc9cv3i2NcQg93ZPL
YWPm0BUg6BNVGePAxDXLer6XmQO3SPrvY9UxDg3c4Wva3M0crG6/PVLWHONw
ovnxiwfhZg5FR6JquoD8SdkhHyf4mzlckFncxtAY48ClF3Ylwc/M4cGyWVta
gPzp3N6fhFzMHLot5qZoN8Q4fLq8w3y/q5lD4kabfwfrYxziw4riJYDybWr2
M04B5dUDuzYudzBz4LCdHTofKH/62i+lhbZmDtoiL+v8gOZlLDuq9d7KzKGj
RK/aA6j+S31EA4O5mUN+SGzZvroYh5ZZx2YvBPLD7of8/w3k/znC+OW3hZmD
6xWX+f1A/sa/+12bgPq/5h4Mugvk1+x4siMY6P8Ub1fJB0B+xsJgNyGgfbWu
QhLHgPx4hytK7kB+rHhdAcj8mtvL7V4D+X9d1gdsBfJz/q1k+g/kb9qZNU8Z
GF7+crs33LI0c5iwcvembiDfpuj/m0WmZg6XUhVaFYHhm1zLPFkaKI8eHwBu
ELLy
           "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQXTpZgiVsXeqBtfxuq5iOBDh49FtN/d6feqB1Xcsq
py0BDjLdMWozC1MPxPgeXtW0JMDhfVvddqvg1AMmbxhXH5oS4HCoaYHHHZPU
A9zdDquZWgMcvhYqS8sFpR5YYH3w3+uaAAeNxGVv4/NB6h2DrpYEOLy63Lq5
LDH1wDar91uvxQY4MAmtiNxdlXrgGNOurgcpAQ7SAaf+/5+ceuDqqZb4V9kB
Dsd83JfubUo98IbruK26a4CDf+mJswU9qQfCgxcvFLAOcJBd8794xvzUA07n
064+Nwtw8P2zpvfM0tQD6Ys1P77XD3DQf59QNXFa6oH7r95HP1YJcOB/JJIe
1g7Ub7Tt2DXJAIeKDVlbcxanHth8aYlICX+AAyw8Wi/cD1gojuC/sAqXFA9E
8L2WnnvY04Xgw8IPAGZOolM=
           "], CompressedData["
1:eJxdkmtI01EUwGWYLpEU0coUM10WzjeSyqQOai9MJveC3hvoYimE/Xuhzlmh
7oOWiCW2+iJmD82CnhYVKnaofDHTlBHMGStnPmciLZ+J/Ud+6sDhcOCc8zuv
XepzJFfi5OS0W1SHtTbVfQysYPj08PeL3u8JtEnGsvPfMZyxSHPtPQRqVWHL
nUsMQ7RRSuMAgbz2ghvbYziqPVnCqy8EPgSurCctMIyQtYWHjRLwKy8VzrQy
XI4LCGqcJbAeqpm+85vhWa+9rvHTBH58Fk4ZoziO2qJthnECPZqT464Cx4xu
xaDKSuCx//EcRTNHw92Dr39ZCKyUiMQ3HEsd4EkCGVvCW+orN/wlR70g8zLh
eCu5SpiYI0DfBpTPJHD882h+KM0u9hdUOP+Ec0zsfZFeIaUQU23IOl/M8fLk
hf4Ofwqr5mfHNis5eiRKUys8KXSG6hX3ZBzvX7/dneZM4VqxNlSxwjDOGpvi
I/Ky6CXhgZmhvta41LZGoE841C734LgtasQ7T6yfdLXQXjnDsKyus2qTg5fi
PBQ7zNDvW7xlvxuF5zXetmF3jvv65DE+PhQiv8pcdAc4EkffOylklo2cjnDj
aOpfpNZgCrpg/aDZyPCEY9A9FB52pcZVNjCcWBUHlFOwrxm1U3kMizoadkSK
+RL5la0m9Ub8IoGW+rnmrlKGn/pE+UkgR2FRVmeyf/uxEXDR3UyuSmc4IOKa
TAQifbuPaASGL1VFrfljBArAa2G2hKGhxjd7XbxP8VRItDSHYetRd4m8l8D/
//MXJBYoiQ==
           "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQPf3SS/1VHsEHdn8/3fTkkaFDYocj6xrf4AO6u3dr
Ohw3dDCZY2R+Hyife/D7Yt8jhg6tVzyWzfMKPtBq+ezhyi2GDjsPqxl9jgw+
cPWIz5vXdwwdHvM9DU3PDz4g9qMrb+8tQ4eal5PEgpuDD2x4FJKdaGLksErL
ROD0tOADnflFnBdtjRwSTC4oigL5Z/WnxFZFGzlEi9o8mNobfKCGxaOOr9TI
oUDjej5jTfCBpXsPiqsVGjnccvvkbVwWfMC1RNIjsc3Iob6UW7jGMviAdPpl
wQOZRg4yehqH9hgGH+DIvH7O0dXI4YT4P9nZosEHfmjemHBS3cjhvpTxk83c
wQdmNpmeW/bS0OGwvaDBfcXgAz1b5mWvvGnoEHnY9d1LreADUyq60tZ/MHTg
vr+xT1I3+MDkyllNrz8ZOizjkblwCWj+NIPOzKlvDR0slKdwyJkFH+BVLpY+
/M7QQc7W5JGFXvCBKg1phUdA9QuurLhYahp84GbTlD6Nv4YOV5mfKV62CT7A
73Py7Olrhg7o4Q8AaZa8JA==
           "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQHcJVYNClFXBA+D2Df5S+gwPnxPRPK4D8QLF9+67p
OTi4vtnRZgfkh2dc49gM5F92cbm2XzPggG8ui60+UL3zUYt6YaA8//zzt42B
/GMrst/+BcpzHeVxngXkq7qE2HQC+Z2uPNY9QL4R+xyGeUD+n6ktv3yA5ml9
PGXvAtQv6Ot6/pKug0Pz8gnaX4HyXVey/vkB+fMvbrzHDJRX+VdU/lzHwYF5
4erk00D5S1/7UhYA+dLruxpB7rn9cu/zMiBf6UDfkpNA/qPt1y0CgfzjBk2K
bNoBB64WlzuFAO2bGxmjexDIP7k49V02kF9j0s12H8jXqmZc4wK0L72saZGc
TsABtl/zw6cD5RdVXzONAvIDJd4rLQfyFfr2/9sK5F9ac/xGCpD/zdMzqwbI
X3tJnTkQyA/aeO3rBiD/1JcPXC+B5u3ZG7XEXhcYXs4/1WOB8qWrny/5DrSP
iWuW9XxgeKCHPwCeQa0q
           "], CompressedData["
1:eJxdk39Qk3Ucx0GUkQ4GEiCEBSZ2CLmmp/ymN3XslOd5tvF9VDhOMBYThDZ3
cEMKbIAmNdkIBcGb1IwMwh+BHj+9zivCIwrTJYQ7AZ0QcBOzINkIsad/++Nz
n3v99b7XfT7vYPkholjh5OQUxc1/WxCk3x16nULC5Nep4koCVXxW6aKegqUi
M9xeRWCYfybc6kKj3DRrrWgguNhSN36wiMbm7vfP+F0gEDWIXusV0Wgb97bt
vkzQUfWTKtBGIdL1cuzJNoKa0BPZmigaFnVqQFE3AVxMMMxSEFAZ9rM/Eox4
+U+/l05j27hOXz5EoA46WUUN0kgt6NyQ84CAJ1wTsTmOQQlvopOZJTgXd2zM
7RIDk9GT2eYgiKSffTQVKEGfMM66bhWLW2mFr9+olGCm9+DhZU8Wse15219y
laLp6p2ldj8WTYLMOLVWCkXjm+XKl1m8mLs3sc8uxaunWnghISxgPb/JPUoG
a7mP/l4Yi8IqU0unRgZTfunamq0sLsYat8ivyJAht9VRUSysM7VX+H/IsJ7s
Xe8CFo871gxqApLhK6gpPbKDheNo2dRYYjI8f779cCGcy/tu1wSfn4y5CHGK
IZiFcNnrQbRZhqHGnoGNviySYiyjOfUydAmE8ddWs1AUfWE5nSGDsbixLfk5
QWl77m8/bJThyJRfyPQc5z+paJ4ckuIdtrL+w2kC5f6n5xLkUrx93YnvM0rQ
ePe4seGxBCFhGu2F2wQW1q/W8YEEbnUzfyXcIBDcbDLs4UlgW5FxYKSHQLwz
8uO2UwwGVea7qm8ISr7vL3MPYtBqETOrvuTuX9jsPJbOoFoV3dWiJ1xub1qq
C4P+eKVDeZzA+42xq+ZmGs89TNEiLUE/38FnJDR2jJuL5w8TBJ59GHHfQCM/
jdq3QU2QH3ZTXvALjUtDvbGyHALdZEzDrRQaHj2huqU8AqkpvuvPz2ic2OQa
4ZZO8G5H1p5j3L+s1XZfm5MQrNxn+/3bfyjwWpVPw1MIzjvnFy2cobB0P1h0
YD/n02R/QRRJ4YnXcN7n2QTTtNaYO5yEybd0X40cIvAPmE9aDqfQWuk++qiE
IGkqZ7H6KIWS4U+9nXUEnyyYBwoWKXjG2LcMlHF+rdn+cytpBOtUcmU5wZ2J
ddpqAY17HTX1fI4dWX1qjTeN0tWPhlM4Dvi7/ddiHxoBHk920RwrfMWv1HNc
sb02MZPj//fvX4fAjwg=
           "], CompressedData["
1:eJxTTMoPSmViYGCQAGIQ7Sw4x6XPNvXAurPZEyP5jA+sfKT4PALID9L2uZ/N
ZXxg57dVVhOA/PccTPsXMhsfOGizv7kKyJ/Rsf3cfkbjAx+aZ3z4YJN6YHdm
H/u2v0YHtkzRUV8I5OdvV2F/88PowNZ/H3fqAflfblh7fPlqdCB6+W1lVevU
Azc3CnZc/2x04Hjx8TUaVqkH5KL2fwkEymeFXw8/a5l6YMKtIyf/fjM6cNpT
ozYRyP9y9s3KbibjA4yRdo1pQP7BhYxsk9mMD/zh//X4uEXqgW3VzHdX8Bsf
cPdlVWsEygd3TMxnkDQ+cCBYSHkq0Pzgf/89exWMD6zazXv0B5CfF6QjlKcK
VP95W4cc0H2uk6/uO6VufMDCKaD+OJDvu0m+eL2y8YH7FwXmtwL9W7RO/Odq
JeMDF7ZkCpoB+eX6308GAs2L2Bol5gTk79JP36YtY3xA8YvSySS71AMvsrS/
TRc2PvBuobG8G5C/5ass70dB4wPo4Q0AmHG85w==
           "], CompressedData["
1:eJxdU2tQVVUUvl7UEbxCImFdUUJvlDGCkshkpMtUHHygrVPYnL2Po+AtH0wp
4zA+CAYdbZhEMzUfQGQ+AGVM7EYmxiylAHEckXxRMUgE4uV58TEima19r79c
M2fW7DNnf+f7vvWtkMRP0W42mUwx/KgeW3rvybVbko676hYkViJ8ts0YkOJt
0PmaQ7NLLyL8kFA10G+qQTcPr3nH5zKCM3TSkOJVBnWlTY9aUovQVfHxrRcj
DbLfLy2+Xo/Qs/Sbwow+SQ2rw20LmhHuP7m2/i5Jer/5aM6vHQizvki+098t
qbz13bo9ToQ9Lw1M8A026DVn4xB7G4L67JV4g3Z18g9aEdb9AQXDrAZtFDec
+/n+YL/WrMctkpIuRnz9by/CvpkMWCJpfnTWjKV9COP+7Etf1SPpGMOc4vOp
lBW7OsMNMql6zPoeWcrMZoN8FfBThHnpJf+MvC5pVJsjM36QBi8znQmFksbL
nRce+GhgMYd9HnhVUlt/kavOVwMPzjN8fw0abIMz99ZLcuuwalAWxzd+lpS5
l4mFaKBotaRLUt0+XANHdWp5/izp8W+ABuxmkO4j6Qjbu9iFcHJO08aAWkH6
8rcbFzYhPNLYkVxB0bUrvfJuIzBa7diVgkbE7GfLEJSdRVGCegoq50XzOVLh
rRA0ZcnZOEs/gntuOYI2BTByoOaZxxpBeGbM1vZXNXjhw7cc1bHCo3eyBot9
J5zOswlSMMvHaZDLMlPMgu4o/cx/Ufa+T/yDBam2xfwMr1WnDXc5GCYNPF2Q
gn+P5zO5w+fLTVU6RSk+PQjdXVw7dDqd111Q2Yngzl2CThHKyHaEo0z3ZoZO
zOZ1WYHgysn0CynTKTxpjm37LwjTqn4LWP1Qp8teB4LP/cT6e72tP04SlHzE
ae0oYb2j44OfJguyzI4JDCpGsMV9ZYsrFHSiJXv4/GMIa9fdGL+7WdDcbY2W
tG8RyvOtEQ1jJLlzfRDBfwvVHDIk/ceyQg8jfKQqV5L7/QmExoWsPElSn5qL
A0HZl/oG513lgPldHcsBdAlS9HfyPs1VATojqJDHk3UFIW1Z5AcTewX55b75
nYP36fvSxIz6MEmpa0cNu30JoWno7qLNdkl/xXqtH1qDELCs4vewfEkzg9r/
nlKN8Py+/g/a/M6Z
           "], CompressedData["
1:eJxTTMoPSmViYGAQB2IQ7Tnt7l0Rcf8D4ZaR/CwXDRym9L8zXCTmf2B34u1F
Z84ZOARdjPhtDZTf9de3+e8ZA4c/D3vYpor6H0iMM/sQedTAgZPlA6uMiP+B
VU8lbnkdNnAo77g10VXY/8Dj9SpX0g8YOOgIm8i0AvmFjoLPLu4ycJjhWRl0
Wsj/gLKG8mW3HQYOtvskVJ2B8k+bjH/83mrg8LWy+lgJUN7vzcLaNZuA9m8Q
SO8Hmq9f+Wm+yloDh0nFa+awS/gf0K25kbZvjYFDW/Z/kRtS/gc0Xds2lG4w
cIj9e0PFXtb/gGFn5lT/7QYOJ0p/CPyU8z9gzejbwrvTwEHv/L0SNSB/Y/ci
djuge/bMyT3JCuSf6Lt+9tp+Awe7xrRjE2X8D1x9kKN5DeifuFk5vixAfjpH
TjHHSQOHxzn3PVyB9uk6ujm0njVw6PDTKlUB8tcLbJSpuWTgoOAxZU2lpP+B
Lu7ZMc+BfPTwBQBqc6RF
           "], CompressedData["
1:eJxTTMoPSmViYGAQB2IQbVawxkDpot+BCxZytXelNRweXmGfVH7N78DfB9cX
n2bTcFgZ3b7l+m2/A0krO2feYNdwsHtoluJ7y+/A+eg2TyYmDYdlO1a92Q3k
Nxv/+H30j7pDwUN9mX1A9SVhoZU+QP1hEbvO/LrjdyBW3vCqOoeGw4NJuneY
gfwzfD4nz/5Xd+BZYjBlxz2/A1sn8bzXAMrf/LjrZtVDvwOuKuuLK36qO0Q9
Vlr7HMh/sKGudh+zhsPMeRuOMD/yO3Dc+uL+vH/qDmeXCYU4A/mvS59Vngba
75xu17P1md+B/W6TFGIYNRy4pplMqLjvd2BLzQ77IjENh5r1x+p2A83zcvkh
7qit4bCT3chnO9A9FcaRkz7Fajh8nyUnMuWK34Fd5y50+lVoODzrOKaSe9bv
gLhAFH98kYZDzq6fC3WB/ANZ0qaiDhoOR6ZG7Lt83u9Ae+qNs4a2Gg4vHp0y
+XrO78B83widfnUNB/TwBQA/jbTB
           "], CompressedData["
1:eJxTTMoPSmViYGAQB2IQ3b3+4tnIS74Hjp6uYDBo13IQF3d/qnbZ98Dzj0c1
JOdpObzbu05U+aLvAY3Fqq8SVmg5/Jl7Z+nhs74HwnKa4vJWaTn8/1T/99hJ
oPwhGynbuVoO23ca2iae8D3g1L2tRKxby+HoVtPai4d9D+yPMYjVLdBy8HJS
yn282/dAl9irX/4xWg5PQntWrtrle+Ch0pzdTHFaDkIBbf73d/ge+PgqbcKZ
EC2HbX2sD35t9T3wfnFK8zR/LYfUd8fUObf7Hpj17NDbUnsth5fZPnY6QP1M
F+/uP6yn5fCww1PYa7/vAX7+xD8mSloOVYxrXPoP+B74/WlHXKeUloPs/eaa
UqB7jsee2/ZETMth5tGqyJNHfQ+8mXrY4qSClkPikqK8vHO+B1JWzjpqoKHl
sH+rsKoikG+eeyyzA2i+5a3Cw+8v+B6Y9uy3n4WJlkOUn9NLbiD/pICgx2Uz
LYf74bO3ngKGF4Oza7eSl5YDevgCAHhitFw=
           "], CompressedData["
1:eJxTTMoPSmViYGAQB2IQXfg3oZVhtZnDtBdlDspevg5HdguZxyqbOxw7yq6T
7+br8D0nfSWboLlDpbx7cYq/r8MfS9afN1XMHf7/FJSSCfB1ECl9JicE5C9w
ZWiUCPN1OLlp92wmI3OHArb6/TPCfR0Cpnpd/p1u7tB/0nbHNKB5Nm+tUuu1
gPzoJqfPHr4OSY6r7x5QMndQCrtle8XJ1+Hyq68Wsl7mDvOjaktD7Xwd6p4X
3YvyN3cIufxEot7M1+FJYOusGg1zh2kB3PkKtr4O38qj+/7sMHM4mftb7quU
r4P3C73OzT5mDl+TLZzFgPzrjNkGGUZmDkfX85lp//Vx2HpquVLBb1MHzdV9
B/V/+jjsr35zeZolUL3NyfTDgr4OiW3ZUeeumDqkbP1Zf1XZ12Fx+hGxM6xm
Dgdfu0y+qufr4O/2Qcr/uqmDBnOgY7+9r8OO9OUGDFJmDmfFFcq8TX0drs5e
s+aEp5nDY/PWqVyevg7o4QsA2ueZ8Q==
           "], CompressedData["
1:eJxdkEsoAwAcxjc5TIrCItaK1A7UtGVqO/j+HCyPvB9TJKw0Gg4zmwwxayaW
qLG8DhRahINlaZLXYZQiLMlbK4/yroW5Onx9/U7fry+6sj5P7sdgMCJ8+eud
9DiL6gWYSLzOtLYQDpfVcfpbYE7iMnG7CeKHPXfMG3Dop+nk9BBGvY7cqSdg
uDxVttVPkKeZDPYjQJi6HzBuIMgCFsJH3AB7UZOZ106wSINaOS6Ale4ck9cQ
5hWcIrsW2E1YcXXkECZ54sJTHVBCKyxuMcHY7sgKV/q4bWCtpJTArq/mfsmA
GeGH+TmXkMI7344XAkmrPycTFQRJQf6AKsbnfxa9yTASYpX+lnsRQN5FxZae
cNvE/9jNBprbHMU2C0E7VOs8agAEwmONc5Ag0pq/3CpAlJShtC8RBhXjfdsH
wF2D7X3BRri0Mo3MYML3bEhU5QaB76rqlGQQwm7UyaEnhF7+6ZX+ExjzmK0X
04S6MkWX7hWYlq6FSId8+/l1jYJAwmqkZ/1RS/j/9y/Q/6sZ
           "], CompressedData["
1:eJxTTMoPSmViYGAQB2IQfT/Z8v7m2d4OBV7Klv84TQ/YvPaOa1js7bA/tO3l
sf8mB35GPOBMXOLtYGdbV/rhjcmB3wLaun0rvR0iWs1TKt+bHHDd3XUhf7O3
g+3l6VtNHpocOLqojW3zTm8HnxfT5mrcNznwTD/wcN5lbwfBRRbS116ZHOC8
0c9scNPb4ejsST/efDM5sOXp+4hPQH4Mi5dWMYvpgQc/+rqz7nk7HIyuV78r
aHpgVVSp7aNX3g6/lypv59M0PZA/+/alWc+8HdI39J5tdDI9sEFppl3yc2+H
lbECeznDTA/MFe05aPvY2+GkgUdSf6zpgahNxcv3X/J2EPG+mnI02fTAof6M
+MJj3g7eroY3T8abHmirOHW3Zpu3Q/vK5xeUgk0PCLEXnNXd5O2wZcvb98ze
pgeC7iQpl6wG+id/ybYP7qYHfrZ3mzcu9XYw0ZA+88zK9MAdcTanrcDwCfla
t0AF6L53DQYWoXO8HYQ4GnXMRUwPoIcvAFbMshQ=
           "], CompressedData["
1:eJxdUn0wk3EcX+jQqdlsrbtckeQaO/JWOvV81YVuSIY9z9MLprZOL/OWo3Bk
iTtZr6LalbercK5bnXeeX3k/tUytutKtokSEONFiPf3bH5/7/Pl5tZfIw46a
MBgMNxr/OMp6XDTqQMDUx3PdbNYvKnu3nnNxOQGXg2LF3sxxqixlQOc2goOi
NhsrnH9JtT/oLHrVg8Ma33bXUEE/Jh/9nDXSisOW3h0NRRWT2NrNjOO/1Tg4
/w6q2VViwCyu2wQeuYLDqowRnmODEZtjODlqEnBYMKInOd+XQTj5zmxGiEPd
fdTrzTEH9aOLw7xNOCTuR9pRXytgrfTr8GXQeov6Exq1Ncils+Ux78SQotVP
OQXYQLKEORGrEUMvfnIpKng1+DWe1DsYxYDUAxWcQS4wrZ9ph1xxqLfaJuyN
48KglN9RHo1DrVQ1nbHAgeF4P1ZXPg6GxVs8J082jJ/BD3+j/V/me529+2EV
zCjk1SsGceAT7t0/wyzBUJg770L303HB1WZPjylcXZzxjN5GwAX38M5w0oiZ
Mlgub3cR8FC4Nd8v1ASqj/XP1p0iYN4jt6/F3ICJtMrW6zcJUParFHOnpjGD
z77c5C4Cih/r5hCux1L3V3kIVARUsGUGf74GeyFKdZZ2EjDdhiTte7WYU6S/
w50Jep/Z5wGxmS8xrUQhLPtEQOka2dMvI/1UuvxpUqWOgDF2iJR3b4wKEdsm
5cwR8OrGoa/8mgnKHktJjOGREFXo7XEHn6LiBT9uHt9Awg9vOxXX1kBRa6Xt
pwUktE0qTLsmTZClCVXaJyMh2ac4OMveFB24limzyyEhIMEju/uPOWpmJWiG
0klwS4vQ+VQwka0y1uteCgkFqJnzutIGpVtF3o6LJyGr49lOZRoPLUklTZfC
aL3UkpaD3VxE9UXeNzqQUDh/VFfQyEOHq/LyB2fpvOvqzc5bcNFSXlNcI50/
fI+FZ4aYjVSycWFREQHyN+qusSAm8vVfJ0iSEeC1McLx/ZglCvRsGJ4MpfvY
kaaMW78ciTaE3T6xnQArsWphQcRA///9L3h9bVk=
           "], CompressedData["
1:eJxTTMoPSmViYGAQB2IQLeJe6Xj/borD7tPcodekH+yfeeyp3g8gX2PLii87
RB7st77umG99L8Xh7ZPIyTskHuxncfNdlQPkPz6Vxuep+2D//anCi+cC+Wt2
CHw9E/Ng/5EFTGLrgfwZP/3UTZY82O934+brCiD/58y3XLUfHuzvkLxwMBPI
D8jmXfpN6eH+H5mNj0DmxZfwKEskPdz/WulBdjKQL7vkxR2Pkof7ty+fxf8P
6J7KaZmuTzc83B9tv2jdLSD/YKt/i9zuh/s3HggvWQ3ka9uvXWS/5eF+vwc9
AYuA/KWCEVNygfJbmqwcvIF83nviNh8bH+4/WP33vx6QH/xv7bqQxIf7z51O
/C4L5FcpvK1vMH24/7dozRMFIF+eaa7n7FcP9h/mL34nDeQbf/4+h/X1g/2+
y1L/iwP57M0iD0+/fLDfWWWeO0j9jG7h+LcvHuyv3ePWaAKy/2Gs3qPdD/aj
hy8APJvKBw==
           "], CompressedData["
1:eJxTTMoPSmViYGAQB2IQbWnO+PDeyYQDJztCz+7l83XQzmHbseBowoGvxT+P
Rov4Ojh/lLRv3plw4Ny2Ts+8Uz4OAiVbVqmeSjgQoFWq8onb16E7a9v0mbsT
DsieLox9vs7HYULyhITzlxMOHDf9wvq40cfhq5q2dhGQf2OiycmbB30c3Nbw
m0pfSDiwwanhUP8uH4dvn6axSV5MOBDmGMbIcdjHgePFvjk3zyUc+Hx8i1nv
UR+HvjdLW36fTzhgzXWsXOKIj8OkT++Ug4D6pT/f15ADqteRTSqKBKp/ypOV
8gcoL3BueZ8oUL1rYNihk/t9HN6kNmz4cSbhwKlT+s2GQH6WX1xKE1C9m8+T
u28O+Dj84Dd2PXU24UCNWtjCO0Dz9gak7t17OuGAxJRMk51A+4/eiTp9Eujf
TU+m/e48DtSvW9h5Asjf0MhxZt4JH4f3ATv1Dl5JOFD65vdpz38+DiUljFd2
3ks4YBX+/vQXY18H9PAFANxAwBg=
           "], CompressedData["
1:eJxTTMoPSmViYGAQA2IQXTJvo/7NMP8DKZoeSq88DB12dPH/VQnyP/A08EHw
e3tDh8Jbc/9nBPofKLPY5VXuaOjgn95kIxbgf+Cgue98WQdDhwcLNS6oA/nx
NRfl9K0MHRrNPWfwBfsfsD7hVi0O5Css0rluFuJ/4L9l4b0lZoYO+Y9Zj0uH
+h9Iyqlp3AKU/7JTRUICKO84pfKrNdC8KQ8vfy8FyoftDedgczV06G568PFt
lP+BJXHL7hh7GjrUBxQ9Yov2P8A5VzHNwdvQQUM8OUE2zv/AxF1za58C5Y+W
7+3/l+J/YPnhEJfpvoYOj0IEVizO8z+w59vutBVxhg6TGqeXvM/1P8CkuTG7
OtXQ4c77WQuZcvwPSEz+F8eVaejgPXv38j3p/gcaGfY1MGcbOnzv19Kfl+Z/
wNI6eaV9BjB88qawnUj2PzDnzYbLkelAfrBVxP8Y/wM5O5S/n48xdEAPTwDS
s547
           "], CompressedData["
1:eJxTTMoPSmViYGAQA2IQXaBwMlD1vuaBznUbWo/6yjkYXlUXqdXVPJB1NTjg
W7ecgyx3qs1SNc0DGQq3amur5RymdgpWiFlrHmDjLr98qVLOgUns51dnG80D
O9awiT+MkXN4wfaz39pe84Auvy5veJScw7bTJ7JYHDQP7Gpvef83Vs5hb/rJ
jg12mgdu3a9L9UqQczhu+oX1MZB/wkleJzlZzsHVRjl6OVD//OfvWlakyDno
T0xrD3bUPLDZ7VGXQZKcg46SvsBKJ80Dy288StEByq/jf90bBZSPur1Wemmi
nEMYg9OtrUD9Kz/e0JIByvcqV2s+BJrvc+PQIzWg/L1j3H3mQP3Zr2y0/sXL
OXAG7lvQ6qJ5wL3oJ//LcCBftUn9MVA+eGWdl5W/nEP7uvmRucDwaKgteXUq
H+gf/srTV/9rHHi2JyTnjLScA5+O+wkHPs0DYot6c5OnyjqghycAdwGXJA==

           "], CompressedData["
1:eJxTTMoPSmViYGCQAGIQ/dhc6464WbzDXhPXhsvOKg6fdpmYiKjGO3BvsV4i
sUnVgdnOvkdAJN4h0tjoRKyCugNXpd+RHKC84Dbj5Wpz1Bz+5Be/8rCKdyh7
7iaw67Cag0E+3/Usk3iHTtnrF8Q51B2qEhU1bzjFOzhV/Pt3r17d4eHKicu/
ScQ7uJ/d1GSVouGw8mP5lPeC8Q5f1vw/F6il6RARcfpHkGe8w4k72d8TtTUd
2D6qpfQkxDv8mrM7Vj9Tw2HFs7M2IjHxDkG6tc42luoO5TfXW98tiHdgbpvt
NFdAzYHF/Pufq0D1+bk2xjJaag7/7wnu2+sQ7yAr1HnzbJeaw+8+vttTPOId
xPLX3nvUoerww477R3ZAvIPAmYuPv7epOOzfP8fkhV28w8xzn32uHFZxmLZq
8cy7QL5Rua6i/BEVh2/P1BTuAPktc5OuKgD56xT26NxxjHf4ff7rjY9MKg4r
Qzo3mQPDk59/z9blwPCcpXyBVQrI9+q6eecRkI8e3gAMu6ZT
           "], CompressedData["
1:eJxTTMoPSmViYGCQAGIQ7bFBvWDhlyQHrveypmp7hA+k7zJi3vA+yUE2/ZXU
pasCB86eAQKeZIcZV6q1lvsKHqhaNl3CmyvZQceL8+CqLOEDFz7Z7Kj+l+Rg
OD3K6+MX4QMPef7VbWRKdlA+Kpv/6bTogdbXgTvkgOYpzzl4X19M7MChdiHd
n0+B5h84++joJfEDgrfESy+dSXKo+aX6aK2w5IFFsyOsWbcnObRNnCuUfUfi
gEnsTEaLhUkOEzVEnTWWShzg+C7i9aEzyWE+68I9/YvFDlRlzZJJ7k1y2L8/
LvHgUdED/ZWXH69dkuSQk8lRO/+N6IElHTyrf+xOcpAQ3jSjVljsQOy3CVNZ
Dic5rOvYfm7/X+EDi8/dcWYC8ssVFsrsFhI7IFmUY8t8PsmBQ+ALm98W0QM8
kiYzwy4nOTRU3djgbSh2IM/F0YrtapJD7zxZ0SVqYgf4u9m9GID8jr1Cb88b
iR2IDmOrOgvk1yXc65hsIHbgTG7YDfXXSQ6PTi9dXrdE+AB6eAMAyyyybw==

           "], CompressedData["
1:eJxTTMoPSmViYGAQBWIQnXLO+JuqWcCBzXV9r877Gzl0OK4qyrYIOLDsV8si
/UAjhyOVd49/Mw84IOF1RzIGKC9nNWOFJVB+Y+L0T9m+Rg4usw5NEbIOOCDy
48rv60D106vOfAsH8n+WxcyTCDdyqFqRe3iFbcCBkJsHL3EFGznM2xeiZG8f
cEBWlatjSaSRw5P7h0RXOwUc+LHz9bbQKCMH5j27W37aBBw4qljG2JVg5CB9
yZcdZJ7EJIsLL6KNHE6d/6PACOQbLc6cdTDWyGGZWlrSfSBfkvm1RR1QffdF
zTonoH4tRkNO8SQjB7EjsycYAvkFL22tpID83AKlX6ZA/1xYPKOoBGg/55Nc
BkGg/6MzOWrnhxg5TOMz3LkGyF9nM+nO6iAjB9kv2x5PNw04IH0rWnUz0P1X
gwO+WQP5u3bOVdIB8tHDDwCLvZZB
           "], CompressedData["
1:eJxTTMoPSmViYGAQAWIQ/eyn7JX+5RIH3P/o17xU8HV4eruwMumKxIHlHiWt
uhK+Dvom1zOXtEodOLy4V/kal69DQpm/nFiX5IFM1rY1eby+Dst2rHqz+5Hk
AXanTQ2cP3wcTq4u5jkxT+pAqbl/6YmvPg7rV3EuepcsdUDt+NxLB9l8Hbaz
dB+euV/qgH/EI8ZUdl8HAYYE7fBvUgfE+DRX9730cfjw5mHj9nvSB+5IWD9U
vevjsGqr2YtlHTIHfgdWPuB47ePQf6bOYrGj9IHCnPYLQZ99HLK1v02/Wyxz
QFAuV2bjPx8H/Yj/zw3mSx8w02S9Gwe0b3HbQ+WkLpkDm+a+X36M39fhp11O
n4SSzIGVBbukf8n5OuySiFuyOl/6gG4K5zEZPl+HnnuLFx/kkjxQcGQJp6qT
r8OWn1o/b7RKHvj1On7xNxlfB/TwAgBTWJg/
           "], CompressedData["
1:eJxTTMoPSmViYGAQBmIQLXXtZ4yQZsABl9uGpeGHDB3EegUq1VQCDkj9Ut8R
cdDQYYfALOFX2gEHvk7b4/15i6FDbqmlqoJ+wIGGy7sr7IH8rV8rjiUD+cnX
nkXxbzB0WBe+6G+kYcABt4vM8s1bDR1CXr3V+m8QcIBD6dnbZKA8w7qU425G
AQe8Q+s1V2w2dLjcV2a+yjTggORMs0sc6wwd4roLIx9YBhyYEVHi9n6toUPq
LsXr0y0CDlz62peyAGjfNfvHstZA+QeNjC38+w0dmoUvrtcFync/P75L+Kih
w0GN7x/bgOZZqCxRuQX0j/+3B/9vAN0T8nFC8ZoThg4VqUVHFwDdc8jjyoaW
I4YOLfWCJs+A7l9pNevmXKC8mPWFn/G6AQeY0++fNgaajx4+AGsTj84=
           "], CompressedData["
1:eJxdUm9I01EANNHUpSWswqmbOE0qnGyJ4L/ijNJ8b1rvmctwCdoWCoskEsqZ
gk2kJB1hpmmU5CoVpy0tLQiKtUmmGCaRES5XUihBmC1NVr++9uE4jjsODi66
5BTX+/r4+MgF/GNFmbFnZYzCGfm46coiQ96PvrUouRqmSxOa2rcM52pcuZln
1cj4NSc9/ZzhpkjcaZhQw6v3fCruY/BTThpNJ9SQNFhjtVaGsvzLmg4vReKA
XqfpZxivJKrBForc6ciuQwMMu24FBL9KoChdnXKT+wzXXtjn3Q6CC1ENMftt
DKGLeV9r5RQbt3XViB0MkoKjJ83dBJ4/OWML0wxye9H3G0qC2RnPVvtnhnil
rqL3UTZGhzpLOpYZAquqw6IDCQKk9W+cfhxzztYnLQUEmSZD5pKY46n4QVGw
0Fe3wIZlMRwH3jn77YkEkb9vj8wqOLQj4yJjLQFPK43QJXKUt03pVa8JLhrj
z39J5giSpbbee0iQ7pElpAj6WGVT4/pBgr1xkpQNaRxk6KDz+HUCbUnE3SOp
HGuuaNV8I0GosttcLPirk/7LigYhXzhhGU7n+CadMTChb1Zrcw3mctS9Nye1
hVP0TMUtNedwSNuyvK5qijOk3b9CzWHTeB3b3RR7nm0Ky6cc2ZuHmsqz1AhK
Nu1MIhyj+ywGwwqFNWSLu2q3sK/ianZpL8Vht6XdruTIUIXI1v2kqA93fbDs
4BBNFn70vUMR1yx5qYvl+P8PfwH15e4g
           "], CompressedData["
1:eJxdkltI0wEUxnWuLCrDK5WMeQmNLhasLELsyy6YmOH5p64i9UyHmg+ipmUN
Lw+RTAqFskkiDEtkWooKWzgHrfKSFIEXUCRlK+fyLiGas/r32sPH4Xv4fnDO
+YJVeaSWuLm5hYj6N21+WcnYp4Ii8nbnmXHC1ZToQV8PFRxzwnnzZ8KHOn84
ZhnPGxUjp94Ragsy5ANfGBWFs+MeowStu8/ldDvDoU5Vxs6JeWNOiK2fIXPl
xFYsEGxxD3UToo9q6c4uHSJY7ZFFdZOMynpLw2IfQa+ZTkxeZQw/ejucbiZM
psgXIsYYdc79mlwTQaZQaj3NjLQLlaHFXYTrXjVhUw2MUP3sx/J2gs45YDVV
MGZcCQVVrYTR95K0mkzGK2XH3tpmglodHL4ezzh97qmly0hY3oLF9BOM/iN3
M4Z6CWVNqcZ+GSNpz41tKyMETWBidcJRRsyn6oNacb/yjSVbp5whbL8yU/Sd
sFbcdKjwGOPi8cG2dhdh9delXOtZxtQdq7vdQ8DP0nmDt8Ao6X4j+O8Q8DpA
IRvJYBxwbm2T7BLgd+tZufOe6KXmAMs64X7Phn2zhhEuzy8tmSZ8Tdqt83zJ
aKuae6JbIcQshMR7mxgn17JajL8JP7x6gnpaGZrm0EgvkZ/bVeZzs5fxoDew
I1MiYP5ajHRTvO/jb74R3SI/7490tX6doZPsNHgvE5Ze9DmifFXQB0nDsmcI
+XHasYnDKhiiXXrLpPiv//rwF+h//Is=
           "], CompressedData["
1:eJxTTMoPSmViYGAQBmIQLainN7/sf4rDZ42pH1r4bA+4+J9awgbk91y0WjUL
yOdRP7L99L8Uh0fLxbZxC9gekP2RZBkM5E8NlO6OAcr3GR7c9ftvisPNNfMX
/+K3PaC55ue0e0D+ritrnW/x2h5wfri5tADIf7Ix1MICyI/f9DGhG8gX1l+1
4C+37YE47YW7U4B8zsfLC/M5bA+879mm1Qnkz5r61vkek+0Bxknznf2B/C3O
4bWcQP7n1ZYOIPPylxopXPtnc+DX7ku93UD3lCV3v8titD3g9fEjpyTQ/a/4
m9fPY7U9UBU8kesxkH/r8pGPRuy2B67v3XX+GpBvdGWP3Tmg/WbK96ZWAPkb
N9fssOexPeBh+PTFNCBfYK9C7Tuge9HDBwA+75nr
           "], {{-6.76733860000001, 61.44702590000001}, {-6.7170989, 
           61.45992540000001}, {-6.6715186, 61.3994259}, {-6.8692554, 
           61.4743544}, {-6.89940670000001, 61.5069656}, {-6.87985599999999, 
           61.5250163}, {-7.00289090000001, 61.6227032}, {-6.91664410000001, 
           61.6505578}, {-6.8959389, 61.6414118}, {-6.9281233, 
           61.62553340000001}, {-6.879208, 61.626674699999995`}, {-6.9425955, 
           61.59338640000001}, {-6.75131279999999, 
           61.57347709999999}, {-6.74837049999999, 
           61.5414465}, {-6.840446600000001, 61.5592464}, {-6.70283230000001, 
           61.4886281}, {-6.82495970000001, 
           61.471976700000006`}, {-6.76733860000001, 
           61.44702590000001}}, CompressedData["
1:eJxTTMoPSmViYGBQBGIQ7cBZ+0tyV6JD8YL2W2Ze7g4C0ia8b/ckOkxv3Hlm
/l53h/s6r+UP7E902JX0eh+HoYfDertFRpMPJTrcc5bdWLjEw6EuINI17Wii
A5Oq/+Jb4p4OfkkCEZYnEh1U2RqnOnd7OsT0H/qqsS/RYYGU/l2VW54OWXtK
JktsSXSQBnLZNL0cunOe/9bcluggyRLGp5vj5bBGJirFekeig/jNc9+D13s5
FNhyXV8MNE++9XXgjiNeDmZxuzx5biY6qBtyrJG55eWwtTtzmTVQvif+0KbH
at4OgjNXTOm9BpR/XNw00czbIUnaR27Vg0SHv03qdh0XvBw2zX2//NirRIeL
Srd/1mV5ORw4tdB124tEh8qXaoYcYl4O578HP176LNFBaUNRxsSDng6HDdUi
vn9KdKi51MlyOdXTYXv2jzMe/xMdbnxZsECEy9Nh9dJTjrO4kxxMxHfYhK3z
cJh/f8621+JJDv2W529MD/Jw+LD8mLc5Q5JDl2PC0wuLPMD+Xfkw0UEW6M37
0z3A9psB/aMMco6dh8M3DWCIXUh00AQF3BN3h442hSS7R4kOUtUOrxy63B2k
nzwx2fU50YFn1kfBHn13B+7z3kfd3gLD2zDI0pwJyJ/0+PP5+4kOl5r2HBYC
yYdWK0VeSnRouKLm9y7a3QFoq38vMP7e1dibxn1yc0CPfwDDje8s
           
           "], {{-128.3355693, -24.4078507}, {-128.35546050000002`, \
-24.3763386}, {-128.35699480000002`, -24.3661163}, {-128.3530787, \
-24.3551601}, {-128.3477787, -24.3502436}, {-128.3428864, -24.338201}, \
{-128.3229629, -24.3392358}, {-128.3009795, -24.3305276}, \
{-128.30586110000002`, -24.3418178}, {-128.3065478, -24.3492857}, \
{-128.2936088, -24.3887099}, {-128.2946066, -24.4035616}, {-128.2923535, \
-24.4197402}, {-128.29922, -24.4229151}, {-128.3130602, -24.413566}, \
{-128.3307628, -24.4108501}, {-128.3355693, -24.4078507}}, {{-154.1019395, 
           57.0455496}, {-154.7984491, 57.3473333}, {-154.0348596, 
           57.66341560000001}, {-154.1047117, 
           57.52533929999999}, {-153.9259814, 
           57.53368950000001}, {-153.7795994, 57.321156}, {-153.7570383, 
           57.3056764}, {-153.7119844, 57.29979469999999}, {-153.6391909, 
           57.2750954}, {-153.6259403, 57.2741379}, {-153.6212272, 
           57.2749295}, {-153.9348077, 57.803722}, {-153.2817515, 
           57.999745000000004`}, {-152.71803010000005`, 
           57.80909595000001}, {-152.1543087, 
           57.618446899999995`}, {-152.80351896666667`, 
           57.42748113333334}, {-153.45272923333332`, 
           57.236515366666666`}, {-154.1019395, 57.0455496}}, {{-74.1970089, 
           22.260966}, {-73.8751435, 22.51592}, {-74.0282911, 
           22.6879112}, {-73.9758393, 22.6681185}, {-74.0157536, 
           22.697942}, {-73.9574104, 22.7261567}, {-73.9270187, 
           22.7057014}, {-73.8577193, 22.7383756}, {-73.8347555, 
           22.7274588}, {-73.8393174, 22.5373708}, {-73.9756558, 
           22.3550827}, {-74.1360081, 22.2904568}, {-74.1850707, 
           22.2187398}, {-74.2927661, 22.1648617}, {-74.1970089, 
           22.260966}}, CompressedData["
1:eJxdkltI03EUx5fdWBRUli7NlpLTppWMdYHhkvkQ0WWd3xRtKDLbLLywLmO5
GqTY0CYzTIaWD0a2TBsiPriH5N8XhqGlxXRZKlY2Ksuyi9WK0vUf9NTD4QuH
84Xv+fCNLzQyQ4RAIEjgJ6zGz7aBrEUMPyaeVp5REQpl2WnSPoLSknt7Zzoh
y7SlMVRDqI4aexTcTZhZIl+zS09wF3X1cvmESmdmbelewnBPdYetiiCSaJa2
xhCCywqaDrYTWNL1S12xhAEz1xIzSXAkf1zFbSQ0v4lrm17NIDu7LV6cTTCu
rcKDaIbRvjJ5hYOgUk6PuTcxnF/XuW+KzxNVfGiuLpFh87FZrWqB8N7ZvfJU
KoM6I1LnTWHQhXPHMUzY5w1BAUOaKVSiiWQ4/uRtccooQdDT3mYVMsyJh40F
dwiPg5qAK0TgvxxSvCTEvMqN9nwhcGlXpaL1DPrB/AP9AUKNTTvSm86w4C9/
JwkSaDzWqitiaJpsqLat4Pf2hPrWKwxHv9Ym3vtD6FBsvfWaY9iw/KL35ywh
58OOu0kzDGGbbIogvf+r+YibwWcyy/aME+ZbvFZLGUP/0MnFyhGCz+LIv7Gd
AZISf+Yg4aYmR/nwE8FzweDaz3MI4/rWReh8VmBWc4TDvvq8hcA/bST4r/Fg
uwnPI4R2cQNBq1e8UFfyfOUVnow6QhifkveJnH7hiQpCafk5V+pvgvd7ct7l
0/zdf334C9dQF2o=
           
           "], {{-70.0054734, -55.1646877}, {-69.22190169999999, \
-55.0509838}, {-68.43833, -54.9372799}, {-68.58596, -55.1585101}, \
{-69.0113099, -55.0266799}, {-69.06891, -55.0802}, {-68.2451799, -55.22616}, \
{-68.1730101, -55.2925994}, {-68.53395, -55.3217795}, {-68.64504, \
-55.2553094}, {-68.66926, -55.2549995}, {-68.7242201, -55.2817694}, \
{-68.5742599, -55.37531930000001}, {-68.1336401, -55.3896393}, {-67.98188, \
-55.6744801}, {-68.65641113333334, -55.5045493}, {-69.33094226666667, \
-55.3346185}, {-70.0054734, -55.1646877}}, {{134.4102232, 7.27145439999998}, {
           134.4347393, 7.2797351}, {134.4329646, 7.30176699999999}, {
           134.4412914, 7.304749399999981}, {134.4253129, 7.31998819999999}, {
           134.4221546, 7.32844229999999}, {134.4240763, 7.33612009999999}, {
           134.4533027, 7.300639199999989}, {134.436454, 7.28796429999999}, {
           134.4494695, 7.2506646}, {134.418286, 7.26909179999999}, {
           134.3796124, 7.2145819999999805`}, {134.3395945, 
           7.25531229999999}, {134.379898, 7.2274078999999904`}, {134.4102232,
            7.27145439999998}}, {{-171.7417643, -13.8410886}, {-171.5836682, \
-13.8785}, {-171.53746810000004`, -13.9129408}, {-171.5710039, -13.9419921}, \
{-171.5245892, -13.9282253}, {-171.4406871, -13.9758759}, {-171.4341592, \
-14.0489098}, {-171.7647481, -14.0438943}, {-171.8334461, -13.985262}, \
{-171.9173358, -14.0043336}, {-172.0733156, -13.8661169}, {-172.029058, \
-13.8260379}, {-171.8663122, -13.794801}, {-171.7417643, -13.8410886}}, \
CompressedData["
1:eJxTTMoPSmViYGAQA2IQHb7ql/fB63EHQt7I9Z8383D45vhg0lqh+ANrjt9I
yfD1cJhy8+jNmb7xB1gXT7JiTPFwOLRVJfCnWfwBJolW4fYGD4f1fbqiqUbx
B9h2sykZTPJwMOpfyHHOJP7AJNevhlULPBzqHmefX5MUf+B695/Q26UeDn41
Ua+ONsUfmCCs1pM22cNBVtST9f6i+AOes/0Pfdzg4TCf1Y1Ztjn+wOYNPind
5z0cWCdLu17bF39ghTvnhn/vPBwyFT629f+KPzDn3tHfhXyeDjZJM5Uv3Io/
UCvO8MXV19NhWebqt42MCQfkoqTWHbHwdPgXaVt4ijfhwPutYVlrUjwdaneu
ct/6Ov6Ayh9HYfEwoPy+W2uu7o4/EOGku6fR3dOh/giX0Lfu+AO9HRKpb4D6
GU5ZlYvFxB84dI6ZL1zL06F4f5XwL/34Ax7N2x9r3vRweLJl1/q7zPEHzpln
7/zT7uGAHp4A0cmozw==
           "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQnds6/13R2dgD5+reiaqHBDtouzcEvZkYe+BbdJFw
TmSww0uOxG2pYbEH5C2/CWyMC3ZYfspR6r5U7AF3sSq+b8nBDvbXk49n/4g5
cFPnkxtjTLDDrcetJT+uxhzIds6q5wGa94al/9SK7zEHclYv/nLNL9jhj+oM
hUjJ2AM5wnczF3oGO2Tk348sfBdzgLX3y9/1NsEOzUen208Vjz0QL/Am+KV1
sIP4zXPfg5ljD7h05zz/rR7s8OL3yo+XDGIPHP6qEdMvE+ywQ671dWBc7AGn
hKcXlASDHZRv/6zLmhR7wC9JIMLSKNjhw/Jj3ubHYg/4mnc6JogEO+wpmSzB
8iv2gBcPk3b7tyAHsLhE3AENQ441MkzBDneA2veYxR1gCePT3cQb7OAPMico
7kBM/6GvGr+CHBwdJfQSO4DqfzAuTmMOdjBUUGDp3Bd34HOCY8ASnmCHxp/7
65yb4g5krVjD2CoX7HD+UvzPv65xBx68F9+cahDsILvmf/EOzrgD4ebNKW5O
wQ7o4Q8AbsW4rQ==
           "], CompressedData["
1:eJxTTMoPSmViYGCQBGIQ3fFZ1DOhJuTAnbY1J9dd8ncQOi3TqLcm5IBerMyH
kI/+DnMWKe/8czvkwAFJt+6/7AEOlTP3xMxnCz0Qvza6VfSJv0PohFAGJ8PQ
Azbq2l/0d/g7GLW/W/wkOvSA1MJfSV49/g4i9sfubM0IPfCm40WN7A1/h/m5
twyjZoceuKuY5S52zd9Ba867tn9nQw+c3/VakP+Kv8Oh3TFHyteEHjj3fFLC
g/f+DtG3TzF+7Ao9kM419/oN1gCHJwafK0o7Qg98m3QsQ9Y4wCGvTfrDz9bQ
AyAqMSHAYfsWKaHvCaEHvoPkqwMcvM/KZbBahR5g/31g/mrfAIcFqepnJ3CE
Hih7dLb0q1OAw5e/+kYy10MOPDt5y9veIsDBc5rF9OVLQw6Ebnyu2Kkb4DBP
z/GPUUnIgSMzvny/pBTg4FOZ/D04NeSA+vOqifYcAQ7vdGe/F2sIOWDjd3Fi
zD9/hzfzbHSuuIQc8C9/wZr5wd/hNf+9jImcIQcSFvyvLH3k77CT8deNH04h
B+YLX1OcdMvfAT38AdLIyQE=
           "], {{-77.17957, 26.5168899}, {-77.1342801, 
           26.5108899}, {-77.14181, 26.5699399}, {-77.3286, 
           26.59813}, {-77.3134608, 26.6658159}, {-77.54804, 
           26.89397}, {-77.62272, 26.861610000000002`}, {-77.82762, 
           26.91539}, {-77.58307, 26.9213599}, {-77.0216779, 
           26.5560462}, {-77.21159000000002, 25.8449255}, {-77.4060001, 
           26.0050356}, {-77.2003, 26.1549354}, {-77.17957, 
           26.5168899}}, {{-76.13097, 25.09975}, {-76.14543, 
           24.61439}, {-76.346247, 24.8300202}, {-76.1591799, 
           24.8361299}, {-76.15198, 25.1241601}, {-76.32286, 
           25.2560301}, {-76.35954, 25.3218301}, {-76.50542, 
           25.3514201}, {-76.60882, 25.4401301}, {-76.79304, 
           25.40365}, {-76.73860010000001, 25.55791}, {-76.3680601, 
           25.3498}, {-76.1331401, 25.1510701}, {-76.13097, 
           25.09975}}, {{-71.9890066, 21.9623035}, {-71.95294020000001, 
           21.956377200000002`}, {-71.9197689, 21.9466615}, {-71.9111601, 
           21.9416359}, {-71.9141024, 21.8766131}, {-71.8605611, 
           21.8364216}, {-71.8983464, 21.7977014}, {-71.9778326, 
           21.8830245}, {-71.9466321, 21.916706}, {-71.9448547, 
           21.9456807}, {-71.989922, 21.8882994}, {-72.04240160000002, 
           21.9087853}, {-72.0374364, 21.9529029}, {-71.9890066, 
           21.9623035}}, {{-64.7848075, 18.353549}, {-64.7463443, 
           18.3558811}, {-64.7420287, 18.3725191}, {-64.6909754, 
           18.361368}, {-64.6606741, 18.3402037}, {-64.6920756, 
           18.3391274}, {-64.6909801, 18.3562674}, {-64.7159666, 
           18.3455901}, {-64.6972706, 18.321841}, {-64.7029287, 
           18.2982041}, {-64.7472659, 18.3244622}, {-64.7911678, 
           18.3143767}, {-64.7989299, 18.3368069}, {-64.7848075, 
           18.353549}}, {{14.316144, 36.026414}, {14.2792286, 36.0158239}, {
           14.2715286, 36.0204097}, {14.2620261, 36.0114347}, {14.2188135, 
           36.0208153}, {14.2169495, 36.0305187}, {14.1863288, 36.0359634}, {
           14.1935521, 36.0461518}, {14.18404, 36.0720126}, {14.2519979, 
           36.0799065}, {14.2818158, 36.0616754}, {14.3112184, 36.0585651}, {
           14.3357894, 36.0353851}, {14.316144, 36.026414}}, {{25.8775019, 
           35.1590032}, {26.1595915, 35.1979062}, {26.2341267, 35.2790728}, {
           26.2867736, 35.2848612}, {26.2821582, 35.310402}, {26.3139773, 
           35.3150196}, {26.1366875, 34.9998942}, {25.4461247, 34.96051235}, {
           24.7555619, 34.9211305}, {24.7214371, 35.0927002}, {24.15602715, 
           35.16189525}, {23.5906172, 35.2310903}, {23.514671, 35.306066}, {
           23.7374864, 35.6956949}, {24.2760551, 35.3572996}, {25.0767785, 
           35.2581514}, {25.8775019, 35.1590032}}, {{69.3388742, -49.03141}, {
           69.2776897, -49.0715676}, {69.3464385, -49.08189300000001}, {
           69.20017970000002, -49.106851000000006`}, {
           69.1931664, -48.9910928}, {69.350897, -48.8834442}, {
           69.3760663, -48.9220782}, {69.3230495, -48.9405405}, {
           69.2990253, -48.9626401}, {69.3718109, -48.9340137}, {
           69.4043364, -48.9285353}, {69.4151278, -48.9407512}, {
           69.3140023, -49.0132777}, {69.3388742, -49.03141}}, {{114.2417991, 
           22.21804}, {114.2236454, 22.2466328}, {114.2139797, 22.1940286}, {
           114.1875033, 22.2448866}, {114.1710981, 22.229976}, {114.1705554, 
           22.2483713}, {114.1361196, 22.248879900000002`}, {114.1173741, 
           22.279747000000004`}, {114.20319320000002`, 22.295107100000003`}, {
           114.2345956, 22.2844453}, {114.2574241, 22.2617089}, {114.2468579, 
           22.2451626}, {114.2610358, 22.207434}, {114.2417991, 22.21804}}, {{
           134.3436436, 7.1692259000000105`}, {134.3588179, 
           7.17951629999999}, {134.3494585, 7.15713659999999}, {134.3703616, 
           7.15951899999999}, {134.3717321, 7.164079}, {134.3678947, 
           7.169827200000001}, {134.3690514, 7.173695699999991}, {134.370956, 
           7.16656789999999}, {134.3778284, 7.16371389999999}, {134.3775439, 
           7.1922682999999905`}, {134.3849762, 7.135563799999981}, {
           134.3723207, 7.149574000000011}, {134.346897, 7.14324529999999}, {
           134.3436436, 7.1692259000000105`}}, {{-64.8767648, 
           32.2786089}, {-64.8748055, 32.2930588}, {-64.8815144, 
           32.3047729}, {-64.8722367, 32.3037565}, {-64.8698229, 
           32.308512500000006`}, {-64.865076, 32.3103552}, {-64.8656018, 
           32.3037827}, {-64.8587548, 32.304845}, {-64.8610398, 
           32.2999465}, {-64.8569306, 32.2971896}, {-64.8680266, 
           32.2934644}, {-64.8691144, 32.2810663}, {-64.8767648, 
           32.2786089}}, {{-56.1711483, 46.7796664}, {-56.17709880000001, 
           46.775132}, {-56.1618724, 46.7813449}, {-56.1507973, 
           46.7647133}, {-56.1877143, 46.7561212}, {-56.19535890000001, 
           46.7669255}, {-56.2227684, 46.7506872}, {-56.2279067, 
           46.7622647}, {-56.2420054, 46.7655703}, {-56.1943766, 
           46.809563}, {-56.1655623, 
           46.81586540000001}, {-56.154055400000004`, 
           46.7972556}, {-56.1711483, 46.7796664}}, {{
           3.40219378560183, -54.3974651013475}, {3.4115753, -54.398327}, {
           3.43161739999999, -54.41688200000001}, {
           3.42476370000001, -54.4368176}, {3.41282149999999, -54.4444873}, {
           3.3624565, -54.4444269}, {3.3297453, -54.4506461}, {
           3.31115699999999, -54.4429776}, {
           3.29869549999999, -54.42521990000001}, {
           3.29713790000001, -54.4171841}, {3.30544549999999, -54.3992943}, {
           3.37331749999999, -54.3912245}, {
           3.40219378560183, -54.3974651013475}}, {{6.46805910000001, 
           0.18637050000000102`}, {6.46676650000001, 0.263390999999983}, {
           6.54159029999999, 0.357433599999993}, {6.62678960000001, 
           0.410784800000004}, {6.71930369999999, 0.381207399999982}, {
           6.7606077, 0.295512599999983}, {6.745498, 0.23211080000000398`}, {
           6.65234089999999, 0.108712000000002}, {6.56847680000001, 
           0.0839276000000011}, {6.5574968, 0.0355079999999836}, {
           6.51156850000001, 0.023611899999983}, {6.51630159999999, 
           0.100595100000003}, {6.46805910000001, 0.18637050000000102`}}, {{
           40.0232333, 15.727859900000002`}, {39.9233426, 
           15.725085499999999`}, {40.0453948, 15.8224307}, {
           40.022043700000005`, 15.8619578}, {39.9821201, 15.8620132}, {
           39.9550583, 15.880425600000002`}, {39.9534959, 15.8877752}, {
           40.09469, 15.8362367}, {40.1673753, 15.6311758}, {40.3142364, 
           15.6911393}, {40.4248968, 15.5629379}, {39.9832843, 
           15.605928200000001`}, {40.0232333, 
           15.727859900000002`}}, CompressedData["
1:eJxTTMoPSmViYGAQB2IQXZwx8W1Na/iBJIEIyy1MQQ4z8oSaDzSEH+idDmQw
BDnwMGm3iy0PPxDTf+irBpDfONW5O+ds+AGddrGb5/4HOmw5UbZv/rrwAy7d
Oc9/cwY5vFIz5FhzJvzANw2gDrkgB/nW14E7XoUfWHHM27zTOMhhsgRLGN9b
qHk5QQ5q9/KVMvaHH0i5/nh1V1mQw47Ft98dnBh+IFueNelNQ5CDd6b7bumU
8APF6WoSft1A8xMP6y3VDT+w5Nc5/VdtQQ6dUfaL9L6HHbjWW+7e1hTkoBG8
W3THgbADHIoK8Up1QQ7HgdY6doUdsAQ5tDLIwTRulyfPlrAD1SLr3B8mBDks
KbDlun437MCeEqDLPIIcgL4/tZA9/MC/KxUv1fSDHDjlzgh/NQ0/YF/TFsto
EOTAuPN6jAfQPQ3KUy7eBvJ/BD9eOntS+IGDpxa6bjMMcgDyjijEAN0LClfZ
IAf08AUAcYyqxQ==
           "], {{-72.15175440000002, 21.827636}, {-72.1290102, 
           21.8107114}, {-72.1806865, 21.7570435}, {-72.2530964, 
           21.7670293}, {-72.2838618, 21.7392471}, {-72.321532, 
           21.7865046}, {-72.313731, 21.7583672}, {-72.3502509, 
           21.7480108}, {-72.3564758, 21.756694700000004`}, {-72.333, 
           21.86525}, {-72.2381164, 21.7863786}, {-72.15175440000002, 
           21.827636}}, {{-61.8538133, 17.7190171}, {-61.8437406, 
           17.7291471}, {-61.8208341, 17.7019735}, {-61.7931468, 
           17.7000566}, {-61.745214, 17.6461609}, {-61.7321565, 
           17.5439872}, {-61.7661413, 17.5442306}, {-61.822270100000004`, 
           17.5920869}, {-61.8604414, 17.5828453}, {-61.8537795, 
           17.651464900000004`}, {-61.886722999999996`, 
           17.6968465}, {-61.8538133, 
           17.7190171}}, {{-37.9840512, -54.06217}, {-38.0183478, \
-54.0128516}, {-37.4046948, -53.9857813}, {-36.6416348, -54.1210888}, \
{-36.6983216, -54.3011071}, {-36.2468965, -54.2884267}, {-35.7925834, \
-54.76663560000001}, {-36.1159426, -54.8847229}, {-36.4897927, -54.5079644}, \
{-37.4177193, -54.2726661}, {-37.2445099, -54.1465961}, {-37.9840512, \
-54.06217}}, {{-6.61414470000001, 62.3471567}, {-6.5817262, 
           62.3568491}, {-6.52973389999999, 62.285626400000005`}, {-6.4259535,
            62.2547642}, {-6.4718318, 62.2293456}, {-6.5376498, 
           62.25362129999999}, {-6.4424265, 62.1835829}, {-6.572061900000011, 
           62.2241621}, {-6.5488446, 62.167803}, {-6.6194565, 
           62.2171346}, {-6.5803102, 62.254744699999996`}, {-6.61414470000001,
            62.3471567}}, {{43.2371052, -11.7211474}, {
           43.2665193, -11.6732049}, {43.277781, -11.3987323}, {
           43.3936007, -11.3746537}, {43.416563000000004`, -11.4358915}, {
           43.3961286, -11.6493692}, {43.5176721, -11.8919783}, {
           43.4982572, -11.9233541}, {43.4573162, -11.9382377}, {
           43.384785, -11.8628497}, {43.2882247, -11.8467709}, {
           43.2371052, -11.7211474}}, {{43.8699412, -12.3890838}, {
           43.8646896, -12.3911233}, {43.8249031, -12.3779409}, {
           43.8157201, -12.3798341}, {43.7835327, -12.3685425}, {
           43.7780715, -12.3810558}, {43.7492362, -12.3596954}, {
           43.6578349, -12.3592485}, {43.6262945, -12.2624791}, {
           43.7339688, -12.2714766}, {43.8591149, -12.3467786}, {
           43.8699412, -12.3890838}}, {{50.412017, 26.1905985}, {50.4243647, 
           26.1200331}, {50.384421, 26.1238379}, {50.3779921, 26.1537082}, {
           50.3971457, 26.1708946}, {50.3727867, 26.181408}, {50.3956222, 
           26.1719153}, {50.4054927, 26.1732344}, {50.3726843, 26.18632}, {
           50.4054176, 26.174361}, {50.3972336, 26.1961098}, {50.412017, 
           26.1905985}}, {{96.8605294, -12.1927953}, {
           96.8631591, -12.2010185}, {96.8445532, -12.206749}, {
           96.8197124, -12.1828764}, {96.8199319, -12.1347244}, {
           96.8331309, -12.1661571}, {96.8319192, -12.1737832}, {
           96.825987, -12.1598687}, {96.8208556, -12.1805723}, {
           96.8296732, -12.1783361}, {96.84669020000001, -12.2052504}, {
           96.8605294, -12.1927953}}, {{96.9295023, -12.1793047}, {
           96.9222669, -12.196722}, {96.9167392, -12.2018833}, {
           96.8942465, -12.2089772}, {96.8849396, -12.2012824}, {
           96.8873256, -12.195536}, {96.89537, -12.2070445}, {
           96.9042233, -12.196941700000002`}, {96.9198401, -12.1970295}, {
           96.9274163, -12.1799296}, {96.91854590000001, -12.1595975}, {
           96.9295023, -12.1793047}}, CompressedData["
1:eJxTTMoPSmViYGCQAmIQPSOls7jyR5TDbUaj80t3SxxI0N70/I9QtIPKT7aC
I38kD2h+uhXdoBvtkPvhtsBjW+kDjTq/fqamRDt0PNO3E+uQPnAzTXKG9+xo
hyV3mrM9L0kf2HSa8cyxXdEO/B/5o6vmSB5IaZh/5ta7aIcLy72WvqyUOiBq
anv2nVKMw4S41vcR4dIHeNY8/qFoFeOgFJKqubhZ7sDOaI8y6ewYh+nb905m
vSZ3II177WeROTEO3NJi/9I15A8wLl3oprgsxuG955de5wbFA+dvTbmSnxHj
8Hvy48MKZooH5gl0JO3TinHguHfp59/XCgdy3Ko/8LyNdhDROKR/e6HCAeua
vLro9dEOckUbU3eEKxzg3JTIs6ow2kFrz4LZU3kVDtx4HjLrh3G0Qw6PwuKn
bfIHlsl6aLh/i3JoWfCPb8EnuQOip7pF/+2NcvjzY69v/TLZA81l55m2tkY5
FAfW9sRFyRz4pCT8Ids3yuH1SpvTtnzSB5aWXTDjyIhyiDjQa1niLnkg4lRv
7ZKmKIdj1+4tX9UgfqBievePPqB5ATkd1hpyEgfQ4wMAyD/HoA==
           "], {{114.1227501, 22.2281136}, {114.1369556, 22.2187511}, {
           114.1270172, 22.2094666}, {114.130039, 22.2020286}, {114.1603781, 
           22.2086581}, {114.1398112, 22.1978588}, {114.1494733, 
           22.1813511}, {114.11401470000001`, 22.1833105}, {114.1212136, 
           22.2143617}, {114.1024238, 22.2187385}, {114.1178954, 
           22.241190200000002`}, {114.1227501, 22.2281136}}, {{127.7243861, 
           0.335125999999994}, {127.39911920000002`, 1.19606139999999}, {
           127.67706009999999`, 1.709085899999995}, {127.95500100000001`, 
           2.2221104}, {127.8044675, 1.5484018999999918`}, {127.653934, 
           0.8746933999999831}, {128.20618805, 1.1348350499999864`}, {
           128.7584421, 1.39497669999999}, {128.1986509, 0.789661399999989}, {
           128.6805787, 0.549085900000005}, {128.9033093, 0.20756379999999}, {
           128.0798861, 0.47688860000000594`}, {127.8633288, 
           0.296768399999992}, {128.15868995, -0.3083730000000105}, {
           128.4540511, -0.913514400000013}, {
           128.0892186, -0.2891942000000095}, {127.7243861, 
           0.33512599999999404`}}, {{133.8904993, 34.3516902}, {134.589093, 
           34.23909}, {134.75009400000002`, 33.834653}, {134.176643, 
           33.243025}, {133.5527, 33.540781}, {133.006267, 32.721304}, {
           132.472768, 32.906859}, {132.4234895, 33.4644296}, {132.013086, 
           33.343456}, {132.4524505, 33.73123250000001}, {132.891815, 
           34.119009}, {133.51214800000002`, 33.969751}, {133.8904993, 
           34.3516902}}, {{-172.50482410000004`, -13.4725667}, {-172.353323, \
-13.4388056}, {-172.30566710000002`, -13.4601857}, {-172.1740517, \
-13.6676055}, {-172.2260061, -13.8019229}, {-172.3088181, -13.7547727}, \
{-172.5443001, -13.7972274}, {-172.8040668, -13.515888}, {-172.7573491, \
-13.4899001}, {-172.63737440000003`, -13.5190165}, {-172.50482410000004`, \
-13.4725667}}, {{-133.6412861, 56.2612387}, {-133.1744877, 
           56.3284806}, {-132.4984995, 55.8148538}, {-132.14316910000002`, 
           55.4571369}, {-132.5563447, 55.6249162}, {-132.7419378, 
           55.361296}, {-131.9985297, 55.2672153}, {-132.0162108, 
           54.6901564}, {-132.6268553, 54.987809049999996`}, {-133.2374998, 
           55.2854617}, {-132.93262230000002`, 55.6236404}, {-133.6412861, 
           56.2612387}}, CompressedData["
1:eJwBAQL+/SFib1JlAgAAAB8AAAACAAAA3wkHjD8AXsAwJw3a0JFSQDbaYJeX
yF3A2qqSNsOQUkCLqrqi75BdwIMuGJO1j1JA4XoUrkdZXcAtsp3vp45SQGt1
TPBgLF3A0tuyVsd+UkD1b4Qyev9cwHYFyL3mblJAf2q8dJPSXMAcL90kBl9S
QDjzqzlAEF3AF4IclLBRUkDye5v+7E1dwBPVWwNbRFJArQSLw5mLXcAPKJty
BTdSQGWNeohGyV3AC3va4a8pUkBGyIorOOxdwN4JrNKMHVJAJgObzikPXsCy
mH3DaRFSQI109RmGIV7APPceLjniUUCGiikQ9VFewCd6YbOk2FFAfaBdBmSC
XsAR/aM4EM9RQHa2kfzSsl7A/H/mvXvFUUCgRQCBOOZewB68G7Cw01FAytRu
BZ4ZX8BA+FCi5eFRQPRj3YkDTV/AYjSGlBrwUUAe80sOaYBfwIRwu4ZP/lFA
DvQs5O1PX8BMkaAcKSRSQP30DbpyH1/AFbKFsgJKUkDt9e6P9+5ewN3Sakjc
b1JAHrBhPDkQX8BE2saf6IJSQFBq1Oh6MV/ArOEi9/SVUkDSI3gJb/RewGC8
UfEglVJAVt0bKmO3XsAUl4DrTJRSQNmWv0pXel7AyHGv5XiTUkBdUGNrSz1e
wHxM3t+kklJA3wkHjD8AXsAwJw3a0JFSQJ55764=
           "], {{-62.5866353, 17.2062693}, {-62.5561225, 
           17.1944953}, {-62.5455654, 17.1807032}, {-62.539668799999994`, 
           17.1436352}, {-62.55426, 17.1067813}, {-62.6022909, 
           17.0944184}, {-62.6253237, 17.1087264}, {-62.63353320000001, 
           17.1329071}, {-62.6289155, 17.1660983}, {-62.61192110000001, 
           17.2031947}, {-62.5866353, 17.2062693}}, {{-54.2918, 
           70.3192601}, {-53.71392505, 70.2400001}, {-53.1360501, 
           70.1607401}, {-52.493365049999994`, 69.90117004999999}, {-51.85068,
            69.6416}, {-52.703355, 69.43624495}, {-53.55603000000001, 
           69.2308899}, {-54.27722, 69.4153299}, {-53.3746301, 
           69.44371}, {-53.31937, 69.5857499}, {-54.13895, 
           69.63677}, {-54.95853, 69.6877901}, {-54.35209, 
           69.66921}, {-54.9236799, 69.82571}, {-54.2918, 
           70.3192601}}, {{-24.6259875, 73.4276806}, {-23.9220696, 
           73.33317170000001}, {-23.2181517, 73.2386628}, {-23.5951162, 
           73.2220228}, {-24.2408136, 73.2972183}, {-24.4535139, 
           73.2928242}, {-24.903625, 73.3248893}, {-25.231914, 
           73.3278203}, {-24.444847166666666`, 
           73.2717209}, {-23.657780333333335`, 73.2156215}, {-22.8707135, 
           73.1595221}, {-23.828339433333333`, 
           73.1723878}, {-24.785965366666666`, 73.1852535}, {-25.7435913, 
           73.1981192}, {-25.2691163, 73.4079205}, {-24.6259875, 
           73.4276806}}, {{-2.36923689999999, 49.4236926}, {-2.3787118, 
           49.4318371}, {-2.36944910000001, 
           49.43485580000001}, {-2.36768640000001, 
           49.4491411}, {-2.34261190000001, 49.4327096}, {-2.3468341, 
           49.423571900000006`}, {-2.359954, 49.4238447}, {-2.3689926, 
           49.4103829}, {-2.37842599999999, 49.4083079}, {-2.382869, 
           49.4142278}, {-2.36923689999999, 49.4236926}}, {{9.58028450000001, 
           40.9548406}, {9.82885199999999, 40.5285342}, {9.698024549999996, 
           39.8377804}, {9.5671971, 39.1470266}, {9.0597383, 39.223479}, {
           8.63994720000001, 38.8649256}, {8.36812089999999, 39.2137154}, {
           8.57072259999999, 39.8639623}, {8.373638049999995, 40.40058885}, {
           8.1765535, 40.9372154}, {8.56437570000001, 40.83244040000001}, {
           9.22534710000001, 41.2590755}, {9.58028450000001, 40.9548406}}, {{
           11.8087607, 54.7939704}, {11.8339888, 54.6515564}, {11.5093011, 
           54.593839700000004`}, {11.0072341, 54.7618768}, {10.9627802, 
           54.8043966}, {10.9565074, 54.8151512}, {10.9547227, 54.8291007}, {
           11.1394204, 54.8282258}, {11.018575, 54.895685}, {11.2003361, 
           54.9605073}, {11.8087607, 54.7939704}}, {{17.0705339, 
           57.1729856}, {16.9084546, 57.0412114}, {16.8696382, 56.8462162}, {
           16.48071, 56.2391}, {16.3898713, 56.1995861}, {16.3946784, 
           56.6039356}, {16.7212556, 56.8840964}, {16.9593202, 57.2913468}, {
           17.0216866, 57.3449808}, {17.0889074, 57.368654500000005`}, {
           17.0705339, 57.1729856}}, CompressedData["
1:eJxTTMoPSmViYGCQAGIQHRCUwOjT4e6wqWOPwxKuEIf9O0KW6sa4O9yU6al9
JxTicF3p250pp9wd1E8HVb+VDXF43zNd5I+Fh0NppWTlG40QB5+n3bck77k7
LPN6PrdAPcRhhW3DAvNmd4dr0lsPfVENcVARLK2ylHF38H1eqZYlE+Kwu7zy
vuwJNweWYHErB8UQh6B7tS5MJW4OO/dt8RVTC3FIa90SIfPQzeHg16KXK7VD
HKp1XueY+bk7nNQxbLU1DHHov6zYGLDb3eFi8nuFi2YhDufurb+sw+rhkHDZ
6s13gxAH3le2apz+Hg7vndq2ywH1T5tU3Z0928OhytAqcJdRiIOi9c4PZ597
OLAovHsVahXicFlzkeVRG08HScevC2WB5rVJdDftmejpoJv0J+Ip0D5L9pLT
m595Ojg1Mwus1Q1x4Hpscy0719NBNfCrz2qge+/sY32o/MXDgUP+eedK+RCH
tbPOvb5d5eHw5s2NY8slQhzqy6Z/m8zo4XB+1ynmZYIhDujhDQBavqVs
           "], {{103.7689521, 1.2082032}, {103.7817516, 1.20484579999998}, {
           103.7806895, 1.19982579999999}, {103.7733187, 1.19137329999999}, {
           103.7684693, 1.18904569999999}, {103.7750461, 1.196876}, {
           103.7661519, 1.2024002}, {103.7641456, 1.19143769999998}, {
           103.7601008, 1.19537429999999}, {103.7586846, 1.2177819}, {
           103.7689521, 1.2082032}}, {{167.2617502, -20.9138746}, {
           167.4596488, -21.0557387}, {167.3879312, -21.1829408}, {
           167.0955065, -21.0423492}, {167.01, -20.918889}, {
           167.1196881, -20.910268200000004`}, {167.1799191, -20.8126187}, {
           167.0397662, -20.7320922}, {167.1927595, -20.6786039}, {
           167.299167, -20.7275}, {167.2617502, -20.9138746}}, {{-111.8410534,
            78.5605864}, {-111.12275555, 78.6641138}, {-110.4044577, 
           78.7676412}, {-109.80837059999999`, 78.6240162}, {-109.2122835, 
           78.4803912}, {-109.7787967, 78.3787277}, {-110.3453099, 
           78.27706420000001}, {-111.144419, 78.3934671}, {-111.4475015, 
           78.2707668}, {-112.1599865, 78.3745814}, {-113.1487311, 
           78.2702391}, {-113.3280085, 78.3445383}, {-112.58453095, 
           78.45256235000001}, {-111.8410534, 
           78.5605864}}, {{-81.33787760000001, 19.2977734}, {-81.2606601, 
           19.3227076}, {-81.2712709, 19.373036}, {-81.0855477, 
           19.3409934}, {-81.1139761, 19.294254100000003`}, {-81.3806506, 
           19.2651751}, {-81.4148943, 19.3855477}, {-81.3650993, 
           19.3870923}, {-81.3675365, 19.3146327}, {-81.33787760000001, 
           19.2977734}}, {{-77.7885899, 23.9902701}, {-77.6932899, 
           24.033730000000002`}, {-77.5927701, 
           24.206960100000003`}, {-77.5238401, 23.99589}, {-77.7135001, 
           23.93374}, {-77.5916601, 23.95668}, {-77.60217, 
           23.89451}, {-77.6664701, 23.8510901}, {-77.6938599, 
           23.85049}, {-77.7885899, 23.9902701}}, {{-64.652556, 
           18.3916256}, {-64.717452, 18.3890026}, {-64.677703, 
           18.4015292}, {-64.6438741, 18.4539102}, {-64.5581768, 
           18.457662800000005`}, {-64.5531413, 18.4418415}, {-64.5778354, 
           18.4138456}, {-64.6157072, 18.4280133}, {-64.615313, 
           18.4071621}, {-64.652556, 18.3916256}}, {{-64.4261199, 
           18.4581922}, {-64.4232607, 18.4318507}, {-64.4456429, 
           18.4260101}, {-64.4438292, 18.4584504}, {-64.4139316, 
           18.4696625}, {-64.4158967, 18.5040404}, {-64.3825645, 
           18.4887238}, {-64.3563193, 18.5020514}, {-64.3199598, 
           18.5035751}, {-64.4261199, 
           18.4581922}}, {{-60.91010990000001, -51.93925}, {-61.0007801, \
-51.98913}, {-61.1658099, -51.83088010000001}, {-60.93963, -51.8017601}, \
{-60.93986009999999, -51.8194499}, {-61.03308, -51.85808}, {-61.0511601, \
-51.88978000000001}, {-60.90157, -51.8556701}, {-60.86498, -51.76301}, \
{-60.91010990000001, -51.93925}}, {{-16.5078130804854, 
           16.093782133093}, {-16.5078096, 16.0937702}, {-16.5051457, 
           16.0404976}, {-16.5116323, 15.9651481}, {-16.5095292, 
           16.0930132}, {-16.5095292017767, 16.0930133228534}, {-16.50954, 
           16.09376}, {-16.5006549619873, 16.1279808672521}, {-16.5078131, 
           16.0937822}, {-16.5078130804854, 16.093782133093}}, {{
           7.402103400000011, 1.54686869999998}, {7.341400300000011, 
           1.5528781}, {7.3282987, 1.6032555}, {7.36389699999999, 
           1.6050888}, {7.37126139999999, 1.6829326}, {7.4409223, 
           1.6920112000000103`}, {7.4615588000000095`, 1.66934539999999}, {
           7.42075230000001, 1.64216359999999}, {7.4618489, 
           1.62501219999999}, {7.402103400000011, 1.54686869999998}}, {{
           8.71304300000001, 3.7879592}, {8.8982718, 3.76516199999999}, {
           8.9381187, 3.6670043999999904`}, {8.67744149999999, 
           3.20870679999998}, {8.45378760000001, 3.26930759999999}, {
           8.41476340000001, 3.36088949999999}, {8.4588093, 
           3.46557319999999}, {8.57385669999999, 3.4684631}, {
           8.60882030000001, 3.6661147999999897`}, {8.71304300000001, 
           3.7879592}}, {{19.3774310783823, 41.8479503141651}, {19.3762204, 
           41.8472558}, {19.3760333875321, 41.8473549889382}, {19.3760213, 
           41.8473614}, {19.3766879, 41.8479126}, {19.3768197155294, 
           41.8478823036911}, {19.3768615, 41.8478727}, {19.3773476, 
           41.8479268}, {19.3773973049882, 41.8479404780345}, {
           19.3774310783823, 41.8479503141651}}, {{21.0434748, 78.1498239}, {
           21.93594685, 78.20357125000001}, {22.8284189, 78.2573186}, {
           23.58101605, 78.0854033}, {24.3336132, 77.913488}, {
           23.495652749999998`, 77.57743545}, {22.6576923, 77.2413829}, {
           22.6557857, 77.5249017}, {23.0380935, 77.5701251}, {
           22.305249066666665`, 77.53025703333333}, {21.572404633333335`, 
           77.49038896666667}, {20.8395602, 77.4505209}, {21.5453511, 
           77.917794}, {20.7864075, 78.0837859}, {21.0434748, 78.1498239}}, {{
           45.2542458117712, -12.7832717079057}, {
           45.2641672857449, -12.7825124118702}, {45.2672895, -12.7890219}, {
           45.2741023, -12.7764644}, {45.2643747035293, -12.7822494945112}, {
           45.2860317, -12.7595079}, {45.2999902718267, -12.7844645342765}, {
           45.2851585, -12.803253400000001`}, {45.2876787, -12.8171834}, {
           45.2542458117712, -12.7832717079057}}, {{50.62997270000001, 
           26.1331389}, {50.6383841, 26.1088925}, {50.5977207, 26.1698112}, {
           50.6114869, 26.1866809}, {50.6320456, 26.1775443}, {50.6282561, 
           26.1448027}, {50.6620734, 26.161530800000005`}, {50.6508199, 
           26.1549811}, {50.6716435, 26.1573225}, {50.62997270000001, 
           26.1331389}}, {{50.7874606, 25.6775863}, {50.758087, 25.6668605}, {
           50.7763151, 25.6383225}, {50.7548449, 25.5857859}, {50.776026, 
           25.5738191}, {50.7770052, 25.5718102}, {50.7404204, 
           25.590367300000004`}, {50.739158, 25.6915128}, {50.8004315, 
           25.7335811}, {50.7874606, 25.6775863}}, {{117.67412449999999`, 
           8.66974109999999}, {117.17460030000001`, 8.3391973}, {
           117.86837809999999`, 9.054016633333333}, {118.56215590000001`, 
           9.768835966666668}, {119.2559337, 10.4836553}, {
           119.22075509999999`, 10.9543237}, {119.4615372, 10.723567}, {
           119.50064070000002`, 11.4188042}, {119.7167419, 10.5072165}, {
           119.23425525000002`, 10.2177992}, {118.7517686, 9.9283819}, {
           118.49025880000002`, 9.294974299999991}, {118.08219165000001`, 
           8.98235769999999}, {117.67412449999999`, 8.66974109999999}}, {{
           118.63157489999999`, -8.81669760000002}, {
           118.39036360000001`, -8.60686620000002}, {
           117.90065179999998`, -8.828053100000005}, {
           117.41094, -9.04923999999999}, {
           116.71534809999999`, -8.97114570000001}, {
           117.12312539999999`, -8.370435000000022}, {
           117.69626650000002`, -8.51429840000001}, {
           118.26940760000001`, -8.6581618}, {
           117.92380810000002`, -8.0800228}, {
           118.46397910000002`, -8.196779450000001}, {
           119.0041501, -8.3135361}, {
           119.17170709999999`, -8.724502800000021}, {
           118.63157489999999`, -8.81669760000002}}, {{
           145.9131436, -41.060957}, {146.51749785, -41.25229720000001}, {
           147.12185210000004`, -41.4436374}, {146.7865941, -41.054138}, {
           147.56802635, -41.0235166}, {148.3494586, -40.9928952}, {
           148.34779715, -41.608408999999995`}, {148.3461357, -42.2239228}, {
           147.67398815, -42.62059985}, {147.0018406, -43.0172769}, {
           146.8709945, -43.63861850000001}, {146.1829132, -43.3149712}, {
           145.4948319, -42.9913239}, {145.20035076666667`, -42.306844}, {
           144.90586963333334`, -41.6223641}, {144.6113885, -40.9378842}, {
           145.26226605, -40.9994206}, {145.9131436, -41.060957}}, {{
           167.1376253, -15.5621212}, {166.7740018, -15.6502895}, {
           166.5421852, -14.8473376}, {166.6147037, -14.643986200000002`}, {
           166.8325863, -15.162519499999998`}, {166.9516331, -15.1607478}, {
           166.9833926, -14.9539241}, {167.0897964, -14.945249}, {
           167.2598934, -15.509348100000002`}, {167.1376253, -15.5621212}}, {{
           178.145084, -19.0491834}, {178.31366940000004`, -18.9325675}, {
           178.4486348, -18.9557687}, {178.4858344, -19.0000227}, {
           178.3195304, -19.0581956}, {178.2632568, -18.9942085}, {
           178.156376, -19.0610931}, {178.157186, -19.1580473}, {
           177.9519304, -19.1347681}, {
           178.145084, -19.0491834}}, {{-78.5886685, 
           26.580369800000003`}, {-78.4961519, 
           26.732998}, {-78.30470700000001, 26.6654556}, {-78.0438726, 
           26.6805775}, {-78.0530329, 26.7249929}, {-77.9176, 
           26.7779201}, {-77.8984001, 26.74965}, {-77.9713599, 
           26.6528799}, {-78.5886685, 
           26.580369800000003`}}, {{-74.4280169, -49.4106647}, {-74.4062855, \
-49.902024600000004`}, {-74.79789, -50.0558501}, {-74.5827801, -49.30727}, \
{-75.0597921, -49.90516}, {-75.457, -49.2757508}, {-74.8568599, -49.3720199}, \
{-74.68282, -48.652790100000004`}, {-74.4280169, -49.4106647}}, {{-64.8463852,
            32.3125302}, {-64.8496588, 32.3127528}, {-64.831912, 
           32.3299951}, {-64.8302912, 32.327709}, {-64.8335299, 
           32.3224784}, {-64.8326597, 32.3266731}, {-64.8416531, 
           32.3204411}, {-64.8420109, 32.312533}, {-64.8463852, 
           32.3125302}}, {{-64.684044, 32.3778467}, {-64.6922517, 
           32.3780374}, {-64.6958388, 32.3749705}, {-64.6887851, 
           32.3718843}, {-64.7162334, 32.36196}, {-64.6750756, 
           32.3909596}, {-64.6626581, 32.3791334}, {-64.6744769, 
           32.3818454}, {-64.684044, 32.3778467}}, {{-63.109603, 
           46.25}, {-63.6538628, 46.2200155}, {-64.4099879, 
           46.7067018}, {-63.996564500000005`, 47.0589262}, {-64.1517042, 
           46.6925723}, {-63.9254051, 46.4554217}, {-62.948087750000006`, 
           46.4543099}, {-61.97077039999999, 
           46.4531981}, {-62.529176500000005`, 45.9711792}, {-63.109603, 
           46.25}}, {{-62.9052938, 17.9605724}, {-62.89585240000001, 
           17.9574697}, {-62.89602409999999, 
           17.9566532}, {-62.901345600000006`, 17.9548569}, {-62.9037488, 
           17.9512643}, {-62.9034055, 17.9571431}, {-62.911301900000005`, 
           17.9568165}, {-62.9099286, 17.9600825}, {-62.9052938, 
           17.9605724}}, {{-61.4388293, 12.455279}, {-61.4997036, 
           12.4357867}, {-61.4829205, 12.4590589}, {-61.49792370000001, 
           12.4673894}, {-61.49793, 12.4777201}, {-61.4598321, 
           12.4819797}, {-61.4379195, 12.5299687}, {-61.41988649999999, 
           12.500708800000002`}, {-61.4388293, 
           12.455279}}, {{-61.0986417700266, 
           16.2937779256829}, {-61.08953644630681, 
           16.3121770734165}, {-61.00447057030859, 
           16.3447524081161}, {-61.0067687303, 
           16.3412273564941}, {-61.00334174732261, 
           16.3399540535619}, {-61.0044804517768, 
           16.3382507576281}, {-61.000400932577, 
           16.3346358488071}, {-61.0013692266217, 
           16.3324824230762}, {-61.0986417700266, 
           16.2937779256829}}, {{-60.23472, -51.3146099}, {-60.32525, \
-51.2631399}, {-60.04409, -51.33713}, {-60.10800999999999, -51.4040899}, \
{-60.25663, -51.4135599}, {-60.31501, -51.3895399}, {-60.23375, -51.33766}, \
{-60.12692, -51.3868699}, {-60.23472, -51.3146099}}, {{-7.34437570000001, 
           62.1269225}, {-7.2447432, 62.1594162}, {-7.06015049999999, 
           62.0774507}, {-7.08475270000001, 62.0462205}, {-7.23488150000001, 
           62.0207628}, {-7.40687089999999, 62.0670024}, {-7.31168000000001, 
           62.07080990000001}, {-7.46527850000001, 
           62.134075200000005`}, {-7.34437570000001, 
           62.1269225}}, {{-6.86724700000001, 
           61.89740940000001}, {-6.63375840000001, 
           61.831086600000006`}, {-6.67497070000001, 
           61.8096567}, {-6.65979550000001, 
           61.76431109999999}, {-6.72072820000001, 
           61.771690500000005`}, {-6.7774918, 
           61.83119760000001}, {-6.87713200000001, 61.8192728}, {-6.9525232, 
           61.9123192}, {-6.86724700000001, 
           61.89740940000001}}, {{-6.00859999999999, 
           56.37446}, {-6.20349999999999, 56.3639}, {-5.99834899999999, 
           56.49086}, {-6.33406000000001, 56.53303}, {-6.32423, 
           56.60659}, {-5.64576309999999, 56.447713}, {-5.83282, 
           56.310942}, {-6.38882, 56.28931000000001}, {-6.00859999999999, 
           56.37446}}, {{-2.17790779999999, 49.7305357}, {-2.15907899999999, 
           49.7275291}, {-2.1922809, 49.7067334}, {-2.2339905, 
           49.7041645}, {-2.221231, 49.720431}, {-2.19455129999999, 
           49.7304167}, {-2.20284859999999, 49.723575}, {-2.18950670000001, 
           49.7213144}, {-2.17790779999999, 49.7305357}}, {{-1.33147999999999,
            59.9688539}, {-1.2671583, 
           60.237744299999996`}, {-1.70303030000001, 
           60.28850980000001}, {-1.26331199999999, 60.3511526}, {-1.6328888, 
           60.4833837}, {-1.3084252, 60.6395793}, {-1.38350960000001, 
           60.3974625}, {-1.04900149999999, 
           60.44000880000001}, {-1.33147999999999, 59.9688539}}, {{10.9036355,
            33.907181}, {10.8893825, 33.913492}, {10.9294601, 33.8983429}, {
           11.0135041, 33.8342219}, {11.056463600000003`, 33.8251799}, {
           11.0625618, 33.7884851}, {10.8867727, 33.6314494}, {10.7275067, 
           33.763634}, {10.9036355, 33.907181}}, {{14.668213700000003`, 
           45.1058852}, {14.6718953, 45.0779536}, {14.7380989, 45.067894}, {
           14.7438235, 45.0343341}, {14.8107318, 44.9911595}, {14.8202159, 
           44.9706845}, {14.430831, 45.0784049}, {14.5541409, 45.2456821}, {
           14.668213700000003`, 45.1058852}}, {{15.244164699999999`, 
           38.2193835}, {15.653238600000002`, 38.2674866}, {15.09026, 
           37.4997086}, {15.336725099999999`, 37.007628}, {
           15.079793900000002`, 36.6467869}, {14.194644166666667`, 
           37.0318776}, {13.309494433333334`, 37.4169683}, {12.4243447, 
           37.802059}, {12.7306481, 38.1893523}, {13.23743645, 38.0797642}, {
           13.7442248, 37.9701761}, {14.494194750000002`, 38.0947798}, {
           15.244164699999999`, 38.2193835}}, {{44.204849, -12.1688989}, {
           44.3752876, -12.183402400000002`}, {44.4193606, -12.1524517}, {
           44.4208641, -12.0921196}, {44.4748518, -12.0718665}, {
           44.5406407, -12.260647}, {44.5275352, -12.381221000000002`}, {
           44.3842278, -12.2533664}, {44.204849, -12.1688989}}, {{103.7398257,
            1.2334278999999901`}, {103.7573878, 1.2366868}, {
           103.76127348889601`, 1.23399505979559}, {103.7638073, 1.2406517}, {
           103.7790706, 1.2241368}, {103.7732518, 1.22488679999999}, {
           103.769519538818, 1.22712123725024}, {103.7602578, 
           1.22542949999999}, {103.7398257, 1.2334278999999901`}}, {{
           168.113056, -21.435556}, {168.1362245, -21.4484889}, {
           168.1154885, -21.6278967}, {167.9787995, -21.6603166}, {
           167.84527800000004`, -21.599167000000005`}, {
           167.80034420000004`, -21.3813246}, {167.9749055, -21.3477055}, {
           167.999671, -21.4578793}, {168.113056, -21.435556}}, {{-135.11942, 
           57.48993}, {-135.8338101, 57.7703771}, {-135.5479376, 
           57.4795732}, {-135.844598, 57.3901197}, {-136.4477133, 
           58.1202161}, {-135.70053185, 58.080419500000005`}, {-134.9533504, 
           58.0406229}, {-135.8920828, 57.9960344}, {-135.11942, 
           57.48993}}, CompressedData["
1:eJxTTMoPSmViYGAQAWIQffTfpupPCyIOzD+76vzVV4EHRGVPPrXviDggnHj4
svbHwAOnDzutzZwXcaDswRzBpaxBB6Iv73ksUhhxwOGdqfikf4EHXj8ykzrg
HHGA+885mfrvgQdqPm0IyBaLOHCVM0Mp50PgAZfM/A+trhEHzlr7XZzIEXRA
zZBjjYxAxIH125Lqb/IGHeD8uSB9863wAxMMy3UVhYMO3HvAPXmlVMSBcn85
sSzBoANbTpTtmx8VcSA2F+hS/qADnRsevpw6K+KAS3fO899A/fEzfER7bkUc
0FopfMGFJ+iAScN2hyapyAOCx3ft6OUKOsAFdEZFVOSB708SF14D2n/fv3d6
3qzIA/eYOLvk2YMOzNg9bQJ/TOSBvtJCaV6GoANB6gs6N8hGHrB7cXPNrx+B
B3gmr2wKvB9x4H2Uk90LYHighxcA476miQ==
           "], {{-61.3371889445669, 15.941922392729602`}, {-61.2761423124671, 
           16.0074130075731}, {-61.233066118299895`, 
           15.9854219677638}, {-61.1950015352713, 
           15.930277789791703`}, {-61.204253284382496`, 
           15.901173868025102`}, {-61.279557437682705`, 
           15.8664455924531}, {-61.32359887162269, 
           15.887342806303801`}, {-61.3371889445669, 
           15.941922392729602`}}, {{-60.75548, 11.2357701}, {-60.693177, 
           11.2890348}, {-60.51983109999999, 11.3371088}, {-60.5538898, 
           11.2436115}, {-60.738708800000005`, 11.1822178}, {-60.7845954, 
           11.1349143}, {-60.8448506, 11.1462492}, {-60.75548, 
           11.2357701}}, {{-16.176191, 11.027374}, {-16.245348, 
           11.096290000000002`}, {-16.121327, 11.142391}, {-16.118176, 
           11.205411}, {-16.057301, 11.189784000000001`}, {-16.066969, 
           11.08512}, {-16.147264, 11.101576}, {-16.176191, 
           11.027374}}, {{-6.5368469000000005`, 
           62.32105550000001}, {-6.5427432, 62.36165660000001}, {-6.594016, 
           62.3848833}, {-6.5256394, 62.38090789999999}, {-6.47213899999999, 
           62.30081390000001}, {-6.40506510000001, 
           62.3020338}, {-6.44742700000001, 
           62.2776722}, {-6.5368469000000005`, 62.32105550000001}}, {{
           18.9112048, 57.7137523}, {18.9178815, 57.403253600000006`}, {
           18.1272019, 56.9084454}, {18.3011022, 57.0951353}, {18.10971, 
           57.53831}, {18.7252283, 57.9288172}, {19.0875908, 57.8442118}, {
           18.9112048, 57.7137523}}, {{26.5237728, 39.0356425}, {26.1684092, 
           39.0054376}, {26.2535406, 39.2054618}, {26.0761231, 39.0861691}, {
           25.957994, 39.103377}, {25.831666, 39.188723}, {26.3414875, 
           39.390144}, {26.5237728, 39.0356425}}, {{49.2890301, 68.77668}, {
           48.3363601, 68.73797}, {48.23592, 69.0995899}, {49.1273463, 
           69.502044}, {50.085610100000004`, 69.27471}, {50.2480201, 
           69.1938}, {50.30855, 69.12874}, {49.798790049999994`, 68.95271}, {
           49.2890301, 68.77668}}, {{69.6093811, 22.7556024}, {69.06717875, 
           23.222746450000002`}, {68.5249764, 23.6898905}, {69.15508890000001,
            23.836892849999998`}, {69.7852014, 23.9838952}, {69.9224232, 
           23.5801647}, {70.2187291, 23.3976877}, {70.6260785, 23.956441}, {
           71.1445658, 23.5416002}, {70.37697345, 23.148601300000003`}, {
           69.6093811, 22.7556024}}, CompressedData["
1:eJxTTMoPSmViYGAQA2IQPW/On8Kw5REOQSosARs3BzuEGU6tS8qJcPilFTKp
YHuwA88x3e48wwiHJYZLrujvDnY4HHVsetW3cAcfiy9i7/cFO1S9j1vStjvc
4YudS+S6Q8EOX7wXpPhNCHdY5XyH6/zZYIe8FQ9VxFLDHeI9Sva8vxHs8IJF
+eldy3AHUV+ePIEnwQ66OzZm86aHO7yPFbU6+D7YoSjb4ZPNlHCHE3lybEW/
gx22y52vyDkY7rCwXv2SEnuIg5lmwrSJ38MddgsLbH/OHOKw1fjj5m26EQ5X
l/+YvYYhxMHEruni7eQIh4/WDxsK/wY7bPIQfs8wK8KB68LJVLNfwQ6GwUt4
1C5EOKikbPL6/S3YYUOsqZY3W6SD3Y9Z+gc+Bzscu5j27PLzCAcbjmX2Co+D
He66zlgUczLCwVpio3/DpWAH/n/9scb/Ixw2d282FgOGR5jvseculyMcmG7c
PpgMDC/08AQA32ihEw==
           "], {{122.39108270000001`, 11.710031700000002`}, {122.8957057, 
           11.4312258}, {123.1509668, 11.5970843}, {123.1268304, 
           11.1713903}, {122.5434058, 10.788808750000001`}, {
           121.95998119999999`, 10.4062272}, {122.03010395, 11.05452185}, {
           122.10022670000001`, 11.7028165}, {121.88475309999998`, 
           11.898859800000002`}, {122.39108270000001`, 
           11.710031700000002`}}, {{122.78232690000002`, 10.0685807}, {
           122.9523118, 10.8942774}, {123.5102864, 10.924357700000002`}, {
           123.3205631, 10.3828821}, {123.13083980000002`, 9.8414065}, {
           123.31309359999999`, 9.31528039999998}, {123.128155, 9.045848}, {
           122.38070880000001`, 9.70758319999999}, {122.78232690000002`, 
           10.0685807}}, {{123.6610768, 12.3422951}, {123.89477440000002`, 
           12.2088855}, {124.05250600000001`, 11.9692456}, {124.0692219, 
           11.721371800000002`}, {123.5349991, 12.21298}, {123.1459223, 
           11.9240353}, {123.2352521, 12.6005194}, {123.6610768, 
           12.3422951}}, {{123.7097381, 10.1572465}, {123.3014459, 
           9.41685419999999}, {123.37127550000001`, 9.99368389999999}, {
           123.6615493, 10.3836646}, {123.9445966, 11.187201}, {
           124.06453270000002`, 11.285861}, {124.02125309999998`, 
           10.3833851}, {123.7097381, 10.1572465}}, {{
           167.4433888, -16.1142622}, {167.7654055, -16.3326735}, {
           167.7674476, -16.5463734}, {167.4216095, -16.528423}, {
           167.3943159, -16.182622700000003`}, {167.1881617, -16.1368129}, {
           167.1794866, -15.902326500000001`}, {167.4433888, -16.1142622}}, {{
           167.9436238, -29.123153300000002`}, {
           167.9426874, -29.117020500000002`}, {
           167.9474256, -29.114536899999997`}, {167.965589, -29.1171779}, {
           167.9633048, -29.1224887}, {167.9535248, -29.122433700000002`}, {
           167.9511515, -29.1328671}, {
           167.9436238, -29.123153300000002`}}, {{-172.4693158, \
-8.56306230000002}, {-172.4948233, -8.53507720000001}, {-172.5022558, \
-8.53735880000001}, {-172.4933342, -8.53384020000001}, {-172.4662023, \
-8.5570503}, {-172.4656387, -8.57539570000001}, {-172.4693158, \
-8.56306230000002}}, CompressedData["
1:eJxTTMoPSmViYGAQBWIw/abU0dg/8sCj7TX19/YGO+Q/W8gwWzbyQC3LYvPG
VcEOJx+c3c/0JuKAeODJ98rTgx2Ub/+sy9oVcWDT3PfLjzUHO7iAwNeIA8cm
xev8bA12SFvbxylnEHngVvv5DdodwQ4dYjfPfc+KPPCuxt40rivYYWW98pSL
SyMPMBat3zmhJ9jh1IvcyNUPIg+IpcvbHe4LdngTuEOuVTrqgGZM/6GvE4Id
djrcnW3lGHUgRkt1l+yCYIcyj2tt+lxRB/YsfbZnwvJgB9OA84UqlyMPyCiu
2M+8Huj+63FyrqxRB1qk75/l3BHssCzu3alU86gDb0TF7vAfDHa4/7S2vC0z
6kCIgO8r0VPBDtsb1ufwG0YdKDjdmbfkeLBDn/TDxBk/Ig/0th37ZHQU6J9t
QuGKByIPrHRkLj94KNjBNtDFZ1V75IFjf+x/+x8IdkAPPwBrNqTo
           "], {{-74.8551576, 22.852733200000003`}, {-75.22913, 
           23.17418}, {-75.07413, 23.1086799}, {-75.0821901, 
           23.09039}, {-75.0447904, 23.0824022}, {-75.3305, 
           23.68527}, {-74.8551576, 22.852733200000003`}}, {{-73.6712133, 
           20.9300773}, {-73.6675313, 21.1137906}, {-73.3906963, 
           21.2367541}, {-73.1723065, 21.1642409}, {-73.0101199, 
           21.333529}, {-73.1628741, 20.9650889}, {-73.6712133, 
           20.9300773}}, {{-72.9921905, 18.8823917}, {-72.8467412, 
           18.8359605}, {-72.8075978, 18.7048246}, {-73.2167626, 
           18.8353598}, {-73.3013509, 18.9253185}, {-73.1979829, 
           18.9691085}, {-72.9921905, 18.8823917}}, {{-61.3417918, 
           12.692325}, {-61.35452910000001, 12.7042734}, {-61.32637660000001, 
           12.7062411}, {-61.3328826, 12.7374616}, {-61.311785400000005`, 
           12.7377462}, {-61.308232, 12.7185824}, {-61.3417918, 
           12.692325}}, {{-61.2457297, 13.010635400000002`}, {-61.2489677, 
           13.018022300000002`}, {-61.2045246, 
           13.046471}, {-61.23022310000001, 12.9875062}, {-61.2868401, 
           12.9896199}, {-61.2476639, 12.9956521}, {-61.2457297, 
           13.010635400000002`}}, {{-58.42748, -52.09867}, {-58.52662, \
-52.0592501}, {-58.55275, -52.02149}, {-58.489380000000004`, -51.98925}, \
{-58.3929201, -51.9978701}, {-58.46986009999999, -52.02717}, {-58.42748, \
-52.09867}}, {{-25.1998558, 17.161829}, {-25.0890549, 
           17.2044534}, {-24.9632542, 17.0886167}, {-25.1790848, 
           16.9171174}, {-25.2975311, 16.9074274}, {-25.3587267, 
           17.0603992}, {-25.1998558, 17.161829}}, {{8.72674190000001, 
           42.0347815}, {8.5453504, 42.3757682}, {9.004409849999995, 
           42.6812611}, {9.46346929999999, 42.986754}, {9.55536270000001, 
           42.1270125}, {9.22039259999999, 41.3665009}, {8.78706459999999, 
           41.5560171}, {8.72674190000001, 42.0347815}}, {{9.76013110000001, 
           54.9814145}, {9.826673900000001, 54.932808900000005`}, {
           9.87379589999999, 54.9425528}, {9.63934239999999, 
           55.051212500000005`}, {10.0713457, 54.8770439}, {9.79422609999999, 
           54.8962752}, {9.76013110000001, 54.9814145}}, {{14.3099312, 
           44.9417622}, {14.417094, 44.9464023}, {14.2766561, 45.1041286}, {
           14.3266751, 45.17532690000001}, {14.4866462, 44.9551481}, {
           14.520722800000001`, 44.6108486}, {14.3099312, 44.9417622}}, {{
           19.3774310783823, 41.8479503141651}, {19.3778542807084, 
           41.8481930871545}, {19.3778703269917, 41.84815767478461}, {
           19.3778938, 41.8481303}, {19.3777309, 41.8480388}, {
           19.3776446693547, 41.8480125201927}, {19.3774310783823, 
           41.8479503141651}}, {{20.371, 60.22500000000001}, {
           20.325500000000005`, 60.23275}, {20.34825, 60.27025}, {20.32425, 
           60.29275}, {20.4325, 60.246249999999996`}, {20.3735, 60.19625}, {
           20.371, 60.22500000000001}}, {{20.3758199, 59.978860100000006`}, {
           20.3595584, 60.000582800000004`}, {20.2995201, 
           59.964909999999996`}, {20.2794299, 59.973380000000006`}, {
           20.3511866, 60.0221635}, {20.4560426, 60.0053247}, {20.3758199, 
           59.978860100000006`}}, {{20.96745, 59.9233999}, {20.9791688, 
           59.9265713}, {20.9100101, 59.95612}, {21.0066084, 
           59.951151499999995`}, {20.9562, 59.9477}, {20.99778, 59.93056}, {
           20.96745, 59.9233999}}, {{46.2451075, -9.46105140000001}, {
           46.443852, -9.37401750000001}, {46.5238522, -9.401615}, {
           46.2821316, -9.49376840000001}, {46.2334926, -9.484730600000011}, {
           46.2091849, -9.42061550000002}, {
           46.2451075, -9.46105140000001}}, {{79.8906581, 8.9555914}, {
           79.811669, 9.0351078}, {79.68978220000001, 9.09147949999999}, {
           79.8621352, 9.07255319999998}, {79.9275382, 9.00965810000001}, {
           79.853117, 9.0611094}, {79.8906581, 8.9555914}}, CompressedData["
1:eJxTTMoPSmViYGAQBmIQ3XzQtPzLinCHLX2r1Do4QhzeRM95XlcW7vBYQGzX
dK4Qh5BvTBGcLuEOQpMbfZfzhDjsnZB5YrJguIOT6NsH2/hCHNS0L1jI3Q9z
KJoeUXJMIMRhqcmWlCaxcIcZZUl738mEOKjazZjwzDfcYX9oDpu4ZojDEvea
PV6t4Q5PTcr87U1DHFQCE16s2xPuwCPSMCPdMcRhcZSLiPCXcAfjz50P+31D
HP68Pt3heCPcYfFe7qUHAkIcdJPnfcj9Fe7wY6WWyQT/EIdpW8X04zUiHGy1
F7RPdA5x+MfenxsQFuHQuEb09iTzEIf0KPY1ji0RDsd0u/WmaIc46H25FJfn
G+HAxDZZ56JSiMPX3nmCs8WA+u/N0uKTCnHYo5515Pj9cIeKbYs0vAVDHNDD
BwDh2IAp
           "], {{103.1096775, 79.0380013}, {103.89413566666667`, 
           78.87317110000001}, {104.67859383333334`, 78.7083409}, {
           105.46305200000002`, 78.5435107}, {104.59510821428572`, 
           78.46770028571429}, {103.72716442857143`, 78.39188987142857}, {
           102.85922064285714`, 78.31607945714286}, {101.99127685714286`, 
           78.24026904285714}, {101.12333307142858`, 78.16445862857142}, {
           100.25538928571429`, 78.08864821428571}, {99.3874455, 
           78.0128378}, {100.14744976666667`, 78.4577718}, {
           100.90745403333334`, 78.90270579999999}, {101.6674583, 
           79.3476398}, {102.44606540000001`, 79.32465605}, {103.2246725, 
           79.3016723}, {102.4593462, 78.8122841}, {103.1096775, 
           79.0380013}}, {{110.8596175, 19.5239001}, {110.2787037, 
           18.853499999999997`}, {109.6977899, 18.1830999}, {
           109.19236000000001`, 18.344829949999998`}, {108.6869301, 
           18.50656}, {108.6226941, 19.272991}, {109.28812, 19.91364}, {
           109.98651004999999`, 20.037635}, {110.6849001, 20.16163}, {
           110.8596175, 19.5239001}}, {{117.89934819947901`, 
           4.16591388770424}, {117.9011043, 4.16406299999999}, {117.6849826, 
           4.16491899999999}, {117.683980187125, 4.165529973803}, {
           117.67880280000001`, 4.16868559999999}, {117.8870884, 
           4.17883529999999}, {117.89934819947901`, 4.16591388770424}}, {{
           126.6350338, 33.5373859}, {126.82687000000001`, 33.55911}, {
           126.94699280000002`, 33.4566715}, {126.60818880000001`, 
           33.2373318}, {126.1622712, 33.2851693}, {126.31219009999998`, 
           33.46883}, {126.6350338, 33.5373859}}, {{
           129.8631113, -2.9393690000000103`}, {
           130.5776403, -3.12451260000001}, {
           130.8501582, -3.8643770000000206`}, {
           129.95726786666668`, -3.5969135000000168`}, {
           129.06437753333333`, -3.3294500000000133`}, {
           128.1714872, -3.06198650000001}, {127.897121, -3.49843810000002}, {
           128.1640678, -2.86324430000001}, {
           129.01358955, -2.90130665000001}, {
           129.8631113, -2.9393690000000103`}}, {{134.2665374, 
           7.03846239999999}, {134.2450498, 7.0134014}, {134.27907480000002`, 
           7.0235301}, {134.2241999, 6.97426399999999}, {134.2242634, 
           7.0123579}, {134.2693192, 7.04945029999999}, {134.2665374, 
           7.03846239999999}}, {{134.478299, 7.34504239999999}, {134.5074165, 
           7.35342749999999}, {134.51407570000003`, 7.329066499999989}, {
           134.5038967, 7.311009699999999}, {134.506193, 7.33601849999998}, {
           134.4621049, 7.34212979999999}, {134.478299, 7.34504239999999}}, {{
           152.5222281, -3.89651200000001}, {
           151.9211210666667, -3.51451493333334}, {
           151.32001403333334`, -3.13251786666667}, {
           150.718907, -2.7505208}, {150.7963393, -2.55294550000001}, {
           151.50889286666666`, -3.0283803333333434`}, {
           152.22144643333334`, -3.503815166666677}, {
           152.934, -3.9792500000000106`}, {153.1185, -4.37275000000002}, {
           152.8785, -4.85125}, {152.70036405000002`, -4.373881000000005}, {
           152.5222281, -3.89651200000001}}, {{
           155.41272090000004`, -6.0616124}, {
           155.9194801, -6.50600410000001}, {155.968333, -6.71166700000002}, {
           155.9161199, -6.8011505}, {155.249167, -6.63500000000001}, {
           154.96161725000005`, -6.0347542500000095`}, {
           154.6740675, -5.43450850000001}, {
           155.41272090000004`, -6.0616124}}, {{156.7325, -7.}, {
           156.439167, -6.598333000000011}, {156.97, -6.86000000000001}, {
           157.1775, -7.164167000000011}, {157.538333, -7.29166700000002}, {
           157.648333, -7.450833000000011}, {
           157.1904165, -7.225416500000005}, {
           156.7325, -7.}}, {{-171.2015184, -9.33496840000001}, \
{-171.2137156, -9.32565630000001}, {-171.1947468, -9.3377472}, {-171.1835945, \
-9.35270430000002}, {-171.1820254, -9.3605215}, {-171.2015184, \
-9.33496840000001}}, {{-169.516629, -14.2297202}, {-169.507496, -14.2129183}, \
{-169.4184412, -14.2218774}, {-169.4244999, -14.256964300000002`}, \
{-169.4880845, -14.2726908}, {-169.516629, -14.2297202}}, {{-157.4766545, 
           1.98213259999999}, {-157.4956124, 2.0390355}, {-157.4546712, 
           2.04864189999999}, {-157.311501, 
           1.9840578999999803`}, {-157.1675238, 
           1.70121919999999}, {-157.4766545, 
           1.98213259999999}}, {{-155.9352399, 
           19.4782371}, {-156.06172890000002`, 19.7280359}, {-155.853313, 
           20.268438}, {-155.3301384, 19.8932045}, {-154.8069638, 
           19.517971}, {-155.24271405000002`, 19.21429535}, {-155.6784643, 
           18.9106197}, {-155.9352399, 19.4782371}}, {{-133.10881970000003`, 
           53.857211}, {-132.2696442, 54.0984223}, {-132.4795241, 
           53.563959200000006`}, {-132.06060785, 53.8785414}, {-131.6416916, 
           54.1931236}, {-131.92811625000002`, 53.6704274}, {-132.2145409, 
           53.1477312}, {-132.6616803, 53.5024711}, {-133.10881970000003`, 
           53.857211}}, {{-110.2266845, 77.5161374}, {-111.20123795000002`, 
           77.42878485}, {-112.1757914, 77.3414323}, {-112.74720794999999`, 
           77.58547379999999}, {-113.31862450000001`, 
           77.8295153}, {-112.37787570000002`, 
           77.89196369999999}, {-111.43712690000002`, 
           77.9544121}, {-110.4963781, 78.0168605}, {-109.5556293, 
           78.07930890000002}, {-110.23621445, 
           77.97141640000001}, {-110.9167996, 77.8635239}, {-110.2266845, 
           77.5161374}}, {{-98.6484817, 69.2931379}, {-97.9190364, 
           69.9037077}, {-96.99825763333332, 
           69.55910803333333}, {-96.07747886666667, 
           69.21450836666666}, {-95.1567001, 68.8699087}, {-95.84982, 
           68.6617694}, {-96.5429399, 68.4536301}, {-97.293112425, 
           68.5939301}, {-98.04328494999999, 
           68.73423009999999}, {-98.793457475, 68.8745301}, {-99.54363, 
           69.0148301}, {-98.6484817, 69.2931379}}, {{-93.5265, 
           75.0455}, {-93.48629, 74.67535}, {-94.00573005, 
           74.6515}, {-94.5251701, 74.62765}, {-95.22544673333333, 
           74.7496}, {-95.92572336666667, 74.87155}, {-96.626, 
           74.9935}, {-95.77000000000001, 75.3185}, {-94.914, 
           75.6435}, {-94.22025000000001, 75.34450000000001}, {-93.5265, 
           75.0455}}, {{-91.0728639, -0.5961645}, {-91.59387, \
-0.0117400000000093}, {-91.35985, 
           0.162890000000005}, {-91.07043999999999, -0.30136500000000344`}, \
{-90.78103, -0.765620000000012}, {-91.44078, -1.00059000000002}, \
{-91.0728639, -0.5961645}}, {{-82.1416799, 
           62.60515000000001}, {-82.63526494999999, 
           62.386520000000004`}, {-83.12885, 62.16789}, {-83.96479, 
           62.43003}, {-83.2869199, 62.93175}, {-82.57557495, 
           62.92389505}, {-81.86423, 62.9160401}, {-82.1416799, 
           62.60515000000001}}, {{-78.622, 72.84825}, {-79.311375, 
           72.857625}, {-80.00075, 72.867}, {-80.42275000000001, 
           73.30725000000001}, {-80.84475, 73.7475}, {-79.986378675, 
           73.699174775}, {-79.12800735, 73.65084955}, {-78.26963602500001, 
           73.602524325}, {-77.4112647, 73.5541991}, {-76.73162095, 
           73.2320834}, {-76.05197720000001, 72.9099677}, {-76.90865146666667,
            72.88939513333332}, {-77.76532573333333, 
           72.86882256666667}, {-78.622, 
           72.84825}}, {{-75.4868, -73.0032}, {-75.8373, -72.9689}, \
{-75.08255, -72.97035}, {-74.3278, -72.9718}, {-74.3796, -73.5463}, \
{-75.28800000000001, -73.35375}, {-76.1964, -73.1612}, {-75.4868, -73.0032}}, \
{{-73.8893655, -41.8758285}, {-73.33709, -42.26554}, {-73.592195, \
-42.847280000000005`}, {-73.8473, -43.42902}, {-74.10346, \
-43.393080000000005`}, {-74.4049299, -43.26108990000001}, {-74.1471477, \
-42.5684592}, {-73.8893655, -41.8758285}}, {{-71.83973240000002, 
           21.858922}, {-71.6729851, 21.8333495}, {-71.6407037, 
           21.7370349}, {-71.6991577, 21.787638}, {-71.8250214, 
           21.7657674}, {-71.83973240000002, 
           21.858922}}, {{-68.4315, -78.5621}, {-67.74515, \
-78.47579999999999}, {-67.0588, -78.3895}, {-66.26320000000001, \
-78.39654999999999}, {-65.4676, -78.4036}, {-66.425325, -78.60235}, \
{-67.38305, -78.80109999999999}, {-68.34077500000001, -78.99985}, {-69.2985, \
-79.1986}, {-70.0658, -79.17320000000001}, {-70.8331, -79.1478}, \
{-70.03256666666667, -78.95256666666667}, {-69.23203333333333, \
-78.75733333333334}, {-68.4315, -78.5621}}, {{-65.3847354, 
           18.1121647}, {-65.5328191, 18.0803383}, {-65.5782239, 
           18.1200631}, {-65.3987274, 18.162885700000004`}, {-65.2669, 
           18.1344863}, {-65.3847354, 18.1121647}}, {{-64.3435233, 
           18.7177685}, {-64.3993933, 18.7225807}, {-64.4168385, 
           18.7407297}, {-64.3245742, 18.7470874}, {-64.2713791, 
           18.6908561}, {-64.3435233, 
           18.7177685}}, {{-59.696870000000004`, -51.27315}, {-59.4926901, \
-51.27575}, {-59.423269999999995`, -51.33501}, {-59.58557, \
-51.34320000000001}, {-59.8364501, -51.2634401}, {-59.696870000000004`, \
-51.27315}}, {{-25.942758, 70.5327014}, {-26.2596653, 
           70.589268}, {-27.164447850000002`, 
           70.52098025000001}, {-28.0692304, 
           70.4526925}, {-27.283334399999998`, 70.6644286}, {-26.4974384, 
           70.8761647}, {-25.7115424, 71.0879008}, {-25.2606141, 
           70.6917159}, {-25.942758, 70.5327014}}, {{-24.9099072, 
           16.8786093}, {-24.8635573, 16.8147908}, {-24.985061, 
           16.7770063}, {-25.0859853, 16.826949}, {-24.9620895, 
           16.9223917}, {-24.9099072, 16.8786093}}, {{-23.5732245, 
           14.909481000000001`}, {-23.7794108, 15.0629495}, {-23.7447205, 
           15.339675500000002`}, {-23.4311234, 
           15.016538399999998`}, {-23.4818673, 
           14.905787500000002`}, {-23.5732245, 
           14.909481000000001`}}, {{-23.2171735, 
           15.227351400000002`}, {-23.1802002, 15.3377959}, {-23.118562, 
           15.315553800000002`}, {-23.0884447, 15.1676335}, {-23.2056947, 
           15.1262913}, {-23.2171735, 15.227351400000002`}}, {{-22.8755615, 
           15.9736915}, {-22.965896, 16.0419421}, {-22.9196142, 
           16.2269587}, {-22.7062089, 16.202169}, {-22.681601800000003`, 
           16.0504239}, {-22.8755615, 15.9736915}}, {{-22.6007088, 
           72.3552858}, {-22.0319824, 72.2717281}, {-22.696759933333333`, 
           72.33785950000001}, {-23.361537466666668`, 
           72.4039909}, {-24.026315, 72.4701223}, {-24.5244748, 
           72.8334963}, {-23.6581419, 72.71602356666666}, {-22.791809, 
           72.59855083333333}, {-21.9254761, 72.4810781}, {-22.6007088, 
           72.3552858}}, {{-6.3703985, 62.2821379}, {-6.32687810000001, 
           62.305562099999996`}, {-6.2845435, 
           62.281448700000006`}, {-6.3839078, 62.2332896}, {-6.415983, 
           62.27237040000001}, {-6.3703985, 62.2821379}}, {{-4.82134710000001,
            54.0456335}, {-4.82536210000001, 54.0446243}, {-4.83054070000001, 
           54.0542934}, {-4.80001640000001, 54.0597282}, {-4.81277949999999, 
           54.0440688}, {-4.82134710000001, 54.0456335}}, {{4.7146096, 
           53.0474965}, {4.84172929999999, 53.183789600000004`}, {
           4.90714260000001, 53.1379572}, {4.79292540000001, 53.002264}, {
           4.71973270000001, 52.9844458}, {4.7146096, 53.0474965}}, {{
           5.24723740000001, 53.4030385}, {5.5115008, 53.4480467}, {
           5.55320260000001, 53.4414728}, {5.5561195, 53.4293768}, {
           5.15195099999999, 53.3539949}, {5.24723740000001, 53.4030385}}, {{
           11.9059648, 54.7107465}, {11.755096, 54.9200242}, {11.7055167, 
           54.9340064}, {12.165238600000002`, 54.8353663}, {11.9701978, 
           54.5591552}, {11.9059648, 54.7107465}}, {{15.042998199999998`, 
           44.4797469}, {15.2470019, 44.3495807}, {15.256267200000002`, 
           44.3215636}, {15.110758499999998`, 44.3186671}, {14.7322121, 
           44.7039056}, {15.042998199999998`, 44.4797469}}, {{16.8613972, 
           43.118318}, {16.5467523, 43.1385788}, {16.3663315, 43.1951194}, {
           16.5611083, 43.2356785}, {17.1968248, 43.1248078}, {16.8613972, 
           43.118318}}, {{20.60275, 60.04650000000001}, {20.628, 60.0445}, {
           20.5915, 60.0155}, {20.4955, 60.00775}, {20.5385, 60.0585}, {
           20.60275, 60.04650000000001}}, {{22.5256487, 58.69414890000001}, {
           22.3983446, 58.8889231}, {22.0421906, 58.9410079}, {22.6535297, 
           59.08735889999999}, {23.0691698, 58.8383778}, {22.5256487, 
           58.69414890000001}}, {{24.1061543, 38.6664281}, {24.5255586, 
           37.9571444}, {23.86483605, 38.39387385}, {23.2041135, 
           38.8306033}, {22.8285402, 38.8248006}, {23.317123200000005`, 
           39.0385731}, {24.1061543, 38.6664281}}, {{
           39.3656805, -5.9454666}, {39.5358325, -6.1891005}, {
           39.5147201, -6.47676370000001}, {39.2005728, -6.22083980000001}, {
           39.2978696, -5.72244170000002}, {39.3656805, -5.9454666}}, {{
           45.0183424689436, -12.6443753243574}, {
           45.0268865252739, -12.6366933971462}, {
           45.0419166874501, -12.6482423653195}, {
           45.02694581408261, -12.6583135065843}, {
           45.0303042556038, -12.6511278384846}, {
           45.0183424689436, -12.6443753243574}}, {{48.1003938, 29.9023641}, {
           48.0533649, 29.9214987}, {48.0435603, 29.938757}, {48.097906, 
           29.9677258}, {48.1446188, 29.929163}, {48.1003938, 29.9023641}}, {{
           53.4908719, 12.6999837}, {54.1098087, 12.7002899}, {54.5342045, 
           12.5427856}, {53.6778269, 12.3045547}, {53.3071749, 
           12.529639600000001`}, {53.4908719, 12.6999837}}, {{
           60.035000100000005`, 69.6905701}, {59.06608, 69.85728}, {
           58.405229999999996`, 70.23596}, {59.074794600000004`, 
           70.4635343}, {59.82019230000001, 70.13017214999999}, {60.56559, 
           69.79681}, {60.035000100000005`, 69.6905701}}, {{73.5398657, 
           4.20091879999999}, {73.5390472, 4.22339789999999}, {73.5468956, 
           4.2210084}, {73.5370142, 4.18830259999998}, {73.5279844, 
           4.1760197}, {73.5398657, 4.20091879999999}}, {{93.3139746, 
           79.7579132}, {92.64796845000001, 79.71808755}, {91.9819623, 
           79.6782619}, {92.3865406, 79.7619484}, {91.6848839, 
           79.91189585000001}, {90.9832272, 80.0618433}, {91.94827853333334, 
           80.01028786666667}, {92.91332986666667, 79.95873243333334}, {
           93.8783812, 79.90717700000002}, {93.3139746, 79.7579132}}, {{
           105.1319936, -2.0835671}, {105.9157994, -1.50140750000001}, {
           106.328199, -2.292677850000005}, {106.7405986, -3.0839482}, {
           105.9503746, -2.81890160000001}, {105.7589009, -2.1439508}, {
           105.1319936, -2.0835671}}, {{121.381329, 12.2938944}, {121.1104947,
            12.2438536}, {120.7187828, 12.867184349999999`}, {120.3270709, 
           13.4905151}, {120.99273079999999`, 13.5228095}, {121.557073, 
           13.1203457}, {121.381329, 12.2938944}}, {{
           122.0104043, -8.5166258}, {122.51434335, -8.39874825}, {
           123.0182824, -8.2808707}, {122.33086610000001`, -8.59340275}, {
           121.6434498, -8.9059348}, {120.7199622, -8.823602500000005}, {
           119.7964746, -8.74127020000001}, {
           120.42953390000001`, -8.2409221}, {121.2199691, -8.37877395}, {
           122.0104043, -8.5166258}}, {{126.5432201, 37.61994}, {126.4624199, 
           37.58933}, {126.37075000000002`, 37.61237}, {126.35162, 
           37.79171}, {126.5071199, 37.78226}, {126.5432201, 37.61994}}, {{
           159.8945161, -9.4086962}, {160.383333, -9.42166700000001}, {
           160.834167, -9.85333300000001}, {160.3275, -9.826666500000005}, {
           159.820833, -9.8}, {159.5963544, -9.30636150000001}, {
           159.8945161, -9.4086962}}, {{168., -16.1973033}, {
           168.1737464, -16.1004817}, {168.30906780000004`, -16.3308058}, {
           168.0110055, -16.3265342}, {167.91251800000003`, -16.2411304}, {
           168., -16.1973033}}, {{168.3660985, -16.76423}, {
           168.4606227, -16.7687632}, {168.4799648, -16.8418516}, {
           168.1782312, -16.8039516}, {168.1530802, -16.5719739}, {
           168.3660985, -16.76423}}, {{168.4773268, -17.8137029}, {
           168.2596206, -17.6861068}, {168.15804100000003`, -17.7080634}, {
           168.4442112, -17.5299743}, {168.5952375, -17.6900445}, {
           168.4773268, -17.8137029}}, {{169.1492548, -18.6380732}, {
           169.3407878, -18.9112598}, {169.2877115, -18.9956186}, {
           168.9906581, -18.8712434}, {169.0077446, -18.6600556}, {
           169.1492548, -18.6380732}}, {{169.3525698, -19.4144912}, {
           169.506017, -19.5203601}, {169.4459458, -19.6534878}, {
           169.22512710000004`, -19.4676157}, {169.2758606, -19.3286843}, {
           169.3525698, -19.4144912}}, {{-171.8569771, -9.142421}, \
{-171.8562846, -9.1554085}, {-171.8622799, -9.17227240000001}, {-171.8612148, \
-9.12514140000001}, {-171.8569771, -9.142421}}, {{-171.787096, \
-9.15134310000002}, {-171.7899133, -9.13509820000002}, {-171.7875785, \
-9.13484550000002}, {-171.7667398, -9.21402270000001}, {-171.787096, \
-9.15134310000002}}, {{-169.3773199, 63.15293}, {-169.6455596, 
           62.9379035}, {-170.37643970000002`, 
           63.143495666666674`}, {-171.1073198, 
           63.349087833333336`}, {-171.8381999, 63.55468}, {-171.050527425, 
           63.4899825}, {-170.26285495000002`, 
           63.42528500000001}, {-169.475182475, 
           63.360587499999994`}, {-168.68751, 63.29589}, {-169.3773199, 
           63.15293}}, {{-165.9082329, 60.337160600000004`}, {-165.5650754, 
           59.9265341}, {-166.1523423, 59.74739060000001}, {-166.80549615, 
           59.97946315000001}, {-167.45865000000003`, 
           60.21153569999999}, {-166.68344145, 
           60.274348149999994`}, {-165.9082329, 
           60.337160600000004`}}, {{-159.985432, -0.379422499999996}, \
{-160.0047092, -0.38049750000001}, {-160.0135328, -0.378285099999999}, \
{-159.9982911, -0.363884900000011}, {-159.985432, -0.379422499999996}}, \
{{-159.7323213, -21.260870500000003`}, {-159.8160052, -21.2575771}, \
{-159.83061950000004`, -21.2169727}, {-159.7520956, -21.2039882}, \
{-159.7323213, -21.260870500000003`}}, {{-157.8989362, -21.9050055}, \
{-157.8784063, -21.9548829}, {-157.9578337, -21.9436924}, {-157.9447874, \
-21.8977819}, {-157.8989362, -21.9050055}}, {{-149.3056544, -17.7207632}, \
{-149.1451406, -17.8713527}, {-149.62054450000002`, -17.5616577}, \
{-149.3409844, -17.543905}, {-149.3056544, -17.7207632}}, {{-135.2196092, 
           57.0000106}, {-135.5509941, 57.50900140000001}, {-134.8322048, 
           57.4174167}, {-134.7519089, 56.7889368}, {-134.671613, 
           56.1604569}, {-134.9456111, 56.580233750000005`}, {-135.2196092, 
           57.0000106}}, {{-118.90975000000002`, 75.79625}, {-118.34725, 
           75.95637500000001}, {-117.78475, 76.1165}, {-117.44175, 
           76.09475}, {-118.09683333333334`, 
           75.93458333333334}, {-118.75191666666666`, 
           75.77441666666667}, {-119.407, 75.61425}, {-118.90975000000002`, 
           75.79625}}, {{-105.9024077, 73.1427095}, {-106.45657215, 
           73.31546234999999}, {-107.0107366, 
           73.4882152}, {-106.15560906666667`, 
           73.50815246666667}, {-105.30048153333333`, 
           73.52808973333333}, {-104.445354, 73.548027}, {-104.841382, 
           73.19911855000001}, {-105.23741, 72.8502101}, {-105.9024077, 
           73.1427095}}, {{-105.598118, 77.7348359}, {-105.0195668, 
           77.4083134}, {-104.3462306, 77.2058308}, {-105.2318705, 
           77.468006}, {-106.11751040000001`, 77.7301812}, {-105.598118, 
           77.7348359}}, {{-98.1068396, 78.5813335}, {-98.4012465, 
           78.769997}, {-97.506247375, 78.66793525}, {-96.61124825, 
           78.56587350000001}, {-95.716249125, 78.46381175}, {-94.82125, 
           78.36175}, {-95.51733333333334, 
           78.16991666666667}, {-96.21341666666666, 
           77.97808333333334}, {-96.9095, 77.78625}, {-97.5081698, 
           78.18379175}, {-98.1068396, 78.5813335}}, {{-96.25975, 
           77.68775}, {-95.48, 77.81725}, {-94.68016666666666, 
           77.76683333333334}, {-93.88033333333334, 
           77.71641666666666}, {-93.0805, 77.666}, {-93.78625, 
           77.435}, {-94.61075, 77.51925}, {-95.43525, 77.6035}, {-96.25975, 
           77.68775}}, {{-83.104886, 21.5081899}, {-82.993398, 
           21.9373797}, {-82.5757064, 21.7400567}, {-82.6229498, 
           21.5159224}, {-83.104886, 21.5081899}}, {{-81.6660403, 
           7.38562439999999}, {-81.5911484, 7.326934199999991}, {-81.88736, 
           7.49111}, {-81.75124990000002, 7.65001989999999}, {-81.6660403, 
           7.38562439999999}}, {{-79.9618303, 19.7061624}, {-80.0807738, 
           19.659167}, {-80.1107203, 19.660559}, {-80.0613525, 
           19.6955819}, {-79.9618303, 19.7061624}}, {{-79.89318, 
           19.68332}, {-79.75954, 19.75235}, {-79.7229199, 
           19.7521089}, {-79.75377, 19.72179}, {-79.89318, 
           19.68332}}, {{-79.8909299, 62.38156}, {-79.2596301, 
           62.23857}, {-79.79712, 61.57006}, {-80.2715601, 
           61.91037}, {-79.8909299, 
           62.38156}}, {{-79.5598, -77.2448}, {-78.65223333333333, \
-77.21483333333333}, {-77.74466666666667, -77.18486666666666}, {-76.8371, \
-77.1549}, {-76.2723, -77.6069}, {-75.7075, -78.0589}, {-76.54514999999999, \
-78.01436666666666}, {-77.3828, -77.96983333333333}, {-78.22045, -77.9253}, \
{-79.0581, -77.88076666666667}, {-79.89575, -77.83623333333335}, {-80.7334, \
-77.79170000000002}, {-80.1466, -77.51825}, {-79.5598, -77.2448}}, \
{{-77.13975, 67.36725}, {-76.90325, 67.81258}, {-76.66675000000001, 
           68.25791}, {-75.83761505, 68.201375}, {-75.0084801, 
           68.14484}, {-75.30172, 67.38173}, {-76.220735, 
           67.37449000000001}, {-77.13975, 67.36725}}, {{-75.0277263, 
           18.41234}, {-75.0048236, 18.4095765}, {-75.0011015, 
           18.3929023}, {-75.0159921, 18.3932539}, {-75.0277263, 
           18.41234}}, {{-74.6984, -69.984}, {-75.31725, -69.95439999999999}, \
{-75.9361, -69.92480000000002}, {-76.091, -69.6557}, {-75.3999, -69.6105}, \
{-74.7088, -69.5653}, {-74.6984, -69.984}}, {{-72.9680624, 
           20.0606861}, {-72.80166260000001, 20.0889573}, {-72.6201585, 
           19.9967728}, {-72.6954282, 19.9976278}, {-72.9680624, 
           20.0606861}}, {{-72.48225, 21.62225}, {-72.46425, 
           21.69525}, {-72.4440678, 21.7092053}, {-72.4207079, 
           21.7100671}, {-72.48225, 21.62225}}, {{-71.582037, 
           21.7609353}, {-71.47141370000001, 21.7245993}, {-71.4665574, 
           21.6531038}, {-71.58501090000001, 21.7256288}, {-71.582037, 
           21.7609353}}, {{-68.6896621, 18.114871}, {-68.7844125, 
           18.1886821}, {-68.5681195, 18.1214186}, {-68.6455631, 
           18.1299038}, {-68.6896621, 18.114871}}, {{-68.3754778, 
           12.2208175}, {-68.3879837, 12.3121223}, {-68.1970301, 
           12.22145}, {-68.23556, 12.02866}, {-68.3754778, 
           12.2208175}}, {{-68.0058, -67.3825}, {-68.6176, -67.7542}, \
{-69.2024, -67.59}, {-68.44465, -67.111}, {-67.6869, -66.632}, {-68.0058, \
-67.3825}}, {{-64.7613906, 18.4426115}, {-64.7814776, 
           18.443894}, {-64.7547832, 18.4587345}, {-64.7206745, 
           18.4413339}, {-64.7613906, 18.4426115}}, {{-64., 
           49.700412}, {-64.5197447, 49.8785712}, {-63.56958396666666, 
           49.63026103333333}, {-62.619423233333336`, 
           49.38195086666667}, {-61.6692625, 49.1336407}, {-62.301829, 
           49.16233135}, {-62.93439550000001, 
           49.191022}, {-63.467197750000004`, 49.445717}, {-64., 
           49.700412}}, {{-63.2351403, 18.2830211}, {-63.2521913, 
           18.2711644}, {-63.262706300000005`, 18.2789053}, {-63.2554822, 
           18.2845695}, {-63.2351403, 18.2830211}}, {{-62.9707128, 
           18.1250614}, {-62.9737869, 18.1167311}, {-62.9896656, 
           18.1124239}, {-62.9801384, 18.1248395}, {-62.9707128, 
           18.1250614}}, {{-62.92571029999999, 
           18.290729}, {-62.956018900000004`, 
           18.2747896}, {-62.96078250000001, 
           18.2769087}, {-62.945590499999994`, 
           18.2965492}, {-62.92571029999999, 18.290729}}, {{-62.8497119, 
           17.9313191}, {-62.8547588, 17.9303555}, {-62.8547673, 
           17.9338751}, {-62.8473602, 17.937035300000005`}, {-62.8497119, 
           17.9313191}}, {{-61.65073888762961, 
           15.848107108111098`}, {-61.63542584597041, 
           15.8713062179515}, {-61.61439790213671, 
           15.8553974556383}, {-61.63367278369349, 
           15.8395958965298}, {-61.65073888762961, 
           15.848107108111098`}}, {{-61.4353988, 12.5853583}, {-61.4608304, 
           12.5896724}, {-61.4515607, 12.6121293}, {-61.40803590000001, 
           12.6018769}, {-61.4353988, 
           12.5853583}}, {{-58.2593778841816, -34.1774079644075}, \
{-58.2436019406565, -34.174803233394}, {-58.2429075429419, \
-34.1857997377854}, {-58.2568259501225, -34.1902308262892}, \
{-58.2593778841816, -34.1774079644075}}, {{-24.3715509, 
           14.812638200000002`}, {-24.5040817, 
           14.920832800000001`}, {-24.3691714, 
           15.051644100000003`}, {-24.2776191, 14.8860712}, {-24.3715509, 
           14.812638200000002`}}, {{-24.2802016, 16.5605471}, {-24.3269288, 
           16.4813572}, {-24.4198595, 16.6549942}, {-24.0080036, 
           16.5696817}, {-24.2802016, 16.5605471}}, {{-22.9366212, 
           16.6790662}, {-22.9937762, 16.8094608}, {-22.9202853, 
           16.8552418}, {-22.8869446, 16.5916761}, {-22.9366212, 
           16.6790662}}, {{-16.416775, 11.524047}, {-16.386385, 
           11.560784}, {-16.246006, 11.579717}, {-16.270036, 
           11.489551}, {-16.416775, 11.524047}}, {{-16.2792705, 
           11.2351114}, {-16.2297677, 11.3101464}, {-16.1489863, 
           11.2684189}, {-16.191308, 11.2177907}, {-16.2792705, 
           11.2351114}}, {{-16.2388554, 11.9164903}, {-16.1730575, 
           11.8729465}, {-16.3295567, 11.8535626}, {-16.2909769, 
           11.9777634}, {-16.2388554, 11.9164903}}, {{-16.051807, 
           11.471994}, {-15.915521000000002`, 11.5164017}, {-15.900601, 
           11.453171}, {-16.0285673, 11.423019000000002`}, {-16.051807, 
           11.471994}}, {{-15.4684828, 11.6094248}, {-15.5458803, 
           11.5022114}, {-15.633001500000002`, 11.5268161}, {-15.4651737, 
           11.6379638}, {-15.4684828, 
           11.6094248}}, {{-14.31523, -7.9371214}, {-14.341887300000002`, \
-7.98322430000001}, {-14.4153155, -7.9766964000000105`}, \
{-14.394106700000002`, -7.89370220000001}, {-14.31523, -7.9371214}}, \
{{-12.313277, -37.0635068}, {-12.2170961, -37.1084129}, \
{-12.271220900000001`, -37.1676737}, {-12.3503972, -37.1185024}, {-12.313277, \
-37.0635068}}, {{-9.9333824, -40.3516893}, {-10.0150145, -40.3142144}, \
{-10.0016427, -40.2824355}, {-9.8758678, -40.3465087}, {-9.9333824, \
-40.3516893}}, {{-6.7552802, 62.29587}, {-6.8160752, 
           62.3718034}, {-6.65934560000001, 62.2281074}, {-6.71547500000001, 
           62.23623380000001}, {-6.7552802, 62.29587}}, {{-6.61497210000001, 
           62.25031260000001}, {-6.69551070000001, 
           62.3096047}, {-6.70089389999999, 62.3670366}, {-6.6173466, 
           62.3035378}, {-6.61497210000001, 
           62.25031260000001}}, {{-2.45712010000001, 49.478442}, {-2.4481007, 
           49.48292210000001}, {-2.44494719999999, 
           49.4646077}, {-2.45179350000001, 49.462941}, {-2.45712010000001, 
           49.478442}}, {{5.7760785, 53.4371657}, {5.61224850000001, 
           53.4478921}, {5.9728751, 53.4637457}, {5.95848899999999, 
           53.456298800000006`}, {5.7760785, 53.4371657}}, {{10.6679925, 
           54.8718156}, {10.7279486, 54.8779017}, {10.9540294, 55.1579039}, {
           10.717008300000002`, 54.72753670000001}, {10.6679925, 
           54.8718156}}, {{14.326300800000002`, 36.0179695}, {14.3388328, 
           36.0200238}, {14.3496718, 36.0080428}, {14.3243762, 36.0037859}, {
           14.326300800000002`, 36.0179695}}, {{14.701670599999998`, 
           55.1167354}, {14.773051, 55.2991679}, {15.1571454, 55.0831219}, {
           15.0748779, 54.987162}, {14.701670599999998`, 55.1167354}}, {{
           16.6403395, 43.3758445}, {16.8115342, 43.3519849}, {16.8995489, 
           43.3139241}, {16.4081329, 43.3198117}, {16.6403395, 
           43.3758445}}, {{20.3754163, 60.02396830000001}, {
           20.418798200000005`, 60.0569005}, {20.4722502, 60.0687416}, {
           20.4401486, 60.021417099999994`}, {20.3754163, 
           60.02396830000001}}, {{20.464, 60.043}, {20.47925, 60.06625}, {
           20.544, 60.06324999999999}, {20.473, 60.01325}, {20.464, 
           60.043}}, {{20.7002941, 78.2241186}, {20.1442911, 78.482375}, {
           20.830888, 78.44763293333334}, {21.5174849, 78.41289086666667}, {
           22.204081800000004`, 78.3781488}, {22.060785, 78.2590864}, {
           21.38053955, 78.24160250000001}, {20.7002941, 78.2241186}}, {{
           20.7921187, 60.2906381}, {20.8413856, 60.24500580000001}, {
           20.7820766, 60.224979}, {20.7322574, 60.25796460000001}, {
           20.7921187, 60.2906381}}, {{20.7963069, 60.3522786}, {20.7840331, 
           60.329300999999994`}, {20.7351955, 60.31404440000001}, {
           20.755537300000004`, 60.3708273}, {20.7963069, 60.3522786}}, {{
           28.2259372, 36.4531247}, {28.0870671, 36.0543936}, {27.734463, 
           35.915486}, {27.6849539, 36.1564526}, {28.2259372, 36.4531247}}, {{
           48.2897202, 29.466810399999996`}, {48.3547339, 
           29.451300699999997`}, {48.4025361, 29.3943658}, {48.2673384, 
           29.4290408}, {48.2897202, 29.466810399999996`}}, {{50.8154818, 
           25.6471276}, {50.81508, 25.6318135}, {50.7912386, 25.6283074}, {
           50.78039750000001, 25.6573735}, {50.8154818, 25.6471276}}, {{
           61.7148934, 80.8660155}, {62.187503, 80.7154227}, {
           61.24553623333333, 80.63768160000001}, {60.30356946666666, 
           80.5599405}, {59.361602700000006`, 80.4821994}, {59.68970370000001,
            80.7980471}, {60.36476693333334, 80.82070323333333}, {
           61.039830166666675`, 80.84335936666668}, {61.7148934, 
           80.8660155}}, {{63.0178479, 80.6417381}, {62.5145966, 
           80.7806179}, {63.46470193333334, 80.8581801}, {64.41480726666666, 
           80.9357423}, {65.3649126, 81.0133045}, {64.8975666, 80.774223}, {
           63.957707250000006`, 80.70798055}, {63.0178479, 80.6417381}}, {{
           73.0898883, -0.5781599000000192}, {
           73.0815697, -0.591901199999995}, {
           73.1091456, -0.653161100000001}, {
           73.0758896, -0.590448000000005}, {
           73.0898883, -0.5781599000000192}}, {{
           73.41141060000001, -0.289185400000008}, {
           73.4187434, -0.277464600000018}, {
           73.4399424, -0.310134199999997}, {
           73.4285039, -0.309761899999996}, {
           73.41141060000001, -0.289185400000008}}, {{73.5278197, 
           1.88136300000001}, {73.538687, 1.9404301999999802`}, {73.5443567, 
           1.94302510000001}, {73.5319155, 1.8657871999999898`}, {73.5278197, 
           1.88136300000001}}, {{73.5550756, 2.10515129999999}, {73.5512663, 
           2.117642}, {73.5855605, 2.13253409999999}, {73.5838514, 
           2.12245270000001}, {73.5550756, 2.10515129999999}}, {{
           96.8266809, -11.8417607}, {96.8169601, -11.8357063}, {
           96.8244716, -11.821651}, {96.83098890000001, -11.8263002}, {
           96.8266809, -11.8417607}}, {{103.7178159, 1.20251939999999}, {
           103.7070977, 1.20515809999999}, {103.7213886, 1.21366419999999}, {
           103.7337374, 1.20376369999999}, {103.7178159, 
           1.20251939999999}}, {{103.8382866, 1.2540925999999801`}, {
           103.848244, 1.2512187}, {103.8329043, 1.23779750000001}, {
           103.8065464, 1.2598247}, {103.8382866, 1.2540925999999801`}}, {{
           113.4628521, 74.3748867}, {112.8342916, 74.0786613}, {
           112.17148209999999`, 74.19284145}, {111.5086726, 74.3070216}, {
           112.0479753, 74.5479822}, {112.7554137, 74.46143445000001}, {
           113.4628521, 74.3748867}}, {{113.9358255, 22.3207739}, {
           113.9339918, 22.290619}, {113.8940835, 22.2946158}, {113.8932252, 
           22.3108948}, {113.9358255, 22.3207739}}, {{114.08183, 
           22.359940000000005`}, {114.1074097, 22.3631776}, {114.1177003, 
           22.3310182}, {114.091896, 22.3261795}, {114.08183, 
           22.359940000000005`}}, {{114.3036796, 22.354348}, {114.3066617, 
           22.3809131}, {114.31804500000001`, 22.3780363}, {114.3247486, 
           22.343974}, {114.3036796, 22.354348}}, {{
           119.13242409999998`, -9.72915220000002}, {
           119.93570319999999`, -9.27587100000002}, {
           120.3888817, -9.68223540000001}, {
           120.84206020000002`, -10.0885998}, {
           120.45414550000001`, -10.3173512}, {
           119.7932848, -10.02325170000001}, {
           119.13242409999998`, -9.72915220000002}}, {{123.8691081, 
           9.71786999999999}, {124.15601079999999`, 10.1545335}, {124.5590581,
            10.0243019}, {124.35819610000001`, 9.62935049999999}, {
           123.8691081, 9.71786999999999}}, {{125.619088, -8.1339876}, {
           125.6006227, -8.28567030000002}, {125.527196, -8.29554090000001}, {
           125.50164540000002`, -8.26221960000002}, {
           125.619088, -8.1339876}}, {{
           126.04960989999998`, -3.4452494000000105`}, {
           126.7088224, -3.0564326000000004`}, {
           127.2689748, -3.39104660000001}, {
           126.69586310000001`, -3.8620823}, {
           126.04960989999998`, -3.4452494000000105`}}, {{126.32540850000001`,
            34.5405379}, {126.33666989999999`, 34.40024}, {126.1296301, 
           34.35933}, {126.24034, 34.58669}, {126.32540850000001`, 
           34.5405379}}, {{134.1507768, 6.91401549999999}, {134.1469276, 
           6.8999719}, {134.1217856, 6.88969210000001}, {134.1248368, 
           6.9226039}, {134.1507768, 6.91401549999999}}, {{140.8433725, 
           73.6815873}, {141.67780295, 73.75707205}, {142.5122334, 
           73.83255680000002}, {143.06045870000003`, 73.521753}, {143.608684, 
           73.2109492}, {142.65073835, 73.2591457}, {141.6927927, 
           73.3073422}, {140.73484705, 73.3555387}, {139.7769014, 
           73.4037352}, {140.31013695000001`, 73.54266125000001}, {
           140.8433725, 73.6815873}}, {{145.1212525, 14.1187547}, {
           145.1598447, 14.1682177}, {145.2902727, 14.1894406}, {145.2146165, 
           14.1161278}, {145.1212525, 14.1187547}}, {{145.6461359, 
           14.9274011}, {145.6322492, 14.9249167}, {145.582302, 15.0179027}, {
           145.6449897, 15.101364000000002`}, {145.6461359, 14.9274011}}, {{
           145.8116178, 15.289980399999997`}, {145.7892505, 15.1503717}, {
           145.7072156, 15.106235100000001`}, {145.7167263, 15.21881}, {
           145.8116178, 15.289980399999997`}}, {{147.1741964, -2.1961956}, {
           146.5529953, -2.25509470000001}, {
           146.5059097, -2.1554579000000103`}, {147.4277797, -2.0078952}, {
           147.1741964, -2.1961956}}, {{149.0777918, 75.2259975}, {
           150.02156505, 75.1764821}, {150.9653383, 75.1269667}, {150.3033517,
            74.99415019999999}, {149.6413651, 74.8613337}, {148.9793785, 
           74.7285172}, {148.0243825, 74.89887286666666}, {147.0693865, 
           75.06922853333333}, {146.1143905, 75.2395842}, {
           147.10219093333333`, 75.2350553}, {148.08999136666668`, 
           75.2305264}, {149.0777918, 75.2259975}}, {{
           157.0925332, -8.19308140000001}, {
           157.504167, -7.960833000000009}, {157.88, -8.579167}, {
           157.525833, -8.245}, {157.0925332, -8.19308140000001}}, {{
           158.3256687, 6.91919339999998}, {158.2159259, 6.78472519999999}, {
           158.1112084, 6.92501809999999}, {158.2084531, 6.9898922}, {
           158.3256687, 6.91919339999998}}, {{
           158.9941562, -7.79166350000001}, {
           159.4244054, -8.06685805000001}, {
           159.8546546, -8.34205260000001}, {159.895467, -8.5650799}, {
           159.09646775, -8.067133650000006}, {
           158.2974685, -7.5691874000000094`}, {
           158.9941562, -7.79166350000001}}, {{
           160.770833, -9.00000000000001}, {160.5675, -8.32916700000001}, {
           160.9925, -8.62666700000001}, {
           161.19791650000002`, -9.108750000000004}, {
           161.403333, -9.590833}, {160.770833, -9.00000000000001}}, {{
           161.41525, -10.35775}, {161.281667, -10.208333}, {
           161.8294585, -10.5252915}, {162.37725, -10.84225}, {
           161.7603433, -10.7414336}, {161.41525, -10.35775}}, {{166.6143159, 
           19.2885731}, {166.6469325, 19.309595}, {166.6573715, 19.2701342}, {
           166.6209827, 19.2843135}, {166.6143159, 19.2885731}}, {{
           167.4455401, -22.661564400000003`}, {167.4132246, -22.6045804}, {
           167.4443384, -22.5351038}, {167.5577313, -22.616636}, {
           167.4455401, -22.661564400000003`}}, {{
           167.9246521, -15.401298500000001`}, {167.8351924, -15.4756866}, {
           167.6736766, -15.444490100000001`}, {167.9886542, -15.275497}, {
           167.9246521, -15.401298500000001`}}, {{168.0841415, 5.6456373}, {
           168.1366234, 5.6358611}, {168.1220499, 5.58859209999999}, {
           168.097741, 5.5919392}, {168.0841415, 5.6456373}}, {{
           168.223993, -15.7086128}, {
           168.28318270000003`, -15.922748700000001`}, {
           168.2124657, -16.0157944}, {
           168.15198420000002`, -15.448496100000002`}, {
           168.223993, -15.7086128}}, {{176.3205537, -6.2740193}, {
           176.3266822, -6.28408790000001}, {
           176.3203814, -6.30145700000001}, {
           176.3130037, -6.28947780000002}, {176.3205537, -6.2740193}}, {{
           179.999999974944, 71.5342000005999}, {179.999999974944, 
           70.9758499973363}, {179.317721837472, 70.99156479866815}, {
           178.6354437, 71.0072796}, {178.906028, 71.2202128}, {
           179.453013987472, 71.37720640029994}, {179.999999974944, 
           71.5342000005999}}, {{-16.5006549619873, 
           16.1279808672521}, {-16.418946, 16.518353}, {-16.4021064039226, 
           16.5075422285654}, {-16.5006549619873, 16.1279808672521}}}], 
         PolygonBox[{CompressedData["
1:eJxTTMoPSmViYGBQBGIQ3Z3z/PfKwHSH1gv3AxaKBzi4HqjhfWOa7pBTeig4
WyfA4Z+wkLyeVLpDiNTSMFPHAIcd6csNCv6lOVjvb4/8HxrgULzbxmnTozQH
pZSsmJNZAQ4Nsu9unjyR5vBD4Odl7dQAh976+YUP16U5nN/b7t0XH+Bwa+mm
s0WL0hz4N/w2XtEU4GDrp+PdvwGon2Hy+viOAIdgmTVLdgH5+z31om7PCHDw
P2q0qHJumsPXL4I/Dk8McPDO2znfoivNQXvB16lrugIcRJI6k3ynpzkcvCxl
eTAxwEFsnS0DQ0Oaw+Mks9p8JwRfRHL3tdJGBN/lvL1BzQEEv7T1SGfTfwR/
mbXn4w67QAdOMy0W43lpDuYbK/RO6wY6/N0rxpG2J83hhNqKSl7ZQIcPrsw8
M2+lOUTNuX7EnyfQ4cnZ9/xnfqQ5vBZkF5j0O8Dheugd4f9i6Q417WbRV14F
OGiZHtX9oJLuEMl7mcN9X4BDtcg694dG6Q5mk/O37QT6b9mhvq1fPdMdjsVZ
9kyeHeBw7sk3NUXrdIeoc17/t68PcPjOFj/DRyfd4Z1tTNGdwwEOeWvkv8V6
pzuU/8je5HY8wAEWn2v53VYxHUHwvZaee9jTheC/sAqXFA9E8GHxDwCAv+r9

           "], {{186.0271951, -18.6145018}, {186.00855, -18.6068411}, {
           185.9427979, -18.6740965}, {185.9948032, -18.5739279}, {
           186.066562, -18.5715482}, {186.0980892, -18.6296759}, {
           186.01756700000004`, -18.6806111}, {186.0271951, -18.6145018}}, {{
           184.8029664, -21.17982}, {184.9682986, -21.1470878}, {
           184.8644805, -21.272460100000004`}, {184.6654117, -21.1582135}, {
           184.6439047, -21.0918552}, {184.8465569, -21.1386978}, {
           184.8029664, -21.17982}}, {{180.000000114888, 70.9758500091835}, {
           180.000000114888, 71.5342000089782}, {180.3217985, 71.5747331}, {
           181.01861925, 71.54816655}, {181.71544, 71.5216}, {182.56738, 
           71.2245901}, {181.7115867049627, 71.1416767363945}, {
           180.85579340992533`, 71.058763372789}, {180.000000114888, 
           70.9758500091835}}, {{181.9029887, -14.3085863}, {
           181.8440935, -14.3034118}, {181.8216906, -14.2419829}, {
           181.9460677, -14.306462300000002`}, {181.9029887, -14.3085863}}, {{
           182.6045752, 28.1951891}, {182.6128884, 28.2153095}, {182.6390961, 
           28.2152755}, {182.6266399, 28.1996375}, {182.6045752, 
           28.1951891}}, {{183.8028479, -13.3432117}, {
           183.7499718, -13.3067816}, {183.7990272, -13.2170717}, {
           183.8377789, -13.2654857}, {183.8028479, -13.3432117}}}]},
        Antialiasing->True]}},
     Annotation[#, "GeoBackground", "WolframGeoGraphics"]& ], {{
      {RGBColor[0.901856875, 0.5237642499999999, 0.2053], 
       DiskBox[{0.683333, 47.4}, 0.5]}, 
      {RGBColor[0.9011289375, 0.574772125, 0.215009], 
       DiskBox[{-4.06667, 48.5167}, 0.5]}, 
      {RGBColor[0.9011289375, 0.574772125, 0.215009], 
       DiskBox[{-4.06667, 48.5167}, 0.5]}, 
      {RGBColor[0.8925421666666666, 0.3869823333333333, 0.17887524999999999`],
        DiskBox[{3.9333300000000007, 47.35}, 0.5]}, 
      {RGBColor[0.878107, 0.293208, 0.160481], 
       DiskBox[{-1.16667, 44.650000000000006}, 0.5]}, 
      {RGBColor[0.8899644583333334, 0.3702369166666667, 0.1755905625], 
       DiskBox[{4.11667, 46.666700000000006}, 0.5]}, 
      {RGBColor[0.8899644583333334, 0.3702369166666667, 0.1755905625], 
       DiskBox[{4.11667, 46.666700000000006}, 0.5]}, 
      {RGBColor[0.8124183190104166, 0.7081019934895834, 0.25454158463541665`],
        DiskBox[{16.2667, 49.3667}, 0.5]}, 
      {RGBColor[0.8124183190104166, 0.7081019934895834, 0.25454158463541665`],
        DiskBox[{16.3497, 49.4211}, 0.5]}, 
      {RGBColor[0.8118795455729166, 0.7084956419270834, 0.25473115494791665`],
        DiskBox[{16.2815, 49.41120000000001}, 0.5]}, 
      {RGBColor[0.8122387278645833, 0.7082332096354167, 0.2546047747395833], 
       DiskBox[{16.232, 49.403}, 0.5]}, 
      {RGBColor[0.8122387278645833, 0.7082332096354167, 0.2546047747395833], 
       DiskBox[{15.5, 47.}, 0.5]}, 
      {RGBColor[0.250728, 0.225386, 0.769152], 
       DiskBox[{-87.735, 40.8313}, 0.5]}, 
      {RGBColor[0.250728, 0.225386, 0.769152], 
       DiskBox[{-87.735, 40.8313}, 0.5]}, 
      {RGBColor[0.250728, 0.225386, 0.769152], 
       DiskBox[{-87.735, 40.8313}, 0.5]}, 
      {RGBColor[0.266122, 0.486664, 0.802529], 
       DiskBox[{-87.735, 40.8313}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-87.735, 40.8313}, 0.5]}, 
      {RGBColor[0.266122, 0.486664, 0.802529], 
       DiskBox[{-87.735, 40.8313}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-73.2089, 40.9076}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-73.2089, 40.9076}, 0.5]}, 
      {RGBColor[0.9010523125, 0.580141375, 0.216031], 
       DiskBox[{-72.90690000000001, 40.7777}, 0.5]}, 
      {RGBColor[0.9011289375, 0.574772125, 0.215009], 
       DiskBox[{-72.90690000000001, 40.7777}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-72.8615, 40.9447}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-72.8615, 40.9447}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-73.1493, 40.906400000000005}, 0.5]}, 
      {RGBColor[0.266122, 0.486664, 0.802529], 
       DiskBox[{-73.1493, 40.906400000000005}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-73.114, 40.9352}, 0.5]}, 
      {RGBColor[0.250728, 0.225386, 0.769152], 
       DiskBox[{-73.114, 40.9352}, 0.5]}, 
      {RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
       DiskBox[{74.3667, 42.3}, 0.5]}, 
      {RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
       DiskBox[{73.4, 42.1833}, 0.5]}, 
      {RGBColor[0.71098208984375, 0.74116771484375, 0.2966211171875], 
       DiskBox[{73.6333, 42.5833}, 0.5]}, 
      {RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
       DiskBox[{76.35, 42.8}, 0.5]}, 
      {RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
       DiskBox[{72.4667, 37.35}, 0.5]}, 
      {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
       DiskBox[{-84.4639, 37.9169}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.6691, 41.7976}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.6691, 41.7976}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.4366, 41.8266}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.4366, 41.8266}, 0.5]}, 
      {RGBColor[0.901243875, 0.56671825, 0.213476], 
       DiskBox[{-86.4366, 41.8266}, 0.5]}, 
      {RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 
       DiskBox[{-71.4378, 41.8972}, 0.5]}, 
      {RGBColor[0.9011480937499999, 0.5734298124999999, 0.2147535], 
       DiskBox[{-71.1445, 42.3634}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{14.05, 55.3833}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{14.05, 55.3833}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{14.05, 55.3833}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{14.05, 55.3833}, 0.5]}, 
      {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
       DiskBox[{14.05, 55.3833}, 0.5]}, 
      {RGBColor[0.5556259791666667, 0.7361003541666666, 0.4039107291666667], 
       DiskBox[{14.1333, 55.7167}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{14.1333, 55.7167}, 0.5]}, 
      {RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
       DiskBox[{14.1333, 55.7167}, 0.5]}, 
      {RGBColor[0.5556259791666667, 0.7361003541666666, 0.4039107291666667], 
       DiskBox[{14.1333, 55.7167}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{14.1333, 55.7167}, 0.5]}, 
      {RGBColor[0.5585707916666667, 0.7365315416666667, 0.40134529166666666`],
        DiskBox[{16.5167, 56.7}, 0.5]}, 
      {RGBColor[0.5585707916666667, 0.7365315416666667, 0.40134529166666666`],
        DiskBox[{16.5167, 56.7}, 0.5]}, 
      {RGBColor[0.57231325, 0.73854375, 0.38937325], 
       DiskBox[{17.0167, 59.4333}, 0.5]}, 
      {RGBColor[0.57231325, 0.73854375, 0.38937325], 
       DiskBox[{17.0167, 59.4333}, 0.5]}, 
      {RGBColor[0.57231325, 0.73854375, 0.38937325], 
       DiskBox[{16.8667, 59.566700000000004}, 0.5]}, 
      {RGBColor[0.57231325, 0.73854375, 0.38937325], 
       DiskBox[{16.8667, 59.566700000000004}, 0.5]}, 
      {RGBColor[0.6462000208333334, 0.7432718958333333, 0.33506718750000003`],
        DiskBox[{18.3667, 63.0833}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], DiskBox[{-86.583, 41.9}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], DiskBox[{-86.583, 41.9}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.4045, 43.3431}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.4045, 43.3431}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.607, 41.879}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.607, 41.879}, 0.5]}, 
      {RGBColor[0.250728, 0.225386, 0.769152], 
       DiskBox[{-85.398, 42.405}, 0.5]}, 
      {RGBColor[0.250728, 0.225386, 0.769152], 
       DiskBox[{-85.398, 42.405}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.358, 42.184}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.358, 42.184}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], DiskBox[{-86.67, 41.847}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], DiskBox[{-86.67, 41.847}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], DiskBox[{-86.67, 41.8}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], DiskBox[{-86.67, 41.8}, 0.5]}, 
      {RGBColor[0.901243875, 0.56671825, 0.213476], 
       DiskBox[{-86.509, 42.051}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.509, 42.051}, 0.5]}, 
      {RGBColor[0.266122, 0.486664, 0.802529], 
       DiskBox[{-86.509, 42.051}, 0.5]}, 
      {RGBColor[0.266122, 0.486664, 0.802529], 
       DiskBox[{-86.2657, 43.595}, 0.5]}, 
      {RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
       DiskBox[{-86.2657, 43.595}, 0.5]}, 
      {RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
       DiskBox[{-86.2657, 43.595}, 0.5]}, 
      {RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
       DiskBox[{-86.2657, 43.595}, 0.5]}, 
      {RGBColor[0.7988591875, 0.7180088124999999, 0.2593124375], 
       DiskBox[{-86.1859, 43.5139}, 0.5]}, 
      {RGBColor[0.72741575, 0.73723275, 0.2895825], 
       DiskBox[{-86.18430000000001, 43.5251}, 0.5]}, 
      {RGBColor[0.250728, 0.225386, 0.769152], 
       DiskBox[{-86.18430000000001, 43.5251}, 0.5]}, 
      {RGBColor[0.250728, 0.225386, 0.769152], 
       DiskBox[{-86.18430000000001, 43.5251}, 0.5]}, 
      {RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
       DiskBox[{-86.1739, 43.5187}, 0.5]}, 
      {RGBColor[0.8904799999999999, 0.373586, 0.1762475], 
       DiskBox[{-86.1788, 43.5356}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.1788, 43.5356}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.412, 42.166}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.412, 42.166}, 0.5]}, 
      {RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
       DiskBox[{-86.412, 42.166}, 0.5]}, 
      {RGBColor[0.266122, 0.486664, 0.802529], 
       DiskBox[{-86.33680000000001, 43.2483}, 0.5]}, 
      {RGBColor[0.250728, 0.225386, 0.769152], 
       DiskBox[{-86.33680000000001, 43.2483}, 0.5]}, 
      {RGBColor[0.250728, 0.225386, 0.769152], 
       DiskBox[{-86.0891, 43.2749}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.0891, 43.2749}, 0.5]}, 
      {RGBColor[0.250728, 0.225386, 0.769152], 
       DiskBox[{-86.0891, 43.2749}, 0.5]}, 
      {RGBColor[0.250728, 0.225386, 0.769152], 
       DiskBox[{-86.431, 42.148}, 0.5]}, 
      {RGBColor[0.250728, 0.225386, 0.769152], 
       DiskBox[{-86.431, 42.148}, 0.5]}, 
      {RGBColor[0.901243875, 0.56671825, 0.213476], 
       DiskBox[{-86.431, 42.148}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.3929, 43.7623}, 0.5]}, 
      {RGBColor[0.7988591875, 0.7180088124999999, 0.2593124375], 
       DiskBox[{-86.3929, 43.7623}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.3929, 43.7623}, 0.5]}, 
      {RGBColor[0.266122, 0.486664, 0.802529], 
       DiskBox[{-86.382, 42.184}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.382, 42.184}, 0.5]}, 
      {RGBColor[0.9010523125, 0.580141375, 0.216031], 
       DiskBox[{-86.496, 43.665}, 0.5]}, 
      {RGBColor[0.901243875, 0.56671825, 0.213476], 
       DiskBox[{-86.496, 43.665}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.496, 43.665}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.496, 43.665}, 0.5]}, 
      {RGBColor[0.9010523125, 0.580141375, 0.216031], 
       DiskBox[{-86.514, 42.03}, 0.5]}, 
      {RGBColor[0.250728, 0.225386, 0.769152], 
       DiskBox[{-86.646, 41.865}, 0.5]}, 
      {RGBColor[0.250728, 0.225386, 0.769152], 
       DiskBox[{-86.646, 41.865}, 0.5]}, 
      {RGBColor[0.9011289375, 0.574772125, 0.215009], 
       DiskBox[{-4.9, 50.4}, 0.5]}, 
      {RGBColor[0.901090625, 0.57745675, 0.21552000000000002`], 
       DiskBox[{-4.9, 50.4}, 0.5]}, 
      {RGBColor[0.9011289375, 0.574772125, 0.215009], 
       DiskBox[{-4.9, 50.4}, 0.5]}, 
      {RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
       DiskBox[{-4.9, 50.4}, 0.5]}, 
      {RGBColor[0.9010523125, 0.580141375, 0.216031], 
       DiskBox[{-4.9, 50.300000000000004}, 0.5]}, 
      {RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
       DiskBox[{-4.9, 50.300000000000004}, 0.5]}, 
      {RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
       DiskBox[{-4.8, 50.300000000000004}, 0.5]}, 
      {RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
       DiskBox[{-4.7, 50.4}, 0.5]}, 
      {RGBColor[0.9011289375, 0.574772125, 0.215009], 
       DiskBox[{-4.5, 50.5}, 0.5]}, 
      {RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
       DiskBox[{0.5, 51.3}, 0.5]}, 
      {RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666], 
       DiskBox[{0.5, 51.3}, 0.5]}, 
      {RGBColor[0.90147375, 0.5506105, 0.21041], DiskBox[{-1.7, 52.2}, 0.5]}, 
      {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
       DiskBox[{0.4, 51.3}, 0.5]}, 
      {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
       DiskBox[{0.3, 51.2}, 0.5]}, 
      {RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
       DiskBox[{0.4, 51.2}, 0.5]}, 
      {RGBColor[0.9010523125, 0.580141375, 0.216031], 
       DiskBox[{0.3, 51.2}, 0.5]}, 
      {RGBColor[0.9011002031249999, 0.5767855937499999, 0.21539225], 
       DiskBox[{0.6, 51.1}, 0.5]}, 
      {RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
       DiskBox[{1.1, 51.3}, 0.5]}, 
      {RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
       DiskBox[{1.1, 51.3}, 0.5]}, 
      {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
       DiskBox[{0.4, 51.1}, 0.5]}, 
      {RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
       DiskBox[{-3.0000000000000004, 54.5}, 0.5]}, 
      {RGBColor[0.9010523125, 0.580141375, 0.216031], 
       DiskBox[{-3.0000000000000004, 54.4}, 0.5]}, 
      {RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666], 
       DiskBox[{-3.3, 54.6}, 0.5]}, 
      {RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
       DiskBox[{-3.4, 54.7}, 0.5]}, 
      {RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
       DiskBox[{-2.9, 54.4}, 0.5]}, 
      {RGBColor[0.9010523125, 0.580141375, 0.216031], 
       DiskBox[{-2.9, 54.4}, 0.5]}, 
      {RGBColor[0.9010523125, 0.580141375, 0.216031], 
       DiskBox[{-3.2, 54.6}, 0.5]}, 
      {RGBColor[0.9010523125, 0.580141375, 0.216031], 
       DiskBox[{-3.4, 57.00000000000001}, 0.5]}, 
      {RGBColor[0.878107, 0.293208, 0.160481], DiskBox[{-1.6, 53.3}, 0.5]}, 
      {RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
       DiskBox[{1.1, 51.3}, 0.5]}, 
      {RGBColor[0.90147375, 0.5506105, 0.21041], DiskBox[{-4.1, 56.6}, 0.5]}, 
      {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
       DiskBox[{-4.4, 56.}, 0.5]}, 
      {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
       DiskBox[{-2.3000000000000003, 54.6}, 0.5]}, 
      {RGBColor[0.90147375, 0.5506105, 0.21041], 
       DiskBox[{-1.5000000000000002, 54.1}, 0.5]}, 
      {RGBColor[0.888933375, 0.36353875, 0.1742766875], 
       DiskBox[{-2.3000000000000003, 54.1}, 0.5]}, 
      {RGBColor[0.9010523125, 0.580141375, 0.216031], 
       DiskBox[{-1.3, 52.9}, 0.5]}, 
      {RGBColor[0.901090625, 0.57745675, 0.21552000000000002`], 
       DiskBox[{-3.1, 51.}, 0.5]}, 
      {RGBColor[0.57231325, 0.73854375, 0.38937325], 
       DiskBox[{-5.2, 56.4}, 0.5]}, 
      {RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
       DiskBox[{-3.3, 53.1}, 0.5]}, 
      {RGBColor[
       0.8959791111111111, 0.40930955555555554`, 0.18325483333333334`], 
       DiskBox[{-5.5, 57.400000000000006}, 0.5]}, 
      {RGBColor[0.901090625, 0.57745675, 0.21552000000000002`], 
       DiskBox[{-3.1, 52.9}, 0.5]}, 
      {RGBColor[0.57231325, 0.73854375, 0.38937325], 
       DiskBox[{-5.98333, 56.7333}, 0.5]}, 
      {RGBColor[0.8232835833333333, 0.7001634166666666, 0.2507185833333333], 
       DiskBox[{15.966700000000001, 56.3333}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{15.966700000000001, 56.3333}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{15.966700000000001, 56.3333}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.51, 55.86}, 0.5]}, 
      {RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333], 
       DiskBox[{16.2326, 49.4013}, 0.5]}, 
      {RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
       DiskBox[{17.4914, 63.0167}, 0.5]}, 
      {RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
       DiskBox[{18.0165, 62.6814}, 0.5]}, 
      {RGBColor[0.5543171736111111, 0.7359087152777778, 0.4050509236111111], 
       DiskBox[{14.12, 55.76}, 0.5]}, 
      {RGBColor[0.5543171736111111, 0.7359087152777778, 0.4050509236111111], 
       DiskBox[{14.12, 55.76}, 0.5]}, 
      {RGBColor[0.8118795455729166, 0.7084956419270834, 0.25473115494791665`],
        DiskBox[{16.2815, 49.41120000000001}, 0.5]}, 
      {RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 
       DiskBox[{16.2815, 49.41120000000001}, 0.5]}, 
      {RGBColor[0.8118795455729166, 0.7084956419270834, 0.25473115494791665`],
        DiskBox[{16.2815, 49.41120000000001}, 0.5]}, 
      {RGBColor[0.8118795455729166, 0.7084956419270834, 0.25473115494791665`],
        DiskBox[{16.2815, 49.41120000000001}, 0.5]}, 
      {RGBColor[0.8118795455729166, 0.7084956419270834, 0.25473115494791665`],
        DiskBox[{16.2815, 49.41120000000001}, 0.5]}, 
      {RGBColor[0.8118795455729166, 0.7084956419270834, 0.25473115494791665`],
        DiskBox[{16.2815, 49.41120000000001}, 0.5]}, 
      {RGBColor[0.8118795455729166, 0.7084956419270834, 0.25473115494791665`],
        DiskBox[{16.2815, 49.41120000000001}, 0.5]}, 
      {RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 
       DiskBox[{16.2815, 49.41120000000001}, 0.5]}, 
      {RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 
       DiskBox[{16.2, 49.1}, 0.5]}, 
      {RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
       DiskBox[{18.177, 62.877}, 0.5]}, 
      {RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
       DiskBox[{18.177, 62.877}, 0.5]}, 
      {RGBColor[0.6380844375000001, 0.7433658125, 0.3400189375], 
       DiskBox[{18.177, 62.877}, 0.5]}, 
      {RGBColor[0.6380844375000001, 0.7433658125, 0.3400189375], 
       DiskBox[{18.177, 62.877}, 0.5]}, 
      {RGBColor[0.6380844375000001, 0.7433658125, 0.3400189375], 
       DiskBox[{18.177, 62.877}, 0.5]}, 
      {RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
       DiskBox[{18.400000000000002, 62.900000000000006}, 0.5]}, 
      {RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
       DiskBox[{18.400000000000002, 62.900000000000006}, 0.5]}, 
      {RGBColor[0.5536627708333334, 0.7358128958333333, 0.40562102083333335`],
        DiskBox[{14.290000000000001, 56.06}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{14.290000000000001, 56.06}, 0.5]}, 
      {RGBColor[0.5543171736111111, 0.7359087152777778, 0.4050509236111111], 
       DiskBox[{14.290000000000001, 56.06}, 0.5]}, 
      {RGBColor[0.5536627708333334, 0.7358128958333333, 0.40562102083333335`],
        DiskBox[{14.290000000000001, 56.06}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.3712, 55.7509}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.3712, 55.7509}, 0.5]}, 
      {RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
       DiskBox[{17.7339, 62.64370000000001}, 0.5]}, 
      {RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
       DiskBox[{18.1896, 62.806}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.74, 56.1}, 0.5]}, 
      {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
       DiskBox[{13.74, 56.1}, 0.5]}, 
      {RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
       DiskBox[{13.74, 56.1}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.74, 56.1}, 0.5]}, 
      {RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666], 
       DiskBox[{13.74, 56.1}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.4, 55.66}, 0.5]}, 
      {RGBColor[0.8232835833333333, 0.7001634166666666, 0.2507185833333333], 
       DiskBox[{14.775, 56.0328}, 0.5]}, 
      {RGBColor[0.8132264791666666, 0.7075115208333334, 0.25425722916666665`],
        DiskBox[{13.9, 56.09}, 0.5]}, 
      {RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 
       DiskBox[{18.079, 62.800999999999995}, 0.5]}, 
      {RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 
       DiskBox[{18.079, 62.800999999999995}, 0.5]}, 
      {RGBColor[0.6462000208333334, 0.7432718958333333, 0.33506718750000003`],
        DiskBox[{18.2763, 62.9513}, 0.5]}, 
      {RGBColor[0.6462000208333334, 0.7432718958333333, 0.33506718750000003`],
        DiskBox[{18.2763, 62.9513}, 0.5]}, 
      {RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
       DiskBox[{18.3448, 62.9308}, 0.5]}, 
      {RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
       DiskBox[{18.3448, 62.9308}, 0.5]}, 
      {RGBColor[0.8232835833333333, 0.7001634166666666, 0.2507185833333333], 
       DiskBox[{15.8155, 56.1481}, 0.5]}, 
      {RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
       DiskBox[{16.1308, 56.4573}, 0.5]}, 
      {RGBColor[0.5507179583333334, 0.7353817083333334, 0.40818645833333334`],
        DiskBox[{13.4504, 55.6942}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.4504, 55.6942}, 0.5]}, 
      {RGBColor[0.5507179583333334, 0.7353817083333334, 0.40818645833333334`],
        DiskBox[{13.2145, 55.7097}, 0.5]}, 
      {RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
       DiskBox[{11.2, 58.9}, 0.5]}, 
      {RGBColor[0.5536627708333334, 0.7358128958333333, 0.40562102083333335`],
        DiskBox[{16.1284, 56.4666}, 0.5]}, 
      {RGBColor[0.8232835833333333, 0.7001634166666666, 0.2507185833333333], 
       DiskBox[{16.1284, 56.4666}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{13.2197, 55.6525}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.215, 55.6525}, 0.5]}, 
      {RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667], 
       DiskBox[{13.2233, 55.6514}, 0.5]}, 
      {RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667], 
       DiskBox[{13.2147, 55.6494}, 0.5]}, 
      {RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667], 
       DiskBox[{13.216100000000003, 55.6486}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{13.2225, 55.6472}, 0.5]}, 
      {RGBColor[0.5507179583333334, 0.7353817083333334, 0.40818645833333334`],
        DiskBox[{13.2264, 55.6481}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{13.217800000000002, 55.6561}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{13.2386, 55.6575}, 0.5]}, 
      {RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667], 
       DiskBox[{13.2, 55.6}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{13.2, 55.6}, 0.5]}, 
      {RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667], 
       DiskBox[{13.2, 55.6}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], DiskBox[{13.2, 55.7}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{13.1211, 55.7967}, 0.5]}, 
      {RGBColor[0.5507179583333334, 0.7353817083333334, 0.40818645833333334`],
        DiskBox[{13.1186, 55.7931}, 0.5]}, 
      {RGBColor[0.5507179583333334, 0.7353817083333334, 0.40818645833333334`],
        DiskBox[{13.1222, 55.7942}, 0.5]}, 
      {RGBColor[0.9010523125, 0.580141375, 0.216031], 
       DiskBox[{13.1206, 55.7989}, 0.5]}, 
      {RGBColor[0.5507179583333334, 0.7353817083333334, 0.40818645833333334`],
        DiskBox[{13.123300000000002, 55.7936}, 0.5]}, 
      {RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667], 
       DiskBox[{13.1219, 55.7989}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{13.104400000000002, 55.7967}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{13.1028, 55.8078}, 0.5]}, 
      {RGBColor[0.5507179583333334, 0.7353817083333334, 0.40818645833333334`],
        DiskBox[{13.1342, 55.8097}, 0.5]}, 
      {RGBColor[0.5507179583333334, 0.7353817083333334, 0.40818645833333334`],
        DiskBox[{13.1367, 55.8}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], DiskBox[{13.2, 55.7}, 0.5]}, 
      {RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667], 
       DiskBox[{13.2, 55.7}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.3075, 55.836400000000005}, 0.5]}, 
      {RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667], 
       DiskBox[{13.3033, 55.8369}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{13.3092, 55.8378}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.3106, 55.840300000000006}, 0.5]}, 
      {RGBColor[0.5507179583333334, 0.7353817083333334, 0.40818645833333334`],
        DiskBox[{13.3047, 55.8411}, 0.5]}, 
      {RGBColor[0.5507179583333334, 0.7353817083333334, 0.40818645833333334`],
        DiskBox[{13.2881, 55.8397}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.3181, 55.8369}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.3186, 55.8386}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.2906, 55.836400000000005}, 0.5]}, 
      {RGBColor[0.5507179583333334, 0.7353817083333334, 0.40818645833333334`],
        DiskBox[{13.2906, 55.8383}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.5519, 55.9336}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.5603, 55.9419}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.5511, 55.9403}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.5539, 55.9392}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{13.5542, 55.9414}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.5558, 55.9428}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.5533, 55.9497}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.5508, 55.9319}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.5481, 55.9281}, 0.5]}, 
      {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
       DiskBox[{13.5319, 55.9261}, 0.5]}, 
      {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
       DiskBox[{13.2244, 55.6528}, 0.5]}, 
      {RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
       DiskBox[{17.7422, 62.6425}, 0.5]}, 
      {RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
       DiskBox[{17.7406, 62.64220000000001}, 0.5]}, 
      {RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
       DiskBox[{17.735600000000005, 62.6425}, 0.5]}, 
      {RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
       DiskBox[{17.7372, 62.6425}, 0.5]}, 
      {RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
       DiskBox[{18.3447, 62.871399999999994}, 0.5]}, 
      {RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
       DiskBox[{18.3436, 62.8717}, 0.5]}, 
      {RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
       DiskBox[{18.3419, 62.8717}, 0.5]}, 
      {RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
       DiskBox[{18.3422, 62.871900000000004}, 0.5]}, 
      {RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 
       DiskBox[{17.69, 62.6322}, 0.5]}, 
      {RGBColor[
       0.8994160555555556, 0.43163677777777776`, 0.18763441666666666`], 
       DiskBox[{17.6906, 62.6322}, 0.5]}, 
      {RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 
       DiskBox[{18.4522, 62.889199999999995}, 0.5]}, 
      {RGBColor[0.8132264791666666, 0.7075115208333334, 0.25425722916666665`],
        DiskBox[{14.1386, 55.7683}, 0.5]}, 
      {RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
       DiskBox[{14.138300000000001, 55.7686}, 0.5]}, 
      {RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
       DiskBox[{14.1375, 55.76890000000001}, 0.5]}, 
      {RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
       DiskBox[{14.1369, 55.7692}, 0.5]}, 
      {RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
       DiskBox[{14.1347, 55.7694}, 0.5]}, 
      {RGBColor[0.5556259791666667, 0.7361003541666666, 0.4039107291666667], 
       DiskBox[{14.1342, 55.7706}, 0.5]}, 
      {RGBColor[0.5556259791666667, 0.7361003541666666, 0.4039107291666667], 
       DiskBox[{14.1342, 55.7708}, 0.5]}, 
      {RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
       DiskBox[{14.133100000000002, 55.7708}, 0.5]}, 
      {RGBColor[0.5543171736111111, 0.7359087152777778, 0.4050509236111111], 
       DiskBox[{14.121100000000002, 55.7719}, 0.5]}, 
      {RGBColor[0.5543171736111111, 0.7359087152777778, 0.4050509236111111], 
       DiskBox[{14.1206, 55.7717}, 0.5]}, 
      {RGBColor[0.5543171736111111, 0.7359087152777778, 0.4050509236111111], 
       DiskBox[{14.1208, 55.7714}, 0.5]}, 
      {RGBColor[0.6380844375000001, 0.7433658125, 0.3400189375], 
       DiskBox[{18.1842, 62.88360000000001}, 0.5]}, 
      {RGBColor[0.6380844375000001, 0.7433658125, 0.3400189375], 
       DiskBox[{18.1836, 62.8839}, 0.5]}, 
      {RGBColor[0.6198243750000001, 0.743577125, 0.351160375], 
       DiskBox[{18.3281, 63.0175}, 0.5]}, 
      {RGBColor[0.6198243750000001, 0.743577125, 0.351160375], 
       DiskBox[{18.3283, 63.0167}, 0.5]}, 
      {RGBColor[0.6380844375000001, 0.7433658125, 0.3400189375], 
       DiskBox[{18.3283, 63.01690000000001}, 0.5]}, 
      {RGBColor[0.6198243750000001, 0.743577125, 0.351160375], 
       DiskBox[{18.3283, 63.01720000000001}, 0.5]}, 
      {RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
       DiskBox[{18.1896, 62.806}, 0.5]}, 
      {RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
       DiskBox[{18.1896, 62.806}, 0.5]}, 
      {RGBColor[0.6462000208333334, 0.7432718958333333, 0.33506718750000003`],
        DiskBox[{18.2844, 62.96}, 0.5]}, 
      {RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
       DiskBox[{18.3589, 62.9611}, 0.5]}, 
      {RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
       DiskBox[{18.35, 62.96189999999999}, 0.5]}, 
      {RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
       DiskBox[{18.35, 62.96189999999999}, 0.5]}, 
      {RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
       DiskBox[{18.35, 62.962199999999996}, 0.5]}, 
      {RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
       DiskBox[{18.3608, 62.961400000000005}, 0.5]}, 
      {RGBColor[0.5507179583333334, 0.7353817083333334, 0.40818645833333334`],
        DiskBox[{13.2, 55.7}, 0.5]}, 
      {RGBColor[0.8121489322916666, 0.7082988177083334, 0.25463636979166665`],
        DiskBox[{13.900450000000001, 56.27373}, 0.5]}, 
      {RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
       DiskBox[{18.4728, 62.9169}, 0.5]}, 
      {RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
       DiskBox[{14.3336, 55.5796}, 0.5]}, 
      {RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
       DiskBox[{14.333999999999998, 55.5796}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{14.3336, 55.5796}, 0.5]}, 
      {RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
       DiskBox[{14.3336, 55.5796}, 0.5]}, 
      {RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
       DiskBox[{14.3336, 55.5796}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{14.3336, 55.5796}, 0.5]}, 
      {RGBColor[0.8123285234375, 0.7081676015625, 0.2545731796875], 
       DiskBox[{16.6314, 49.2771}, 0.5]}, 
      {RGBColor[0.8123285234375, 0.7081676015625, 0.2545731796875], 
       DiskBox[{16.6314, 49.2771}, 0.5]}, 
      {RGBColor[0.8123285234375, 0.7081676015625, 0.2545731796875], 
       DiskBox[{16.6314, 49.2771}, 0.5]}, 
      {RGBColor[0.5536627708333334, 0.7358128958333333, 0.40562102083333335`],
        DiskBox[{13.97, 56.06}, 0.5]}, 
      {RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333], 
       DiskBox[{16.2544, 49.3853}, 0.5]}, 
      {RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666], 
       DiskBox[{16.2544, 49.3853}, 0.5]}, 
      {RGBColor[0.8118795455729166, 0.7084956419270834, 0.25473115494791665`],
        DiskBox[{16.2544, 49.3853}, 0.5]}, 
      {RGBColor[0.8899644583333334, 0.3702369166666667, 0.1755905625], 
       DiskBox[{6.4333, 51.85}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-73.4675, 40.8585}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-73.4675, 40.8585}, 0.5]}, 
      {RGBColor[0.901243875, 0.56671825, 0.213476], 
       DiskBox[{-73.4675, 40.8585}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-76.5072, 42.4489}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-76.5072, 42.4489}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-71.0627, 42.373}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-71.0627, 42.373}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.621, 41.2816}, 0.5]}, 
      {RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666], 
       DiskBox[{73.1, 49.5}, 0.5]}, 
      {RGBColor[0.901856875, 0.5237642499999999, 0.2053], 
       DiskBox[{1.3, 45.}, 0.5]}, 
      {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
       DiskBox[{4.4, 51.2167}, 0.5]}, 
      {RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
       DiskBox[{18.484, 63.324}, 0.5]}, 
      {RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 
       DiskBox[{18.484, 63.324}, 0.5]}, 
      {RGBColor[0.8124183190104166, 0.7081019934895834, 0.25454158463541665`],
        DiskBox[{16.2326, 49.4013}, 0.5]}, 
      {RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
       DiskBox[{16.6166, 49.2}, 0.5]}, 
      {RGBColor[0.90147375, 0.5506105, 0.21041], 
       DiskBox[{-0.6383, 51.4083}, 0.5]}, 
      {RGBColor[0.9011480937499999, 0.5734298124999999, 0.2147535], 
       DiskBox[{-0.6383, 51.4083}, 0.5]}, 
      {RGBColor[
       0.8994160555555556, 0.43163677777777776`, 0.18763441666666666`], 
       DiskBox[{-92.3, 38.3}, 0.5]}, 
      {RGBColor[0.77217125, 0.72651625, 0.2704135], 
       DiskBox[{-23.6167, 15.1111}, 0.5]}, 
      {RGBColor[0.6380844375000001, 0.7433658125, 0.3400189375], 
       DiskBox[{18.177, 62.877}, 0.5]}, 
      {RGBColor[0.9014782222222222, 0.4450331111111111, 0.19026216666666665`],
        DiskBox[{6.3, 50.300000000000004}, 0.5]}, 
      {RGBColor[0.6198243750000001, 0.743577125, 0.351160375], 
       DiskBox[{18.3174, 63.0165}, 0.5]}, 
      {RGBColor[0.6380844375000001, 0.7433658125, 0.3400189375], 
       DiskBox[{18.3174, 63.0165}, 0.5]}, 
      {RGBColor[0.8132264791666666, 0.7075115208333334, 0.25425722916666665`],
        DiskBox[{8., 50.300000000000004}, 0.5]}, 
      {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
       DiskBox[{9.9355, 51.5338}, 0.5]}, 
      {RGBColor[0.8980412777777778, 0.4227058888888889, 0.18588258333333332`],
        DiskBox[{8., 50.300000000000004}, 0.5]}, 
      {RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
       DiskBox[{-0.6383, 51.4083}, 0.5]}, 
      {RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
       DiskBox[{-0.6383, 51.4083}, 0.5]}, 
      {RGBColor[0.9011289375, 0.574772125, 0.215009], 
       DiskBox[{-85.37, 44.46}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.621, 41.2816}, 0.5]}, 
      {RGBColor[0.71098208984375, 0.74116771484375, 0.2966211171875], 
       DiskBox[{68.49, 38.48}, 0.5]}, 
      {RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
       DiskBox[{73.1, 49.5}, 0.5]}, 
      {RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666], 
       DiskBox[{10.8719, 47.984}, 0.5]}, 
      {RGBColor[0.8737845, 0.25943675, 0.154574125], 
       DiskBox[{2.49, 41.59}, 0.5]}, 
      {RGBColor[0.7959857291666667, 0.7201082708333333, 0.26032347916666665`],
        DiskBox[{37.6322, 55.7522}, 0.5]}, 
      {RGBColor[
       0.8994160555555556, 0.43163677777777776`, 0.18763441666666666`], 
       DiskBox[{8.3, 50.300000000000004}, 0.5]}, 
      {RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
       DiskBox[{-0.6383, 51.4083}, 0.5]}, 
      {RGBColor[0.9011002031249999, 0.5767855937499999, 0.21539225], 
       DiskBox[{-0.6383, 51.4083}, 0.5]}, 
      {RGBColor[0.90147375, 0.5506105, 0.21041], DiskBox[{4.45, 52.24}, 0.5]}, 
      {RGBColor[0.8121489322916666, 0.7082988177083334, 0.25463636979166665`],
        DiskBox[{16.36, 49.42}, 0.5]}, 
      {RGBColor[0.8121489322916666, 0.7082988177083334, 0.25463636979166665`],
        DiskBox[{16.36, 49.42}, 0.5]}, 
      {RGBColor[0.8121489322916666, 0.7082988177083334, 0.25463636979166665`],
        DiskBox[{16.36, 49.42}, 0.5]}, 
      {RGBColor[0.8925421666666666, 0.3869823333333333, 0.17887524999999999`],
        DiskBox[{3.3, 46.}, 0.5]}, 
      {RGBColor[0.9011289375, 0.574772125, 0.215009], 
       DiskBox[{-1.41, 48.5}, 0.5]}, 
      {RGBColor[0.9011289375, 0.574772125, 0.215009], 
       DiskBox[{-1.41, 48.5}, 0.5]}, 
      {RGBColor[0.8737845, 0.25943675, 0.154574125], 
       DiskBox[{-3.53333, 38.3333}, 0.5]}, 
      {RGBColor[0.71098208984375, 0.74116771484375, 0.2966211171875], 
       DiskBox[{68.48, 38.35}, 0.5]}, 
      {RGBColor[0.9011002031249999, 0.5767855937499999, 0.21539225], 
       DiskBox[{-0.6383, 51.4083}, 0.5]}, 
      {RGBColor[0.90147375, 0.5506105, 0.21041], 
       DiskBox[{-0.6383, 51.4083}, 0.5]}, 
      {RGBColor[0.6563445000000001, 0.7431544999999999, 0.32887750000000004`],
        DiskBox[{23.5, 59.99999999999999}, 0.5]}, 
      {RGBColor[0.6563445000000001, 0.7431544999999999, 0.32887750000000004`],
        DiskBox[{23.5, 59.99999999999999}, 0.5]}, 
      {RGBColor[0.8737845, 0.25943675, 0.154574125], 
       DiskBox[{2.93056, 41.7194}, 0.5]}, 
      {RGBColor[0.8720555, 0.24592825000000001`, 0.152211375], 
       DiskBox[{2.93056, 41.7194}, 0.5]}, 
      {RGBColor[0.5173434166666667, 0.7304949166666667, 0.4372614166666667], 
       DiskBox[{13.9707, 56.0648}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{13.9707, 56.0648}, 0.5]}, 
      {RGBColor[0.8868712083333333, 0.3501424166666667, 0.17164893750000002`],
        DiskBox[{14.449999999999998, 48.3}, 0.5]}, 
      {RGBColor[0.8128672968749999, 0.707773953125, 0.254383609375], 
       DiskBox[{14.449999999999998, 48.3}, 0.5]}, 
      {RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 
       DiskBox[{8.26, 47.25}, 0.5]}, 
      {RGBColor[0.81178975, 0.70856125, 0.25476275], 
       DiskBox[{29.999999999999996, 52.3}, 0.5]}, 
      {RGBColor[0.9014782222222222, 0.4450331111111111, 0.19026216666666665`],
        DiskBox[{9.3, 52.3}, 0.5]}, 
      {RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 
       DiskBox[{16.2544, 49.3853}, 0.5]}, 
      {RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
       DiskBox[{-2.2207, 57.1539}, 0.5]}, 
      {RGBColor[0.888933375, 0.36353875, 0.1742766875], 
       DiskBox[{7.625509999999999, 48.0683}, 0.5]}, 
      {RGBColor[0.9011002031249999, 0.5767855937499999, 0.21539225], 
       DiskBox[{-2.4333, 54.800000000000004}, 0.5]}, 
      {RGBColor[0.8868712083333333, 0.3501424166666667, 0.17164893750000002`],
        DiskBox[{5.73, 53.448}, 0.5]}, 
      {RGBColor[0.8899644583333334, 0.3702369166666667, 0.1755905625], 
       DiskBox[{5.300000000000001, 50.300000000000004}, 0.5]}, 
      {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
       DiskBox[{5.5833, 51.8333}, 0.5]}, 
      {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
       DiskBox[{9.57073, 50.9167}, 0.5]}, 
      {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
       DiskBox[{6.1, 51.3333}, 0.5]}, 
      {RGBColor[0.888933375, 0.36353875, 0.1742766875], 
       DiskBox[{7.499999999999999, 47.5}, 0.5]}, 
      {RGBColor[0.9014782222222222, 0.4450331111111111, 0.19026216666666665`],
        DiskBox[{5.675, 52.}, 0.5]}, 
      {RGBColor[0.8132264791666666, 0.7075115208333334, 0.25425722916666665`],
        DiskBox[{13.287000000000003, 52.4584}, 0.5]}, 
      {RGBColor[0.8980412777777778, 0.4227058888888889, 0.18588258333333332`],
        DiskBox[{-4.79821, 56.5459}, 0.5]}, 
      {RGBColor[0.8868712083333333, 0.3501424166666667, 0.17164893750000002`],
        DiskBox[{11.3396, 44.5041}, 0.5]}, 
      {RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
       DiskBox[{-3.2667, 54.4}, 0.5]}, 
      {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
       DiskBox[{9.3166, 49.5166}, 0.5]}, 
      {RGBColor[
       0.8959791111111111, 0.40930955555555554`, 0.18325483333333334`], 
       DiskBox[{8.666700000000002, 50.01670000000001}, 0.5]}, 
      {RGBColor[0.266122, 0.486664, 0.802529], 
       DiskBox[{-122.755, 41.3599}, 0.5]}, 
      {RGBColor[
       0.8994160555555556, 0.43163677777777776`, 0.18763441666666666`], 
       DiskBox[{9.5, 50.5}, 0.5]}, 
      {RGBColor[0.878107, 0.293208, 0.160481], DiskBox[{-6.2, 54.1}, 0.5]}, 
      {RGBColor[0.878107, 0.293208, 0.160481], 
       DiskBox[{-1.64293, 53.2699}, 0.5]}, 
      {RGBColor[0.8980412777777778, 0.4227058888888889, 0.18588258333333332`],
        DiskBox[{8.26607, 50.2981}, 0.5]}, 
      {RGBColor[0.859088, 0.1446145, 0.13449075], 
       DiskBox[{-13.4811, 29.2144}, 0.5]}, 
      {RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
       DiskBox[{1.1, 51.3}, 0.5]}, 
      {RGBColor[0.8089162916666666, 0.7106607083333333, 0.25577379166666664`],
        DiskBox[{14.999999999999998, 37.3}, 0.5]}, 
      {RGBColor[0.9017419375, 0.5318181249999999, 0.20683300000000002`], 
       DiskBox[{12.1, 42.}, 0.5]}, 
      {RGBColor[0.8925421666666666, 0.3869823333333333, 0.17887524999999999`],
        DiskBox[{1.33867, 48.0717}, 0.5]}, 
      {RGBColor[0.7959857291666667, 0.7201082708333333, 0.26032347916666665`],
        DiskBox[{34.7361, 53.7502}, 0.5]}, 
      {RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
       DiskBox[{-8.25, 40.12}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-8.42639, 40.2077}, 0.5]}, 
      {RGBColor[0.9011480937499999, 0.5734298124999999, 0.2147535], 
       DiskBox[{2.823, 49.416}, 0.5]}, 
      {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
       DiskBox[{8.65081, 49.8724}, 0.5]}, 
      {RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666], 
       DiskBox[{5.04278, 47.3239}, 0.5]}, 
      {RGBColor[0.8980412777777778, 0.4227058888888889, 0.18588258333333332`],
        DiskBox[{8.2372, 50.7224}, 0.5]}, 
      {RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 
       DiskBox[{16.2667, 49.4167}, 0.5]}, 
      {RGBColor[0.8868712083333333, 0.3501424166666667, 0.17164893750000002`],
        DiskBox[{13.7336, 51.051}, 0.5]}, 
      {RGBColor[0.9010523125, 0.580141375, 0.216031], 
       DiskBox[{-1.5733, 54.7761}, 0.5]}, 
      {RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
       DiskBox[{0.5, 51.3}, 0.5]}, 
      {RGBColor[0.90147375, 0.5506105, 0.21041], 
       DiskBox[{-3.16028, 55.9494}, 0.5]}, 
      {RGBColor[
       0.8959791111111111, 0.40930955555555554`, 0.18325483333333334`], 
       DiskBox[{9.68253, 51.5105}, 0.5]}, 
      {RGBColor[0.8980412777777778, 0.4227058888888889, 0.18588258333333332`],
        DiskBox[{8.5, 50.}, 0.5]}, 
      {RGBColor[0.8089162916666666, 0.7106607083333333, 0.25577379166666664`],
        DiskBox[{8.5, 50.}, 0.5]}, 
      {RGBColor[0.9014782222222222, 0.4450331111111111, 0.19026216666666665`],
        DiskBox[{11.0087, 49.59550000000001}, 0.5]}, 
      {RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
       DiskBox[{24.5682, 60.19970000000001}, 0.5]}, 
      {RGBColor[0.8884178333333334, 0.3601896666666667, 0.17361975000000002`],
        DiskBox[{24.9871, 58.6656}, 0.5]}, 
      {RGBColor[0.901856875, 0.5237642499999999, 0.2053], 
       DiskBox[{2.56481, 44.6447}, 0.5]}, 
      {RGBColor[
       0.8959791111111111, 0.40930955555555554`, 0.18325483333333334`], 
       DiskBox[{8.6822, 50.1102}, 0.5]}, 
      {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
       DiskBox[{8.0167, 50.5}, 0.5]}, 
      {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
       DiskBox[{5.866670000000001, 51.0167}, 0.5]}, 
      {RGBColor[0.5173434166666667, 0.7304949166666667, 0.4372614166666667], 
       DiskBox[{8.67825, 50.584}, 0.5]}, 
      {RGBColor[0.8868712083333333, 0.3501424166666667, 0.17164893750000002`],
        DiskBox[{15.5, 47.}, 0.5]}, 
      {RGBColor[0.266122, 0.486664, 0.802529], 
       DiskBox[{-85.2532, 43.178}, 0.5]}, 
      {RGBColor[0.8980412777777778, 0.4227058888888889, 0.18588258333333332`],
        DiskBox[{10.5, 53.5}, 0.5]}, 
      {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
       DiskBox[{9.44, 52.24}, 0.5]}, 
      {RGBColor[0.8980412777777778, 0.4227058888888889, 0.18588258333333332`],
        DiskBox[{9.73569, 52.3721}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{12.5686, 55.675}, 0.5]}, 
      {RGBColor[0.5173434166666667, 0.7304949166666667, 0.4372614166666667], 
       DiskBox[{8.28844, 51.3472}, 0.5]}, 
      {RGBColor[0.9013205, 0.561349, 0.212454], 
       DiskBox[{9.88682, 54.4175}, 0.5]}, 
      {RGBColor[0.8121489322916666, 0.7082988177083334, 0.25463636979166665`],
        DiskBox[{14.999999999999998, 49.}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{11.587, 50.927}, 0.5]}, 
      {RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
       DiskBox[{77., 35.}, 0.5]}, 
      {RGBColor[0.8132264791666666, 0.7075115208333334, 0.25425722916666665`],
        DiskBox[{23.8924, 54.8969}, 0.5]}, 
      {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
       DiskBox[{-5.66364, 55.6395}, 0.5]}, 
      {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
       DiskBox[{6.9666, 50.95}, 0.5]}, 
      {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
       DiskBox[{8.50861, 50.1797}, 0.5]}, 
      {RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333], 
       DiskBox[{11.5722, 49.631}, 0.5]}, 
      {RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333], 
       DiskBox[{135.75200000000004, 35.008500000000005}, 0.5]}, 
      {RGBColor[
       0.8994160555555556, 0.43163677777777776`, 0.18763441666666666`], 
       DiskBox[{-3.78181, 55.6739}, 0.5]}, 
      {RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666], 
       DiskBox[{15.233299999999998, 52.7333}, 0.5]}, 
      {RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666], 
       DiskBox[{10.8719, 47.984}, 0.5]}, 
      {RGBColor[0.867733, 0.212157, 0.1463045], 
       DiskBox[{0.5, 48.00000000000001}, 0.5]}, 
      {RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333], 
       DiskBox[{4.49015, 52.1611}, 0.5]}, 
      {RGBColor[0.8122387278645833, 0.7082332096354167, 0.2546047747395833], 
       DiskBox[{8.0666, 50.3833}, 0.5]}, 
      {RGBColor[
       0.8959791111111111, 0.40930955555555554`, 0.18325483333333334`], 
       DiskBox[{8.0666, 50.3833}, 0.5]}, 
      {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
       DiskBox[{8.26664, 50.001}, 0.5]}, 
      {RGBColor[0.266122, 0.486664, 0.802529], 
       DiskBox[{-70.6652, 41.3923}, 0.5]}, 
      {RGBColor[0.81178975, 0.70856125, 0.25476275], 
       DiskBox[{10.1138, 51.9183}, 0.5]}, 
      {RGBColor[0.8980412777777778, 0.4227058888888889, 0.18588258333333332`],
        DiskBox[{20.5, 50.95}, 0.5]}, 
      {RGBColor[0.8980412777777778, 0.4227058888888889, 0.18588258333333332`],
        DiskBox[{8.5, 50.5}, 0.5]}, 
      {RGBColor[0.8232835833333333, 0.7001634166666666, 0.2507185833333333], 
       DiskBox[{10.981, 52.6969}, 0.5]}, 
      {RGBColor[0.8121489322916666, 0.7082988177083334, 0.25463636979166665`],
        DiskBox[{13.2995, 51.0581}, 0.5]}, 
      {RGBColor[0.8980412777777778, 0.4227058888888889, 0.18588258333333332`],
        DiskBox[{8.5833, 50.2}, 0.5]}, 
      {RGBColor[0.5173434166666667, 0.7304949166666667, 0.4372614166666667], 
       DiskBox[{8.2, 53.1667}, 0.5]}, 
      {RGBColor[0.8980412777777778, 0.4227058888888889, 0.18588258333333332`],
        DiskBox[{8.01161, 50.3827}, 0.5]}, 
      {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
       DiskBox[{8.42255, 53.3422}, 0.5]}, 
      {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
       DiskBox[{6.193019, 60.38554299999999}, 0.5]}, 
      {RGBColor[0.8121489322916666, 0.7082988177083334, 0.25463636979166665`],
        DiskBox[{29.000000000000004, 59.00000000000001}, 0.5]}, 
      {RGBColor[0.8876767421875, 0.355375359375, 0.17267540234375], 
       DiskBox[{10.51, 47.04}, 0.5]}, 
      {RGBColor[0.5173434166666667, 0.7304949166666667, 0.4372614166666667], 
       DiskBox[{10.6065, 53.476}, 0.5]}, 
      {RGBColor[0.901856875, 0.5237642499999999, 0.2053], 
       DiskBox[{-123.206, 49.26550000000001}, 0.5]}, 
      {RGBColor[0.9011289375, 0.574772125, 0.215009], 
       DiskBox[{-2.96591, 48.0653}, 0.5]}, 
      {RGBColor[0.81178975, 0.70856125, 0.25476275], 
       DiskBox[{-3.41697, 54.3512}, 0.5]}, 
      {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
       DiskBox[{5.56667, 51.9667}, 0.5]}, 
      {RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
       DiskBox[{12.1, 42.}, 0.5]}, 
      {RGBColor[0.9011480937499999, 0.5734298124999999, 0.2147535], 
       DiskBox[{1.09849, 49.4424}, 0.5]}, 
      {RGBColor[0.9014782222222222, 0.4450331111111111, 0.19026216666666665`],
        DiskBox[{34., 56.3}, 0.5]}, 
      {RGBColor[0.7988591875, 0.7180088124999999, 0.2593124375], 
       DiskBox[{38.28, 49.}, 0.5]}, 
      {RGBColor[0.8737845, 0.25943675, 0.154574125], 
       DiskBox[{3.0333300000000003, 41.7833}, 0.5]}, 
      {RGBColor[0.8737845, 0.25943675, 0.154574125], 
       DiskBox[{3.0333300000000003, 41.7833}, 0.5]}, 
      {RGBColor[0.9011289375, 0.574772125, 0.215009], 
       DiskBox[{-122.2, 47.}, 0.5]}, 
      {RGBColor[0.8613569062499999, 0.67234559375, 0.23732228125], 
       DiskBox[{11.5614, 46.5438}, 0.5]}, 
      {RGBColor[
       0.8994160555555556, 0.43163677777777776`, 0.18763441666666666`], 
       DiskBox[{8.02341, 50.8738}, 0.5]}, 
      {RGBColor[0.90147375, 0.5506105, 0.21041], 
       DiskBox[{-3.0073300000000005, 53.6473}, 0.5]}, 
      {RGBColor[0.8132264791666666, 0.7075115208333334, 0.25425722916666665`],
        DiskBox[{13.181, 52.5339}, 0.5]}, 
      {RGBColor[0.888933375, 0.36353875, 0.1742766875], 
       DiskBox[{9.5, 47.6667}, 0.5]}, 
      {RGBColor[0.5556259791666667, 0.7361003541666666, 0.4039107291666667], 
       DiskBox[{11.8558, 52.6058}, 0.5]}, 
      {RGBColor[0.8089162916666666, 0.7106607083333333, 0.25577379166666664`],
        DiskBox[{36., 52.}, 0.5]}, 
      {RGBColor[0.8122387278645833, 0.7082332096354167, 0.2546047747395833], 
       DiskBox[{14.500000000000002, 49.5}, 0.5]}, 
      {RGBColor[0.8122387278645833, 0.7082332096354167, 0.2546047747395833], 
       DiskBox[{-122.459, 47.2413}, 0.5]}, 
      {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
       DiskBox[{4.3, 52.08}, 0.5]}, 
      {RGBColor[0.8132264791666666, 0.7075115208333334, 0.25425722916666665`],
        DiskBox[{14.900000000000002, 56.5}, 0.5]}, 
      {RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
       DiskBox[{-83.5553, 41.6639}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-83.5553, 41.6639}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-83.5553, 41.6639}, 0.5]}, 
      {RGBColor[0.8875156354166667, 0.35432877083333336`, 0.172470109375], 
       DiskBox[{9.9042, 47.0748}, 0.5]}, 
      {RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 
       DiskBox[{136.31, 34.43}, 0.5]}, 
      {RGBColor[0.266122, 0.486664, 0.802529], 
       DiskBox[{-85.2563, 43.2708}, 0.5]}, 
      {RGBColor[0.888933375, 0.36353875, 0.1742766875], 
       DiskBox[{7.7667, 48.0333}, 0.5]}, 
      {RGBColor[0.8875156354166667, 0.35432877083333336`, 0.172470109375], 
       DiskBox[{5.1145, 52.091800000000006}, 0.5]}, 
      {RGBColor[0.901856875, 0.5237642499999999, 0.2053], 
       DiskBox[{-123.206, 49.26550000000001}, 0.5]}, 
      {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
       DiskBox[{5.55, 52.0333}, 0.5]}, 
      {RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
       DiskBox[{-2.3671, 54.9902}, 0.5]}, 
      {RGBColor[0.8132264791666666, 0.7075115208333334, 0.25425722916666665`],
        DiskBox[{21., 52.3}, 0.5]}, 
      {RGBColor[0.8132264791666666, 0.7075115208333334, 0.25425722916666665`],
        DiskBox[{29.999999999999996, 52.3}, 0.5]}, 
      {RGBColor[0.8232835833333333, 0.7001634166666666, 0.2507185833333333], 
       DiskBox[{10.066700000000003, 52.6}, 0.5]}, 
      {RGBColor[0.8877411848958333, 0.3557939947916667, 0.17275751953125001`],
        DiskBox[{10.8134, 47.92990000000001}, 0.5]}, 
      {RGBColor[0.8125081145833333, 0.7080363854166667, 0.2545099895833333], 
       DiskBox[{25.3167, 54.6833}, 0.5]}, 
      {RGBColor[
       0.8959791111111111, 0.40930955555555554`, 0.18325483333333334`], 
       DiskBox[{9.936100000000001, 49.7878}, 0.5]}, 
      {RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
       DiskBox[{-119.35000000000001, 37.45}, 0.5]}, 
      {RGBColor[0.8899644583333334, 0.3702369166666667, 0.1755905625], 
       DiskBox[{8.55, 47.3667}, 0.5]}, 
      {RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 
       DiskBox[{8.55, 47.3667}, 0.5]}, 
      {RGBColor[0.9014782222222222, 0.4450331111111111, 0.19026216666666665`],
        DiskBox[{8.32213, 50.3058}, 0.5]}, 
      {RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333], 
       DiskBox[{16.6166, 49.2}, 0.5]}, 
      {RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 
       DiskBox[{6.25, 48.6167}, 0.5]}, 
      {RGBColor[0.57231325, 0.73854375, 0.38937325], 
       DiskBox[{14.999999999999998, 49.}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-72.677, 41.767}, 0.5]}, 
      {RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 
       DiskBox[{-71.28250000000001, 41.7302}, 0.5]}, 
      {RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
       DiskBox[{-86.4251, 41.560900000000004}, 0.5]}, 
      {RGBColor[0.266122, 0.486664, 0.802529], 
       DiskBox[{-86.4251, 41.560900000000004}, 0.5]}, 
      {RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
       DiskBox[{14.333999999999998, 55.58}, 0.5]}, 
      {RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
       DiskBox[{14.333999999999998, 55.58}, 0.5]}, 
      {RGBColor[0.8124183190104166, 0.7081019934895834, 0.25454158463541665`],
        DiskBox[{16.81, 49.38}, 0.5]}, 
      {RGBColor[0.8124183190104166, 0.7081019934895834, 0.25454158463541665`],
        DiskBox[{16.81, 49.38}, 0.5]}, 
      {RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
       DiskBox[{-86.3253, 42.0945}, 0.5]}, 
      {RGBColor[0.901090625, 0.57745675, 0.21552000000000002`], 
       DiskBox[{-86.511, 42.036}, 0.5]}, 
      {RGBColor[0.901243875, 0.56671825, 0.213476], 
       DiskBox[{-86.5128, 42.0333}, 0.5]}, 
      {RGBColor[0.901243875, 0.56671825, 0.213476], 
       DiskBox[{-86.5128, 42.0333}, 0.5]}, 
      {RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
       DiskBox[{-86.359, 42.093}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.359, 42.093}, 0.5]}, 
      {RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
       DiskBox[{-86.625, 41.273}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.625, 41.273}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.625, 41.273}, 0.5]}, 
      {RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
       DiskBox[{-86.3253, 42.0945}, 0.5]}, 
      {RGBColor[0.9011289375, 0.574772125, 0.215009], 
       DiskBox[{-86.3253, 42.0945}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.7368, 41.3423}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.7368, 41.3423}, 0.5]}, 
      {RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
       DiskBox[{-86.7368, 41.3423}, 0.5]}, 
      {RGBColor[0.901243875, 0.56671825, 0.213476], 
       DiskBox[{-86.511, 42.036}, 0.5]}, 
      {RGBColor[0.901090625, 0.57745675, 0.21552000000000002`], 
       DiskBox[{-86.511, 42.036}, 0.5]}, 
      {RGBColor[0.9011480937499999, 0.5734298124999999, 0.2147535], 
       DiskBox[{2., 49.}, 0.5]}, 
      {RGBColor[0.5543171736111111, 0.7359087152777778, 0.4050509236111111], 
       DiskBox[{14.775, 56.0328}, 0.5]}, 
      {RGBColor[0.6441711250000001, 0.743295375, 0.33630512500000004`], 
       DiskBox[{17.9103, 62.7989}, 0.5]}, 
      {RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
       DiskBox[{16.5, 56.68}, 0.5]}, 
      {RGBColor[0.8232835833333333, 0.7001634166666666, 0.2507185833333333], 
       DiskBox[{16., 56.3}, 0.5]}, 
      {RGBColor[0.266122, 0.486664, 0.802529], 
       DiskBox[{-87.1923, 41.1876}, 0.5]}, 
      {RGBColor[0.5556259791666667, 0.7361003541666666, 0.4039107291666667], 
       DiskBox[{15.812700000000001, 56.4606}, 0.5]}, 
      {RGBColor[0.8121489322916666, 0.7082988177083334, 0.25463636979166665`],
        DiskBox[{17.1, 48.8}, 0.5]}, 
      {RGBColor[0.8118795455729166, 0.7084956419270834, 0.25473115494791665`],
        DiskBox[{15.76, 49.33}, 0.5]}, 
      {RGBColor[0.5507179583333334, 0.7353817083333334, 0.40818645833333334`],
        DiskBox[{13.1, 55.8}, 0.5]}, 
      {RGBColor[0.9014782222222222, 0.4450331111111111, 0.19026216666666665`],
        DiskBox[{0.4, 51.15}, 0.5]}, 
      {RGBColor[
       0.8959791111111111, 0.40930955555555554`, 0.18325483333333334`], 
       DiskBox[{7., 51.}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{13.196, 55.705000000000005}, 0.5]}, 
      {RGBColor[0.8232835833333333, 0.7001634166666666, 0.2507185833333333], 
       DiskBox[{13.821, 55.9473}, 0.5]}, 
      {RGBColor[0.5536627708333334, 0.7358128958333333, 0.40562102083333335`],
        DiskBox[{15.788400000000001, 56.1494}, 0.5]}, 
      {RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
       DiskBox[{11.2547, 43.7703}, 0.5]}, 
      {RGBColor[0.859088, 0.1446145, 0.13449075], 
       DiskBox[{2.3086, 48.6103}, 0.5]}, 
      {RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
       DiskBox[{-79.18, 35.}, 0.5]}, 
      {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
       DiskBox[{13.74, 56.07}, 0.5]}, 
      {RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
       DiskBox[{15.8, 57.699999999999996}, 0.5]}, 
      {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
       DiskBox[{12.9, 56.4}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{12.9, 56.4}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{12.9, 56.4}, 0.5]}, 
      {RGBColor[0.8720555, 0.24592825000000001`, 0.152211375], 
       DiskBox[{2.8, 41.6833}, 0.5]}, 
      {RGBColor[0.5556259791666667, 0.7361003541666666, 0.4039107291666667], 
       DiskBox[{14.12, 55.76}, 0.5]}, 
      {RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333], 
       DiskBox[{16.2815, 49.41120000000001}, 0.5]}, 
      {RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 
       DiskBox[{16.2815, 49.41120000000001}, 0.5]}, 
      {RGBColor[0.8089162916666666, 0.7106607083333333, 0.25577379166666664`],
        DiskBox[{8.5, 50.}, 0.5]}, 
      {RGBColor[0.8925421666666666, 0.3869823333333333, 0.17887524999999999`],
        DiskBox[{6.08, 46.5}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{13.74, 56.1}, 0.5]}, 
      {RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
       DiskBox[{13.74, 56.1}, 0.5]}, 
      {RGBColor[0.9025465, 0.475441, 0.196102], DiskBox[{11.5, 47.5}, 0.5]}, 
      {RGBColor[
       0.8959791111111111, 0.40930955555555554`, 0.18325483333333334`], 
       DiskBox[{7.499999999999999, 50.5}, 0.5]}, 
      {RGBColor[0.5530083680555555, 0.735717076388889, 0.4061911180555556], 
       DiskBox[{14.775, 56.0328}, 0.5]}, 
      {RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
       DiskBox[{13.2, 55.71}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.2, 55.71}, 0.5]}, 
      {RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
       DiskBox[{12.37, 44.}, 0.5]}, 
      {RGBColor[0.8980412777777778, 0.4227058888888889, 0.18588258333333332`],
        DiskBox[{1.5000000000000002, 47.5}, 0.5]}, 
      {RGBColor[0.6563445000000001, 0.7431544999999999, 0.32887750000000004`],
        DiskBox[{18.37, 60.25000000000001}, 0.5]}, 
      {RGBColor[0.7959857291666667, 0.7201082708333333, 0.26032347916666665`],
        DiskBox[{56.3167, 58.00000000000001}, 0.5]}, 
      {RGBColor[0.8737845, 0.25943675, 0.154574125], 
       DiskBox[{2.25, 41.5}, 0.5]}, 
      {RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333], 
       DiskBox[{16., 49.}, 0.5]}, 
      {RGBColor[0.8132264791666666, 0.7075115208333334, 0.25425722916666665`],
        DiskBox[{8.5, 50.5}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.4504, 55.6942}, 0.5]}, 
      {RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 
       DiskBox[{18., 62.68999999999999}, 0.5]}, 
      {RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 
       DiskBox[{11.2, 58.9}, 0.5]}, 
      {RGBColor[0.9014782222222222, 0.4450331111111111, 0.19026216666666665`],
        DiskBox[{18., 59.00000000000001}, 0.5]}, 
      {RGBColor[0.8132264791666666, 0.7075115208333334, 0.25425722916666665`],
        DiskBox[{25.3167, 54.6833}, 0.5]}, 
      {RGBColor[0.9014782222222222, 0.4450331111111111, 0.19026216666666665`],
        DiskBox[{8.5333, 50.066700000000004}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{14.290000000000001, 56.06}, 0.5]}, 
      {RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
       DiskBox[{77., 35.}, 0.5]}, 
      {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
       DiskBox[{13.97, 56.06}, 0.5]}, 
      {RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
       DiskBox[{13.9707, 56.0648}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.8513, 41.6862}, 0.5]}, 
      {RGBColor[0.36048, 0.655759, 0.645692], 
       DiskBox[{-86.8513, 41.6862}, 0.5]}, 
      {RGBColor[0.250728, 0.225386, 0.769152], 
       DiskBox[{-86.3253, 42.0945}, 0.5]}, 
      {RGBColor[0.250728, 0.225386, 0.769152], 
       DiskBox[{-86.3253, 42.0945}, 0.5]}, 
      {RGBColor[0.901243875, 0.56671825, 0.213476], 
       DiskBox[{-86.511, 42.036}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.9167, 56.1}, 0.5]}, 
      {RGBColor[0.57231325, 0.73854375, 0.38937325], 
       DiskBox[{16.6333, 57.74999999999999}, 0.5]}, 
      {RGBColor[0.9020484375, 0.510341125, 0.202745], 
       DiskBox[{48.7992, 38.6536}, 0.5]}, 
      {RGBColor[0.9019718125, 0.5157103749999999, 0.203767], 
       DiskBox[{48.7992, 38.6536}, 0.5]}, 
      {RGBColor[0.9019718125, 0.5157103749999999, 0.203767], 
       DiskBox[{48.7992, 38.6536}, 0.5]}, 
      {RGBColor[0.9019718125, 0.5157103749999999, 0.203767], 
       DiskBox[{48.6131, 38.7406}, 0.5]}, 
      {RGBColor[0.9019718125, 0.5157103749999999, 0.203767], 
       DiskBox[{48.6131, 38.7406}, 0.5]}, 
      {RGBColor[0.902010125, 0.51302575, 0.203256], 
       DiskBox[{48.5517, 38.7833}, 0.5]}, 
      {RGBColor[0.9019718125, 0.5157103749999999, 0.203767], 
       DiskBox[{48.5517, 38.7833}, 0.5]}, 
      {RGBColor[0.902010125, 0.51302575, 0.203256], 
       DiskBox[{48.5517, 38.7833}, 0.5]}, 
      {RGBColor[0.902010125, 0.51302575, 0.203256], 
       DiskBox[{48.5517, 38.7833}, 0.5]}, 
      {RGBColor[0.9019718125, 0.5157103749999999, 0.203767], 
       DiskBox[{48.925, 38.9522}, 0.5]}, 
      {RGBColor[0.9020484375, 0.510341125, 0.202745], 
       DiskBox[{48.925, 38.9522}, 0.5]}, 
      {RGBColor[0.9020484375, 0.510341125, 0.202745], 
       DiskBox[{48.5594, 38.97860000000001}, 0.5]}, 
      {RGBColor[0.9020484375, 0.510341125, 0.202745], 
       DiskBox[{48.5594, 38.97860000000001}, 0.5]}, 
      {RGBColor[0.9022016875, 0.49960262499999997`, 0.200701], 
       DiskBox[{46.2831, 41.8296}, 0.5]}, 
      {RGBColor[0.9022016875, 0.49960262499999997`, 0.200701], 
       DiskBox[{46.2831, 41.8296}, 0.5]}, 
      {RGBColor[0.9022016875, 0.49960262499999997`, 0.200701], 
       DiskBox[{46.2831, 41.8296}, 0.5]}, 
      {RGBColor[0.9022016875, 0.49960262499999997`, 0.200701], 
       DiskBox[{46.2831, 41.8296}, 0.5]}, 
      {RGBColor[0.9022016875, 0.49960262499999997`, 0.200701], 
       DiskBox[{46.2831, 41.8296}, 0.5]}, 
      {RGBColor[0.9022016875, 0.49960262499999997`, 0.200701], 
       DiskBox[{46.2831, 41.8296}, 0.5]}, 
      {RGBColor[0.9021250625, 0.504971875, 0.20172299999999999`], 
       DiskBox[{46.2831, 41.8296}, 0.5]}, 
      {RGBColor[0.9021250625, 0.504971875, 0.20172299999999999`], 
       DiskBox[{46.2831, 41.8296}, 0.5]}, 
      {RGBColor[0.9021250625, 0.504971875, 0.20172299999999999`], 
       DiskBox[{46.2831, 41.8296}, 0.5]}, 
      {RGBColor[0.9021250625, 0.504971875, 0.20172299999999999`], 
       DiskBox[{46.2831, 41.8296}, 0.5]}, 
      {RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
       DiskBox[{43.4767, 41.794200000000004}, 0.5]}, 
      {RGBColor[0.7078352187500001, 0.7419212187499999, 0.29796893750000003`],
        DiskBox[{44.8203, 40.1408}, 0.5]}, 
      {RGBColor[0.7078352187500001, 0.7419212187499999, 0.29796893750000003`],
        DiskBox[{45.3622, 39.8692}, 0.5]}, 
      {RGBColor[0.7078352187500001, 0.7419212187499999, 0.29796893750000003`],
        DiskBox[{45.3622, 39.8692}, 0.5]}, 
      {RGBColor[0.7078352187500001, 0.7419212187499999, 0.29796893750000003`],
        DiskBox[{45.3622, 39.8692}, 0.5]}, 
      {RGBColor[0.7078352187500001, 0.7419212187499999, 0.29796893750000003`],
        DiskBox[{45.3622, 39.8692}, 0.5]}, 
      {RGBColor[0.7078352187500001, 0.7419212187499999, 0.29796893750000003`],
        DiskBox[{45.3622, 39.8692}, 0.5]}, 
      {RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
       DiskBox[{-3.21833, 55.9681}, 0.5]}, 
      {RGBColor[0.8925421666666666, 0.3869823333333333, 0.17887524999999999`],
        DiskBox[{-5.1525, 57.9}, 0.5]}, 
      {RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
       DiskBox[{-3.96722, 57.967200000000005}, 0.5]}, 
      {RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
       DiskBox[{18.336, 62.86220000000001}, 0.5]}, 
      {RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
       DiskBox[{18.336, 62.86220000000001}, 0.5]}, 
      {RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
       DiskBox[{18.381, 62.86979999999999}, 0.5]}, 
      {RGBColor[0.57231325, 0.73854375, 0.38937325], 
       DiskBox[{18.4473, 62.879400000000004}, 0.5]}, 
      {RGBColor[0.5536627708333334, 0.7358128958333333, 0.40562102083333335`],
        DiskBox[{15.0689, 57.7133}, 0.5]}, 
      {RGBColor[0.57231325, 0.73854375, 0.38937325], 
       DiskBox[{18.1512, 57.3089}, 0.5]}, 
      {RGBColor[0.8017326458333333, 0.7159093541666667, 0.25830139583333334`],
        DiskBox[{16.3675, 57.2608}, 0.5]}, 
      {RGBColor[0.8017326458333333, 0.7159093541666667, 0.25830139583333334`],
        DiskBox[{16.3675, 57.2608}, 0.5]}, 
      {RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
       DiskBox[{18.4045, 62.9147}, 0.5]}, 
      {RGBColor[0.5536627708333334, 0.7358128958333333, 0.40562102083333335`],
        DiskBox[{14.998600000000001, 57.67810000000001}, 0.5]}, 
      {RGBColor[0.8017326458333333, 0.7159093541666667, 0.25830139583333334`],
        DiskBox[{14.998600000000001, 57.67810000000001}, 0.5]}, 
      {RGBColor[0.6198243750000001, 0.743577125, 0.351160375], 
       DiskBox[{18.3175, 63.016}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.3742, 55.7488}, 0.5]}, 
      {RGBColor[0.57231325, 0.73854375, 0.38937325], 
       DiskBox[{14.2091, 55.8106}, 0.5]}, 
      {RGBColor[0.57231325, 0.73854375, 0.38937325], 
       DiskBox[{14.2091, 55.8106}, 0.5]}, 
      {RGBColor[0.57231325, 0.73854375, 0.38937325], 
       DiskBox[{14.2091, 55.8106}, 0.5]}, 
      {RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
       DiskBox[{18.1896, 62.806}, 0.5]}, 
      {RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
       DiskBox[{18.1896, 62.806}, 0.5]}, 
      {RGBColor[0.8017326458333333, 0.7159093541666667, 0.25830139583333334`],
        DiskBox[{15.897900000000002, 57.32630000000001}, 0.5]}, 
      {RGBColor[0.8017326458333333, 0.7159093541666667, 0.25830139583333334`],
        DiskBox[{15.897900000000002, 57.32630000000001}, 0.5]}, 
      {RGBColor[0.8017326458333333, 0.7159093541666667, 0.25830139583333334`],
        DiskBox[{15.897900000000002, 57.32630000000001}, 0.5]}, 
      {RGBColor[0.57231325, 0.73854375, 0.38937325], 
       DiskBox[{16.4063, 56.5804}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{15.0105, 57.5089}, 0.5]}, 
      {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
       DiskBox[{13.9905, 55.4234}, 0.5]}, 
      {RGBColor[0.5536627708333334, 0.7358128958333333, 0.40562102083333335`],
        DiskBox[{14.8549, 57.8765}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{13.399, 55.749100000000006}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.399, 55.749100000000006}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.399, 55.749100000000006}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{13.9519, 56.047000000000004}, 0.5]}, 
      {RGBColor[0.5530083680555555, 0.735717076388889, 0.4061911180555556], 
       DiskBox[{14.302000000000001, 56.0573}, 0.5]}, 
      {RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
       DiskBox[{16.1494, 57.2746}, 0.5]}, 
      {RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
       DiskBox[{16.1494, 57.2746}, 0.5]}, 
      {RGBColor[0.57231325, 0.73854375, 0.38937325], 
       DiskBox[{18.3837, 57.7215}, 0.5]}, 
      {RGBColor[0.5530083680555555, 0.735717076388889, 0.4061911180555556], 
       DiskBox[{14.399699999999998, 55.9745}, 0.5]}, 
      {RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
       DiskBox[{18.4055, 62.88150000000001}, 0.5]}, 
      {RGBColor[0.6462000208333334, 0.7432718958333333, 0.33506718750000003`],
        DiskBox[{18.2763, 62.9513}, 0.5]}, 
      {RGBColor[0.5530083680555555, 0.735717076388889, 0.4061911180555556], 
       DiskBox[{14.6806, 56.1633}, 0.5]}, 
      {RGBColor[0.5530083680555555, 0.735717076388889, 0.4061911180555556], 
       DiskBox[{14.6806, 56.1633}, 0.5]}, 
      {RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
       DiskBox[{14.3398, 55.5678}, 0.5]}, 
      {RGBColor[0.5585707916666667, 0.7365315416666667, 0.40134529166666666`],
        DiskBox[{18.2109, 57.2545}, 0.5]}, 
      {RGBColor[0.5585707916666667, 0.7365315416666667, 0.40134529166666666`],
        DiskBox[{18.2109, 57.2545}, 0.5]}, 
      {RGBColor[0.5585707916666667, 0.7365315416666667, 0.40134529166666666`],
        DiskBox[{18.2109, 57.2545}, 0.5]}, 
      {RGBColor[0.5585707916666667, 0.7365315416666667, 0.40134529166666666`],
        DiskBox[{18.5162, 57.8009}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{18.5162, 57.8009}, 0.5]}, 
      {RGBColor[0.5585707916666667, 0.7365315416666667, 0.40134529166666666`],
        DiskBox[{18.5162, 57.8009}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{14.804300000000001, 57.6511}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{13.9707, 56.0648}, 0.5]}, 
      {RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
       DiskBox[{14.3336, 55.5796}, 0.5]}, 
      {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
       DiskBox[{13.8484, 55.4242}, 0.5]}, 
      {RGBColor[0.9011480937499999, 0.5734298124999999, 0.2147535], 
       DiskBox[{-3.21072, 55.8877}, 0.5]}, 
      {RGBColor[0.8582235, 0.13786025, 0.133309375], 
       DiskBox[{-7.47, 40.11}, 0.5]}, 
      {RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
       DiskBox[{-7.499999999999999, 38.45000000000001}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-7.11, 40.040000000000006}, 0.5]}, 
      {RGBColor[0.863194375, 0.17669718750000002`, 0.14010228125000002`], 
       DiskBox[{-7.400000000000001, 39.29}, 0.5]}, 
      {RGBColor[0.8627621249999999, 0.17332006249999998`, 0.13951159375], 
       DiskBox[{-7.59, 38.75}, 0.5]}, 
      {RGBColor[0.863194375, 0.17669718750000002`, 0.14010228125000002`], 
       DiskBox[{-8.020000000000001, 38.53}, 0.5]}, 
      {RGBColor[0.8627621249999999, 0.17332006249999998`, 0.13951159375], 
       DiskBox[{-7.840000000000001, 38.22}, 0.5]}, 
      {RGBColor[0.86384275, 0.181762875, 0.1409883125], 
       DiskBox[{-4.07, 38.77}, 0.5]}, 
      {RGBColor[0.8627621249999999, 0.17332006249999998`, 0.13951159375], 
       DiskBox[{-4.54, 39.15}, 0.5]}, 
      {RGBColor[0.863194375, 0.17669718750000002`, 0.14010228125000002`], 
       DiskBox[{-6.89, 39.72}, 0.5]}, 
      {RGBColor[0.8599525, 0.15136875, 0.135672125], 
       DiskBox[{-7.8, 42.19}, 0.5]}, 
      {RGBColor[0.8772424999999999, 0.28645375, 0.159299625], 
       DiskBox[{-0.36, 39.88}, 0.5]}, 
      {RGBColor[0.8737845, 0.25943675, 0.154574125], 
       DiskBox[{2.64, 41.94}, 0.5]}, 
      {RGBColor[
       0.8587998333333333, 0.14236308333333333`, 0.13409695833333332`], 
       DiskBox[{-3.68, 41.7}, 0.5]}, 
      {RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
       DiskBox[{2.13, 41.43}, 0.5]}, 
      {RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
       DiskBox[{-5.27, 36.52}, 0.5]}, 
      {RGBColor[0.86384275, 0.181762875, 0.1409883125], 
       DiskBox[{-2.66, 38.37}, 0.5]}, 
      {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
       DiskBox[{-0.56, 42.52}, 0.5]}, 
      {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
       DiskBox[{0.54, 42.49}, 0.5]}, 
      {RGBColor[0.8737845, 0.25943675, 0.154574125], 
       DiskBox[{2.39, 41.54}, 0.5]}, 
      {RGBColor[
       0.8576471666666666, 0.13335741666666667`, 0.13252179166666667`], 
       DiskBox[{-5.74, 40.37}, 0.5]}, 
      {RGBColor[0.8772424999999999, 0.28645375, 0.159299625], 
       DiskBox[{-1.37, 40.94}, 0.5]}, 
      {RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
       DiskBox[{-3.3600000000000003, 36.97}, 0.5]}, 
      {RGBColor[0.86297825, 0.17500862500000003`, 0.1398069375], 
       DiskBox[{-4.32, 38.25}, 0.5]}, 
      {RGBColor[0.861465375, 0.1631886875, 0.13773953125], 
       DiskBox[{-4.54, 41.21}, 0.5]}, 
      {RGBColor[0.86124925, 0.161500125, 0.1374441875], 
       DiskBox[{-4.64, 42.23}, 0.5]}, 
      {RGBColor[0.77217125, 0.72651625, 0.2704135], 
       DiskBox[{-4.32, 41.15}, 0.5]}, 
      {RGBColor[
       0.8608890416666667, 0.15868585416666667`, 0.13695194791666665`], 
       DiskBox[{-4.65, 40.05}, 0.5]}, 
      {RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
       DiskBox[{3.19, 42.31}, 0.5]}, 
      {RGBColor[0.8772424999999999, 0.28645375, 0.159299625], 
       DiskBox[{-2., 40.83}, 0.5]}, 
      {RGBColor[0.863194375, 0.17669718750000002`, 0.14010228125000002`], 
       DiskBox[{-6.66, 38.07}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-6.67, 40.29}, 0.5]}, 
      {RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
       DiskBox[{2.34, 41.81}, 0.5]}, 
      {RGBColor[0.863194375, 0.17669718750000002`, 0.14010228125000002`], 
       DiskBox[{-5.42, 38.26}, 0.5]}, 
      {RGBColor[0.77217125, 0.72651625, 0.2704135], 
       DiskBox[{-4.05, 40.79}, 0.5]}, 
      {RGBColor[0.77217125, 0.72651625, 0.2704135], 
       DiskBox[{-5.39, 36.77}, 0.5]}, 
      {RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
       DiskBox[{-5.33, 39.4}, 0.5]}, 
      {RGBColor[0.77217125, 0.72651625, 0.2704135], 
       DiskBox[{-5.78, 39.4}, 0.5]}, 
      {RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
       DiskBox[{-1.6800000000000002, 40.82}, 0.5]}, 
      {RGBColor[0.8720555, 0.24592825000000001`, 0.152211375], 
       DiskBox[{2.62, 41.67}, 0.5]}, 
      {RGBColor[0.86124925, 0.161500125, 0.1374441875], 
       DiskBox[{-5., 40.4}, 0.5]}, 
      {RGBColor[0.6563445000000001, 0.7431544999999999, 0.32887750000000004`],
        DiskBox[{-3.6900000000000004, 42.23}, 0.5]}, 
      {RGBColor[0.6563445000000001, 0.7431544999999999, 0.32887750000000004`],
        DiskBox[{-5.37, 43.05}, 0.5]}, 
      {RGBColor[0.8582235, 0.13786025, 0.133309375], 
       DiskBox[{-5.92, 42.28}, 0.5]}, 
      {RGBColor[0.861465375, 0.1631886875, 0.13773953125], 
       DiskBox[{-4.5, 40.87}, 0.5]}, 
      {RGBColor[0.861465375, 0.1631886875, 0.13773953125], 
       DiskBox[{-4.710000000000001, 41.58}, 0.5]}, 
      {RGBColor[0.77217125, 0.72651625, 0.2704135], 
       DiskBox[{-3.16, 38.86}, 0.5]}, 
      {RGBColor[0.77217125, 0.72651625, 0.2704135], 
       DiskBox[{-3.9300000000000006, 39.58}, 0.5]}, 
      {RGBColor[
       0.8608890416666667, 0.15868585416666667`, 0.13695194791666665`], 
       DiskBox[{-4.34, 39.66}, 0.5]}, 
      {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
       DiskBox[{0.7, 42.46}, 0.5]}, 
      {RGBColor[
       0.8587998333333333, 0.14236308333333333`, 0.13409695833333332`], 
       DiskBox[{-5.64, 41.57}, 0.5]}, 
      {RGBColor[0.86384275, 0.181762875, 0.1409883125], 
       DiskBox[{-4.38, 38.06}, 0.5]}, 
      {RGBColor[0.863194375, 0.17669718750000002`, 0.14010228125000002`], 
       DiskBox[{-6.240000000000001, 38.19}, 0.5]}, 
      {RGBColor[
       0.8576471666666666, 0.13335741666666667`, 0.13252179166666667`], 
       DiskBox[{-5.04, 40.71}, 0.5]}, 
      {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
       DiskBox[{2., 41.67}, 0.5]}, 
      {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
       DiskBox[{-1.6, 40.45}, 0.5]}, 
      {RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
       DiskBox[{-1.23, 42.97}, 0.5]}, 
      {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
       DiskBox[{1.3, 42.34}, 0.5]}, 
      {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
       DiskBox[{-0.23, 42.76}, 0.5]}, 
      {RGBColor[0.8599525, 0.15136875, 0.135672125], 
       DiskBox[{-6.45, 42.87}, 0.5]}, 
      {RGBColor[0.8634105, 0.17838575, 0.140397625], 
       DiskBox[{-6.01, 43.28000000000001}, 0.5]}, 
      {RGBColor[0.8737845, 0.25943675, 0.154574125], 
       DiskBox[{2.99, 41.86}, 0.5]}, 
      {RGBColor[0.86384275, 0.181762875, 0.1409883125], 
       DiskBox[{-2.7, 38.6}, 0.5]}, 
      {RGBColor[
       0.8587998333333333, 0.14236308333333333`, 0.13409695833333332`], 
       DiskBox[{-4.11, 40.86}, 0.5]}, 
      {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
       DiskBox[{2.17, 42.34}, 0.5]}, 
      {RGBColor[0.8582235, 0.13786025, 0.133309375], 
       DiskBox[{-6.7, 42.13}, 0.5]}, 
      {RGBColor[0.86384275, 0.181762875, 0.1409883125], 
       DiskBox[{-3.51, 38.33}, 0.5]}, 
      {RGBColor[0.8582235, 0.13786025, 0.133309375], 
       DiskBox[{-5.12, 42.84}, 0.5]}, 
      {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
       DiskBox[{-1.63, 41.48}, 0.5]}, 
      {RGBColor[0.77217125, 0.72651625, 0.2704135], 
       DiskBox[{-3.38, 37.09}, 0.5]}, 
      {RGBColor[0.86211375, 0.168254375, 0.1386255625], 
       DiskBox[{-3.58, 41.190000000000005}, 0.5]}, 
      {RGBColor[0.8599525, 0.15136875, 0.135672125], 
       DiskBox[{-7.39, 43.4}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-3.27, 41.03000000000001}, 0.5]}, 
      {RGBColor[0.86124925, 0.161500125, 0.1374441875], 
       DiskBox[{-1.88, 41.5}, 0.5]}, 
      {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
       DiskBox[{0.6, 42.11}, 0.5]}, 
      {RGBColor[
       0.8587998333333333, 0.14236308333333333`, 0.13409695833333332`], 
       DiskBox[{-2.83, 41.6}, 0.5]}, 
      {RGBColor[0.8599525, 0.15136875, 0.135672125], 
       DiskBox[{-5.49, 43.37}, 0.5]}, 
      {RGBColor[0.859088, 0.1446145, 0.13449075], 
       DiskBox[{-3.5900000000000003, 42.86}, 0.5]}, 
      {RGBColor[0.86211375, 0.168254375, 0.1386255625], 
       DiskBox[{-5.44, 42.1}, 0.5]}, 
      {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
       DiskBox[{-2.99, 42.26}, 0.5]}, 
      {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
       DiskBox[{1.01, 42.04}, 0.5]}, 
      {RGBColor[
       0.8576471666666666, 0.13335741666666667`, 0.13252179166666667`], 
       DiskBox[{-5.5, 40.89}, 0.5]}, 
      {RGBColor[0.8582235, 0.13786025, 0.133309375], 
       DiskBox[{-7.450000000000001, 41.95}, 0.5]}, 
      {RGBColor[0.86211375, 0.168254375, 0.1386255625], 
       DiskBox[{-2.53, 42.31}, 0.5]}, 
      {RGBColor[0.77217125, 0.72651625, 0.2704135], 
       DiskBox[{-6.51, 41.88}, 0.5]}, 
      {RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
       DiskBox[{-5.77, 42.8}, 0.5]}, 
      {RGBColor[0.77217125, 0.72651625, 0.2704135], 
       DiskBox[{-6.04, 39.85}, 0.5]}, 
      {RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
       DiskBox[{-1.88, 41.85}, 0.5]}, 
      {RGBColor[
       0.8611772083333333, 0.16093727083333334`, 0.13734573958333332`], 
       DiskBox[{-3.96, 40.5}, 0.5]}, 
      {RGBColor[0.738604625, 0.734553625, 0.28479025], 
       DiskBox[{-7.450000000000001, 31.48}, 0.5]}, 
      {RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
       DiskBox[{52.15, 53.05}, 0.5]}, 
      {RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
       DiskBox[{59.440000000000005, 51.37}, 0.5]}, 
      {RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
       DiskBox[{59.98, 51.41}, 0.5]}, 
      {RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
       DiskBox[{51.96, 53.04}, 0.5]}, 
      {RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
       DiskBox[{51.9, 53.04}, 0.5]}, 
      {RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
       DiskBox[{51.94, 53.04}, 0.5]}, 
      {RGBColor[0.9025465, 0.475441, 0.196102], DiskBox[{61.41, 55.36}, 0.5]}, 
      {RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
       DiskBox[{52.16, 52.99}, 0.5]}, 
      {RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
       DiskBox[{51.96, 53.06}, 0.5]}, 
      {RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
       DiskBox[{59.440000000000005, 51.37}, 0.5]}, 
      {RGBColor[0.7108072636718751, 0.741209576171875, 0.29669599609375], 
       DiskBox[{79.48, 51.84}, 0.5]}, 
      {RGBColor[0.7108072636718751, 0.741209576171875, 0.29669599609375], 
       DiskBox[{79.48, 51.82}, 0.5]}, 
      {RGBColor[0.7108072636718751, 0.741209576171875, 0.29669599609375], 
       DiskBox[{79.46, 51.84}, 0.5]}, 
      {RGBColor[0.7959857291666667, 0.7201082708333333, 0.26032347916666665`],
        DiskBox[{85.27, 52.52}, 0.5]}, 
      {RGBColor[0.71098208984375, 0.74116771484375, 0.2966211171875], 
       DiskBox[{79.37000000000002, 53.6}, 0.5]}, 
      {RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
       DiskBox[{82.59, 51.31}, 0.5]}, 
      {RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
       DiskBox[{82.59, 51.36}, 0.5]}, 
      {RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
       DiskBox[{82.55, 51.32}, 0.5]}, 
      {RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
       DiskBox[{82.54, 51.33}, 0.5]}, 
      {RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
       DiskBox[{82.18, 51.35}, 0.5]}, 
      {RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
       DiskBox[{82.16000000000001, 51.34}, 0.5]}, 
      {RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`], 
       DiskBox[{80.79, 51.65}, 0.5]}, 
      {RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`], 
       DiskBox[{80.82, 51.67}, 0.5]}, 
      {RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`], 
       DiskBox[{80.83, 51.63}, 0.5]}, 
      {RGBColor[0.7108072636718751, 0.741209576171875, 0.29669599609375], 
       DiskBox[{81.31, 54.13}, 0.5]}, 
      {RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`], 
       DiskBox[{80.6, 51.87}, 0.5]}, 
      {RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`], 
       DiskBox[{80.82, 51.75}, 0.5]}, 
      {RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`], 
       DiskBox[{80.85, 51.77}, 0.5]}, 
      {RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`], 
       DiskBox[{80.86, 51.73}, 0.5]}, 
      {RGBColor[0.71098208984375, 0.74116771484375, 0.2966211171875], 
       DiskBox[{80.31, 53.82}, 0.5]}, 
      {RGBColor[0.7108072636718751, 0.741209576171875, 0.29669599609375], 
       DiskBox[{80.06, 51.87}, 0.5]}, 
      {RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`], 
       DiskBox[{80.06, 51.9}, 0.5]}, 
      {RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`], 
       DiskBox[{80.06, 51.84}, 0.5]}, 
      {RGBColor[0.7108072636718751, 0.741209576171875, 0.29669599609375], 
       DiskBox[{79.31, 52.1}, 0.5]}, 
      {RGBColor[0.8132264791666666, 0.7075115208333334, 0.25425722916666665`],
        DiskBox[{18.72, 45.07}, 0.5]}, 
      {RGBColor[0.8132264791666666, 0.7075115208333334, 0.25425722916666665`],
        DiskBox[{18.7, 45.17}, 0.5]}, 
      {RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
       DiskBox[{16.170188, 39.12689900000001}, 0.5]}, 
      {RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
       DiskBox[{16.77, 40.37}, 0.5]}, 
      {RGBColor[0.90168446875, 0.5358450625, 0.2075995], 
       DiskBox[{16.28, 39.48}, 0.5]}, 
      {RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
       DiskBox[{16.17, 39.13}, 0.5]}, 
      {RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
       DiskBox[{14.870000000000001, 40.68}, 0.5]}, 
      {RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
       DiskBox[{16.13, 38.44}, 0.5]}, 
      {RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
       DiskBox[{16.47, 38.92}, 0.5]}, 
      {RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
       DiskBox[{17.31, 40.64}, 0.5]}, 
      {RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
       DiskBox[{16.040000000000003, 38.45000000000001}, 0.5]}, 
      {RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
       DiskBox[{16.34, 38.97}, 0.5]}, 
      {RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
       DiskBox[{14.18, 41.18}, 0.5]}, 
      {RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
       DiskBox[{14.57, 40.84}, 0.5]}, 
      {RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
       DiskBox[{16.21, 39.58}, 0.5]}, 
      {RGBColor[0.9017419375, 0.5318181249999999, 0.20683300000000002`], 
       DiskBox[{14.09, 41.33}, 0.5]}, 
      {RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 
       DiskBox[{11.2832, 46.366}, 0.5]}, 
      {RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 
       DiskBox[{11.2832, 46.366}, 0.5]}, 
      {RGBColor[0.81178975, 0.70856125, 0.25476275], 
       DiskBox[{11.2832, 46.366}, 0.5]}, 
      {RGBColor[0.858124265625, 0.674707484375, 0.238459703125], 
       DiskBox[{11.2832, 46.366}, 0.5]}, 
      {RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 
       DiskBox[{11.283700000000001, 46.3668}, 0.5]}, 
      {RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 
       DiskBox[{11.283700000000001, 46.3668}, 0.5]}, 
      {RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 
       DiskBox[{11.283700000000001, 46.3668}, 0.5]}, 
      {RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 
       DiskBox[{11.283700000000001, 46.3668}, 0.5]}, 
      {RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 
       DiskBox[{11.283700000000001, 46.3668}, 0.5]}, 
      {RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 
       DiskBox[{11.283700000000001, 46.3668}, 0.5]}, 
      {RGBColor[0.858124265625, 0.674707484375, 0.238459703125], 
       DiskBox[{11.2866, 46.3718}, 0.5]}, 
      {RGBColor[0.858124265625, 0.674707484375, 0.238459703125], 
       DiskBox[{11.2866, 46.3718}, 0.5]}, 
      {RGBColor[0.858124265625, 0.674707484375, 0.238459703125], 
       DiskBox[{11.2866, 46.3718}, 0.5]}, 
      {RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
       DiskBox[{11.2928, 46.3378}, 0.5]}, 
      {RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
       DiskBox[{11.2928, 46.3378}, 0.5]}, 
      {RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
       DiskBox[{11.2928, 46.3378}, 0.5]}, 
      {RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
       DiskBox[{11.2928, 46.3378}, 0.5]}, 
      {RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
       DiskBox[{11.2928, 46.3378}, 0.5]}, 
      {RGBColor[0.8613569062499999, 0.67234559375, 0.23732228125], 
       DiskBox[{11.2928, 46.3378}, 0.5]}, 
      {RGBColor[0.8613569062499999, 0.67234559375, 0.23732228125], 
       DiskBox[{11.2928, 46.3378}, 0.5]}, 
      {RGBColor[0.8570467187499999, 0.67549478125, 0.23883884375], 
       DiskBox[{11.2928, 46.3378}, 0.5]}, 
      {RGBColor[0.8613569062499999, 0.67234559375, 0.23732228125], 
       DiskBox[{11.2928, 46.3378}, 0.5]}, 
      {RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
       DiskBox[{11.2928, 46.3378}, 0.5]}, 
      {RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
       DiskBox[{11.2928, 46.3378}, 0.5]}, 
      {RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333], 
       DiskBox[{11.2928, 46.3378}, 0.5]}, 
      {RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
       DiskBox[{11.2928, 46.3378}, 0.5]}, 
      {RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
       DiskBox[{11.2928, 46.3378}, 0.5]}, 
      {RGBColor[0.8376508749999999, 0.689666125, 0.245663375], 
       DiskBox[{11.2928, 46.3378}, 0.5]}, 
      {RGBColor[0.8376508749999999, 0.689666125, 0.245663375], 
       DiskBox[{11.2928, 46.3378}, 0.5]}, 
      {RGBColor[0.8376508749999999, 0.689666125, 0.245663375], 
       DiskBox[{11.2928, 46.3378}, 0.5]}, 
      {RGBColor[0.90239325, 0.4861795, 0.198146], 
       DiskBox[{23.94, 41.62}, 0.5]}, 
      {RGBColor[0.90239325, 0.4861795, 0.198146], 
       DiskBox[{23.85, 41.57}, 0.5]}, 
      {RGBColor[0.90239325, 0.4861795, 0.198146], 
       DiskBox[{23.14, 41.37}, 0.5]}, 
      {RGBColor[0.9025465, 0.475441, 0.196102], DiskBox[{23.1, 42.32}, 0.5]}, 
      {RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333], 
       DiskBox[{25.91, 43.7}, 0.5]}, 
      {RGBColor[0.9025465, 0.475441, 0.196102], DiskBox[{23.39, 41.53}, 0.5]}, 
      {RGBColor[0.90269975, 0.46470249999999996`, 0.194058], 
       DiskBox[{23.39, 41.53}, 0.5]}, 
      {RGBColor[0.90269975, 0.46470249999999996`, 0.194058], 
       DiskBox[{23.33, 41.5}, 0.5]}, 
      {RGBColor[0.90239325, 0.4861795, 0.198146], 
       DiskBox[{24.18, 41.64}, 0.5]}, 
      {RGBColor[0.9025465, 0.475441, 0.196102], DiskBox[{24.84, 41.57}, 0.5]}, 
      {RGBColor[0.90208675, 0.5076565, 0.202234], 
       DiskBox[{25.35, 41.62}, 0.5]}, 
      {RGBColor[0.9025465, 0.475441, 0.196102], DiskBox[{23.13, 41.85}, 0.5]}, 
      {RGBColor[0.90269975, 0.46470249999999996`, 0.194058], 
       DiskBox[{23.13, 41.85}, 0.5]}, 
      {RGBColor[0.9025465, 0.475441, 0.196102], DiskBox[{23.1, 42.32}, 0.5]}, 
      {RGBColor[0.9025465, 0.475441, 0.196102], DiskBox[{23.1, 42.32}, 0.5]}, 
      {RGBColor[0.90269975, 0.46470249999999996`, 0.194058], 
       DiskBox[{25.61, 42.49}, 0.5]}, 
      {RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
       DiskBox[{25.75, 41.84}, 0.5]}, 
      {RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
       DiskBox[{24.98, 41.54}, 0.5]}, 
      {RGBColor[0.90208675, 0.5076565, 0.202234], 
       DiskBox[{25.47, 41.66}, 0.5]}, 
      {RGBColor[0.90239325, 0.4861795, 0.198146], 
       DiskBox[{24.75, 41.55}, 0.5]}, 
      {RGBColor[0.90208675, 0.5076565, 0.202234], 
       DiskBox[{25.69, 41.83}, 0.5]}, 
      {RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
       DiskBox[{25.68, 41.77}, 0.5]}, 
      {RGBColor[0.9025465, 0.475441, 0.196102], DiskBox[{25.33, 42.72}, 0.5]}, 
      {RGBColor[0.9025465, 0.475441, 0.196102], 
       DiskBox[{24.410000000000004, 41.71}, 0.5]}, 
      {RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333], 
       DiskBox[{23.67, 41.42}, 0.5]}, 
      {RGBColor[0.90208675, 0.5076565, 0.202234], 
       DiskBox[{23.08, 37.6}, 0.5]}, 
      {RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
       DiskBox[{22.04, 37.07}, 0.5]}, 
      {RGBColor[0.858124265625, 0.674707484375, 0.238459703125], 
       DiskBox[{21.62, 37.63}, 0.5]}, 
      {RGBColor[0.81394484375, 0.70698665625, 0.25400446875], 
       DiskBox[{18.9, 48.46}, 0.5]}, 
      {RGBColor[0.81394484375, 0.70698665625, 0.25400446875], 
       DiskBox[{18.9, 48.46}, 0.5]}, 
      {RGBColor[0.81394484375, 0.70698665625, 0.25400446875], 
       DiskBox[{18.94, 48.47}, 0.5]}, 
      {RGBColor[0.81394484375, 0.70698665625, 0.25400446875], 
       DiskBox[{18.9, 48.46}, 0.5]}, 
      {RGBColor[0.81394484375, 0.70698665625, 0.25400446875], 
       DiskBox[{18.96, 48.47}, 0.5]}, 
      {RGBColor[0.81394484375, 0.70698665625, 0.25400446875], 
       DiskBox[{18.94, 48.47}, 0.5]}, 
      {RGBColor[0.81394484375, 0.70698665625, 0.25400446875], 
       DiskBox[{18.94, 48.47}, 0.5]}, 
      {RGBColor[0.7988591875, 0.7180088124999999, 0.2593124375], 
       DiskBox[{25.17, 44.69}, 0.5]}, 
      {RGBColor[0.71098208984375, 0.74116771484375, 0.2966211171875], 
       DiskBox[{22.62, 45.95}, 0.5]}, 
      {RGBColor[0.9025465, 0.475441, 0.196102], DiskBox[{25.42, 45.57}, 0.5]}, 
      {RGBColor[0.8160999375, 0.7054120625, 0.2532461875], 
       DiskBox[{22.33, 46.01}, 0.5]}, 
      {RGBColor[0.8160999375, 0.7054120625, 0.2532461875], 
       DiskBox[{23.16, 45.84}, 0.5]}, 
      {RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333], 
       DiskBox[{25., 45.14}, 0.5]}, 
      {RGBColor[0.7988591875, 0.7180088124999999, 0.2593124375], 
       DiskBox[{27.59, 47.16}, 0.5]}, 
      {RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
       DiskBox[{70.05, 41.45}, 0.5]}, 
      {RGBColor[0.8160999375, 0.7054120625, 0.2532461875], 
       DiskBox[{21.22, 44.38}, 0.5]}, 
      {RGBColor[0.9025465, 0.475441, 0.196102], DiskBox[{21.71, 44.23}, 0.5]}, 
      {RGBColor[0.9025465, 0.475441, 0.196102], DiskBox[{22.29, 43.54}, 0.5]}, 
      {RGBColor[0.8160999375, 0.7054120625, 0.2532461875], 
       DiskBox[{21.37, 44.66}, 0.5]}, 
      {RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333], 
       DiskBox[{22.56, 44.56}, 0.5]}, 
      {RGBColor[0.8160999375, 0.7054120625, 0.2532461875], 
       DiskBox[{21.08, 44.3}, 0.5]}, 
      {RGBColor[0.9025465, 0.475441, 0.196102], DiskBox[{21.08, 44.3}, 0.5]}, 
      {RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
       DiskBox[{88.4, 47.75}, 0.5]}, 
      {RGBColor[0.9020484375, 0.510341125, 0.202745], 
       DiskBox[{49.47, 37.47}, 0.5]}, 
      {RGBColor[0.8132264791666666, 0.7075115208333334, 0.25425722916666665`],
        DiskBox[{35.7, 33.92}, 0.5]}, 
      {RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
       DiskBox[{14.98, 37.69}, 0.5]}, 
      {RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
       DiskBox[{35.84, 34.1}, 0.5]}, 
      {RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
       DiskBox[{74.16, 42.26}, 0.5]}, 
      {RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
       DiskBox[{9.16, 48.57}, 0.5]}, 
      {RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
       DiskBox[{8.99, 48.55}, 0.5]}, 
      {RGBColor[0.8874511927083333, 0.35391013541666666`, 0.1723879921875], 
       DiskBox[{9.01, 48.53}, 0.5]}, 
      {RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
       DiskBox[{9.11, 48.56}, 0.5]}, 
      {RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
       DiskBox[{8.85, 48.41}, 0.5]}, 
      {RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
       DiskBox[{9.22, 48.59}, 0.5]}, 
      {RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
       DiskBox[{8.79, 48.41}, 0.5]}, 
      {RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
       DiskBox[{8.79, 48.43}, 0.5]}, 
      {RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
       DiskBox[{9.17, 48.57}, 0.5]}, 
      {RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
       DiskBox[{8.84, 48.41}, 0.5]}, 
      {RGBColor[0.8877411848958333, 0.3557939947916667, 0.17275751953125001`],
        DiskBox[{8.78, 48.5}, 0.5]}, 
      {RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
       DiskBox[{8.79, 48.43}, 0.5]}, 
      {RGBColor[0.8876767421875, 0.355375359375, 0.17267540234375], 
       DiskBox[{9.11, 48.52}, 0.5]}, 
      {RGBColor[0.8877411848958333, 0.3557939947916667, 0.17275751953125001`],
        DiskBox[{9.09, 48.53}, 0.5]}, 
      {RGBColor[0.5369755, 0.7333695, 0.4201585], 
       DiskBox[{9.050000000000002, 48.52}, 0.5]}, 
      {RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
       DiskBox[{8.8, 48.5}, 0.5]}, 
      {RGBColor[0.8874511927083333, 0.35391013541666666`, 0.1723879921875], 
       DiskBox[{9.02, 48.54}, 0.5]}, 
      {RGBColor[0.8874511927083333, 0.35391013541666666`, 0.1723879921875], 
       DiskBox[{9.01, 48.54}, 0.5]}, 
      {RGBColor[0.8874511927083333, 0.35391013541666666`, 0.1723879921875], 
       DiskBox[{9., 48.5}, 0.5]}, 
      {RGBColor[0.8874511927083333, 0.35391013541666666`, 0.1723879921875], 
       DiskBox[{9.01, 48.53}, 0.5]}, 
      {RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
       DiskBox[{8.96, 48.39}, 0.5]}, 
      {RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
       DiskBox[{9.18, 48.58}, 0.5]}, 
      {RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
       DiskBox[{9.200000000000001, 48.6}, 0.5]}, 
      {RGBColor[0.8877411848958333, 0.3557939947916667, 0.17275751953125001`],
        DiskBox[{9.09, 48.54}, 0.5]}, 
      {RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
       DiskBox[{9.16, 48.57}, 0.5]}, 
      {RGBColor[0.8876767421875, 0.355375359375, 0.17267540234375], 
       DiskBox[{9.08, 48.52}, 0.5]}, 
      {RGBColor[0.8876767421875, 0.355375359375, 0.17267540234375], 
       DiskBox[{9.11, 48.5}, 0.5]}, 
      {RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
       DiskBox[{8.84, 48.41}, 0.5]}, 
      {RGBColor[0.8874511927083333, 0.35391013541666666`, 0.1723879921875], 
       DiskBox[{9.02, 48.54}, 0.5]}, 
      {RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
       DiskBox[{9.01, 48.54}, 0.5]}, 
      {RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
       DiskBox[{8.85, 48.39}, 0.5]}, 
      {RGBColor[0.8874511927083333, 0.35391013541666666`, 0.1723879921875], 
       DiskBox[{9.01, 48.54}, 0.5]}, 
      {RGBColor[0.8876767421875, 0.355375359375, 0.17267540234375], 
       DiskBox[{9.01, 48.54}, 0.5]}, 
      {RGBColor[0.8876767421875, 0.355375359375, 0.17267540234375], 
       DiskBox[{9.11, 48.51}, 0.5]}, 
      {RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
       DiskBox[{8.76, 48.42}, 0.5]}, 
      {RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
       DiskBox[{8.87, 48.45}, 0.5]}, 
      {RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
       DiskBox[{9.09, 48.54}, 0.5]}, 
      {RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
       DiskBox[{9.16, 48.56}, 0.5]}, 
      {RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
       DiskBox[{9.22, 48.6}, 0.5]}, 
      {RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
       DiskBox[{9.08, 48.52}, 0.5]}, 
      {RGBColor[0.9010523125, 0.580141375, 0.216031], 
       DiskBox[{9.050000000000002, 48.52}, 0.5]}, 
      {RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
       DiskBox[{9.07, 48.53}, 0.5]}, 
      {RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
       DiskBox[{9.050000000000002, 48.52}, 0.5]}, 
      {RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
       DiskBox[{9.03, 48.52}, 0.5]}, 
      {RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
       DiskBox[{8.77, 48.4}, 0.5]}, 
      {RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
       DiskBox[{8.79, 48.42}, 0.5]}, 
      {RGBColor[0.8874511927083333, 0.35391013541666666`, 0.1723879921875], 
       DiskBox[{9.02, 48.54}, 0.5]}, 
      {RGBColor[0.8876767421875, 0.355375359375, 0.17267540234375], 
       DiskBox[{9.06, 48.55}, 0.5]}, 
      {RGBColor[0.86297825, 0.17500862500000003`, 0.1398069375], 
       DiskBox[{-6.6, 39.84}, 0.5]}, 
      {RGBColor[0.8822313333333334, 0.3200006666666667, 0.1657365], 
       DiskBox[{-3.03, 42.35}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-4.710000000000001, 41.}, 0.5]}, 
      {RGBColor[0.8720555, 0.24592825000000001`, 0.152211375], 
       DiskBox[{2.49, 41.81}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-4.02, 40.52}, 0.5]}, 
      {RGBColor[0.867733, 0.212157, 0.1463045], DiskBox[{-5.84, 43.34}, 0.5]}, 
      {RGBColor[0.8599525, 0.15136875, 0.135672125], 
       DiskBox[{-4.91, 42.91}, 0.5]}, 
      {RGBColor[
       0.8611772083333333, 0.16093727083333334`, 0.13734573958333332`], 
       DiskBox[{-3.8799999999999994, 40.4}, 0.5]}, 
      {RGBColor[0.8599525, 0.15136875, 0.135672125], 
       DiskBox[{-6.71, 42.49}, 0.5]}, 
      {RGBColor[0.8925421666666666, 0.3869823333333333, 0.17887524999999999`],
        DiskBox[{0.69, 42.78}, 0.5]}, 
      {RGBColor[0.8582235, 0.13786025, 0.133309375], 
       DiskBox[{-6.15, 42.5}, 0.5]}, 
      {RGBColor[0.86124925, 0.161500125, 0.1374441875], 
       DiskBox[{-3.28, 36.97}, 0.5]}, 
      {RGBColor[0.86384275, 0.181762875, 0.1409883125], 
       DiskBox[{-3.39, 38.54}, 0.5]}, 
      {RGBColor[0.77217125, 0.72651625, 0.2704135], 
       DiskBox[{-3.6900000000000004, 40.54}, 0.5]}, 
      {RGBColor[
       0.8608890416666667, 0.15868585416666667`, 0.13695194791666665`], 
       DiskBox[{-4.21, 40.38}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-3.9, 40.51}, 0.5]}, 
      {RGBColor[
       0.8576471666666666, 0.13335741666666667`, 0.13252179166666667`], 
       DiskBox[{-6.57, 40.61}, 0.5]}, 
      {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
       DiskBox[{-1.32, 41.25}, 0.5]}, 
      {RGBColor[0.86297825, 0.17500862500000003`, 0.1398069375], 
       DiskBox[{-5.6, 37.94}, 0.5]}, 
      {RGBColor[0.8582235, 0.13786025, 0.133309375], 
       DiskBox[{-5.38, 41.83}, 0.5]}, 
      {RGBColor[0.861465375, 0.1631886875, 0.13773953125], 
       DiskBox[{-4.27, 40.44}, 0.5]}, 
      {RGBColor[0.8772424999999999, 0.28645375, 0.159299625], 
       DiskBox[{-1.43, 41.13}, 0.5]}, 
      {RGBColor[
       0.8611772083333333, 0.16093727083333334`, 0.13734573958333332`], 
       DiskBox[{-4.15, 40.59}, 0.5]}, 
      {RGBColor[
       0.8611772083333333, 0.16093727083333334`, 0.13734573958333332`], 
       DiskBox[{-3.9200000000000004, 40.53}, 0.5]}, 
      {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
       DiskBox[{0.19, 42.27}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-3.96, 40.48}, 0.5]}, 
      {RGBColor[0.86211375, 0.168254375, 0.1386255625], 
       DiskBox[{-3.02, 42.31}, 0.5]}, 
      {RGBColor[0.9011289375, 0.574772125, 0.215009], 
       DiskBox[{-5.7, 43.31}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-5.77, 40.11}, 0.5]}, 
      {RGBColor[
       0.8587998333333333, 0.14236308333333333`, 0.13409695833333332`], 
       DiskBox[{-4.11, 40.65}, 0.5]}, 
      {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
       DiskBox[{-0.7, 42.86}, 0.5]}, 
      {RGBColor[0.8599525, 0.15136875, 0.135672125], 
       DiskBox[{-6.1, 42.96}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-3.7499999999999996, 40.46}, 0.5]}, 
      {RGBColor[0.867733, 0.212157, 0.1463045], 
       DiskBox[{-5.91, 43.330000000000005}, 0.5]}, 
      {RGBColor[0.867733, 0.212157, 0.1463045], DiskBox[{-5.88, 43.36}, 0.5]}, 
      {RGBColor[
       0.8611772083333333, 0.16093727083333334`, 0.13734573958333332`], 
       DiskBox[{-3.8900000000000006, 40.57}, 0.5]}, 
      {RGBColor[
       0.8608890416666667, 0.15868585416666667`, 0.13695194791666665`], 
       DiskBox[{-4., 40.51}, 0.5]}, 
      {RGBColor[
       0.8611772083333333, 0.16093727083333334`, 0.13734573958333332`], 
       DiskBox[{-3.8, 40.33}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-3.8, 40.98}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-3.8799999999999994, 40.5}, 0.5]}, 
      {RGBColor[0.8822313333333334, 0.3200006666666667, 0.1657365], 
       DiskBox[{-2.62, 42.24}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-3.21, 40.72}, 0.5]}, 
      {RGBColor[0.867733, 0.212157, 0.1463045], DiskBox[{-3.67, 40.45}, 0.5]}, 
      {RGBColor[0.8720555, 0.24592825000000001`, 0.152211375], 
       DiskBox[{2.69, 41.76}, 0.5]}, 
      {RGBColor[0.86124925, 0.161500125, 0.1374441875], 
       DiskBox[{-2.79, 41.89}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-3.22, 40.94}, 0.5]}, 
      {RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
       DiskBox[{2.37, 41.78}, 0.5]}, 
      {RGBColor[0.77217125, 0.72651625, 0.2704135], 
       DiskBox[{-5.28, 36.76}, 0.5]}, 
      {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
       DiskBox[{0.17, 41.91}, 0.5]}, 
      {RGBColor[0.738604625, 0.734553625, 0.28479025], 
       DiskBox[{-3.9899999999999998, 40.75}, 0.5]}, 
      {RGBColor[0.8627621249999999, 0.17332006249999998`, 0.13951159375], 
       DiskBox[{-5.45, 37.94}, 0.5]}, 
      {RGBColor[0.8822313333333334, 0.3200006666666667, 0.1657365], 
       DiskBox[{-3.0000000000000004, 42.34}, 0.5]}, 
      {RGBColor[0.867733, 0.212157, 0.1463045], DiskBox[{-5.87, 43.38}, 0.5]}, 
      {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
       DiskBox[{0.99, 41.34}, 0.5]}, 
      {RGBColor[0.8582235, 0.13786025, 0.133309375], 
       DiskBox[{-5.6, 43.02}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-3.6199999999999997, 40.78}, 0.5]}, 
      {RGBColor[0.77217125, 0.72651625, 0.2704135], 
       DiskBox[{-1.12, 37.6}, 0.5]}, 
      {RGBColor[0.86124925, 0.161500125, 0.1374441875], 
       DiskBox[{-3.44, 42.72}, 0.5]}, 
      {RGBColor[
       0.8576471666666666, 0.13335741666666667`, 0.13252179166666667`], 
       DiskBox[{-5.32, 40.46}, 0.5]}, 
      {RGBColor[
       0.8608890416666667, 0.15868585416666667`, 0.13695194791666665`], 
       DiskBox[{-4.26, 40.46}, 0.5]}, 
      {RGBColor[0.8822313333333334, 0.3200006666666667, 0.1657365], 
       DiskBox[{-2.56, 42.1}, 0.5]}, 
      {RGBColor[0.861465375, 0.1631886875, 0.13773953125], 
       DiskBox[{-3.68, 41.14}, 0.5]}, 
      {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
       DiskBox[{1.73, 42.38}, 0.5]}, 
      {RGBColor[0.738604625, 0.734553625, 0.28479025], 
       DiskBox[{-4.77, 40.4}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-3.31, 40.93}, 0.5]}, 
      {RGBColor[0.8582235, 0.13786025, 0.133309375], 
       DiskBox[{-5.07, 43.16}, 0.5]}, 
      {RGBColor[0.8737845, 0.25943675, 0.154574125], 
       DiskBox[{2.92, 41.93}, 0.5]}, 
      {RGBColor[
       0.8576471666666666, 0.13335741666666667`, 0.13252179166666667`], 
       DiskBox[{-6.960000000000001, 42.68}, 0.5]}, 
      {RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
       DiskBox[{0.76, 42.59}, 0.5]}, 
      {RGBColor[0.8720555, 0.24592825000000001`, 0.152211375], 
       DiskBox[{2.57, 41.78}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-5.63, 40.95}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-3.58, 41.14}, 0.5]}, 
      {RGBColor[0.6563445000000001, 0.7431544999999999, 0.32887750000000004`],
        DiskBox[{0.8400000000000001, 42.54}, 0.5]}, 
      {RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
       DiskBox[{-6.01, 37.38}, 0.5]}, 
      {RGBColor[0.8822313333333334, 0.3200006666666667, 0.1657365], 
       DiskBox[{-2.98, 42.27}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-3.24, 40.71}, 0.5]}, 
      {RGBColor[0.86124925, 0.161500125, 0.1374441875], 
       DiskBox[{-3.1, 42.31}, 0.5]}, 
      {RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
       DiskBox[{-3.31, 40.95}, 0.5]}, 
      {RGBColor[0.738604625, 0.734553625, 0.28479025], 
       DiskBox[{-4.010000000000001, 40.76}, 0.5]}, 
      {RGBColor[
       0.8729199999999999, 0.25268250000000003`, 0.15339275000000002`], 
       DiskBox[{4.25, 40.}, 0.5]}, 
      {RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
       DiskBox[{3.4700000000000006, 50.72}, 0.5]}, 
      {RGBColor[0.9011002031249999, 0.5767855937499999, 0.21539225], 
       DiskBox[{3.3, 50.59}, 0.5]}, 
      {RGBColor[0.9011289375, 0.574772125, 0.215009], 
       DiskBox[{3.52, 50.68}, 0.5]}, 
      {RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
       DiskBox[{4.28, 47.16}, 0.5]}, 
      {RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
       DiskBox[{4.55, 46.67}, 0.5]}, 
      {RGBColor[0.8089162916666666, 0.7106607083333333, 0.25577379166666664`],
        DiskBox[{5.33, 47.58}, 0.5]}, 
      {RGBColor[0.8118795455729166, 0.7084956419270834, 0.25473115494791665`],
        DiskBox[{3.94, 47.45000000000001}, 0.5]}, 
      {RGBColor[0.8925421666666666, 0.3869823333333333, 0.17887524999999999`],
        DiskBox[{4.34, 46.69}, 0.5]}, 
      {RGBColor[0.8925421666666666, 0.3869823333333333, 0.17887524999999999`],
        DiskBox[{5.21, 47.43}, 0.5]}, 
      {RGBColor[0.9010523125, 0.580141375, 0.216031], 
       DiskBox[{4.32, 48.54}, 0.5]}, 
      {RGBColor[0.9011480937499999, 0.5734298124999999, 0.2147535], 
       DiskBox[{4.41, 48.57}, 0.5]}, 
      {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
       DiskBox[{4.24, 48.59}, 0.5]}, 
      {RGBColor[0.9011289375, 0.574772125, 0.215009], 
       DiskBox[{4.52, 48.91}, 0.5]}, 
      {RGBColor[0.867733, 0.212157, 0.1463045], DiskBox[{4.1, 48.86}, 0.5]}, 
      {RGBColor[0.867733, 0.212157, 0.1463045], 
       DiskBox[{3.6900000000000004, 44.05}, 0.5]}, 
      {RGBColor[0.8925421666666666, 0.3869823333333333, 0.17887524999999999`],
        DiskBox[{3.77, 44.12}, 0.5]}, 
      {RGBColor[0.8925421666666666, 0.3869823333333333, 0.17887524999999999`],
        DiskBox[{3.71, 43.92}, 0.5]}, 
      {RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333], 
       DiskBox[{4.14, 43.91}, 0.5]}, 
      {RGBColor[0.901090625, 0.57745675, 0.21552000000000002`], 
       DiskBox[{4.33, 44.12}, 0.5]}, 
      {RGBColor[0.7988591875, 0.7180088124999999, 0.2593124375], 
       DiskBox[{3.8900000000000006, 43.74}, 0.5]}, 
      {RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
       DiskBox[{2.93, 50.6}, 0.5]}, 
      {RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
       DiskBox[{2.69, 50.79}, 0.5]}, 
      {RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
       DiskBox[{2.99, 50.65}, 0.5]}, 
      {RGBColor[0.738604625, 0.734553625, 0.28479025], 
       DiskBox[{-7.450000000000001, 31.48}, 0.5]}, 
      {RGBColor[0.9011289375, 0.574772125, 0.215009], 
       DiskBox[{-8.54, 40.92000000000001}, 0.5]}, 
      {RGBColor[0.8772424999999999, 0.28645375, 0.159299625], 
       DiskBox[{-1.34, 41.32}, 0.5]}, 
      {RGBColor[0.863194375, 0.17669718750000002`, 0.14010228125000002`], 
       DiskBox[{-5.74, 39.73}, 0.5]}, 
      {RGBColor[0.77217125, 0.72651625, 0.2704135], 
       DiskBox[{-6.36, 36.83}, 0.5]}, 
      {RGBColor[0.86211375, 0.168254375, 0.1386255625], 
       DiskBox[{-3.11, 41.8}, 0.5]}, 
      {RGBColor[0.8627621249999999, 0.17332006249999998`, 0.13951159375], 
       DiskBox[{-6.34, 38.92}, 0.5]}, 
      {RGBColor[0.77217125, 0.72651625, 0.2704135], 
       DiskBox[{-3.9, 40.74}, 0.5]}, 
      {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
       DiskBox[{-3.54, 41.05}, 0.5]}, 
      {RGBColor[0.8599525, 0.15136875, 0.135672125], 
       DiskBox[{-6.93, 42.69}, 0.5]}, 
      {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
       DiskBox[{0.76, 42.63}, 0.5]}, 
      {RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
       DiskBox[{82.5667, 51.3333}, 0.5]}, 
      {RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
       DiskBox[{82.55, 51.32}, 0.5]}, 
      {RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
       DiskBox[{82.19, 51.33}, 0.5]}, 
      {RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
       DiskBox[{60.46000000000001, 54.09}, 0.5]}, 
      {RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
       DiskBox[{60.480000000000004, 54.06}, 0.5]}, 
      {RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
       DiskBox[{51.75, 53.04}, 0.5]}, 
      {RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
       DiskBox[{49.48, 53.33}, 0.5]}, 
      {RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
       DiskBox[{49.48, 53.33}, 0.5]}, 
      {RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
       DiskBox[{57.56000000000001, 51.31}, 0.5]}, 
      {RGBColor[0.9017419375, 0.5318181249999999, 0.20683300000000002`], 
       DiskBox[{15.320000000000002, 40.57}, 0.5]}, 
      {RGBColor[0.90168446875, 0.5358450625, 0.2075995], 
       DiskBox[{16.26, 39.18}, 0.5]}, 
      {RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
       DiskBox[{16.23, 38.36}, 0.5]}, 
      {RGBColor[0.90168446875, 0.5358450625, 0.2075995], 
       DiskBox[{16.22, 38.38}, 0.5]}, 
      {RGBColor[0.9017419375, 0.5318181249999999, 0.20683300000000002`], 
       DiskBox[{15.65, 40.28}, 0.5]}, 
      {RGBColor[0.90168446875, 0.5358450625, 0.2075995], 
       DiskBox[{16.27, 39.27}, 0.5]}, 
      {RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
       DiskBox[{16.45, 40.18}, 0.5]}, 
      {RGBColor[0.81178975, 0.70856125, 0.25476275], 
       DiskBox[{11.2376, 46.3716}, 0.5]}, 
      {RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
       DiskBox[{11.331, 46.513}, 0.5]}, 
      {RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
       DiskBox[{11.331, 46.513}, 0.5]}, 
      {RGBColor[0.858124265625, 0.674707484375, 0.238459703125], 
       DiskBox[{11.2832, 46.366}, 0.5]}, 
      {RGBColor[0.8376508749999999, 0.689666125, 0.245663375], 
       DiskBox[{11.2928, 46.3378}, 0.5]}, 
      {RGBColor[0.8376508749999999, 0.689666125, 0.245663375], 
       DiskBox[{11.2928, 46.3378}, 0.5]}, 
      {RGBColor[0.9019334999999999, 0.5183949999999999, 0.20427800000000002`],
        DiskBox[{11.167, 46.2543}, 0.5]}, 
      {RGBColor[0.8613569062499999, 0.67234559375, 0.23732228125], 
       DiskBox[{10.817000000000002, 46.62970000000001}, 0.5]}, 
      {RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
       DiskBox[{11.23, 46.36}, 0.5]}, 
      {RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
       DiskBox[{16.17, 38.62}, 0.5]}, 
      {RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
       DiskBox[{16.24, 38.76}, 0.5]}, 
      {RGBColor[0.90168446875, 0.5358450625, 0.2075995], 
       DiskBox[{16.47, 39.01}, 0.5]}, 
      {RGBColor[0.9017419375, 0.5318181249999999, 0.20683300000000002`], 
       DiskBox[{12.87, 41.62}, 0.5]}, 
      {RGBColor[0.9017419375, 0.5318181249999999, 0.20683300000000002`], 
       DiskBox[{12.87, 41.62}, 0.5]}, 
      {RGBColor[0.90239325, 0.4861795, 0.198146], 
       DiskBox[{23.65, 41.43}, 0.5]}, 
      {RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
       DiskBox[{25.2, 41.59}, 0.5]}, 
      {RGBColor[0.90269975, 0.46470249999999996`, 0.194058], 
       DiskBox[{23.5, 41.43}, 0.5]}, 
      {RGBColor[0.716226875, 0.739911875, 0.29437475], 
       DiskBox[{43.4767, 41.794200000000004}, 0.5]}, 
      {RGBColor[0.9021250625, 0.504971875, 0.20172299999999999`], 
       DiskBox[{46.2831, 41.8296}, 0.5]}, 
      {RGBColor[0.902163375, 0.50228725, 0.201212], 
       DiskBox[{46.3728, 41.2381}, 0.5]}, 
      {RGBColor[0.7988591875, 0.7180088124999999, 0.2593124375], 
       DiskBox[{42.2394, 38.6425}, 0.5]}, 
      {RGBColor[0.8876767421875, 0.355375359375, 0.17267540234375], 
       DiskBox[{9.4, 48.14}, 0.5]}, 
      {RGBColor[0.8877411848958333, 0.3557939947916667, 0.17275751953125001`],
        DiskBox[{8.8, 48.52}, 0.5]}, 
      {RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
       DiskBox[{9.16, 48.56}, 0.5]}, 
      {RGBColor[0.888933375, 0.36353875, 0.1742766875], 
       DiskBox[{8.82, 48.43}, 0.5]}, 
      {RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
       DiskBox[{9.06, 48.53}, 0.5]}, 
      {RGBColor[0.9010523125, 0.580141375, 0.216031], 
       DiskBox[{9.050000000000002, 48.52}, 0.5]}, 
      {RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
       DiskBox[{9.04, 48.53}, 0.5]}, 
      {RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333], 
       DiskBox[{25.74, 44.46}, 0.5]}, 
      {RGBColor[0.8160999375, 0.7054120625, 0.2532461875], 
       DiskBox[{21.95, 46.11}, 0.5]}, 
      {RGBColor[0.90208675, 0.5076565, 0.202234], 
       DiskBox[{34.3814, 44.64190000000001}, 0.5]}, 
      {RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
       DiskBox[{70.05, 41.45}, 0.5]}, 
      {RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
       DiskBox[{70.05, 41.45}, 0.5]}, 
      {RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
       DiskBox[{70.05, 41.45}, 0.5]}, 
      {RGBColor[0.7078352187500001, 0.7419212187499999, 0.29796893750000003`],
        DiskBox[{45.3622, 39.8692}, 0.5]}, 
      {RGBColor[0.902010125, 0.51302575, 0.203256], 
       DiskBox[{48.5594, 38.97860000000001}, 0.5]}, 
      {RGBColor[0.9020484375, 0.510341125, 0.202745], 
       DiskBox[{48.6131, 38.7406}, 0.5]}, 
      {RGBColor[0.9020484375, 0.510341125, 0.202745], 
       DiskBox[{48.7992, 38.6536}, 0.5]}, 
      {RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
       DiskBox[{71.3, 37.29}, 0.5]}, 
      {RGBColor[0.8160999375, 0.7054120625, 0.2532461875], 
       DiskBox[{21.46, 44.34}, 0.5]}, 
      {RGBColor[0.8132264791666666, 0.7075115208333334, 0.25425722916666665`],
        DiskBox[{20.16, 44.84}, 0.5]}, 
      {RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 
       DiskBox[{16.5, 49.17}, 0.5]}, 
      {RGBColor[0.888933375, 0.36353875, 0.1742766875], 
       DiskBox[{7.7667, 48.0333}, 0.5]}, 
      {RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
       DiskBox[{15.45, 68.8}, 0.5]}, 
      {RGBColor[0.888933375, 0.36353875, 0.1742766875], 
       DiskBox[{7.765567, 48.028380000000006}, 0.5]}, 
      {RGBColor[0.7218213125, 0.7385723125, 0.291978625], 
       DiskBox[{34.12, 62.02000000000001}, 0.5]}, 
      {RGBColor[0.7218213125, 0.7385723125, 0.291978625], 
       DiskBox[{34.12, 62.02000000000001}, 0.5]}, 
      {RGBColor[0.7218213125, 0.7385723125, 0.291978625], 
       DiskBox[{35.11, 61.589999999999996}, 0.5]}, 
      {RGBColor[0.7218213125, 0.7385723125, 0.291978625], 
       DiskBox[{35.11, 61.589999999999996}, 0.5]}, 
      {RGBColor[0.7959857291666667, 0.7201082708333333, 0.26032347916666665`],
        DiskBox[{34.24, 61.940000000000005}, 0.5]}, 
      {RGBColor[0.7218213125, 0.7385723125, 0.291978625], 
       DiskBox[{34.24, 61.940000000000005}, 0.5]}, 
      {RGBColor[0.7106324375, 0.7412514375, 0.296770875], 
       DiskBox[{61.37, 61.37}, 0.5]}, 
      {RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 
       DiskBox[{14.726650000000001, 48.3315333}, 0.5]}, 
      {RGBColor[0.8121489322916666, 0.7082988177083334, 0.25463636979166665`],
        DiskBox[{14.7158667, 48.3314667}, 0.5]}, 
      {RGBColor[0.8128672968749999, 0.707773953125, 0.254383609375], 
       DiskBox[{14.7158667, 48.3314667}, 0.5]}, 
      {RGBColor[0.7106324375, 0.7412514375, 0.296770875], 
       DiskBox[{32.09, 60.4}, 0.5]}, 
      {RGBColor[0.7120310468750001, 0.740916546875, 0.29617184375], 
       DiskBox[{30.629999999999995, 61.57}, 0.5]}, 
      {RGBColor[0.8128672968749999, 0.707773953125, 0.254383609375], 
       DiskBox[{14.718166699999998, 48.3268333}, 0.5]}, 
      {RGBColor[0.8128672968749999, 0.707773953125, 0.254383609375], 
       DiskBox[{14.718166699999998, 48.3268333}, 0.5]}, 
      {RGBColor[0.8128672968749999, 0.707773953125, 0.254383609375], 
       DiskBox[{14.718166699999998, 48.3268333}, 0.5]}}, 
     TagBox[{},
      Annotation[#, "GeoGridLines", "WolframGeoGraphics"]& ]}}, 
   TagBox[{},
    Annotation[#, "GeoScaleBar", "WolframGeoGraphics"]& ]},
  CoordinatesToolOptions:>{
   "DisplayFunction" -> (
     GeoGraphics`GeoGridPositionDisplay[#, "Equirectangular", "ITRF00"]& ), 
    "CopiedValueFunction" -> (
     GeoGraphics`GeoGridPositionCopiedValue[#, "Equirectangular", 
      "ITRF00"]& )},
  DefaultBaseStyle->"GeoGraphics",
  ImageSize->900,
  Method->{"OriginalInput" -> HoldForm[
      GeoGraphics[{
        RGBColor[0.901856875, 0.5237642499999999, 0.2053], 
        Disk[
         GeoPosition[{47.4, 0.683333}], 0.5], 
        RGBColor[0.9011289375, 0.574772125, 0.215009], 
        Disk[
         GeoPosition[{48.5167, -4.06667}], 0.5], 
        RGBColor[0.9011289375, 0.574772125, 0.215009], 
        Disk[
         GeoPosition[{48.5167, -4.06667}], 0.5], 
        RGBColor[
        0.8925421666666666, 0.3869823333333333, 0.17887524999999999`], 
        Disk[
         GeoPosition[{47.35, 3.93333}], 0.5], 
        RGBColor[0.878107, 0.293208, 0.160481], 
        Disk[
         GeoPosition[{44.65, -1.16667}], 0.5], 
        RGBColor[0.8899644583333334, 0.3702369166666667, 0.1755905625], 
        Disk[
         GeoPosition[{46.6667, 4.11667}], 0.5], 
        RGBColor[0.8899644583333334, 0.3702369166666667, 0.1755905625], 
        Disk[
         GeoPosition[{46.6667, 4.11667}], 0.5], 
        RGBColor[
        0.8124183190104166, 0.7081019934895834, 0.25454158463541665`], 
        Disk[
         GeoPosition[{49.3667, 16.2667}], 0.5], 
        RGBColor[
        0.8124183190104166, 0.7081019934895834, 0.25454158463541665`], 
        Disk[
         GeoPosition[{49.4211, 16.3497}], 0.5], 
        RGBColor[
        0.8118795455729166, 0.7084956419270834, 0.25473115494791665`], 
        Disk[
         GeoPosition[{49.4112, 16.2815}], 0.5], 
        RGBColor[0.8122387278645833, 0.7082332096354167, 0.2546047747395833], 
        Disk[
         GeoPosition[{49.403, 16.232}], 0.5], 
        RGBColor[0.8122387278645833, 0.7082332096354167, 0.2546047747395833], 
        Disk[
         GeoPosition[{47, 15.5}], 0.5], 
        RGBColor[0.250728, 0.225386, 0.769152], 
        Disk[
         GeoPosition[{40.8313, -87.735}], 0.5], 
        RGBColor[0.250728, 0.225386, 0.769152], 
        Disk[
         GeoPosition[{40.8313, -87.735}], 0.5], 
        RGBColor[0.250728, 0.225386, 0.769152], 
        Disk[
         GeoPosition[{40.8313, -87.735}], 0.5], 
        RGBColor[0.266122, 0.486664, 0.802529], 
        Disk[
         GeoPosition[{40.8313, -87.735}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{40.8313, -87.735}], 0.5], 
        RGBColor[0.266122, 0.486664, 0.802529], 
        Disk[
         GeoPosition[{40.8313, -87.735}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{40.9076, -73.2089}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{40.9076, -73.2089}], 0.5], 
        RGBColor[0.9010523125, 0.580141375, 0.216031], 
        Disk[
         GeoPosition[{40.7777, -72.9069}], 0.5], 
        RGBColor[0.9011289375, 0.574772125, 0.215009], 
        Disk[
         GeoPosition[{40.7777, -72.9069}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{40.9447, -72.8615}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{40.9447, -72.8615}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{40.9064, -73.1493}], 0.5], 
        RGBColor[0.266122, 0.486664, 0.802529], 
        Disk[
         GeoPosition[{40.9064, -73.1493}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{40.9352, -73.114}], 0.5], 
        RGBColor[0.250728, 0.225386, 0.769152], 
        Disk[
         GeoPosition[{40.9352, -73.114}], 0.5], 
        RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
        Disk[
         GeoPosition[{42.3, 74.3667}], 0.5], 
        RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
        Disk[
         GeoPosition[{42.1833, 73.4}], 0.5], 
        RGBColor[0.71098208984375, 0.74116771484375, 0.2966211171875], 
        Disk[
         GeoPosition[{42.5833, 73.6333}], 0.5], 
        RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
        Disk[
         GeoPosition[{42.8, 76.35}], 0.5], 
        RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
        Disk[
         GeoPosition[{37.35, 72.4667}], 0.5], 
        RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
        Disk[
         GeoPosition[{37.9169, -84.4639}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.7976, -86.6691}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.7976, -86.6691}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.8266, -86.4366}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.8266, -86.4366}], 0.5], 
        RGBColor[0.901243875, 0.56671825, 0.213476], 
        Disk[
         GeoPosition[{41.8266, -86.4366}], 0.5], 
        RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 
        Disk[
         GeoPosition[{41.8972, -71.4378}], 0.5], 
        RGBColor[0.9011480937499999, 0.5734298124999999, 0.2147535], 
        Disk[
         GeoPosition[{42.3634, -71.1445}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.3833, 14.05}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.3833, 14.05}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.3833, 14.05}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{55.3833, 14.05}], 0.5], 
        RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
        Disk[
         GeoPosition[{55.3833, 14.05}], 0.5], 
        RGBColor[0.5556259791666667, 0.7361003541666666, 0.4039107291666667], 
        Disk[
         GeoPosition[{55.7167, 14.1333}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.7167, 14.1333}], 0.5], 
        RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
        Disk[
         GeoPosition[{55.7167, 14.1333}], 0.5], 
        RGBColor[0.5556259791666667, 0.7361003541666666, 0.4039107291666667], 
        Disk[
         GeoPosition[{55.7167, 14.1333}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{55.7167, 14.1333}], 0.5], 
        RGBColor[
        0.5585707916666667, 0.7365315416666667, 0.40134529166666666`], 
        Disk[
         GeoPosition[{56.7, 16.5167}], 0.5], 
        RGBColor[
        0.5585707916666667, 0.7365315416666667, 0.40134529166666666`], 
        Disk[
         GeoPosition[{56.7, 16.5167}], 0.5], 
        RGBColor[0.57231325, 0.73854375, 0.38937325], 
        Disk[
         GeoPosition[{59.4333, 17.0167}], 0.5], 
        RGBColor[0.57231325, 0.73854375, 0.38937325], 
        Disk[
         GeoPosition[{59.4333, 17.0167}], 0.5], 
        RGBColor[0.57231325, 0.73854375, 0.38937325], 
        Disk[
         GeoPosition[{59.5667, 16.8667}], 0.5], 
        RGBColor[0.57231325, 0.73854375, 0.38937325], 
        Disk[
         GeoPosition[{59.5667, 16.8667}], 0.5], 
        RGBColor[
        0.6462000208333334, 0.7432718958333333, 0.33506718750000003`], 
        Disk[
         GeoPosition[{63.0833, 18.3667}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.9, -86.583}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.9, -86.583}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{43.3431, -86.4045}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{43.3431, -86.4045}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.879, -86.607}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.879, -86.607}], 0.5], 
        RGBColor[0.250728, 0.225386, 0.769152], 
        Disk[
         GeoPosition[{42.405, -85.398}], 0.5], 
        RGBColor[0.250728, 0.225386, 0.769152], 
        Disk[
         GeoPosition[{42.405, -85.398}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{42.184, -86.358}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{42.184, -86.358}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.847, -86.67}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.847, -86.67}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.8, -86.67}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.8, -86.67}], 0.5], 
        RGBColor[0.901243875, 0.56671825, 0.213476], 
        Disk[
         GeoPosition[{42.051, -86.509}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{42.051, -86.509}], 0.5], 
        RGBColor[0.266122, 0.486664, 0.802529], 
        Disk[
         GeoPosition[{42.051, -86.509}], 0.5], 
        RGBColor[0.266122, 0.486664, 0.802529], 
        Disk[
         GeoPosition[{43.595, -86.2657}], 0.5], 
        RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
        Disk[
         GeoPosition[{43.595, -86.2657}], 0.5], 
        RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
        Disk[
         GeoPosition[{43.595, -86.2657}], 0.5], 
        RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
        Disk[
         GeoPosition[{43.595, -86.2657}], 0.5], 
        RGBColor[0.7988591875, 0.7180088124999999, 0.2593124375], 
        Disk[
         GeoPosition[{43.5139, -86.1859}], 0.5], 
        RGBColor[0.72741575, 0.73723275, 0.2895825], 
        Disk[
         GeoPosition[{43.5251, -86.1843}], 0.5], 
        RGBColor[0.250728, 0.225386, 0.769152], 
        Disk[
         GeoPosition[{43.5251, -86.1843}], 0.5], 
        RGBColor[0.250728, 0.225386, 0.769152], 
        Disk[
         GeoPosition[{43.5251, -86.1843}], 0.5], 
        RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
        Disk[
         GeoPosition[{43.5187, -86.1739}], 0.5], 
        RGBColor[0.8904799999999999, 0.373586, 0.1762475], 
        Disk[
         GeoPosition[{43.5356, -86.1788}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{43.5356, -86.1788}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{42.166, -86.412}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{42.166, -86.412}], 0.5], 
        RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
        Disk[
         GeoPosition[{42.166, -86.412}], 0.5], 
        RGBColor[0.266122, 0.486664, 0.802529], 
        Disk[
         GeoPosition[{43.2483, -86.3368}], 0.5], 
        RGBColor[0.250728, 0.225386, 0.769152], 
        Disk[
         GeoPosition[{43.2483, -86.3368}], 0.5], 
        RGBColor[0.250728, 0.225386, 0.769152], 
        Disk[
         GeoPosition[{43.2749, -86.0891}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{43.2749, -86.0891}], 0.5], 
        RGBColor[0.250728, 0.225386, 0.769152], 
        Disk[
         GeoPosition[{43.2749, -86.0891}], 0.5], 
        RGBColor[0.250728, 0.225386, 0.769152], 
        Disk[
         GeoPosition[{42.148, -86.431}], 0.5], 
        RGBColor[0.250728, 0.225386, 0.769152], 
        Disk[
         GeoPosition[{42.148, -86.431}], 0.5], 
        RGBColor[0.901243875, 0.56671825, 0.213476], 
        Disk[
         GeoPosition[{42.148, -86.431}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{43.7623, -86.3929}], 0.5], 
        RGBColor[0.7988591875, 0.7180088124999999, 0.2593124375], 
        Disk[
         GeoPosition[{43.7623, -86.3929}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{43.7623, -86.3929}], 0.5], 
        RGBColor[0.266122, 0.486664, 0.802529], 
        Disk[
         GeoPosition[{42.184, -86.382}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{42.184, -86.382}], 0.5], 
        RGBColor[0.9010523125, 0.580141375, 0.216031], 
        Disk[
         GeoPosition[{43.665, -86.496}], 0.5], 
        RGBColor[0.901243875, 0.56671825, 0.213476], 
        Disk[
         GeoPosition[{43.665, -86.496}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{43.665, -86.496}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{43.665, -86.496}], 0.5], 
        RGBColor[0.9010523125, 0.580141375, 0.216031], 
        Disk[
         GeoPosition[{42.03, -86.514}], 0.5], 
        RGBColor[0.250728, 0.225386, 0.769152], 
        Disk[
         GeoPosition[{41.865, -86.646}], 0.5], 
        RGBColor[0.250728, 0.225386, 0.769152], 
        Disk[
         GeoPosition[{41.865, -86.646}], 0.5], 
        RGBColor[0.9011289375, 0.574772125, 0.215009], 
        Disk[
         GeoPosition[{50.4, -4.9}], 0.5], 
        RGBColor[0.901090625, 0.57745675, 0.21552000000000002`], 
        Disk[
         GeoPosition[{50.4, -4.9}], 0.5], 
        RGBColor[0.9011289375, 0.574772125, 0.215009], 
        Disk[
         GeoPosition[{50.4, -4.9}], 0.5], 
        RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
        Disk[
         GeoPosition[{50.4, -4.9}], 0.5], 
        RGBColor[0.9010523125, 0.580141375, 0.216031], 
        Disk[
         GeoPosition[{50.3, -4.9}], 0.5], 
        RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
        Disk[
         GeoPosition[{50.3, -4.9}], 0.5], 
        RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
        Disk[
         GeoPosition[{50.3, -4.8}], 0.5], 
        RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
        Disk[
         GeoPosition[{50.4, -4.7}], 0.5], 
        RGBColor[0.9011289375, 0.574772125, 0.215009], 
        Disk[
         GeoPosition[{50.5, -4.5}], 0.5], 
        RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
        Disk[
         GeoPosition[{51.3, 0.5}], 0.5], 
        RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666], 
        Disk[
         GeoPosition[{51.3, 0.5}], 0.5], 
        RGBColor[0.90147375, 0.5506105, 0.21041], 
        Disk[
         GeoPosition[{52.2, -1.7}], 0.5], 
        RGBColor[0.8760126666666667, 0.641456, 0.22989], 
        Disk[
         GeoPosition[{51.3, 0.4}], 0.5], 
        RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
        Disk[
         GeoPosition[{51.2, 0.3}], 0.5], 
        RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
        Disk[
         GeoPosition[{51.2, 0.4}], 0.5], 
        RGBColor[0.9010523125, 0.580141375, 0.216031], 
        Disk[
         GeoPosition[{51.2, 0.3}], 0.5], 
        RGBColor[0.9011002031249999, 0.5767855937499999, 0.21539225], 
        Disk[
         GeoPosition[{51.1, 0.6}], 0.5], 
        RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
        Disk[
         GeoPosition[{51.3, 1.1}], 0.5], 
        RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
        Disk[
         GeoPosition[{51.3, 1.1}], 0.5], 
        RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
        Disk[
         GeoPosition[{51.1, 0.4}], 0.5], 
        RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
        Disk[
         GeoPosition[{54.5, -3}], 0.5], 
        RGBColor[0.9010523125, 0.580141375, 0.216031], 
        Disk[
         GeoPosition[{54.4, -3}], 0.5], 
        RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666], 
        Disk[
         GeoPosition[{54.6, -3.3}], 0.5], 
        RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
        Disk[
         GeoPosition[{54.7, -3.4}], 0.5], 
        RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
        Disk[
         GeoPosition[{54.4, -2.9}], 0.5], 
        RGBColor[0.9010523125, 0.580141375, 0.216031], 
        Disk[
         GeoPosition[{54.4, -2.9}], 0.5], 
        RGBColor[0.9010523125, 0.580141375, 0.216031], 
        Disk[
         GeoPosition[{54.6, -3.2}], 0.5], 
        RGBColor[0.9010523125, 0.580141375, 0.216031], 
        Disk[
         GeoPosition[{57, -3.4}], 0.5], 
        RGBColor[0.878107, 0.293208, 0.160481], 
        Disk[
         GeoPosition[{53.3, -1.6}], 0.5], 
        RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
        Disk[
         GeoPosition[{51.3, 1.1}], 0.5], 
        RGBColor[0.90147375, 0.5506105, 0.21041], 
        Disk[
         GeoPosition[{56.6, -4.1}], 0.5], 
        RGBColor[0.8760126666666667, 0.641456, 0.22989], 
        Disk[
         GeoPosition[{56, -4.4}], 0.5], 
        RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
        Disk[
         GeoPosition[{54.6, -2.3}], 0.5], 
        RGBColor[0.90147375, 0.5506105, 0.21041], 
        Disk[
         GeoPosition[{54.1, -1.5}], 0.5], 
        RGBColor[0.888933375, 0.36353875, 0.1742766875], 
        Disk[
         GeoPosition[{54.1, -2.3}], 0.5], 
        RGBColor[0.9010523125, 0.580141375, 0.216031], 
        Disk[
         GeoPosition[{52.9, -1.3}], 0.5], 
        RGBColor[0.901090625, 0.57745675, 0.21552000000000002`], 
        Disk[
         GeoPosition[{51, -3.1}], 0.5], 
        RGBColor[0.57231325, 0.73854375, 0.38937325], 
        Disk[
         GeoPosition[{56.4, -5.2}], 0.5], 
        RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
        Disk[
         GeoPosition[{53.1, -3.3}], 0.5], 
        RGBColor[
        0.8959791111111111, 0.40930955555555554`, 0.18325483333333334`], 
        Disk[
         GeoPosition[{57.4, -5.5}], 0.5], 
        RGBColor[0.901090625, 0.57745675, 0.21552000000000002`], 
        Disk[
         GeoPosition[{52.9, -3.1}], 0.5], 
        RGBColor[0.57231325, 0.73854375, 0.38937325], 
        Disk[
         GeoPosition[{56.7333, -5.98333}], 0.5], 
        RGBColor[0.8232835833333333, 0.7001634166666666, 0.2507185833333333], 
        Disk[
         GeoPosition[{56.3333, 15.9667}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{56.3333, 15.9667}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{56.3333, 15.9667}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.86, 13.51}], 0.5], 
        RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333], 
        Disk[
         GeoPosition[{49.4013, 16.2326}], 0.5], 
        RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
        Disk[
         GeoPosition[{63.0167, 17.4914}], 0.5], 
        RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
        Disk[
         GeoPosition[{62.6814, 18.0165}], 0.5], 
        RGBColor[0.5543171736111111, 0.7359087152777778, 0.4050509236111111], 
        Disk[
         GeoPosition[{55.76, 14.12}], 0.5], 
        RGBColor[0.5543171736111111, 0.7359087152777778, 0.4050509236111111], 
        Disk[
         GeoPosition[{55.76, 14.12}], 0.5], 
        RGBColor[
        0.8118795455729166, 0.7084956419270834, 0.25473115494791665`], 
        Disk[
         GeoPosition[{49.4112, 16.2815}], 0.5], 
        RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 
        Disk[
         GeoPosition[{49.4112, 16.2815}], 0.5], 
        RGBColor[
        0.8118795455729166, 0.7084956419270834, 0.25473115494791665`], 
        Disk[
         GeoPosition[{49.4112, 16.2815}], 0.5], 
        RGBColor[
        0.8118795455729166, 0.7084956419270834, 0.25473115494791665`], 
        Disk[
         GeoPosition[{49.4112, 16.2815}], 0.5], 
        RGBColor[
        0.8118795455729166, 0.7084956419270834, 0.25473115494791665`], 
        Disk[
         GeoPosition[{49.4112, 16.2815}], 0.5], 
        RGBColor[
        0.8118795455729166, 0.7084956419270834, 0.25473115494791665`], 
        Disk[
         GeoPosition[{49.4112, 16.2815}], 0.5], 
        RGBColor[
        0.8118795455729166, 0.7084956419270834, 0.25473115494791665`], 
        Disk[
         GeoPosition[{49.4112, 16.2815}], 0.5], 
        RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 
        Disk[
         GeoPosition[{49.4112, 16.2815}], 0.5], 
        RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 
        Disk[
         GeoPosition[{49.1, 16.2}], 0.5], 
        RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
        Disk[
         GeoPosition[{62.877, 18.177}], 0.5], 
        RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
        Disk[
         GeoPosition[{62.877, 18.177}], 0.5], 
        RGBColor[0.6380844375000001, 0.7433658125, 0.3400189375], 
        Disk[
         GeoPosition[{62.877, 18.177}], 0.5], 
        RGBColor[0.6380844375000001, 0.7433658125, 0.3400189375], 
        Disk[
         GeoPosition[{62.877, 18.177}], 0.5], 
        RGBColor[0.6380844375000001, 0.7433658125, 0.3400189375], 
        Disk[
         GeoPosition[{62.877, 18.177}], 0.5], 
        RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
        Disk[
         GeoPosition[{62.9, 18.4}], 0.5], 
        RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
        Disk[
         GeoPosition[{62.9, 18.4}], 0.5], 
        RGBColor[
        0.5536627708333334, 0.7358128958333333, 0.40562102083333335`], 
        Disk[
         GeoPosition[{56.06, 14.29}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{56.06, 14.29}], 0.5], 
        RGBColor[0.5543171736111111, 0.7359087152777778, 0.4050509236111111], 
        Disk[
         GeoPosition[{56.06, 14.29}], 0.5], 
        RGBColor[
        0.5536627708333334, 0.7358128958333333, 0.40562102083333335`], 
        Disk[
         GeoPosition[{56.06, 14.29}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.7509, 13.3712}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.7509, 13.3712}], 0.5], 
        RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
        Disk[
         GeoPosition[{62.6437, 17.7339}], 0.5], 
        RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
        Disk[
         GeoPosition[{62.806, 18.1896}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{56.1, 13.74}], 0.5], 
        RGBColor[0.8760126666666667, 0.641456, 0.22989], 
        Disk[
         GeoPosition[{56.1, 13.74}], 0.5], 
        RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
        Disk[
         GeoPosition[{56.1, 13.74}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{56.1, 13.74}], 0.5], 
        RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666], 
        Disk[
         GeoPosition[{56.1, 13.74}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.66, 13.4}], 0.5], 
        RGBColor[0.8232835833333333, 0.7001634166666666, 0.2507185833333333], 
        Disk[
         GeoPosition[{56.0328, 14.775}], 0.5], 
        RGBColor[
        0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 
        Disk[
         GeoPosition[{56.09, 13.9}], 0.5], 
        RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 
        Disk[
         GeoPosition[{62.801, 18.079}], 0.5], 
        RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 
        Disk[
         GeoPosition[{62.801, 18.079}], 0.5], 
        RGBColor[
        0.6462000208333334, 0.7432718958333333, 0.33506718750000003`], 
        Disk[
         GeoPosition[{62.9513, 18.2763}], 0.5], 
        RGBColor[
        0.6462000208333334, 0.7432718958333333, 0.33506718750000003`], 
        Disk[
         GeoPosition[{62.9513, 18.2763}], 0.5], 
        RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
        Disk[
         GeoPosition[{62.9308, 18.3448}], 0.5], 
        RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
        Disk[
         GeoPosition[{62.9308, 18.3448}], 0.5], 
        RGBColor[0.8232835833333333, 0.7001634166666666, 0.2507185833333333], 
        Disk[
         GeoPosition[{56.1481, 15.8155}], 0.5], 
        RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
        Disk[
         GeoPosition[{56.4573, 16.1308}], 0.5], 
        RGBColor[
        0.5507179583333334, 0.7353817083333334, 0.40818645833333334`], 
        Disk[
         GeoPosition[{55.6942, 13.4504}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.6942, 13.4504}], 0.5], 
        RGBColor[
        0.5507179583333334, 0.7353817083333334, 0.40818645833333334`], 
        Disk[
         GeoPosition[{55.7097, 13.2145}], 0.5], 
        RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
        Disk[
         GeoPosition[{58.9, 11.2}], 0.5], 
        RGBColor[
        0.5536627708333334, 0.7358128958333333, 0.40562102083333335`], 
        Disk[
         GeoPosition[{56.4666, 16.1284}], 0.5], 
        RGBColor[0.8232835833333333, 0.7001634166666666, 0.2507185833333333], 
        Disk[
         GeoPosition[{56.4666, 16.1284}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{55.6525, 13.2197}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.6525, 13.215}], 0.5], 
        RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667], 
        Disk[
         GeoPosition[{55.6514, 13.2233}], 0.5], 
        RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667], 
        Disk[
         GeoPosition[{55.6494, 13.2147}], 0.5], 
        RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667], 
        Disk[
         GeoPosition[{55.6486, 13.2161}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{55.6472, 13.2225}], 0.5], 
        RGBColor[
        0.5507179583333334, 0.7353817083333334, 0.40818645833333334`], 
        Disk[
         GeoPosition[{55.6481, 13.2264}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{55.6561, 13.2178}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{55.6575, 13.2386}], 0.5], 
        RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667], 
        Disk[
         GeoPosition[{55.6, 13.2}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{55.6, 13.2}], 0.5], 
        RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667], 
        Disk[
         GeoPosition[{55.6, 13.2}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.7, 13.2}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{55.7967, 13.1211}], 0.5], 
        RGBColor[
        0.5507179583333334, 0.7353817083333334, 0.40818645833333334`], 
        Disk[
         GeoPosition[{55.7931, 13.1186}], 0.5], 
        RGBColor[
        0.5507179583333334, 0.7353817083333334, 0.40818645833333334`], 
        Disk[
         GeoPosition[{55.7942, 13.1222}], 0.5], 
        RGBColor[0.9010523125, 0.580141375, 0.216031], 
        Disk[
         GeoPosition[{55.7989, 13.1206}], 0.5], 
        RGBColor[
        0.5507179583333334, 0.7353817083333334, 0.40818645833333334`], 
        Disk[
         GeoPosition[{55.7936, 13.1233}], 0.5], 
        RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667], 
        Disk[
         GeoPosition[{55.7989, 13.1219}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{55.7967, 13.1044}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{55.8078, 13.1028}], 0.5], 
        RGBColor[
        0.5507179583333334, 0.7353817083333334, 0.40818645833333334`], 
        Disk[
         GeoPosition[{55.8097, 13.1342}], 0.5], 
        RGBColor[
        0.5507179583333334, 0.7353817083333334, 0.40818645833333334`], 
        Disk[
         GeoPosition[{55.8, 13.1367}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.7, 13.2}], 0.5], 
        RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667], 
        Disk[
         GeoPosition[{55.7, 13.2}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.8364, 13.3075}], 0.5], 
        RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667], 
        Disk[
         GeoPosition[{55.8369, 13.3033}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{55.8378, 13.3092}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.8403, 13.3106}], 0.5], 
        RGBColor[
        0.5507179583333334, 0.7353817083333334, 0.40818645833333334`], 
        Disk[
         GeoPosition[{55.8411, 13.3047}], 0.5], 
        RGBColor[
        0.5507179583333334, 0.7353817083333334, 0.40818645833333334`], 
        Disk[
         GeoPosition[{55.8397, 13.2881}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.8369, 13.3181}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.8386, 13.3186}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.8364, 13.2906}], 0.5], 
        RGBColor[
        0.5507179583333334, 0.7353817083333334, 0.40818645833333334`], 
        Disk[
         GeoPosition[{55.8383, 13.2906}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.9336, 13.5519}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.9419, 13.5603}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.9403, 13.5511}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.9392, 13.5539}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{55.9414, 13.5542}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.9428, 13.5558}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.9497, 13.5533}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.9319, 13.5508}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.9281, 13.5481}], 0.5], 
        RGBColor[0.8760126666666667, 0.641456, 0.22989], 
        Disk[
         GeoPosition[{55.9261, 13.5319}], 0.5], 
        RGBColor[0.8760126666666667, 0.641456, 0.22989], 
        Disk[
         GeoPosition[{55.6528, 13.2244}], 0.5], 
        RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
        Disk[
         GeoPosition[{62.6425, 17.7422}], 0.5], 
        RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
        Disk[
         GeoPosition[{62.6422, 17.7406}], 0.5], 
        RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
        Disk[
         GeoPosition[{62.6425, 17.7356}], 0.5], 
        RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
        Disk[
         GeoPosition[{62.6425, 17.7372}], 0.5], 
        RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
        Disk[
         GeoPosition[{62.8714, 18.3447}], 0.5], 
        RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
        Disk[
         GeoPosition[{62.8717, 18.3436}], 0.5], 
        RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
        Disk[
         GeoPosition[{62.8717, 18.3419}], 0.5], 
        RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
        Disk[
         GeoPosition[{62.8719, 18.3422}], 0.5], 
        RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 
        Disk[
         GeoPosition[{62.6322, 17.69}], 0.5], 
        RGBColor[
        0.8994160555555556, 0.43163677777777776`, 0.18763441666666666`], 
        Disk[
         GeoPosition[{62.6322, 17.6906}], 0.5], 
        RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 
        Disk[
         GeoPosition[{62.8892, 18.4522}], 0.5], 
        RGBColor[
        0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 
        Disk[
         GeoPosition[{55.7683, 14.1386}], 0.5], 
        RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
        Disk[
         GeoPosition[{55.7686, 14.1383}], 0.5], 
        RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
        Disk[
         GeoPosition[{55.7689, 14.1375}], 0.5], 
        RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
        Disk[
         GeoPosition[{55.7692, 14.1369}], 0.5], 
        RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
        Disk[
         GeoPosition[{55.7694, 14.1347}], 0.5], 
        RGBColor[0.5556259791666667, 0.7361003541666666, 0.4039107291666667], 
        Disk[
         GeoPosition[{55.7706, 14.1342}], 0.5], 
        RGBColor[0.5556259791666667, 0.7361003541666666, 0.4039107291666667], 
        Disk[
         GeoPosition[{55.7708, 14.1342}], 0.5], 
        RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
        Disk[
         GeoPosition[{55.7708, 14.1331}], 0.5], 
        RGBColor[0.5543171736111111, 0.7359087152777778, 0.4050509236111111], 
        Disk[
         GeoPosition[{55.7719, 14.1211}], 0.5], 
        RGBColor[0.5543171736111111, 0.7359087152777778, 0.4050509236111111], 
        Disk[
         GeoPosition[{55.7717, 14.1206}], 0.5], 
        RGBColor[0.5543171736111111, 0.7359087152777778, 0.4050509236111111], 
        Disk[
         GeoPosition[{55.7714, 14.1208}], 0.5], 
        RGBColor[0.6380844375000001, 0.7433658125, 0.3400189375], 
        Disk[
         GeoPosition[{62.8836, 18.1842}], 0.5], 
        RGBColor[0.6380844375000001, 0.7433658125, 0.3400189375], 
        Disk[
         GeoPosition[{62.8839, 18.1836}], 0.5], 
        RGBColor[0.6198243750000001, 0.743577125, 0.351160375], 
        Disk[
         GeoPosition[{63.0175, 18.3281}], 0.5], 
        RGBColor[0.6198243750000001, 0.743577125, 0.351160375], 
        Disk[
         GeoPosition[{63.0167, 18.3283}], 0.5], 
        RGBColor[0.6380844375000001, 0.7433658125, 0.3400189375], 
        Disk[
         GeoPosition[{63.0169, 18.3283}], 0.5], 
        RGBColor[0.6198243750000001, 0.743577125, 0.351160375], 
        Disk[
         GeoPosition[{63.0172, 18.3283}], 0.5], 
        RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
        Disk[
         GeoPosition[{62.806, 18.1896}], 0.5], 
        RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
        Disk[
         GeoPosition[{62.806, 18.1896}], 0.5], 
        RGBColor[
        0.6462000208333334, 0.7432718958333333, 0.33506718750000003`], 
        Disk[
         GeoPosition[{62.96, 18.2844}], 0.5], 
        RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
        Disk[
         GeoPosition[{62.9611, 18.3589}], 0.5], 
        RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
        Disk[
         GeoPosition[{62.9619, 18.35}], 0.5], 
        RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
        Disk[
         GeoPosition[{62.9619, 18.35}], 0.5], 
        RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
        Disk[
         GeoPosition[{62.9622, 18.35}], 0.5], 
        RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
        Disk[
         GeoPosition[{62.9614, 18.3608}], 0.5], 
        RGBColor[
        0.5507179583333334, 0.7353817083333334, 0.40818645833333334`], 
        Disk[
         GeoPosition[{55.7, 13.2}], 0.5], 
        RGBColor[
        0.8121489322916666, 0.7082988177083334, 0.25463636979166665`], 
        Disk[
         GeoPosition[{56.27373, 13.90045}], 0.5], 
        RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
        Disk[
         GeoPosition[{62.9169, 18.4728}], 0.5], 
        RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
        Disk[
         GeoPosition[{55.5796, 14.3336}], 0.5], 
        RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
        Disk[
         GeoPosition[{55.5796, 14.334}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{55.5796, 14.3336}], 0.5], 
        RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
        Disk[
         GeoPosition[{55.5796, 14.3336}], 0.5], 
        RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
        Disk[
         GeoPosition[{55.5796, 14.3336}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{55.5796, 14.3336}], 0.5], 
        RGBColor[0.8123285234375, 0.7081676015625, 0.2545731796875], 
        Disk[
         GeoPosition[{49.2771, 16.6314}], 0.5], 
        RGBColor[0.8123285234375, 0.7081676015625, 0.2545731796875], 
        Disk[
         GeoPosition[{49.2771, 16.6314}], 0.5], 
        RGBColor[0.8123285234375, 0.7081676015625, 0.2545731796875], 
        Disk[
         GeoPosition[{49.2771, 16.6314}], 0.5], 
        RGBColor[
        0.5536627708333334, 0.7358128958333333, 0.40562102083333335`], 
        Disk[
         GeoPosition[{56.06, 13.97}], 0.5], 
        RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333], 
        Disk[
         GeoPosition[{49.3853, 16.2544}], 0.5], 
        RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666], 
        Disk[
         GeoPosition[{49.3853, 16.2544}], 0.5], 
        RGBColor[
        0.8118795455729166, 0.7084956419270834, 0.25473115494791665`], 
        Disk[
         GeoPosition[{49.3853, 16.2544}], 0.5], 
        RGBColor[0.8899644583333334, 0.3702369166666667, 0.1755905625], 
        Disk[
         GeoPosition[{51.85, 6.4333}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{40.8585, -73.4675}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{40.8585, -73.4675}], 0.5], 
        RGBColor[0.901243875, 0.56671825, 0.213476], 
        Disk[
         GeoPosition[{40.8585, -73.4675}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{42.4489, -76.5072}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{42.4489, -76.5072}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{42.373, -71.0627}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{42.373, -71.0627}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.2816, -86.621}], 0.5], 
        RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666], 
        Disk[
         GeoPosition[{49.5, 73.1}], 0.5], 
        RGBColor[0.901856875, 0.5237642499999999, 0.2053], 
        Disk[
         GeoPosition[{45, 1.3}], 0.5], 
        RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
        Disk[
         GeoPosition[{51.2167, 4.4}], 0.5], 
        RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
        Disk[
         GeoPosition[{63.324, 18.484}], 0.5], 
        RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 
        Disk[
         GeoPosition[{63.324, 18.484}], 0.5], 
        RGBColor[
        0.8124183190104166, 0.7081019934895834, 0.25454158463541665`], 
        Disk[
         GeoPosition[{49.4013, 16.2326}], 0.5], 
        RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
        Disk[
         GeoPosition[{49.2, 16.6166}], 0.5], 
        RGBColor[0.90147375, 0.5506105, 0.21041], 
        Disk[
         GeoPosition[{51.4083, -0.6383}], 0.5], 
        RGBColor[0.9011480937499999, 0.5734298124999999, 0.2147535], 
        Disk[
         GeoPosition[{51.4083, -0.6383}], 0.5], 
        RGBColor[
        0.8994160555555556, 0.43163677777777776`, 0.18763441666666666`], 
        Disk[
         GeoPosition[{38.3, -92.3}], 0.5], 
        RGBColor[0.77217125, 0.72651625, 0.2704135], 
        Disk[
         GeoPosition[{15.1111, -23.6167}], 0.5], 
        RGBColor[0.6380844375000001, 0.7433658125, 0.3400189375], 
        Disk[
         GeoPosition[{62.877, 18.177}], 0.5], 
        RGBColor[
        0.9014782222222222, 0.4450331111111111, 0.19026216666666665`], 
        Disk[
         GeoPosition[{50.3, 6.3}], 0.5], 
        RGBColor[0.6198243750000001, 0.743577125, 0.351160375], 
        Disk[
         GeoPosition[{63.0165, 18.3174}], 0.5], 
        RGBColor[0.6380844375000001, 0.7433658125, 0.3400189375], 
        Disk[
         GeoPosition[{63.0165, 18.3174}], 0.5], 
        RGBColor[
        0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 
        Disk[
         GeoPosition[{50.3, 8}], 0.5], 
        RGBColor[0.8760126666666667, 0.641456, 0.22989], 
        Disk[
         GeoPosition[{51.5338, 9.9355}], 0.5], 
        RGBColor[
        0.8980412777777778, 0.4227058888888889, 0.18588258333333332`], 
        Disk[
         GeoPosition[{50.3, 8}], 0.5], 
        RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
        Disk[
         GeoPosition[{51.4083, -0.6383}], 0.5], 
        RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
        Disk[
         GeoPosition[{51.4083, -0.6383}], 0.5], 
        RGBColor[0.9011289375, 0.574772125, 0.215009], 
        Disk[
         GeoPosition[{44.46, -85.37}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.2816, -86.621}], 0.5], 
        RGBColor[0.71098208984375, 0.74116771484375, 0.2966211171875], 
        Disk[
         GeoPosition[{38.48, 68.49}], 0.5], 
        RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
        Disk[
         GeoPosition[{49.5, 73.1}], 0.5], 
        RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666], 
        Disk[
         GeoPosition[{47.984, 10.8719}], 0.5], 
        RGBColor[0.8737845, 0.25943675, 0.154574125], 
        Disk[
         GeoPosition[{41.59, 2.49}], 0.5], 
        RGBColor[
        0.7959857291666667, 0.7201082708333333, 0.26032347916666665`], 
        Disk[
         GeoPosition[{55.7522, 37.6322}], 0.5], 
        RGBColor[
        0.8994160555555556, 0.43163677777777776`, 0.18763441666666666`], 
        Disk[
         GeoPosition[{50.3, 8.3}], 0.5], 
        RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
        Disk[
         GeoPosition[{51.4083, -0.6383}], 0.5], 
        RGBColor[0.9011002031249999, 0.5767855937499999, 0.21539225], 
        Disk[
         GeoPosition[{51.4083, -0.6383}], 0.5], 
        RGBColor[0.90147375, 0.5506105, 0.21041], 
        Disk[
         GeoPosition[{52.24, 4.45}], 0.5], 
        RGBColor[
        0.8121489322916666, 0.7082988177083334, 0.25463636979166665`], 
        Disk[
         GeoPosition[{49.42, 16.36}], 0.5], 
        RGBColor[
        0.8121489322916666, 0.7082988177083334, 0.25463636979166665`], 
        Disk[
         GeoPosition[{49.42, 16.36}], 0.5], 
        RGBColor[
        0.8121489322916666, 0.7082988177083334, 0.25463636979166665`], 
        Disk[
         GeoPosition[{49.42, 16.36}], 0.5], 
        RGBColor[
        0.8925421666666666, 0.3869823333333333, 0.17887524999999999`], 
        Disk[
         GeoPosition[{46, 3.3}], 0.5], 
        RGBColor[0.9011289375, 0.574772125, 0.215009], 
        Disk[
         GeoPosition[{48.5, -1.41}], 0.5], 
        RGBColor[0.9011289375, 0.574772125, 0.215009], 
        Disk[
         GeoPosition[{48.5, -1.41}], 0.5], 
        RGBColor[0.8737845, 0.25943675, 0.154574125], 
        Disk[
         GeoPosition[{38.3333, -3.53333}], 0.5], 
        RGBColor[0.71098208984375, 0.74116771484375, 0.2966211171875], 
        Disk[
         GeoPosition[{38.35, 68.48}], 0.5], 
        RGBColor[0.9011002031249999, 0.5767855937499999, 0.21539225], 
        Disk[
         GeoPosition[{51.4083, -0.6383}], 0.5], 
        RGBColor[0.90147375, 0.5506105, 0.21041], 
        Disk[
         GeoPosition[{51.4083, -0.6383}], 0.5], 
        RGBColor[
        0.6563445000000001, 0.7431544999999999, 0.32887750000000004`], 
        Disk[
         GeoPosition[{60, 23.5}], 0.5], 
        RGBColor[
        0.6563445000000001, 0.7431544999999999, 0.32887750000000004`], 
        Disk[
         GeoPosition[{60, 23.5}], 0.5], 
        RGBColor[0.8737845, 0.25943675, 0.154574125], 
        Disk[
         GeoPosition[{41.7194, 2.93056}], 0.5], 
        RGBColor[0.8720555, 0.24592825000000001`, 0.152211375], 
        Disk[
         GeoPosition[{41.7194, 2.93056}], 0.5], 
        RGBColor[0.5173434166666667, 0.7304949166666667, 0.4372614166666667], 
        Disk[
         GeoPosition[{56.0648, 13.9707}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{56.0648, 13.9707}], 0.5], 
        RGBColor[
        0.8868712083333333, 0.3501424166666667, 0.17164893750000002`], 
        Disk[
         GeoPosition[{48.3, 14.45}], 0.5], 
        RGBColor[0.8128672968749999, 0.707773953125, 0.254383609375], 
        Disk[
         GeoPosition[{48.3, 14.45}], 0.5], 
        RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 
        Disk[
         GeoPosition[{47.25, 8.26}], 0.5], 
        RGBColor[0.81178975, 0.70856125, 0.25476275], 
        Disk[
         GeoPosition[{52.3, 30}], 0.5], 
        RGBColor[
        0.9014782222222222, 0.4450331111111111, 0.19026216666666665`], 
        Disk[
         GeoPosition[{52.3, 9.3}], 0.5], 
        RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 
        Disk[
         GeoPosition[{49.3853, 16.2544}], 0.5], 
        RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
        Disk[
         GeoPosition[{57.1539, -2.2207}], 0.5], 
        RGBColor[0.888933375, 0.36353875, 0.1742766875], 
        Disk[
         GeoPosition[{48.0683, 7.62551}], 0.5], 
        RGBColor[0.9011002031249999, 0.5767855937499999, 0.21539225], 
        Disk[
         GeoPosition[{54.8, -2.4333}], 0.5], 
        RGBColor[
        0.8868712083333333, 0.3501424166666667, 0.17164893750000002`], 
        Disk[
         GeoPosition[{53.448, 5.73}], 0.5], 
        RGBColor[0.8899644583333334, 0.3702369166666667, 0.1755905625], 
        Disk[
         GeoPosition[{50.3, 5.3}], 0.5], 
        RGBColor[0.8760126666666667, 0.641456, 0.22989], 
        Disk[
         GeoPosition[{51.8333, 5.5833}], 0.5], 
        RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
        Disk[
         GeoPosition[{50.9167, 9.57073}], 0.5], 
        RGBColor[0.8760126666666667, 0.641456, 0.22989], 
        Disk[
         GeoPosition[{51.3333, 6.1}], 0.5], 
        RGBColor[0.888933375, 0.36353875, 0.1742766875], 
        Disk[
         GeoPosition[{47.5, 7.5}], 0.5], 
        RGBColor[
        0.9014782222222222, 0.4450331111111111, 0.19026216666666665`], 
        Disk[
         GeoPosition[{52, 5.675}], 0.5], 
        RGBColor[
        0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 
        Disk[
         GeoPosition[{52.4584, 13.287}], 0.5], 
        RGBColor[
        0.8980412777777778, 0.4227058888888889, 0.18588258333333332`], 
        Disk[
         GeoPosition[{56.5459, -4.79821}], 0.5], 
        RGBColor[
        0.8868712083333333, 0.3501424166666667, 0.17164893750000002`], 
        Disk[
         GeoPosition[{44.5041, 11.3396}], 0.5], 
        RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
        Disk[
         GeoPosition[{54.4, -3.2667}], 0.5], 
        RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
        Disk[
         GeoPosition[{49.5166, 9.3166}], 0.5], 
        RGBColor[
        0.8959791111111111, 0.40930955555555554`, 0.18325483333333334`], 
        Disk[
         GeoPosition[{50.0167, 8.6667}], 0.5], 
        RGBColor[0.266122, 0.486664, 0.802529], 
        Disk[
         GeoPosition[{41.3599, -122.755}], 0.5], 
        RGBColor[
        0.8994160555555556, 0.43163677777777776`, 0.18763441666666666`], 
        Disk[
         GeoPosition[{50.5, 9.5}], 0.5], 
        RGBColor[0.878107, 0.293208, 0.160481], 
        Disk[
         GeoPosition[{54.1, -6.2}], 0.5], 
        RGBColor[0.878107, 0.293208, 0.160481], 
        Disk[
         GeoPosition[{53.2699, -1.64293}], 0.5], 
        RGBColor[
        0.8980412777777778, 0.4227058888888889, 0.18588258333333332`], 
        Disk[
         GeoPosition[{50.2981, 8.26607}], 0.5], 
        RGBColor[0.859088, 0.1446145, 0.13449075], 
        Disk[
         GeoPosition[{29.2144, -13.4811}], 0.5], 
        RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
        Disk[
         GeoPosition[{51.3, 1.1}], 0.5], 
        RGBColor[
        0.8089162916666666, 0.7106607083333333, 0.25577379166666664`], 
        Disk[
         GeoPosition[{37.3, 15}], 0.5], 
        RGBColor[0.9017419375, 0.5318181249999999, 0.20683300000000002`], 
        Disk[
         GeoPosition[{42, 12.1}], 0.5], 
        RGBColor[
        0.8925421666666666, 0.3869823333333333, 0.17887524999999999`], 
        Disk[
         GeoPosition[{48.0717, 1.33867}], 0.5], 
        RGBColor[
        0.7959857291666667, 0.7201082708333333, 0.26032347916666665`], 
        Disk[
         GeoPosition[{53.7502, 34.7361}], 0.5], 
        RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
        Disk[
         GeoPosition[{40.12, -8.25}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{40.2077, -8.42639}], 0.5], 
        RGBColor[0.9011480937499999, 0.5734298124999999, 0.2147535], 
        Disk[
         GeoPosition[{49.416, 2.823}], 0.5], 
        RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
        Disk[
         GeoPosition[{49.8724, 8.65081}], 0.5], 
        RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666], 
        Disk[
         GeoPosition[{47.3239, 5.04278}], 0.5], 
        RGBColor[
        0.8980412777777778, 0.4227058888888889, 0.18588258333333332`], 
        Disk[
         GeoPosition[{50.7224, 8.2372}], 0.5], 
        RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 
        Disk[
         GeoPosition[{49.4167, 16.2667}], 0.5], 
        RGBColor[
        0.8868712083333333, 0.3501424166666667, 0.17164893750000002`], 
        Disk[
         GeoPosition[{51.051, 13.7336}], 0.5], 
        RGBColor[0.9010523125, 0.580141375, 0.216031], 
        Disk[
         GeoPosition[{54.7761, -1.5733}], 0.5], 
        RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
        Disk[
         GeoPosition[{51.3, 0.5}], 0.5], 
        RGBColor[0.90147375, 0.5506105, 0.21041], 
        Disk[
         GeoPosition[{55.9494, -3.16028}], 0.5], 
        RGBColor[
        0.8959791111111111, 0.40930955555555554`, 0.18325483333333334`], 
        Disk[
         GeoPosition[{51.5105, 9.68253}], 0.5], 
        RGBColor[
        0.8980412777777778, 0.4227058888888889, 0.18588258333333332`], 
        Disk[
         GeoPosition[{50, 8.5}], 0.5], 
        RGBColor[
        0.8089162916666666, 0.7106607083333333, 0.25577379166666664`], 
        Disk[
         GeoPosition[{50, 8.5}], 0.5], 
        RGBColor[
        0.9014782222222222, 0.4450331111111111, 0.19026216666666665`], 
        Disk[
         GeoPosition[{49.5955, 11.0087}], 0.5], 
        RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
        Disk[
         GeoPosition[{60.1997, 24.5682}], 0.5], 
        RGBColor[
        0.8884178333333334, 0.3601896666666667, 0.17361975000000002`], 
        Disk[
         GeoPosition[{58.6656, 24.9871}], 0.5], 
        RGBColor[0.901856875, 0.5237642499999999, 0.2053], 
        Disk[
         GeoPosition[{44.6447, 2.56481}], 0.5], 
        RGBColor[
        0.8959791111111111, 0.40930955555555554`, 0.18325483333333334`], 
        Disk[
         GeoPosition[{50.1102, 8.6822}], 0.5], 
        RGBColor[0.8760126666666667, 0.641456, 0.22989], 
        Disk[
         GeoPosition[{50.5, 8.0167}], 0.5], 
        RGBColor[0.8760126666666667, 0.641456, 0.22989], 
        Disk[
         GeoPosition[{51.0167, 5.86667}], 0.5], 
        RGBColor[0.5173434166666667, 0.7304949166666667, 0.4372614166666667], 
        Disk[
         GeoPosition[{50.584, 8.67825}], 0.5], 
        RGBColor[
        0.8868712083333333, 0.3501424166666667, 0.17164893750000002`], 
        Disk[
         GeoPosition[{47, 15.5}], 0.5], 
        RGBColor[0.266122, 0.486664, 0.802529], 
        Disk[
         GeoPosition[{43.178, -85.2532}], 0.5], 
        RGBColor[
        0.8980412777777778, 0.4227058888888889, 0.18588258333333332`], 
        Disk[
         GeoPosition[{53.5, 10.5}], 0.5], 
        RGBColor[0.8760126666666667, 0.641456, 0.22989], 
        Disk[
         GeoPosition[{52.24, 9.44}], 0.5], 
        RGBColor[
        0.8980412777777778, 0.4227058888888889, 0.18588258333333332`], 
        Disk[
         GeoPosition[{52.3721, 9.73569}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{55.675, 12.5686}], 0.5], 
        RGBColor[0.5173434166666667, 0.7304949166666667, 0.4372614166666667], 
        Disk[
         GeoPosition[{51.3472, 8.28844}], 0.5], 
        RGBColor[0.9013205, 0.561349, 0.212454], 
        Disk[
         GeoPosition[{54.4175, 9.88682}], 0.5], 
        RGBColor[
        0.8121489322916666, 0.7082988177083334, 0.25463636979166665`], 
        Disk[
         GeoPosition[{49, 15}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{50.927, 11.587}], 0.5], 
        RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
        Disk[
         GeoPosition[{35, 77}], 0.5], 
        RGBColor[
        0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 
        Disk[
         GeoPosition[{54.8969, 23.8924}], 0.5], 
        RGBColor[0.8760126666666667, 0.641456, 0.22989], 
        Disk[
         GeoPosition[{55.6395, -5.66364}], 0.5], 
        RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
        Disk[
         GeoPosition[{50.95, 6.9666}], 0.5], 
        RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
        Disk[
         GeoPosition[{50.1797, 8.50861}], 0.5], 
        RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333], 
        Disk[
         GeoPosition[{49.631, 11.5722}], 0.5], 
        RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333], 
        Disk[
         GeoPosition[{35.0085, 135.752}], 0.5], 
        RGBColor[
        0.8994160555555556, 0.43163677777777776`, 0.18763441666666666`], 
        Disk[
         GeoPosition[{55.6739, -3.78181}], 0.5], 
        RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666], 
        Disk[
         GeoPosition[{52.7333, 15.2333}], 0.5], 
        RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666], 
        Disk[
         GeoPosition[{47.984, 10.8719}], 0.5], 
        RGBColor[0.867733, 0.212157, 0.1463045], 
        Disk[
         GeoPosition[{48, 0.5}], 0.5], 
        RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333], 
        Disk[
         GeoPosition[{52.1611, 4.49015}], 0.5], 
        RGBColor[0.8122387278645833, 0.7082332096354167, 0.2546047747395833], 
        Disk[
         GeoPosition[{50.3833, 8.0666}], 0.5], 
        RGBColor[
        0.8959791111111111, 0.40930955555555554`, 0.18325483333333334`], 
        Disk[
         GeoPosition[{50.3833, 8.0666}], 0.5], 
        RGBColor[0.8760126666666667, 0.641456, 0.22989], 
        Disk[
         GeoPosition[{50.001, 8.26664}], 0.5], 
        RGBColor[0.266122, 0.486664, 0.802529], 
        Disk[
         GeoPosition[{41.3923, -70.6652}], 0.5], 
        RGBColor[0.81178975, 0.70856125, 0.25476275], 
        Disk[
         GeoPosition[{51.9183, 10.1138}], 0.5], 
        RGBColor[
        0.8980412777777778, 0.4227058888888889, 0.18588258333333332`], 
        Disk[
         GeoPosition[{50.95, 20.5}], 0.5], 
        RGBColor[
        0.8980412777777778, 0.4227058888888889, 0.18588258333333332`], 
        Disk[
         GeoPosition[{50.5, 8.5}], 0.5], 
        RGBColor[0.8232835833333333, 0.7001634166666666, 0.2507185833333333], 
        Disk[
         GeoPosition[{52.6969, 10.981}], 0.5], 
        RGBColor[
        0.8121489322916666, 0.7082988177083334, 0.25463636979166665`], 
        Disk[
         GeoPosition[{51.0581, 13.2995}], 0.5], 
        RGBColor[
        0.8980412777777778, 0.4227058888888889, 0.18588258333333332`], 
        Disk[
         GeoPosition[{50.2, 8.5833}], 0.5], 
        RGBColor[0.5173434166666667, 0.7304949166666667, 0.4372614166666667], 
        Disk[
         GeoPosition[{53.1667, 8.2}], 0.5], 
        RGBColor[
        0.8980412777777778, 0.4227058888888889, 0.18588258333333332`], 
        Disk[
         GeoPosition[{50.3827, 8.01161}], 0.5], 
        RGBColor[0.8760126666666667, 0.641456, 0.22989], 
        Disk[
         GeoPosition[{53.3422, 8.42255}], 0.5], 
        RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
        Disk[
         GeoPosition[{60.385543, 6.193019}], 0.5], 
        RGBColor[
        0.8121489322916666, 0.7082988177083334, 0.25463636979166665`], 
        Disk[
         GeoPosition[{59, 29}], 0.5], 
        RGBColor[0.8876767421875, 0.355375359375, 0.17267540234375], 
        Disk[
         GeoPosition[{47.04, 10.51}], 0.5], 
        RGBColor[0.5173434166666667, 0.7304949166666667, 0.4372614166666667], 
        Disk[
         GeoPosition[{53.476, 10.6065}], 0.5], 
        RGBColor[0.901856875, 0.5237642499999999, 0.2053], 
        Disk[
         GeoPosition[{49.2655, -123.206}], 0.5], 
        RGBColor[0.9011289375, 0.574772125, 0.215009], 
        Disk[
         GeoPosition[{48.0653, -2.96591}], 0.5], 
        RGBColor[0.81178975, 0.70856125, 0.25476275], 
        Disk[
         GeoPosition[{54.3512, -3.41697}], 0.5], 
        RGBColor[0.8760126666666667, 0.641456, 0.22989], 
        Disk[
         GeoPosition[{51.9667, 5.56667}], 0.5], 
        RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
        Disk[
         GeoPosition[{42, 12.1}], 0.5], 
        RGBColor[0.9011480937499999, 0.5734298124999999, 0.2147535], 
        Disk[
         GeoPosition[{49.4424, 1.09849}], 0.5], 
        RGBColor[
        0.9014782222222222, 0.4450331111111111, 0.19026216666666665`], 
        Disk[
         GeoPosition[{56.3, 34}], 0.5], 
        RGBColor[0.7988591875, 0.7180088124999999, 0.2593124375], 
        Disk[
         GeoPosition[{49, 38.28}], 0.5], 
        RGBColor[0.8737845, 0.25943675, 0.154574125], 
        Disk[
         GeoPosition[{41.7833, 3.03333}], 0.5], 
        RGBColor[0.8737845, 0.25943675, 0.154574125], 
        Disk[
         GeoPosition[{41.7833, 3.03333}], 0.5], 
        RGBColor[0.9011289375, 0.574772125, 0.215009], 
        Disk[
         GeoPosition[{47, -122.2}], 0.5], 
        RGBColor[0.8613569062499999, 0.67234559375, 0.23732228125], 
        Disk[
         GeoPosition[{46.5438, 11.5614}], 0.5], 
        RGBColor[
        0.8994160555555556, 0.43163677777777776`, 0.18763441666666666`], 
        Disk[
         GeoPosition[{50.8738, 8.02341}], 0.5], 
        RGBColor[0.90147375, 0.5506105, 0.21041], 
        Disk[
         GeoPosition[{53.6473, -3.00733}], 0.5], 
        RGBColor[
        0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 
        Disk[
         GeoPosition[{52.5339, 13.181}], 0.5], 
        RGBColor[0.888933375, 0.36353875, 0.1742766875], 
        Disk[
         GeoPosition[{47.6667, 9.5}], 0.5], 
        RGBColor[0.5556259791666667, 0.7361003541666666, 0.4039107291666667], 
        Disk[
         GeoPosition[{52.6058, 11.8558}], 0.5], 
        RGBColor[
        0.8089162916666666, 0.7106607083333333, 0.25577379166666664`], 
        Disk[
         GeoPosition[{52, 36}], 0.5], 
        RGBColor[0.8122387278645833, 0.7082332096354167, 0.2546047747395833], 
        Disk[
         GeoPosition[{49.5, 14.5}], 0.5], 
        RGBColor[0.8122387278645833, 0.7082332096354167, 0.2546047747395833], 
        Disk[
         GeoPosition[{47.2413, -122.459}], 0.5], 
        RGBColor[0.8760126666666667, 0.641456, 0.22989], 
        Disk[
         GeoPosition[{52.08, 4.3}], 0.5], 
        RGBColor[
        0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 
        Disk[
         GeoPosition[{56.5, 14.9}], 0.5], 
        RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
        Disk[
         GeoPosition[{41.6639, -83.5553}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.6639, -83.5553}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.6639, -83.5553}], 0.5], 
        RGBColor[0.8875156354166667, 0.35432877083333336`, 0.172470109375], 
        Disk[
         GeoPosition[{47.0748, 9.9042}], 0.5], 
        RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 
        Disk[
         GeoPosition[{34.43, 136.31}], 0.5], 
        RGBColor[0.266122, 0.486664, 0.802529], 
        Disk[
         GeoPosition[{43.2708, -85.2563}], 0.5], 
        RGBColor[0.888933375, 0.36353875, 0.1742766875], 
        Disk[
         GeoPosition[{48.0333, 7.7667}], 0.5], 
        RGBColor[0.8875156354166667, 0.35432877083333336`, 0.172470109375], 
        Disk[
         GeoPosition[{52.0918, 5.1145}], 0.5], 
        RGBColor[0.901856875, 0.5237642499999999, 0.2053], 
        Disk[
         GeoPosition[{49.2655, -123.206}], 0.5], 
        RGBColor[0.8760126666666667, 0.641456, 0.22989], 
        Disk[
         GeoPosition[{52.0333, 5.55}], 0.5], 
        RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
        Disk[
         GeoPosition[{54.9902, -2.3671}], 0.5], 
        RGBColor[
        0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 
        Disk[
         GeoPosition[{52.3, 21}], 0.5], 
        RGBColor[
        0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 
        Disk[
         GeoPosition[{52.3, 30}], 0.5], 
        RGBColor[0.8232835833333333, 0.7001634166666666, 0.2507185833333333], 
        Disk[
         GeoPosition[{52.6, 10.0667}], 0.5], 
        RGBColor[
        0.8877411848958333, 0.3557939947916667, 0.17275751953125001`], 
        Disk[
         GeoPosition[{47.9299, 10.8134}], 0.5], 
        RGBColor[0.8125081145833333, 0.7080363854166667, 0.2545099895833333], 
        Disk[
         GeoPosition[{54.6833, 25.3167}], 0.5], 
        RGBColor[
        0.8959791111111111, 0.40930955555555554`, 0.18325483333333334`], 
        Disk[
         GeoPosition[{49.7878, 9.9361}], 0.5], 
        RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
        Disk[
         GeoPosition[{37.45, -119.35}], 0.5], 
        RGBColor[0.8899644583333334, 0.3702369166666667, 0.1755905625], 
        Disk[
         GeoPosition[{47.3667, 8.55}], 0.5], 
        RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 
        Disk[
         GeoPosition[{47.3667, 8.55}], 0.5], 
        RGBColor[
        0.9014782222222222, 0.4450331111111111, 0.19026216666666665`], 
        Disk[
         GeoPosition[{50.3058, 8.32213}], 0.5], 
        RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333], 
        Disk[
         GeoPosition[{49.2, 16.6166}], 0.5], 
        RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 
        Disk[
         GeoPosition[{48.6167, 6.25}], 0.5], 
        RGBColor[0.57231325, 0.73854375, 0.38937325], 
        Disk[
         GeoPosition[{49, 15}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.767, -72.677}], 0.5], 
        RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 
        Disk[
         GeoPosition[{41.7302, -71.2825}], 0.5], 
        RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
        Disk[
         GeoPosition[{41.5609, -86.4251}], 0.5], 
        RGBColor[0.266122, 0.486664, 0.802529], 
        Disk[
         GeoPosition[{41.5609, -86.4251}], 0.5], 
        RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
        Disk[
         GeoPosition[{55.58, 14.334}], 0.5], 
        RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
        Disk[
         GeoPosition[{55.58, 14.334}], 0.5], 
        RGBColor[
        0.8124183190104166, 0.7081019934895834, 0.25454158463541665`], 
        Disk[
         GeoPosition[{49.38, 16.81}], 0.5], 
        RGBColor[
        0.8124183190104166, 0.7081019934895834, 0.25454158463541665`], 
        Disk[
         GeoPosition[{49.38, 16.81}], 0.5], 
        RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
        Disk[
         GeoPosition[{42.0945, -86.3253}], 0.5], 
        RGBColor[0.901090625, 0.57745675, 0.21552000000000002`], 
        Disk[
         GeoPosition[{42.036, -86.511}], 0.5], 
        RGBColor[0.901243875, 0.56671825, 0.213476], 
        Disk[
         GeoPosition[{42.0333, -86.5128}], 0.5], 
        RGBColor[0.901243875, 0.56671825, 0.213476], 
        Disk[
         GeoPosition[{42.0333, -86.5128}], 0.5], 
        RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
        Disk[
         GeoPosition[{42.093, -86.359}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{42.093, -86.359}], 0.5], 
        RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
        Disk[
         GeoPosition[{41.273, -86.625}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.273, -86.625}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.273, -86.625}], 0.5], 
        RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
        Disk[
         GeoPosition[{42.0945, -86.3253}], 0.5], 
        RGBColor[0.9011289375, 0.574772125, 0.215009], 
        Disk[
         GeoPosition[{42.0945, -86.3253}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.3423, -86.7368}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.3423, -86.7368}], 0.5], 
        RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
        Disk[
         GeoPosition[{41.3423, -86.7368}], 0.5], 
        RGBColor[0.901243875, 0.56671825, 0.213476], 
        Disk[
         GeoPosition[{42.036, -86.511}], 0.5], 
        RGBColor[0.901090625, 0.57745675, 0.21552000000000002`], 
        Disk[
         GeoPosition[{42.036, -86.511}], 0.5], 
        RGBColor[0.9011480937499999, 0.5734298124999999, 0.2147535], 
        Disk[
         GeoPosition[{49, 2}], 0.5], 
        RGBColor[0.5543171736111111, 0.7359087152777778, 0.4050509236111111], 
        Disk[
         GeoPosition[{56.0328, 14.775}], 0.5], 
        RGBColor[0.6441711250000001, 0.743295375, 0.33630512500000004`], 
        Disk[
         GeoPosition[{62.7989, 17.9103}], 0.5], 
        RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
        Disk[
         GeoPosition[{56.68, 16.5}], 0.5], 
        RGBColor[0.8232835833333333, 0.7001634166666666, 0.2507185833333333], 
        Disk[
         GeoPosition[{56.3, 16}], 0.5], 
        RGBColor[0.266122, 0.486664, 0.802529], 
        Disk[
         GeoPosition[{41.1876, -87.1923}], 0.5], 
        RGBColor[0.5556259791666667, 0.7361003541666666, 0.4039107291666667], 
        Disk[
         GeoPosition[{56.4606, 15.8127}], 0.5], 
        RGBColor[
        0.8121489322916666, 0.7082988177083334, 0.25463636979166665`], 
        Disk[
         GeoPosition[{48.8, 17.1}], 0.5], 
        RGBColor[
        0.8118795455729166, 0.7084956419270834, 0.25473115494791665`], 
        Disk[
         GeoPosition[{49.33, 15.76}], 0.5], 
        RGBColor[
        0.5507179583333334, 0.7353817083333334, 0.40818645833333334`], 
        Disk[
         GeoPosition[{55.8, 13.1}], 0.5], 
        RGBColor[
        0.9014782222222222, 0.4450331111111111, 0.19026216666666665`], 
        Disk[
         GeoPosition[{51.15, 0.4}], 0.5], 
        RGBColor[
        0.8959791111111111, 0.40930955555555554`, 0.18325483333333334`], 
        Disk[
         GeoPosition[{51, 7}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{55.705, 13.196}], 0.5], 
        RGBColor[0.8232835833333333, 0.7001634166666666, 0.2507185833333333], 
        Disk[
         GeoPosition[{55.9473, 13.821}], 0.5], 
        RGBColor[
        0.5536627708333334, 0.7358128958333333, 0.40562102083333335`], 
        Disk[
         GeoPosition[{56.1494, 15.7884}], 0.5], 
        RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
        Disk[
         GeoPosition[{43.7703, 11.2547}], 0.5], 
        RGBColor[0.859088, 0.1446145, 0.13449075], 
        Disk[
         GeoPosition[{48.6103, 2.3086}], 0.5], 
        RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
        Disk[
         GeoPosition[{35, -79.18}], 0.5], 
        RGBColor[0.8760126666666667, 0.641456, 0.22989], 
        Disk[
         GeoPosition[{56.07, 13.74}], 0.5], 
        RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
        Disk[
         GeoPosition[{57.7, 15.8}], 0.5], 
        RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
        Disk[
         GeoPosition[{56.4, 12.9}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{56.4, 12.9}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{56.4, 12.9}], 0.5], 
        RGBColor[0.8720555, 0.24592825000000001`, 0.152211375], 
        Disk[
         GeoPosition[{41.6833, 2.8}], 0.5], 
        RGBColor[0.5556259791666667, 0.7361003541666666, 0.4039107291666667], 
        Disk[
         GeoPosition[{55.76, 14.12}], 0.5], 
        RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333], 
        Disk[
         GeoPosition[{49.4112, 16.2815}], 0.5], 
        RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 
        Disk[
         GeoPosition[{49.4112, 16.2815}], 0.5], 
        RGBColor[
        0.8089162916666666, 0.7106607083333333, 0.25577379166666664`], 
        Disk[
         GeoPosition[{50, 8.5}], 0.5], 
        RGBColor[
        0.8925421666666666, 0.3869823333333333, 0.17887524999999999`], 
        Disk[
         GeoPosition[{46.5, 6.08}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{56.1, 13.74}], 0.5], 
        RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
        Disk[
         GeoPosition[{56.1, 13.74}], 0.5], 
        RGBColor[0.9025465, 0.475441, 0.196102], 
        Disk[
         GeoPosition[{47.5, 11.5}], 0.5], 
        RGBColor[
        0.8959791111111111, 0.40930955555555554`, 0.18325483333333334`], 
        Disk[
         GeoPosition[{50.5, 7.5}], 0.5], 
        RGBColor[0.5530083680555555, 0.735717076388889, 0.4061911180555556], 
        Disk[
         GeoPosition[{56.0328, 14.775}], 0.5], 
        RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
        Disk[
         GeoPosition[{55.71, 13.2}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.71, 13.2}], 0.5], 
        RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
        Disk[
         GeoPosition[{44, 12.37}], 0.5], 
        RGBColor[
        0.8980412777777778, 0.4227058888888889, 0.18588258333333332`], 
        Disk[
         GeoPosition[{47.5, 1.5}], 0.5], 
        RGBColor[
        0.6563445000000001, 0.7431544999999999, 0.32887750000000004`], 
        Disk[
         GeoPosition[{60.25, 18.37}], 0.5], 
        RGBColor[
        0.7959857291666667, 0.7201082708333333, 0.26032347916666665`], 
        Disk[
         GeoPosition[{58, 56.3167}], 0.5], 
        RGBColor[0.8737845, 0.25943675, 0.154574125], 
        Disk[
         GeoPosition[{41.5, 2.25}], 0.5], 
        RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333], 
        Disk[
         GeoPosition[{49, 16}], 0.5], 
        RGBColor[
        0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 
        Disk[
         GeoPosition[{50.5, 8.5}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.6942, 13.4504}], 0.5], 
        RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 
        Disk[
         GeoPosition[{62.69, 18}], 0.5], 
        RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 
        Disk[
         GeoPosition[{58.9, 11.2}], 0.5], 
        RGBColor[
        0.9014782222222222, 0.4450331111111111, 0.19026216666666665`], 
        Disk[
         GeoPosition[{59, 18}], 0.5], 
        RGBColor[
        0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 
        Disk[
         GeoPosition[{54.6833, 25.3167}], 0.5], 
        RGBColor[
        0.9014782222222222, 0.4450331111111111, 0.19026216666666665`], 
        Disk[
         GeoPosition[{50.0667, 8.5333}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{56.06, 14.29}], 0.5], 
        RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
        Disk[
         GeoPosition[{35, 77}], 0.5], 
        RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
        Disk[
         GeoPosition[{56.06, 13.97}], 0.5], 
        RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
        Disk[
         GeoPosition[{56.0648, 13.9707}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.6862, -86.8513}], 0.5], 
        RGBColor[0.36048, 0.655759, 0.645692], 
        Disk[
         GeoPosition[{41.6862, -86.8513}], 0.5], 
        RGBColor[0.250728, 0.225386, 0.769152], 
        Disk[
         GeoPosition[{42.0945, -86.3253}], 0.5], 
        RGBColor[0.250728, 0.225386, 0.769152], 
        Disk[
         GeoPosition[{42.0945, -86.3253}], 0.5], 
        RGBColor[0.901243875, 0.56671825, 0.213476], 
        Disk[
         GeoPosition[{42.036, -86.511}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{56.1, 13.9167}], 0.5], 
        RGBColor[0.57231325, 0.73854375, 0.38937325], 
        Disk[
         GeoPosition[{57.75, 16.6333}], 0.5], 
        RGBColor[0.9020484375, 0.510341125, 0.202745], 
        Disk[
         GeoPosition[{38.6536, 48.7992}], 0.5], 
        RGBColor[0.9019718125, 0.5157103749999999, 0.203767], 
        Disk[
         GeoPosition[{38.6536, 48.7992}], 0.5], 
        RGBColor[0.9019718125, 0.5157103749999999, 0.203767], 
        Disk[
         GeoPosition[{38.6536, 48.7992}], 0.5], 
        RGBColor[0.9019718125, 0.5157103749999999, 0.203767], 
        Disk[
         GeoPosition[{38.7406, 48.6131}], 0.5], 
        RGBColor[0.9019718125, 0.5157103749999999, 0.203767], 
        Disk[
         GeoPosition[{38.7406, 48.6131}], 0.5], 
        RGBColor[0.902010125, 0.51302575, 0.203256], 
        Disk[
         GeoPosition[{38.7833, 48.5517}], 0.5], 
        RGBColor[0.9019718125, 0.5157103749999999, 0.203767], 
        Disk[
         GeoPosition[{38.7833, 48.5517}], 0.5], 
        RGBColor[0.902010125, 0.51302575, 0.203256], 
        Disk[
         GeoPosition[{38.7833, 48.5517}], 0.5], 
        RGBColor[0.902010125, 0.51302575, 0.203256], 
        Disk[
         GeoPosition[{38.7833, 48.5517}], 0.5], 
        RGBColor[0.9019718125, 0.5157103749999999, 0.203767], 
        Disk[
         GeoPosition[{38.9522, 48.925}], 0.5], 
        RGBColor[0.9020484375, 0.510341125, 0.202745], 
        Disk[
         GeoPosition[{38.9522, 48.925}], 0.5], 
        RGBColor[0.9020484375, 0.510341125, 0.202745], 
        Disk[
         GeoPosition[{38.9786, 48.5594}], 0.5], 
        RGBColor[0.9020484375, 0.510341125, 0.202745], 
        Disk[
         GeoPosition[{38.9786, 48.5594}], 0.5], 
        RGBColor[0.9022016875, 0.49960262499999997`, 0.200701], 
        Disk[
         GeoPosition[{41.8296, 46.2831}], 0.5], 
        RGBColor[0.9022016875, 0.49960262499999997`, 0.200701], 
        Disk[
         GeoPosition[{41.8296, 46.2831}], 0.5], 
        RGBColor[0.9022016875, 0.49960262499999997`, 0.200701], 
        Disk[
         GeoPosition[{41.8296, 46.2831}], 0.5], 
        RGBColor[0.9022016875, 0.49960262499999997`, 0.200701], 
        Disk[
         GeoPosition[{41.8296, 46.2831}], 0.5], 
        RGBColor[0.9022016875, 0.49960262499999997`, 0.200701], 
        Disk[
         GeoPosition[{41.8296, 46.2831}], 0.5], 
        RGBColor[0.9022016875, 0.49960262499999997`, 0.200701], 
        Disk[
         GeoPosition[{41.8296, 46.2831}], 0.5], 
        RGBColor[0.9021250625, 0.504971875, 0.20172299999999999`], 
        Disk[
         GeoPosition[{41.8296, 46.2831}], 0.5], 
        RGBColor[0.9021250625, 0.504971875, 0.20172299999999999`], 
        Disk[
         GeoPosition[{41.8296, 46.2831}], 0.5], 
        RGBColor[0.9021250625, 0.504971875, 0.20172299999999999`], 
        Disk[
         GeoPosition[{41.8296, 46.2831}], 0.5], 
        RGBColor[0.9021250625, 0.504971875, 0.20172299999999999`], 
        Disk[
         GeoPosition[{41.8296, 46.2831}], 0.5], 
        RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
        Disk[
         GeoPosition[{41.7942, 43.4767}], 0.5], 
        RGBColor[
        0.7078352187500001, 0.7419212187499999, 0.29796893750000003`], 
        Disk[
         GeoPosition[{40.1408, 44.8203}], 0.5], 
        RGBColor[
        0.7078352187500001, 0.7419212187499999, 0.29796893750000003`], 
        Disk[
         GeoPosition[{39.8692, 45.3622}], 0.5], 
        RGBColor[
        0.7078352187500001, 0.7419212187499999, 0.29796893750000003`], 
        Disk[
         GeoPosition[{39.8692, 45.3622}], 0.5], 
        RGBColor[
        0.7078352187500001, 0.7419212187499999, 0.29796893750000003`], 
        Disk[
         GeoPosition[{39.8692, 45.3622}], 0.5], 
        RGBColor[
        0.7078352187500001, 0.7419212187499999, 0.29796893750000003`], 
        Disk[
         GeoPosition[{39.8692, 45.3622}], 0.5], 
        RGBColor[
        0.7078352187500001, 0.7419212187499999, 0.29796893750000003`], 
        Disk[
         GeoPosition[{39.8692, 45.3622}], 0.5], 
        RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
        Disk[
         GeoPosition[{55.9681, -3.21833}], 0.5], 
        RGBColor[
        0.8925421666666666, 0.3869823333333333, 0.17887524999999999`], 
        Disk[
         GeoPosition[{57.9, -5.1525}], 0.5], 
        RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
        Disk[
         GeoPosition[{57.9672, -3.96722}], 0.5], 
        RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
        Disk[
         GeoPosition[{62.8622, 18.336}], 0.5], 
        RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
        Disk[
         GeoPosition[{62.8622, 18.336}], 0.5], 
        RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
        Disk[
         GeoPosition[{62.8698, 18.381}], 0.5], 
        RGBColor[0.57231325, 0.73854375, 0.38937325], 
        Disk[
         GeoPosition[{62.8794, 18.4473}], 0.5], 
        RGBColor[
        0.5536627708333334, 0.7358128958333333, 0.40562102083333335`], 
        Disk[
         GeoPosition[{57.7133, 15.0689}], 0.5], 
        RGBColor[0.57231325, 0.73854375, 0.38937325], 
        Disk[
         GeoPosition[{57.3089, 18.1512}], 0.5], 
        RGBColor[
        0.8017326458333333, 0.7159093541666667, 0.25830139583333334`], 
        Disk[
         GeoPosition[{57.2608, 16.3675}], 0.5], 
        RGBColor[
        0.8017326458333333, 0.7159093541666667, 0.25830139583333334`], 
        Disk[
         GeoPosition[{57.2608, 16.3675}], 0.5], 
        RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
        Disk[
         GeoPosition[{62.9147, 18.4045}], 0.5], 
        RGBColor[
        0.5536627708333334, 0.7358128958333333, 0.40562102083333335`], 
        Disk[
         GeoPosition[{57.6781, 14.9986}], 0.5], 
        RGBColor[
        0.8017326458333333, 0.7159093541666667, 0.25830139583333334`], 
        Disk[
         GeoPosition[{57.6781, 14.9986}], 0.5], 
        RGBColor[0.6198243750000001, 0.743577125, 0.351160375], 
        Disk[
         GeoPosition[{63.016, 18.3175}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.7488, 13.3742}], 0.5], 
        RGBColor[0.57231325, 0.73854375, 0.38937325], 
        Disk[
         GeoPosition[{55.8106, 14.2091}], 0.5], 
        RGBColor[0.57231325, 0.73854375, 0.38937325], 
        Disk[
         GeoPosition[{55.8106, 14.2091}], 0.5], 
        RGBColor[0.57231325, 0.73854375, 0.38937325], 
        Disk[
         GeoPosition[{55.8106, 14.2091}], 0.5], 
        RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
        Disk[
         GeoPosition[{62.806, 18.1896}], 0.5], 
        RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
        Disk[
         GeoPosition[{62.806, 18.1896}], 0.5], 
        RGBColor[
        0.8017326458333333, 0.7159093541666667, 0.25830139583333334`], 
        Disk[
         GeoPosition[{57.3263, 15.8979}], 0.5], 
        RGBColor[
        0.8017326458333333, 0.7159093541666667, 0.25830139583333334`], 
        Disk[
         GeoPosition[{57.3263, 15.8979}], 0.5], 
        RGBColor[
        0.8017326458333333, 0.7159093541666667, 0.25830139583333334`], 
        Disk[
         GeoPosition[{57.3263, 15.8979}], 0.5], 
        RGBColor[0.57231325, 0.73854375, 0.38937325], 
        Disk[
         GeoPosition[{56.5804, 16.4063}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{57.5089, 15.0105}], 0.5], 
        RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
        Disk[
         GeoPosition[{55.4234, 13.9905}], 0.5], 
        RGBColor[
        0.5536627708333334, 0.7358128958333333, 0.40562102083333335`], 
        Disk[
         GeoPosition[{57.8765, 14.8549}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{55.7491, 13.399}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.7491, 13.399}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{55.7491, 13.399}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{56.047, 13.9519}], 0.5], 
        RGBColor[0.5530083680555555, 0.735717076388889, 0.4061911180555556], 
        Disk[
         GeoPosition[{56.0573, 14.302}], 0.5], 
        RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
        Disk[
         GeoPosition[{57.2746, 16.1494}], 0.5], 
        RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
        Disk[
         GeoPosition[{57.2746, 16.1494}], 0.5], 
        RGBColor[0.57231325, 0.73854375, 0.38937325], 
        Disk[
         GeoPosition[{57.7215, 18.3837}], 0.5], 
        RGBColor[0.5530083680555555, 0.735717076388889, 0.4061911180555556], 
        Disk[
         GeoPosition[{55.9745, 14.3997}], 0.5], 
        RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
        Disk[
         GeoPosition[{62.8815, 18.4055}], 0.5], 
        RGBColor[
        0.6462000208333334, 0.7432718958333333, 0.33506718750000003`], 
        Disk[
         GeoPosition[{62.9513, 18.2763}], 0.5], 
        RGBColor[0.5530083680555555, 0.735717076388889, 0.4061911180555556], 
        Disk[
         GeoPosition[{56.1633, 14.6806}], 0.5], 
        RGBColor[0.5530083680555555, 0.735717076388889, 0.4061911180555556], 
        Disk[
         GeoPosition[{56.1633, 14.6806}], 0.5], 
        RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
        Disk[
         GeoPosition[{55.5678, 14.3398}], 0.5], 
        RGBColor[
        0.5585707916666667, 0.7365315416666667, 0.40134529166666666`], 
        Disk[
         GeoPosition[{57.2545, 18.2109}], 0.5], 
        RGBColor[
        0.5585707916666667, 0.7365315416666667, 0.40134529166666666`], 
        Disk[
         GeoPosition[{57.2545, 18.2109}], 0.5], 
        RGBColor[
        0.5585707916666667, 0.7365315416666667, 0.40134529166666666`], 
        Disk[
         GeoPosition[{57.2545, 18.2109}], 0.5], 
        RGBColor[
        0.5585707916666667, 0.7365315416666667, 0.40134529166666666`], 
        Disk[
         GeoPosition[{57.8009, 18.5162}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{57.8009, 18.5162}], 0.5], 
        RGBColor[
        0.5585707916666667, 0.7365315416666667, 0.40134529166666666`], 
        Disk[
         GeoPosition[{57.8009, 18.5162}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{57.6511, 14.8043}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{56.0648, 13.9707}], 0.5], 
        RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
        Disk[
         GeoPosition[{55.5796, 14.3336}], 0.5], 
        RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
        Disk[
         GeoPosition[{55.4242, 13.8484}], 0.5], 
        RGBColor[0.9011480937499999, 0.5734298124999999, 0.2147535], 
        Disk[
         GeoPosition[{55.8877, -3.21072}], 0.5], 
        RGBColor[0.8582235, 0.13786025, 0.133309375], 
        Disk[
         GeoPosition[{40.11, -7.47}], 0.5], 
        RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
        Disk[
         GeoPosition[{38.45, -7.5}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{40.04, -7.11}], 0.5], 
        RGBColor[0.863194375, 0.17669718750000002`, 0.14010228125000002`], 
        Disk[
         GeoPosition[{39.29, -7.4}], 0.5], 
        RGBColor[0.8627621249999999, 0.17332006249999998`, 0.13951159375], 
        Disk[
         GeoPosition[{38.75, -7.59}], 0.5], 
        RGBColor[0.863194375, 0.17669718750000002`, 0.14010228125000002`], 
        Disk[
         GeoPosition[{38.53, -8.02}], 0.5], 
        RGBColor[0.8627621249999999, 0.17332006249999998`, 0.13951159375], 
        Disk[
         GeoPosition[{38.22, -7.84}], 0.5], 
        RGBColor[0.86384275, 0.181762875, 0.1409883125], 
        Disk[
         GeoPosition[{38.77, -4.07}], 0.5], 
        RGBColor[0.8627621249999999, 0.17332006249999998`, 0.13951159375], 
        Disk[
         GeoPosition[{39.15, -4.54}], 0.5], 
        RGBColor[0.863194375, 0.17669718750000002`, 0.14010228125000002`], 
        Disk[
         GeoPosition[{39.72, -6.89}], 0.5], 
        RGBColor[0.8599525, 0.15136875, 0.135672125], 
        Disk[
         GeoPosition[{42.19, -7.8}], 0.5], 
        RGBColor[0.8772424999999999, 0.28645375, 0.159299625], 
        Disk[
         GeoPosition[{39.88, -0.36}], 0.5], 
        RGBColor[0.8737845, 0.25943675, 0.154574125], 
        Disk[
         GeoPosition[{41.94, 2.64}], 0.5], 
        RGBColor[
        0.8587998333333333, 0.14236308333333333`, 0.13409695833333332`], 
        Disk[
         GeoPosition[{41.7, -3.68}], 0.5], 
        RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
        Disk[
         GeoPosition[{41.43, 2.13}], 0.5], 
        RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
        Disk[
         GeoPosition[{36.52, -5.27}], 0.5], 
        RGBColor[0.86384275, 0.181762875, 0.1409883125], 
        Disk[
         GeoPosition[{38.37, -2.66}], 0.5], 
        RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
        Disk[
         GeoPosition[{42.52, -0.56}], 0.5], 
        RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
        Disk[
         GeoPosition[{42.49, 0.54}], 0.5], 
        RGBColor[0.8737845, 0.25943675, 0.154574125], 
        Disk[
         GeoPosition[{41.54, 2.39}], 0.5], 
        RGBColor[
        0.8576471666666666, 0.13335741666666667`, 0.13252179166666667`], 
        Disk[
         GeoPosition[{40.37, -5.74}], 0.5], 
        RGBColor[0.8772424999999999, 0.28645375, 0.159299625], 
        Disk[
         GeoPosition[{40.94, -1.37}], 0.5], 
        RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
        Disk[
         GeoPosition[{36.97, -3.36}], 0.5], 
        RGBColor[0.86297825, 0.17500862500000003`, 0.1398069375], 
        Disk[
         GeoPosition[{38.25, -4.32}], 0.5], 
        RGBColor[0.861465375, 0.1631886875, 0.13773953125], 
        Disk[
         GeoPosition[{41.21, -4.54}], 0.5], 
        RGBColor[0.86124925, 0.161500125, 0.1374441875], 
        Disk[
         GeoPosition[{42.23, -4.64}], 0.5], 
        RGBColor[0.77217125, 0.72651625, 0.2704135], 
        Disk[
         GeoPosition[{41.15, -4.32}], 0.5], 
        RGBColor[
        0.8608890416666667, 0.15868585416666667`, 0.13695194791666665`], 
        Disk[
         GeoPosition[{40.05, -4.65}], 0.5], 
        RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
        Disk[
         GeoPosition[{42.31, 3.19}], 0.5], 
        RGBColor[0.8772424999999999, 0.28645375, 0.159299625], 
        Disk[
         GeoPosition[{40.83, -2}], 0.5], 
        RGBColor[0.863194375, 0.17669718750000002`, 0.14010228125000002`], 
        Disk[
         GeoPosition[{38.07, -6.66}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{40.29, -6.67}], 0.5], 
        RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
        Disk[
         GeoPosition[{41.81, 2.34}], 0.5], 
        RGBColor[0.863194375, 0.17669718750000002`, 0.14010228125000002`], 
        Disk[
         GeoPosition[{38.26, -5.42}], 0.5], 
        RGBColor[0.77217125, 0.72651625, 0.2704135], 
        Disk[
         GeoPosition[{40.79, -4.05}], 0.5], 
        RGBColor[0.77217125, 0.72651625, 0.2704135], 
        Disk[
         GeoPosition[{36.77, -5.39}], 0.5], 
        RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
        Disk[
         GeoPosition[{39.4, -5.33}], 0.5], 
        RGBColor[0.77217125, 0.72651625, 0.2704135], 
        Disk[
         GeoPosition[{39.4, -5.78}], 0.5], 
        RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
        Disk[
         GeoPosition[{40.82, -1.68}], 0.5], 
        RGBColor[0.8720555, 0.24592825000000001`, 0.152211375], 
        Disk[
         GeoPosition[{41.67, 2.62}], 0.5], 
        RGBColor[0.86124925, 0.161500125, 0.1374441875], 
        Disk[
         GeoPosition[{40.4, -5}], 0.5], 
        RGBColor[
        0.6563445000000001, 0.7431544999999999, 0.32887750000000004`], 
        Disk[
         GeoPosition[{42.23, -3.69}], 0.5], 
        RGBColor[
        0.6563445000000001, 0.7431544999999999, 0.32887750000000004`], 
        Disk[
         GeoPosition[{43.05, -5.37}], 0.5], 
        RGBColor[0.8582235, 0.13786025, 0.133309375], 
        Disk[
         GeoPosition[{42.28, -5.92}], 0.5], 
        RGBColor[0.861465375, 0.1631886875, 0.13773953125], 
        Disk[
         GeoPosition[{40.87, -4.5}], 0.5], 
        RGBColor[0.861465375, 0.1631886875, 0.13773953125], 
        Disk[
         GeoPosition[{41.58, -4.71}], 0.5], 
        RGBColor[0.77217125, 0.72651625, 0.2704135], 
        Disk[
         GeoPosition[{38.86, -3.16}], 0.5], 
        RGBColor[0.77217125, 0.72651625, 0.2704135], 
        Disk[
         GeoPosition[{39.58, -3.93}], 0.5], 
        RGBColor[
        0.8608890416666667, 0.15868585416666667`, 0.13695194791666665`], 
        Disk[
         GeoPosition[{39.66, -4.34}], 0.5], 
        RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
        Disk[
         GeoPosition[{42.46, 0.7}], 0.5], 
        RGBColor[
        0.8587998333333333, 0.14236308333333333`, 0.13409695833333332`], 
        Disk[
         GeoPosition[{41.57, -5.64}], 0.5], 
        RGBColor[0.86384275, 0.181762875, 0.1409883125], 
        Disk[
         GeoPosition[{38.06, -4.38}], 0.5], 
        RGBColor[0.863194375, 0.17669718750000002`, 0.14010228125000002`], 
        Disk[
         GeoPosition[{38.19, -6.24}], 0.5], 
        RGBColor[
        0.8576471666666666, 0.13335741666666667`, 0.13252179166666667`], 
        Disk[
         GeoPosition[{40.71, -5.04}], 0.5], 
        RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
        Disk[
         GeoPosition[{41.67, 2}], 0.5], 
        RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
        Disk[
         GeoPosition[{40.45, -1.6}], 0.5], 
        RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
        Disk[
         GeoPosition[{42.97, -1.23}], 0.5], 
        RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
        Disk[
         GeoPosition[{42.34, 1.3}], 0.5], 
        RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
        Disk[
         GeoPosition[{42.76, -0.23}], 0.5], 
        RGBColor[0.8599525, 0.15136875, 0.135672125], 
        Disk[
         GeoPosition[{42.87, -6.45}], 0.5], 
        RGBColor[0.8634105, 0.17838575, 0.140397625], 
        Disk[
         GeoPosition[{43.28, -6.01}], 0.5], 
        RGBColor[0.8737845, 0.25943675, 0.154574125], 
        Disk[
         GeoPosition[{41.86, 2.99}], 0.5], 
        RGBColor[0.86384275, 0.181762875, 0.1409883125], 
        Disk[
         GeoPosition[{38.6, -2.7}], 0.5], 
        RGBColor[
        0.8587998333333333, 0.14236308333333333`, 0.13409695833333332`], 
        Disk[
         GeoPosition[{40.86, -4.11}], 0.5], 
        RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
        Disk[
         GeoPosition[{42.34, 2.17}], 0.5], 
        RGBColor[0.8582235, 0.13786025, 0.133309375], 
        Disk[
         GeoPosition[{42.13, -6.7}], 0.5], 
        RGBColor[0.86384275, 0.181762875, 0.1409883125], 
        Disk[
         GeoPosition[{38.33, -3.51}], 0.5], 
        RGBColor[0.8582235, 0.13786025, 0.133309375], 
        Disk[
         GeoPosition[{42.84, -5.12}], 0.5], 
        RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
        Disk[
         GeoPosition[{41.48, -1.63}], 0.5], 
        RGBColor[0.77217125, 0.72651625, 0.2704135], 
        Disk[
         GeoPosition[{37.09, -3.38}], 0.5], 
        RGBColor[0.86211375, 0.168254375, 0.1386255625], 
        Disk[
         GeoPosition[{41.19, -3.58}], 0.5], 
        RGBColor[0.8599525, 0.15136875, 0.135672125], 
        Disk[
         GeoPosition[{43.4, -7.39}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{41.03, -3.27}], 0.5], 
        RGBColor[0.86124925, 0.161500125, 0.1374441875], 
        Disk[
         GeoPosition[{41.5, -1.88}], 0.5], 
        RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
        Disk[
         GeoPosition[{42.11, 0.6}], 0.5], 
        RGBColor[
        0.8587998333333333, 0.14236308333333333`, 0.13409695833333332`], 
        Disk[
         GeoPosition[{41.6, -2.83}], 0.5], 
        RGBColor[0.8599525, 0.15136875, 0.135672125], 
        Disk[
         GeoPosition[{43.37, -5.49}], 0.5], 
        RGBColor[0.859088, 0.1446145, 0.13449075], 
        Disk[
         GeoPosition[{42.86, -3.59}], 0.5], 
        RGBColor[0.86211375, 0.168254375, 0.1386255625], 
        Disk[
         GeoPosition[{42.1, -5.44}], 0.5], 
        RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
        Disk[
         GeoPosition[{42.26, -2.99}], 0.5], 
        RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
        Disk[
         GeoPosition[{42.04, 1.01}], 0.5], 
        RGBColor[
        0.8576471666666666, 0.13335741666666667`, 0.13252179166666667`], 
        Disk[
         GeoPosition[{40.89, -5.5}], 0.5], 
        RGBColor[0.8582235, 0.13786025, 0.133309375], 
        Disk[
         GeoPosition[{41.95, -7.45}], 0.5], 
        RGBColor[0.86211375, 0.168254375, 0.1386255625], 
        Disk[
         GeoPosition[{42.31, -2.53}], 0.5], 
        RGBColor[0.77217125, 0.72651625, 0.2704135], 
        Disk[
         GeoPosition[{41.88, -6.51}], 0.5], 
        RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
        Disk[
         GeoPosition[{42.8, -5.77}], 0.5], 
        RGBColor[0.77217125, 0.72651625, 0.2704135], 
        Disk[
         GeoPosition[{39.85, -6.04}], 0.5], 
        RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
        Disk[
         GeoPosition[{41.85, -1.88}], 0.5], 
        RGBColor[
        0.8611772083333333, 0.16093727083333334`, 0.13734573958333332`], 
        Disk[
         GeoPosition[{40.5, -3.96}], 0.5], 
        RGBColor[0.738604625, 0.734553625, 0.28479025], 
        Disk[
         GeoPosition[{31.48, -7.45}], 0.5], 
        RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
        Disk[
         GeoPosition[{53.05, 52.15}], 0.5], 
        RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
        Disk[
         GeoPosition[{51.37, 59.44}], 0.5], 
        RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
        Disk[
         GeoPosition[{51.41, 59.98}], 0.5], 
        RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
        Disk[
         GeoPosition[{53.04, 51.96}], 0.5], 
        RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
        Disk[
         GeoPosition[{53.04, 51.9}], 0.5], 
        RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
        Disk[
         GeoPosition[{53.04, 51.94}], 0.5], 
        RGBColor[0.9025465, 0.475441, 0.196102], 
        Disk[
         GeoPosition[{55.36, 61.41}], 0.5], 
        RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
        Disk[
         GeoPosition[{52.99, 52.16}], 0.5], 
        RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
        Disk[
         GeoPosition[{53.06, 51.96}], 0.5], 
        RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
        Disk[
         GeoPosition[{51.37, 59.44}], 0.5], 
        RGBColor[0.7108072636718751, 0.741209576171875, 0.29669599609375], 
        Disk[
         GeoPosition[{51.84, 79.48}], 0.5], 
        RGBColor[0.7108072636718751, 0.741209576171875, 0.29669599609375], 
        Disk[
         GeoPosition[{51.82, 79.48}], 0.5], 
        RGBColor[0.7108072636718751, 0.741209576171875, 0.29669599609375], 
        Disk[
         GeoPosition[{51.84, 79.46}], 0.5], 
        RGBColor[
        0.7959857291666667, 0.7201082708333333, 0.26032347916666665`], 
        Disk[
         GeoPosition[{52.52, 85.27}], 0.5], 
        RGBColor[0.71098208984375, 0.74116771484375, 0.2966211171875], 
        Disk[
         GeoPosition[{53.6, 79.37}], 0.5], 
        RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
        Disk[
         GeoPosition[{51.31, 82.59}], 0.5], 
        RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
        Disk[
         GeoPosition[{51.36, 82.59}], 0.5], 
        RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
        Disk[
         GeoPosition[{51.32, 82.55}], 0.5], 
        RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
        Disk[
         GeoPosition[{51.33, 82.54}], 0.5], 
        RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
        Disk[
         GeoPosition[{51.35, 82.18}], 0.5], 
        RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
        Disk[
         GeoPosition[{51.34, 82.16}], 0.5], 
        RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`], 
        Disk[
         GeoPosition[{51.65, 80.79}], 0.5], 
        RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`], 
        Disk[
         GeoPosition[{51.67, 80.82}], 0.5], 
        RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`], 
        Disk[
         GeoPosition[{51.63, 80.83}], 0.5], 
        RGBColor[0.7108072636718751, 0.741209576171875, 0.29669599609375], 
        Disk[
         GeoPosition[{54.13, 81.31}], 0.5], 
        RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`], 
        Disk[
         GeoPosition[{51.87, 80.6}], 0.5], 
        RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`], 
        Disk[
         GeoPosition[{51.75, 80.82}], 0.5], 
        RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`], 
        Disk[
         GeoPosition[{51.77, 80.85}], 0.5], 
        RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`], 
        Disk[
         GeoPosition[{51.73, 80.86}], 0.5], 
        RGBColor[0.71098208984375, 0.74116771484375, 0.2966211171875], 
        Disk[
         GeoPosition[{53.82, 80.31}], 0.5], 
        RGBColor[0.7108072636718751, 0.741209576171875, 0.29669599609375], 
        Disk[
         GeoPosition[{51.87, 80.06}], 0.5], 
        RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`], 
        Disk[
         GeoPosition[{51.9, 80.06}], 0.5], 
        RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`], 
        Disk[
         GeoPosition[{51.84, 80.06}], 0.5], 
        RGBColor[0.7108072636718751, 0.741209576171875, 0.29669599609375], 
        Disk[
         GeoPosition[{52.1, 79.31}], 0.5], 
        RGBColor[
        0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 
        Disk[
         GeoPosition[{45.07, 18.72}], 0.5], 
        RGBColor[
        0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 
        Disk[
         GeoPosition[{45.17, 18.7}], 0.5], 
        RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
        Disk[
         GeoPosition[{39.126899, 16.170188}], 0.5], 
        RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
        Disk[
         GeoPosition[{40.37, 16.77}], 0.5], 
        RGBColor[0.90168446875, 0.5358450625, 0.2075995], 
        Disk[
         GeoPosition[{39.48, 16.28}], 0.5], 
        RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
        Disk[
         GeoPosition[{39.13, 16.17}], 0.5], 
        RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
        Disk[
         GeoPosition[{40.68, 14.87}], 0.5], 
        RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
        Disk[
         GeoPosition[{38.44, 16.13}], 0.5], 
        RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
        Disk[
         GeoPosition[{38.92, 16.47}], 0.5], 
        RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
        Disk[
         GeoPosition[{40.64, 17.31}], 0.5], 
        RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
        Disk[
         GeoPosition[{38.45, 16.04}], 0.5], 
        RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
        Disk[
         GeoPosition[{38.97, 16.34}], 0.5], 
        RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
        Disk[
         GeoPosition[{41.18, 14.18}], 0.5], 
        RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
        Disk[
         GeoPosition[{40.84, 14.57}], 0.5], 
        RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
        Disk[
         GeoPosition[{39.58, 16.21}], 0.5], 
        RGBColor[0.9017419375, 0.5318181249999999, 0.20683300000000002`], 
        Disk[
         GeoPosition[{41.33, 14.09}], 0.5], 
        RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 
        Disk[
         GeoPosition[{46.366, 11.2832}], 0.5], 
        RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 
        Disk[
         GeoPosition[{46.366, 11.2832}], 0.5], 
        RGBColor[0.81178975, 0.70856125, 0.25476275], 
        Disk[
         GeoPosition[{46.366, 11.2832}], 0.5], 
        RGBColor[0.858124265625, 0.674707484375, 0.238459703125], 
        Disk[
         GeoPosition[{46.366, 11.2832}], 0.5], 
        RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 
        Disk[
         GeoPosition[{46.3668, 11.2837}], 0.5], 
        RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 
        Disk[
         GeoPosition[{46.3668, 11.2837}], 0.5], 
        RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 
        Disk[
         GeoPosition[{46.3668, 11.2837}], 0.5], 
        RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 
        Disk[
         GeoPosition[{46.3668, 11.2837}], 0.5], 
        RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 
        Disk[
         GeoPosition[{46.3668, 11.2837}], 0.5], 
        RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 
        Disk[
         GeoPosition[{46.3668, 11.2837}], 0.5], 
        RGBColor[0.858124265625, 0.674707484375, 0.238459703125], 
        Disk[
         GeoPosition[{46.3718, 11.2866}], 0.5], 
        RGBColor[0.858124265625, 0.674707484375, 0.238459703125], 
        Disk[
         GeoPosition[{46.3718, 11.2866}], 0.5], 
        RGBColor[0.858124265625, 0.674707484375, 0.238459703125], 
        Disk[
         GeoPosition[{46.3718, 11.2866}], 0.5], 
        RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
        Disk[
         GeoPosition[{46.3378, 11.2928}], 0.5], 
        RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
        Disk[
         GeoPosition[{46.3378, 11.2928}], 0.5], 
        RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
        Disk[
         GeoPosition[{46.3378, 11.2928}], 0.5], 
        RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
        Disk[
         GeoPosition[{46.3378, 11.2928}], 0.5], 
        RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
        Disk[
         GeoPosition[{46.3378, 11.2928}], 0.5], 
        RGBColor[0.8613569062499999, 0.67234559375, 0.23732228125], 
        Disk[
         GeoPosition[{46.3378, 11.2928}], 0.5], 
        RGBColor[0.8613569062499999, 0.67234559375, 0.23732228125], 
        Disk[
         GeoPosition[{46.3378, 11.2928}], 0.5], 
        RGBColor[0.8570467187499999, 0.67549478125, 0.23883884375], 
        Disk[
         GeoPosition[{46.3378, 11.2928}], 0.5], 
        RGBColor[0.8613569062499999, 0.67234559375, 0.23732228125], 
        Disk[
         GeoPosition[{46.3378, 11.2928}], 0.5], 
        RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
        Disk[
         GeoPosition[{46.3378, 11.2928}], 0.5], 
        RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
        Disk[
         GeoPosition[{46.3378, 11.2928}], 0.5], 
        RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333], 
        Disk[
         GeoPosition[{46.3378, 11.2928}], 0.5], 
        RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
        Disk[
         GeoPosition[{46.3378, 11.2928}], 0.5], 
        RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
        Disk[
         GeoPosition[{46.3378, 11.2928}], 0.5], 
        RGBColor[0.8376508749999999, 0.689666125, 0.245663375], 
        Disk[
         GeoPosition[{46.3378, 11.2928}], 0.5], 
        RGBColor[0.8376508749999999, 0.689666125, 0.245663375], 
        Disk[
         GeoPosition[{46.3378, 11.2928}], 0.5], 
        RGBColor[0.8376508749999999, 0.689666125, 0.245663375], 
        Disk[
         GeoPosition[{46.3378, 11.2928}], 0.5], 
        RGBColor[0.90239325, 0.4861795, 0.198146], 
        Disk[
         GeoPosition[{41.62, 23.94}], 0.5], 
        RGBColor[0.90239325, 0.4861795, 0.198146], 
        Disk[
         GeoPosition[{41.57, 23.85}], 0.5], 
        RGBColor[0.90239325, 0.4861795, 0.198146], 
        Disk[
         GeoPosition[{41.37, 23.14}], 0.5], 
        RGBColor[0.9025465, 0.475441, 0.196102], 
        Disk[
         GeoPosition[{42.32, 23.1}], 0.5], 
        RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333], 
        Disk[
         GeoPosition[{43.7, 25.91}], 0.5], 
        RGBColor[0.9025465, 0.475441, 0.196102], 
        Disk[
         GeoPosition[{41.53, 23.39}], 0.5], 
        RGBColor[0.90269975, 0.46470249999999996`, 0.194058], 
        Disk[
         GeoPosition[{41.53, 23.39}], 0.5], 
        RGBColor[0.90269975, 0.46470249999999996`, 0.194058], 
        Disk[
         GeoPosition[{41.5, 23.33}], 0.5], 
        RGBColor[0.90239325, 0.4861795, 0.198146], 
        Disk[
         GeoPosition[{41.64, 24.18}], 0.5], 
        RGBColor[0.9025465, 0.475441, 0.196102], 
        Disk[
         GeoPosition[{41.57, 24.84}], 0.5], 
        RGBColor[0.90208675, 0.5076565, 0.202234], 
        Disk[
         GeoPosition[{41.62, 25.35}], 0.5], 
        RGBColor[0.9025465, 0.475441, 0.196102], 
        Disk[
         GeoPosition[{41.85, 23.13}], 0.5], 
        RGBColor[0.90269975, 0.46470249999999996`, 0.194058], 
        Disk[
         GeoPosition[{41.85, 23.13}], 0.5], 
        RGBColor[0.9025465, 0.475441, 0.196102], 
        Disk[
         GeoPosition[{42.32, 23.1}], 0.5], 
        RGBColor[0.9025465, 0.475441, 0.196102], 
        Disk[
         GeoPosition[{42.32, 23.1}], 0.5], 
        RGBColor[0.90269975, 0.46470249999999996`, 0.194058], 
        Disk[
         GeoPosition[{42.49, 25.61}], 0.5], 
        RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
        Disk[
         GeoPosition[{41.84, 25.75}], 0.5], 
        RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
        Disk[
         GeoPosition[{41.54, 24.98}], 0.5], 
        RGBColor[0.90208675, 0.5076565, 0.202234], 
        Disk[
         GeoPosition[{41.66, 25.47}], 0.5], 
        RGBColor[0.90239325, 0.4861795, 0.198146], 
        Disk[
         GeoPosition[{41.55, 24.75}], 0.5], 
        RGBColor[0.90208675, 0.5076565, 0.202234], 
        Disk[
         GeoPosition[{41.83, 25.69}], 0.5], 
        RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
        Disk[
         GeoPosition[{41.77, 25.68}], 0.5], 
        RGBColor[0.9025465, 0.475441, 0.196102], 
        Disk[
         GeoPosition[{42.72, 25.33}], 0.5], 
        RGBColor[0.9025465, 0.475441, 0.196102], 
        Disk[
         GeoPosition[{41.71, 24.41}], 0.5], 
        RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333], 
        Disk[
         GeoPosition[{41.42, 23.67}], 0.5], 
        RGBColor[0.90208675, 0.5076565, 0.202234], 
        Disk[
         GeoPosition[{37.6, 23.08}], 0.5], 
        RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
        Disk[
         GeoPosition[{37.07, 22.04}], 0.5], 
        RGBColor[0.858124265625, 0.674707484375, 0.238459703125], 
        Disk[
         GeoPosition[{37.63, 21.62}], 0.5], 
        RGBColor[0.81394484375, 0.70698665625, 0.25400446875], 
        Disk[
         GeoPosition[{48.46, 18.9}], 0.5], 
        RGBColor[0.81394484375, 0.70698665625, 0.25400446875], 
        Disk[
         GeoPosition[{48.46, 18.9}], 0.5], 
        RGBColor[0.81394484375, 0.70698665625, 0.25400446875], 
        Disk[
         GeoPosition[{48.47, 18.94}], 0.5], 
        RGBColor[0.81394484375, 0.70698665625, 0.25400446875], 
        Disk[
         GeoPosition[{48.46, 18.9}], 0.5], 
        RGBColor[0.81394484375, 0.70698665625, 0.25400446875], 
        Disk[
         GeoPosition[{48.47, 18.96}], 0.5], 
        RGBColor[0.81394484375, 0.70698665625, 0.25400446875], 
        Disk[
         GeoPosition[{48.47, 18.94}], 0.5], 
        RGBColor[0.81394484375, 0.70698665625, 0.25400446875], 
        Disk[
         GeoPosition[{48.47, 18.94}], 0.5], 
        RGBColor[0.7988591875, 0.7180088124999999, 0.2593124375], 
        Disk[
         GeoPosition[{44.69, 25.17}], 0.5], 
        RGBColor[0.71098208984375, 0.74116771484375, 0.2966211171875], 
        Disk[
         GeoPosition[{45.95, 22.62}], 0.5], 
        RGBColor[0.9025465, 0.475441, 0.196102], 
        Disk[
         GeoPosition[{45.57, 25.42}], 0.5], 
        RGBColor[0.8160999375, 0.7054120625, 0.2532461875], 
        Disk[
         GeoPosition[{46.01, 22.33}], 0.5], 
        RGBColor[0.8160999375, 0.7054120625, 0.2532461875], 
        Disk[
         GeoPosition[{45.84, 23.16}], 0.5], 
        RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333], 
        Disk[
         GeoPosition[{45.14, 25}], 0.5], 
        RGBColor[0.7988591875, 0.7180088124999999, 0.2593124375], 
        Disk[
         GeoPosition[{47.16, 27.59}], 0.5], 
        RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
        Disk[
         GeoPosition[{41.45, 70.05}], 0.5], 
        RGBColor[0.8160999375, 0.7054120625, 0.2532461875], 
        Disk[
         GeoPosition[{44.38, 21.22}], 0.5], 
        RGBColor[0.9025465, 0.475441, 0.196102], 
        Disk[
         GeoPosition[{44.23, 21.71}], 0.5], 
        RGBColor[0.9025465, 0.475441, 0.196102], 
        Disk[
         GeoPosition[{43.54, 22.29}], 0.5], 
        RGBColor[0.8160999375, 0.7054120625, 0.2532461875], 
        Disk[
         GeoPosition[{44.66, 21.37}], 0.5], 
        RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333], 
        Disk[
         GeoPosition[{44.56, 22.56}], 0.5], 
        RGBColor[0.8160999375, 0.7054120625, 0.2532461875], 
        Disk[
         GeoPosition[{44.3, 21.08}], 0.5], 
        RGBColor[0.9025465, 0.475441, 0.196102], 
        Disk[
         GeoPosition[{44.3, 21.08}], 0.5], 
        RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
        Disk[
         GeoPosition[{47.75, 88.4}], 0.5], 
        RGBColor[0.9020484375, 0.510341125, 0.202745], 
        Disk[
         GeoPosition[{37.47, 49.47}], 0.5], 
        RGBColor[
        0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 
        Disk[
         GeoPosition[{33.92, 35.7}], 0.5], 
        RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
        Disk[
         GeoPosition[{37.69, 14.98}], 0.5], 
        RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
        Disk[
         GeoPosition[{34.1, 35.84}], 0.5], 
        RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
        Disk[
         GeoPosition[{42.26, 74.16}], 0.5], 
        RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
        Disk[
         GeoPosition[{48.57, 9.16}], 0.5], 
        RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
        Disk[
         GeoPosition[{48.55, 8.99}], 0.5], 
        RGBColor[0.8874511927083333, 0.35391013541666666`, 0.1723879921875], 
        Disk[
         GeoPosition[{48.53, 9.01}], 0.5], 
        RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
        Disk[
         GeoPosition[{48.56, 9.11}], 0.5], 
        RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
        Disk[
         GeoPosition[{48.41, 8.85}], 0.5], 
        RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
        Disk[
         GeoPosition[{48.59, 9.22}], 0.5], 
        RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
        Disk[
         GeoPosition[{48.41, 8.79}], 0.5], 
        RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
        Disk[
         GeoPosition[{48.43, 8.79}], 0.5], 
        RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
        Disk[
         GeoPosition[{48.57, 9.17}], 0.5], 
        RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
        Disk[
         GeoPosition[{48.41, 8.84}], 0.5], 
        RGBColor[
        0.8877411848958333, 0.3557939947916667, 0.17275751953125001`], 
        Disk[
         GeoPosition[{48.5, 8.78}], 0.5], 
        RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
        Disk[
         GeoPosition[{48.43, 8.79}], 0.5], 
        RGBColor[0.8876767421875, 0.355375359375, 0.17267540234375], 
        Disk[
         GeoPosition[{48.52, 9.11}], 0.5], 
        RGBColor[
        0.8877411848958333, 0.3557939947916667, 0.17275751953125001`], 
        Disk[
         GeoPosition[{48.53, 9.09}], 0.5], 
        RGBColor[0.5369755, 0.7333695, 0.4201585], 
        Disk[
         GeoPosition[{48.52, 9.05}], 0.5], 
        RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
        Disk[
         GeoPosition[{48.5, 8.8}], 0.5], 
        RGBColor[0.8874511927083333, 0.35391013541666666`, 0.1723879921875], 
        Disk[
         GeoPosition[{48.54, 9.02}], 0.5], 
        RGBColor[0.8874511927083333, 0.35391013541666666`, 0.1723879921875], 
        Disk[
         GeoPosition[{48.54, 9.01}], 0.5], 
        RGBColor[0.8874511927083333, 0.35391013541666666`, 0.1723879921875], 
        Disk[
         GeoPosition[{48.5, 9}], 0.5], 
        RGBColor[0.8874511927083333, 0.35391013541666666`, 0.1723879921875], 
        Disk[
         GeoPosition[{48.53, 9.01}], 0.5], 
        RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
        Disk[
         GeoPosition[{48.39, 8.96}], 0.5], 
        RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
        Disk[
         GeoPosition[{48.58, 9.18}], 0.5], 
        RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
        Disk[
         GeoPosition[{48.6, 9.2}], 0.5], 
        RGBColor[
        0.8877411848958333, 0.3557939947916667, 0.17275751953125001`], 
        Disk[
         GeoPosition[{48.54, 9.09}], 0.5], 
        RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
        Disk[
         GeoPosition[{48.57, 9.16}], 0.5], 
        RGBColor[0.8876767421875, 0.355375359375, 0.17267540234375], 
        Disk[
         GeoPosition[{48.52, 9.08}], 0.5], 
        RGBColor[0.8876767421875, 0.355375359375, 0.17267540234375], 
        Disk[
         GeoPosition[{48.5, 9.11}], 0.5], 
        RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
        Disk[
         GeoPosition[{48.41, 8.84}], 0.5], 
        RGBColor[0.8874511927083333, 0.35391013541666666`, 0.1723879921875], 
        Disk[
         GeoPosition[{48.54, 9.02}], 0.5], 
        RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
        Disk[
         GeoPosition[{48.54, 9.01}], 0.5], 
        RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
        Disk[
         GeoPosition[{48.39, 8.85}], 0.5], 
        RGBColor[0.8874511927083333, 0.35391013541666666`, 0.1723879921875], 
        Disk[
         GeoPosition[{48.54, 9.01}], 0.5], 
        RGBColor[0.8876767421875, 0.355375359375, 0.17267540234375], 
        Disk[
         GeoPosition[{48.54, 9.01}], 0.5], 
        RGBColor[0.8876767421875, 0.355375359375, 0.17267540234375], 
        Disk[
         GeoPosition[{48.51, 9.11}], 0.5], 
        RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
        Disk[
         GeoPosition[{48.42, 8.76}], 0.5], 
        RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
        Disk[
         GeoPosition[{48.45, 8.87}], 0.5], 
        RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
        Disk[
         GeoPosition[{48.54, 9.09}], 0.5], 
        RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
        Disk[
         GeoPosition[{48.56, 9.16}], 0.5], 
        RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
        Disk[
         GeoPosition[{48.6, 9.22}], 0.5], 
        RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
        Disk[
         GeoPosition[{48.52, 9.08}], 0.5], 
        RGBColor[0.9010523125, 0.580141375, 0.216031], 
        Disk[
         GeoPosition[{48.52, 9.05}], 0.5], 
        RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
        Disk[
         GeoPosition[{48.53, 9.07}], 0.5], 
        RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
        Disk[
         GeoPosition[{48.52, 9.05}], 0.5], 
        RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
        Disk[
         GeoPosition[{48.52, 9.03}], 0.5], 
        RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
        Disk[
         GeoPosition[{48.4, 8.77}], 0.5], 
        RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
        Disk[
         GeoPosition[{48.42, 8.79}], 0.5], 
        RGBColor[0.8874511927083333, 0.35391013541666666`, 0.1723879921875], 
        Disk[
         GeoPosition[{48.54, 9.02}], 0.5], 
        RGBColor[0.8876767421875, 0.355375359375, 0.17267540234375], 
        Disk[
         GeoPosition[{48.55, 9.06}], 0.5], 
        RGBColor[0.86297825, 0.17500862500000003`, 0.1398069375], 
        Disk[
         GeoPosition[{39.84, -6.6}], 0.5], 
        RGBColor[0.8822313333333334, 0.3200006666666667, 0.1657365], 
        Disk[
         GeoPosition[{42.35, -3.03}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{41, -4.71}], 0.5], 
        RGBColor[0.8720555, 0.24592825000000001`, 0.152211375], 
        Disk[
         GeoPosition[{41.81, 2.49}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{40.52, -4.02}], 0.5], 
        RGBColor[0.867733, 0.212157, 0.1463045], 
        Disk[
         GeoPosition[{43.34, -5.84}], 0.5], 
        RGBColor[0.8599525, 0.15136875, 0.135672125], 
        Disk[
         GeoPosition[{42.91, -4.91}], 0.5], 
        RGBColor[
        0.8611772083333333, 0.16093727083333334`, 0.13734573958333332`], 
        Disk[
         GeoPosition[{40.4, -3.88}], 0.5], 
        RGBColor[0.8599525, 0.15136875, 0.135672125], 
        Disk[
         GeoPosition[{42.49, -6.71}], 0.5], 
        RGBColor[
        0.8925421666666666, 0.3869823333333333, 0.17887524999999999`], 
        Disk[
         GeoPosition[{42.78, 0.69}], 0.5], 
        RGBColor[0.8582235, 0.13786025, 0.133309375], 
        Disk[
         GeoPosition[{42.5, -6.15}], 0.5], 
        RGBColor[0.86124925, 0.161500125, 0.1374441875], 
        Disk[
         GeoPosition[{36.97, -3.28}], 0.5], 
        RGBColor[0.86384275, 0.181762875, 0.1409883125], 
        Disk[
         GeoPosition[{38.54, -3.39}], 0.5], 
        RGBColor[0.77217125, 0.72651625, 0.2704135], 
        Disk[
         GeoPosition[{40.54, -3.69}], 0.5], 
        RGBColor[
        0.8608890416666667, 0.15868585416666667`, 0.13695194791666665`], 
        Disk[
         GeoPosition[{40.38, -4.21}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{40.51, -3.9}], 0.5], 
        RGBColor[
        0.8576471666666666, 0.13335741666666667`, 0.13252179166666667`], 
        Disk[
         GeoPosition[{40.61, -6.57}], 0.5], 
        RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
        Disk[
         GeoPosition[{41.25, -1.32}], 0.5], 
        RGBColor[0.86297825, 0.17500862500000003`, 0.1398069375], 
        Disk[
         GeoPosition[{37.94, -5.6}], 0.5], 
        RGBColor[0.8582235, 0.13786025, 0.133309375], 
        Disk[
         GeoPosition[{41.83, -5.38}], 0.5], 
        RGBColor[0.861465375, 0.1631886875, 0.13773953125], 
        Disk[
         GeoPosition[{40.44, -4.27}], 0.5], 
        RGBColor[0.8772424999999999, 0.28645375, 0.159299625], 
        Disk[
         GeoPosition[{41.13, -1.43}], 0.5], 
        RGBColor[
        0.8611772083333333, 0.16093727083333334`, 0.13734573958333332`], 
        Disk[
         GeoPosition[{40.59, -4.15}], 0.5], 
        RGBColor[
        0.8611772083333333, 0.16093727083333334`, 0.13734573958333332`], 
        Disk[
         GeoPosition[{40.53, -3.92}], 0.5], 
        RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
        Disk[
         GeoPosition[{42.27, 0.19}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{40.48, -3.96}], 0.5], 
        RGBColor[0.86211375, 0.168254375, 0.1386255625], 
        Disk[
         GeoPosition[{42.31, -3.02}], 0.5], 
        RGBColor[0.9011289375, 0.574772125, 0.215009], 
        Disk[
         GeoPosition[{43.31, -5.7}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{40.11, -5.77}], 0.5], 
        RGBColor[
        0.8587998333333333, 0.14236308333333333`, 0.13409695833333332`], 
        Disk[
         GeoPosition[{40.65, -4.11}], 0.5], 
        RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
        Disk[
         GeoPosition[{42.86, -0.7}], 0.5], 
        RGBColor[0.8599525, 0.15136875, 0.135672125], 
        Disk[
         GeoPosition[{42.96, -6.1}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{40.46, -3.75}], 0.5], 
        RGBColor[0.867733, 0.212157, 0.1463045], 
        Disk[
         GeoPosition[{43.33, -5.91}], 0.5], 
        RGBColor[0.867733, 0.212157, 0.1463045], 
        Disk[
         GeoPosition[{43.36, -5.88}], 0.5], 
        RGBColor[
        0.8611772083333333, 0.16093727083333334`, 0.13734573958333332`], 
        Disk[
         GeoPosition[{40.57, -3.89}], 0.5], 
        RGBColor[
        0.8608890416666667, 0.15868585416666667`, 0.13695194791666665`], 
        Disk[
         GeoPosition[{40.51, -4}], 0.5], 
        RGBColor[
        0.8611772083333333, 0.16093727083333334`, 0.13734573958333332`], 
        Disk[
         GeoPosition[{40.33, -3.8}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{40.98, -3.8}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{40.5, -3.88}], 0.5], 
        RGBColor[0.8822313333333334, 0.3200006666666667, 0.1657365], 
        Disk[
         GeoPosition[{42.24, -2.62}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{40.72, -3.21}], 0.5], 
        RGBColor[0.867733, 0.212157, 0.1463045], 
        Disk[
         GeoPosition[{40.45, -3.67}], 0.5], 
        RGBColor[0.8720555, 0.24592825000000001`, 0.152211375], 
        Disk[
         GeoPosition[{41.76, 2.69}], 0.5], 
        RGBColor[0.86124925, 0.161500125, 0.1374441875], 
        Disk[
         GeoPosition[{41.89, -2.79}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{40.94, -3.22}], 0.5], 
        RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
        Disk[
         GeoPosition[{41.78, 2.37}], 0.5], 
        RGBColor[0.77217125, 0.72651625, 0.2704135], 
        Disk[
         GeoPosition[{36.76, -5.28}], 0.5], 
        RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
        Disk[
         GeoPosition[{41.91, 0.17}], 0.5], 
        RGBColor[0.738604625, 0.734553625, 0.28479025], 
        Disk[
         GeoPosition[{40.75, -3.99}], 0.5], 
        RGBColor[0.8627621249999999, 0.17332006249999998`, 0.13951159375], 
        Disk[
         GeoPosition[{37.94, -5.45}], 0.5], 
        RGBColor[0.8822313333333334, 0.3200006666666667, 0.1657365], 
        Disk[
         GeoPosition[{42.34, -3}], 0.5], 
        RGBColor[0.867733, 0.212157, 0.1463045], 
        Disk[
         GeoPosition[{43.38, -5.87}], 0.5], 
        RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
        Disk[
         GeoPosition[{41.34, 0.99}], 0.5], 
        RGBColor[0.8582235, 0.13786025, 0.133309375], 
        Disk[
         GeoPosition[{43.02, -5.6}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{40.78, -3.62}], 0.5], 
        RGBColor[0.77217125, 0.72651625, 0.2704135], 
        Disk[
         GeoPosition[{37.6, -1.12}], 0.5], 
        RGBColor[0.86124925, 0.161500125, 0.1374441875], 
        Disk[
         GeoPosition[{42.72, -3.44}], 0.5], 
        RGBColor[
        0.8576471666666666, 0.13335741666666667`, 0.13252179166666667`], 
        Disk[
         GeoPosition[{40.46, -5.32}], 0.5], 
        RGBColor[
        0.8608890416666667, 0.15868585416666667`, 0.13695194791666665`], 
        Disk[
         GeoPosition[{40.46, -4.26}], 0.5], 
        RGBColor[0.8822313333333334, 0.3200006666666667, 0.1657365], 
        Disk[
         GeoPosition[{42.1, -2.56}], 0.5], 
        RGBColor[0.861465375, 0.1631886875, 0.13773953125], 
        Disk[
         GeoPosition[{41.14, -3.68}], 0.5], 
        RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
        Disk[
         GeoPosition[{42.38, 1.73}], 0.5], 
        RGBColor[0.738604625, 0.734553625, 0.28479025], 
        Disk[
         GeoPosition[{40.4, -4.77}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{40.93, -3.31}], 0.5], 
        RGBColor[0.8582235, 0.13786025, 0.133309375], 
        Disk[
         GeoPosition[{43.16, -5.07}], 0.5], 
        RGBColor[0.8737845, 0.25943675, 0.154574125], 
        Disk[
         GeoPosition[{41.93, 2.92}], 0.5], 
        RGBColor[
        0.8576471666666666, 0.13335741666666667`, 0.13252179166666667`], 
        Disk[
         GeoPosition[{42.68, -6.96}], 0.5], 
        RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
        Disk[
         GeoPosition[{42.59, 0.76}], 0.5], 
        RGBColor[0.8720555, 0.24592825000000001`, 0.152211375], 
        Disk[
         GeoPosition[{41.78, 2.57}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{40.95, -5.63}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{41.14, -3.58}], 0.5], 
        RGBColor[
        0.6563445000000001, 0.7431544999999999, 0.32887750000000004`], 
        Disk[
         GeoPosition[{42.54, 0.84}], 0.5], 
        RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
        Disk[
         GeoPosition[{37.38, -6.01}], 0.5], 
        RGBColor[0.8822313333333334, 0.3200006666666667, 0.1657365], 
        Disk[
         GeoPosition[{42.27, -2.98}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{40.71, -3.24}], 0.5], 
        RGBColor[0.86124925, 0.161500125, 0.1374441875], 
        Disk[
         GeoPosition[{42.31, -3.1}], 0.5], 
        RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
        Disk[
         GeoPosition[{40.95, -3.31}], 0.5], 
        RGBColor[0.738604625, 0.734553625, 0.28479025], 
        Disk[
         GeoPosition[{40.76, -4.01}], 0.5], 
        RGBColor[
        0.8729199999999999, 0.25268250000000003`, 0.15339275000000002`], 
        Disk[
         GeoPosition[{40, 4.25}], 0.5], 
        RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
        Disk[
         GeoPosition[{50.72, 3.47}], 0.5], 
        RGBColor[0.9011002031249999, 0.5767855937499999, 0.21539225], 
        Disk[
         GeoPosition[{50.59, 3.3}], 0.5], 
        RGBColor[0.9011289375, 0.574772125, 0.215009], 
        Disk[
         GeoPosition[{50.68, 3.52}], 0.5], 
        RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
        Disk[
         GeoPosition[{47.16, 4.28}], 0.5], 
        RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
        Disk[
         GeoPosition[{46.67, 4.55}], 0.5], 
        RGBColor[
        0.8089162916666666, 0.7106607083333333, 0.25577379166666664`], 
        Disk[
         GeoPosition[{47.58, 5.33}], 0.5], 
        RGBColor[
        0.8118795455729166, 0.7084956419270834, 0.25473115494791665`], 
        Disk[
         GeoPosition[{47.45, 3.94}], 0.5], 
        RGBColor[
        0.8925421666666666, 0.3869823333333333, 0.17887524999999999`], 
        Disk[
         GeoPosition[{46.69, 4.34}], 0.5], 
        RGBColor[
        0.8925421666666666, 0.3869823333333333, 0.17887524999999999`], 
        Disk[
         GeoPosition[{47.43, 5.21}], 0.5], 
        RGBColor[0.9010523125, 0.580141375, 0.216031], 
        Disk[
         GeoPosition[{48.54, 4.32}], 0.5], 
        RGBColor[0.9011480937499999, 0.5734298124999999, 0.2147535], 
        Disk[
         GeoPosition[{48.57, 4.41}], 0.5], 
        RGBColor[0.8760126666666667, 0.641456, 0.22989], 
        Disk[
         GeoPosition[{48.59, 4.24}], 0.5], 
        RGBColor[0.9011289375, 0.574772125, 0.215009], 
        Disk[
         GeoPosition[{48.91, 4.52}], 0.5], 
        RGBColor[0.867733, 0.212157, 0.1463045], 
        Disk[
         GeoPosition[{48.86, 4.1}], 0.5], 
        RGBColor[0.867733, 0.212157, 0.1463045], 
        Disk[
         GeoPosition[{44.05, 3.69}], 0.5], 
        RGBColor[
        0.8925421666666666, 0.3869823333333333, 0.17887524999999999`], 
        Disk[
         GeoPosition[{44.12, 3.77}], 0.5], 
        RGBColor[
        0.8925421666666666, 0.3869823333333333, 0.17887524999999999`], 
        Disk[
         GeoPosition[{43.92, 3.71}], 0.5], 
        RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333], 
        Disk[
         GeoPosition[{43.91, 4.14}], 0.5], 
        RGBColor[0.901090625, 0.57745675, 0.21552000000000002`], 
        Disk[
         GeoPosition[{44.12, 4.33}], 0.5], 
        RGBColor[0.7988591875, 0.7180088124999999, 0.2593124375], 
        Disk[
         GeoPosition[{43.74, 3.89}], 0.5], 
        RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
        Disk[
         GeoPosition[{50.6, 2.93}], 0.5], 
        RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
        Disk[
         GeoPosition[{50.79, 2.69}], 0.5], 
        RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
        Disk[
         GeoPosition[{50.65, 2.99}], 0.5], 
        RGBColor[0.738604625, 0.734553625, 0.28479025], 
        Disk[
         GeoPosition[{31.48, -7.45}], 0.5], 
        RGBColor[0.9011289375, 0.574772125, 0.215009], 
        Disk[
         GeoPosition[{40.92, -8.54}], 0.5], 
        RGBColor[0.8772424999999999, 0.28645375, 0.159299625], 
        Disk[
         GeoPosition[{41.32, -1.34}], 0.5], 
        RGBColor[0.863194375, 0.17669718750000002`, 0.14010228125000002`], 
        Disk[
         GeoPosition[{39.73, -5.74}], 0.5], 
        RGBColor[0.77217125, 0.72651625, 0.2704135], 
        Disk[
         GeoPosition[{36.83, -6.36}], 0.5], 
        RGBColor[0.86211375, 0.168254375, 0.1386255625], 
        Disk[
         GeoPosition[{41.8, -3.11}], 0.5], 
        RGBColor[0.8627621249999999, 0.17332006249999998`, 0.13951159375], 
        Disk[
         GeoPosition[{38.92, -6.34}], 0.5], 
        RGBColor[0.77217125, 0.72651625, 0.2704135], 
        Disk[
         GeoPosition[{40.74, -3.9}], 0.5], 
        RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
        Disk[
         GeoPosition[{41.05, -3.54}], 0.5], 
        RGBColor[0.8599525, 0.15136875, 0.135672125], 
        Disk[
         GeoPosition[{42.69, -6.93}], 0.5], 
        RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
        Disk[
         GeoPosition[{42.63, 0.76}], 0.5], 
        RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
        Disk[
         GeoPosition[{51.3333, 82.5667}], 0.5], 
        RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
        Disk[
         GeoPosition[{51.32, 82.55}], 0.5], 
        RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
        Disk[
         GeoPosition[{51.33, 82.19}], 0.5], 
        RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
        Disk[
         GeoPosition[{54.09, 60.46}], 0.5], 
        RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
        Disk[
         GeoPosition[{54.06, 60.48}], 0.5], 
        RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
        Disk[
         GeoPosition[{53.04, 51.75}], 0.5], 
        RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
        Disk[
         GeoPosition[{53.33, 49.48}], 0.5], 
        RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
        Disk[
         GeoPosition[{53.33, 49.48}], 0.5], 
        RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
        Disk[
         GeoPosition[{51.31, 57.56}], 0.5], 
        RGBColor[0.9017419375, 0.5318181249999999, 0.20683300000000002`], 
        Disk[
         GeoPosition[{40.57, 15.32}], 0.5], 
        RGBColor[0.90168446875, 0.5358450625, 0.2075995], 
        Disk[
         GeoPosition[{39.18, 16.26}], 0.5], 
        RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
        Disk[
         GeoPosition[{38.36, 16.23}], 0.5], 
        RGBColor[0.90168446875, 0.5358450625, 0.2075995], 
        Disk[
         GeoPosition[{38.38, 16.22}], 0.5], 
        RGBColor[0.9017419375, 0.5318181249999999, 0.20683300000000002`], 
        Disk[
         GeoPosition[{40.28, 15.65}], 0.5], 
        RGBColor[0.90168446875, 0.5358450625, 0.2075995], 
        Disk[
         GeoPosition[{39.27, 16.27}], 0.5], 
        RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
        Disk[
         GeoPosition[{40.18, 16.45}], 0.5], 
        RGBColor[0.81178975, 0.70856125, 0.25476275], 
        Disk[
         GeoPosition[{46.3716, 11.2376}], 0.5], 
        RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
        Disk[
         GeoPosition[{46.513, 11.331}], 0.5], 
        RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
        Disk[
         GeoPosition[{46.513, 11.331}], 0.5], 
        RGBColor[0.858124265625, 0.674707484375, 0.238459703125], 
        Disk[
         GeoPosition[{46.366, 11.2832}], 0.5], 
        RGBColor[0.8376508749999999, 0.689666125, 0.245663375], 
        Disk[
         GeoPosition[{46.3378, 11.2928}], 0.5], 
        RGBColor[0.8376508749999999, 0.689666125, 0.245663375], 
        Disk[
         GeoPosition[{46.3378, 11.2928}], 0.5], 
        RGBColor[
        0.9019334999999999, 0.5183949999999999, 0.20427800000000002`], 
        Disk[
         GeoPosition[{46.2543, 11.167}], 0.5], 
        RGBColor[0.8613569062499999, 0.67234559375, 0.23732228125], 
        Disk[
         GeoPosition[{46.6297, 10.817}], 0.5], 
        RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
        Disk[
         GeoPosition[{46.36, 11.23}], 0.5], 
        RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
        Disk[
         GeoPosition[{38.62, 16.17}], 0.5], 
        RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
        Disk[
         GeoPosition[{38.76, 16.24}], 0.5], 
        RGBColor[0.90168446875, 0.5358450625, 0.2075995], 
        Disk[
         GeoPosition[{39.01, 16.47}], 0.5], 
        RGBColor[0.9017419375, 0.5318181249999999, 0.20683300000000002`], 
        Disk[
         GeoPosition[{41.62, 12.87}], 0.5], 
        RGBColor[0.9017419375, 0.5318181249999999, 0.20683300000000002`], 
        Disk[
         GeoPosition[{41.62, 12.87}], 0.5], 
        RGBColor[0.90239325, 0.4861795, 0.198146], 
        Disk[
         GeoPosition[{41.43, 23.65}], 0.5], 
        RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
        Disk[
         GeoPosition[{41.59, 25.2}], 0.5], 
        RGBColor[0.90269975, 0.46470249999999996`, 0.194058], 
        Disk[
         GeoPosition[{41.43, 23.5}], 0.5], 
        RGBColor[0.716226875, 0.739911875, 0.29437475], 
        Disk[
         GeoPosition[{41.7942, 43.4767}], 0.5], 
        RGBColor[0.9021250625, 0.504971875, 0.20172299999999999`], 
        Disk[
         GeoPosition[{41.8296, 46.2831}], 0.5], 
        RGBColor[0.902163375, 0.50228725, 0.201212], 
        Disk[
         GeoPosition[{41.2381, 46.3728}], 0.5], 
        RGBColor[0.7988591875, 0.7180088124999999, 0.2593124375], 
        Disk[
         GeoPosition[{38.6425, 42.2394}], 0.5], 
        RGBColor[0.8876767421875, 0.355375359375, 0.17267540234375], 
        Disk[
         GeoPosition[{48.14, 9.4}], 0.5], 
        RGBColor[
        0.8877411848958333, 0.3557939947916667, 0.17275751953125001`], 
        Disk[
         GeoPosition[{48.52, 8.8}], 0.5], 
        RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
        Disk[
         GeoPosition[{48.56, 9.16}], 0.5], 
        RGBColor[0.888933375, 0.36353875, 0.1742766875], 
        Disk[
         GeoPosition[{48.43, 8.82}], 0.5], 
        RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
        Disk[
         GeoPosition[{48.53, 9.06}], 0.5], 
        RGBColor[0.9010523125, 0.580141375, 0.216031], 
        Disk[
         GeoPosition[{48.52, 9.05}], 0.5], 
        RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
        Disk[
         GeoPosition[{48.53, 9.04}], 0.5], 
        RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333], 
        Disk[
         GeoPosition[{44.46, 25.74}], 0.5], 
        RGBColor[0.8160999375, 0.7054120625, 0.2532461875], 
        Disk[
         GeoPosition[{46.11, 21.95}], 0.5], 
        RGBColor[0.90208675, 0.5076565, 0.202234], 
        Disk[
         GeoPosition[{44.6419, 34.3814}], 0.5], 
        RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
        Disk[
         GeoPosition[{41.45, 70.05}], 0.5], 
        RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
        Disk[
         GeoPosition[{41.45, 70.05}], 0.5], 
        RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
        Disk[
         GeoPosition[{41.45, 70.05}], 0.5], 
        RGBColor[
        0.7078352187500001, 0.7419212187499999, 0.29796893750000003`], 
        Disk[
         GeoPosition[{39.8692, 45.3622}], 0.5], 
        RGBColor[0.902010125, 0.51302575, 0.203256], 
        Disk[
         GeoPosition[{38.9786, 48.5594}], 0.5], 
        RGBColor[0.9020484375, 0.510341125, 0.202745], 
        Disk[
         GeoPosition[{38.7406, 48.6131}], 0.5], 
        RGBColor[0.9020484375, 0.510341125, 0.202745], 
        Disk[
         GeoPosition[{38.6536, 48.7992}], 0.5], 
        RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
        Disk[
         GeoPosition[{37.29, 71.3}], 0.5], 
        RGBColor[0.8160999375, 0.7054120625, 0.2532461875], 
        Disk[
         GeoPosition[{44.34, 21.46}], 0.5], 
        RGBColor[
        0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 
        Disk[
         GeoPosition[{44.84, 20.16}], 0.5], 
        RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 
        Disk[
         GeoPosition[{49.17, 16.5}], 0.5], 
        RGBColor[0.888933375, 0.36353875, 0.1742766875], 
        Disk[
         GeoPosition[{48.0333, 7.7667}], 0.5], 
        RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
        Disk[
         GeoPosition[{68.8, 15.45}], 0.5], 
        RGBColor[0.888933375, 0.36353875, 0.1742766875], 
        Disk[
         GeoPosition[{48.02838, 7.765567}], 0.5], 
        RGBColor[0.7218213125, 0.7385723125, 0.291978625], 
        Disk[
         GeoPosition[{62.02, 34.12}], 0.5], 
        RGBColor[0.7218213125, 0.7385723125, 0.291978625], 
        Disk[
         GeoPosition[{62.02, 34.12}], 0.5], 
        RGBColor[0.7218213125, 0.7385723125, 0.291978625], 
        Disk[
         GeoPosition[{61.59, 35.11}], 0.5], 
        RGBColor[0.7218213125, 0.7385723125, 0.291978625], 
        Disk[
         GeoPosition[{61.59, 35.11}], 0.5], 
        RGBColor[
        0.7959857291666667, 0.7201082708333333, 0.26032347916666665`], 
        Disk[
         GeoPosition[{61.94, 34.24}], 0.5], 
        RGBColor[0.7218213125, 0.7385723125, 0.291978625], 
        Disk[
         GeoPosition[{61.94, 34.24}], 0.5], 
        RGBColor[0.7106324375, 0.7412514375, 0.296770875], 
        Disk[
         GeoPosition[{61.37, 61.37}], 0.5], 
        RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 
        Disk[
         GeoPosition[{48.3315333, 14.72665}], 0.5], 
        RGBColor[
        0.8121489322916666, 0.7082988177083334, 0.25463636979166665`], 
        Disk[
         GeoPosition[{48.3314667, 14.7158667}], 0.5], 
        RGBColor[0.8128672968749999, 0.707773953125, 0.254383609375], 
        Disk[
         GeoPosition[{48.3314667, 14.7158667}], 0.5], 
        RGBColor[0.7106324375, 0.7412514375, 0.296770875], 
        Disk[
         GeoPosition[{60.4, 32.09}], 0.5], 
        RGBColor[0.7120310468750001, 0.740916546875, 0.29617184375], 
        Disk[
         GeoPosition[{61.57, 30.63}], 0.5], 
        RGBColor[0.8128672968749999, 0.707773953125, 0.254383609375], 
        Disk[
         GeoPosition[{48.3268333, 14.7181667}], 0.5], 
        RGBColor[0.8128672968749999, 0.707773953125, 0.254383609375], 
        Disk[
         GeoPosition[{48.3268333, 14.7181667}], 0.5], 
        RGBColor[0.8128672968749999, 0.707773953125, 0.254383609375], 
        Disk[
         GeoPosition[{48.3268333, 14.7181667}], 0.5]}, GeoProjection -> 
       "Equirectangular", GeoRange -> Automatic, GeoBackground -> 
       GeoStyling["Coastlines", 
         Opacity[1]], ImageSize -> 900]], 
    "BasicGeoRange" -> {{15.1111, 68.8}, {-123.206, 136.31}}, 
    "GeoGraphicsOptions" -> {GeoBackground -> GeoStyling["Coastlines", 
        Opacity[1], 
        GeoServer -> {
         "Wolfram", "AllowProviderChange" :> GIS`$AllowProviderChange}], 
      GeoCenter -> GeoPosition[{0., 6.5519999999999925`}], GeoGridLines -> 
      None, GeoGridLinesStyle -> GrayLevel[0.4, 0.3], GeoModel -> "ITRF00", 
      GeoProjection -> "Equirectangular", 
      GeoRange -> {{-90., 90.}, {-173.448, 186.552}}, GeoRangePadding -> None,
       GeoServer -> {
       "Wolfram", "AllowProviderChange" :> GIS`$AllowProviderChange}, 
      GeoZoomLevel -> 2, 
      MetaInformation -> {"Software" -> "Wolfram Language"}}},
  PlotRange->{{-173.448, 186.552}, {-90., 90.}},
  PlotRangeClipping->True,
  PlotRangePadding->None]], "Output",
 CellChangeTimes->{{3.731690559946581*^9, 3.7316905836922116`*^9}, 
   3.7316907772561717`*^9, 3.731691239566778*^9, {3.7316914977419662`*^9, 
   3.73169151170444*^9}, 3.7316932251794453`*^9, 
   3.7348033185484796`*^9},ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"],ExpressionUUID->"f718fa1f-64d0-4b5a-8c52-e83756e5169d"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
       20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37,
       38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55,
       56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73,
       74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91,
       92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107,
       108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 
      122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 
      136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 
      150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 
      164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 
      178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 
      192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 
      206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 
      220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 
      234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 
      248, 249, 250, 251, 252, 253, 254}, {CompressedData["
1:eJwBCwL0/SFib1JiAgAAAP0AAAACAAAAAQIBAwIEAwUDBgQHBAgFCQUKBgsG
DAYNCA4JDwkQChEKEgsTCxQMFQwWDRcNGA4ZDxoPGxAcER0RHhIfEiATIRQi
FCMVJBUlFiYWJxcoGCkYKhorGiwaLRsuGy8cMBwxHTIdMx40HzUfNh83IDgh
OSM6IzskPCQ9JT4mPydAJ0EoQihDKkQqRStGK0csSC1JLUouSzBMMU0yTjJP
NFA1UTVSNlM4VDlVOlY6VzxYPFk9Wj5bP1xAXUFeQV9DYENhRGJEY0VkRWVH
ZkhnSWhKaUpqS2tMbE5tTm5Rb1JwUnFTclNzVHRUdVV2VndWeFh5Wnpae1t8
XH1cflx/XoBegV+CX4NghGCFYYZhh2KIYoljimOLZYxnjWiOaY9pkGyRbJJu
k26Ub5VzlnOXdZh1mXeaeJt5nHqde557n3ygfKF+on6jgqSFpYmmiaeLqIyp
jKqMq46sjq2Pro+vj7CSsZKyk7OTtJS1lbaVt5a4mLmZupm7m7ycvZ2+nb+j
wKTBpMKow6jErMWyxrLHssizybPKtMu4zLrNus68z7zQvdG90sHTwtTC1cTW
ydfK2MzZzdrP29Hc1N3U3tXf1eDW4dfi1+PZ5Nnl2+bb59zo3Ond6t7r3uzf
7eHu4e/h8OTx5PLn8+j06vXx9vb39vj3+fj6+Pv5/Pn9/f4d4OiZ
       "], Null}, {EdgeStyle -> {
         RGBColor[0.8, 0.8, 0.8]}, GraphLayout -> "LayeredDigraphEmbedding", 
       ImageSize -> 1000, VertexSize -> {0.5}, 
       VertexStyle -> {
        51 -> RGBColor[0.738604625, 0.734553625, 0.28479025], 37 -> 
         RGBColor[0.9025465, 0.475441, 0.196102], 59 -> 
         RGBColor[0.90147375, 0.5506105, 0.21041], 21 -> 
         RGBColor[0.90224, 0.49691799999999997`, 0.20019], 191 -> 
         RGBColor[0.9020484375, 0.510341125, 0.202745], 210 -> 
         RGBColor[0.9017419375, 0.5318181249999999, 0.20683300000000002`], 
         215 -> RGBColor[0.71098208984375, 0.74116771484375, 0.2966211171875],
          176 -> RGBColor[
          0.5543171736111111, 0.7359087152777778, 0.4050509236111111], 61 -> 
         RGBColor[0.90208675, 0.5076565, 0.202234], 85 -> 
         RGBColor[0.8760126666666667, 0.641456, 0.22989], 238 -> 
         RGBColor[
          0.8611772083333333, 0.16093727083333334`, 0.13734573958333332`], 99 -> 
         RGBColor[0.8616815, 0.16487725, 0.138034875], 97 -> 
         RGBColor[
          0.8729199999999999, 0.25268250000000003`, 0.15339275000000002`], 
         122 -> RGBColor[0.902010125, 0.51302575, 0.203256], 248 -> 
         RGBColor[0.8123285234375, 0.7081676015625, 0.2545731796875], 11 -> 
         RGBColor[0.8885133333333333, 0.6121409999999999, 0.223216], 17 -> 
         RGBColor[0.7497935, 0.7318745, 0.27999799999999997`], 24 -> 
         RGBColor[0.864275, 0.18514000000000003`, 0.141579], 89 -> 
         RGBColor[0.901856875, 0.5237642499999999, 0.2053], 55 -> 
         RGBColor[0.8232835833333333, 0.7001634166666666, 0.2507185833333333],
          14 -> RGBColor[0.36048, 0.655759, 0.645692], 242 -> 
         RGBColor[0.8128672968749999, 0.707773953125, 0.254383609375], 164 -> 
         RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 
         153 -> RGBColor[
          0.8592018124999999, 0.6739201875, 0.23808056249999998`], 143 -> 
         RGBColor[
          0.5536627708333334, 0.7358128958333333, 0.40562102083333335`], 27 -> 
         RGBColor[0.5840925, 0.7402685, 0.37911150000000005`], 69 -> 
         RGBColor[0.859088, 0.1446145, 0.13449075], 194 -> 
         RGBColor[0.8876445208333333, 0.35516604166666665`, 0.17263434375], 
         182 -> RGBColor[
          0.7959857291666667, 0.7201082708333333, 0.26032347916666665`], 136 -> 
         RGBColor[0.86384275, 0.181762875, 0.1409883125], 93 -> 
         RGBColor[
          0.8925421666666666, 0.3869823333333333, 0.17887524999999999`], 75 -> 
         RGBColor[0.57231325, 0.73854375, 0.38937325], 157 -> 
         RGBColor[0.902010125, 0.51302575, 0.203256], 234 -> 
         RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
         32 -> RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
         66 -> RGBColor[0.8822313333333334, 0.3200006666666667, 0.1657365], 
         184 -> RGBColor[
          0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 101 -> 
         RGBColor[0.8582235, 0.13786025, 0.133309375], 39 -> 
         RGBColor[0.8904799999999999, 0.373586, 0.1762475], 253 -> 
         RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 130 -> 
         RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 12 -> 
         RGBColor[0.902853, 0.453964, 0.192014], 167 -> 
         RGBColor[0.8627621249999999, 0.17332006249999998`, 0.13951159375], 
         135 -> RGBColor[0.8720555, 0.24592825000000001`, 0.152211375], 230 -> 
         RGBColor[0.9011002031249999, 0.5767855937499999, 0.21539225], 92 -> 
         RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 131 -> 
         RGBColor[
          0.8868712083333333, 0.3501424166666667, 0.17164893750000002`], 106 -> 
         RGBColor[
          0.5585707916666667, 0.7365315416666667, 0.40134529166666666`], 207 -> 
         RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 151 -> 
         RGBColor[0.8160999375, 0.7054120625, 0.2532461875], 226 -> 
         RGBColor[0.7108072636718751, 0.741209576171875, 0.29669599609375], 
         221 -> RGBColor[
          0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 165 -> 
         RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 95 -> 
         RGBColor[0.88738675, 0.3534915, 0.172305875], 150 -> 
         RGBColor[
          0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 126 -> 
         RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 100 -> 
         RGBColor[0.8599525, 0.15136875, 0.135672125], 245 -> 
         RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
         166 -> RGBColor[
          0.863194375, 0.17669718750000002`, 0.14010228125000002`], 231 -> 
         RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 107 -> 
         RGBColor[0.57231325, 0.73854375, 0.38937325], 9 -> 
         RGBColor[0.607651, 0.743718, 0.358588], 104 -> 
         RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 213 -> 
         RGBColor[0.8875156354166667, 0.35432877083333336`, 0.172470109375], 
         206 -> RGBColor[0.858124265625, 0.674707484375, 0.238459703125], 140 -> 
         RGBColor[0.8582235, 0.13786025, 0.133309375], 102 -> 
         RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 22 -> 
         RGBColor[0.8946043333333333, 0.40037866666666666`, 0.181503], 169 -> 
         RGBColor[
          0.8587998333333333, 0.14236308333333333`, 0.13409695833333332`], 
         254 -> RGBColor[
          0.81205913671875, 0.70836442578125, 0.25466796484375], 214 -> 
         RGBColor[0.861033125, 0.1598115625, 0.13714884375], 53 -> 
         RGBColor[
          0.8002959166666667, 0.7169590833333332, 0.25880691666666666`], 181 -> 
         RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 146 -> 
         RGBColor[0.6441711250000001, 0.743295375, 0.33630512500000004`], 38 -> 
         RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 129 -> 
         RGBColor[0.888933375, 0.36353875, 0.1742766875], 219 -> 
         RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 117 -> 
         RGBColor[0.8548916249999999, 0.677069375, 0.239597125], 88 -> 
         RGBColor[0.901703625, 0.5345027499999999, 0.207344], 13 -> 
         RGBColor[0.8711909999999999, 0.23917400000000003`, 0.15103], 139 -> 
         RGBColor[0.86124925, 0.161500125, 0.1374441875], 57 -> 
         RGBColor[0.8760126666666667, 0.641456, 0.22989], 108 -> 
         RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 228 -> 
         RGBColor[0.8125081145833333, 0.7080363854166667, 0.2545099895833333],
          233 -> RGBColor[0.90168446875, 0.5358450625, 0.2075995], 168 -> 
         RGBColor[0.86124925, 0.161500125, 0.1374441875], 204 -> 
         RGBColor[
          0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 154 -> 
         RGBColor[0.9010523125, 0.580141375, 0.216031], 138 -> 
         RGBColor[0.86211375, 0.168254375, 0.1386255625], 19 -> 
         RGBColor[0.8760126666666667, 0.641456, 0.22989], 16 -> 
         RGBColor[
          0.6563445000000001, 0.7431544999999999, 0.32887750000000004`], 105 -> 
         RGBColor[0.5546443750000001, 0.735956625, 0.404765875], 216 -> 
         RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
         26 -> RGBColor[0.5369755, 0.7333695, 0.4201585], 60 -> 
         RGBColor[0.90178025, 0.5291334999999999, 0.206322], 170 -> 
         RGBColor[0.8582235, 0.13786025, 0.133309375], 163 -> 
         RGBColor[
          0.8980412777777778, 0.4227058888888889, 0.18588258333333332`], 120 -> 
         RGBColor[0.9011289375, 0.574772125, 0.215009], 29 -> 
         RGBColor[0.72741575, 0.73723275, 0.2895825], 133 -> 
         RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 137 -> 
         RGBColor[0.86297825, 0.17500862500000003`, 0.1398069375], 46 -> 
         RGBColor[0.57231325, 0.73854375, 0.38937325], 79 -> 
         RGBColor[0.7218213125, 0.7385723125, 0.291978625], 76 -> 
         RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 188 -> 
         RGBColor[0.9011289375, 0.574772125, 0.215009], 132 -> 
         RGBColor[0.8772424999999999, 0.28645375, 0.159299625], 178 -> 
         RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 162 -> 
         RGBColor[
          0.8994160555555556, 0.43163677777777776`, 0.18763441666666666`], 
         220 -> RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 149 -> 
         RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333],
          34 -> RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`],
          147 -> RGBColor[0.7120310468750001, 0.740916546875, 0.29617184375], 
         200 -> 
         RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 144 -> 
         RGBColor[0.5556259791666667, 0.7361003541666666, 0.4039107291666667],
          128 -> RGBColor[
          0.8899644583333334, 0.3702369166666667, 0.1755905625], 118 -> 
         RGBColor[0.8760126666666667, 0.641456, 0.22989], 6 -> 
         RGBColor[0.902853, 0.453964, 0.192014], 183 -> 
         RGBColor[0.7988591875, 0.7180088124999999, 0.2593124375], 30 -> 
         RGBColor[0.77217125, 0.72651625, 0.2704135], 142 -> 
         RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 3 -> 
         RGBColor[0.863512, 0.670771, 0.236564], 208 -> 
         RGBColor[0.9011480937499999, 0.5734298124999999, 0.2147535], 186 -> 
         RGBColor[0.8570467187499999, 0.67549478125, 0.23883884375], 177 -> 
         RGBColor[0.6380844375000001, 0.7433658125, 0.3400189375], 172 -> 
         RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667],
          190 -> RGBColor[0.9019718125, 0.5157103749999999, 0.203767], 77 -> 
         RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 72 -> 
         RGBColor[0.5369755, 0.7333695, 0.4201585], 62 -> 
         RGBColor[0.9025465, 0.475441, 0.196102], 209 -> 
         RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 217 -> 
         RGBColor[
          0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 148 -> 
         RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 171 -> 
         RGBColor[
          0.8576471666666666, 0.13335741666666667`, 0.13252179166666667`], 
         127 -> RGBColor[
          0.8959791111111111, 0.40930955555555554`, 0.18325483333333334`], 54 -> 
         RGBColor[0.81178975, 0.70856125, 0.25476275], 71 -> 
         RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 113 -> 
         RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666],
          179 -> RGBColor[
          0.7113317421875001, 0.7410839921875, 0.296471359375], 109 -> 
         RGBColor[
          0.7078352187500001, 0.7419212187499999, 0.29796893750000003`], 7 -> 
         RGBColor[0.250728, 0.225386, 0.769152], 81 -> 
         RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333],
          47 -> 
         RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 252 -> 
         RGBColor[
          0.8118795455729166, 0.7084956419270834, 0.25473115494791665`], 240 -> 
         RGBColor[
          0.8608890416666667, 0.15868585416666667`, 0.13695194791666665`], 
         192 -> RGBColor[
          0.8980412777777778, 0.4227058888888889, 0.18588258333333332`], 87 -> 
         RGBColor[0.901243875, 0.56671825, 0.213476], 94 -> 
         RGBColor[0.8894489166666667, 0.36688783333333336`, 0.174933625], 202 -> 
         RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
         84 -> RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
         222 -> RGBColor[
          0.8877089635416666, 0.35558467708333336`, 0.1727164609375], 35 -> 
         RGBColor[0.9013205, 0.561349, 0.212454], 115 -> 
         RGBColor[0.8146632083333333, 0.7064617916666667, 0.2537517083333333],
          49 -> RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 36 -> 
         RGBColor[
          0.9019334999999999, 0.5183949999999999, 0.20427800000000002`], 224 -> 
         RGBColor[0.8874511927083333, 0.35391013541666666`, 0.1723879921875], 
         156 -> RGBColor[0.901703625, 0.5345027499999999, 0.207344], 112 -> 
         RGBColor[
          0.8017326458333333, 0.7159093541666667, 0.25830139583333334`], 4 -> 
         RGBColor[0.266122, 0.486664, 0.802529], 1 -> 
         RGBColor[0.513417, 0.72992, 0.440682], 180 -> 
         RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
         124 -> RGBColor[0.9025465, 0.475441, 0.196102], 91 -> 
         RGBColor[0.9025465, 0.475441, 0.196102], 229 -> 
         RGBColor[0.81394484375, 0.70698665625, 0.25400446875], 193 -> 
         RGBColor[0.8881600625, 0.358515125, 0.17329128125], 197 -> 
         RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667],
          141 -> RGBColor[0.5369755, 0.7333695, 0.4201585], 225 -> 
         RGBColor[0.861033125, 0.1598115625, 0.13714884375], 173 -> 
         RGBColor[
          0.5507179583333334, 0.7353817083333334, 0.40818645833333334`], 78 -> 
         RGBColor[0.7106324375, 0.7412514375, 0.296770875], 189 -> 
         RGBColor[0.901703625, 0.5345027499999999, 0.207344], 28 -> 
         RGBColor[
          0.6563445000000001, 0.7431544999999999, 0.32887750000000004`], 198 -> 
         RGBColor[
          0.6462000208333334, 0.7432718958333333, 0.33506718750000003`], 65 -> 
         RGBColor[
          0.8884178333333334, 0.3601896666666667, 0.17361975000000002`], 218 -> 
         RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 161 -> 
         RGBColor[0.90269975, 0.46470249999999996`, 0.194058], 43 -> 
         RGBColor[
          0.5212698333333333, 0.7310698333333333, 0.43384083333333334`], 203 -> 
         RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
         145 -> RGBColor[0.6198243750000001, 0.743577125, 0.351160375], 45 -> 
         RGBColor[0.5526811666666667, 0.7356691666666667, 0.4064761666666667],
          63 -> RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585],
          56 -> RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
         18 -> RGBColor[0.8290305, 0.6959645, 0.2486965], 2 -> 
         RGBColor[0.266122, 0.486664, 0.802529], 246 -> 
         RGBColor[
          0.8121489322916666, 0.7082988177083334, 0.25463636979166665`], 42 -> 
         RGBColor[0.8608169999999999, 0.15812299999999999`, 0.1368535], 125 -> 
         RGBColor[
          0.9014782222222222, 0.4450331111111111, 0.19026216666666665`], 15 -> 
         RGBColor[0.5605340000000001, 0.736819, 0.399635], 25 -> 
         RGBColor[0.36048, 0.655759, 0.645692], 243 -> 
         RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 20 -> 
         RGBColor[0.901014, 0.582826, 0.216542], 155 -> 
         RGBColor[0.9011289375, 0.574772125, 0.215009], 244 -> 
         RGBColor[0.90164615625, 0.5385296875, 0.2081105], 241 -> 
         RGBColor[
          0.8121489322916666, 0.7082988177083334, 0.25463636979166665`], 195 -> 
         RGBColor[0.861465375, 0.1631886875, 0.13773953125], 48 -> 
         RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 86 -> 
         RGBColor[0.901090625, 0.57745675, 0.21552000000000002`], 70 -> 
         RGBColor[0.5173434166666667, 0.7304949166666667, 0.4372614166666667],
          196 -> RGBColor[0.861033125, 0.1598115625, 0.13714884375], 73 -> 
         RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 111 -> 
         RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333],
          212 -> RGBColor[0.88777340625, 0.3560033125, 0.172798578125], 187 -> 
         RGBColor[0.8613569062499999, 0.67234559375, 0.23732228125], 199 -> 
         RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 158 -> 
         RGBColor[0.9021250625, 0.504971875, 0.20172299999999999`], 40 -> 
         RGBColor[0.878107, 0.293208, 0.160481], 223 -> 
         RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 227 -> 
         RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`],
          123 -> RGBColor[0.902163375, 0.50228725, 0.201212], 211 -> 
         RGBColor[0.8881600625, 0.358515125, 0.17329128125], 134 -> 
         RGBColor[0.8737845, 0.25943675, 0.154574125], 68 -> 
         RGBColor[0.862546, 0.1716315, 0.13921624999999999`], 249 -> 
         RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333],
          201 -> RGBColor[
          0.71098208984375, 0.74116771484375, 0.2966211171875], 175 -> 
         RGBColor[
          0.5536627708333334, 0.7358128958333333, 0.40562102083333335`], 235 -> 
         RGBColor[
          0.8877411848958333, 0.3557939947916667, 0.17275751953125001`], 232 -> 
         RGBColor[0.90164615625, 0.5385296875, 0.2081105], 80 -> 
         RGBColor[0.77217125, 0.72651625, 0.2704135], 239 -> 
         RGBColor[0.861033125, 0.1598115625, 0.13714884375], 174 -> 
         RGBColor[0.5530083680555555, 0.735717076388889, 0.4061911180555556], 
         237 -> RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 96 -> 
         RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 98 -> 
         RGBColor[0.8634105, 0.17838575, 0.140397625], 110 -> 
         RGBColor[0.71342965625, 0.74058165625, 0.2955728125], 83 -> 
         RGBColor[0.81178975, 0.70856125, 0.25476275], 52 -> 
         RGBColor[0.77217125, 0.72651625, 0.2704135], 116 -> 
         RGBColor[0.8376508749999999, 0.689666125, 0.245663375], 250 -> 
         RGBColor[0.8122387278645833, 0.7082332096354167, 0.2546047747395833],
          44 -> RGBColor[0.5369755, 0.7333695, 0.4201585], 41 -> 
         RGBColor[0.867733, 0.212157, 0.1463045], 50 -> 
         RGBColor[0.716226875, 0.739911875, 0.29437475], 33 -> 
         RGBColor[0.8760126666666667, 0.641456, 0.22989], 247 -> 
         RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333],
          114 -> RGBColor[
          0.8089162916666666, 0.7106607083333333, 0.25577379166666664`], 74 -> 
         RGBColor[
          0.5566075833333334, 0.7362440833333334, 0.40305558333333336`], 152 -> 
         RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 58 -> 
         RGBColor[0.90116725, 0.5720875, 0.21449800000000002`], 251 -> 
         RGBColor[
          0.8124183190104166, 0.7081019934895834, 0.25454158463541665`], 82 -> 
         RGBColor[0.803169375, 0.714859625, 0.257795875], 103 -> 
         RGBColor[0.5369755, 0.7333695, 0.4201585], 31 -> 
         RGBColor[0.81178975, 0.70856125, 0.25476275], 121 -> 
         RGBColor[0.901703625, 0.5345027499999999, 0.207344], 205 -> 
         RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 185 -> 
         RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 23 -> 
         RGBColor[0.878107, 0.293208, 0.160481], 119 -> 
         RGBColor[0.9010523125, 0.580141375, 0.216031], 5 -> 
         RGBColor[0.705038, 0.742591, 0.299167], 67 -> 
         RGBColor[0.874649, 0.266191, 0.15575550000000002`], 236 -> 
         RGBColor[0.8876767421875, 0.355375359375, 0.17267540234375], 160 -> 
         RGBColor[0.90239325, 0.4861795, 0.198146], 159 -> 
         RGBColor[0.9022016875, 0.49960262499999997`, 0.200701], 64 -> 
         RGBColor[
          0.8925421666666666, 0.3869823333333333, 0.17887524999999999`], 8 -> 
         RGBColor[0.36048, 0.655759, 0.645692], 10 -> 
         RGBColor[0.794549, 0.721158, 0.260829], 90 -> 
         RGBColor[0.90208675, 0.5076565, 0.202234]}}]]}, 
    TagBox[GraphicsGroupBox[GraphicsComplexBox[CompressedData["
1:eJxVlX1wU2UWxu+UilhQK4ZOuo1wSUO4ZNOStiAp9OO0RYVCtaMyNKxCxCl0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       "], {
        {RGBColor[0.8, 0.8, 0.8], Opacity[0.7], Arrowheads[
         0.006615108115907495], ArrowBox[{1, 2}, 0.24999999988411048`], 
         ArrowBox[{1, 3}, 0.24999999988411048`], 
         ArrowBox[{2, 4}, 0.24999999988411048`], 
         ArrowBox[{3, 5}, 0.24999999988411048`], 
         ArrowBox[{3, 6}, 0.24999999988411048`], 
         ArrowBox[{4, 7}, 0.24999999988411048`], 
         ArrowBox[{4, 8}, 0.24999999988411048`], 
         ArrowBox[{5, 9}, 0.24999999988411048`], 
         ArrowBox[{5, 10}, 0.24999999988411048`], 
         ArrowBox[{6, 11}, 0.24999999988411048`], 
         ArrowBox[{6, 12}, 0.24999999988411048`], 
         ArrowBox[{6, 13}, 0.24999999988411048`], 
         ArrowBox[{8, 14}, 0.24999999988411048`], 
         ArrowBox[{9, 15}, 0.24999999988411048`], 
         ArrowBox[{9, 16}, 0.24999999988411048`], 
         ArrowBox[{10, 17}, 0.24999999988411048`], 
         ArrowBox[{10, 18}, 0.24999999988411048`], 
         ArrowBox[{11, 19}, 0.24999999988411048`], 
         ArrowBox[{11, 20}, 0.24999999988411048`], 
         ArrowBox[{12, 21}, 0.24999999988411048`], 
         ArrowBox[{12, 22}, 0.24999999988411048`], 
         ArrowBox[{13, 23}, 0.24999999988411048`], 
         ArrowBox[{13, 24}, 0.24999999988411048`], 
         ArrowBox[{14, 25}, 0.24999999988411048`], 
         ArrowBox[{15, 26}, 0.24999999988411048`], 
         ArrowBox[{15, 27}, 0.24999999988411048`], 
         ArrowBox[{16, 28}, 0.24999999988411048`], 
         ArrowBox[{17, 29}, 0.24999999988411048`], 
         ArrowBox[{17, 30}, 0.24999999988411048`], 
         ArrowBox[{18, 31}, 0.24999999988411048`], 
         ArrowBox[{18, 32}, 0.24999999988411048`], 
         ArrowBox[{19, 33}, 0.24999999988411048`], 
         ArrowBox[{20, 34}, 0.24999999988411048`], 
         ArrowBox[{20, 35}, 0.24999999988411048`], 
         ArrowBox[{21, 36}, 0.24999999988411048`], 
         ArrowBox[{21, 37}, 0.24999999988411048`], 
         ArrowBox[{22, 38}, 0.24999999988411048`], 
         ArrowBox[{22, 39}, 0.24999999988411048`], 
         ArrowBox[{23, 40}, 0.24999999988411048`], 
         ArrowBox[{24, 41}, 0.24999999988411048`], 
         ArrowBox[{24, 42}, 0.24999999988411048`], 
         ArrowBox[{26, 43}, 0.24999999988411048`], 
         ArrowBox[{26, 44}, 0.24999999988411048`], 
         ArrowBox[{26, 45}, 0.24999999988411048`], 
         ArrowBox[{27, 46}, 0.24999999988411048`], 
         ArrowBox[{27, 47}, 0.24999999988411048`], 
         ArrowBox[{28, 48}, 0.24999999988411048`], 
         ArrowBox[{28, 49}, 0.24999999988411048`], 
         ArrowBox[{29, 50}, 0.24999999988411048`], 
         ArrowBox[{29, 51}, 0.24999999988411048`], 
         ArrowBox[{30, 52}, 0.24999999988411048`], 
         ArrowBox[{31, 53}, 0.24999999988411048`], 
         ArrowBox[{31, 54}, 0.24999999988411048`], 
         ArrowBox[{31, 55}, 0.24999999988411048`], 
         ArrowBox[{32, 56}, 0.24999999988411048`], 
         ArrowBox[{33, 57}, 0.24999999988411048`], 
         ArrowBox[{35, 58}, 0.24999999988411048`], 
         ArrowBox[{35, 59}, 0.24999999988411048`], 
         ArrowBox[{36, 60}, 0.24999999988411048`], 
         ArrowBox[{36, 61}, 0.24999999988411048`], 
         ArrowBox[{37, 62}, 0.24999999988411048`], 
         ArrowBox[{38, 63}, 0.24999999988411048`], 
         ArrowBox[{39, 64}, 0.24999999988411048`], 
         ArrowBox[{39, 65}, 0.24999999988411048`], 
         ArrowBox[{40, 66}, 0.24999999988411048`], 
         ArrowBox[{40, 67}, 0.24999999988411048`], 
         ArrowBox[{42, 68}, 0.24999999988411048`], 
         ArrowBox[{42, 69}, 0.24999999988411048`], 
         ArrowBox[{43, 70}, 0.24999999988411048`], 
         ArrowBox[{43, 71}, 0.24999999988411048`], 
         ArrowBox[{44, 72}, 0.24999999988411048`], 
         ArrowBox[{45, 73}, 0.24999999988411048`], 
         ArrowBox[{45, 74}, 0.24999999988411048`], 
         ArrowBox[{46, 75}, 0.24999999988411048`], 
         ArrowBox[{48, 76}, 0.24999999988411048`], 
         ArrowBox[{49, 77}, 0.24999999988411048`], 
         ArrowBox[{50, 78}, 0.24999999988411048`], 
         ArrowBox[{50, 79}, 0.24999999988411048`], 
         ArrowBox[{52, 80}, 0.24999999988411048`], 
         ArrowBox[{53, 81}, 0.24999999988411048`], 
         ArrowBox[{53, 82}, 0.24999999988411048`], 
         ArrowBox[{54, 83}, 0.24999999988411048`], 
         ArrowBox[{56, 84}, 0.24999999988411048`], 
         ArrowBox[{57, 85}, 0.24999999988411048`], 
         ArrowBox[{58, 86}, 0.24999999988411048`], 
         ArrowBox[{58, 87}, 0.24999999988411048`], 
         ArrowBox[{60, 88}, 0.24999999988411048`], 
         ArrowBox[{60, 89}, 0.24999999988411048`], 
         ArrowBox[{61, 90}, 0.24999999988411048`], 
         ArrowBox[{62, 91}, 0.24999999988411048`], 
         ArrowBox[{63, 92}, 0.24999999988411048`], 
         ArrowBox[{64, 93}, 0.24999999988411048`], 
         ArrowBox[{65, 94}, 0.24999999988411048`], 
         ArrowBox[{65, 95}, 0.24999999988411048`], 
         ArrowBox[{67, 96}, 0.24999999988411048`], 
         ArrowBox[{67, 97}, 0.24999999988411048`], 
         ArrowBox[{68, 98}, 0.24999999988411048`], 
         ArrowBox[{68, 99}, 0.24999999988411048`], 
         ArrowBox[{69, 100}, 0.24999999988411048`], 
         ArrowBox[{69, 101}, 0.24999999988411048`], 
         ArrowBox[{71, 102}, 0.24999999988411048`], 
         ArrowBox[{72, 103}, 0.24999999988411048`], 
         ArrowBox[{73, 104}, 0.24999999988411048`], 
         ArrowBox[{74, 105}, 0.24999999988411048`], 
         ArrowBox[{74, 106}, 0.24999999988411048`], 
         ArrowBox[{75, 107}, 0.24999999988411048`], 
         ArrowBox[{76, 108}, 0.24999999988411048`], 
         ArrowBox[{78, 109}, 0.24999999988411048`], 
         ArrowBox[{78, 110}, 0.24999999988411048`], 
         ArrowBox[{81, 111}, 0.24999999988411048`], 
         ArrowBox[{82, 112}, 0.24999999988411048`], 
         ArrowBox[{82, 113}, 0.24999999988411048`], 
         ArrowBox[{83, 114}, 0.24999999988411048`], 
         ArrowBox[{83, 115}, 0.24999999988411048`], 
         ArrowBox[{84, 116}, 0.24999999988411048`], 
         ArrowBox[{84, 117}, 0.24999999988411048`], 
         ArrowBox[{85, 118}, 0.24999999988411048`], 
         ArrowBox[{86, 119}, 0.24999999988411048`], 
         ArrowBox[{86, 120}, 0.24999999988411048`], 
         ArrowBox[{88, 121}, 0.24999999988411048`], 
         ArrowBox[{90, 122}, 0.24999999988411048`], 
         ArrowBox[{90, 123}, 0.24999999988411048`], 
         ArrowBox[{91, 124}, 0.24999999988411048`], 
         ArrowBox[{92, 125}, 0.24999999988411048`], 
         ArrowBox[{92, 126}, 0.24999999988411048`], 
         ArrowBox[{92, 127}, 0.24999999988411048`], 
         ArrowBox[{94, 128}, 0.24999999988411048`], 
         ArrowBox[{94, 129}, 0.24999999988411048`], 
         ArrowBox[{95, 130}, 0.24999999988411048`], 
         ArrowBox[{95, 131}, 0.24999999988411048`], 
         ArrowBox[{96, 132}, 0.24999999988411048`], 
         ArrowBox[{96, 133}, 0.24999999988411048`], 
         ArrowBox[{97, 134}, 0.24999999988411048`], 
         ArrowBox[{97, 135}, 0.24999999988411048`], 
         ArrowBox[{98, 136}, 0.24999999988411048`], 
         ArrowBox[{98, 137}, 0.24999999988411048`], 
         ArrowBox[{99, 138}, 0.24999999988411048`], 
         ArrowBox[{99, 139}, 0.24999999988411048`], 
         ArrowBox[{101, 140}, 0.24999999988411048`], 
         ArrowBox[{103, 141}, 0.24999999988411048`], 
         ArrowBox[{104, 142}, 0.24999999988411048`], 
         ArrowBox[{105, 143}, 0.24999999988411048`], 
         ArrowBox[{105, 144}, 0.24999999988411048`], 
         ArrowBox[{108, 145}, 0.24999999988411048`], 
         ArrowBox[{108, 146}, 0.24999999988411048`], 
         ArrowBox[{110, 147}, 0.24999999988411048`], 
         ArrowBox[{110, 148}, 0.24999999988411048`], 
         ArrowBox[{111, 149}, 0.24999999988411048`], 
         ArrowBox[{115, 150}, 0.24999999988411048`], 
         ArrowBox[{115, 151}, 0.24999999988411048`], 
         ArrowBox[{117, 152}, 0.24999999988411048`], 
         ArrowBox[{117, 153}, 0.24999999988411048`], 
         ArrowBox[{119, 154}, 0.24999999988411048`], 
         ArrowBox[{120, 155}, 0.24999999988411048`], 
         ArrowBox[{121, 156}, 0.24999999988411048`], 
         ArrowBox[{122, 157}, 0.24999999988411048`], 
         ArrowBox[{123, 158}, 0.24999999988411048`], 
         ArrowBox[{123, 159}, 0.24999999988411048`], 
         ArrowBox[{124, 160}, 0.24999999988411048`], 
         ArrowBox[{124, 161}, 0.24999999988411048`], 
         ArrowBox[{126, 162}, 0.24999999988411048`], 
         ArrowBox[{126, 163}, 0.24999999988411048`], 
         ArrowBox[{130, 164}, 0.24999999988411048`], 
         ArrowBox[{133, 165}, 0.24999999988411048`], 
         ArrowBox[{137, 166}, 0.24999999988411048`], 
         ArrowBox[{137, 167}, 0.24999999988411048`], 
         ArrowBox[{139, 168}, 0.24999999988411048`], 
         ArrowBox[{140, 169}, 0.24999999988411048`], 
         ArrowBox[{140, 170}, 0.24999999988411048`], 
         ArrowBox[{140, 171}, 0.24999999988411048`], 
         ArrowBox[{142, 172}, 0.24999999988411048`], 
         ArrowBox[{142, 173}, 0.24999999988411048`], 
         ArrowBox[{143, 174}, 0.24999999988411048`], 
         ArrowBox[{143, 175}, 0.24999999988411048`], 
         ArrowBox[{143, 176}, 0.24999999988411048`], 
         ArrowBox[{146, 177}, 0.24999999988411048`], 
         ArrowBox[{146, 178}, 0.24999999988411048`], 
         ArrowBox[{147, 179}, 0.24999999988411048`], 
         ArrowBox[{147, 180}, 0.24999999988411048`], 
         ArrowBox[{148, 181}, 0.24999999988411048`], 
         ArrowBox[{149, 182}, 0.24999999988411048`], 
         ArrowBox[{149, 183}, 0.24999999988411048`], 
         ArrowBox[{150, 184}, 0.24999999988411048`], 
         ArrowBox[{152, 185}, 0.24999999988411048`], 
         ArrowBox[{153, 186}, 0.24999999988411048`], 
         ArrowBox[{153, 187}, 0.24999999988411048`], 
         ArrowBox[{155, 188}, 0.24999999988411048`], 
         ArrowBox[{156, 189}, 0.24999999988411048`], 
         ArrowBox[{157, 190}, 0.24999999988411048`], 
         ArrowBox[{157, 191}, 0.24999999988411048`], 
         ArrowBox[{163, 192}, 0.24999999988411048`], 
         ArrowBox[{164, 193}, 0.24999999988411048`], 
         ArrowBox[{164, 194}, 0.24999999988411048`], 
         ArrowBox[{168, 195}, 0.24999999988411048`], 
         ArrowBox[{168, 196}, 0.24999999988411048`], 
         ArrowBox[{172, 197}, 0.24999999988411048`], 
         ArrowBox[{178, 198}, 0.24999999988411048`], 
         ArrowBox[{178, 199}, 0.24999999988411048`], 
         ArrowBox[{178, 200}, 0.24999999988411048`], 
         ArrowBox[{179, 201}, 0.24999999988411048`], 
         ArrowBox[{179, 202}, 0.24999999988411048`], 
         ArrowBox[{180, 203}, 0.24999999988411048`], 
         ArrowBox[{184, 204}, 0.24999999988411048`], 
         ArrowBox[{186, 205}, 0.24999999988411048`], 
         ArrowBox[{186, 206}, 0.24999999988411048`], 
         ArrowBox[{188, 207}, 0.24999999988411048`], 
         ArrowBox[{188, 208}, 0.24999999988411048`], 
         ArrowBox[{189, 209}, 0.24999999988411048`], 
         ArrowBox[{189, 210}, 0.24999999988411048`], 
         ArrowBox[{193, 211}, 0.24999999988411048`], 
         ArrowBox[{194, 212}, 0.24999999988411048`], 
         ArrowBox[{194, 213}, 0.24999999988411048`], 
         ArrowBox[{196, 214}, 0.24999999988411048`], 
         ArrowBox[{201, 215}, 0.24999999988411048`], 
         ArrowBox[{202, 216}, 0.24999999988411048`], 
         ArrowBox[{204, 217}, 0.24999999988411048`], 
         ArrowBox[{205, 218}, 0.24999999988411048`], 
         ArrowBox[{207, 219}, 0.24999999988411048`], 
         ArrowBox[{209, 220}, 0.24999999988411048`], 
         ArrowBox[{212, 221}, 0.24999999988411048`], 
         ArrowBox[{212, 222}, 0.24999999988411048`], 
         ArrowBox[{213, 223}, 0.24999999988411048`], 
         ArrowBox[{213, 224}, 0.24999999988411048`], 
         ArrowBox[{214, 225}, 0.24999999988411048`], 
         ArrowBox[{215, 226}, 0.24999999988411048`], 
         ArrowBox[{215, 227}, 0.24999999988411048`], 
         ArrowBox[{217, 228}, 0.24999999988411048`], 
         ArrowBox[{217, 229}, 0.24999999988411048`], 
         ArrowBox[{219, 230}, 0.24999999988411048`], 
         ArrowBox[{219, 231}, 0.24999999988411048`], 
         ArrowBox[{220, 232}, 0.24999999988411048`], 
         ArrowBox[{220, 233}, 0.24999999988411048`], 
         ArrowBox[{221, 234}, 0.24999999988411048`], 
         ArrowBox[{222, 235}, 0.24999999988411048`], 
         ArrowBox[{222, 236}, 0.24999999988411048`], 
         ArrowBox[{223, 237}, 0.24999999988411048`], 
         ArrowBox[{225, 238}, 0.24999999988411048`], 
         ArrowBox[{225, 239}, 0.24999999988411048`], 
         ArrowBox[{225, 240}, 0.24999999988411048`], 
         ArrowBox[{228, 241}, 0.24999999988411048`], 
         ArrowBox[{228, 242}, 0.24999999988411048`], 
         ArrowBox[{231, 243}, 0.24999999988411048`], 
         ArrowBox[{232, 244}, 0.24999999988411048`], 
         ArrowBox[{234, 245}, 0.24999999988411048`], 
         ArrowBox[{241, 246}, 0.24999999988411048`], 
         ArrowBox[{246, 247}, 0.24999999988411048`], 
         ArrowBox[{246, 248}, 0.24999999988411048`], 
         ArrowBox[{247, 249}, 0.24999999988411048`], 
         ArrowBox[{248, 250}, 0.24999999988411048`], 
         ArrowBox[{248, 251}, 0.24999999988411048`], 
         ArrowBox[{249, 252}, 0.24999999988411048`], 
         ArrowBox[{249, 253}, 0.24999999988411048`], 
         ArrowBox[{253, 254}, 0.24999999988411048`]}, 
        {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], 
         {RGBColor[0.513417, 0.72992, 0.440682], 
          DiskBox[1, 0.24999999988411048]}, 
         {RGBColor[0.266122, 0.486664, 0.802529], 
          DiskBox[2, 0.24999999988411048]}, 
         {RGBColor[0.863512, 0.670771, 0.236564], 
          DiskBox[3, 0.24999999988411048]}, 
         {RGBColor[0.266122, 0.486664, 0.802529], 
          DiskBox[4, 0.24999999988411048]}, 
         {RGBColor[0.705038, 0.742591, 0.299167], 
          DiskBox[5, 0.24999999988411048]}, 
         {RGBColor[0.902853, 0.453964, 0.192014], 
          DiskBox[6, 0.24999999988411048]}, 
         {RGBColor[0.250728, 0.225386, 0.769152], 
          DiskBox[7, 0.24999999988411048]}, 
         {RGBColor[0.36048, 0.655759, 0.645692], 
          DiskBox[8, 0.24999999988411048]}, 
         {RGBColor[0.607651, 0.743718, 0.358588], 
          DiskBox[9, 0.24999999988411048]}, 
         {RGBColor[0.794549, 0.721158, 0.260829], 
          DiskBox[10, 0.24999999988411048]}, 
         {RGBColor[0.8885133333333333, 0.6121409999999999, 0.223216], 
          DiskBox[11, 0.24999999988411048]}, 
         {RGBColor[0.902853, 0.453964, 0.192014], 
          DiskBox[12, 0.24999999988411048]}, 
         {RGBColor[0.8711909999999999, 0.23917400000000003`, 0.15103], 
          DiskBox[13, 0.24999999988411048]}, 
         {RGBColor[0.36048, 0.655759, 0.645692], 
          DiskBox[14, 0.24999999988411048]}, 
         {RGBColor[0.5605340000000001, 0.736819, 0.399635], 
          DiskBox[15, 0.24999999988411048]}, 
         {RGBColor[
          0.6563445000000001, 0.7431544999999999, 0.32887750000000004`], 
          DiskBox[16, 0.24999999988411048]}, 
         {RGBColor[0.7497935, 0.7318745, 0.27999799999999997`], 
          DiskBox[17, 0.24999999988411048]}, 
         {RGBColor[0.8290305, 0.6959645, 0.2486965], 
          DiskBox[18, 0.24999999988411048]}, 
         {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
          DiskBox[19, 0.24999999988411048]}, 
         {RGBColor[0.901014, 0.582826, 0.216542], 
          DiskBox[20, 0.24999999988411048]}, 
         {RGBColor[0.90224, 0.49691799999999997`, 0.20019], 
          DiskBox[21, 0.24999999988411048]}, 
         {RGBColor[0.8946043333333333, 0.40037866666666666`, 0.181503], 
          DiskBox[22, 0.24999999988411048]}, 
         {RGBColor[0.878107, 0.293208, 0.160481], 
          DiskBox[23, 0.24999999988411048]}, 
         {RGBColor[0.864275, 0.18514000000000003`, 0.141579], 
          DiskBox[24, 0.24999999988411048]}, 
         {RGBColor[0.36048, 0.655759, 0.645692], 
          DiskBox[25, 0.24999999988411048]}, 
         {RGBColor[0.5369755, 0.7333695, 0.4201585], 
          DiskBox[26, 0.24999999988411048]}, 
         {RGBColor[0.5840925, 0.7402685, 0.37911150000000005`], 
          DiskBox[27, 0.24999999988411048]}, 
         {RGBColor[
          0.6563445000000001, 0.7431544999999999, 0.32887750000000004`], 
          DiskBox[28, 0.24999999988411048]}, 
         {RGBColor[0.72741575, 0.73723275, 0.2895825], 
          DiskBox[29, 0.24999999988411048]}, 
         {RGBColor[0.77217125, 0.72651625, 0.2704135], 
          DiskBox[30, 0.24999999988411048]}, 
         {RGBColor[0.81178975, 0.70856125, 0.25476275], 
          DiskBox[31, 0.24999999988411048]}, 
         {RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
          DiskBox[32, 0.24999999988411048]}, 
         {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
          DiskBox[33, 0.24999999988411048]}, 
         {RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
          DiskBox[34, 0.24999999988411048]}, 
         {RGBColor[0.9013205, 0.561349, 0.212454], 
          DiskBox[35, 0.24999999988411048]}, 
         {RGBColor[
          0.9019334999999999, 0.5183949999999999, 0.20427800000000002`], 
          DiskBox[36, 0.24999999988411048]}, 
         {RGBColor[0.9025465, 0.475441, 0.196102], 
          DiskBox[37, 0.24999999988411048]}, 
         {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
          DiskBox[38, 0.24999999988411048]}, 
         {RGBColor[0.8904799999999999, 0.373586, 0.1762475], 
          DiskBox[39, 0.24999999988411048]}, 
         {RGBColor[0.878107, 0.293208, 0.160481], 
          DiskBox[40, 0.24999999988411048]}, 
         {RGBColor[0.867733, 0.212157, 0.1463045], 
          DiskBox[41, 0.24999999988411048]}, 
         {RGBColor[0.8608169999999999, 0.15812299999999999`, 0.1368535], 
          DiskBox[42, 0.24999999988411048]}, 
         {RGBColor[
          0.5212698333333333, 0.7310698333333333, 0.43384083333333334`], 
          DiskBox[43, 0.24999999988411048]}, 
         {RGBColor[0.5369755, 0.7333695, 0.4201585], 
          DiskBox[44, 0.24999999988411048]}, 
         {RGBColor[
          0.5526811666666667, 0.7356691666666667, 0.4064761666666667], 
          DiskBox[45, 0.24999999988411048]}, 
         {RGBColor[0.57231325, 0.73854375, 0.38937325], 
          DiskBox[46, 0.24999999988411048]}, 
         {RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
          DiskBox[47, 0.24999999988411048]}, 
         {RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 
          DiskBox[48, 0.24999999988411048]}, 
         {RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
          DiskBox[49, 0.24999999988411048]}, 
         {RGBColor[0.716226875, 0.739911875, 0.29437475], 
          DiskBox[50, 0.24999999988411048]}, 
         {RGBColor[0.738604625, 0.734553625, 0.28479025], 
          DiskBox[51, 0.24999999988411048]}, 
         {RGBColor[0.77217125, 0.72651625, 0.2704135], 
          DiskBox[52, 0.24999999988411048]}, 
         {RGBColor[
          0.8002959166666667, 0.7169590833333332, 0.25880691666666666`], 
          DiskBox[53, 0.24999999988411048]}, 
         {RGBColor[0.81178975, 0.70856125, 0.25476275], 
          DiskBox[54, 0.24999999988411048]}, 
         {RGBColor[
          0.8232835833333333, 0.7001634166666666, 0.2507185833333333], 
          DiskBox[55, 0.24999999988411048]}, 
         {RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
          DiskBox[56, 0.24999999988411048]}, 
         {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
          DiskBox[57, 0.24999999988411048]}, 
         {RGBColor[0.90116725, 0.5720875, 0.21449800000000002`], 
          DiskBox[58, 0.24999999988411048]}, 
         {RGBColor[0.90147375, 0.5506105, 0.21041], 
          DiskBox[59, 0.24999999988411048]}, 
         {RGBColor[0.90178025, 0.5291334999999999, 0.206322], 
          DiskBox[60, 0.24999999988411048]}, 
         {RGBColor[0.90208675, 0.5076565, 0.202234], 
          DiskBox[61, 0.24999999988411048]}, 
         {RGBColor[0.9025465, 0.475441, 0.196102], 
          DiskBox[62, 0.24999999988411048]}, 
         {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
          DiskBox[63, 0.24999999988411048]}, 
         {RGBColor[
          0.8925421666666666, 0.3869823333333333, 0.17887524999999999`], 
          DiskBox[64, 0.24999999988411048]}, 
         {RGBColor[
          0.8884178333333334, 0.3601896666666667, 0.17361975000000002`], 
          DiskBox[65, 0.24999999988411048]}, 
         {RGBColor[0.8822313333333334, 0.3200006666666667, 0.1657365], 
          DiskBox[66, 0.24999999988411048]}, 
         {RGBColor[0.874649, 0.266191, 0.15575550000000002`], 
          DiskBox[67, 0.24999999988411048]}, 
         {RGBColor[0.862546, 0.1716315, 0.13921624999999999`], 
          DiskBox[68, 0.24999999988411048]}, 
         {RGBColor[0.859088, 0.1446145, 0.13449075], 
          DiskBox[69, 0.24999999988411048]}, 
         {RGBColor[
          0.5173434166666667, 0.7304949166666667, 0.4372614166666667], 
          DiskBox[70, 0.24999999988411048]}, 
         {RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
          DiskBox[71, 0.24999999988411048]}, 
         {RGBColor[0.5369755, 0.7333695, 0.4201585], 
          DiskBox[72, 0.24999999988411048]}, 
         {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
          DiskBox[73, 0.24999999988411048]}, 
         {RGBColor[
          0.5566075833333334, 0.7362440833333334, 0.40305558333333336`], 
          DiskBox[74, 0.24999999988411048]}, 
         {RGBColor[0.57231325, 0.73854375, 0.38937325], 
          DiskBox[75, 0.24999999988411048]}, 
         {RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 
          DiskBox[76, 0.24999999988411048]}, 
         {RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
          DiskBox[77, 0.24999999988411048]}, 
         {RGBColor[0.7106324375, 0.7412514375, 0.296770875], 
          DiskBox[78, 0.24999999988411048]}, 
         {RGBColor[0.7218213125, 0.7385723125, 0.291978625], 
          DiskBox[79, 0.24999999988411048]}, 
         {RGBColor[0.77217125, 0.72651625, 0.2704135], 
          DiskBox[80, 0.24999999988411048]}, 
         {RGBColor[
          0.7974224583333333, 0.7190585416666666, 0.2598179583333333], 
          DiskBox[81, 0.24999999988411048]}, 
         {RGBColor[0.803169375, 0.714859625, 0.257795875], 
          DiskBox[82, 0.24999999988411048]}, 
         {RGBColor[0.81178975, 0.70856125, 0.25476275], 
          DiskBox[83, 0.24999999988411048]}, 
         {RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
          DiskBox[84, 0.24999999988411048]}, 
         {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
          DiskBox[85, 0.24999999988411048]}, 
         {RGBColor[0.901090625, 0.57745675, 0.21552000000000002`], 
          DiskBox[86, 0.24999999988411048]}, 
         {RGBColor[0.901243875, 0.56671825, 0.213476], 
          DiskBox[87, 0.24999999988411048]}, 
         {RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
          DiskBox[88, 0.24999999988411048]}, 
         {RGBColor[0.901856875, 0.5237642499999999, 0.2053], 
          DiskBox[89, 0.24999999988411048]}, 
         {RGBColor[0.90208675, 0.5076565, 0.202234], 
          DiskBox[90, 0.24999999988411048]}, 
         {RGBColor[0.9025465, 0.475441, 0.196102], 
          DiskBox[91, 0.24999999988411048]}, 
         {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
          DiskBox[92, 0.24999999988411048]}, 
         {RGBColor[
          0.8925421666666666, 0.3869823333333333, 0.17887524999999999`], 
          DiskBox[93, 0.24999999988411048]}, 
         {RGBColor[0.8894489166666667, 0.36688783333333336`, 0.174933625], 
          DiskBox[94, 0.24999999988411048]}, 
         {RGBColor[0.88738675, 0.3534915, 0.172305875], 
          DiskBox[95, 0.24999999988411048]}, 
         {RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 
          DiskBox[96, 0.24999999988411048]}, 
         {RGBColor[
          0.8729199999999999, 0.25268250000000003`, 0.15339275000000002`], 
          DiskBox[97, 0.24999999988411048]}, 
         {RGBColor[0.8634105, 0.17838575, 0.140397625], 
          DiskBox[98, 0.24999999988411048]}, 
         {RGBColor[0.8616815, 0.16487725, 0.138034875], 
          DiskBox[99, 0.24999999988411048]}, 
         {RGBColor[0.8599525, 0.15136875, 0.135672125], 
          DiskBox[100, 0.24999999988411048]}, 
         {RGBColor[0.8582235, 0.13786025, 0.133309375], 
          DiskBox[101, 0.24999999988411048]}, 
         {RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
          DiskBox[102, 0.24999999988411048]}, 
         {RGBColor[0.5369755, 0.7333695, 0.4201585], 
          DiskBox[103, 0.24999999988411048]}, 
         {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
          DiskBox[104, 0.24999999988411048]}, 
         {RGBColor[0.5546443750000001, 0.735956625, 0.404765875], 
          DiskBox[105, 0.24999999988411048]}, 
         {RGBColor[
          0.5585707916666667, 0.7365315416666667, 0.40134529166666666`], 
          DiskBox[106, 0.24999999988411048]}, 
         {RGBColor[0.57231325, 0.73854375, 0.38937325], 
          DiskBox[107, 0.24999999988411048]}, 
         {RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 
          DiskBox[108, 0.24999999988411048]}, 
         {RGBColor[
          0.7078352187500001, 0.7419212187499999, 0.29796893750000003`], 
          DiskBox[109, 0.24999999988411048]}, 
         {RGBColor[0.71342965625, 0.74058165625, 0.2955728125], 
          DiskBox[110, 0.24999999988411048]}, 
         {RGBColor[
          0.7974224583333333, 0.7190585416666666, 0.2598179583333333], 
          DiskBox[111, 0.24999999988411048]}, 
         {RGBColor[
          0.8017326458333333, 0.7159093541666667, 0.25830139583333334`], 
          DiskBox[112, 0.24999999988411048]}, 
         {RGBColor[
          0.8046061041666667, 0.7138098958333333, 0.2572903541666666], 
          DiskBox[113, 0.24999999988411048]}, 
         {RGBColor[
          0.8089162916666666, 0.7106607083333333, 0.25577379166666664`], 
          DiskBox[114, 0.24999999988411048]}, 
         {RGBColor[
          0.8146632083333333, 0.7064617916666667, 0.2537517083333333], 
          DiskBox[115, 0.24999999988411048]}, 
         {RGBColor[0.8376508749999999, 0.689666125, 0.245663375], 
          DiskBox[116, 0.24999999988411048]}, 
         {RGBColor[0.8548916249999999, 0.677069375, 0.239597125], 
          DiskBox[117, 0.24999999988411048]}, 
         {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
          DiskBox[118, 0.24999999988411048]}, 
         {RGBColor[0.9010523125, 0.580141375, 0.216031], 
          DiskBox[119, 0.24999999988411048]}, 
         {RGBColor[0.9011289375, 0.574772125, 0.215009], 
          DiskBox[120, 0.24999999988411048]}, 
         {RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
          DiskBox[121, 0.24999999988411048]}, 
         {RGBColor[0.902010125, 0.51302575, 0.203256], 
          DiskBox[122, 0.24999999988411048]}, 
         {RGBColor[0.902163375, 0.50228725, 0.201212], 
          DiskBox[123, 0.24999999988411048]}, 
         {RGBColor[0.9025465, 0.475441, 0.196102], 
          DiskBox[124, 0.24999999988411048]}, 
         {RGBColor[
          0.9014782222222222, 0.4450331111111111, 0.19026216666666665`], 
          DiskBox[125, 0.24999999988411048]}, 
         {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
          DiskBox[126, 0.24999999988411048]}, 
         {RGBColor[
          0.8959791111111111, 0.40930955555555554`, 0.18325483333333334`], 
          DiskBox[127, 0.24999999988411048]}, 
         {RGBColor[0.8899644583333334, 0.3702369166666667, 0.1755905625], 
          DiskBox[128, 0.24999999988411048]}, 
         {RGBColor[0.888933375, 0.36353875, 0.1742766875], 
          DiskBox[129, 0.24999999988411048]}, 
         {RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 
          DiskBox[130, 0.24999999988411048]}, 
         {RGBColor[
          0.8868712083333333, 0.3501424166666667, 0.17164893750000002`], 
          DiskBox[131, 0.24999999988411048]}, 
         {RGBColor[0.8772424999999999, 0.28645375, 0.159299625], 
          DiskBox[132, 0.24999999988411048]}, 
         {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
          DiskBox[133, 0.24999999988411048]}, 
         {RGBColor[0.8737845, 0.25943675, 0.154574125], 
          DiskBox[134, 0.24999999988411048]}, 
         {RGBColor[0.8720555, 0.24592825000000001`, 0.152211375], 
          DiskBox[135, 0.24999999988411048]}, 
         {RGBColor[0.86384275, 0.181762875, 0.1409883125], 
          DiskBox[136, 0.24999999988411048]}, 
         {RGBColor[0.86297825, 0.17500862500000003`, 0.1398069375], 
          DiskBox[137, 0.24999999988411048]}, 
         {RGBColor[0.86211375, 0.168254375, 0.1386255625], 
          DiskBox[138, 0.24999999988411048]}, 
         {RGBColor[0.86124925, 0.161500125, 0.1374441875], 
          DiskBox[139, 0.24999999988411048]}, 
         {RGBColor[0.8582235, 0.13786025, 0.133309375], 
          DiskBox[140, 0.24999999988411048]}, 
         {RGBColor[0.5369755, 0.7333695, 0.4201585], 
          DiskBox[141, 0.24999999988411048]}, 
         {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
          DiskBox[142, 0.24999999988411048]}, 
         {RGBColor[
          0.5536627708333334, 0.7358128958333333, 0.40562102083333335`], 
          DiskBox[143, 0.24999999988411048]}, 
         {RGBColor[
          0.5556259791666667, 0.7361003541666666, 0.4039107291666667], 
          DiskBox[144, 0.24999999988411048]}, 
         {RGBColor[0.6198243750000001, 0.743577125, 0.351160375], 
          DiskBox[145, 0.24999999988411048]}, 
         {RGBColor[0.6441711250000001, 0.743295375, 0.33630512500000004`], 
          DiskBox[146, 0.24999999988411048]}, 
         {RGBColor[0.7120310468750001, 0.740916546875, 0.29617184375], 
          DiskBox[147, 0.24999999988411048]}, 
         {RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
          DiskBox[148, 0.24999999988411048]}, 
         {RGBColor[
          0.7974224583333333, 0.7190585416666666, 0.2598179583333333], 
          DiskBox[149, 0.24999999988411048]}, 
         {RGBColor[
          0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 
          DiskBox[150, 0.24999999988411048]}, 
         {RGBColor[0.8160999375, 0.7054120625, 0.2532461875], 
          DiskBox[151, 0.24999999988411048]}, 
         {RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
          DiskBox[152, 0.24999999988411048]}, 
         {RGBColor[0.8592018124999999, 0.6739201875, 0.23808056249999998`], 
          DiskBox[153, 0.24999999988411048]}, 
         {RGBColor[0.9010523125, 0.580141375, 0.216031], 
          DiskBox[154, 0.24999999988411048]}, 
         {RGBColor[0.9011289375, 0.574772125, 0.215009], 
          DiskBox[155, 0.24999999988411048]}, 
         {RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
          DiskBox[156, 0.24999999988411048]}, 
         {RGBColor[0.902010125, 0.51302575, 0.203256], 
          DiskBox[157, 0.24999999988411048]}, 
         {RGBColor[0.9021250625, 0.504971875, 0.20172299999999999`], 
          DiskBox[158, 0.24999999988411048]}, 
         {RGBColor[0.9022016875, 0.49960262499999997`, 0.200701], 
          DiskBox[159, 0.24999999988411048]}, 
         {RGBColor[0.90239325, 0.4861795, 0.198146], 
          DiskBox[160, 0.24999999988411048]}, 
         {RGBColor[0.90269975, 0.46470249999999996`, 0.194058], 
          DiskBox[161, 0.24999999988411048]}, 
         {RGBColor[
          0.8994160555555556, 0.43163677777777776`, 0.18763441666666666`], 
          DiskBox[162, 0.24999999988411048]}, 
         {RGBColor[
          0.8980412777777778, 0.4227058888888889, 0.18588258333333332`], 
          DiskBox[163, 0.24999999988411048]}, 
         {RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 
          DiskBox[164, 0.24999999988411048]}, 
         {RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 
          DiskBox[165, 0.24999999988411048]}, 
         {RGBColor[0.863194375, 0.17669718750000002`, 0.14010228125000002`], 
          DiskBox[166, 0.24999999988411048]}, 
         {RGBColor[0.8627621249999999, 0.17332006249999998`, 0.13951159375], 
          DiskBox[167, 0.24999999988411048]}, 
         {RGBColor[0.86124925, 0.161500125, 0.1374441875], 
          DiskBox[168, 0.24999999988411048]}, 
         {RGBColor[
          0.8587998333333333, 0.14236308333333333`, 0.13409695833333332`], 
          DiskBox[169, 0.24999999988411048]}, 
         {RGBColor[0.8582235, 0.13786025, 0.133309375], 
          DiskBox[170, 0.24999999988411048]}, 
         {RGBColor[
          0.8576471666666666, 0.13335741666666667`, 0.13252179166666667`], 
          DiskBox[171, 0.24999999988411048]}, 
         {RGBColor[
          0.5467915416666667, 0.7348067916666666, 0.4116070416666667], 
          DiskBox[172, 0.24999999988411048]}, 
         {RGBColor[
          0.5507179583333334, 0.7353817083333334, 0.40818645833333334`], 
          DiskBox[173, 0.24999999988411048]}, 
         {RGBColor[0.5530083680555555, 0.735717076388889, 0.4061911180555556],
           DiskBox[174, 0.24999999988411048]}, 
         {RGBColor[
          0.5536627708333334, 0.7358128958333333, 0.40562102083333335`], 
          DiskBox[175, 0.24999999988411048]}, 
         {RGBColor[
          0.5543171736111111, 0.7359087152777778, 0.4050509236111111], 
          DiskBox[176, 0.24999999988411048]}, 
         {RGBColor[0.6380844375000001, 0.7433658125, 0.3400189375], 
          DiskBox[177, 0.24999999988411048]}, 
         {RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
          DiskBox[178, 0.24999999988411048]}, 
         {RGBColor[0.7113317421875001, 0.7410839921875, 0.296471359375], 
          DiskBox[179, 0.24999999988411048]}, 
         {RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`],
           DiskBox[180, 0.24999999988411048]}, 
         {RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 
          DiskBox[181, 0.24999999988411048]}, 
         {RGBColor[
          0.7959857291666667, 0.7201082708333333, 0.26032347916666665`], 
          DiskBox[182, 0.24999999988411048]}, 
         {RGBColor[0.7988591875, 0.7180088124999999, 0.2593124375], 
          DiskBox[183, 0.24999999988411048]}, 
         {RGBColor[
          0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 
          DiskBox[184, 0.24999999988411048]}, 
         {RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 
          DiskBox[185, 0.24999999988411048]}, 
         {RGBColor[0.8570467187499999, 0.67549478125, 0.23883884375], 
          DiskBox[186, 0.24999999988411048]}, 
         {RGBColor[0.8613569062499999, 0.67234559375, 0.23732228125], 
          DiskBox[187, 0.24999999988411048]}, 
         {RGBColor[0.9011289375, 0.574772125, 0.215009], 
          DiskBox[188, 0.24999999988411048]}, 
         {RGBColor[0.901703625, 0.5345027499999999, 0.207344], 
          DiskBox[189, 0.24999999988411048]}, 
         {RGBColor[0.9019718125, 0.5157103749999999, 0.203767], 
          DiskBox[190, 0.24999999988411048]}, 
         {RGBColor[0.9020484375, 0.510341125, 0.202745], 
          DiskBox[191, 0.24999999988411048]}, 
         {RGBColor[
          0.8980412777777778, 0.4227058888888889, 0.18588258333333332`], 
          DiskBox[192, 0.24999999988411048]}, 
         {RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
          DiskBox[193, 0.24999999988411048]}, 
         {RGBColor[0.8876445208333333, 0.35516604166666665`, 0.17263434375], 
          DiskBox[194, 0.24999999988411048]}, 
         {RGBColor[0.861465375, 0.1631886875, 0.13773953125], 
          DiskBox[195, 0.24999999988411048]}, 
         {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
          DiskBox[196, 0.24999999988411048]}, 
         {RGBColor[
          0.5467915416666667, 0.7348067916666666, 0.4116070416666667], 
          DiskBox[197, 0.24999999988411048]}, 
         {RGBColor[
          0.6462000208333334, 0.7432718958333333, 0.33506718750000003`], 
          DiskBox[198, 0.24999999988411048]}, 
         {RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 
          DiskBox[199, 0.24999999988411048]}, 
         {RGBColor[0.6543156041666667, 0.7431779791666666, 0.3301154375], 
          DiskBox[200, 0.24999999988411048]}, 
         {RGBColor[0.71098208984375, 0.74116771484375, 0.2966211171875], 
          DiskBox[201, 0.24999999988411048]}, 
         {RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
          DiskBox[202, 0.24999999988411048]}, 
         {RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`],
           DiskBox[203, 0.24999999988411048]}, 
         {RGBColor[
          0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 
          DiskBox[204, 0.24999999988411048]}, 
         {RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 
          DiskBox[205, 0.24999999988411048]}, 
         {RGBColor[0.858124265625, 0.674707484375, 0.238459703125], 
          DiskBox[206, 0.24999999988411048]}, 
         {RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
          DiskBox[207, 0.24999999988411048]}, 
         {RGBColor[0.9011480937499999, 0.5734298124999999, 0.2147535], 
          DiskBox[208, 0.24999999988411048]}, 
         {RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
          DiskBox[209, 0.24999999988411048]}, 
         {RGBColor[0.9017419375, 0.5318181249999999, 0.20683300000000002`], 
          DiskBox[210, 0.24999999988411048]}, 
         {RGBColor[0.8881600625, 0.358515125, 0.17329128125], 
          DiskBox[211, 0.24999999988411048]}, 
         {RGBColor[0.88777340625, 0.3560033125, 0.172798578125], 
          DiskBox[212, 0.24999999988411048]}, 
         {RGBColor[0.8875156354166667, 0.35432877083333336`, 0.172470109375], 
          DiskBox[213, 0.24999999988411048]}, 
         {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
          DiskBox[214, 0.24999999988411048]}, 
         {RGBColor[0.71098208984375, 0.74116771484375, 0.2966211171875], 
          DiskBox[215, 0.24999999988411048]}, 
         {RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
          DiskBox[216, 0.24999999988411048]}, 
         {RGBColor[
          0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 
          DiskBox[217, 0.24999999988411048]}, 
         {RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 
          DiskBox[218, 0.24999999988411048]}, 
         {RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 
          DiskBox[219, 0.24999999988411048]}, 
         {RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 
          DiskBox[220, 0.24999999988411048]}, 
         {RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125],
           DiskBox[221, 0.24999999988411048]}, 
         {RGBColor[0.8877089635416666, 0.35558467708333336`, 0.1727164609375],
           DiskBox[222, 0.24999999988411048]}, 
         {RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
          DiskBox[223, 0.24999999988411048]}, 
         {RGBColor[0.8874511927083333, 0.35391013541666666`, 0.1723879921875],
           DiskBox[224, 0.24999999988411048]}, 
         {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
          DiskBox[225, 0.24999999988411048]}, 
         {RGBColor[0.7108072636718751, 0.741209576171875, 0.29669599609375], 
          DiskBox[226, 0.24999999988411048]}, 
         {RGBColor[
          0.711156916015625, 0.741125853515625, 0.29654623828125004`], 
          DiskBox[227, 0.24999999988411048]}, 
         {RGBColor[
          0.8125081145833333, 0.7080363854166667, 0.2545099895833333], 
          DiskBox[228, 0.24999999988411048]}, 
         {RGBColor[0.81394484375, 0.70698665625, 0.25400446875], 
          DiskBox[229, 0.24999999988411048]}, 
         {RGBColor[0.9011002031249999, 0.5767855937499999, 0.21539225], 
          DiskBox[230, 0.24999999988411048]}, 
         {RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
          DiskBox[231, 0.24999999988411048]}, 
         {RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
          DiskBox[232, 0.24999999988411048]}, 
         {RGBColor[0.90168446875, 0.5358450625, 0.2075995], 
          DiskBox[233, 0.24999999988411048]}, 
         {RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125],
           DiskBox[234, 0.24999999988411048]}, 
         {RGBColor[
          0.8877411848958333, 0.3557939947916667, 0.17275751953125001`], 
          DiskBox[235, 0.24999999988411048]}, 
         {RGBColor[0.8876767421875, 0.355375359375, 0.17267540234375], 
          DiskBox[236, 0.24999999988411048]}, 
         {RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 
          DiskBox[237, 0.24999999988411048]}, 
         {RGBColor[
          0.8611772083333333, 0.16093727083333334`, 0.13734573958333332`], 
          DiskBox[238, 0.24999999988411048]}, 
         {RGBColor[0.861033125, 0.1598115625, 0.13714884375], 
          DiskBox[239, 0.24999999988411048]}, 
         {RGBColor[
          0.8608890416666667, 0.15868585416666667`, 0.13695194791666665`], 
          DiskBox[240, 0.24999999988411048]}, 
         {RGBColor[
          0.8121489322916666, 0.7082988177083334, 0.25463636979166665`], 
          DiskBox[241, 0.24999999988411048]}, 
         {RGBColor[0.8128672968749999, 0.707773953125, 0.254383609375], 
          DiskBox[242, 0.24999999988411048]}, 
         {RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 
          DiskBox[243, 0.24999999988411048]}, 
         {RGBColor[0.90164615625, 0.5385296875, 0.2081105], 
          DiskBox[244, 0.24999999988411048]}, 
         {RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125],
           DiskBox[245, 0.24999999988411048]}, 
         {RGBColor[
          0.8121489322916666, 0.7082988177083334, 0.25463636979166665`], 
          DiskBox[246, 0.24999999988411048]}, 
         {RGBColor[
          0.8119693411458333, 0.7084300338541667, 0.2546995598958333], 
          DiskBox[247, 0.24999999988411048]}, 
         {RGBColor[0.8123285234375, 0.7081676015625, 0.2545731796875], 
          DiskBox[248, 0.24999999988411048]}, 
         {RGBColor[
          0.8119693411458333, 0.7084300338541667, 0.2546995598958333], 
          DiskBox[249, 0.24999999988411048]}, 
         {RGBColor[
          0.8122387278645833, 0.7082332096354167, 0.2546047747395833], 
          DiskBox[250, 0.24999999988411048]}, 
         {RGBColor[
          0.8124183190104166, 0.7081019934895834, 0.25454158463541665`], 
          DiskBox[251, 0.24999999988411048]}, 
         {RGBColor[
          0.8118795455729166, 0.7084956419270834, 0.25473115494791665`], 
          DiskBox[252, 0.24999999988411048]}, 
         {RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 
          DiskBox[253, 0.24999999988411048]}, 
         {RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 
          DiskBox[254, 0.24999999988411048]}}}]],
     MouseAppearanceTag["NetworkGraphics"]],
    AllowKernelInitialization->False]],
  DefaultBaseStyle->{
   "NetworkGraphics", FrontEnd`GraphicsHighlightColor -> Hue[0.8, 1., 0.6]},
  FormatType->TraditionalForm,
  FrameTicks->None,
  ImageSize->1000]], "Output",
 CellChangeTimes->{{3.731690559946581*^9, 3.7316905836922116`*^9}, 
   3.7316907772561717`*^9, 3.731691239566778*^9, {3.7316914977419662`*^9, 
   3.73169151170444*^9}, 3.7316932251794453`*^9, 
   3.734803319347188*^9},ExpressionUUID->"c976951e-8106-4875-9926-\
b3edc887784c"],

Cell[BoxData[
 GraphicsBox[
  NamespaceBox["NetworkGraphics",
   DynamicModuleBox[{Typeset`graph = HoldComplete[
     Graph[{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19,
       20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37,
       38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55,
       56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73,
       74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91,
       92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107,
       108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 
      122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 
      136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 
      150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 
      164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 
      178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 
      192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 
      206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 
      220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 
      234, 235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 
      248, 249, 250, 251, 252, 253, 254}, {CompressedData["
1:eJwBCwL0/SFib1JiAgAAAP0AAAACAAAAAQIBAwIEAwUDBgQHBAgFCQUKBgsG
DAYNCA4JDwkQChEKEgsTCxQMFQwWDRcNGA4ZDxoPGxAcER0RHhIfEiATIRQi
FCMVJBUlFiYWJxcoGCkYKhorGiwaLRsuGy8cMBwxHTIdMx40HzUfNh83IDgh
OSM6IzskPCQ9JT4mPydAJ0EoQihDKkQqRStGK0csSC1JLUouSzBMMU0yTjJP
NFA1UTVSNlM4VDlVOlY6VzxYPFk9Wj5bP1xAXUFeQV9DYENhRGJEY0VkRWVH
ZkhnSWhKaUpqS2tMbE5tTm5Rb1JwUnFTclNzVHRUdVV2VndWeFh5Wnpae1t8
XH1cflx/XoBegV+CX4NghGCFYYZhh2KIYoljimOLZYxnjWiOaY9pkGyRbJJu
k26Ub5VzlnOXdZh1mXeaeJt5nHqde557n3ygfKF+on6jgqSFpYmmiaeLqIyp
jKqMq46sjq2Pro+vj7CSsZKyk7OTtJS1lbaVt5a4mLmZupm7m7ycvZ2+nb+j
wKTBpMKow6jErMWyxrLHssizybPKtMu4zLrNus68z7zQvdG90sHTwtTC1cTW
ydfK2MzZzdrP29Hc1N3U3tXf1eDW4dfi1+PZ5Nnl2+bb59zo3Ond6t7r3uzf
7eHu4e/h8OTx5PLn8+j06vXx9vb39vj3+fj6+Pv5/Pn9/f4d4OiZ
       "], Null}, {EdgeStyle -> {
         RGBColor[0.9, 0.9, 0.9]}, GraphLayout -> "LayeredDigraphEmbedding", 
       ImageSize -> 1000, VertexLabels -> {"Name"}, VertexLabelStyle -> {
         Directive[
          RGBColor[
          0.6666666666666666, 0.6666666666666666, 0.6666666666666666], 8]}, 
       VertexStyle -> {
        51 -> RGBColor[0.738604625, 0.734553625, 0.28479025], 37 -> 
         RGBColor[0.9025465, 0.475441, 0.196102], 59 -> 
         RGBColor[0.90147375, 0.5506105, 0.21041], 21 -> 
         RGBColor[0.90224, 0.49691799999999997`, 0.20019], 191 -> 
         RGBColor[0.9020484375, 0.510341125, 0.202745], 210 -> 
         RGBColor[0.9017419375, 0.5318181249999999, 0.20683300000000002`], 
         215 -> RGBColor[0.71098208984375, 0.74116771484375, 0.2966211171875],
          176 -> RGBColor[
          0.5543171736111111, 0.7359087152777778, 0.4050509236111111], 61 -> 
         RGBColor[0.90208675, 0.5076565, 0.202234], 85 -> 
         RGBColor[0.8760126666666667, 0.641456, 0.22989], 238 -> 
         RGBColor[
          0.8611772083333333, 0.16093727083333334`, 0.13734573958333332`], 99 -> 
         RGBColor[0.8616815, 0.16487725, 0.138034875], 97 -> 
         RGBColor[
          0.8729199999999999, 0.25268250000000003`, 0.15339275000000002`], 
         122 -> RGBColor[0.902010125, 0.51302575, 0.203256], 248 -> 
         RGBColor[0.8123285234375, 0.7081676015625, 0.2545731796875], 11 -> 
         RGBColor[0.8885133333333333, 0.6121409999999999, 0.223216], 17 -> 
         RGBColor[0.7497935, 0.7318745, 0.27999799999999997`], 24 -> 
         RGBColor[0.864275, 0.18514000000000003`, 0.141579], 89 -> 
         RGBColor[0.901856875, 0.5237642499999999, 0.2053], 55 -> 
         RGBColor[0.8232835833333333, 0.7001634166666666, 0.2507185833333333],
          14 -> RGBColor[0.36048, 0.655759, 0.645692], 242 -> 
         RGBColor[0.8128672968749999, 0.707773953125, 0.254383609375], 164 -> 
         RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 
         153 -> 
         RGBColor[0.8592018124999999, 0.6739201875, 0.23808056249999998`], 
         143 -> RGBColor[
          0.5536627708333334, 0.7358128958333333, 0.40562102083333335`], 27 -> 
         RGBColor[0.5840925, 0.7402685, 0.37911150000000005`], 69 -> 
         RGBColor[0.859088, 0.1446145, 0.13449075], 194 -> 
         RGBColor[0.8876445208333333, 0.35516604166666665`, 0.17263434375], 
         182 -> RGBColor[
          0.7959857291666667, 0.7201082708333333, 0.26032347916666665`], 136 -> 
         RGBColor[0.86384275, 0.181762875, 0.1409883125], 93 -> 
         RGBColor[
          0.8925421666666666, 0.3869823333333333, 0.17887524999999999`], 75 -> 
         RGBColor[0.57231325, 0.73854375, 0.38937325], 157 -> 
         RGBColor[0.902010125, 0.51302575, 0.203256], 234 -> 
         RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
         32 -> RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
         66 -> RGBColor[0.8822313333333334, 0.3200006666666667, 0.1657365], 
         184 -> RGBColor[
          0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 101 -> 
         RGBColor[0.8582235, 0.13786025, 0.133309375], 39 -> 
         RGBColor[0.8904799999999999, 0.373586, 0.1762475], 253 -> 
         RGBColor[0.81205913671875, 0.70836442578125, 0.25466796484375], 130 -> 
         RGBColor[0.8879022916666667, 0.35684058333333335`, 0.1729628125], 12 -> 
         RGBColor[0.902853, 0.453964, 0.192014], 167 -> 
         RGBColor[0.8627621249999999, 0.17332006249999998`, 0.13951159375], 
         135 -> RGBColor[0.8720555, 0.24592825000000001`, 0.152211375], 230 -> 
         RGBColor[0.9011002031249999, 0.5767855937499999, 0.21539225], 92 -> 
         RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 131 -> 
         RGBColor[
          0.8868712083333333, 0.3501424166666667, 0.17164893750000002`], 106 -> 
         RGBColor[
          0.5585707916666667, 0.7365315416666667, 0.40134529166666666`], 207 -> 
         RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 151 -> 
         RGBColor[0.8160999375, 0.7054120625, 0.2532461875], 226 -> 
         RGBColor[0.7108072636718751, 0.741209576171875, 0.29669599609375], 
         221 -> 
         RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
         165 -> RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 95 -> 
         RGBColor[0.88738675, 0.3534915, 0.172305875], 150 -> 
         RGBColor[
          0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 126 -> 
         RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 100 -> 
         RGBColor[0.8599525, 0.15136875, 0.135672125], 245 -> 
         RGBColor[0.8878378489583333, 0.35642194791666665`, 0.1728806953125], 
         166 -> RGBColor[
          0.863194375, 0.17669718750000002`, 0.14010228125000002`], 231 -> 
         RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 107 -> 
         RGBColor[0.57231325, 0.73854375, 0.38937325], 9 -> 
         RGBColor[0.607651, 0.743718, 0.358588], 104 -> 
         RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 213 -> 
         RGBColor[0.8875156354166667, 0.35432877083333336`, 0.172470109375], 
         206 -> RGBColor[0.858124265625, 0.674707484375, 0.238459703125], 140 -> 
         RGBColor[0.8582235, 0.13786025, 0.133309375], 102 -> 
         RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 22 -> 
         RGBColor[0.8946043333333333, 0.40037866666666666`, 0.181503], 169 -> 
         RGBColor[
          0.8587998333333333, 0.14236308333333333`, 0.13409695833333332`], 
         254 -> RGBColor[
          0.81205913671875, 0.70836442578125, 0.25466796484375], 214 -> 
         RGBColor[0.861033125, 0.1598115625, 0.13714884375], 53 -> 
         RGBColor[
          0.8002959166666667, 0.7169590833333332, 0.25880691666666666`], 181 -> 
         RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 146 -> 
         RGBColor[0.6441711250000001, 0.743295375, 0.33630512500000004`], 38 -> 
         RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 129 -> 
         RGBColor[0.888933375, 0.36353875, 0.1742766875], 219 -> 
         RGBColor[0.90110978125, 0.5761144374999999, 0.2152645], 117 -> 
         RGBColor[0.8548916249999999, 0.677069375, 0.239597125], 88 -> 
         RGBColor[0.901703625, 0.5345027499999999, 0.207344], 13 -> 
         RGBColor[0.8711909999999999, 0.23917400000000003`, 0.15103], 139 -> 
         RGBColor[0.86124925, 0.161500125, 0.1374441875], 57 -> 
         RGBColor[0.8760126666666667, 0.641456, 0.22989], 108 -> 
         RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 228 -> 
         RGBColor[0.8125081145833333, 0.7080363854166667, 0.2545099895833333],
          233 -> RGBColor[0.90168446875, 0.5358450625, 0.2075995], 168 -> 
         RGBColor[0.86124925, 0.161500125, 0.1374441875], 204 -> 
         RGBColor[
          0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 154 -> 
         RGBColor[0.9010523125, 0.580141375, 0.216031], 138 -> 
         RGBColor[0.86211375, 0.168254375, 0.1386255625], 19 -> 
         RGBColor[0.8760126666666667, 0.641456, 0.22989], 16 -> 
         RGBColor[
          0.6563445000000001, 0.7431544999999999, 0.32887750000000004`], 105 -> 
         RGBColor[0.5546443750000001, 0.735956625, 0.404765875], 216 -> 
         RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
         26 -> RGBColor[0.5369755, 0.7333695, 0.4201585], 60 -> 
         RGBColor[0.90178025, 0.5291334999999999, 0.206322], 170 -> 
         RGBColor[0.8582235, 0.13786025, 0.133309375], 163 -> 
         RGBColor[
          0.8980412777777778, 0.4227058888888889, 0.18588258333333332`], 120 -> 
         RGBColor[0.9011289375, 0.574772125, 0.215009], 29 -> 
         RGBColor[0.72741575, 0.73723275, 0.2895825], 133 -> 
         RGBColor[0.8755135, 0.27294525000000003`, 0.156936875], 137 -> 
         RGBColor[0.86297825, 0.17500862500000003`, 0.1398069375], 46 -> 
         RGBColor[0.57231325, 0.73854375, 0.38937325], 79 -> 
         RGBColor[0.7218213125, 0.7385723125, 0.291978625], 76 -> 
         RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 188 -> 
         RGBColor[0.9011289375, 0.574772125, 0.215009], 132 -> 
         RGBColor[0.8772424999999999, 0.28645375, 0.159299625], 178 -> 
         RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 162 -> 
         RGBColor[
          0.8994160555555556, 0.43163677777777776`, 0.18763441666666666`], 
         220 -> RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 149 -> 
         RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333],
          34 -> RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`],
          147 -> RGBColor[0.7120310468750001, 0.740916546875, 0.29617184375], 
         200 -> RGBColor[
          0.6543156041666667, 0.7431779791666666, 0.3301154375], 144 -> 
         RGBColor[0.5556259791666667, 0.7361003541666666, 0.4039107291666667],
          128 -> RGBColor[
          0.8899644583333334, 0.3702369166666667, 0.1755905625], 118 -> 
         RGBColor[0.8760126666666667, 0.641456, 0.22989], 6 -> 
         RGBColor[0.902853, 0.453964, 0.192014], 183 -> 
         RGBColor[0.7988591875, 0.7180088124999999, 0.2593124375], 30 -> 
         RGBColor[0.77217125, 0.72651625, 0.2704135], 142 -> 
         RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 3 -> 
         RGBColor[0.863512, 0.670771, 0.236564], 208 -> 
         RGBColor[0.9011480937499999, 0.5734298124999999, 0.2147535], 186 -> 
         RGBColor[0.8570467187499999, 0.67549478125, 0.23883884375], 177 -> 
         RGBColor[0.6380844375000001, 0.7433658125, 0.3400189375], 172 -> 
         RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667],
          190 -> RGBColor[0.9019718125, 0.5157103749999999, 0.203767], 77 -> 
         RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 72 -> 
         RGBColor[0.5369755, 0.7333695, 0.4201585], 62 -> 
         RGBColor[0.9025465, 0.475441, 0.196102], 209 -> 
         RGBColor[0.9016653125, 0.5371873749999999, 0.207855], 217 -> 
         RGBColor[
          0.8132264791666666, 0.7075115208333334, 0.25425722916666665`], 148 -> 
         RGBColor[0.714828265625, 0.740246765625, 0.29497378125], 171 -> 
         RGBColor[
          0.8576471666666666, 0.13335741666666667`, 0.13252179166666667`], 
         127 -> RGBColor[
          0.8959791111111111, 0.40930955555555554`, 0.18325483333333334`], 54 -> 
         RGBColor[0.81178975, 0.70856125, 0.25476275], 71 -> 
         RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 113 -> 
         RGBColor[0.8046061041666667, 0.7138098958333333, 0.2572903541666666],
          179 -> RGBColor[
          0.7113317421875001, 0.7410839921875, 0.296471359375], 109 -> 
         RGBColor[
          0.7078352187500001, 0.7419212187499999, 0.29796893750000003`], 7 -> 
         RGBColor[0.250728, 0.225386, 0.769152], 81 -> 
         RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333],
          47 -> RGBColor[
          0.59587175, 0.7419932499999999, 0.36884975000000003`], 252 -> 
         RGBColor[
          0.8118795455729166, 0.7084956419270834, 0.25473115494791665`], 240 -> 
         RGBColor[
          0.8608890416666667, 0.15868585416666667`, 0.13695194791666665`], 
         192 -> RGBColor[
          0.8980412777777778, 0.4227058888888889, 0.18588258333333332`], 87 -> 
         RGBColor[0.901243875, 0.56671825, 0.213476], 94 -> 
         RGBColor[0.8894489166666667, 0.36688783333333336`, 0.174933625], 202 -> 
         RGBColor[0.71168139453125, 0.74100026953125, 0.29632160156250004`], 
         84 -> RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
         222 -> RGBColor[
          0.8877089635416666, 0.35558467708333336`, 0.1727164609375], 35 -> 
         RGBColor[0.9013205, 0.561349, 0.212454], 115 -> 
         RGBColor[0.8146632083333333, 0.7064617916666667, 0.2537517083333333],
          49 -> RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 36 -> 
         RGBColor[
          0.9019334999999999, 0.5183949999999999, 0.20427800000000002`], 224 -> 
         RGBColor[0.8874511927083333, 0.35391013541666666`, 0.1723879921875], 
         156 -> RGBColor[0.901703625, 0.5345027499999999, 0.207344], 112 -> 
         RGBColor[
          0.8017326458333333, 0.7159093541666667, 0.25830139583333334`], 4 -> 
         RGBColor[0.266122, 0.486664, 0.802529], 1 -> 
         RGBColor[0.513417, 0.72992, 0.440682], 180 -> 
         RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
         124 -> RGBColor[0.9025465, 0.475441, 0.196102], 91 -> 
         RGBColor[0.9025465, 0.475441, 0.196102], 229 -> 
         RGBColor[0.81394484375, 0.70698665625, 0.25400446875], 193 -> 
         RGBColor[0.8881600625, 0.358515125, 0.17329128125], 197 -> 
         RGBColor[0.5467915416666667, 0.7348067916666666, 0.4116070416666667],
          141 -> RGBColor[0.5369755, 0.7333695, 0.4201585], 225 -> 
         RGBColor[0.861033125, 0.1598115625, 0.13714884375], 173 -> 
         RGBColor[
          0.5507179583333334, 0.7353817083333334, 0.40818645833333334`], 78 -> 
         RGBColor[0.7106324375, 0.7412514375, 0.296770875], 189 -> 
         RGBColor[0.901703625, 0.5345027499999999, 0.207344], 28 -> 
         RGBColor[
          0.6563445000000001, 0.7431544999999999, 0.32887750000000004`], 198 -> 
         RGBColor[
          0.6462000208333334, 0.7432718958333333, 0.33506718750000003`], 65 -> 
         RGBColor[
          0.8884178333333334, 0.3601896666666667, 0.17361975000000002`], 218 -> 
         RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 161 -> 
         RGBColor[0.90269975, 0.46470249999999996`, 0.194058], 43 -> 
         RGBColor[
          0.5212698333333333, 0.7310698333333333, 0.43384083333333334`], 203 -> 
         RGBColor[0.7127303515625001, 0.7407491015625, 0.29587232812500003`], 
         145 -> RGBColor[0.6198243750000001, 0.743577125, 0.351160375], 45 -> 
         RGBColor[0.5526811666666667, 0.7356691666666667, 0.4064761666666667],
          63 -> RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585],
          56 -> RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
         18 -> RGBColor[0.8290305, 0.6959645, 0.2486965], 2 -> 
         RGBColor[0.266122, 0.486664, 0.802529], 246 -> 
         RGBColor[
          0.8121489322916666, 0.7082988177083334, 0.25463636979166665`], 42 -> 
         RGBColor[0.8608169999999999, 0.15812299999999999`, 0.1368535], 125 -> 
         RGBColor[
          0.9014782222222222, 0.4450331111111111, 0.19026216666666665`], 15 -> 
         RGBColor[0.5605340000000001, 0.736819, 0.399635], 25 -> 
         RGBColor[0.36048, 0.655759, 0.645692], 243 -> 
         RGBColor[0.901119359375, 0.57544328125, 0.21513675000000002`], 20 -> 
         RGBColor[0.901014, 0.582826, 0.216542], 155 -> 
         RGBColor[0.9011289375, 0.574772125, 0.215009], 244 -> 
         RGBColor[0.90164615625, 0.5385296875, 0.2081105], 241 -> 
         RGBColor[
          0.8121489322916666, 0.7082988177083334, 0.25463636979166665`], 195 -> 
         RGBColor[0.861465375, 0.1631886875, 0.13773953125], 48 -> 
         RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 86 -> 
         RGBColor[0.901090625, 0.57745675, 0.21552000000000002`], 70 -> 
         RGBColor[0.5173434166666667, 0.7304949166666667, 0.4372614166666667],
          196 -> RGBColor[0.861033125, 0.1598115625, 0.13714884375], 73 -> 
         RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 111 -> 
         RGBColor[0.7974224583333333, 0.7190585416666666, 0.2598179583333333],
          212 -> RGBColor[0.88777340625, 0.3560033125, 0.172798578125], 187 -> 
         RGBColor[0.8613569062499999, 0.67234559375, 0.23732228125], 199 -> 
         RGBColor[0.6502578125, 0.7432249375, 0.3325913125], 158 -> 
         RGBColor[0.9021250625, 0.504971875, 0.20172299999999999`], 40 -> 
         RGBColor[0.878107, 0.293208, 0.160481], 223 -> 
         RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 227 -> 
         RGBColor[0.711156916015625, 0.741125853515625, 0.29654623828125004`],
          123 -> RGBColor[0.902163375, 0.50228725, 0.201212], 211 -> 
         RGBColor[0.8881600625, 0.358515125, 0.17329128125], 134 -> 
         RGBColor[0.8737845, 0.25943675, 0.154574125], 68 -> 
         RGBColor[0.862546, 0.1716315, 0.13921624999999999`], 249 -> 
         RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333],
          201 -> RGBColor[
          0.71098208984375, 0.74116771484375, 0.2966211171875], 175 -> 
         RGBColor[
          0.5536627708333334, 0.7358128958333333, 0.40562102083333335`], 235 -> 
         RGBColor[
          0.8877411848958333, 0.3557939947916667, 0.17275751953125001`], 232 -> 
         RGBColor[0.90164615625, 0.5385296875, 0.2081105], 80 -> 
         RGBColor[0.77217125, 0.72651625, 0.2704135], 239 -> 
         RGBColor[0.861033125, 0.1598115625, 0.13714884375], 174 -> 
         RGBColor[0.5530083680555555, 0.735717076388889, 0.4061911180555556], 
         237 -> RGBColor[0.887580078125, 0.35474740625, 0.1725522265625], 96 -> 
         RGBColor[0.876378, 0.27969950000000005`, 0.15811825000000002`], 98 -> 
         RGBColor[0.8634105, 0.17838575, 0.140397625], 110 -> 
         RGBColor[0.71342965625, 0.74058165625, 0.2955728125], 83 -> 
         RGBColor[0.81178975, 0.70856125, 0.25476275], 52 -> 
         RGBColor[0.77217125, 0.72651625, 0.2704135], 116 -> 
         RGBColor[0.8376508749999999, 0.689666125, 0.245663375], 250 -> 
         RGBColor[0.8122387278645833, 0.7082332096354167, 0.2546047747395833],
          44 -> RGBColor[0.5369755, 0.7333695, 0.4201585], 41 -> 
         RGBColor[0.867733, 0.212157, 0.1463045], 50 -> 
         RGBColor[0.716226875, 0.739911875, 0.29437475], 33 -> 
         RGBColor[0.8760126666666667, 0.641456, 0.22989], 247 -> 
         RGBColor[0.8119693411458333, 0.7084300338541667, 0.2546995598958333],
          114 -> RGBColor[
          0.8089162916666666, 0.7106607083333333, 0.25577379166666664`], 74 -> 
         RGBColor[
          0.5566075833333334, 0.7362440833333334, 0.40305558333333336`], 152 -> 
         RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 58 -> 
         RGBColor[0.90116725, 0.5720875, 0.21449800000000002`], 251 -> 
         RGBColor[
          0.8124183190104166, 0.7081019934895834, 0.25454158463541665`], 82 -> 
         RGBColor[0.803169375, 0.714859625, 0.257795875], 103 -> 
         RGBColor[0.5369755, 0.7333695, 0.4201585], 31 -> 
         RGBColor[0.81178975, 0.70856125, 0.25476275], 121 -> 
         RGBColor[0.901703625, 0.5345027499999999, 0.207344], 205 -> 
         RGBColor[0.855969171875, 0.676282078125, 0.239217984375], 185 -> 
         RGBColor[0.8505814374999999, 0.6802185625, 0.2411136875], 23 -> 
         RGBColor[0.878107, 0.293208, 0.160481], 119 -> 
         RGBColor[0.9010523125, 0.580141375, 0.216031], 5 -> 
         RGBColor[0.705038, 0.742591, 0.299167], 67 -> 
         RGBColor[0.874649, 0.266191, 0.15575550000000002`], 236 -> 
         RGBColor[0.8876767421875, 0.355375359375, 0.17267540234375], 160 -> 
         RGBColor[0.90239325, 0.4861795, 0.198146], 159 -> 
         RGBColor[0.9022016875, 0.49960262499999997`, 0.200701], 64 -> 
         RGBColor[
          0.8925421666666666, 0.3869823333333333, 0.17887524999999999`], 8 -> 
         RGBColor[0.36048, 0.655759, 0.645692], 10 -> 
         RGBColor[0.794549, 0.721158, 0.260829], 90 -> 
         RGBColor[0.90208675, 0.5076565, 0.202234]}}]]}, 
    TagBox[GraphicsGroupBox[{
       {RGBColor[0.9, 0.9, 0.9], Opacity[0.7], Arrowheads[
        0.006615108115907495], 
        ArrowBox[{{0., 19.}, {-2.022220191745106, 18.}}, 
         0.11501454641530486`], 
        ArrowBox[{{0., 19.}, {2.045937863027717, 18.}}, 0.11501454641530486`],
         ArrowBox[{{-2.022220191745106, 18.}, {-3.448540882597314, 17.}}, 
         0.11501454641530486`], 
        ArrowBox[{{2.045937863027717, 18.}, {23.095079223215066`, 17.}}, 
         0.11501454641530486`], 
        ArrowBox[{{2.045937863027717, 18.}, {2.0459378630190486`, 17.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-3.448540882597314, 17.}, {-4.448540882610757, 16.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-3.448540882597314, 17.}, {-3.4485408826000423`, 16.}}, 
         0.11501454641530486`], 
        ArrowBox[{{23.095079223215066`, 17.}, {23.09507922324812, 16.}}, 
         0.11501454641530486`], 
        ArrowBox[{{23.095079223215066`, 17.}, {28.99952564036272, 16.}}, 
         0.11501454641530486`], 
        ArrowBox[{{2.0459378630190486`, 17.}, {-1.6581062291706417`, 16.}}, 
         0.11501454641530486`], 
        ArrowBox[{{2.0459378630190486`, 17.}, {10.392213397079445`, 16.}}, 
         0.11501454641530486`], 
        ArrowBox[{{2.0459378630190486`, 17.}, {2.0459378630265803`, 16.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-3.4485408826000423`, 16.}, {-4.163490779319204, 15.}}, 
         0.11501454641530486`], 
        ArrowBox[{{23.09507922324812, 16.}, {22.204005292846148`, 15.}}, 
         0.11501454641530486`], 
        ArrowBox[{{23.09507922324812, 16.}, {24.30082938528264, 15.}}, 
         0.11501454641530486`], 
        ArrowBox[{{28.99952564036272, 16.}, {28.999525640306786`, 15.}}, 
         0.11501454641530486`], 
        ArrowBox[{{28.99952564036272, 16.}, {31.787374888605996`, 15.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-1.6581062291706417`, 16.}, {-1.6581062291776334`, 15.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-1.6581062291706417`, 16.}, {-2.658106229401284, 15.}}, 
         0.11501454641530486`], 
        ArrowBox[{{10.392213397079445`, 16.}, {15.58982508570682, 15.}}, 
         0.11501454641530486`], 
        ArrowBox[{{10.392213397079445`, 16.}, {10.392213397097919`, 15.}}, 
         0.11501454641530486`], 
        ArrowBox[{{2.0459378630265803`, 16.}, {1.3418937707969292`, 15.}}, 
         0.11501454641530486`], 
        ArrowBox[{{2.0459378630265803`, 16.}, {2.3418937709033685`, 15.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-4.163490779319204, 15.}, {-4.658106229575736, 14.}}, 
         0.11501454641530486`], 
        ArrowBox[{{22.204005292846148`, 15.}, {22.20400529291129, 14.}}, 
         0.11501454641530486`], 
        ArrowBox[{{22.204005292846148`, 15.}, {19.98380650707307, 14.}}, 
         0.11501454641530486`], 
        ArrowBox[{{24.30082938528264, 15.}, {25.204005293188686`, 14.}}, 
         0.11501454641530486`], 
        ArrowBox[{{28.999525640306786`, 15.}, {28.528916755615484`, 14.}}, 
         0.11501454641530486`], 
        ArrowBox[{{28.999525640306786`, 15.}, {29.528916755708195`, 14.}}, 
         0.11501454641530486`], 
        ArrowBox[{{31.787374888605996`, 15.}, {31.787374888571406`, 14.}}, 
         0.11501454641530486`], 
        ArrowBox[{{31.787374888605996`, 15.}, {33.82146193475651, 14.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-1.6581062291776334`, 15.}, {-1.6581062291994613`, 14.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-2.658106229401284, 15.}, {-3.6581062295064726`, 14.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-2.658106229401284, 15.}, {-2.658106229391535, 14.}}, 
         0.11501454641530486`], 
        ArrowBox[{{15.58982508570682, 15.}, {15.58982508561752, 14.}}, 
         0.11501454641530486`], 
        ArrowBox[{{15.58982508570682, 15.}, {16.914169108709814`, 14.}}, 
         0.11501454641530486`], 
        ArrowBox[{{10.392213397097919`, 15.}, {9.851797329644882, 14.}}, 
         0.11501454641530486`], 
        ArrowBox[{{10.392213397097919`, 15.}, {10.984121802026266`, 14.}}, 
         0.11501454641530486`], 
        ArrowBox[{{1.3418937707969292`, 15.}, {1.3418937706159682`, 14.}}, 
         0.11501454641530486`], 
        ArrowBox[{{2.3418937709033685`, 15.}, {2.341893770862299, 14.}}, 
         0.11501454641530486`], 
        ArrowBox[{{2.3418937709033685`, 15.}, {3.3418937709029137`, 14.}}, 
         0.11501454641530486`], 
        ArrowBox[{{22.20400529291129, 14.}, {21.204005292813918`, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{22.20400529291129, 14.}, {22.204005292866498`, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{22.20400529291129, 14.}, {23.204005292962535`, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{19.98380650707307, 14.}, {19.983806507063207`, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{19.98380650707307, 14.}, {18.983806507039276`, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{25.204005293188686`, 14.}, {26.204005293276737`, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{25.204005293188686`, 14.}, {25.204005292998232`, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{28.528916755615484`, 14.}, {28.52891675571965, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{28.528916755615484`, 14.}, {27.52891675554787, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{29.528916755708195`, 14.}, {29.52891675584408, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{31.787374888571406`, 14.}, {32.90863910066366, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{31.787374888571406`, 14.}, {31.78737488864786, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{31.787374888571406`, 14.}, {30.78737488862774, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{33.82146193475651, 14.}, {34.79035567590262, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-1.6581062291994613`, 14.}, {-1.6581062293238062`, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-2.658106229391535, 14.}, {-2.6581062294621063`, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-2.658106229391535, 14.}, {-3.6581062294757203`, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{15.58982508561752, 14.}, {15.341893770984996`, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{15.58982508561752, 14.}, {16.34189377122229, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{16.914169108709814`, 14.}, {17.553065300915137`, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{9.851797329644882, 14.}, {9.650469521453346, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{10.984121802026266`, 14.}, {10.984121801885891`, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{10.984121802026266`, 14.}, {12.129616882880441`, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{1.3418937706159682`, 14.}, {0.341893770679377, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{1.3418937706159682`, 14.}, {1.3418937707158989`, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{3.3418937709029137`, 14.}, {4.895639399270124, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{3.3418937709029137`, 14.}, {3.3418937708428302`, 13.}}, 
         0.11501454641530486`], 
        ArrowBox[{{21.204005292813918`, 13.}, {20.204005292768187`, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{21.204005292813918`, 13.}, {21.20400529287477, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{22.204005292866498`, 13.}, {22.204005292801952`, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{23.204005292962535`, 13.}, {24.204005293073692`, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{23.204005292962535`, 13.}, {23.204005292971544`, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{19.983806507063207`, 13.}, {19.20400529253598, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{26.204005293276737`, 13.}, {26.20400529323473, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{25.204005292998232`, 13.}, {25.2040052935389, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{28.52891675571965, 13.}, {28.5289167556721, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{28.52891675571965, 13.}, {27.528916755722918`, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{29.52891675584408, 13.}, {29.528916755892908`, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{32.90863910066366, 13.}, {34.03234014975271, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{32.90863910066366, 13.}, {32.9086391006756, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{31.78737488864786, 13.}, {31.39615061319833, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{34.79035567590262, 13.}, {35.396150612891205`, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-1.6581062293238062`, 13.}, {-1.6581062294043818`, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-2.6581062294621063`, 13.}, {-2.6581062296236553`, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-2.6581062294621063`, 13.}, {-3.6581062296385483`, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{15.341893770984996`, 13.}, {15.341893771120255`, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{15.341893770984996`, 13.}, {14.341893770643082`, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{16.34189377122229, 13.}, {16.3418937710029, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{17.553065300915137`, 13.}, {17.917095517265892`, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{9.650469521453346, 13.}, {9.484056391613649, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{10.984121801885891`, 13.}, {10.98412180190644, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{12.129616882880441`, 13.}, {12.129616882774883`, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{12.129616882880441`, 13.}, {13.341893770362418`, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{1.3418937707158989`, 13.}, {1.3418937704978475`, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{1.3418937707158989`, 13.}, {0.3418937702838605, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{4.895639399270124, 13.}, {4.8956393993071, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{4.895639399270124, 13.}, {6.341893770761828, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{3.3418937708428302`, 13.}, {2.341893770759242, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{3.3418937708428302`, 13.}, {3.341893770714506, 12.}}, 
         0.11501454641530486`], 
        ArrowBox[{{21.20400529287477, 12.}, {20.72717549486356, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{22.204005292801952`, 12.}, {21.727175494838974`, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{24.204005293073692`, 12.}, {24.727175495055803`, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{23.204005292971544`, 12.}, {23.727175494785456`, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{23.204005292971544`, 12.}, {22.72717549479404, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{19.20400529253598, 12.}, {19.341893770955664`, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{26.20400529323473, 12.}, {26.204005293352992`, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{28.5289167556721, 12.}, {28.08455826924896, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{28.5289167556721, 12.}, {29.08455826946141, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{34.03234014975271, 12.}, {34.39615061312125, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{32.9086391006756, 12.}, {32.39615061314359, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{32.9086391006756, 12.}, {33.39615061289962, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{31.39615061319833, 12.}, {30.396150613222147`, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{31.39615061319833, 12.}, {31.396150613121108`, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{35.396150612891205`, 12.}, {35.396150612822424`, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{35.396150612891205`, 12.}, {36.39615061294376, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-1.6581062294043818`, 12.}, {-1.6581062294861795`, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-2.6581062296236553`, 12.}, {-3.658106229769544, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-2.6581062296236553`, 12.}, {-2.658106229763149, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{15.341893771120255`, 12.}, {15.341893770716837`, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{16.3418937710029, 12.}, {17.3418937708862, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{16.3418937710029, 12.}, {16.341893770846298`, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{17.917095517265892`, 12.}, {18.341893770900953`, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{9.484056391613649, 12.}, {8.341893770852636, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{9.484056391613649, 12.}, {10.341893770616934`, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{9.484056391613649, 12.}, {9.341893771080493, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{12.129616882774883`, 12.}, {11.34189377046792, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{12.129616882774883`, 12.}, {12.341893770794712`, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{13.341893770362418`, 12.}, {14.341893770715245`, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{13.341893770362418`, 12.}, {13.341893770792552`, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{1.3418937704978475`, 12.}, {1.3418937704880989`, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{1.3418937704978475`, 12.}, {2.3418937704540497`, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{0.3418937702838605, 12.}, {-0.658106229606858, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{0.3418937702838605, 12.}, {0.3418937702360836, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{4.8956393993071, 12.}, {4.341893770671362, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{4.8956393993071, 12.}, {5.341893770602212, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{6.341893770761828, 12.}, {6.341893770738324, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{6.341893770761828, 12.}, {7.3418937708576095`, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{3.341893770714506, 12.}, {3.341893770629582, 11.}}, 
         0.11501454641530486`], 
        ArrowBox[{{21.727175494838974`, 11.}, {21.727175494722616`, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{24.727175495055803`, 11.}, {24.72717549514209, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{23.727175494785456`, 11.}, {23.727175494862905`, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{23.727175494785456`, 11.}, {22.727175494809785`, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{26.204005293352992`, 11.}, {25.987450501538774`, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{26.204005293352992`, 11.}, {26.98745050150393, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{29.08455826946141, 11.}, {29.72717549543208, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{29.08455826946141, 11.}, {28.727175494856453`, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{34.39615061312125, 11.}, {34.39615061301893, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{31.396150613121108`, 11.}, {32.45092910782455, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{31.396150613121108`, 11.}, {31.39615061298153, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{36.39615061294376, 11.}, {36.195679203889114`, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{36.39615061294376, 11.}, {37.19567920385413, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-3.658106229769544, 11.}, {-3.658106229822124, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-2.658106229763149, 11.}, {-2.658106229661456, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{15.341893770716837`, 11.}, {14.341893771247527`, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{17.3418937708862, 11.}, {17.34189377088228, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{16.341893770846298`, 11.}, {15.341893771028367`, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{16.341893770846298`, 11.}, {16.341893770972803`, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{18.341893770900953`, 11.}, {18.341893770984143`, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{18.341893770900953`, 11.}, {19.341893770951344`, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{10.341893770616934`, 11.}, {9.755170498866704, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{10.341893770616934`, 11.}, {10.755170498911156`, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{14.341893770715245`, 11.}, {13.185279646409953`, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{2.3418937704540497`, 11.}, {1.341893770580043, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{5.341893770602212, 11.}, {5.341893770631231, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{5.341893770602212, 11.}, {6.341893770673323, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{7.3418937708576095`, 11.}, {7.3418937709351155`, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{3.341893770629582, 11.}, {2.341893770639672, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{3.341893770629582, 11.}, {3.3418937705513088`, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{3.341893770629582, 11.}, {4.34189377063808, 10.}}, 
         0.11501454641530486`], 
        ArrowBox[{{24.72717549514209, 10.}, {24.727175494926655`, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{24.72717549514209, 10.}, {25.72717549486049, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{23.727175494862905`, 10.}, {21.727175494798615`, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{23.727175494862905`, 10.}, {22.72717549486555, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{23.727175494862905`, 10.}, {23.727175494897523`, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{26.98745050150393, 10.}, {26.72717549473714, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{26.98745050150393, 10.}, {27.727175494733928`, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{29.72717549543208, 10.}, {30.727175495303698`, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{29.72717549543208, 10.}, {29.727175495277578`, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{28.727175494856453`, 10.}, {28.72717549474342, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{34.39615061301893, 10.}, {33.89402413343072, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{34.39615061301893, 10.}, {34.89402413338152, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{32.45092910782455, 10.}, {32.58184398684102, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{36.195679203889114`, 10.}, {36.195679203748, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{37.19567920385413, 10.}, {38.19567920376218, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{37.19567920385413, 10.}, {37.19567920385555, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-2.658106229661456, 10.}, {-2.658106229740639, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{14.341893771247527`, 10.}, {14.718305318173776`, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{17.34189377088228, 10.}, {16.90856187798812, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{17.34189377088228, 10.}, {17.908561878092172`, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{10.755170498911156`, 10.}, {10.7551704989487, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{13.185279646409953`, 10.}, {12.072257097525949`, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{13.185279646409953`, 10.}, {13.185279646230583`, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{7.3418937709351155`, 10.}, {6.760286744236311, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{7.3418937709351155`, 10.}, {7.760286744147834, 9.}}, 
         0.11501454641530486`], 
        ArrowBox[{{24.727175494926655`, 9.}, {24.72717549490048, 8.}}, 
         0.11501454641530486`], 
        ArrowBox[{{27.727175494733928`, 9.}, {26.727175494446215`, 8.}}, 
         0.11501454641530486`], 
        ArrowBox[{{27.727175494733928`, 9.}, {27.727175494670206`, 8.}}, 
         0.11501454641530486`], 
        ArrowBox[{{27.727175494733928`, 9.}, {28.727175494683934`, 8.}}, 
         0.11501454641530486`], 
        ArrowBox[{{30.727175495303698`, 9.}, {31.72717549534849, 8.}}, 
         0.11501454641530486`], 
        ArrowBox[{{30.727175495303698`, 9.}, {30.72717549503062, 8.}}, 
         0.11501454641530486`], 
        ArrowBox[{{29.727175495277578`, 9.}, {29.727175494894453`, 8.}}, 
         0.11501454641530486`], 
        ArrowBox[{{32.58184398684102, 9.}, {32.72717549537609, 8.}}, 
         0.11501454641530486`], 
        ArrowBox[{{38.19567920376218, 9.}, {38.80851003733261, 8.}}, 
         0.11501454641530486`], 
        ArrowBox[{{38.19567920376218, 9.}, {37.808510037362936`, 8.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-2.658106229740639, 9.}, {-2.2778060607375608`, 8.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-2.658106229740639, 9.}, {-3.277806060712294, 8.}}, 
         0.11501454641530486`], 
        ArrowBox[{{14.718305318173776`, 9.}, {15.718305318267, 8.}}, 
         0.11501454641530486`], 
        ArrowBox[{{14.718305318173776`, 9.}, {14.718305318215641`, 8.}}, 
         0.11501454641530486`], 
        ArrowBox[{{12.072257097525949`, 9.}, {11.718305317938928`, 8.}}, 
         0.11501454641530486`], 
        ArrowBox[{{13.185279646230583`, 9.}, {13.718305318140693`, 8.}}, 
         0.11501454641530486`], 
        ArrowBox[{{13.185279646230583`, 9.}, {12.71830531799759, 8.}}, 
         0.11501454641530486`], 
        ArrowBox[{{7.760286744147834, 9.}, {7.760286744183787, 8.}}, 
         0.11501454641530486`], 
        ArrowBox[{{31.72717549534849, 8.}, {31.72717549522895, 7.}}, 
         0.11501454641530486`], 
        ArrowBox[{{30.72717549503062, 8.}, {30.727175495039234`, 7.}}, 
         0.11501454641530486`], 
        ArrowBox[{{32.72717549537609, 8.}, {32.72717549556367, 7.}}, 
         0.11501454641530486`], 
        ArrowBox[{{38.80851003733261, 8.}, {38.80851003730791, 7.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-2.2778060607375608`, 8.}, {-2.277806060757058, 7.}}, 
         0.11501454641530486`], 
        ArrowBox[{{15.718305318267, 8.}, {15.718305318658366`, 7.}}, 
         0.11501454641530486`], 
        ArrowBox[{{13.718305318140693`, 8.}, {14.718305318100136`, 7.}}, 
         0.11501454641530486`], 
        ArrowBox[{{13.718305318140693`, 8.}, {13.718305318119718`, 7.}}, 
         0.11501454641530486`], 
        ArrowBox[{{12.71830531799759, 8.}, {12.718305317754528`, 7.}}, 
         0.11501454641530486`], 
        ArrowBox[{{12.71830531799759, 8.}, {11.718305317755636`, 7.}}, 
         0.11501454641530486`], 
        ArrowBox[{{7.760286744183787, 8.}, {7.760286744202375, 7.}}, 
         0.11501454641530486`], 
        ArrowBox[{{31.72717549522895, 7.}, {30.727175495346785`, 6.}}, 
         0.11501454641530486`], 
        ArrowBox[{{31.72717549522895, 7.}, {31.727175495349115`, 6.}}, 
         0.11501454641530486`], 
        ArrowBox[{{32.72717549556367, 7.}, {33.72717549541997, 6.}}, 
         0.11501454641530486`], 
        ArrowBox[{{32.72717549556367, 7.}, {32.72717549544376, 6.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-2.277806060757058, 7.}, {-2.825433669450547, 6.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-2.277806060757058, 7.}, {-1.82543366938566, 6.}}, 
         0.11501454641530486`], 
        ArrowBox[{{15.718305318658366`, 7.}, {16.71830531855747, 6.}}, 
         0.11501454641530486`], 
        ArrowBox[{{15.718305318658366`, 7.}, {15.718305318418373`, 6.}}, 
         0.11501454641530486`], 
        ArrowBox[{{14.718305318100136`, 7.}, {14.718305318151664`, 6.}}, 
         0.11501454641530486`], 
        ArrowBox[{{13.718305318119718`, 7.}, {12.71830531820072, 6.}}, 
         0.11501454641530486`], 
        ArrowBox[{{13.718305318119718`, 7.}, {13.71830531834334, 6.}}, 
         0.11501454641530486`], 
        ArrowBox[{{12.718305317754528`, 7.}, {11.71830531816471, 6.}}, 
         0.11501454641530486`], 
        ArrowBox[{{7.760286744202375, 7.}, {6.760286744088205, 6.}}, 
         0.11501454641530486`], 
        ArrowBox[{{7.760286744202375, 7.}, {7.760286744200926, 6.}}, 
         0.11501454641530486`], 
        ArrowBox[{{7.760286744202375, 7.}, {8.760286744199789, 6.}}, 
         0.11501454641530486`], 
        ArrowBox[{{33.72717549541997, 6.}, {33.43548291084545, 5.}}, 
         0.11501454641530486`], 
        ArrowBox[{{33.72717549541997, 6.}, {34.43548291092142, 5.}}, 
         0.11501454641530486`], 
        ArrowBox[{{-1.82543366938566, 6.}, {-1.8254336694808444`, 5.}}, 
         0.11501454641530486`], 
        ArrowBox[{{16.71830531855747, 6.}, {16.718305318510772`, 5.}}, 
         0.11501454641530486`], 
        ArrowBox[{{14.718305318151664`, 6.}, {14.718305318232666`, 5.}}, 
         0.11501454641530486`], 
        ArrowBox[{{33.43548291084545, 5.}, {33.435482910895075`, 4.}}, 
         0.11501454641530486`], 
        ArrowBox[{{33.435482910895075`, 4.}, {33.99227857181481, 3.}}, 
         0.11501454641530486`], 
        ArrowBox[{{33.435482910895075`, 4.}, {32.99227857166724, 3.}}, 
         0.11501454641530486`], 
        ArrowBox[{{33.99227857181481, 3.}, {33.992278571885464`, 2.}}, 
         0.11501454641530486`], 
        ArrowBox[{{32.99227857166724, 3.}, {31.992278571833964`, 2.}}, 
         0.11501454641530486`], 
        ArrowBox[{{32.99227857166724, 3.}, {32.99227857178403, 2.}}, 
         0.11501454641530486`], 
        ArrowBox[{{33.992278571885464`, 2.}, {33.526917011818426`, 1.}}, 
         0.11501454641530486`], 
        ArrowBox[{{33.992278571885464`, 2.}, {34.52691701183895, 1.}}, 
         0.11501454641530486`], 
        ArrowBox[{{34.52691701183895, 1.}, {34.52691701181266, 0.}}, 
         0.11501454641530486`]}, 
       {Hue[0.6, 0.2, 0.8], EdgeForm[{GrayLevel[0], Opacity[0.7]}], {
         {RGBColor[0.513417, 0.72992, 0.440682], 
          DiskBox[{0., 19.}, 0.11501454641530486]}, InsetBox[
          StyleBox["1",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {0.11501454641530486, 19.115014546415306}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.266122, 0.486664, 0.802529], 
          DiskBox[{-2.022220191745106, 18.}, 0.11501454641530486]}, InsetBox[
          StyleBox["2",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {-1.907205645329801, 18.115014546415306}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.863512, 0.670771, 0.236564], 
          DiskBox[{2.045937863027717, 18.}, 0.11501454641530486]}, InsetBox[
          StyleBox["3",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {2.160952409443022, 18.115014546415306}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.266122, 0.486664, 0.802529], 
          DiskBox[{-3.448540882597314, 17.}, 0.11501454641530486]}, InsetBox[
          StyleBox["4",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {-3.333526336182009, 17.115014546415306}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.705038, 0.742591, 0.299167], 
          DiskBox[{23.095079223215066, 17.}, 0.11501454641530486]}, InsetBox[
          StyleBox["5",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {23.210093769630372, 17.115014546415306}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.902853, 0.453964, 0.192014], 
          DiskBox[{2.0459378630190486, 17.}, 0.11501454641530486]}, InsetBox[
          StyleBox["6",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {2.1609524094343535, 17.115014546415306}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.250728, 0.225386, 0.769152], 
          DiskBox[{-4.448540882610757, 16.}, 0.11501454641530486]}, InsetBox[
          StyleBox["7",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {-4.333526336195453, 16.115014546415306}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.36048, 0.655759, 0.645692], 
          DiskBox[{-3.4485408826000423, 16.}, 0.11501454641530486]}, InsetBox[
          StyleBox["8",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {-3.3335263361847374, 16.115014546415306}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.607651, 0.743718, 0.358588], 
          DiskBox[{23.09507922324812, 16.}, 0.11501454641530486]}, InsetBox[
          StyleBox["9",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {23.210093769663427, 16.115014546415306}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.794549, 0.721158, 0.260829], 
          DiskBox[{28.99952564036272, 16.}, 0.11501454641530486]}, InsetBox[
          StyleBox["10",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {29.114540186778026, 16.115014546415306}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.8885133333333333, 0.6121409999999999, 0.223216], 
          DiskBox[{-1.6581062291706417, 16.}, 0.11501454641530486]}, InsetBox[
          StyleBox["11",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {-1.5430916827553367, 16.115014546415306}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.902853, 0.453964, 0.192014], 
          DiskBox[{10.392213397079445, 16.}, 0.11501454641530486]}, InsetBox[
          StyleBox["12",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {10.50722794349475, 16.115014546415306}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.8711909999999999, 0.23917400000000003`, 0.15103], 
          DiskBox[{2.0459378630265803, 16.}, 0.11501454641530486]}, InsetBox[
          StyleBox["13",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {2.1609524094418853, 16.115014546415306}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.36048, 0.655759, 0.645692], 
          DiskBox[{-4.163490779319204, 15.}, 0.11501454641530486]}, InsetBox[
          StyleBox["14",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {-4.0484762329039, 15.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.5605340000000001, 0.736819, 0.399635], 
          DiskBox[{22.204005292846148, 15.}, 0.11501454641530486]}, InsetBox[
          StyleBox["15",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {22.319019839261454, 15.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[
          0.6563445000000001, 0.7431544999999999, 0.32887750000000004`], 
          DiskBox[{24.30082938528264, 15.}, 0.11501454641530486]}, InsetBox[
          StyleBox["16",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {24.415843931697946, 15.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.7497935, 0.7318745, 0.27999799999999997`], 
          DiskBox[{28.999525640306786, 15.}, 0.11501454641530486]}, InsetBox[
          StyleBox["17",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {29.114540186722092, 15.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.8290305, 0.6959645, 0.2486965], 
          DiskBox[{31.787374888605996, 15.}, 0.11501454641530486]}, InsetBox[
          StyleBox["18",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {31.902389435021302, 15.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
          DiskBox[{-1.6581062291776334, 15.}, 0.11501454641530486]}, InsetBox[
          StyleBox["19",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {-1.5430916827623284, 15.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.901014, 0.582826, 0.216542], 
          DiskBox[{-2.658106229401284, 15.}, 0.11501454641530486]}, InsetBox[
          StyleBox["20",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {-2.543091682985979, 15.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.90224, 0.49691799999999997`, 0.20019], 
          DiskBox[{15.58982508570682, 15.}, 0.11501454641530486]}, InsetBox[
          StyleBox["21",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {15.704839632122125, 15.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.8946043333333333, 0.40037866666666666`, 0.181503], 
          DiskBox[{10.392213397097919, 15.}, 0.11501454641530486]}, InsetBox[
          StyleBox["22",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {10.507227943513223, 15.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.878107, 0.293208, 0.160481], 
          DiskBox[{1.3418937707969292, 15.}, 0.11501454641530486]}, InsetBox[
          StyleBox["23",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {1.4569083172122341, 15.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.864275, 0.18514000000000003`, 0.141579], 
          DiskBox[{2.3418937709033685, 15.}, 0.11501454641530486]}, InsetBox[
          StyleBox["24",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {2.4569083173186734, 15.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.36048, 0.655759, 0.645692], 
          DiskBox[{-4.658106229575736, 14.}, 0.11501454641530486]}, InsetBox[
          StyleBox["25",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {-4.543091683160432, 14.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.5369755, 0.7333695, 0.4201585], 
          DiskBox[{22.20400529291129, 14.}, 0.11501454641530486]}, InsetBox[
          StyleBox["26",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {22.319019839326597, 14.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.5840925, 0.7402685, 0.37911150000000005`], 
          DiskBox[{19.98380650707307, 14.}, 0.11501454641530486]}, InsetBox[
          StyleBox["27",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {20.098821053488376, 14.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[
          0.6563445000000001, 0.7431544999999999, 0.32887750000000004`], 
          DiskBox[{25.204005293188686, 14.}, 0.11501454641530486]}, InsetBox[
          StyleBox["28",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {25.319019839603992, 14.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.72741575, 0.73723275, 0.2895825], 
          DiskBox[{28.528916755615484, 14.}, 0.11501454641530486]}, InsetBox[
          StyleBox["29",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {28.64393130203079, 14.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.77217125, 0.72651625, 0.2704135], 
          DiskBox[{29.528916755708195, 14.}, 0.11501454641530486]}, InsetBox[
          StyleBox["30",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {29.6439313021235, 14.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.81178975, 0.70856125, 0.25476275], 
          DiskBox[{31.787374888571406, 14.}, 0.11501454641530486]}, InsetBox[
          StyleBox["31",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {31.902389434986713, 14.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
          DiskBox[{33.82146193475651, 14.}, 0.11501454641530486]}, InsetBox[
          StyleBox["32",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {33.936476481171816, 14.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
          DiskBox[{-1.6581062291994613, 14.}, 0.11501454641530486]}, InsetBox[
          StyleBox["33",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {-1.5430916827841563, 14.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.8947636666666666, 0.5974835, 0.21987900000000002`], 
          DiskBox[{-3.6581062295064726, 14.}, 0.11501454641530486]}, InsetBox[
          StyleBox["34",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {-3.5430916830911676, 14.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.9013205, 0.561349, 0.212454], 
          DiskBox[{-2.658106229391535, 14.}, 0.11501454641530486]}, InsetBox[
          StyleBox["35",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {-2.5430916829762302, 14.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[
          0.9019334999999999, 0.5183949999999999, 0.20427800000000002`], 
          DiskBox[{15.58982508561752, 14.}, 0.11501454641530486]}, InsetBox[
          StyleBox["36",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {15.704839632032824, 14.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.9025465, 0.475441, 0.196102], 
          DiskBox[{16.914169108709814, 14.}, 0.11501454641530486]}, InsetBox[
          StyleBox["37",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {17.02918365512512, 14.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
          DiskBox[{9.851797329644882, 14.}, 0.11501454641530486]}, InsetBox[
          StyleBox["38",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {9.966811876060186, 14.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.8904799999999999, 0.373586, 0.1762475], 
          DiskBox[{10.984121802026266, 14.}, 0.11501454641530486]}, InsetBox[
          StyleBox["39",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {11.09913634844157, 14.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.878107, 0.293208, 0.160481], 
          DiskBox[{1.3418937706159682, 14.}, 0.11501454641530486]}, InsetBox[
          StyleBox["40",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {1.456908317031273, 14.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.867733, 0.212157, 0.1463045], 
          DiskBox[{2.341893770862299, 14.}, 0.11501454641530486]}, InsetBox[
          StyleBox["41",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {2.456908317277604, 14.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.8608169999999999, 0.15812299999999999`, 0.1368535], 
          DiskBox[{3.3418937709029137, 14.}, 0.11501454641530486]}, InsetBox[
          StyleBox["42",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {3.4569083173182187, 14.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[
          0.5212698333333333, 0.7310698333333333, 0.43384083333333334`], 
          DiskBox[{21.204005292813918, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["43",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {21.319019839229224, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.5369755, 0.7333695, 0.4201585], 
          DiskBox[{22.204005292866498, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["44",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {22.319019839281804, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[
          0.5526811666666667, 0.7356691666666667, 0.4064761666666667], 
          DiskBox[{23.204005292962535, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["45",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {23.31901983937784, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.57231325, 0.73854375, 0.38937325], 
          DiskBox[{19.983806507063207, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["46",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {20.098821053478513, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.59587175, 0.7419932499999999, 0.36884975000000003`], 
          DiskBox[{18.983806507039276, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["47",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {19.098821053454582, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 
          DiskBox[{26.204005293276737, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["48",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {26.319019839692043, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
          DiskBox[{25.204005292998232, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["49",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {25.31901983941354, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.716226875, 0.739911875, 0.29437475], 
          DiskBox[{28.52891675571965, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["50",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {28.643931302134956, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.738604625, 0.734553625, 0.28479025], 
          DiskBox[{27.52891675554787, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["51",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {27.643931301963175, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.77217125, 0.72651625, 0.2704135], 
          DiskBox[{29.52891675584408, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["52",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {29.643931302259386, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[
          0.8002959166666667, 0.7169590833333332, 0.25880691666666666`], 
          DiskBox[{32.90863910066366, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["53",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {33.023653647078966, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.81178975, 0.70856125, 0.25476275], 
          DiskBox[{31.78737488864786, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["54",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {31.902389435063167, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[
          0.8232835833333333, 0.7001634166666666, 0.2507185833333333], 
          DiskBox[{30.78737488862774, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["55",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {30.902389435043045, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
          DiskBox[{34.79035567590262, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["56",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {34.90537022231792, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.8760126666666667, 0.641456, 0.22989], 
          DiskBox[{-1.6581062293238062, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["57",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {-1.5430916829085013, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.90116725, 0.5720875, 0.21449800000000002`], 
          DiskBox[{-2.6581062294621063, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["58",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {-2.5430916830468013, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.90147375, 0.5506105, 0.21041], 
          DiskBox[{-3.6581062294757203, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["59",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {-3.5430916830604153, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.90178025, 0.5291334999999999, 0.206322], 
          DiskBox[{15.341893770984996, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["60",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {15.4569083174003, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.90208675, 0.5076565, 0.202234], 
          DiskBox[{16.34189377122229, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["61",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {16.456908317637595, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.9025465, 0.475441, 0.196102], 
          DiskBox[{17.553065300915137, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["62",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {17.668079847330443, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.8987286666666667, 0.42717133333333335`, 0.1867585], 
          DiskBox[{9.650469521453346, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["63",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {9.76548406786865, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[
          0.8925421666666666, 0.3869823333333333, 0.17887524999999999`], 
          DiskBox[{10.984121801885891, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["64",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {11.099136348301196, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[
          0.8884178333333334, 0.3601896666666667, 0.17361975000000002`], 
          DiskBox[{12.129616882880441, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["65",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {12.244631429295746, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.8822313333333334, 0.3200006666666667, 0.1657365], 
          DiskBox[{0.341893770679377, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["66",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {0.4569083170946818, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.874649, 0.266191, 0.15575550000000002`], 
          DiskBox[{1.3418937707158989, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["67",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {1.4569083171312038, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.862546, 0.1716315, 0.13921624999999999`], 
          DiskBox[{4.895639399270124, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["68",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {5.010653945685428, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.859088, 0.1446145, 0.13449075], 
          DiskBox[{3.3418937708428302, 13.}, 0.11501454641530486]}, InsetBox[
          StyleBox["69",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {3.456908317258135, 13.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[
          0.5173434166666667, 0.7304949166666667, 0.4372614166666667], 
          DiskBox[{20.204005292768187, 12.}, 0.11501454641530486]}, InsetBox[
          StyleBox["70",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {20.319019839183493, 12.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.52519625, 0.7316447500000001, 0.43042025], 
          DiskBox[{21.20400529287477, 12.}, 0.11501454641530486]}, InsetBox[
          StyleBox["71",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {21.319019839290075, 12.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.5369755, 0.7333695, 0.4201585], 
          DiskBox[{22.204005292801952, 12.}, 0.11501454641530486]}, InsetBox[
          StyleBox["72",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {22.31901983921726, 12.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.5487547500000001, 0.73509425, 0.40989675000000003`], 
          DiskBox[{24.204005293073692, 12.}, 0.11501454641530486]}, InsetBox[
          StyleBox["73",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {24.319019839489, 12.115014546415305}], ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[
          0.5566075833333334, 0.7362440833333334, 0.40305558333333336`], 
          DiskBox[{23.204005292971544, 12.}, 0.11501454641530486]}, InsetBox[
          StyleBox["74",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {23.31901983938685, 12.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.57231325, 0.73854375, 0.38937325], 
          DiskBox[{19.20400529253598, 12.}, 0.11501454641530486]}, InsetBox[
          StyleBox["75",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {19.319019838951288, 12.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.63199775, 0.74343625, 0.34373275000000003`], 
          DiskBox[{26.20400529323473, 12.}, 0.11501454641530486]}, InsetBox[
          StyleBox["76",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {26.319019839650036, 12.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.6806912500000001, 0.74287275, 0.31402225], 
          DiskBox[{25.2040052935389, 12.}, 0.11501454641530486]}, InsetBox[
          StyleBox["77",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {25.319019839954205, 12.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.7106324375, 0.7412514375, 0.296770875], 
          DiskBox[{28.5289167556721, 12.}, 0.11501454641530486]}, InsetBox[
          StyleBox["78",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {28.643931302087406, 12.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.7218213125, 0.7385723125, 0.291978625], 
          DiskBox[{27.528916755722918, 12.}, 0.11501454641530486]}, InsetBox[
          StyleBox["79",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {27.643931302138224, 12.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.77217125, 0.72651625, 0.2704135], 
          DiskBox[{29.528916755892908, 12.}, 0.11501454641530486]}, InsetBox[
          StyleBox["80",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {29.643931302308214, 12.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[
          0.7974224583333333, 0.7190585416666666, 0.2598179583333333], 
          DiskBox[{34.03234014975271, 12.}, 0.11501454641530486]}, InsetBox[
          StyleBox["81",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {34.147354696168016, 12.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.803169375, 0.714859625, 0.257795875], 
          DiskBox[{32.9086391006756, 12.}, 0.11501454641530486]}, InsetBox[
          StyleBox["82",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {33.0236536470909, 12.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.81178975, 0.70856125, 0.25476275], 
          DiskBox[{31.39615061319833, 12.}, 0.11501454641530486]}, InsetBox[
          StyleBox["83",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           GraphicsColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           FontSize->8,
           
           FontColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666]], 
          Offset[{2, 2}, {31.511165159613636, 12.115014546415305}], 
          ImageScaled[{0, 0}],
          BaseStyle->"Graphics"]}, {
         {RGBColor[0.8462712499999999, 0.6833677499999999, 0.24263025], 
          DiskBox[{35.396150612891205, 12.}, 0.11501454641530486]}, InsetBox[
          StyleBox["84",
           StripOnInput->False,
           
           LineColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           FrontFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6666666666666666],
           
           BackFaceColor->RGBColor[
            0.6666666666666666, 0.6666666666666666, 0.6