/*
 * Decompiled with CFR 0.152.
 */
package netStruct_Hierarchy;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import netStruct_Hierarchy.Edge;

public class TextConvertor {
    public static Set<Integer> getListOfNodes(String pathToListOfComms, int line) throws IOException {
        String[] parts;
        HashSet<Integer> nodes = new HashSet<Integer>();
        List<String> lines = Files.readAllLines(Paths.get(pathToListOfComms, new String[0]));
        String lineS = lines.get(line);
        String[] stringArray = parts = lineS.split(" ");
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            nodes.add(new Integer(part));
            ++n2;
        }
        return nodes;
    }

    public static Set<Edge> getListOfEdges(String pathToListOfEdges) throws IOException {
        HashSet<Edge> edges = new HashSet<Edge>();
        List<String> lines = Files.readAllLines(Paths.get(pathToListOfEdges, new String[0]));
        for (String line : lines) {
            String[] parts = line.split("\t");
            edges.add(new Edge(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Double.parseDouble(parts[2])));
        }
        return edges;
    }

    public static Map<String, String[]> DEPRECTAEDgetMapCode2SampleSites(String pathToMapCode2SampleSites) throws IOException {
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        List<String> lines = Files.readAllLines(Paths.get(pathToMapCode2SampleSites, new String[0]));
        for (String line : lines) {
            String[] parts = line.split("[,\\s]+");
            map.put(parts[0], new String[]{parts[1], parts[2]});
        }
        return map;
    }

    public static Map<Integer, String> getMapNode2SampleSite(String pathToMapNode2SampleSiteCode, Set<Integer> individulasToExclude) throws IOException {
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        List<String> lines = Files.readAllLines(Paths.get(pathToMapNode2SampleSiteCode, new String[0]));
        Integer nodeId = 0;
        for (String line : lines) {
            if (!individulasToExclude.contains(nodeId)) {
                map.put(nodeId, line.trim());
            }
            nodeId = nodeId + 1;
        }
        return map;
    }

    public static String[][] getSampleSites(String pathToSampleSites) throws IOException {
        List<String> lines = Files.readAllLines(Paths.get(pathToSampleSites, new String[0]));
        int numOfAreas = lines.size();
        String[][] sampleSites = new String[numOfAreas][];
        int i = 0;
        while (i < numOfAreas) {
            String[] sampleSitesInArea = lines.get(i).trim().split("[,\\s]+");
            sampleSites[i] = sampleSitesInArea;
            ++i;
        }
        return sampleSites;
    }

    public static double[] createInputs(boolean inputAsMatrix, String pathToMatrixFile, String pathToEdgesFile, String edgesFileName, String commsFileName, Set<Integer> individulasToExclude) throws IOException {
        if (inputAsMatrix) {
            return TextConvertor.createInputsFromMatrix(pathToMatrixFile, edgesFileName, commsFileName, individulasToExclude);
        }
        return TextConvertor.createInputsFromEdgeList(pathToEdgesFile, edgesFileName, commsFileName, individulasToExclude);
    }

    public static Set<Integer> getIndividulasToExclude(String pathToIndividulasToExclude) throws IOException {
        HashSet<Integer> ans = new HashSet<Integer>();
        if (pathToIndividulasToExclude != null && pathToIndividulasToExclude != "") {
            String line = Files.readAllLines(Paths.get(pathToIndividulasToExclude, new String[0])).get(0);
            String[] stringArray = line.trim().split("[,\\s]+");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String ind = stringArray[n2];
                ans.add(Integer.parseInt(ind));
                ++n2;
            }
        }
        return ans;
    }

    private static double[] createInputsFromMatrix(String pathToMatrix, String pathToListOfEdges, String pathToListOfComms, Set<Integer> individulasToExclude) throws IOException {
        double minEdgeWeight = Double.MAX_VALUE;
        double maxEdgeWeight = Double.MIN_VALUE;
        List<String> lines = Files.readAllLines(Paths.get(pathToMatrix, new String[0]));
        PrintWriter writerEdges = new PrintWriter(pathToListOfEdges, "UTF-8");
        HashSet<Integer> nodes = new HashSet<Integer>();
        Integer nodeFrom = 0;
        for (String line : lines) {
            if (!individulasToExclude.contains(nodeFrom)) {
                nodes.add(nodeFrom);
            }
            String[] weights = line.split("[,\\s]+");
            Integer nodeTo = nodeFrom + 1;
            String[] stringArray = weights;
            int n = weights.length;
            int n2 = 0;
            while (n2 < n) {
                String weightS = stringArray[n2];
                double weight = Double.parseDouble(weightS);
                if (weight < minEdgeWeight) {
                    minEdgeWeight = weight;
                }
                if (weight > maxEdgeWeight) {
                    maxEdgeWeight = weight;
                }
                if (!individulasToExclude.contains(nodeFrom) && !individulasToExclude.contains(nodeTo)) {
                    writerEdges.println(new Edge(nodeFrom, nodeTo, Double.parseDouble(weightS)));
                }
                nodeTo = nodeTo + 1;
                ++n2;
            }
            nodeFrom = nodeFrom + 1;
        }
        if (!individulasToExclude.contains(nodeFrom)) {
            nodes.add(nodeFrom);
        }
        writerEdges.close();
        PrintWriter writerComms = new PrintWriter(pathToListOfComms, "UTF-8");
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            int node = (Integer)iterator.next();
            writerComms.print(String.valueOf(node) + " ");
        }
        writerComms.close();
        return new double[]{minEdgeWeight, maxEdgeWeight};
    }

    private static double[] createInputsFromEdgeList(String pathToEdgesFile, String pathToListOfEdges, String pathToListOfComms, Set<Integer> individulasToExclude) throws IOException {
        double minEdgeWeight = Double.MAX_VALUE;
        double maxEdgeWeight = Double.MIN_VALUE;
        HashSet<Integer> nodes = new HashSet<Integer>();
        List<String> edges = Files.readAllLines(Paths.get(pathToEdgesFile, new String[0]));
        PrintWriter writerEdges = new PrintWriter(pathToListOfEdges, "UTF-8");
        for (String edge : edges) {
            double weight;
            String[] edgeParts = edge.trim().split("[,\\s]+");
            Integer nodeFrom = Integer.parseInt(edgeParts[0]);
            Integer nodeTo = Integer.parseInt(edgeParts[1]);
            if (!individulasToExclude.contains(nodeFrom)) {
                nodes.add(nodeFrom);
            }
            if (!individulasToExclude.contains(nodeTo)) {
                nodes.add(nodeTo);
            }
            if ((weight = Double.parseDouble(edgeParts[2])) < minEdgeWeight) {
                minEdgeWeight = weight;
            }
            if (weight > maxEdgeWeight) {
                maxEdgeWeight = weight;
            }
            if (individulasToExclude.contains(nodeFrom) || individulasToExclude.contains(nodeTo)) continue;
            writerEdges.println(new Edge(nodeFrom, nodeTo, weight));
        }
        writerEdges.close();
        PrintWriter writerComms = new PrintWriter(pathToListOfComms, "UTF-8");
        Iterator iterator = nodes.iterator();
        while (iterator.hasNext()) {
            int node = (Integer)iterator.next();
            writerComms.print(String.valueOf(node) + " ");
        }
        writerComms.close();
        return new double[]{minEdgeWeight, maxEdgeWeight};
    }
}

