/*
 * Decompiled with CFR 0.152.
 */
package netStruct_Hierarchy;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.InputMismatchException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import netStruct_Hierarchy.CommAnalyzer;
import netStruct_Hierarchy.CommBraker;
import netStruct_Hierarchy.CommId;
import netStruct_Hierarchy.Common;
import netStruct_Hierarchy.TextConvertor;

public class NetStruct_Hierarchy {
    static boolean debug = false;
    static boolean dummy = false;
    static String[] varFlags = new String[]{"-ss", "-dy", "-mod", "-minb", "-mino", "-b", "-pro", "-skip", "-pca", "-pm", "-pe", "-pmn", "-pss", "-nvl", "-w", "-ls", "-pts", "-indtoex"};
    static String[] varValues;

    static {
        String[] stringArray = new String[18];
        stringArray[0] = "0.0001";
        stringArray[1] = "false";
        stringArray[2] = "true";
        stringArray[3] = "3";
        stringArray[4] = "3";
        stringArray[5] = "1.0";
        stringArray[6] = "C:/Data/";
        stringArray[7] = "false";
        stringArray[8] = "";
        stringArray[9] = "C:/Data/Matrix.txt";
        stringArray[10] = "";
        stringArray[11] = "C:/Data/indlist.csv";
        stringArray[12] = "C:/Data/SampleSites.txt";
        stringArray[13] = "0";
        stringArray[14] = "true";
        stringArray[15] = "false";
        stringArray[16] = "false";
        varValues = stringArray;
    }

    public static void main(String[] args) throws Exception {
        NetStruct_Hierarchy.singleRun(args);
    }

    public static void singleRun(String[] args) throws Exception {
        List<CommId> comms;
        if (!debug && args.length == 0) {
            System.out.println("******************************************\n       Welcom to NetStruct_Hierarchy! \n******************************************\n\nUse -h to get full help.\n\n Running the jar with a single param '-demo' will run a dummy sample, generating sample inputs and outputs in ./sample/ \n\n\nInput parameteres for NetStruct_Hierarchy: \nstepSize = 0.0001 \ndynamicChoose = false \nuseModularityAsDefaultMetric = true \nminSizeOfCommToBrake = 3 \nminSizeOfCommToOutput = 3 \nbeta = 1.0 \npathToRootOutputDir = C:/Data/\nskipBrakeComms = false \npathToCommAnalysisFile placeholder (full path is required if @skipBrakeComms)\npathToMatrixDir = C:/Data/Matrix.txt \npathToEdgesFile = C:/Data/ListOfEdges.txt \npathToMapNode2SampleSiteCode = C:/Data/indlist.csv \npathToSampleSites = C:/Data/SampleSites.txt \nnectarVerboseLevel = 0 \nuseWeighted = true \npathToIndividulasToExclude = null \n\n For your use - a sample full command line: \njava -jar NetStruct_Hierarchy_v1.jar -ss 0.0001 -dy true -mod true -minb 3 -mino 3 -b 1.0 -pro C:/Data/ -skip false -pca placeholder -pm C:/Data/Matrix.txt -pe placeholder -pmn C:/Data/indlist.txt -pss C:/Data/SampleSites.txt -nvl 0 -w true -indtoex placeholder\n");
            return;
        }
        if (!debug && (args[0].equals("-h") || args[0].equals("-H"))) {
            System.out.println("******************************************\n       Welcome to NetStruct_Hierarchy! \n******************************************\n\n---   This program will break a dense network to communities, in an hirarcial manner.\n---   The code can be found at TDOD. \n---   For full details please refer to our paper TODO.\n---   If you use this code in your work, please cite TODO. \n\n\n Running the jar with a single param '-demo' will run a dummy sample, generating sample inputs and outputs in ./sample/ \n-----------------------------------------------------\n\n\nInput params:\n-----------------------------------------------------\nstepSize (-ss) - \n\t\t a double. For a given community, this value is added to the minimum edge weight in the community, to construct the threshold which any edge below it will be removed when looking for subcommunites. @stepSize is added until we break the given community. Default - 0.0001. \ndynamicChoose (-dy) -\n\t\t a boolean, controls if NECTAR chooses dynamicly between WOCC and Modularity to find communities. Default - false. \nuseModularityAsDefaultMetric (-mod) -\n\t\t a boolean, controls the default metric NECTAR uses to find modularity (incase @dynamicChoose is set to false). Default - true. \nminSizeOfCommToBrake (-minb) -\n\t\t an int, the minimum amount of nodes in a community in order to brake it to sub-communities. Default - 3. \nminSizeOfCommToOutput (-mino) -\n\t\t an int, the minimum amount of nodes in a community in order to output it. Default - 3. \nbeta (-b) -\n\t\t a double, at least 1.0 (e.g. '1.0'). Used by NECTAR to find communities (when given 1.0, there is no overlap between communities). \npathToRootOutputDir (-pro) -\n\t\t full path to the directory where the output will be written. Will overwrite existing files! A sub directory in this location will be created, including all the params used in its name.\nskipBrakeComms (-skip) -\n\t\t internal use. a boolean, when true, will read the file in @pathToCommAnalysisFile and perfom merge by Chi-squere and F1 and structure calculation. Default - false \npathToCommAnalysisFile (-pca) -\n\t\t Internal use. full path to CommAnalysisFile - an existing output of this program. used when @skipBrakeComms is true. \npathToMatrixFile (-pm) -\n\t\t full path to the the file containing a matrix of weights between nodes, with respect to the list of nodes in @pathToMapNode2SampleSite. \npathToEdgesFile (-pe) -\n\t\t full path to the the file containing a list of weighted edges (format is <node> <node> <weight>), with respect to the list of nodes in @pathToMapNode2SampleSite. \n\t\t -------- PLEASE NOTE THAT ALL NUMBERS BETWEEN 0 AND n-1(number of nodes) SHOULD APPEAR! \n\t\t -------- If the paramter given in @pathToMatrixFile is not a valid file, the list of edges will be used. \npathToMapNode2SampleSite (-pmn) -\n\t\t full path to file containing in each line i a sampleSite code indicating the sampleSite of node i.\npathToSampleSites (-pss) -\n\t\t full path to file containing in each line a list of comma separated sample sites (which match the values in @pathToMapNode2SampleSite.) In each line you can put several sample sites, they will be considered to be in the same area. This is non mandatory - you may put all sample sites in a single line. \nnectarVerboseLevel (-nvl) -\n\t\t one of 0,1,2 - verbose level of nectar (higher is more vebose).  Default - 0. \nuseWeighted (-w) -\n\t\t boolean. When true - only Modularity is used. Default - true. \npathToIndividulasToExclude (-indtoex) -\n\t\t string. When supplied must be a path to a file containing a comma separated list of nodes. Note that if a matrix of edges is given, the first node index is 0! Default - null. \n\n-----------------------------------------------------\nOutput: \n-----------------------------------------------------\n1_CommAnalysis_...txt -\n\t\t UNMERGED comm stats found.\n2_Leafs_NoOverlap.txt -\n\t\t Leafs found in the tree. Dropped individuals are assigned to a singleton leaf.\n2_Leafs_WithOverlap.txt -\n\t\t Leafs found in the tree. Dropped individuals are assigned to a all leafs under the node in which they appear.\nlog_<@matrixFileName>_<HH-mm_d--MM-YYYY>.log -\n\t\t log of the process.\nLe_#_En_#_PaLe_#_PaEn_#_PaLi_#_TH__C.txt -\n\t\t a list of comms in the given level and entry.\nLe_#_En_#_PaLe_#_PaEn_#_PaLi_#_TH__E.txt -\n\t\t a list of edges in the given level and entry.\n");
            System.out.println("******************************************\n       Welcom to NetStruct_Hierarchy! \n******************************************\n\nUse -h to get full help.\n\n Running the jar with a single param '-demo' will run a dummy sample, generating sample inputs and outputs in ./sample/ \n\n\nInput parameteres for NetStruct_Hierarchy: \nstepSize = 0.0001 \ndynamicChoose = false \nuseModularityAsDefaultMetric = true \nminSizeOfCommToBrake = 3 \nminSizeOfCommToOutput = 3 \nbeta = 1.0 \npathToRootOutputDir = C:/Data/\nskipBrakeComms = false \npathToCommAnalysisFile placeholder (full path is required if @skipBrakeComms)\npathToMatrixDir = C:/Data/Matrix.txt \npathToEdgesFile = C:/Data/ListOfEdges.txt \npathToMapNode2SampleSiteCode = C:/Data/indlist.csv \npathToSampleSites = C:/Data/SampleSites.txt \nnectarVerboseLevel = 0 \nuseWeighted = true \npathToIndividulasToExclude = null \n\n For your use - a sample full command line: \njava -jar NetStruct_Hierarchy_v1.jar -ss 0.0001 -dy true -mod true -minb 3 -mino 3 -b 1.0 -pro C:/Data/ -skip false -pca placeholder -pm C:/Data/Matrix.txt -pe placeholder -pmn C:/Data/indlist.txt -pss C:/Data/SampleSites.txt -nvl 0 -w true -indtoex placeholder\n");
            return;
        }
        if (!debug && args[0].equals("-demo")) {
            dummy = true;
        }
        if (!debug & !dummy) {
            NetStruct_Hierarchy.populateVarValues(args);
        }
        double stepSize = Double.parseDouble(varValues[0]);
        boolean dynamicChoose = Boolean.parseBoolean(varValues[1]);
        boolean useModularityAsDefaultMetric = Boolean.parseBoolean(varValues[2]);
        int minSizeOfCommToBrake = Integer.parseInt(varValues[3]);
        int minSizeOfCommToOutput = Integer.parseInt(varValues[4]);
        String beta = varValues[5];
        String pathToRootOutputDir = varValues[6];
        boolean skipBrakeComms = Boolean.parseBoolean(varValues[7]);
        String pathToCommAnalysisFile = varValues[8];
        String pathToMatrixFile = varValues[9];
        String pathToEdgesFile = varValues[10];
        String pathToMapNode2SampleSite = varValues[11];
        String pathToSampleSites = varValues[12];
        int nectarVerboseLevel = Integer.parseInt(varValues[13]);
        boolean useWeighted = Boolean.parseBoolean(varValues[14]);
        boolean useLeafSizesForStructure = Boolean.parseBoolean(varValues[15]);
        boolean useProportionalTreeSplitsForStructure = Boolean.parseBoolean(varValues[16]);
        String pathToIndividulasToExclude = varValues[17];
        if (useWeighted) {
            dynamicChoose = false;
            useModularityAsDefaultMetric = true;
        }
        if (!skipBrakeComms && (pathToRootOutputDir = String.valueOf(pathToRootOutputDir) + "W_" + (useWeighted ? 1 : 0) + "_D_" + (dynamicChoose ? 1 : 0) + "_Min_" + minSizeOfCommToBrake + "_SS_" + stepSize + "_B_" + beta + "/").length() > 100) {
            throw new Exception("Output path is too long, max is 100, got " + pathToRootOutputDir.length() + ". The reason for this limitation is the fact that in some OS (like Windows) there is a limitation on the path of a file. NetStruct_Hierarchy write files with relativly long names, and so we limit the output folder path to 100. Sorry for that...");
        }
        if (dummy) {
            stepSize = 0.01;
            pathToRootOutputDir = "./sample/DUMMYStepSize_" + stepSize + "_Beta_" + beta + "_DynamicChoose_" + dynamicChoose + "_minSizeOfCommToBrake_" + minSizeOfCommToBrake + "/";
            NetStruct_Hierarchy.deleteDirectory(pathToRootOutputDir);
            pathToMatrixFile = "./sample/DUMMY_All_chrome_M.txt";
            Common.writeToFile(pathToMatrixFile, "0.5\t0.5\t0.0001\t0.0001 0.0001\n0.5\t0.0001\t0.0001 0.0001\n0.0001\t0.0001 0.0001\n0.5 0.5\n0.5");
            pathToMapNode2SampleSite = "./sample/DUMMY_indlist.txt";
            Common.writeToFile(pathToMapNode2SampleSite, "Africa\nAfrica\nAfrica\nAmerica\nAmerica\nAmerica");
            pathToSampleSites = "./sample/DUMMY_SampleSites.txt";
            Common.writeToFile(pathToSampleSites, "Africa,America");
            minSizeOfCommToBrake = 2;
            minSizeOfCommToOutput = 2;
        }
        if (!new File(pathToMatrixFile).exists() & !new File(pathToEdgesFile).exists()) {
            throw new InputMismatchException("You must supply @pathToMatrixfile or @pathToEdgesfile - paths to files who exist on the system.");
        }
        boolean inputAsMatrix = true;
        if (!new File(pathToMatrixFile).exists()) {
            inputAsMatrix = false;
        }
        if (Files.exists(Paths.get(pathToRootOutputDir, new String[0]), new LinkOption[0])) {
            throw new RuntimeException("The output directory supplied already exist, please change it to a non existing folder. Directory is: " + pathToRootOutputDir);
        }
        new File(pathToRootOutputDir).mkdirs();
        int firstLevel = 0;
        int firstEntry = 0;
        int firstLine = 0;
        System.out.println("stepSize:                      " + stepSize);
        System.out.println("dynamicChoose:                 " + dynamicChoose);
        System.out.println("useModularityAsDefaultMetric:  " + useModularityAsDefaultMetric);
        System.out.println("minSizeOfCommToBrake:          " + minSizeOfCommToBrake);
        System.out.println("minSizeOfCommToOutput:         " + minSizeOfCommToOutput);
        System.out.println("beta:                          " + beta);
        System.out.println("pathToRootOutputDir:           " + pathToRootOutputDir);
        if (inputAsMatrix) {
            System.out.println("pathToMatrixFile:              " + pathToMatrixFile);
        } else {
            System.out.println("pathToEdgesFile:               " + pathToEdgesFile);
        }
        System.out.println("pathToMapNode2SampleSite:      " + pathToMapNode2SampleSite);
        System.out.println("pathToSampleSites:             " + pathToSampleSites);
        System.out.println("nectarVerboseLevel:            " + nectarVerboseLevel);
        System.out.println("useWeighted:                   " + useWeighted);
        System.out.println("pathToIndividulasToExclude:    " + pathToIndividulasToExclude);
        System.out.println("");
        Set<Integer> individulasToExclude = TextConvertor.getIndividulasToExclude(pathToIndividulasToExclude);
        CommAnalyzer commAnalyzer = new CommAnalyzer(pathToMapNode2SampleSite, pathToSampleSites, minSizeOfCommToOutput, individulasToExclude);
        String pathToInputFile = inputAsMatrix ? pathToMatrixFile : pathToEdgesFile;
        String inputFileName = pathToInputFile.split("/")[pathToInputFile.split("/").length - 1];
        String pathToLog = String.valueOf(pathToRootOutputDir) + "log_" + inputFileName + "_" + Common.getDate() + ".log";
        Common.writeToLog(pathToLog, "------------------\n", debug);
        Common.writeToLog(pathToLog, "------------------\n", debug);
        Common.writeToLog(pathToLog, "Input file" + inputFileName + "\n", debug);
        String pathToOutputDir = pathToRootOutputDir;
        new File(pathToOutputDir).mkdirs();
        CommId rootComm = new CommId(pathToOutputDir, firstLevel, firstEntry, firstLine);
        if (!skipBrakeComms) {
            double[] minAndMaxEdgesWeights = TextConvertor.createInputs(inputAsMatrix, pathToMatrixFile, pathToEdgesFile, rootComm.edgesFileName, rootComm.commsFileName, individulasToExclude);
            double minThresholdToUse = minAndMaxEdgesWeights[0] + stepSize;
            double maxThresholdToUse = minAndMaxEdgesWeights[1];
            Common.writeToLog(pathToLog, "\t\tFirst level inputs created.\n", debug);
            pathToCommAnalysisFile = String.valueOf(pathToOutputDir) + "1_CommAnalysis_dynamic-" + dynamicChoose + "_modularity-" + useModularityAsDefaultMetric + "_minCommBrake-" + minSizeOfCommToBrake + "_" + stepSize + ".txt";
            LinkedList<CommId> firstLevelComms = new LinkedList<CommId>();
            firstLevelComms.add(rootComm);
            comms = CommBraker.brakeRec(pathToOutputDir, firstLevelComms, minThresholdToUse, stepSize, maxThresholdToUse, minSizeOfCommToBrake, beta, pathToLog, commAnalyzer, pathToCommAnalysisFile, dynamicChoose, useModularityAsDefaultMetric, -1, nectarVerboseLevel, useWeighted);
            comms.add(rootComm);
            Common.writeToLog(pathToLog, "\t\tDone with brakeRec\n", debug);
        } else {
            if (pathToCommAnalysisFile == null) {
                throw new RuntimeException("You must supply pathToCommAnalysisFile");
            }
            comms = commAnalyzer.getCommsFromFiles(pathToOutputDir, pathToCommAnalysisFile, rootComm);
        }
        Map<CommId, Map<String, Integer>> mapCommToMapCodeToCount = commAnalyzer.commsToMapSampleSiteToCount(comms);
        commAnalyzer.WriteStructureOutputToFile(rootComm, mapCommToMapCodeToCount.keySet(), "", minSizeOfCommToOutput, useLeafSizesForStructure, useProportionalTreeSplitsForStructure);
        Common.writeToLog(pathToLog, "\t\tDone with Write Structure Output To File without output\n", debug);
        String pathToLeafsBeforeMergeNoOverlapFile = String.valueOf(pathToOutputDir) + "2_Leafs_NoOverlap.txt";
        String pathToLeafsBeforeMergeWithOverlapFile = String.valueOf(pathToOutputDir) + "2_Leafs_WithOverlap.txt";
        commAnalyzer.LeafsAsCommunities();
        commAnalyzer.WriteLeafsNoOverlapAsCommunitiesToFile(pathToLeafsBeforeMergeNoOverlapFile);
        commAnalyzer.WriteLeafsWithOverlapAsCommunitiesToFile(pathToLeafsBeforeMergeWithOverlapFile);
        Common.writeToLog(pathToLog, "\t\tDone with Write Leafs As Communities To File\n", debug);
    }

    private static void deleteDirectory(String dir) throws IOException {
        Path directory = Paths.get(dir, new String[0]);
        if (Files.exists(directory, new LinkOption[0])) {
            Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    Files.delete(dir);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
    }

    private static void populateVarValues(String[] args) {
        int length = args.length;
        int i = 0;
        while (i < length) {
            String flag = args[i].toLowerCase();
            if (i + 1 > length) {
                throw new InputMismatchException("Bad input for NetStruct_Tree. The flag:" + flag + " is missing a value,");
            }
            boolean foundFlag = false;
            int j = 0;
            while (j < varFlags.length) {
                if (varFlags[j].equals(flag)) {
                    NetStruct_Hierarchy.varValues[j] = args[i + 1];
                    foundFlag = true;
                    break;
                }
                ++j;
            }
            if (!foundFlag) {
                throw new InputMismatchException("Bad input for NetStruct_Tree. The flag:" + flag + " is not found. Use -h to see available flags.");
            }
            i += 2;
        }
    }
}

