/*
 * Decompiled with CFR 0.152.
 */
package netStruct_Hierarchy;

import NECTAR.RunNectar;
import NECTAR_Weighted.RunNectar_Weighted;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Set;
import netStruct_Hierarchy.CommId;
import netStruct_Hierarchy.Common;
import netStruct_Hierarchy.Edge;
import netStruct_Hierarchy.TextConvertor;

public class NectarIntegration {
    public static CommId findNextThreshold(Boolean shouldUseModularity, String pathToWorkingDir, CommId parentComm, int entry, double minThresholdToUse, double stepSize, double maxThresholdToUse, int minSizeOfCommToBrake, String betas, int nectarVerboseLevel, boolean useWeighted) throws Exception {
        double th = -1.0;
        th = Math.max(minThresholdToUse, parentComm.th + stepSize);
        while (th <= maxThresholdToUse) {
            CommId newComms = new CommId(parentComm.pathToWorkingDir, parentComm.level + 1, entry, -1, th, parentComm);
            String pathToEdgesForNectar = NectarIntegration.createFileForNectarWeighted(th, newComms, pathToWorkingDir, minSizeOfCommToBrake);
            if (pathToEdgesForNectar == null) {
                return null;
            }
            NectarIntegration.runNectar(pathToEdgesForNectar, pathToWorkingDir, betas, shouldUseModularity, nectarVerboseLevel, useWeighted);
            String[] betasArray = betas.split(",");
            File[] nectarOutputs = new File[betasArray.length];
            int counter = 0;
            Object[] objectArray = betasArray;
            int n = betasArray.length;
            int n2 = 0;
            while (n2 < n) {
                File nectarOutput;
                String beta = objectArray[n2];
                nectarOutputs[counter] = nectarOutput = new File(String.valueOf(pathToWorkingDir) + beta + ".txt");
                ++counter;
                ++n2;
            }
            objectArray = nectarOutputs;
            n = nectarOutputs.length;
            n2 = 0;
            while (n2 < n) {
                Object nectarOutput = objectArray[n2];
                if (NectarIntegration.fileHasMoreThanNLines((File)nectarOutput, 1)) {
                    NectarIntegration.deleteFilesWithException(nectarOutputs, (File)nectarOutput);
                    String pathToOutputComms = newComms.commsFileName;
                    if (!((File)nectarOutput).renameTo(new File(pathToOutputComms))) {
                        System.out.println("Failed to rename NECTAR output to: " + pathToOutputComms + ". \n This is probably as the file already exists.\n" + "Existing file is renamed.");
                        Common.renameFile(pathToOutputComms);
                        if (!((File)nectarOutput).renameTo(new File(pathToOutputComms))) {
                            throw new IOException("Failed to rename NECTAR output to: " + pathToOutputComms);
                        }
                    }
                    return newComms;
                }
                NectarIntegration.deleteFilesWithException(nectarOutputs, null);
                new File(pathToEdgesForNectar).delete();
                ++n2;
            }
            th += stepSize;
        }
        return null;
    }

    private static void runNectar(String pathToFileForNecter, String pathToWorkingDir, String betas, Boolean shouldUseModularity, int nectarVerboseLevel, boolean useWeighted) throws Exception {
        String shouldUseModularityS = shouldUseModularity != false ? "true" : "false";
        String[] args = new String[]{pathToFileForNecter, pathToWorkingDir, betas, "0.8", "5", "20", "0", "99", "false", shouldUseModularityS, shouldUseModularityS == "true" ? "false" : "true", "false", "" + nectarVerboseLevel};
        if (useWeighted) {
            RunNectar_Weighted.main((String[])args);
        } else {
            RunNectar.main((String[])args);
        }
    }

    private static String createFileForNectarWeighted(double th, CommId newComms, String pathToWorkingDir, int minSizeOfCommToBrake) throws IOException {
        Set<Integer> nodes;
        String pathToFileForNecter;
        block4: {
            pathToFileForNecter = newComms.edgesFileName;
            nodes = TextConvertor.getListOfNodes(newComms.parentComm.commsFileName, newComms.parentComm.line);
            if (nodes.size() >= minSizeOfCommToBrake) break block4;
            return null;
        }
        try {
            PrintWriter writerNectar = new PrintWriter(pathToFileForNecter, "UTF-8");
            Set<Edge> edges = TextConvertor.getListOfEdges(newComms.parentComm.edgesFileName);
            for (Edge edge : edges) {
                if (!(edge.weight >= th & nodes.contains(edge.from) & nodes.contains(edge.to))) continue;
                writerNectar.println(edge);
            }
            writerNectar.close();
        }
        catch (IOException e) {
            throw new IOException("Problems writing file for nectar. Exception :" + e.getMessage());
        }
        return pathToFileForNecter;
    }

    private static void deleteFilesWithException(File[] filesToDeleter, File filetoKeep) {
        File[] fileArray = filesToDeleter;
        int n = filesToDeleter.length;
        int n2 = 0;
        while (n2 < n) {
            File toDelete = fileArray[n2];
            if (!toDelete.equals(filetoKeep)) {
                toDelete.delete();
            }
            ++n2;
        }
    }

    private static boolean fileHasMoreThanNLines(File nectarOutput, int i) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(nectarOutput));
        int lines = 0;
        while (reader.readLine() != null) {
            if (++lines <= i) continue;
            reader.close();
            return true;
        }
        reader.close();
        return false;
    }

    public static boolean ShouldUseModularity(CommId comm, boolean useModularityAsDefaultMetric) throws Exception {
        String pathToFileForNecter = comm.edgesFileName;
        int N = comm.GetNodes().size();
        int E = comm.GetEdges().size();
        if (E > N * 25) {
            return useModularityAsDefaultMetric;
        }
        return RunNectar.ShouldUseModularity((String)pathToFileForNecter);
    }
}

