/*
 * Decompiled with CFR 0.152.
 */
package netStruct_Hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import netStruct_Hierarchy.CommAnalyzer;
import netStruct_Hierarchy.CommId;
import org.apache.commons.math3.stat.inference.ChiSquareTest;

public class MergeComms {
    public static Map<CommId, Map<String, Integer>> MergeCommsByPVal(CommId root, Map<CommId, Map<String, Integer>> mapCommToMapCodeToCount, double pVal) {
        HashMap<CommId, Map<String, Integer>> ans = new HashMap<CommId, Map<String, Integer>>();
        ArrayList commsToInspectCurrentLevel = new ArrayList();
        ArrayList<? extends CommId> commsToInspectNextLevel = new ArrayList<CommId>();
        commsToInspectNextLevel.add(root);
        while (!commsToInspectNextLevel.isEmpty()) {
            commsToInspectCurrentLevel = new ArrayList();
            commsToInspectCurrentLevel.addAll(commsToInspectNextLevel);
            for (CommId comm : commsToInspectCurrentLevel) {
                ans.put(comm, mapCommToMapCodeToCount.get(comm));
            }
            commsToInspectNextLevel = new ArrayList();
            for (CommId commToInspect : commsToInspectCurrentLevel) {
                commsToInspectNextLevel.addAll(MergeComms.MergeChildrensOfComm(commToInspect, mapCommToMapCodeToCount, pVal));
            }
        }
        return ans;
    }

    private static Collection<? extends CommId> MergeChildrensOfComm(CommId commToInspect, Map<CommId, Map<String, Integer>> mapCommToMapCodeToCount, double pVal) {
        ArrayList<CommId> ans = new ArrayList<CommId>();
        List<CommId> newChildComms = commToInspect.childComms;
        ArrayList<CommId> childsToScan = new ArrayList<CommId>();
        while (!newChildComms.isEmpty()) {
            childsToScan = new ArrayList();
            childsToScan.addAll(newChildComms);
            newChildComms = new ArrayList<CommId>();
            for (CommId child : childsToScan) {
                if (MergeComms.ShouldMergeComms(commToInspect, child, mapCommToMapCodeToCount, pVal)) {
                    commToInspect.childComms.remove(child);
                    for (CommId grandson : child.childComms) {
                        grandson.parentComm = commToInspect;
                    }
                    commToInspect.childComms.addAll(child.childComms);
                    newChildComms.addAll(child.childComms);
                    continue;
                }
                ans.add(child);
            }
        }
        return ans;
    }

    private static boolean ShouldMergeComms(CommId commToInspect, CommId child, Map<CommId, Map<String, Integer>> mapCommToMapCodeToCount, double pVal) {
        Map<String, Integer> childMapCodeToCount;
        long[] childCounts;
        Map<String, Integer> parentMapCodeToCount = mapCommToMapCodeToCount.get(commToInspect);
        long[] parentCounts = MergeComms.getCountsFromMap(parentMapCodeToCount);
        return MergeComms.calcPVal(parentCounts, childCounts = MergeComms.getCountsFromMap(childMapCodeToCount = mapCommToMapCodeToCount.get(child))) > pVal;
    }

    private static long[] getCountsFromMap(Map<String, Integer> mapCodeToCount) {
        long[] ans = new long[CommAnalyzer.amountOfSampleSites];
        String[][] codes = CommAnalyzer.samplesSites;
        int counter = -1;
        String[][] stringArray = codes;
        int n = codes.length;
        int n2 = 0;
        while (n2 < n) {
            String[] area;
            String[] stringArray2 = area = stringArray[n2];
            int n3 = area.length;
            int n4 = 0;
            while (n4 < n3) {
                String code = stringArray2[n4];
                Integer count = mapCodeToCount.get(code);
                ans[++counter] = count == null ? 0L : (long)count.intValue();
                ++n4;
            }
            ++n2;
        }
        return ans;
    }

    public static double calcPVal(long[] parentCounts, long[] childCounts) {
        ArrayList<Integer> nonZeroIndexs = new ArrayList<Integer>();
        int i = 0;
        while (i < parentCounts.length) {
            if (parentCounts[i] > 0L) {
                nonZeroIndexs.add(new Integer(i));
            }
            ++i;
        }
        long[] newParentCounts = new long[nonZeroIndexs.size()];
        long[] newChildCounts = new long[nonZeroIndexs.size()];
        int counter = 0;
        for (Integer nonZeroI : nonZeroIndexs) {
            newParentCounts[counter] = parentCounts[nonZeroI];
            newChildCounts[counter] = childCounts[nonZeroI];
            ++counter;
        }
        return MergeComms.chiTestWrapper(newParentCounts, newChildCounts);
    }

    private static double chiTestWrapper(long[] observed1, long[] observed2) {
        if (observed1.length == 1) {
            return 1.0;
        }
        ChiSquareTest chiSquareTest = new ChiSquareTest();
        return chiSquareTest.chiSquareTestDataSetsComparison(observed1, observed2);
    }

    public static void chiTestCheck() {
        long[] expected = new long[]{8L, 8L};
        long[] lArray = new long[2];
        lArray[0] = 8L;
        long[] observed = lArray;
        System.out.println(MergeComms.chiTestWrapper(expected, observed));
    }
}

