/*
 * Decompiled with CFR 0.152.
 */
package netStruct_Hierarchy;

import netStruct_Hierarchy.Common;
import netStruct_Hierarchy.SampleSite;

public class Individual {
    public final int id;
    public final SampleSite sampleSite;
    public String pathFromRoot;

    public Individual(int id, SampleSite sampleSite) {
        this.id = id;
        this.sampleSite = sampleSite;
        this.pathFromRoot = "";
    }

    public double calcF1Score(Individual other) {
        int maxLength = Math.max(this.pathFromRoot.length(), other.pathFromRoot.length());
        int minLength = Math.max(1, Math.min(this.pathFromRoot.length(), other.pathFromRoot.length()));
        int greatestCommonPrefixLength = Common.greatestCommonPrefix(this.pathFromRoot, other.pathFromRoot).length();
        double p = (double)greatestCommonPrefixLength / (double)maxLength;
        double r = (double)greatestCommonPrefixLength / (double)minLength;
        return 2.0 * p * r / (p + r);
    }

    public String toString() {
        return String.valueOf(this.id) + ", sampleSite " + this.sampleSite.code;
    }
}

