/*
 * Decompiled with CFR 0.152.
 */
package netStruct_Hierarchy;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;

public class Common {
    public static void writeToFile(String fileName, String str) throws IOException {
        File file = new File(fileName);
        file.getParentFile().mkdirs();
        FileWriter writer = new FileWriter(file);
        writer.write(str);
        writer.close();
    }

    public static String greatestCommonPrefix(String a, String b) {
        int minLength = Math.min(a.length(), b.length());
        int i = 0;
        while (i < minLength) {
            if (a.charAt(i) != b.charAt(i)) {
                return a.substring(0, i);
            }
            ++i;
        }
        return a.substring(0, minLength);
    }

    public static String getDate() {
        Date now = new Date();
        SimpleDateFormat dateFormatter = new SimpleDateFormat("hh-mm_dd-MM-y");
        return dateFormatter.format(now);
    }

    public static void writeToLog(String pathToLog, String msg, boolean debug) throws IOException {
        String msgWithTime = String.valueOf(Common.getDate()) + " : " + msg;
        System.out.println(msgWithTime);
        if (!debug) {
            Path path = Paths.get(pathToLog, new String[0]);
            Files.write(path, Arrays.asList(msgWithTime), StandardCharsets.UTF_8, Files.exists(path, new LinkOption[0]) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);
        }
    }

    public static void renameFile(String pathToFile) throws Exception {
        String newName = String.valueOf(pathToFile) + "renamed.txt";
        if (newName.length() > 260) {
            throw new Exception("File path is too long, max is 260, got " + newName.length() + ". Path: " + newName);
        }
        if (!new File(pathToFile).renameTo(new File(newName))) {
            Common.renameFile(newName);
            Common.renameFile(pathToFile);
        }
    }

    public static int numOfLinesInFile(String pathToFile) throws IOException {
        File f = new File(pathToFile);
        BufferedReader reader = new BufferedReader(new FileReader(f));
        int lines = 0;
        while (reader.readLine() != null) {
            ++lines;
        }
        reader.close();
        return lines;
    }
}

