/*
 * Decompiled with CFR 0.152.
 */
package netStruct_Hierarchy;

import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import netStruct_Hierarchy.Edge;
import netStruct_Hierarchy.TextConvertor;

public class CommId {
    public String pathToWorkingDir;
    public int level;
    public int entry;
    public int line;
    public double th;
    public CommId parentComm;
    public List<CommId> childComms;
    public String metricUsed;
    public String edgesFileName;
    public String commsFileName;
    public Map<CommId, Double> leafs;
    public String leafsVectorAsString;
    public boolean leafPopulated = false;
    private int size;

    public CommId(String pathToWorkingDir, int level, int entry, int line, double th, CommId parentComm) throws IOException {
        this(pathToWorkingDir, level, entry, line);
        this.th = th;
        this.parentComm = parentComm;
        this.size = -1;
        this.edgesFileName = this.generateFileName("E");
        this.commsFileName = this.generateFileName("C");
    }

    public CommId(String pathToWorkingDir, int level, int entry, int line) {
        this.pathToWorkingDir = pathToWorkingDir;
        this.level = level;
        this.entry = entry;
        this.line = line;
        this.metricUsed = "NotSet";
        this.childComms = new ArrayList<CommId>();
        this.edgesFileName = this.generateFileName("E");
        this.commsFileName = this.generateFileName("C");
        this.leafs = new HashMap<CommId, Double>();
        this.size = -1;
    }

    public int Size() throws IOException {
        if (this.size == -1) {
            this.size = this.GetNodes().size();
        }
        return this.size;
    }

    private String generateFileName(String type) {
        if (this.parentComm == null) {
            return String.valueOf(this.pathToWorkingDir) + "Le_" + this.level + "_En_" + this.entry + "_TH_" + String.format("%1$,.7f", this.th) + "_" + type + ".txt";
        }
        return String.valueOf(this.pathToWorkingDir) + "Le_" + this.level + "_En_" + this.entry + "_PaLe_" + this.parentComm.level + "_PaEn_" + this.parentComm.entry + "_PaLi_" + this.parentComm.line + "_TH_" + String.format("%1$,.7f", this.th) + "_" + type + ".txt";
    }

    public Set<Integer> GetNodes() throws IOException {
        return TextConvertor.getListOfNodes(this.commsFileName, this.line);
    }

    public Set<Edge> GetEdges() throws IOException {
        return TextConvertor.getListOfEdges(this.edgesFileName);
    }

    public void PopulateLeafMap(int minSizeOfCommToOutput, boolean useLeafSizesForStructure, boolean useProportionalTreeSplitForStructure) throws IOException {
        if (useLeafSizesForStructure) {
            this.PopulateLeafMapByLeafSize(minSizeOfCommToOutput);
        } else {
            this.PopulateLeafMapByTreeSplit(minSizeOfCommToOutput, useProportionalTreeSplitForStructure);
        }
    }

    private void PopulateLeafMapByLeafSize(int minSizeOfCommToOutput) throws IOException {
        if (this.leafPopulated) {
            return;
        }
        this.leafPopulated = true;
        if (this.IsLeaf(minSizeOfCommToOutput)) {
            if (this.Size() >= minSizeOfCommToOutput) {
                this.leafs.put(this, Double.valueOf(this.GetNodes().size()));
            }
        } else {
            for (CommId child : this.childComms) {
                child.PopulateLeafMapByLeafSize(minSizeOfCommToOutput);
                Map<CommId, Double> childLeafs = child.leafs;
                this.leafs.putAll(childLeafs);
            }
        }
    }

    private void PopulateLeafMapByTreeSplit(int minSizeOfCommToOutput, boolean useProportionalTreeSplitForStructure) throws IOException {
        block7: {
            block6: {
                if (this.leafPopulated) {
                    return;
                }
                this.leafPopulated = true;
                if (!this.IsLeaf(minSizeOfCommToOutput)) break block6;
                if (this.Size() < minSizeOfCommToOutput) break block7;
                this.leafs.put(this, 10000.0);
                break block7;
            }
            for (CommId child : this.childComms) {
                child.PopulateLeafMapByTreeSplit(minSizeOfCommToOutput, useProportionalTreeSplitForStructure);
                Map<CommId, Double> childLeafs = child.leafs;
                this.leafs.putAll(childLeafs);
            }
            if (useProportionalTreeSplitForStructure) {
                int numOfChilds = this.childComms.size();
                for (Map.Entry<CommId, Double> leafAndSize : this.leafs.entrySet()) {
                    this.leafs.put(leafAndSize.getKey(), leafAndSize.getValue() / (double)numOfChilds);
                }
            } else {
                int numOfLeafsInSubTree = this.leafs.size();
                for (Map.Entry<CommId, Double> leafAndSize : this.leafs.entrySet()) {
                    this.leafs.put(leafAndSize.getKey(), 1.0 / (double)numOfLeafsInSubTree);
                }
            }
        }
    }

    public boolean IsLeaf(int minSizeOfCommToOutput) throws IOException {
        int numOfBigEnoughChilds = this.childComms.size();
        if (numOfBigEnoughChilds == 0) {
            return true;
        }
        for (CommId child : this.childComms) {
            if (child.Size() >= minSizeOfCommToOutput) continue;
            --numOfBigEnoughChilds;
        }
        return numOfBigEnoughChilds == 0;
    }

    public String toString() {
        DecimalFormat df = new DecimalFormat("#.#####");
        if (this.parentComm == null) {
            return "Level_" + this.level + "_Entry_" + this.entry + "_Line_" + this.line + "_TH_" + df.format(this.th) + "_" + this.metricUsed + "_";
        }
        return "Level_" + this.level + "_Entry_" + this.entry + "_Line_" + this.line + "_ParentLevel_" + this.parentComm.level + "_ParentEntry_" + this.parentComm.entry + "_ParentLine_" + this.parentComm.line + "_TH_" + df.format(this.th) + "_" + this.metricUsed + "_";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommId)) {
            return false;
        }
        CommId other = (CommId)o;
        return other.level == this.level && other.entry == this.entry && other.line == this.line;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.level;
        result = 31 * result + this.entry;
        result = 31 * result + this.line;
        return result;
    }

    public void SetLeafsVectorAsString(List<CommId> sortedAllLeafs) {
        this.leafsVectorAsString = "";
        Double[] v = new Double[sortedAllLeafs.size()];
        int index = 0;
        double sum = 0.0;
        for (CommId comm : sortedAllLeafs) {
            Double val = this.leafs.get(comm);
            v[index] = val == null ? 0.0 : val;
            ++index;
            sum += val == null ? 0.0 : val;
        }
        int a = 0;
        while (a < v.length) {
            this.leafsVectorAsString = String.valueOf(this.leafsVectorAsString) + v[a] / sum + ',';
            ++a;
        }
        if (this.leafsVectorAsString.length() > 0) {
            this.leafsVectorAsString = this.leafsVectorAsString.substring(0, this.leafsVectorAsString.length() - 1);
        }
    }

    public void resetLeafMap() {
        this.leafPopulated = false;
        this.leafs = new HashMap<CommId, Double>();
        for (CommId child : this.childComms) {
            child.resetLeafMap();
        }
    }
}

