/*
 * Decompiled with CFR 0.152.
 */
package netStruct_Hierarchy;

import java.util.LinkedList;
import java.util.List;
import netStruct_Hierarchy.CommAnalyzer;
import netStruct_Hierarchy.CommId;
import netStruct_Hierarchy.Common;
import netStruct_Hierarchy.NectarIntegration;

public class CommBraker {
    public static List<CommId> brakeRec(String pathToWorkingDir, List<CommId> commsInCurrentLevel, double minThresholdToUse, double stepSize, double maxThresholdToUse, int minSizeOfCommToBrake, String beta, String pathToLog, CommAnalyzer commAnalyzer, String pathToCommAnalysisFile, boolean dynamicChoose, boolean useModularityAsDefaultMetric, int maxLevels, int nectarVerboseLevel, boolean useWeighted) throws Exception {
        LinkedList<CommId> ans = new LinkedList<CommId>();
        if (commsInCurrentLevel.size() == 0 || maxLevels == 0) {
            return ans;
        }
        Common.writeToLog(pathToLog, "Level " + commsInCurrentLevel.get((int)0).level + " has " + commsInCurrentLevel.size() + " comms." + "\n", true);
        LinkedList<CommId> commsInNextLevel = new LinkedList<CommId>();
        int entry = 0;
        for (CommId comm : commsInCurrentLevel) {
            if (comm == null) continue;
            boolean shouldUseModularity = dynamicChoose ? NectarIntegration.ShouldUseModularity(comm, useModularityAsDefaultMetric) : useModularityAsDefaultMetric;
            comm.metricUsed = shouldUseModularity ? "Modularity" : "WOCC";
            List<CommId> commsCreated = CommBraker.brakeSingleComm(shouldUseModularity, pathToWorkingDir, comm, entry, minThresholdToUse, stepSize, maxThresholdToUse, minSizeOfCommToBrake, beta, nectarVerboseLevel, useWeighted);
            comm.childComms.addAll(commsCreated);
            commsInNextLevel.addAll(commsCreated);
            ans.addAll(commsCreated);
            ++entry;
        }
        commAnalyzer.WriteCommAnalysisToFile(commsInCurrentLevel, pathToCommAnalysisFile);
        ans.addAll(CommBraker.brakeRec(pathToWorkingDir, commsInNextLevel, minThresholdToUse, stepSize, maxThresholdToUse, minSizeOfCommToBrake, beta, pathToLog, commAnalyzer, pathToCommAnalysisFile, dynamicChoose, useModularityAsDefaultMetric, maxLevels - 1, nectarVerboseLevel, useWeighted));
        return ans;
    }

    private static List<CommId> brakeSingleComm(Boolean shouldUseModularity, String pathToWorkingDir, CommId parentComm, int entry, double minThresholdToUse, double stepSize, double maxThresholdToUse, int minSizeOfCommToBrake, String beta, int nectarVerboseLevel, boolean useWeighted) throws Exception {
        CommId commGenerated = NectarIntegration.findNextThreshold(shouldUseModularity, pathToWorkingDir, parentComm, entry, minThresholdToUse, stepSize, maxThresholdToUse, minSizeOfCommToBrake, beta, nectarVerboseLevel, useWeighted);
        LinkedList<CommId> CommsToBrake = new LinkedList<CommId>();
        if (commGenerated != null) {
            int numOfLines = Common.numOfLinesInFile(commGenerated.commsFileName);
            int line = 0;
            while (line < numOfLines) {
                CommsToBrake.add(new CommId(commGenerated.pathToWorkingDir, commGenerated.level, commGenerated.entry, line, commGenerated.th, commGenerated.parentComm));
                ++line;
            }
        }
        return CommsToBrake;
    }
}

