/*
 * Decompiled with CFR 0.152.
 */
package netStruct_Hierarchy;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.InputMismatchException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import netStruct_Hierarchy.CommId;
import netStruct_Hierarchy.Individual;
import netStruct_Hierarchy.SampleSite;
import netStruct_Hierarchy.TextConvertor;

public class CommAnalyzer {
    public Map<Integer, String> mapNode2SampleSite;
    public int minSizeOfCommToOutput;
    public Map<Integer, CommId> mapNode2CommID;
    public Map<Integer, Set<Integer>> mapLeaf2NodesNoOverlap;
    public Map<Integer, Set<Integer>> mapLeaf2NodesWithOverlap;
    public Map<Integer, Set<Integer>> mapNode2LeafsInSubTree;
    public Set<Integer> droppedIndividuals;
    public Set<Integer> individulasToExclude;
    public static String[][] samplesSites;
    private static Set<String> samplesSitesSet;
    public static int amountOfSampleSites;

    public CommAnalyzer(String pathToMapNode2SampleSite, String pathToSampleSites, int minSizeOfCommToOutput, Set<Integer> individulasToExclude) throws IOException {
        this.individulasToExclude = individulasToExclude;
        this.InitSamplesSitesList(pathToSampleSites);
        this.mapNode2SampleSite = TextConvertor.getMapNode2SampleSite(pathToMapNode2SampleSite, individulasToExclude);
        this.VerifySampleSitesList();
        this.minSizeOfCommToOutput = minSizeOfCommToOutput;
        this.mapNode2CommID = new HashMap<Integer, CommId>();
    }

    private void VerifySampleSitesList() {
        for (Map.Entry<Integer, String> entry : this.mapNode2SampleSite.entrySet()) {
            if (samplesSitesSet.contains(entry.getValue())) continue;
            throw new InputMismatchException(" Not all sample sites are listed in the sampleSitesFile. SampleSite " + entry.getValue() + " is missing. It is assigned to individual id " + entry.getKey());
        }
    }

    private void InitSamplesSitesList(String pathToSampleSites) throws IOException {
        samplesSitesSet = new HashSet<String>();
        samplesSites = TextConvertor.getSampleSites(pathToSampleSites);
        amountOfSampleSites = 0;
        String[][] stringArray = samplesSites;
        int n = samplesSites.length;
        int n2 = 0;
        while (n2 < n) {
            String[] sampleSiteArea;
            String[] stringArray2 = sampleSiteArea = stringArray[n2];
            int n3 = sampleSiteArea.length;
            int n4 = 0;
            while (n4 < n3) {
                String sampleSite = stringArray2[n4];
                ++amountOfSampleSites;
                samplesSitesSet.add(sampleSite);
                ++n4;
            }
            ++n2;
        }
        if (amountOfSampleSites != samplesSitesSet.size()) {
            throw new InputMismatchException(" Sample sites must all be unique names. Please verify - " + pathToSampleSites);
        }
    }

    public Map<String, Integer> perSampleSiteCounts(CommId commId) throws IOException {
        HashMap<String, Integer> ans = new HashMap<String, Integer>();
        String[][] stringArray = samplesSites;
        int n = samplesSites.length;
        int n2 = 0;
        while (n2 < n) {
            String[] sampleSitesArea;
            String[] stringArray2 = sampleSitesArea = stringArray[n2];
            int n3 = sampleSitesArea.length;
            int n4 = 0;
            while (n4 < n3) {
                String sampleSite = stringArray2[n4];
                ans.put(sampleSite, 0);
                ++n4;
            }
            ++n2;
        }
        Set<Integer> nodes = commId.GetNodes();
        for (Integer node : nodes) {
            String sampleSite = this.mapNode2SampleSite.get(node);
            ans.put(sampleSite, (Integer)ans.get(sampleSite) + 1);
        }
        return ans;
    }

    public void WriteCommAnalysisToFile(List<CommId> comms, String pathS) throws IOException {
        HashMap<CommId, Map<String, Integer>> mapCommToMapSampleSiteToCount = new HashMap<CommId, Map<String, Integer>>();
        for (CommId commId : comms) {
            Map<String, Integer> mapSampleSiteToCount = this.perSampleSiteCounts(commId);
            mapCommToMapSampleSiteToCount.put(commId, mapSampleSiteToCount);
        }
        this.WriteCommAnalysisToFile(mapCommToMapSampleSiteToCount, pathS);
    }

    public void WriteCommAnalysisToFile(Map<CommId, Map<String, Integer>> mapCommToMapSampleSiteToCount, String pathS) throws IOException {
        Path path = Paths.get(pathS, new String[0]);
        int prevLevel = -1;
        List<CommId> comms = this.SortCommsByLevelAndEntry(mapCommToMapSampleSiteToCount.keySet());
        for (CommId commId : comms) {
            Map<String, Integer> mapSampleSiteToCount = mapCommToMapSampleSiteToCount.get(commId);
            String commLine = "";
            int commSize = this.SumAmountOfNodes(mapSampleSiteToCount);
            if (commSize < this.minSizeOfCommToOutput) continue;
            int commLevel = commId.level;
            if (commLevel > prevLevel) {
                Files.write(path, Arrays.asList(" ----------- LEVEL " + commLevel + " ----------- "), StandardCharsets.UTF_8, Files.exists(path, new LinkOption[0]) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);
                prevLevel = commLevel;
            }
            commLine = String.valueOf(commLine) + "Size_" + String.format("%04d", commSize) + "_" + commId.toString() + "\t";
            String[][] stringArray = samplesSites;
            int n = samplesSites.length;
            int n2 = 0;
            while (n2 < n) {
                String[] sampleSitesArea = stringArray[n2];
                commLine = String.valueOf(commLine) + "|";
                String[] stringArray2 = sampleSitesArea;
                int n3 = sampleSitesArea.length;
                int n4 = 0;
                while (n4 < n3) {
                    String sampleSite = stringArray2[n4];
                    commLine = String.valueOf(commLine) + sampleSite + ":" + mapSampleSiteToCount.get(sampleSite) + "\t";
                    ++n4;
                }
                ++n2;
            }
            Files.write(path, Arrays.asList(commLine), StandardCharsets.UTF_8, StandardOpenOption.APPEND);
        }
    }

    private int SumAmountOfNodes(Map<String, Integer> map) {
        int sum = 0;
        for (int f : map.values()) {
            sum += f;
        }
        return sum;
    }

    private List<CommId> SortCommsByLevelAndEntry(Set<CommId> keySet) {
        ArrayList<CommId> ans = new ArrayList<CommId>(keySet);
        Collections.sort(ans, new CommIdComperator());
        return ans;
    }

    public Map<CommId, Map<String, Integer>> commsToMapSampleSiteToCount(List<CommId> comms) throws IOException {
        HashMap<CommId, Map<String, Integer>> ans = new HashMap<CommId, Map<String, Integer>>();
        for (CommId comm : comms) {
            ans.put(comm, this.perSampleSiteCounts(comm));
        }
        return ans;
    }

    public Map<String, SampleSite> InitSampleSites() {
        HashMap<String, SampleSite> sampleSites = new HashMap<String, SampleSite>();
        String[][] stringArray = samplesSites;
        int n = samplesSites.length;
        int n2 = 0;
        while (n2 < n) {
            String[] sampleSitesInArea;
            String[] stringArray2 = sampleSitesInArea = stringArray[n2];
            int n3 = sampleSitesInArea.length;
            int n4 = 0;
            while (n4 < n3) {
                String sampleSite = stringArray2[n4];
                sampleSites.put(sampleSite, new SampleSite(sampleSite));
                ++n4;
            }
            ++n2;
        }
        for (Map.Entry<Integer, String> IdSampleSite : this.mapNode2SampleSite.entrySet()) {
            SampleSite sampleSite = (SampleSite)sampleSites.get(IdSampleSite.getValue());
            Integer id = IdSampleSite.getKey();
            sampleSite.members.put(id, new Individual(id, sampleSite));
        }
        return sampleSites;
    }

    public void SetPathFromRootToAll(Map<String, SampleSite> sampleSites, Set<CommId> comms) throws IOException {
        List<CommId> sortedComms = this.SortCommsByLevelAndEntry(comms);
        int previousLevel = -1;
        for (CommId comm : sortedComms) {
            if (comm.level < previousLevel) {
                throw new RuntimeException("sortedComms is not sorted!");
            }
            this.UpdatePathFromRoot(comm, sampleSites);
        }
    }

    private void UpdatePathFromRoot(CommId comm, Map<String, SampleSite> sampleSites) throws IOException {
        String levelEntry = " " + comm.level + "-" + comm.entry + "-" + comm.line;
        for (Integer personId : comm.GetNodes()) {
            String newPathFromRoot;
            String sampleSiteS = this.mapNode2SampleSite.get(personId);
            SampleSite sampleSite = sampleSites.get(sampleSiteS);
            sampleSite.members.get((Object)personId).pathFromRoot = newPathFromRoot = String.valueOf(sampleSite.members.get((Object)personId).pathFromRoot) + levelEntry;
        }
    }

    public void WriteF1ScoreMatrixToFile(Map<String, Map<String, Double>> f1ScoreMatrix, String pathToF1ScoreMatrixFile) throws IOException {
        Path path = Paths.get(pathToF1ScoreMatrixFile, new String[0]);
        String[][] stringArray = samplesSites;
        int n = samplesSites.length;
        int n2 = 0;
        while (n2 < n) {
            String[] sampleSitesInArea1;
            String[] stringArray2 = sampleSitesInArea1 = stringArray[n2];
            int n3 = sampleSitesInArea1.length;
            int n4 = 0;
            while (n4 < n3) {
                String sampleSite1 = stringArray2[n4];
                Map<String, Double> map1 = f1ScoreMatrix.get(sampleSite1);
                String[][] stringArray3 = samplesSites;
                int n5 = samplesSites.length;
                int n6 = 0;
                while (n6 < n5) {
                    String[] sampleSitesInArea2;
                    String[] stringArray4 = sampleSitesInArea2 = stringArray3[n6];
                    int n7 = sampleSitesInArea2.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        String sampleSite2 = stringArray4[n8];
                        if (sampleSite1.compareTo(sampleSite2) < 0) {
                            String commLine = String.valueOf(sampleSite1) + " " + sampleSite2 + " " + map1.get(sampleSite2);
                            Files.write(path, Arrays.asList(commLine), StandardCharsets.UTF_8, Files.exists(path, new LinkOption[0]) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);
                        }
                        ++n8;
                    }
                    ++n6;
                }
                ++n4;
            }
            ++n2;
        }
    }

    public Map<String, Map<String, Double>> CalcF1ScoresMatrix(Map<String, SampleSite> sampleSites) {
        Map<String, Map<String, Double>> f1ScoresMatrix = this.InitF1ScoresMatrix();
        for (String sampleSiteS1 : sampleSites.keySet()) {
            for (String sampleSiteS2 : sampleSites.keySet()) {
                if (sampleSiteS1.compareTo(sampleSiteS2) >= 0) continue;
                double f1Score = sampleSites.get(sampleSiteS1).calcF1Score(sampleSites.get(sampleSiteS2));
                f1ScoresMatrix.get(sampleSiteS1).put(sampleSiteS2, f1Score);
            }
        }
        return f1ScoresMatrix;
    }

    private Map<String, Map<String, Double>> InitF1ScoresMatrix() {
        HashMap<String, Map<String, Double>> f1ScoresMatrix = new HashMap<String, Map<String, Double>>();
        String[][] stringArray = samplesSites;
        int n = samplesSites.length;
        int n2 = 0;
        while (n2 < n) {
            String[] sampleSitesInArea;
            String[] stringArray2 = sampleSitesInArea = stringArray[n2];
            int n3 = sampleSitesInArea.length;
            int n4 = 0;
            while (n4 < n3) {
                String sampleSite = stringArray2[n4];
                f1ScoresMatrix.put(sampleSite, this.GenerateSampleSitesMap());
                ++n4;
            }
            ++n2;
        }
        return f1ScoresMatrix;
    }

    private Map<String, Double> GenerateSampleSitesMap() {
        HashMap<String, Double> sampleSitesMap = new HashMap<String, Double>();
        String[][] stringArray = samplesSites;
        int n = samplesSites.length;
        int n2 = 0;
        while (n2 < n) {
            String[] sampleSitesInArea;
            String[] stringArray2 = sampleSitesInArea = stringArray[n2];
            int n3 = sampleSitesInArea.length;
            int n4 = 0;
            while (n4 < n3) {
                String sampleSite = stringArray2[n4];
                sampleSitesMap.put(sampleSite, 0.0);
                ++n4;
            }
            ++n2;
        }
        return sampleSitesMap;
    }

    private void SetCommIdsForNodes(Set<CommId> comms) throws IOException {
        List<CommId> sortedComms = this.SortCommsByLevelAndEntry(comms);
        for (CommId comm : sortedComms) {
            if (comm.Size() < this.minSizeOfCommToOutput) continue;
            this.SetSingleCommIdForNodes(comm);
        }
    }

    private void SetSingleCommIdForNodes(CommId commId) throws IOException {
        Set<Integer> nodes = commId.GetNodes();
        for (Integer node : nodes) {
            this.mapNode2CommID.put(node, commId);
        }
    }

    public void WriteStructureOutputToFile(CommId rootComm, Set<CommId> comms, String pathToStructureFile, int minSizeOfCommToOutput, boolean useLeafSizesForStructure, boolean useProportionalTreeSplitsForStructure) throws IOException {
        Path path = pathToStructureFile == "" ? null : Paths.get(pathToStructureFile, new String[0]);
        rootComm.resetLeafMap();
        rootComm.PopulateLeafMap(minSizeOfCommToOutput, useLeafSizesForStructure, useProportionalTreeSplitsForStructure);
        this.SetLeafsVectorAsString(rootComm, comms);
        this.SetCommIdsForNodes(comms);
        if (path != null) {
            for (Map.Entry<Integer, CommId> nodeCommId : this.mapNode2CommID.entrySet()) {
                Integer node = nodeCommId.getKey();
                CommId commId = nodeCommId.getValue();
                String sampleSite = this.mapNode2SampleSite.get(node);
                String leafsVectorAsString = commId.leafsVectorAsString;
                String line = String.valueOf(sampleSite) + " " + node + " " + leafsVectorAsString;
                Files.write(path, Arrays.asList(line), StandardCharsets.UTF_8, Files.exists(path, new LinkOption[0]) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);
            }
        }
    }

    private void SetLeafsVectorAsString(CommId rootComm, Set<CommId> comms) {
        Set<CommId> allLeafs = rootComm.leafs.keySet();
        List<CommId> sortedAllLeafs = this.SortCommsByLevelAndEntry(allLeafs);
        for (CommId comm : comms) {
            comm.SetLeafsVectorAsString(sortedAllLeafs);
        }
    }

    public List<CommId> getCommsFromFiles(String pathToWorkingDir, String pathToCommAnalysisFile, CommId rootComm) throws IOException {
        ArrayList<CommId> comms = new ArrayList<CommId>();
        comms.add(rootComm);
        List<String> lines = Files.readAllLines(Paths.get(pathToCommAnalysisFile, new String[0]));
        for (String lineInFile : lines) {
            String[] parts;
            int level;
            if (lineInFile.contains("---") || (level = Integer.parseInt((parts = lineInFile.split("_"))[3])) == 0) continue;
            int entry = Integer.parseInt(parts[5]);
            int line = Integer.parseInt(parts[7]);
            int parentLevel = Integer.parseInt(parts[9]);
            int parentEntry = Integer.parseInt(parts[11]);
            int parentLine = Integer.parseInt(parts[13]);
            double th = CommAnalyzer.FindLongThreshold(pathToWorkingDir, level, entry, parentLevel, parentEntry, parentLine);
            CommId parentComm = this.FindComm(comms, parentLevel, parentEntry, parentLine);
            CommId comm = new CommId(pathToWorkingDir, level, entry, line, th, parentComm);
            comms.add(comm);
            parentComm.childComms.add(comm);
        }
        return comms;
    }

    public static double FindLongThreshold(String pathToWorkingDir, int level, int entry, int parentLevel, int parentEntry, int parentLine) {
        File[] fileArray = new File(pathToWorkingDir).listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File fileEntry = fileArray[n2];
            if (fileEntry.getName().contains("Level_" + level + "_Entry_" + entry + "_ParentLevel_" + parentLevel + "_ParentEntry_" + parentEntry + "_ParentLine_" + parentLine)) {
                String[] parts = fileEntry.getName().split("_");
                return Double.parseDouble(parts[parts.length - 2]);
            }
            ++n2;
        }
        return 0.0;
    }

    private CommId FindComm(List<CommId> comms, int level, int entry, int line) {
        for (CommId comm : comms) {
            if (comm.level != level || comm.entry != entry || comm.line != line) continue;
            return comm;
        }
        throw new RuntimeException("Comm not found! Level-" + level + " Entry-" + entry + " Line-" + line);
    }

    public void LeafsAsCommunities() throws IOException {
        this.mapNode2LeafsInSubTree = new HashMap<Integer, Set<Integer>>();
        for (Map.Entry<Integer, CommId> nodeCommId : this.mapNode2CommID.entrySet()) {
            Integer node = nodeCommId.getKey();
            this.mapNode2LeafsInSubTree.put(node, new HashSet());
            CommId commId = nodeCommId.getValue();
            String leafs = commId.leafsVectorAsString;
            String[] leafsStringA = leafs.split(",");
            Set<Integer> leafsInSubTree = this.mapNode2LeafsInSubTree.get(node);
            Integer i = 0;
            while (i < leafsStringA.length) {
                if (!leafsStringA[i].equals("0.0")) {
                    leafsInSubTree.add(i);
                }
                i = i + 1;
            }
        }
        this.mapLeaf2NodesNoOverlap = new HashMap<Integer, Set<Integer>>();
        this.mapLeaf2NodesWithOverlap = new HashMap<Integer, Set<Integer>>();
        this.droppedIndividuals = new HashSet<Integer>();
        for (Integer individual : this.mapNode2LeafsInSubTree.keySet()) {
            Set<Integer> leafsInSubTree = this.mapNode2LeafsInSubTree.get(individual);
            if (this.mapNode2CommID.get(individual).IsLeaf(this.minSizeOfCommToOutput)) {
                Integer leafIndex = (Integer)leafsInSubTree.toArray()[0];
                if (this.mapLeaf2NodesNoOverlap.get(leafIndex) == null) {
                    this.mapLeaf2NodesNoOverlap.put(leafIndex, new HashSet());
                }
                if (this.mapLeaf2NodesWithOverlap.get(leafIndex) == null) {
                    this.mapLeaf2NodesWithOverlap.put(leafIndex, new HashSet());
                }
                this.mapLeaf2NodesNoOverlap.get(leafIndex).add(individual);
                this.mapLeaf2NodesWithOverlap.get(leafIndex).add(individual);
                continue;
            }
            this.droppedIndividuals.add(individual);
            for (Integer leafIndex : this.mapNode2LeafsInSubTree.get(individual)) {
                if (this.mapLeaf2NodesWithOverlap.get(leafIndex) == null) {
                    this.mapLeaf2NodesWithOverlap.put(leafIndex, new HashSet());
                }
                this.mapLeaf2NodesWithOverlap.get(leafIndex).add(individual);
            }
        }
    }

    public void WriteLeafsNoOverlapAsCommunitiesToFile(String pathToLeafsFile) throws IOException {
        String line;
        Path path = Paths.get(pathToLeafsFile, new String[0]);
        for (Set<Integer> individuals : this.mapLeaf2NodesNoOverlap.values()) {
            line = "";
            for (Integer ind : individuals) {
                line = String.valueOf(line) + ind + " ";
            }
            line = line.substring(0, line.length() - 1);
            Files.write(path, Arrays.asList(line), StandardCharsets.UTF_8, Files.exists(path, new LinkOption[0]) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);
        }
        for (Integer ind : this.droppedIndividuals) {
            line = "" + ind;
            Files.write(path, Arrays.asList(line), StandardCharsets.UTF_8, Files.exists(path, new LinkOption[0]) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);
        }
    }

    public void WriteLeafsWithOverlapAsCommunitiesToFile(String pathToLeafsFile) throws IOException {
        Path path = Paths.get(pathToLeafsFile, new String[0]);
        for (Set<Integer> individuals : this.mapLeaf2NodesWithOverlap.values()) {
            String line = "";
            for (Integer ind : individuals) {
                line = String.valueOf(line) + ind + " ";
            }
            line = line.substring(0, line.length() - 1);
            Files.write(path, Arrays.asList(line), StandardCharsets.UTF_8, Files.exists(path, new LinkOption[0]) ? StandardOpenOption.APPEND : StandardOpenOption.CREATE);
        }
    }

    private static class CommIdComperator
    implements Comparator<CommId> {
        private CommIdComperator() {
        }

        @Override
        public int compare(CommId o1, CommId o2) {
            if (o1.level != o2.level) {
                return o1.level - o2.level;
            }
            if (o1.entry != o2.entry) {
                return o1.entry - o2.entry;
            }
            if (o1.line != o2.line) {
                return o1.line - o2.line;
            }
            return 0;
        }
    }
}

