use strict;
use Cwd qw(abs_path getcwd);
use Getopt::Long;
use Data::Dumper;
use File::Basename qw(basename dirname);
use FindBin qw($Bin $Script);

my $programe_dir=basename($0);
my $path=dirname($0);

my $ver    = "1.0";
my $Writer = "Daih <daih\@biomarker.com.cn>";
my $Data   = "2015/11/6";
my $BEGIN=time();
#######################################################################################

# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
my ($id,$cut,$od);
GetOptions(
			"h|?" =>\&help,
			"od:s"=>\$od,
			"id:s"=>\$id,
			"cut:s"=>\$cut,
			) || &help;
&help unless ($id && $cut);

sub help
{
	print <<"	Usage End.";
    Description:
        Writer  : $Writer
        Data    : $Data
        Version : $ver
        function: ......
    Usage:
	perl XXX.pl -id <genepair match file> -cut <gene num for one file> -od <outfile>
	Usage End.
	exit;
}
# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
$od = abs_path ($od);
mkdir $od if (!-d $od);
$id = abs_path($id);
$cut ||= 100;
###############Time
my $Time_Start;
$Time_Start = sub_format_datetime(localtime(time()));
print "\nStart $programe_dir Time :[$Time_Start]\n\n";
################
my %genepair;
open my $IN, "<$id";
while(<$IN>){
	chomp;
	next if(/^#/||/^$/);
	my $id = (split/\t+/)[0];
	push @{$genepair{$id}}, $_;
}

my @aa = sort(keys %genepair);
my $index=0;
LAB:for(my $i=1;;){
	my $num=0;
	open OUT, ">$od/Split_$i.txt" || die $!;
	for($index..$#aa){
		$index++;
		if($num<$cut){
			my $line = join"\n", @{$genepair{$aa[$_]}};
			print OUT "$line\n";
			$num++;
		}
		if($num>=$cut){
			$num=0;
			$i++;
			close OUT;
			if($index==$#aa+1){
				last;
			}else{
				next LAB;
			}
		}
	}
	if($num){
		close OUT;
	}
	last;
}

###############Time
my $Time_End;
$Time_End = sub_format_datetime(localtime(time()));
print "\nEnd $programe_dir Time :[$Time_End]\n\n";
&Runtime($BEGIN);
###############Subs
sub sub_format_datetime #Time calculation subroutine
{
	my($sec, $min, $hour, $day, $mon, $year, $wday, $yday, $isdst) = @_;
	$wday = $yday = $isdst = 0;
	sprintf("%4d-%02d-%02d %02d:%02d:%02d", $year+1900, $mon+1, $day, $hour, $min, $sec);
}

sub Runtime # &Runtime($BEGIN);
{
	my ($t1)=@_;
	my $t=time()-$t1;
	print "Total $programe_dir elapsed time : [",&sub_time($t),"]\n";
}
sub sub_time
{
	my ($T)=@_;chomp $T;
	my $s=0;my $m=0;my $h=0;
	if ($T>=3600) {
		my $h=int ($T/3600);
		my $a=$T%3600;
		if ($a>=60) {
			my $m=int($a/60);
			$s=$a%60;
			$T=$h."h\-".$m."m\-".$s."s";
		}else{
			$T=$h."h-"."0m\-".$a."s";
		}
	}else{
		if ($T>=60) {
			my $m=int($T/60);
			$s=$T%60;
			$T=$m."m\-".$s."s";
		}else{
			$T=$T."s";
		}
	}
	return ($T);
}

sub ABSOLUTE_DIR #$pavfile=&ABSOLUTE_DIR($pavfile);
{
	my $cur_dir=`pwd`;chomp($cur_dir);
	my ($in)=@_;
	my $return="";
	if(-f $in){
		my $dir=dirname($in);
		my $file=basename($in);
		chdir $dir;$dir=`pwd`;chomp $dir;
		$return="$dir/$file";
	}elsif(-d $in){
		chdir $in;$return=`pwd`;chomp $return;
	}else{
		warn "Warning just for file and dir\n";
		exit;
	}
	chdir $cur_dir;
	return $return;
}

