use strict;
use Cwd qw(abs_path getcwd);
use Getopt::Long;
use Data::Dumper;
use File::Basename qw(basename dirname);
use FindBin qw($Bin $Script);

my $programe_dir=basename($0);
my $path=dirname($0);

my $ver    = "1.0";
my $Writer = "Daih <daih\@biomarker.com.cn>";
my $Data   = "2015/11/6";
my $BEGIN=time();
#######################################################################################

# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
my ($tc_reads, $bsb_reads, $sample_file, $od);
GetOptions(
			"h|?" =>\&help,
			"od:s"=>\$od,
			"tc:s"=>\$tc_reads,
			"bsb:s"=>\$bsb_reads,
			"sample:s"=>\$sample_file,
			) || &help;
&help unless ($tc_reads && $bsb_reads && $sample_file && $od);

sub help
{
	print <<"	Usage End.";
    Description:
        Writer  : $Writer
        Data    : $Data
        Version : $ver
        function: ......
    Usage:
	perl XXX.pl -sample <sample file> -tc <tc reads file> -bsb <bsb reads file> -od <outfile>
	Usage End.
	exit;
}
# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
$od = abs_path ($od);
#mkdir $od if (!-d $od);
$sample_file = abs_path($sample_file);
$tc_reads = abs_path($tc_reads);
$bsb_reads = abs_path($bsb_reads);
###############Time
my $Time_Start;
$Time_Start = sub_format_datetime(localtime(time()));
print "\nStart $programe_dir Time :[$Time_Start]\n\n";
################
my %sample_hash;
my %sample;
open my $SA, "<$sample_file";
while(<$SA>){
	chomp;
	next if(/^#/ || /^$/);
	my @aa = split/\t+/;
	$sample_hash{$aa[0]} = $aa[1];
	push @{$sample{$aa[1]}}, $aa[0];
}

my %reads1;
open my $IN1, "<$tc_reads";
while(<$IN1>){
	chomp;
	next if(/^#/ || /^$/);
	my @aa = split/\t+/;
	$reads1{$aa[0]}=$aa[3];
}

my %reads2;
open my $IN2, "<$bsb_reads";
while(<$IN2>){
	chomp;
	next if(/^#/ || /^$/);
	my @aa = split/\t+/;
	$reads2{$aa[0]}=$aa[3];
}

my %read_hash;
for my $group(keys %sample){
	my @spe = @{$sample{$group}};
	for(my $i=0;$i<=$#spe;$i++){
		if(exists $reads1{$spe[$i]}){
			my $count = $reads1{$spe[$i]};
			push @{$read_hash{$group}{tc}}, $count;
		}else{
			print "Error: can not find the count of $spe[$i]\n";
		}
		if(exists $reads2{$spe[$i]}){
			my $count = $reads2{$spe[$i]};
			push @{$read_hash{$group}{bsb}}, $count;
		}else{
			print "Error: can not find the count of $spe[$i]\n";
		}
	}
}

open my $O, ">$od";
print $O "#Species\tTC\tBSB\n";
for my $name(keys %read_hash){
	my $tc_line = join";", @{$read_hash{$name}{tc}};
	my $bsb_line = join";", @{$read_hash{$name}{bsb}};
	print $O "$name\t$tc_line\t$bsb_line\n";
}

###############Time
my $Time_End;
$Time_End = sub_format_datetime(localtime(time()));
print "\nEnd $programe_dir Time :[$Time_End]\n\n";
&Runtime($BEGIN);
###############Subs
sub sub_format_datetime #Time calculation subroutine
{
	my($sec, $min, $hour, $day, $mon, $year, $wday, $yday, $isdst) = @_;
	$wday = $yday = $isdst = 0;
	sprintf("%4d-%02d-%02d %02d:%02d:%02d", $year+1900, $mon+1, $day, $hour, $min, $sec);
}

sub Runtime # &Runtime($BEGIN);
{
	my ($t1)=@_;
	my $t=time()-$t1;
	print "Total $programe_dir elapsed time : [",&sub_time($t),"]\n";
}
sub sub_time
{
	my ($T)=@_;chomp $T;
	my $s=0;my $m=0;my $h=0;
	if ($T>=3600) {
		my $h=int ($T/3600);
		my $a=$T%3600;
		if ($a>=60) {
			my $m=int($a/60);
			$s=$a%60;
			$T=$h."h\-".$m."m\-".$s."s";
		}else{
			$T=$h."h-"."0m\-".$a."s";
		}
	}else{
		if ($T>=60) {
			my $m=int($T/60);
			$s=$T%60;
			$T=$m."m\-".$s."s";
		}else{
			$T=$T."s";
		}
	}
	return ($T);
}

sub ABSOLUTE_DIR #$pavfile=&ABSOLUTE_DIR($pavfile);
{
	my $cur_dir=`pwd`;chomp($cur_dir);
	my ($in)=@_;
	my $return="";
	if(-f $in){
		my $dir=dirname($in);
		my $file=basename($in);
		chdir $dir;$dir=`pwd`;chomp $dir;
		$return="$dir/$file";
	}elsif(-d $in){
		chdir $in;$return=`pwd`;chomp $return;
	}else{
		warn "Warning just for file and dir\n";
		exit;
	}
	chdir $cur_dir;
	return $return;
}

