use strict;
use Cwd qw(abs_path getcwd);
use Getopt::Long;
use Data::Dumper;
use File::Basename qw(basename dirname);
use FindBin qw($Bin $Script);

my $programe_dir=basename($0);
my $path=dirname($0);

my $ver    = "1.0";
my $Writer = "Daih <daih\@biomarker.com.cn>";
my $Data   = "2015/11/6";
my $BEGIN=time();
#######################################################################################

# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
my ($match_file,$tc_gff,$bsb_gff,$od);
GetOptions(
			"h|?" =>\&help,
			"od:s"=>\$od,
			"m:s"=>\$match_file,
			"tc:s"=>\$tc_gff,
			"bsb:s"=>\$bsb_gff,
			) || &help;
&help unless ($match_file && $tc_gff && $bsb_gff && $od);

sub help
{
	print <<"	Usage End.";
    Description:
        Writer  : $Writer
        Data    : $Data
        Version : $ver
        function: ......
    Usage:
	perl XXX.pl -m <gene pair match file> -tc <tc gene gff file> -bsb <bsb gene gff file> -od <outfile>
	Usage End.
	exit;
}
# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
$od = abs_path ($od);
#mkdir $od if (!-d $od);
$match_file = abs_path($match_file);
$tc_gff = abs_path($tc_gff);
$bsb_gff = abs_path($bsb_gff);
###############Time
my $Time_Start;
$Time_Start = sub_format_datetime(localtime(time()));
print "\nStart $programe_dir Time :[$Time_Start]\n\n";
################
my %tc = ReadGff(%tc_gff);
my %bsb = ReadGff(%bsb_gff);
open my $IN, "<$match_file";
open my $O, ">$od";
while(<$IN>){
	chomp;
	my @items = split/\t+/;
	my(@tc_pos) = Changing($items[1],$items[2],\%tc);
	my(@bsb_pos) = Changing($item[4],$items[5],\%bsb);
}

sub Changing{
	my($beg, $end, $hash) = @_;
	my %hash = %{$hash};
	
}

sub ReadGff{
	my $file = shift;
	my %hash;
	open my $IN, "<$file";
	while(<$IN>){
		chomp;
		next unless(/\tCDS\t/);
		my @aa = split/\t+/;
		my ($id) = $_ =~ /Parent=(\w+?);/;
		push @{$hash{$id}},[$aa[0], $aa[3], $aa[4], $aa[6]];
	}
	return(%hash);
}

###############Time
my $Time_End;
$Time_End = sub_format_datetime(localtime(time()));
print "\nEnd $programe_dir Time :[$Time_End]\n\n";
&Runtime($BEGIN);
###############Subs
sub sub_format_datetime #Time calculation subroutine
{
	my($sec, $min, $hour, $day, $mon, $year, $wday, $yday, $isdst) = @_;
	$wday = $yday = $isdst = 0;
	sprintf("%4d-%02d-%02d %02d:%02d:%02d", $year+1900, $mon+1, $day, $hour, $min, $sec);
}

sub Runtime # &Runtime($BEGIN);
{
	my ($t1)=@_;
	my $t=time()-$t1;
	print "Total $programe_dir elapsed time : [",&sub_time($t),"]\n";
}
sub sub_time
{
	my ($T)=@_;chomp $T;
	my $s=0;my $m=0;my $h=0;
	if ($T>=3600) {
		my $h=int ($T/3600);
		my $a=$T%3600;
		if ($a>=60) {
			my $m=int($a/60);
			$s=$a%60;
			$T=$h."h\-".$m."m\-".$s."s";
		}else{
			$T=$h."h-"."0m\-".$a."s";
		}
	}else{
		if ($T>=60) {
			my $m=int($T/60);
			$s=$T%60;
			$T=$m."m\-".$s."s";
		}else{
			$T=$T."s";
		}
	}
	return ($T);
}

sub ABSOLUTE_DIR #$pavfile=&ABSOLUTE_DIR($pavfile);
{
	my $cur_dir=`pwd`;chomp($cur_dir);
	my ($in)=@_;
	my $return="";
	if(-f $in){
		my $dir=dirname($in);
		my $file=basename($in);
		chdir $dir;$dir=`pwd`;chomp $dir;
		$return="$dir/$file";
	}elsif(-d $in){
		chdir $in;$return=`pwd`;chomp $return;
	}else{
		warn "Warning just for file and dir\n";
		exit;
	}
	chdir $cur_dir;
	return $return;
}

