use strict;
use Cwd qw(abs_path getcwd);
use Getopt::Long;
use Data::Dumper;
use File::Basename qw(basename dirname);
use FindBin qw($Bin $Script);

my $programe_dir=basename($0);
my $path=dirname($0);

my $ver    = "1.0";
my $Writer = "Daih <daih\@biomarker.com.cn>";
my $Data   = "2015/11/6";
my $BEGIN=time();
#######################################################################################

# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
my ($snp_file, $gff_tc, $gff_bsb, $od);
GetOptions(
			"h|?" =>\&help,
			"od:s"=>\$od,
			"snp:s"=>\$snp_file,
			"tc:s"=>\$gff_tc,
			"bsb:s"=>\$gff_bsb,
			) || &help;
&help unless ($snp_file && $gff_tc && $gff_bsb && $od);

sub help
{
	print <<"	Usage End.";
    Description:
        Writer  : $Writer
        Data    : $Data
        Version : $ver
        function: ......
    Usage:
	perl XXX.pl -snp <gene snp file> -tc <tc gff file> -bsb <bsb gff file> -od <outfile>
	Usage End.
	exit;
}
# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
$od = abs_path ($od);
#mkdir $od if (!-d $od);
$snp_file = abs_path($snp_file);
$gff_tc = abs_path($gff_tc);
$gff_bsb = abs_path($gff_bsb);
###############Time
my $Time_Start;
$Time_Start = sub_format_datetime(localtime(time()));
print "\nStart $programe_dir Time :[$Time_Start]\n\n";
################
my %tc_gff = ReadGff($gff_tc);
my %bsb_gff = ReadGff($gff_bsb);
open my $IN, "<$snp_file";
open my $O, ">$od";
while(<$IN>){
	chomp;
	my @items = split/\t+/;
	my $tc_pos = Changing($items[0], $items[1], \%tc_gff);
	my $bsb_pos = Changing($items[3], $items[4], \%bsb_gff);
	print $O "$items[0]\t$tc_pos\t$items[2]\t$items[3]\t$bsb_pos\t$items[5]\n";
}
sub Changing{
	my($geneid, $genepos, $hash) = @_;
	my %hash = %{$hash};
	my $genome_pos;
	if(exists $hash{$geneid}){
		my @words = @{$hash{$geneid}};
		my $orien = $words[0][-1];
		my $accum;
		for(my $i=0;$i<=$#words;$i++){
			my $len = abs($words[$i][1]-$words[$i][2])+1;
			$accum += $len;
			if($accum >= $genepos){
				my $dif = $accum - $genepos;
				if($orien eq "+"){
					$genome_pos = $words[$i][2]-$dif;
				}else{
					$genome_pos = $words[$i][1]+$dif;
				}
				last;
			}
		}
	}else{
		print "Error: can not find the gene $geneid\n";
	}
	return($genome_pos);
}

sub ReadGff{
	my $file = shift;
	open my $IN, "<$file";
	my %hash;
	while(<$IN>){
		chomp;
		next unless(/\tCDS\t/);
		my @aa = split/\t+/;
		my ($geneid) = $_ =~ /Parent=(\w+?);/;
		push @{$hash{$geneid}}, [$aa[0], $aa[3], $aa[4], $aa[6]];
	}
	return(%hash);
}
###############Time
my $Time_End;
$Time_End = sub_format_datetime(localtime(time()));
print "\nEnd $programe_dir Time :[$Time_End]\n\n";
&Runtime($BEGIN);
###############Subs
sub sub_format_datetime #Time calculation subroutine
{
	my($sec, $min, $hour, $day, $mon, $year, $wday, $yday, $isdst) = @_;
	$wday = $yday = $isdst = 0;
	sprintf("%4d-%02d-%02d %02d:%02d:%02d", $year+1900, $mon+1, $day, $hour, $min, $sec);
}

sub Runtime # &Runtime($BEGIN);
{
	my ($t1)=@_;
	my $t=time()-$t1;
	print "Total $programe_dir elapsed time : [",&sub_time($t),"]\n";
}
sub sub_time
{
	my ($T)=@_;chomp $T;
	my $s=0;my $m=0;my $h=0;
	if ($T>=3600) {
		my $h=int ($T/3600);
		my $a=$T%3600;
		if ($a>=60) {
			my $m=int($a/60);
			$s=$a%60;
			$T=$h."h\-".$m."m\-".$s."s";
		}else{
			$T=$h."h-"."0m\-".$a."s";
		}
	}else{
		if ($T>=60) {
			my $m=int($T/60);
			$s=$T%60;
			$T=$m."m\-".$s."s";
		}else{
			$T=$T."s";
		}
	}
	return ($T);
}

sub ABSOLUTE_DIR #$pavfile=&ABSOLUTE_DIR($pavfile);
{
	my $cur_dir=`pwd`;chomp($cur_dir);
	my ($in)=@_;
	my $return="";
	if(-f $in){
		my $dir=dirname($in);
		my $file=basename($in);
		chdir $dir;$dir=`pwd`;chomp $dir;
		$return="$dir/$file";
	}elsif(-d $in){
		chdir $in;$return=`pwd`;chomp $return;
	}else{
		warn "Warning just for file and dir\n";
		exit;
	}
	chdir $cur_dir;
	return $return;
}

