use strict;
use Cwd qw(abs_path getcwd);
use Getopt::Long;
use Data::Dumper;
use File::Basename qw(basename dirname);
use FindBin qw($Bin $Script);

my $programe_dir=basename($0);
my $path=dirname($0);

my $ver    = "1.0";
my $Writer = "Daih <daih\@biomarker.com.cn>";
my $Data   = "2015/11/6";
my $BEGIN=time();
#######################################################################################

# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
my ($id,$od);
GetOptions(
			"h|?" =>\&help,
			"od:s"=>\$od,
			"id:s"=>\$id,
			) || &help;
&help unless ($id && $od);

sub help
{
	print <<"	Usage End.";
    Description:
        Writer  : $Writer
        Data    : $Data
        Version : $ver
        function: ......
    Usage:
	perl XXX.pl -id <count file> -od <outfile>
	Usage End.
	exit;
}
# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
$od = abs_path ($od);
#mkdir $od if (!-d $od);
$id = abs_path($id);
###############Time
my $Time_Start;
$Time_Start = sub_format_datetime(localtime(time()));
print "\nStart $programe_dir Time :[$Time_Start]\n\n";
################
open my $IN, "<$id";
open my $OD, ">$od";
my %hash;
while(<$IN>){
	chomp;
	next if(/^$/);
	if(/^#/){
		my @aa = split/\t+/;
		print $OD "#$aa[2]\t$aa[6]";
		for(my $i=9;$i<$#aa;$i+=2){
			print $OD "\t$aa[$i]";
		}
		print $OD "\tSnp_number\n";
	}else{
		my @aa = split/\t+/;
		push @{$hash{$aa[2]}},[$aa[6], $aa[9], $aa[11], $aa[13], $aa[15], $aa[17], $aa[19], $aa[21], $aa[23], $aa[25], $aa[27], $aa[29], $aa[31], $aa[33], $aa[35], $aa[37], $aa[39], $aa[41], $aa[43], $aa[45], $aa[47], $aa[49], $aa[51]];
	}
}

for my $geneid(keys %hash){
	my @item = @{$hash{$geneid}};
	my $snp_count = @item;
	my $num = @{$item[0]};
	print $OD "$geneid\t$item[0][0]";
	for(my $i=1;$i<=$num;$i++){
		my %sum;
		for(my $j=0;$j<$snp_count;$j++){
			my @count = split/;/,$item[$j][$i];
			for(my $k=0;$k<=$#count;$k++){
				my @each = split/,/, $count[$k];
				for my $idx(@each){
					$sum{$k}+=$idx;
				}
			}
		}
		my @final;
		for my $idy(sort{$a<=>$b} keys %sum){
			#my $aver = int(($sum{$idy}/$snp_count)+0.5);
			push @final, $sum{$idy};
		}
		my $line = join ";", @final;
		print $OD "\t$line";
	}
	print $OD "\t$snp_count\n";
}


###############Time
my $Time_End;
$Time_End = sub_format_datetime(localtime(time()));
print "\nEnd $programe_dir Time :[$Time_End]\n\n";
&Runtime($BEGIN);
###############Subs
sub sub_format_datetime #Time calculation subroutine
{
	my($sec, $min, $hour, $day, $mon, $year, $wday, $yday, $isdst) = @_;
	$wday = $yday = $isdst = 0;
	sprintf("%4d-%02d-%02d %02d:%02d:%02d", $year+1900, $mon+1, $day, $hour, $min, $sec);
}

sub Runtime # &Runtime($BEGIN);
{
	my ($t1)=@_;
	my $t=time()-$t1;
	print "Total $programe_dir elapsed time : [",&sub_time($t),"]\n";
}
sub sub_time
{
	my ($T)=@_;chomp $T;
	my $s=0;my $m=0;my $h=0;
	if ($T>=3600) {
		my $h=int ($T/3600);
		my $a=$T%3600;
		if ($a>=60) {
			my $m=int($a/60);
			$s=$a%60;
			$T=$h."h\-".$m."m\-".$s."s";
		}else{
			$T=$h."h-"."0m\-".$a."s";
		}
	}else{
		if ($T>=60) {
			my $m=int($T/60);
			$s=$T%60;
			$T=$m."m\-".$s."s";
		}else{
			$T=$T."s";
		}
	}
	return ($T);
}

sub ABSOLUTE_DIR #$pavfile=&ABSOLUTE_DIR($pavfile);
{
	my $cur_dir=`pwd`;chomp($cur_dir);
	my ($in)=@_;
	my $return="";
	if(-f $in){
		my $dir=dirname($in);
		my $file=basename($in);
		chdir $dir;$dir=`pwd`;chomp $dir;
		$return="$dir/$file";
	}elsif(-d $in){
		chdir $in;$return=`pwd`;chomp $return;
	}else{
		warn "Warning just for file and dir\n";
		exit;
	}
	chdir $cur_dir;
	return $return;
}

