use strict;
use Cwd qw(abs_path getcwd);
use Getopt::Long;
use Data::Dumper;
use File::Basename qw(basename dirname);
use FindBin qw($Bin $Script);

my $programe_dir=basename($0);
my $path=dirname($0);

my $ver    = "1.0";
my $Writer = "Daih <daih\@biomarker.com.cn>";
my $Data   = "2015/11/6";
my $BEGIN=time();
#######################################################################################

# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
my ($id,$od);
GetOptions(
			"h|?" =>\&help,
			"od:s"=>\$od,
			"id:s"=>\$id,
			) || &help;
&help unless ($id && $od);

sub help
{
	print <<"	Usage End.";
    Description:
        Writer  : $Writer
        Data    : $Data
        Version : $ver
        function: ......
    Usage:

	Usage End.
	exit;
}
# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
$od = abs_path ($od);
#mkdir $od if (!-d $od);
$id = abs_path($id);
###############Time
my $Time_Start;
$Time_Start = sub_format_datetime(localtime(time()));
print "\nStart $programe_dir Time :[$Time_Start]\n\n";
################
open my $IN, "<$id";
open my $OD, ">$od";
my %hash;
while(<$IN>){
	chomp;
	next if(/^#/ || /^$/);
	my @aa = split/\t+/;
	for(my $i=2;$i<=$#aa;$i+=1){
		my @array = split/[;]/,$aa[$i];
		for my $id(@array){
			my @bb = split/,/,$id;
			my $sum;
			for my $idx(@bb){
				$sum += $idx;
			}
			$hash{$sum}++;
		}
	}
}

my $cut_0025 = 0.0025;
my $cut_005 = 0.005;
my $cut_008 = 0.008;

my $total = scalar keys %hash;
my $cut_num1 = int(($total*$cut_0025)+0.5);
my $cut_num2 = int(($total*$cut_005)+0.5);
my $cut_num3 = int(($total*$cut_008)+0.5);

my($cut1, $cut2, $cut3)=();
my $num = 0;
foreach my $count(sort{$a<=>$b} keys %hash){
	$num++;
	if($num == $cut_num1){
		$cut1 = $count;
	}elsif($num == $cut_num2){
		$cut2 = $count;
	}elsif($num == $cut_num3){
		$cut3 = $count;
		last;
	}
}
print $OD "2.5\%: $cut1\n";
print $OD "5\%: $cut2\n";
print $OD "8\%: $cut3\n";

###############Time
my $Time_End;
$Time_End = sub_format_datetime(localtime(time()));
print "\nEnd $programe_dir Time :[$Time_End]\n\n";
&Runtime($BEGIN);
###############Subs
sub sub_format_datetime #Time calculation subroutine
{
	my($sec, $min, $hour, $day, $mon, $year, $wday, $yday, $isdst) = @_;
	$wday = $yday = $isdst = 0;
	sprintf("%4d-%02d-%02d %02d:%02d:%02d", $year+1900, $mon+1, $day, $hour, $min, $sec);
}

sub Runtime # &Runtime($BEGIN);
{
	my ($t1)=@_;
	my $t=time()-$t1;
	print "Total $programe_dir elapsed time : [",&sub_time($t),"]\n";
}
sub sub_time
{
	my ($T)=@_;chomp $T;
	my $s=0;my $m=0;my $h=0;
	if ($T>=3600) {
		my $h=int ($T/3600);
		my $a=$T%3600;
		if ($a>=60) {
			my $m=int($a/60);
			$s=$a%60;
			$T=$h."h\-".$m."m\-".$s."s";
		}else{
			$T=$h."h-"."0m\-".$a."s";
		}
	}else{
		if ($T>=60) {
			my $m=int($T/60);
			$s=$T%60;
			$T=$m."m\-".$s."s";
		}else{
			$T=$T."s";
		}
	}
	return ($T);
}

sub ABSOLUTE_DIR #$pavfile=&ABSOLUTE_DIR($pavfile);
{
	my $cur_dir=`pwd`;chomp($cur_dir);
	my ($in)=@_;
	my $return="";
	if(-f $in){
		my $dir=dirname($in);
		my $file=basename($in);
		chdir $dir;$dir=`pwd`;chomp $dir;
		$return="$dir/$file";
	}elsif(-d $in){
		chdir $in;$return=`pwd`;chomp $return;
	}else{
		warn "Warning just for file and dir\n";
		exit;
	}
	chdir $cur_dir;
	return $return;
}

