use strict;
use Cwd qw(abs_path getcwd);
use Getopt::Long;
use Data::Dumper;
use File::Basename qw(basename dirname);
use FindBin qw($Bin $Script);

my $programe_dir=basename($0);
my $path=dirname($0);

my $ver    = "1.0";
my $Writer = "Daih <daih\@biomarker.com.cn>";
my $Data   = "2015/11/6";
my $BEGIN=time();
#######################################################################################

# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
my ($id,$sample_file,$ase,$od);
GetOptions(
			"h|?" =>\&help,
			"od:s"=>\$od,
			"id:s"=>\$id,
			"sample:s"=>\$sample_file,
			"ase:s"=>\$ase,
			) || &help;
&help unless ($id && $sample_file && $ase && $od);

sub help
{
	print <<"	Usage End.";
    Description:
        Writer  : $Writer
        Data    : $Data
        Version : $ver
        function: ......
    Usage:
	perl XXX.pl -id <count files dir> -sample <sample repeat file> -ase <ase file> -od <outdir>
	Usage End.
	exit;
}
# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
$od = abs_path ($od);
mkdir $od if (!-d $od);
$id = abs_path($id);
$sample_file = abs_path($sample_file);
$ase = abs_path($ase);
###############Time
my $Time_Start;
$Time_Start = sub_format_datetime(localtime(time()));
print "\nStart $programe_dir Time :[$Time_Start]\n\n";
################
my %sample_hash;
my %rep;
my @sample_list;
open my $SA, "<$sample_file";
while(<$SA>){
	chomp;
	next if(/^#/ || /^$/);
	my @aa = split/\t+/;
	$sample_hash{$aa[0]} = $aa[1];
	if(!exists $rep{$aa[1]}){
		push @sample_list, $aa[1];
		$rep{$aa[1]} = 1;
	}
}

my @path = glob("$id/*.out");
my %hash;
for my $file(@path){
	open my $IN, "<$file";
	my $name = basename($file);
	$name =~ s/\.out//g;
	while(<$IN>){
		chomp;
		next if(/^#/ || /^$/);
		my @aa = split/\t+/;
		my $group = $sample_hash{$name};
		push @{$hash{$aa[0]}{$aa[1]}{$group}{tc}}, $aa[12];
		push @{$hash{$aa[0]}{$aa[1]}{$group}{tcd}}, $aa[13];
		push @{$hash{$aa[0]}{$aa[1]}{$group}{bsb}}, $aa[14];
		push @{$hash{$aa[0]}{$aa[1]}{$group}{bsbd}}, $aa[15];
		#@{$hash{$aa[0]}{$aa[1]}{$name}}=($aa[12], $aa[13], $aa[14], $aa[15]);
	}
}

open my $IN, "<$ase";
open my $O, ">$od";
open my $AL, ">$od/All_Ase_count.xls";
open my $TC, ">$od/TC_Ase_count.xls";
open my $BSB, ">$od/BSB_Ase_count.xls";
print $AL "#TC_chr\tTC_pos\tTC_gene\tTC_orien\tBSB_chr\tBSB_pos\tBSB_gene\tBSB_orien\tTC_base\tTC_depth\tBSB_base\tBSB_depth";
print $TC "#TC_chr\tTC_pos\tTC_gene\tTC_orien\tTC_base\tTC_depth";
print $BSB "#BSB_chr\tBSB_pos\tBSB_gene\tBSB_orien\tBSB_base\tBSB_depth";
for my $key(@sample_list){
	print $AL "\tTC_$key"."_base\tTC_$key"."_depth\tBSB_$key"."_base\tBSB_$key"."_depth";
	print $TC "\tTC_$key"."_base\tTC_$key"."_depth";
	print $BSB "\tBSB_$key"."_base\tBSB_$key"."_depth";
}
print $AL "\n";
print $TC "\n";
print $BSB "\n";

while(<$IN>){
	chomp;
	next if(/^#/ || /^$/);
	my($tc_chr, $tc_pos, $tc_base, $tc_depth, $tc_gene, $tc_orien, $bsb_chr, $bsb_pos, $bsb_base, $bsb_depth, $bsb_gene, $bsb_orien) =  split/\t+/;
	if(exists $hash{$tc_chr}{$tc_pos}){
		print $AL "$tc_chr\t$tc_pos\t$tc_gene\t$tc_orien\t$bsb_chr\t$bsb_pos\t$bsb_gene\t$bsb_orien\t$tc_base\t$tc_depth\t$bsb_base\t$bsb_depth";
		print $TC "$tc_chr\t$tc_pos\t$tc_gene\t$tc_orien\t$tc_base\t$tc_depth";
		print $BSB "$bsb_chr\t$bsb_pos\t$bsb_gene\t$bsb_orien\t$bsb_base\t$bsb_depth";

		for my $sample(@sample_list){
			if(exists $hash{$tc_chr}{$tc_pos}{$sample}){
				my @tc = @{$hash{$tc_chr}{$tc_pos}{$sample}{tc}};
				my @tcd = @{$hash{$tc_chr}{$tc_pos}{$sample}{tcd}};
				my @bsb = @{$hash{$tc_chr}{$tc_pos}{$sample}{bsb}};
				my @bsbd = @{$hash{$tc_chr}{$tc_pos}{$sample}{bsbd}};
				my $base_tc = join";",@tc;
				my $depth_tc = join";",@tcd;
				my $base_bsb = join";",@bsb;
				my $depth_bsb = join";",@bsbd;
				print $AL "\t$base_tc\t$depth_tc\t$base_bsb\t$depth_bsb";
				print $TC "\t$base_tc\t$depth_tc";
				print $BSB "\t$base_bsb\t$depth_bsb";
			}else{
				print $AL "\tFilter\tFilter\tFilter\tFilter";
				print $TC "\tFilter\tFilter";
				print $BSB "\tFilter\tFilter";
			}
		}
		print $AL "\n";
		print $TC "\n";
		print $BSB "\n";
	}else{
		next;
	}
}

#############Time
my $Time_End;
$Time_End = sub_format_datetime(localtime(time()));
print "\nEnd $programe_dir Time :[$Time_End]\n\n";
&Runtime($BEGIN);
###############Subs
sub sub_format_datetime #Time calculation subroutine
{
	my($sec, $min, $hour, $day, $mon, $year, $wday, $yday, $isdst) = @_;
	$wday = $yday = $isdst = 0;
	sprintf("%4d-%02d-%02d %02d:%02d:%02d", $year+1900, $mon+1, $day, $hour, $min, $sec);
}

sub Runtime # &Runtime($BEGIN);
{
	my ($t1)=@_;
	my $t=time()-$t1;
	print "Total $programe_dir elapsed time : [",&sub_time($t),"]\n";
}
sub sub_time
{
	my ($T)=@_;chomp $T;
	my $s=0;my $m=0;my $h=0;
	if ($T>=3600) {
		my $h=int ($T/3600);
		my $a=$T%3600;
		if ($a>=60) {
			my $m=int($a/60);
			$s=$a%60;
			$T=$h."h\-".$m."m\-".$s."s";
		}else{
			$T=$h."h-"."0m\-".$a."s";
		}
	}else{
		if ($T>=60) {
			my $m=int($T/60);
			$s=$T%60;
			$T=$m."m\-".$s."s";
		}else{
			$T=$T."s";
		}
	}
	return ($T);
}

sub ABSOLUTE_DIR #$pavfile=&ABSOLUTE_DIR($pavfile);
{
	my $cur_dir=`pwd`;chomp($cur_dir);
	my ($in)=@_;
	my $return="";
	if(-f $in){
		my $dir=dirname($in);
		my $file=basename($in);
		chdir $dir;$dir=`pwd`;chomp $dir;
		$return="$dir/$file";
	}elsif(-d $in){
		chdir $in;$return=`pwd`;chomp $return;
	}else{
		warn "Warning just for file and dir\n";
		exit;
	}
	chdir $cur_dir;
	return $return;
}

