use strict;
use Cwd qw(abs_path getcwd);
use Getopt::Long;
use Data::Dumper;
use File::Basename qw(basename dirname);
use FindBin qw($Bin $Script);

my $programe_dir=basename($0);
my $path=dirname($0);

my $ver    = "1.0";
my $Writer = "Daih <daih\@biomarker.com.cn>";
my $Data   = "2015/11/6";
my $BEGIN=time();
#######################################################################################

# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
my ($ase_file,$tc_depth_dir,$bsb_depth_dir,$od);
GetOptions(
			"h|?" =>\&help,
			"od:s"=>\$od,
			"ase:s"=>\$ase_file,
			"tc:s"=>\$tc_depth_dir,
			"bsb:s"=>\$bsb_depth_dir,
			) || &help;
&help unless ($ase_file && $tc_depth_dir && $bsb_depth_dir && $od);

sub help
{
	print <<"	Usage End.";
    Description:
        Writer  : $Writer
        Data    : $Data
        Version : $ver
        function: ......
    Usage:
	perl XXX.pl -ase <ASE information file> -tc <tc depth file> -bsb <bsb depth file> -od <out file>
	Usage End.
	exit;
}
# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
$od = abs_path ($od);
#mkdir $od if (!-d $od);
$ase_file = abs_path($ase_file);
$tc_depth_dir = abs_path($tc_depth_dir);
$bsb_depth_dir = abs_path($bsb_depth_dir);
###############Time
my $Time_Start;
$Time_Start = sub_format_datetime(localtime(time()));
print "\nStart $programe_dir Time :[$Time_Start]\n\n";
################
my %pos_hash = &PosList($ase_file);
my @path_tc = glob("$tc_depth_dir/*.depth");
my @path_bsb = glob("$bsb_depth_dir/*.depth");
my %depth_tc = &ReadDepth("TC", \@path_tc);
my %depth_bsb = &ReadDepth("BSB", \@path_bsb);

open my $IN, "<$ase_file";
open my $O, ">$od";
while(<$IN>){
	chomp;
	my @aa = split/\t+/;
	if($_=~/CdsBase/){
		if($aa[3] =~ /CdsBase/){
			if(exists $depth_tc{$aa[0]}{$aa[1]}){
				my @all = @{$depth_tc{$aa[0]}{$aa[1]}};
				my $num = @all;
				if($num == 3){
					$aa[3] = join ";", @all;
				}else{
					next;
				}
			}else{
				next;
			}
		}
		if($aa[9] =~ /CdsBase/){
			if(exists $depth_bsb{$aa[6]}{$aa[7]}){
				my @all = @{$depth_bsb{$aa[6]}{$aa[7]}};
				my $num = @all;
				if($num == 3){
					$aa[9] = join";", @all;
				}else{
					next;
				}
			}else{
				next;
			}
		}
		my $line = join"\t", @aa;
		print $O "$line\n";
		
	}else{
		print $O "$_\n";
	}
}

sub ReadDepth{
	my($key, $path) = @_;
	my @path = @{$path};
	my %hash;
	for my $file(@path){
		open my $IN, "<$file";
		while(<$IN>){
			chomp;
			next if(/^#/ || /^$/);
			my @aa = split/\t+/;
			next if($aa[2] == 0);
			if(exists $pos_hash{$key}{$aa[0]}{$aa[1]}){
				push @{$hash{$aa[0]}{$aa[1]}}, $aa[2];
			}
		}
	}
	return(%hash);
}

sub PosList{
	my $file = shift;
	my %hash;
	open my $IN,"<$file";
	while(<$IN>){
		chomp;
		my @aa = split/\t+/;
		if($aa[3] =~ /CdsBase/){
			$hash{TC}{$aa[0]}{$aa[1]}=1;
		}
		if($aa[9] =~ /CdsBase/){
			$hash{BSB}{$aa[6]}{$aa[7]}=1;
		}
	}
	return(%hash);
}

###############Time
my $Time_End;
$Time_End = sub_format_datetime(localtime(time()));
print "\nEnd $programe_dir Time :[$Time_End]\n\n";
&Runtime($BEGIN);
###############Subs
sub sub_format_datetime #Time calculation subroutine
{
	my($sec, $min, $hour, $day, $mon, $year, $wday, $yday, $isdst) = @_;
	$wday = $yday = $isdst = 0;
	sprintf("%4d-%02d-%02d %02d:%02d:%02d", $year+1900, $mon+1, $day, $hour, $min, $sec);
}

sub Runtime # &Runtime($BEGIN);
{
	my ($t1)=@_;
	my $t=time()-$t1;
	print "Total $programe_dir elapsed time : [",&sub_time($t),"]\n";
}
sub sub_time
{
	my ($T)=@_;chomp $T;
	my $s=0;my $m=0;my $h=0;
	if ($T>=3600) {
		my $h=int ($T/3600);
		my $a=$T%3600;
		if ($a>=60) {
			my $m=int($a/60);
			$s=$a%60;
			$T=$h."h\-".$m."m\-".$s."s";
		}else{
			$T=$h."h-"."0m\-".$a."s";
		}
	}else{
		if ($T>=60) {
			my $m=int($T/60);
			$s=$T%60;
			$T=$m."m\-".$s."s";
		}else{
			$T=$T."s";
		}
	}
	return ($T);
}

sub ABSOLUTE_DIR #$pavfile=&ABSOLUTE_DIR($pavfile);
{
	my $cur_dir=`pwd`;chomp($cur_dir);
	my ($in)=@_;
	my $return="";
	if(-f $in){
		my $dir=dirname($in);
		my $file=basename($in);
		chdir $dir;$dir=`pwd`;chomp $dir;
		$return="$dir/$file";
	}elsif(-d $in){
		chdir $in;$return=`pwd`;chomp $return;
	}else{
		warn "Warning just for file and dir\n";
		exit;
	}
	chdir $cur_dir;
	return $return;
}

