use strict;
use Cwd qw(abs_path getcwd);
use Getopt::Long;
use Data::Dumper;
use File::Basename qw(basename dirname);
use FindBin qw($Bin $Script);

my $programe_dir=basename($0);
my $path=dirname($0);

my $ver    = "1.0";
my $Writer = "Daih <daih\@biomarker.com.cn>";
my $Data   = "2015/11/6";
my $BEGIN=time();
#######################################################################################

# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
my ($ase_file,$tc_snp,$bsb_snp,$od);
GetOptions(
			"h|?" =>\&help,
			"od:s"=>\$od,
			"ase:s"=>\$ase_file,
			"tc:s"=>\$tc_snp,
			"bsb:s"=>\$bsb_snp,
			) || &help;
&help unless ($ase_file && $tc_snp && $bsb_snp && $od);

sub help
{
	print <<"	Usage End.";
    Description:
        Writer  : $Writer
        Data    : $Data
        Version : $ver
        function: ......
    Usage:
	perl XXX.pl -ase <ase file> -tc <tc snp file> -bsb <bsb snp file> -od <out file>
	Usage End.
	exit;
}
# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
$od = abs_path ($od);
#mkdir $od if (!-d $od);
$ase_file = abs_path($ase_file);
$tc_snp = abs_path($tc_snp);
$bsb_snp = abs_path($bsb_snp);
###############Time
my $Time_Start;
$Time_Start = sub_format_datetime(localtime(time()));
print "\nStart $programe_dir Time :[$Time_Start]\n\n";
################
my %tc_hash = ReadSnp($tc_snp);
my %bsb_hash = ReadSnp($bsb_snp);

open my $IN, "<$ase_file";
open my $O, ">$od";
while(<$IN>){
	chomp;
	my @aa = split/\t+/;
	if($aa[3] =~ /[\d]+/){
		if(exists $tc_hash{$aa[0]}{$aa[1]}){
			$aa[3] = $tc_hash{$aa[0]}{$aa[1]};
		}else{
			print "Error: Can not find $aa[0]  $aa[1]\n";
		}
	}
	if($aa[9] =~ /[\d]+/){
		if(exists $bsb_hash{$aa[6]}{$aa[7]}){
			$aa[9] = $bsb_hash{$aa[6]}{$aa[7]};
		}else{
			print "Error: Can not find $aa[6]  $aa[7]\n";
		}
	}
	my $line = join "\t",@aa;
	print $O "$line\n";
}

sub ReadSnp{
	my $file = shift;
	my %hash;
	open my $IN, "<$file";
	while(<$IN>){
		chomp;
		next if(/^#/ || /^$/);
		my @aa = split/\t+/;
		my $a1 = Filter($aa[6]);
		my $a2 = Filter($aa[9]);
		my $a3 = Filter($aa[12]);
		my $line = join("\;",$a1, $a2, $a3);
		$hash{$aa[0]}{$aa[1]} = $line;
	}
	return(%hash);
}

sub Filter{
	my $file = shift;
	my $result;
	if($file =~ /,/){
		my @aa = split/,/,$file;
		my @new = ();
		for my $id(@aa){
			if($id != 0){
				push @new, $id;
			}
		}
		$result = join",", @new;
	}else{
		$result = $file;
	}
	return($result);
}
###############Time
my $Time_End;
$Time_End = sub_format_datetime(localtime(time()));
print "\nEnd $programe_dir Time :[$Time_End]\n\n";
&Runtime($BEGIN);
###############Subs
sub sub_format_datetime #Time calculation subroutine
{
	my($sec, $min, $hour, $day, $mon, $year, $wday, $yday, $isdst) = @_;
	$wday = $yday = $isdst = 0;
	sprintf("%4d-%02d-%02d %02d:%02d:%02d", $year+1900, $mon+1, $day, $hour, $min, $sec);
}

sub Runtime # &Runtime($BEGIN);
{
	my ($t1)=@_;
	my $t=time()-$t1;
	print "Total $programe_dir elapsed time : [",&sub_time($t),"]\n";
}
sub sub_time
{
	my ($T)=@_;chomp $T;
	my $s=0;my $m=0;my $h=0;
	if ($T>=3600) {
		my $h=int ($T/3600);
		my $a=$T%3600;
		if ($a>=60) {
			my $m=int($a/60);
			$s=$a%60;
			$T=$h."h\-".$m."m\-".$s."s";
		}else{
			$T=$h."h-"."0m\-".$a."s";
		}
	}else{
		if ($T>=60) {
			my $m=int($T/60);
			$s=$T%60;
			$T=$m."m\-".$s."s";
		}else{
			$T=$T."s";
		}
	}
	return ($T);
}

sub ABSOLUTE_DIR #$pavfile=&ABSOLUTE_DIR($pavfile);
{
	my $cur_dir=`pwd`;chomp($cur_dir);
	my ($in)=@_;
	my $return="";
	if(-f $in){
		my $dir=dirname($in);
		my $file=basename($in);
		chdir $dir;$dir=`pwd`;chomp $dir;
		$return="$dir/$file";
	}elsif(-d $in){
		chdir $in;$return=`pwd`;chomp $return;
	}else{
		warn "Warning just for file and dir\n";
		exit;
	}
	chdir $cur_dir;
	return $return;
}

