use strict;
use Cwd qw(abs_path getcwd);
use Getopt::Long;
use Data::Dumper;
use File::Basename qw(basename dirname);
use FindBin qw($Bin $Script);

my $programe_dir=basename($0);
my $path=dirname($0);

my $ver    = "1.0";
my $Writer = "Daih <daih\@biomarker.com.cn>";
my $Data   = "2015/11/6";
my $BEGIN=time();
#######################################################################################

# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
my ($tc_depth_file,$bsb_depth_file,$ase_file,$tc_snp_file,$bsb_snp_file,$sample,$tc_fa,$bsb_fa,$od);
GetOptions(
			"h|?" =>\&help,
			"od:s"=>\$od,
			"tcdepth:s"=>\$tc_depth_file,
			"bsbdepth:s"=>\$bsb_depth_file,
			"a:s"=>\$ase_file,
			"tc:s"=>\$tc_snp_file,
			"bsb:s"=>\$bsb_snp_file,
			"sample:s"=>\$sample,
			"tcfa:s"=>\$tc_fa,
			"bsbfa:s"=>\$bsb_fa,
			) || &help;
&help unless ($tc_depth_file && $bsb_depth_file && $ase_file && $tc_snp_file && $bsb_snp_file && $sample && $tc_fa && $bsb_fa && $od);

sub help
{
	print <<"	Usage End.";
    Description:
        Writer  : $Writer
        Data    : $Data
        Version : $ver
        function: ......
    Usage:
	perl XXX.pl -tcdepth <tc depth file> -bsbdepth <bsb depth file> -a <Parental ASE file> -tc <tc snp file> -bsb <bsb snp file> -sample <sample name> -tcfa <tc genome fa file> -bsbfa <bsb genome fa file> -od <outfile>
	Usage End.
	exit;
}
# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
$od = abs_path ($od);
#mkdir $od if (!-d $od);
$tc_depth_file = abs_path($tc_depth_file);
$bsb_depth_file = abs_path($bsb_depth_file);
$ase_file = abs_path($ase_file);
$tc_snp_file = abs_path($tc_snp_file);
$bsb_snp_file = abs_path($bsb_snp_file);
$tc_fa = abs_path($tc_fa);
$bsb_fa = abs_path($bsb_fa);
###############Time
my $Time_Start;
$Time_Start = sub_format_datetime(localtime(time()));
print "\nStart $programe_dir Time :[$Time_Start]\n\n";
################

my %pos_list = PostList($ase_file);print "Getting Ase position is done!\n\n";

print "Reading genome fasta file......\n";
my %tc_fa_hash = ReadFa($tc_fa);
my %bsb_fa_hash = ReadFa($bsb_fa);
print "Done!\n\n";

print "Reading SNP file......\n";
my %tc_snp_hash = ReadSnp($tc_snp_file);
my %bsb_snp_hash = ReadSnp($bsb_snp_file);
print "Done!\n\n";

print "Reading Depth file......\n";
my %tc_depth_hash = ReadDepth($tc_depth_file,"TC",\%tc_fa_hash);
my %bsb_depth_hash = ReadDepth($bsb_depth_file,"BSB",\%bsb_fa_hash);
print "Done!\n";

print "Combine for the result......\n";
open my $LI, "<$ase_file";
open my $O, ">$od";
while(<$LI>){
	chomp;
	next if(/^#/ || /^$/);
	my @aa = split/\t+/;
	my($base1, $depth1) = JudgeSnp($aa[0], $aa[1], $aa[2], \%tc_snp_hash, \%tc_depth_hash);
	#next if($base1 =~ /Filter/);
	my ($base2, $depth2) = JudgeSnp($aa[6], $aa[7], $aa[8], \%bsb_snp_hash, \%bsb_depth_hash);
	print $O "$_\t$base1\t$depth1\t$base2\t$depth2\n";
	
}
print "Done!\n";

sub JudgeSnp{
	my($chr, $pos, $type, $hytype, $hydepth) = @_;
	my %hytype = %{$hytype};
	my %hydepth = %{$hydepth};
	my %hash;
	my @types = split/,/,$type;
	my @newtype;
	my @newdepth;
	for my $idx(@types){
		$hash{$idx} = 1;
	}
	my ($final_base,$final_depth);
	if(exists $hytype{$chr}{$pos}){
		my ($base, $depth) = @{$hytype{$chr}{$pos}};
		my @bases = split/,/,$base;
		my @depths = split/,/,$depth;
		for(my $i=0;$i<=$#bases;$i++){
			if(exists $hash{$bases[$i]}){
				next if($depths[$i] == 0);
				push @newtype, $bases[$i];
				push @newdepth, $depths[$i];
			}
		}
		my $number = @newtype;
		if($number == 0){
			$final_base = "NA";
			$final_depth = 0;
		}else{
			$final_base = join",",@newtype;
			$final_depth = join",",@newdepth;
		}
	}elsif(exists $hydepth{$chr}{$pos}){
		my($base, $depth) = @{$hydepth{$chr}{$pos}};
		if(exists $hash{$base}){
			$final_base = $base;
			$final_depth = $depth;
		}else{
			$final_base = "NA";
			$final_depth = 0;
		}
	}else{
		$final_base = "Filter";
		$final_depth = "Filter";
	}
	return($final_base, $final_depth);
}

sub ReadDepth{
	my($file, $key, $fahash) = @_;
	my %fahash = %{$fahash};
	my %hash;
	open my $IN, "<$file";
	while(<$IN>){
		chomp;
		next if(/^#/ || /^$/);
		my @aa = split/\t+/;
		if(exists $pos_list{$key}{$aa[0]}{$aa[1]}){
			my $base = substr($fahash{$aa[0]}, $aa[1]-1, 1);
			@{$hash{$aa[0]}{$aa[1]}}=($base, $aa[2]);
		}
	}
	return(%hash);
}

sub ReadSnp{
	my ($file,$key) = @_;
	my %hash;
	my $head;
	open my $IN, "<$file";
	while(<$IN>){
		chomp;
		next if(/^$/);
		my @aa = split/\t+/;
		if(/^#/){
			for(my $i=5;$i<$#aa;$i+=3){
				my $id = (split/_/,$aa[$i])[0];
				if($id eq $sample){
					$head = $i;
				}
			}
		}else{
			my($chr, $pos)=(split/\t+/)[0, 1];
			if(exists $pos_list{$key}{$chr}{$pos}){
				@{$hash{$chr}{$pos}} = ($aa[$head], $aa[$head+1]);
			}
		}
	}
	return(%hash);
}

sub PostList{
	my $file = shift;
	my %hash;
	open my $IN, "<$file";
	while(<$IN>){
		chomp;
		my @aa = split/\t+/;
		$hash{TC}{$aa[0]}{$aa[1]} = 1;
		$hash{BSB}{$aa[6]}{$aa[7]} = 1;
	}
	return(%hash);
}

sub ReadFa{
	my $file = shift;
	my %hash;
	open my $IN, "<$file";
	$/ = ">";
	<$IN>;
	while(<$IN>){
		chomp;
		my($head, $seq) = split/\n+/,$_,2;
		my $id = (split/\s+i/,$head)[0];
		$seq =~ s/\n+//g;
		$hash{$id} = $seq;
	}
	$/ = "\n";
	return(%hash);
}

###############Time
my $Time_End;
$Time_End = sub_format_datetime(localtime(time()));
print "\nEnd $programe_dir Time :[$Time_End]\n\n";
&Runtime($BEGIN);
###############Subs
sub sub_format_datetime #Time calculation subroutine
{
	my($sec, $min, $hour, $day, $mon, $year, $wday, $yday, $isdst) = @_;
	$wday = $yday = $isdst = 0;
	sprintf("%4d-%02d-%02d %02d:%02d:%02d", $year+1900, $mon+1, $day, $hour, $min, $sec);
}

sub Runtime # &Runtime($BEGIN);
{
	my ($t1)=@_;
	my $t=time()-$t1;
	print "Total $programe_dir elapsed time : [",&sub_time($t),"]\n";
}
sub sub_time
{
	my ($T)=@_;chomp $T;
	my $s=0;my $m=0;my $h=0;
	if ($T>=3600) {
		my $h=int ($T/3600);
		my $a=$T%3600;
		if ($a>=60) {
			my $m=int($a/60);
			$s=$a%60;
			$T=$h."h\-".$m."m\-".$s."s";
		}else{
			$T=$h."h-"."0m\-".$a."s";
		}
	}else{
		if ($T>=60) {
			my $m=int($T/60);
			$s=$T%60;
			$T=$m."m\-".$s."s";
		}else{
			$T=$T."s";
		}
	}
	return ($T);
}

sub ABSOLUTE_DIR #$pavfile=&ABSOLUTE_DIR($pavfile);
{
	my $cur_dir=`pwd`;chomp($cur_dir);
	my ($in)=@_;
	my $return="";
	if(-f $in){
		my $dir=dirname($in);
		my $file=basename($in);
		chdir $dir;$dir=`pwd`;chomp $dir;
		$return="$dir/$file";
	}elsif(-d $in){
		chdir $in;$return=`pwd`;chomp $return;
	}else{
		warn "Warning just for file and dir\n";
		exit;
	}
	chdir $cur_dir;
	return $return;
}

