use strict;
use Cwd qw(abs_path getcwd);
use Getopt::Long;
use Data::Dumper;
use File::Basename qw(basename dirname);
use FindBin qw($Bin $Script);

my $programe_dir=basename($0);
my $path=dirname($0);

my $ver    = "1.0";
my $Writer = "Daih <daih\@biomarker.com.cn>";
my $Data   = "2015/11/6";
my $BEGIN=time();
#######################################################################################

# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
my ($config,$gene_list,$od);
GetOptions(
			"h|?" =>\&help,
			"od:s"=>\$od,
			"conf:s"=>\$config,
			"g:s"=>\$gene_list,
			) || &help;
&help unless ($config && $gene_list && $od);

sub help
{
	print <<"	Usage End.";
    Description:
        Writer  : $Writer
        Data    : $Data
        Version : $ver
        function: ......
    Usage:
	perl XXX.pl -conf <config file> -g <gene list file> -od <outdir>
	Usage End.
	exit;
}
# ------------------------------------------------------------------
# GetOptions
# ------------------------------------------------------------------
$od = abs_path ($od);
mkdir $od if (!-d $od);
$config = abs_path($config);
###############Time
my $Time_Start;
$Time_Start = sub_format_datetime(localtime(time()));
print "\nStart $programe_dir Time :[$Time_Start]\n\n";
################
my %list_hash;
open(LI, $gene_list) || die $!;
while(<LI>){
	chomp;
	my @aa = split/\t+/;
	$list_hash{$aa[0]}{$aa[1]} = $aa[2];
}
close LI;

my %config_hash;
open (IN, $config) or die $!;
while(<IN>){
	chomp;
	next if(/^$/ || /^#/);
	my($spe, $sample, $genome, $line) = split/:/,$_;
#	my $line =~ s/\s+//g;
#	$line =~ s/^M//g;
	@{$config_hash{$spe}{$sample}} = ($genome, $line);
}
close IN;

`mkdir $od/SampleCount`;
for my $group(keys %config_hash){
	for my $sample(keys %{$config_hash{$group}}){
		my($genome, $line) = @{$config_hash{$group}{$sample}};
		my %total_hash;
		my %hash;
		open my $IN1, "samtools view $genome |";
		while(<$IN1>){
			chomp;
			my @aa = split/\t+/;
			$total_hash{$aa[2]}{$aa[0]} = 1;
		}
		my $total = 0;
		for my $contig(keys %total_hash){
			for my $read(keys %{$total_hash{$contig}}){
				$total += 1;
			}
		}

		open my $IN2, "samtools view $line |";
		while(<$IN2>){
			chomp;
			my @aa = split/\t+/;
			my $gname = (split/\-/, $aa[2])[0];
			$hash{$gname}{$aa[0]} = 1;
		}
		open(OD, ">SampleCount/$group.$sample.count.xls") || die $!;
		print OD "#Group\tSample\tGeneID\tRead_Count\tCount_normalized\tLog\n";
		if($list_hash{$group}){
			for my $gene(keys %{$list_hash{$group}}){
				my $len = $list_hash{$group}{$gene};
				if(exists $hash{$gene}){
					my $num = 0;
					for my $reads(keys %{$hash{$gene}}){
						$num++;
					}
					my $normal = ($num/($total*$len))*100000000;
					my $log = log($normal);
					print OD "$group\t$sample\t$gene\t$num\t$normal\t$log\n";
				}else{
					my $instead = (1/($total*$len))*100000000;
					my $log = log($instead);
					print OD "$group\t$sample\t$gene\t0\t0\t$log\n";
				}
			}
		}
		close OD;
	}
}



###############Time
my $Time_End;
$Time_End = sub_format_datetime(localtime(time()));
print "\nEnd $programe_dir Time :[$Time_End]\n\n";
&Runtime($BEGIN);
###############Subs
sub sub_format_datetime #Time calculation subroutine
{
	my($sec, $min, $hour, $day, $mon, $year, $wday, $yday, $isdst) = @_;
	$wday = $yday = $isdst = 0;
	sprintf("%4d-%02d-%02d %02d:%02d:%02d", $year+1900, $mon+1, $day, $hour, $min, $sec);
}

sub Runtime # &Runtime($BEGIN);
{
	my ($t1)=@_;
	my $t=time()-$t1;
	print "Total $programe_dir elapsed time : [",&sub_time($t),"]\n";
}
sub sub_time
{
	my ($T)=@_;chomp $T;
	my $s=0;my $m=0;my $h=0;
	if ($T>=3600) {
		my $h=int ($T/3600);
		my $a=$T%3600;
		if ($a>=60) {
			my $m=int($a/60);
			$s=$a%60;
			$T=$h."h\-".$m."m\-".$s."s";
		}else{
			$T=$h."h-"."0m\-".$a."s";
		}
	}else{
		if ($T>=60) {
			my $m=int($T/60);
			$s=$T%60;
			$T=$m."m\-".$s."s";
		}else{
			$T=$T."s";
		}
	}
	return ($T);
}

sub ABSOLUTE_DIR #$pavfile=&ABSOLUTE_DIR($pavfile);
{
	my $cur_dir=`pwd`;chomp($cur_dir);
	my ($in)=@_;
	my $return="";
	if(-f $in){
		my $dir=dirname($in);
		my $file=basename($in);
		chdir $dir;$dir=`pwd`;chomp $dir;
		$return="$dir/$file";
	}elsif(-d $in){
		chdir $in;$return=`pwd`;chomp $return;
	}else{
		warn "Warning just for file and dir\n";
		exit;
	}
	chdir $cur_dir;
	return $return;
}

