import sys

doubletSampleFile = sys.argv[1]
nCell = int(sys.argv[2])

## Process inferred doublets
cellDoubletSampleCount = [0]*nCell
totalSamples = 0
fds = open(doubletSampleFile)
for line in fds:
	row = line.rstrip().split(' ')
	totalSamples += 1
	for i in range(nCell):
		cellDoubletSampleCount[i] += int(row[i])

cellDoubletProb = [float(i)/totalSamples for i in cellDoubletSampleCount]
inferredDoublets = [i for i in range(nCell) if cellDoubletProb[i] >= 0.05]

inferredDoubletsSet = set(inferredDoublets)

inferredDoubletList = ['0']*nCell
for i in inferredDoublets:
	inferredDoubletList[i] = '1'
print ' '.join(inferredDoubletList)