import sys, numpy as np

clusterSampleFile = sys.argv[1]
genotypeSampleFile = sys.argv[2]
nCell = int(sys.argv[3])

## Get the cluster Samples
clusterSamples = []
fc = open(clusterSampleFile)
for line in fc:
	row = line.rstrip().split(' ')
	clustRow = [int(i) for i in row]
	clusterSamples.append(clustRow)

nSamples = len(clusterSamples)


## Get the genotype samples 
fg = open(genotypeSampleFile)
genotypeSamples = []
for line in fg:
	row = line.rstrip().split(',')
	cloneGenotypes = []
	for clone in row:
		cloneG = [int(i) for i in clone.split(' ')]
		nMut = len(cloneG)
		cloneGenotypes.append(cloneG)
	genotypeSamples.append(cloneGenotypes)

cellGenotypesPosteriorCount = np.zeros(shape=(nCell, nMut, 3))
for sampleID in range(nSamples):
	for j in range(nCell):
		# print sampleID, j
		cell_j = clusterSamples[sampleID][j]
		cellGenotype = genotypeSamples[sampleID][cell_j]
		for i in range(nMut):
			cell_j_i = cellGenotype[i]
			cellGenotypesPosteriorCount[j,i,cell_j_i] += 1

cellGenotypes = np.zeros(shape=(nMut, nCell))
for i in range(nMut):
	for j in range(nCell):
		best_i_j, bestGt_i_j = max((v, i) for i,v in enumerate(cellGenotypesPosteriorCount[j,i,:]))
		cellGenotypes[i,j] = bestGt_i_j

for i in range(nMut):
	mut = [str(i)]
	for j in range(nCell):
		mut.append(str(int(cellGenotypes[i][j])))
	mut_S = ' '.join(mut)
	print mut_S
